---
jupyter:
  jupytext:
    text_representation:
      extension: .md
      format_name: markdown
      format_version: '1.1'
      jupytext_version: 1.16.6
  kernelspec:
    display_name: Logtalk
    language: logtalk
    name: logtalk_kernel
---

<!--
________________________________________________________________________

This file is part of Logtalk <https://logtalk.org/>  
SPDX-FileCopyrightText: 1998-2025 Paulo Moura <pmoura@logtalk.org>  
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
________________________________________________________________________
-->

# encodings

This is a very simple example of using the new, experimental `encoding/1`
directive, which is fully based on the directive with the same name found 
on recent development releases of SWI-Prolog and YAP. Currently, this 
example requires Logtalk to be run with the latest versions of the CxProlog,
JIProlog, XVM, SICStus Prolog, SWI-Prolog, Tau Prolog, Trealla Prolog, or YAP
backends.

The following encodings are used in the source file:

- `mahjong.lgt`   - UTF-16 full (with a BOM)
- `asian.lgt`     - UTF-16 (with a BOM)
- `babel.lgt`     - UTF-8 (with a BOM)
- `latin.lgt`     - ISO-8859-1 (Latin 1)
- `mythology.lgt` - UTF-32 (with a BOM)

The `mahjong.lgt` source file requires full and up-to-date UTF-16 support
as it uses characters that are represented using surrogate pairs. Only XVM
provides the required support. Although CxProlog and SICStus Prolog claim
to support UTF-16, that support is outdated and don't include recently
added code points, notably that require surrogates.

As of the release date of this Logtalk version, only XVM, SICStus Prolog, and 
CxProlog support UTF-32 encodings. Attempting to compile the `mythology.lgt` 
source file with either YAP or SWI-Prolog results in a misleading syntax 
error.

JIProlog, Tau Prolog, and Trealla Prolog encoding is UTF-8. Therefore,
only the `babel.lgt` file can be used with these backends.

Be sure to use a text editor that supports these encodings when opening 
these files. In addition, you may need to configure your text editor to 
open the source file using the declared encoding. Be sure to use a font 
that supports Unicode characters (both for your text editor and for the 
shell running your Prolog compiler interpreter).

See the documentation of the Logtalk `encoding/1` directive for its possible 
arguments. The Prolog and XML files generated by the Logtalk compiler use 
the same encoding as the compiled source files.

Start by loading the example:

```logtalk
logtalk_load(encodings(loader)).
```

Query the table of "Hello world!" messages:

```logtalk
%%table
babel::hello_world(Code, Text).
```

<!--
Code = el, Text = 'Γειάσου κόσμος!' ;
Code = en, Text = 'Hello world!' ;
Code = es, Text = '¡Hola mundo!' ;
Code = ja, Text = 'こんにちは世界!' ;
Code = ko, Text = '여보세요 세계!' ;
Code = nl, Text = 'Hallo wereld!' ;
Code = pt, Text = 'Olá mundo!' ;
Code = ru, Text = 'Здравствулте! мир!' ;
Code = zh, Text = '你好世界!'.
-->

Query the table of names:

```logtalk
%%table
latin::name(Name).
```

<!--
Name = 'António Simões' ;
Name = 'Cátia Conceição' ;
Name = 'João Raínho' ;
Name = 'Luís Araújo'.
-->

Query the table of countries:

```logtalk
%%table
asian::country(Country, Name, Capital).
```

<!--
Name = '中国', Capital = '北京', Country = china ;
Name = '日本', Capital = '東京', Country = japan ;
Name = 'Монгол Улс', Capital = 'Улаанбатаар', Country = mongolia ? ;
Name = '臺灣', Capital = '臺北', Country = taiwan ;
Name = 'Тоҷикистон', Capital = 'Душанбе', Country = tajikistan.
-->

Query the table of greek mythology divinities:

```logtalk
%%table
mythology::divinity(English, Greek).
```

<!--
Greek = 'Ηρα', English = hera ? ;
Greek = 'Καλυψω', English = kalypso ? ;
Greek = 'Μορφευς', English = morpheus ? ;
Greek = 'Ποσειδων', English = poseidon ? ;
Greek = 'Ζευς', English = zeus.
-->
