/*
 * Copyright (C) 2014, 2016 Karl Wette
 * Copyright (C) 2009-2013 Adam Mercer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 */

/*
 * LALPulsarVCSInfo.h - LALPulsar VCS Information Header
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALPULSARVCSINFOHEADER_H
#define _LALPULSARVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALPulsarVCSInfo.h>
#include <lal/LALPulsarConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information */
#define LALPULSAR_VCS_ID "3b63370a45a6cc4b267c000149a922980f5de734"
#define LALPULSAR_VCS_DATE "2024-08-20 15:10:40 +0000"
#define LALPULSAR_VCS_BRANCH "None"
#define LALPULSAR_VCS_TAG "lalpulsar-v7.0.0a"
#define LALPULSAR_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALPULSAR_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALPULSAR_VCS_CLEAN "CLEAN"
#define LALPULSAR_VCS_STATUS "CLEAN: All modifications committed"

#if LALPULSAR_VERSION_DEVEL != 0
/* VCS header/library mismatch link check function */
#define LALPULSAR_VCS_LINK_CHECK LALPULSAR_CLEAN_3b63370a45a6cc4b267c000149a922980f5de734_VCS_HEADER_LIBRARY_MISMATCH
void LALPULSAR_VCS_LINK_CHECK(void);
#endif

#ifdef __cplusplus
}
#endif

#endif /* _LALPULSARVCSINFOHEADER_H */

/** \endcond */
