%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts %{nil}

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalmetaio
Version: 4.0.5
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
License: GPLv2+
Source0: https://software.igwn.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: help2man >= 1.37
BuildRequires: pkgconfig >= 0.18.0
BuildRequires: libmetaio-devel
BuildRequires: liblal-devel >= 7.6.0
BuildRequires: make

# swig
BuildRequires: swig >= 3.0.11

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-lal >= 7.6.0
BuildRequires: python%{python3_pkgversion}-numpy >= 1.7
BuildRequires: python%{python3_pkgversion}-pytest

# octave
BuildRequires: lal-octave >= 7.6.0
BuildRequires: octave-devel

# -- packages ---------------

#%%package -n lalmetaio
Summary: LVK Algorithm MetaIO Library - runtime tools
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}-%{name} = %{version}-%{release}
Obsoletes: python2-%{name} <= 2.0.2-1
%description
The LVK Algorithm MetaIO Library for gravitational wave data analysis.
This package provides the runtime tools.

# liblalmetaio
%package -n lib%{name}
Summary: LVK Algorithm MetaIO Library - library package
Requires: libmetaio >= 8.4.0
Requires: liblal >= 7.6.0
Conflicts: lalmetaio <= 2.0.0-1
%description -n lib%{name}
The LVK Algorithm MetaIO Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL MetaIO library.

# liblalmetaio-devel
%package -n lib%{name}-devel
Summary: Files and documentation needed for compiling programs that use LAL MetaIO
Requires: lib%{name} = %{version}
Requires: libmetaio-devel >= 8.4.0
Requires: liblal-devel >= 7.6.0
Provides: %{name}-devel = %{version}-%{release}
Obsoletes: %{name}-devel < 2.0.1-1
%description -n lib%{name}-devel
The LVK Algorithm MetaIO Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL MetaIO
library.

# python3x-lalmetaio
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} Bindings for LALMetaIO
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-lal >= 7.6.0
Requires: python%{python3_pkgversion}-numpy >= 1.7
Obsoletes: python2-%{name} < 2.0.3-1
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
The LVK Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python3_version} bindings for LALMetaIO.

# lalmetaio-octave
%package octave
Summary: Octave Bindings for LALMetaIO
Requires: lib%{name} = %{version}-%{release}
Requires: octave
Requires: lal-octave >= 7.6.0
%description octave
The LVK Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALMetaIO.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python3}
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post -n lib%{name} -p /sbin/ldconfig

%postun -n lib%{name} -p /sbin/ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files -n lib%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_libdir}/*.so.*

%files -n lib%{name}-devel
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalmetaio.oct*

%files
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_bindir}/*
%{_mandir}/man1/*
%{_sysconfdir}/*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jul 29 2024 Adam Mercer <adam.mercer@ligo.org> 4.0.5-1
- Update for 4.0.5

* Mon Mar 11 2024 Duncan Macleod <duncan.macleod@ligo.org> 4.0.4-1
- Update for 4.0.4

* Fri Oct 20 2023 Adam Mercer <adam.mercer@ligo.org> 4.0.3-1
- Update for 4.0.3

* Fri Oct 06 2023 Adam Mercer <adam.mercer@ligo.org> 4.0.2-1
- Update for 4.0.2

* Thu Apr 06 2023 Adam Mercer <adam.mercer@ligo.org> 4.0.1-1
- Update for 4.0.1

* Mon Feb 06 2023 Adam Mercer <adam.mercer@ligo.org< 4.0.0-1
- Update for 4.0.0

* Mon Sep 05 2022 Adam Mercer <adam.mercer@ligo.org> 3.0.2-1
- Update for 3.0.2

* Thu Aug 18 2022 Adam Mercer <adam.mercer@ligo.org> 3.0.1-1
- Update for 3.0.1

* Tue Aug 02 2022 Adam Mercer <adam.mercer@ligo.org> 3.0.0-1
- Update for 3.0.0

* Thu Mar 03 2022 Adam Mercer <adam.mercer@ligo.org> 2.1.2-1
- Update for 2.1.2

* Mon Jan 10 2022 Adam Mercer <adam.mercer@ligo.org> 2.1.1-1
- Update for 2.1.1

* Fri Dec 03 2021 Adam Mercer <adam.mercer@ligo.org> 2.1.0-1
- Update for 2.1.0

* Mon May 17 2021 Adam Mercer <adam.mercer@ligo.org> 2.0.3-1
- Update for 2.0.3

* Fri Feb 05 2021 Adam Mercer <adam.mercer@ligo.org> 2.0.2-1
- Update for 2.0.2

* Mon Jan 11 2021 Adam Mercer <adam.mercer@ligo.org> 2.0.1-1
- Update for 2.0.1

* Wed Oct 28 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.0-1
- Update for 2.0.0

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 1.6.1-1
- Update for 1.6.1

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.6.0-3
- Packaging updates

* Wed Dec 04 2019 Adam Mercer <adam.mercer@ligo.org> 1.6.0-2
- Packaging updates

* Fri Nov 22 2019 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- O3b release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.1-1
- O3 release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.0-1
- ER14 release

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.4.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.3.1-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.3.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.2.8-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.2.7-1
- Pre O2 packaging test release
