%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts %{nil}

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalinference
Version: 4.1.7
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
License: GPLv2+
Source0: https://software.igwn.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: help2man >= 1.37
BuildRequires: liblal-devel >= 7.6.0
BuildRequires: liblalframe-devel >= 3.0.0
BuildRequires: liblalmetaio-devel >= 4.0.0
BuildRequires: liblalsimulation-devel >= 6.0.0
BuildRequires: liblalburst-devel >= 2.0.0
BuildRequires: liblalinspiral-devel >= 5.0.0
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.11

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-astropy >= 1.1.1
BuildRequires: python%{python3_pkgversion}-gwdatafind
BuildRequires: python%{python3_pkgversion}-healpy >= 1.9.1
BuildRequires: python%{python3_pkgversion}-h5py
BuildRequires: python%{python3_pkgversion}-lal >= 7.6.0
BuildRequires: python%{python3_pkgversion}-lalframe >= 3.0.0
BuildRequires: python%{python3_pkgversion}-lalmetaio >= 4.0.0
BuildRequires: python%{python3_pkgversion}-lalsimulation >= 6.0.0
BuildRequires: python%{python3_pkgversion}-lalburst >= 2.0.0
BuildRequires: python%{python3_pkgversion}-lalinspiral >= 5.0.0
BuildRequires: python%{python3_pkgversion}-lscsoft-glue >= 1.54.1
BuildRequires: python%{python3_pkgversion}-matplotlib >= 1.2.0
BuildRequires: python%{python3_pkgversion}-numpy >= 1.7
BuildRequires: python%{python3_pkgversion}-pytest
BuildRequires: python%{python3_pkgversion}-scipy >= 0.9.0

# octave
BuildRequires: octave-devel
BuildRequires: lal-octave >= 7.6.0
BuildRequires: lalframe-octave >= 3.0.0
BuildRequires: lalmetaio-octave >= 4.0.0
BuildRequires: lalsimulation-octave >= 6.0.0
BuildRequires: lalburst-octave >= 2.0.0
BuildRequires: lalinspiral-octave >= 5.0.0

# -- packages ---------------

# lalinference
Summary: LVK Algorithm Inference Library - runtime tools
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}-%{name} = %{version}-%{release}
Requires: %{name}-data
Obsoletes: python2-%{name} <= 2.0.7-1
%description
The LVK Algorithm Inference Library for gravitational wave data analysis.

# lalinference-data
%package data
BuildArch: noarch
Summary: Data files for LALInference
%description data
The LVK Algorithm Inference Library for gravitational wave data analysis.
This package contains the data files needed to run various applications
and rountines that use the LAL Inference library.

# liblalinference
%package -n lib%{name}
Summary: LVK Algorithm Inference Library - library package
Requires: gsl >= 1.15
Requires: openssh-clients
Requires: liblal >= 7.6.0
Requires: liblalframe >= 3.0.0
Requires: liblalmetaio >= 4.0.0
Requires: liblalsimulation >= 6.0.0
Requires: liblalburst >= 2.0.0
Requires: liblalinspiral >= 5.0.0
Requires: %{name}-data
Conflicts: %{name} <= 2.0.5-1
%description -n lib%{name}
The LVK Algorithm Inference Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Inference library.

# liblalinference-devel
%package -n lib%{name}-devel
Summary: Files and documentation needed for compiling programs that use LAL Inference
Requires: gsl-devel >= 1.15
Requires: lib%{name} = %{version}-%{release}
Requires: liblal-devel >= 7.6.0
Requires: liblalframe-devel >= 3.0.0
Requires: liblalmetaio-devel >= 4.0.0
Requires: liblalsimulation-devel >= 6.0.0
Requires: liblalburst-devel >= 2.0.0
Requires: liblalinspiral-devel >= 5.0.0
Provides: %{name}-devel = %{version}-%{release}
Obsoletes: %{name}-devel < 2.0.6-1
%description -n lib%{name}-devel
The LVK Algorithm Inference Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inference
library.

# python3x-lalinference
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} Bindings for LALInference
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-astropy >= 1.1.1
Requires: python%{python3_pkgversion}-gwdatafind
Requires: python%{python3_pkgversion}-healpy >= 1.9.1
Requires: python%{python3_pkgversion}-h5py
Requires: python%{python3_pkgversion}-lal >= 7.6.0
Requires: python%{python3_pkgversion}-lalframe >= 3.0.0
Requires: python%{python3_pkgversion}-lalmetaio >= 4.0.0
Requires: python%{python3_pkgversion}-lalsimulation >= 6.0.0
Requires: python%{python3_pkgversion}-lalburst >= 2.0.0
Requires: python%{python3_pkgversion}-lalinspiral >= 5.0.0
Requires: python%{python3_pkgversion}-ligo-gracedb
Requires: python%{python3_pkgversion}-ligo-lw >= 1.7.0
Requires: python%{python3_pkgversion}-ligo-segments
Requires: python%{python3_pkgversion}-lscsoft-glue >= 1.54.1
Requires: python%{python3_pkgversion}-matplotlib >= 1.2.0
Requires: python%{python3_pkgversion}-numpy >= 1.7
Requires: python%{python3_pkgversion}-scipy >= 0.8
Obsoletes: python2-%{name} < 3.1.0-1
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
The LVK Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python3_version} bindings for LALInference.

# lalinference-octave
%package octave
Summary: Octave Bindings for LALInference
Requires: lib%{name} = %{version}-%{release}
Requires: octave
Requires: lal-octave >= 7.6.0
Requires: lalframe-octave >= 3.0.0
Requires: lalmetaio-octave >= 4.0.0
Requires: lalsimulation-octave >= 6.0.0
Requires: lalburst-octave >= 2.0.0
Requires: lalinspiral-octave >= 5.0.0
%description octave
The LVK Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALInference.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python3}
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post -n lib%{name} -p /sbin/ldconfig

%postun -n lib%{name} -p /sbin/ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files data
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_datarootdir}/%{name}/*

%files -n lib%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_libdir}/*.so.*

%files -n lib%{name}-devel
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalinference.oct*

%files
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_bindir}/*
%{_mandir}/man1/*
%{_sysconfdir}/*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jul 29 2024 Adam Mercer <adam.mercer@ligo.org> 4.1.7-1
- Update for 4.1.7

* Mon Mar 11 2024 Duncan Macleod <duncan.macleod@ligo.org> 4.1.6-1
- Update for 4.1.6

* Fri Oct 20 2023 Adam Mercer <adam.mercer@ligo.org> 4.1.5-1
- Update for 4.1.5

* Fri Oct 06 2023 Adam Mercer <adam.mercer@ligo.org> 4.1.4-1
- Update for 4.1.4

* Thu Apr 06 2023 Adam Mercer <adam.mercer@ligo.org> 4.1.3-1
- Update for 4.1.3

* Mon Feb 06 2023 Adam Mercer <adam.mercer@ligo.org> 4.1.2-1
- Update for 4.1.2

* Mon Sep 05 2022 Adam Mercer <adam.mercer@ligo.org> 4.1.1-1
- Update for 4.1.1

* Thu Aug 18 2022 Adam Mercer <adam.mercer@ligo.org> 4.1.0-1
- Update for 4.1.0

* Tue Aug 02 2022 Adam Mercer <adam.mercer@ligo.org> 4.0.0-1
- Update for 4.0.0

* Thu Mar 03 2022 Adam Mercer <adam.mercer@ligo.org> 3.0.3-2
- Update for 3.0.3

* Mon Jan 10 2022 Adam Mercer <adam.mercer@ligo.org> 3.0.2-1
- Update for 3.0.2

* Fri Dec 03 2021 Adam Mercer <adam.mercer@ligo.org> 3.0.1-1
- Update for 3.0.1

* Mon May 17 2021 Adam Mercer <adam.mercer@ligo.org> 3.0.0-1
- Update for 3.0.0

* Fri Feb 05 2021 Adam Mercer <adam.mercer@ligo.org> 2.0.7-1
- Update for 2.0.7

* Mon Jan 11 2021 Adam Mercer <adam.mercer@ligo.org> 2.0.6-1
- Update updates 2.0.6

* Wed Oct 28 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.5-1
- Update for 2.0.5

* Thu Oct 01 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.4-1
- Update to 2.0.4

* Wed Aug 05 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.3-1
- Update for 2.0.3

* Wed Jul 08 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.2-1
- Update for 2.0.2

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.1-1
- Update for 2.0.1

* Wed Mar 25 2020 Duncan Macleod <duncan.macleod@ligo.org> 2.0.0-1
- Update for 2.0.0

* Fri Feb 21 2020 Adam Mercer <adam.mercer@ligo.org> 1.11.7-1
- O3b point release

* Thu Feb 13 2020 Adam Mercer <adam.mercer@ligo.org> 1.11.6-2
- O3b point release

* Tue Dec 17 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.5-1
- O3b point release

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.4-2
- Packaging updates

* Wed Nov 27 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.4-1
- O3b release

* Thu Jul 18 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.3-1
- O3 point release

* Thu Jul 11 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.2-1
- O3 point release

* Fri Jun 21 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.1-1
- O3 point release

* Tue May 21 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.0-1
- O3 point release

* Wed May 01 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.3-1
- O3 point release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.2-1
- ER14 release

* Tue Jan 22 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.1-1
- Fix spin2 prior

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.10.0-1
- Pre O3 release

* Thu Jul 27 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.4-1
- bayestar_plot_volume: work around broken fonts in SL7

* Wed Jul 26 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.3-1
- BAYESTAR and sky map post-processing updates

* Thu Mar 16 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.2-1
- lalinference.io.fits: remove some redundant keys on reading
- lalinference.io.fits: fix writing single-column sky maps

* Sat Feb 18 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.1-1
- Do not use $(..._la_LIBADD) to link against external libraries
- Track version info API change
- Fix to weights calculation so that posterior samples are now drawn correctly
- Fix incorrect axes limits for Mollweide sky maps
- Drop code for reading past EOF of named pipe
- Fix incorrect reordering of IDL-compatible sky maps
- Tune default max distance for volume rendering plots

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.0-1
- O2 release

* Thu Dec 15 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.2-1
- Be more emphatic about switching matplotlib backend
- Prevent trying to build python3 packages when unsupported

* Fri Dec 09 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.1-1
- Explicitly set no-op Matplotlib backend
- Set matplotlib backend to no-op

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- Pre O2 packaging test release
