%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts %{nil}

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalframe
Version: 3.0.5
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
License: GPLv2+
Source0: https://software.igwn.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: help2man >= 1.37
BuildRequires: ldas-tools-framecpp-c-devel >= 2.5.5
BuildRequires: ldas-tools-framecpp-c-devel < 3.0.0
BuildRequires: libframel-devel >= 8.39.2
BuildRequires: libframel-devel < 9.0.0
BuildRequires: liblal-devel >= 7.6.0
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.11

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-numpy >= 1.7
BuildRequires: python%{python3_pkgversion}-lal >= 7.6.0
BuildRequires: python%{python3_pkgversion}-pytest

# octave
BuildRequires: octave-devel
BuildRequires: lal-octave >= 7.6.0

# -- packages ---------------

#%%package -n lalframe
Summary: LVK Algorithm Frame Library - runtime tools
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}-%{name} = %{version}-%{release}
Obsoletes: python2-%{name} <= 1.5.4-1
%description
The LVK Algorithm Frame Library for gravitational wave data analysis.
This package provides the runtime tools.

# liblalframe
%package -n lib%{name}
Summary: LVK Algorithm Frame Library - library package
Requires: ldas-tools-framecpp-c >= 2.5.5
Requires: libframel >= 8.39.2
Requires: liblal >= 7.6.0
Conflicts: lalframe <= 1.5.2-1
%description -n lib%{name}
The LVK Algorithm Frame Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Frame library.

# liblalframe-devel
%package -n lib%{name}-devel
Summary: Files and documentation needed for compiling programs that use LAL Frame
Requires: lib%{name} = %{version}-%{release}
Requires: ldas-tools-framecpp-c-devel >= 2.5.5
Requires: libframel-devel >= 8.39.2
Requires: liblal-devel >= 7.6.0
Provides: %{name}-devel = %{version}-%{release}
Obsoletes: %{name}-devel < 1.5.3-1
%description -n lib%{name}-devel
The LVK Algorithm Frame Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Frame
library.

# python3x-lalframe
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} Bindings for LALFrame
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-lal >= 7.6.0
Requires: python%{python3_pkgversion}-numpy >= 1.7
Obsoletes: python2-%{name} < 1.5.5-1
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
The LVK Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python3_version} bindings for LALFrame.

# lalframe-octave
%package octave
Summary: Octave Bindings for LALFrame
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 7.6.0
%description octave
The LVK Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALFrame.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python3}
%{__make} %{?_smp_mflags} V=1

%check
# C + python3 + octave
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post -n lib%{name} -p /sbin/ldconfig

%postun -n lib%{name} -p /sbin/ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files -n lib%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_libdir}/*.so.*

%files -n lib%{name}-devel
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalframe.oct*

%files
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_bindir}/*
%{_mandir}/man1/*
%{_sysconfdir}/*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jul 29 2024 Adam Mercer <adam.mercer@ligo.org> 3.0.5-1
- Update for 3.0.5

* Mon Mar 11 2024 Duncan Macleod <duncan.macleod@ligo.org> 3.0.4-1
- Update for 3.0.4

* Fri Oct 20 2023 Adam Mercer <adam.mercer@ligo.org> 3.0.3-1
- Update for 3.0.3

* Fri Oct 06 2023 Adam Mercer <adam.mercer@ligo.org> 3.0.2-1
- Update for 3.0.2

* Thu Apr 06 2023 Adam Mercer <adam.mercer@ligo.org> 3.0.1-1
- Update for 3.0.1

* Mon Feb 06 2023 Adam Mercer <adam.mercer@ligo.org> 3.0.0-1
- Update for 3.0.0

* Mon Sep 05 2022 Adam Mercer <adam.mercer@ligo.org> 2.0.3-1
- Update for 2.0.3

* Thu Aug 18 2022 Adam Mercer <adam.mercer@ligo.org> 2.0.2-1
- Update for 2.0.2

* Tue Aug 02 2022 Adam Mercer <adam.mercer@ligo.org> 2.0.1-1
- Update for 2.0.1

* Thu Mar 03 2022 Adam Mercer <adam.mercer@ligo.org> 2.0.0-1
- Update for 2.0.0

* Mon Jan 10 2022 Adam Mercer <adam.mercer@ligo.org> 1.6.1-1
- Update for 1.6.1

* Fri Dec 03 2021 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- Update for 1.6.0

* Mon May 17 2021 Adam Mercer <adam.mercer@ligo.org> 1.5.5-1
- Update for 1.5.5

* Fri Feb 05 2021 Adam Mercer <adam.mercer@ligo.org> 1.5.4-1
- Update for 1.5.4

* Mon Jan 11 2021 Adam Mercer <adam.mercer@ligo.org> 1.5.3-1
- Update for 1.5.3

* Tue Oct 27 2020 Adam Mercer <adam.mercer@ligo.org> 1.5.2-1
- Update for 1.5.2

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 1.5.1-1
- Update for 1.5.1

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.0-4
- Packaging updates

* Wed Dec 04 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.0-3
- Packaging updates

* Wed Dec 04 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.0-2
- Add missing dependency on python2-mock

* Fri Nov 22 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.0-1
- O3b release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.4.5-1
- O3 release

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.4.4-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.4.3-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.4.2-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.4.1-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.4.0-1
- Pre O2 packaging test release
