/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.runner.ExpressionRunner;
import org.jetbrains.kotlin.runner.FindCompilerKt;
import org.jetbrains.kotlin.runner.JarRunner;
import org.jetbrains.kotlin.runner.Main;
import org.jetbrains.kotlin.runner.MainClassRunner;
import org.jetbrains.kotlin.runner.ReplRunner;
import org.jetbrains.kotlin.runner.Runner;
import org.jetbrains.kotlin.runner.RunnerException;
import org.jetbrains.kotlin.runner.RunnerWithCompiler;
import org.jetbrains.kotlin.runner.ScriptRunner;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u001b\u0010\u0010\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007\u00a2\u0006\u0002\u0010\u000bJ!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\tH\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0007H\u0002J\b\u0010\u0016\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/runner/Main;", "", "<init>", "()V", "KOTLIN_HOME", "Ljava/io/File;", "run", "", "args", "", "", "([Ljava/lang/String;)V", "addPath", "", "Ljava/net/URL;", "path", "main", "sanitizeStackTrace", "Ljava/lang/StackTraceElement;", "trace", "([Ljava/lang/StackTraceElement;)[Ljava/lang/StackTraceElement;", "printUsageAndExit", "printVersionAndExit", "HowToRun", "kotlin-runner"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\norg/jetbrains/kotlin/runner/Main\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,263:1\n777#2:264\n873#2,2:265\n777#2:267\n873#2,2:268\n1915#2,2:270\n3650#3,6:272\n37#4,2:278\n*S KotlinDebug\n*F\n+ 1 Main.kt\norg/jetbrains/kotlin/runner/Main\n*L\n82#1:264\n82#1:265,2\n87#1:267\n87#1:268,2\n183#1:270,2\n211#1:272,6\n217#1:278,2\n*E\n"})
public final class Main {
    @NotNull
    public static final Main INSTANCE = new Main();
    @NotNull
    private static final File KOTLIN_HOME;

    private Main() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void run(String[] args) {
        classpath = new ArrayList<E>();
        compilerClasspath = new ArrayList<URL>();
        runner = new Ref.ObjectRef<Runner>();
        arguments = new ArrayList<String>();
        compilerArguments = new ArrayList<String>();
        noStdLib = false;
        noReflect = false;
        howtorun = HowToRun.GUESS;
        i = new Ref.IntRef();
        while (i.element < args.length) {
            block24: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                block23: {
                                                    arg = args[i.element];
                                                    if (!Intrinsics.areEqual("-help", arg) && !Intrinsics.areEqual("-h", arg)) break block23;
                                                    this.printUsageAndExit();
                                                    break block24;
                                                }
                                                if (!Intrinsics.areEqual("-version", arg)) break block25;
                                                this.printVersionAndExit();
                                                break block24;
                                            }
                                            if (!Intrinsics.areEqual("-classpath", arg) && !Intrinsics.areEqual("-cp", arg)) break block26;
                                            v0 = Main.run$next(i, args, arg);
                                            var13_18 = new String[1];
                                            Intrinsics.checkNotNullExpressionValue(File.pathSeparator, "pathSeparator");
                                            $this$filter$iv = StringsKt.split$default(v0, var13_18, false, 0, 6, null);
                                            $i$f$filter = false;
                                            var15_23 = $this$filter$iv;
                                            destination$iv$iv = new ArrayList<E>();
                                            $i$f$filterTo = false;
                                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                                p0 = (String)element$iv$iv;
                                                $i$a$-filter-Main$run$1 = false;
                                                v1 = ((CharSequence)p0).length() > 0;
                                                if (!v1) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            for (String[] path : (List)destination$iv$iv) {
                                                this.addPath((List<URL>)classpath, (String)path /* !! */ );
                                            }
                                            break block24;
                                        }
                                        if (!Intrinsics.areEqual("-compiler-path", arg)) break block27;
                                        v2 = Main.run$next(i, args, arg);
                                        path /* !! */  = new String[1];
                                        Intrinsics.checkNotNullExpressionValue(File.pathSeparator, "pathSeparator");
                                        $this$filter$iv = StringsKt.split$default(v2, path /* !! */ , false, 0, 6, null);
                                        $i$f$filter = false;
                                        $this$filterTo$iv$iv = $this$filter$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            p0 = (String)element$iv$iv;
                                            $i$a$-filter-Main$run$2 = false;
                                            v3 = ((CharSequence)p0).length() > 0;
                                            if (!v3) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        for (String[] path : (List)destination$iv$iv) {
                                            this.addPath((List<URL>)compilerClasspath, (String)path /* !! */ );
                                        }
                                        break block24;
                                    }
                                    if (!Intrinsics.areEqual("-howtorun", arg)) break block28;
                                    if (howtorun != HowToRun.GUESS) {
                                        throw new RunnerException("-howtorun is already set to " + howtorun.getArgName(), null, 2, null);
                                    }
                                    howToRunArg = Main.run$next(i, args, arg);
                                    if (StringsKt.startsWith$default(howToRunArg, ".", false, 2, null)) {
                                        howtorun = HowToRun.SCRIPT;
                                        compilerArguments.add("-Xdefault-script-extension=" + howToRunArg);
                                    } else if (HowToRun.Companion.fromArg(howToRunArg) == null) {
                                        throw new RunnerException("invalid argument to the option -howtorun " + howToRunArg + ", valid arguments are: " + HowToRun.Companion.getValidValues(), null, 2, null);
                                    }
                                    break block24;
                                }
                                if (Intrinsics.areEqual("-expression", arg) || Intrinsics.areEqual("-e", arg)) {
                                    if (howtorun != HowToRun.GUESS && howtorun != HowToRun.SCRIPT) {
                                        throw new RunnerException("expression evaluation is not compatible with -howtorun argument " + howtorun.getArgName(), null, 2, null);
                                    }
                                    Main.run$setRunner(runner, new ExpressionRunner(Main.run$next(i, args, arg)));
                                    Main.run$restAsArguments(arguments, args, i);
                                    break;
                                }
                                if (Intrinsics.areEqual("-repl", arg) || Intrinsics.areEqual("-Xrepl", arg)) {
                                    Main.run$setRunner(runner, new ReplRunner());
                                    compilerArguments.add("-Xrepl");
                                    break;
                                }
                                if (!Intrinsics.areEqual("-no-stdlib", arg)) break block29;
                                noStdLib = true;
                                compilerArguments.add(arg);
                                break block24;
                            }
                            if (!Intrinsics.areEqual("-no-reflect", arg)) break block30;
                            noReflect = true;
                            compilerArguments.add(arg);
                            break block24;
                        }
                        if (!StringsKt.startsWith$default(arg, "-X", false, 2, null)) break block31;
                        compilerArguments.add(arg);
                        break block24;
                    }
                    if (Intrinsics.areEqual("-language-version", arg)) break block32;
                    if (StringsKt.startsWith$default(arg, "-", false, 2, null)) {
                        throw new RunnerException("unknown option: " + arg, null, 2, null);
                    }
                    if (howtorun == HowToRun.JAR || howtorun == HowToRun.GUESS && StringsKt.endsWith$default(arg, ".jar", false, 2, null)) {
                        Main.run$setRunner(runner, new JarRunner(arg));
                        Main.run$restAsArguments(arguments, args, i);
                        break;
                    }
                    if (howtorun == HowToRun.SCRIPT || howtorun == HowToRun.GUESS && StringsKt.endsWith$default(arg, ".kts", false, 2, null)) {
                        Main.run$setRunner(runner, new ScriptRunner(arg));
                        Main.run$restAsArguments(arguments, args, i);
                        break;
                    }
                    workingDir = new File(".");
                    classFile = new File(arg);
                    if (!StringsKt.endsWith$default(arg, ".class", false, 2, null) || !classFile.exists()) ** GOTO lbl-1000
                    v4 = classFile.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue(v4, "getCanonicalPath(...)");
                    v5 = v4;
                    v6 = workingDir.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue(v6, "getCanonicalPath(...)");
                    if (StringsKt.contains$default(v5, v6, false, 2, null)) {
                        v7 = classFile.getCanonicalFile();
                        Intrinsics.checkNotNullExpressionValue(v7, "getCanonicalFile(...)");
                        v8 = workingDir.getCanonicalFile();
                        Intrinsics.checkNotNullExpressionValue(v8, "getCanonicalFile(...)");
                        v9 = StringsKt.replace$default(StringsKt.removeSuffix(FilesKt.toRelativeString(v7, v8), (CharSequence)".class"), File.separatorChar, '.', false, 4, null);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v9 = arg;
                    }
                    className = v9;
                    Main.run$setRunner(runner, new MainClassRunner(className));
                    Main.run$restAsArguments(arguments, args, i);
                    break;
                }
                compilerArguments.add(arg);
                compilerArguments.add(Main.run$next(i, args, arg));
            }
            workingDir = i.element;
            i.element = workingDir + 1;
        }
        if (classpath.isEmpty()) {
            this.addPath((List<URL>)classpath, ".");
        }
        if (!noStdLib) {
            this.addPath((List<URL>)classpath, Main.KOTLIN_HOME + "/lib/kotlin-stdlib.jar");
        }
        if (!noReflect) {
            this.addPath((List<URL>)classpath, Main.KOTLIN_HOME + "/lib/kotlin-reflect.jar");
        }
        if (runner.element == null) {
            Main.run$setRunner(runner, new ReplRunner());
        }
        if (runner.element instanceof RunnerWithCompiler && compilerClasspath.isEmpty()) {
            $this$forEach$iv = FindCompilerKt.findCompilerJar(this.getClass(), FilesKt.resolve(Main.KOTLIN_HOME, "lib"));
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                $i$a$-forEach-Main$run$3 = false;
                compilerClasspath.add(it.getAbsoluteFile().toURI().toURL());
            }
        }
        v10 = runner.element;
        Intrinsics.checkNotNull(v10);
        ((Runner)v10).run((List<URL>)classpath, (List<String>)compilerArguments, (List<String>)arguments, (List<URL>)compilerClasspath);
    }

    private final void addPath(List<URL> $this$addPath, String path) {
        URL uRL = new File(path).getAbsoluteFile().toURI().toURL();
        Intrinsics.checkNotNullExpressionValue(uRL, "toURL(...)");
        $this$addPath.add(uRL);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter(args, "args");
        try {
            INSTANCE.run(args);
        }
        catch (RunnerException e) {
            System.err.println("error: " + e.getMessage());
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (Throwable e) {
            Iterator<Throwable> iterator2 = SequencesKt.generateSequence(e, (Function1)main.1.INSTANCE).iterator();
            while (iterator2.hasNext()) {
                Throwable exception = iterator2.next();
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "getStackTrace(...)");
                exception.setStackTrace(INSTANCE.sanitizeStackTrace(stackTraceElementArray));
            }
            throw e;
        }
    }

    private final StackTraceElement[] sanitizeStackTrace(StackTraceElement[] trace) {
        List<Object> list;
        block1: {
            StackTraceElement[] $this$dropLastWhile$iv = trace;
            boolean $i$f$dropLastWhile = false;
            for (int index$iv = ArraysKt.getLastIndex($this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                StackTraceElement it = $this$dropLastWhile$iv[index$iv];
                boolean bl = false;
                String name = it.getClassName();
                Intrinsics.checkNotNull(name);
                if (StringsKt.startsWith$default(name, "org.jetbrains.kotlin.runner.", false, 2, null) || StringsKt.startsWith$default(name, "java.lang.reflect.", false, 2, null) || StringsKt.startsWith$default(name, "sun.reflect.", false, 2, null) || StringsKt.startsWith$default(name, "jdk.internal.reflect.", false, 2, null)) continue;
                list = ArraysKt.take($this$dropLastWhile$iv, index$iv + 1);
                break block1;
            }
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new StackTraceElement[0]);
    }

    private final void printUsageAndExit() {
        System.out.println((Object)("kotlin: run Kotlin programs, scripts or REPL.\n\nUsage: kotlin <options> <command> [<arguments>]\nwhere possible options include:\n  -howtorun <value>          How to run the supplied command with arguments, \n                             valid values: " + HowToRun.Companion.getValidValues() + "\n  -classpath (-cp) <path>    Paths where to find user class files\n  -Dname=value               Set a system JVM property\n  -J<option>                 Pass an option directly to JVM\n  -no-stdlib                 Don't include Kotlin standard library into classpath\n  -no-reflect                Don't include Kotlin reflection implementation into classpath\n  -compiler-path             Kotlin compiler classpath for compiling script or expression or running REPL \n                             If not specified, try to find the compiler in the environment\n  -X<flag>[=value]           Pass -X argument to the compiler\n  -version                   Display Kotlin version\n  -help (-h)                 Print a synopsis of options\nand command is interpreted according to the -howtorun option argument \nor, in case of guess, according to the following rules:\n  foo.Bar                    Runs the 'main' function from the class with the given qualified name\n                             (compiler arguments are ignored) \n  app.jar                    Runs the given JAR file as 'java -jar' would do\n                             (compiler arguments are ignored and no Kotlin stdlib is added to the classpath)\n  script.kts                 Compiles and runs the given script, passing <arguments> to it\n  -expression (-e) '2+2'     Evaluates the expression and prints the result, passing <arguments> to it\n  -repl                      Runs Kotlin REPL\narguments are passed to the main function when running class or jar file, and for standard script definitions\nas the 'args' parameter when running script or expression\n"));
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void printVersionAndExit() {
        String string;
        try {
            string = new Scanner(new File(KOTLIN_HOME, "build.txt")).nextLine();
        }
        catch (FileNotFoundException e) {
            throw new RunnerException("no build.txt was found at home=" + KOTLIN_HOME, null, 2, null);
        }
        String version = string;
        System.out.println((Object)("Kotlin version " + version + " (JRE " + System.getProperty("java.runtime.version") + ')'));
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void run$setRunner(Ref.ObjectRef<Runner> runner, Runner newRunner) {
        if (runner.element != null) {
            throw new AssertionError((Object)"conflicting runner settings");
        }
        runner.element = newRunner;
    }

    private static final String run$next(Ref.IntRef i, String[] $args, String arg) {
        ++i.element;
        if (i.element == $args.length) {
            throw new RunnerException("argument expected to " + arg, null, 2, null);
        }
        return $args[i.element];
    }

    private static final void run$restAsArguments(ArrayList<String> arguments, String[] $args, Ref.IntRef i) {
        CollectionsKt.addAll((Collection)arguments, ArraysKt.copyOfRange($args, i.element + 1, $args.length));
    }

    static {
        String home = System.getProperty("kotlin.home");
        if (home == null) {
            System.err.println("error: no kotlin.home system property was passed");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        KOTLIN_HOME = new File(home);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/runner/Main$HowToRun;", "", "argName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getArgName", "()Ljava/lang/String;", "GUESS", "CLASSFILE", "JAR", "SCRIPT", "Companion", "kotlin-runner"})
    public static final class HowToRun
    extends Enum<HowToRun> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String argName;
        @NotNull
        private static final String validValues;
        public static final /* enum */ HowToRun GUESS;
        public static final /* enum */ HowToRun CLASSFILE;
        public static final /* enum */ HowToRun JAR;
        public static final /* enum */ HowToRun SCRIPT;
        private static final /* synthetic */ HowToRun[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private HowToRun(String argName) {
            this.argName = argName;
        }

        @NotNull
        public final String getArgName() {
            return this.argName;
        }

        public static HowToRun[] values() {
            return (HowToRun[])$VALUES.clone();
        }

        public static HowToRun valueOf(String value) {
            return Enum.valueOf(HowToRun.class, value);
        }

        @NotNull
        public static EnumEntries<HowToRun> getEntries() {
            return $ENTRIES;
        }

        static {
            GUESS = new HowToRun("guess");
            CLASSFILE = new HowToRun("classfile");
            JAR = new HowToRun("jar");
            SCRIPT = new HowToRun("script");
            $VALUES = howToRunArray = new HowToRun[]{HowToRun.GUESS, HowToRun.CLASSFILE, HowToRun.JAR, HowToRun.SCRIPT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            validValues = HowToRun.GUESS.argName + " (default), " + HowToRun.CLASSFILE.argName + ", " + HowToRun.JAR.argName + ", " + HowToRun.SCRIPT.argName + " (or .<script filename extension>)";
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/runner/Main$HowToRun$Companion;", "", "<init>", "()V", "validValues", "", "getValidValues", "()Ljava/lang/String;", "fromArg", "Lorg/jetbrains/kotlin/runner/Main$HowToRun;", "name", "kotlin-runner"})
        @SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\norg/jetbrains/kotlin/runner/Main$HowToRun$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1#2:264\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getValidValues() {
                return validValues;
            }

            @Nullable
            public final HowToRun fromArg(@NotNull String name) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    Iterable iterable = HowToRun.getEntries();
                    for (Object t : iterable) {
                        HowToRun it = (HowToRun)((Object)t);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getArgName(), name)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

