/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.BackupClassPathResolver;
import org.javacs.kt.classpath.CachedClassPathResolver;
import org.javacs.kt.classpath.ClassPathResolver;
import org.javacs.kt.classpath.ClassPathResolverKt;
import org.javacs.kt.classpath.GradleClassPathResolver;
import org.javacs.kt.classpath.MavenClassPathResolver;
import org.javacs.kt.classpath.ShellClassPathResolver;
import org.javacs.kt.classpath.WithStdlibResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002\u001a$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0004H\u0002\u00a8\u0006\u0013"}, d2={"defaultClassPathResolver", "Lorg/javacs/kt/classpath/ClassPathResolver;", "workspaceRoots", "", "Ljava/nio/file/Path;", "db", "Lorg/jetbrains/exposed/sql/Database;", "workspaceResolvers", "Lkotlin/sequences/Sequence;", "workspaceRoot", "folderResolvers", "root", "ignored", "", "Ljava/nio/file/PathMatcher;", "ignoredPathPatterns", "gitignore", "asClassPathProvider", "path", "shared"})
@SourceDebugExtension(value={"SMAP\nDefaultClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultClassPathResolver.kt\norg/javacs/kt/classpath/DefaultClassPathResolverKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n1#2:81\n1557#3:60\n1628#3,3:61\n774#3:64\n865#3,2:65\n1557#3:67\n1628#3,3:68\n1611#3,9:71\n1863#3:80\n1864#3:82\n1620#3:83\n2632#3,3:84\n*S KotlinDebug\n*F\n+ 1 DefaultClassPathResolver.kt\norg/javacs/kt/classpath/DefaultClassPathResolverKt\n*L\n44#1:81\n37#1:60\n37#1:61,3\n38#1:64\n38#1:65,2\n39#1:67\n39#1:68,3\n44#1:71,9\n44#1:80\n44#1:82\n44#1:83\n28#1:84,3\n*E\n"})
public final class DefaultClassPathResolverKt {
    @NotNull
    public static final ClassPathResolver defaultClassPathResolver(@NotNull Collection<? extends Path> workspaceRoots, @Nullable Database db) {
        ClassPathResolver classPathResolver;
        Intrinsics.checkNotNullParameter(workspaceRoots, (String)"workspaceRoots");
        ClassPathResolver childResolver = ClassPathResolverKt.or(new WithStdlibResolver(ClassPathResolverKt.or(ShellClassPathResolver.Companion.global((Path)CollectionsKt.firstOrNull((Iterable)workspaceRoots)), ClassPathResolverKt.getJoined((Sequence<? extends ClassPathResolver>)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)workspaceRoots), DefaultClassPathResolverKt::defaultClassPathResolver$lambda$0)))), BackupClassPathResolver.INSTANCE);
        Database database = db;
        if (database != null) {
            Database it = database;
            boolean bl = false;
            classPathResolver = new CachedClassPathResolver(childResolver, it);
        } else {
            classPathResolver = childResolver;
        }
        return classPathResolver;
    }

    public static /* synthetic */ ClassPathResolver defaultClassPathResolver$default(Collection collection, Database database, int n, Object object) {
        if ((n & 2) != 0) {
            database = null;
        }
        return DefaultClassPathResolverKt.defaultClassPathResolver(collection, database);
    }

    private static final Sequence<ClassPathResolver> workspaceResolvers(Path workspaceRoot) {
        Path path = workspaceRoot.resolve(".gitignore");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        List<PathMatcher> ignored = DefaultClassPathResolverKt.ignoredPathPatterns(workspaceRoot, path);
        return CollectionsKt.asSequence((Iterable)DefaultClassPathResolverKt.folderResolvers(workspaceRoot, ignored));
    }

    private static final Collection<ClassPathResolver> folderResolvers(Path root, List<? extends PathMatcher> ignored) {
        File file = root.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null).onEnter(arg_0 -> DefaultClassPathResolverKt.folderResolvers$lambda$3(ignored, arg_0))), DefaultClassPathResolverKt::folderResolvers$lambda$4));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final List<PathMatcher> ignoredPathPatterns(Path root, Path gitignore) {
        List list;
        File file;
        Object object = gitignore.toFile();
        File it = object;
        boolean bl2 = false;
        File file2 = file = it.exists() ? object : null;
        if (file != null && (object = FilesKt.readLines$default((File)file, null, (int)1, null)) != null) {
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Collection collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv2;
            Iterable bl2 = (Iterable)object;
            boolean $i$f$map22 = false;
            void var7_9 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean bl3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it2))).toString());
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$filter22 = false;
            destination$iv$iv = $this$filter$iv;
            Collection collection2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it3 = (String)element$iv$iv;
                boolean bl5 = false;
                if (!(((CharSequence)it3).length() > 0 && !StringsKt.startsWith$default((String)it3, (String)"#", (boolean)false, (int)2, null))) continue;
                collection2.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)collection2;
            boolean $i$f$map = false;
            void var9_16 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : var9_16) {
                void it4;
                String bl5 = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl6 = false;
                collection.add(StringsKt.removeSuffix((String)it4, (CharSequence)"/"));
            }
            List list2 = (List)destination$iv$iv2;
            boolean bl7 = false;
            List list3 = CollectionsKt.plus((Collection)list2, (Iterable)CollectionsKt.listOf((Object)".git"));
            if (list3 != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable iterable = list3;
                boolean $i$f$mapNotNull = false;
                Iterable $i$f$mapTo2 = iterable;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it$iv$iv;
                    void var22_42;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl8 = false;
                    String it5 = (String)element$iv$iv;
                    boolean bl9 = false;
                    try {
                        Object[] objectArray = new Object[]{it5, gitignore};
                        LoggerKt.getLOG().debug("Adding ignore pattern '{}' from {}", objectArray);
                        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + root + "**/" + it5);
                    }
                    catch (Exception e) {
                        Object[] objectArray = new Object[]{it5, e.getMessage()};
                        LoggerKt.getLOG().warn("Did not recognize gitignore pattern: '{}' ({})", objectArray);
                        Object var22_45 = null;
                    }
                    if (var22_42 == null) continue;
                    boolean bl10 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                list = (List)destination$iv$iv3;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    private static final ClassPathResolver asClassPathProvider(Path path) {
        ClassPathResolver classPathResolver;
        MavenClassPathResolver mavenClassPathResolver = MavenClassPathResolver.Companion.maybeCreate(path);
        if (mavenClassPathResolver != null) {
            classPathResolver = mavenClassPathResolver;
        } else {
            GradleClassPathResolver gradleClassPathResolver = GradleClassPathResolver.Companion.maybeCreate(path);
            classPathResolver = gradleClassPathResolver != null ? (ClassPathResolver)gradleClassPathResolver : (ClassPathResolver)ShellClassPathResolver.Companion.maybeCreate(path);
        }
        return classPathResolver;
    }

    private static final Sequence defaultClassPathResolver$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DefaultClassPathResolverKt.workspaceResolvers(it);
    }

    private static final boolean folderResolvers$lambda$3(List $ignored, File file) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$none$iv = $ignored;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    PathMatcher it = (PathMatcher)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(file.toPath())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final ClassPathResolver folderResolvers$lambda$4(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = it.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return DefaultClassPathResolverKt.asClassPathProvider(path);
    }
}

