/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.nexus2.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.Instant;
import java.util.Locale;
import org.jreleaser.util.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StagingProfileRepository {
    private String profileId;
    private String profileName;
    private String repositoryId;
    private String type;
    private boolean transitioning;
    private Instant created;
    private Instant updated;

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isTransitioning() {
        return this.transitioning;
    }

    public void setTransitioning(boolean transitioning) {
        this.transitioning = transitioning;
    }

    public State getState() {
        return State.of(this.type);
    }

    public Instant getCreated() {
        return this.created;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public Instant getUpdated() {
        return this.updated;
    }

    public void setUpdated(Instant updated) {
        this.updated = updated;
    }

    public String toString() {
        return "StagingProfileRepository{profileId='" + this.profileId + '\'' + ", profileName='" + this.profileName + '\'' + ", repositoryId='" + this.repositoryId + '\'' + ", type='" + this.type + '\'' + ", created='" + this.created + '\'' + ", updated='" + this.updated + '\'' + ", transitioning=" + this.transitioning + '}';
    }

    public static StagingProfileRepository notFound(String repositoryId) {
        StagingProfileRepository repository = new StagingProfileRepository();
        repository.repositoryId = repositoryId;
        repository.type = "not_found";
        return repository;
    }

    public static enum State {
        OPEN,
        CLOSED,
        RELEASED,
        NOT_FOUND;


        public static State of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return State.valueOf(str.toUpperCase(Locale.ENGLISH).trim().replace("-", "_").replace(" ", "_"));
        }
    }
}

