subroutine uv_addnoise(line,comm,error)
  use gildas_def
  use gkernel_interfaces
  use gbl_message
  use clean_types
  use clean_arrays
  use imager_interfaces, only : map_message, uv_new_data
  !---------------------------------------------------------------------
  !*
  ! IMAGER -- Support routine for command SIMULATE\ADD_NOISE
  ! 
  !   ADD_NOISE Value [Bandwidth [Wcol]] /FILE InputFile OutputFile
  !!
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line  !! Command line
  character(len=*), intent(in) :: comm  !! Command name
  logical, intent(inout) :: error       !! Error flag
  !
  ! Constants
  integer, parameter :: o_file=1
  character(len=*), parameter :: rname='ADD_NOISE'
  ! Local ---
  type(gildas) :: hin,hou
  character(len=filename_length) :: uvin, uvou 
  type(gfits_hdesc_t) :: fd   ! FITS descriptor (unused here)
  !
  integer :: sblock=1000      ! Can be more efficient by computing it...
  integer :: i,nc,nv,j,k,l, wcol, ier, nin, nou
  real :: factor, noise, weight, band
  real(8) :: old_weight
  real, allocatable :: wdata(:)
  !
  ! Code ----
  call sic_r4(line,0,1,noise,.true.,error)
  if (error) return
  if (noise.eq.0) then
    if (sic_present(o_file,0)) then
      call map_message(seve%e,rname,'No noise being added, no new file created')
      error = .true.
      return
    else
      call map_message(seve%i,rname,'No noise being added, reloading noise-free model')
    endif
    weight = 1.0
  else
    weight = 1e-6/noise**2
  endif
  band = 0.
  call sic_r4(line,0,2,band,.false.,error)
  if (error) return
  wcol = 0
  call sic_i4(line,0,3,wcol,.false.,error)
  !
  if (sic_present(o_file,0)) then
    ! /FILE option, use specified Input and Output UV table
    call sic_ch(line,o_file,1,uvin,nin,.true.,error)
    if (error) return
    call sic_ch(line,o_file,2,uvou,nou,.true.,error)
    if (error) return
    !
    ! Open line table
    call gildas_null (hin, type = 'UVT')
    call gdf_read_gildas (hin, uvin, '.uvt', error, data=.false.)
    if (error) then
      call map_message(seve%e,rname,'Cannot read input UV table')
      return
    endif
    !
    nc = hin%gil%nchan 
    if (wcol.le.0 .or. wcol.gt.nc) wcol = (nc+2)/3   ! Default channel
    wcol = hin%gil%fcol-1+3*wcol
    !
    hin%blc(1:2) = [wcol,0]
    hin%trc(1:2) = [wcol,0]
    allocate (wdata(hin%gil%dim(2)), hin%r2d(hin%gil%dim(1), sblock), stat=ier)
    if (ier.ne.0) then
      call map_message(seve%e,rname,'Memory allocation error')
      call gdf_close_image(hin,error)
      error = .true.
      return
    endif
    call gdf_read_data (hin, wdata, error)
    if (error) then
      call gdf_close_image(hin,error)
      error = .true.
      return
    endif
    hin%blc = 0
    hin%trc = 0
    !
    old_weight = 0.
    do i=1,hin%gil%nvisi
      if (wdata(i).gt.0) old_weight = old_weight + wdata(i)
    enddo
    if (band.eq.0.) band = abs(hin%gil%fres)
    if (old_weight.eq.0) then
      call map_message(seve%e,rname,'Selected weight channel has Zero weight')
      error = .true.
      return
    endif
    factor = weight / old_weight * abs(hin%gil%fres)/band
    !Print *,'Weight ',weight
    !Print *,'Old Weight ',old_weight
    !Print *,'Resolution ',abs(hin%gil%fres),band
    !Print *,'Factor ',factor
    !
    call gildas_null(hou,type='UVT')
    call gdf_copy_header(hin,hou,error)
    call sic_parsef (uvou, hou%file,' ','.uvt')
    call gdf_create_image(hou,error)
    if (error) then
      call gdf_close_image(hin,error)
      error = .true.
      return
    endif
    !
    ! Loop over line table
    do i=1,hin%gil%dim(2),sblock
      hin%blc(2) = i
      hin%trc(2) = min(hin%gil%dim(2),i-1+sblock)
      call gdf_read_data(hin,hin%r2d,error)
      !
      ! Add noise to this visibility range
      nv = hin%trc(2)-hin%blc(2)+1
      do j=1,nv
        weight = hin%r2d(wcol,j)
        if (weight.gt.0) then
          weight = weight*factor
          noise = 1e-3/sqrt(weight) 
          do k=1,nc
            l = hin%gil%fcol+3*(k-1)
            hin%r2d(l,j) = hin%r2d(l,j) + rangau(noise)
            l = l+1
            hin%r2d(l,j) = hin%r2d(l,j) + rangau(noise)
            l = l+1
            hin%r2d(l,j) = weight 
          enddo
        endif
      enddo  
      hou%blc = hin%blc
      hou%trc = hin%trc
      call gdf_write_data (hou, hin%r2d, error)
    enddo
    ! end loop
    call gdf_close_image (hin, error)
    call gdf_close_image (hou, error)
  else
    ! No /FILE option: Start from the MODEL_UV table,
    ! and overwrite the UV_DATA table.
    !
    if (.not.allocated(duvm)) then
      call map_message(seve%e,rname,'No MODEL_UV table in memory')
      error = .true.
      return
    endif
    !
    ! Discard the current UV_DATA table and overload it by the UV_MODEL
    call getset_uvdata('ADD_NOISE',huvm,duvm,fd,0,[0,0],0,error)
    !
    ! Update the content
    if (noise.gt.0) then
      nc = huvm%gil%nchan
      if (wcol.le.0 .or. wcol.gt.nc) wcol = (nc+2)/3   ! Default channel
      wcol = huvm%gil%fcol-1+3*wcol
      old_weight = 0.
      do i=1,huvm%gil%nvisi
        if (duvm(wcol,i).gt.0) old_weight = old_weight + duvm(wcol,i)
      enddo
      if (band.eq.0.) band = abs(huvm%gil%fres)
      factor = weight / old_weight * abs(huvm%gil%fres)/band
      !
      !$OMP PARALLEL DEFAULT(NONE) &
      !$OMP & SHARED(huvm,huvi,duvi,wcol,nc,factor) &
      !$OMP & PRIVATE(weight,j,k,l,noise)
      !$OMP DO
      do j=1,huvm%gil%nvisi
        weight = duvi(wcol,j)
        if (weight.gt.0) then
          weight = weight*factor
          noise = 1e-3/sqrt(weight)
          do k=1,nc
            l = huvi%gil%fcol+3*(k-1)
            duvi(l,j) = duvi(l,j) + rangau(noise)
            l = l+1
            duvi(l,j) = duvi(l,j) + rangau(noise)
            l = l+1
            duvi(l,j) = weight
          enddo
        endif
      enddo
      !$OMP ENDDO
      !$OMP END PARALLEL
    endif
    !
    call uv_new_data(weight=.true.)
    optimize(code_save_uv)%change = optimize(code_save_uv)%change+100
    !
  endif
end subroutine uv_addnoise
!
