/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;

public class DefaultOperatingSystem
implements OperatingSystemInternal {
    private static final OperatingSystem CURRENT_OS = OperatingSystem.current();
    private final String name;
    private final OperatingSystem internalOs;

    public DefaultOperatingSystem(String name) {
        this(name, OperatingSystem.forName((String)name));
    }

    public DefaultOperatingSystem(String name, OperatingSystem internalOs) {
        this.name = name;
        this.internalOs = internalOs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return "operating system '" + this.name + "'";
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public OperatingSystem getInternalOs() {
        return this.internalOs;
    }

    @Override
    public String toFamilyName() {
        if (this.isWindows()) {
            return "windows";
        }
        if (this.isLinux()) {
            return "linux";
        }
        if (this.isMacOsX()) {
            return "macos";
        }
        throw new UnsupportedOperationException("Unsupported operating system family of name '" + this.name + "'");
    }

    @Override
    public boolean isCurrent() {
        return this.internalOs == CURRENT_OS;
    }

    @Override
    public boolean isWindows() {
        return this.internalOs.isWindows();
    }

    @Override
    public boolean isLinux() {
        return this.internalOs.isLinux();
    }

    @Override
    public boolean isMacOsX() {
        return this.internalOs.isMacOsX();
    }

    @Override
    public boolean isSolaris() {
        return this.internalOs == OperatingSystem.SOLARIS;
    }

    @Override
    public boolean isFreeBSD() {
        return this.internalOs == OperatingSystem.FREE_BSD;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOperatingSystem that = (DefaultOperatingSystem)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

