/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.jspecify.annotations.Nullable;

public class TransformChain {
    private final @Nullable TransformChain init;
    private final TransformStep last;

    public TransformChain(@Nullable TransformChain init, TransformStep last) {
        this.init = init;
        this.last = last;
    }

    public @Nullable TransformChain getInit() {
        return this.init;
    }

    public TransformStep getLast() {
        return this.last;
    }

    public boolean requiresDependencies() {
        return this.init != null && this.init.requiresDependencies() || this.last.requiresDependencies();
    }

    public String getDisplayName() {
        String lastDisplayName = this.last.getDisplayName();
        return this.init == null ? lastDisplayName : this.init.getDisplayName() + " -> " + lastDisplayName;
    }

    public void visitTransformSteps(Action<? super TransformStep> action) {
        if (this.init != null) {
            this.init.visitTransformSteps(action);
        }
        action.execute((Object)this.last);
    }

    public int length() {
        return (this.init == null ? 0 : this.init.length()) + 1;
    }
}

