/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.api.groovybytecode;

import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;
import org.gradle.internal.instrumentation.api.groovybytecode.Invocation;
import org.gradle.internal.instrumentation.api.groovybytecode.InvocationUtils;

class MethodHandleInvocation
implements Invocation {
    private final MethodHandle original;
    private final Object[] originalArgs;
    private final Object[] unspreadArgs;
    private final int unspreadArgsOffset;

    public MethodHandleInvocation(MethodHandle original, Object[] originalArgs, boolean isSpread) {
        this.original = original;
        this.originalArgs = originalArgs;
        if (isSpread) {
            this.unspreadArgs = (Object[])originalArgs[1];
            this.unspreadArgsOffset = 0;
        } else {
            this.unspreadArgs = originalArgs;
            this.unspreadArgsOffset = 1;
        }
    }

    @Override
    public Object getReceiver() {
        return InvocationUtils.unwrap(this.originalArgs[0]);
    }

    @Override
    public int getArgsCount() {
        return this.unspreadArgs.length - this.unspreadArgsOffset;
    }

    @Override
    @Nullable
    public Object getArgument(int pos) {
        return InvocationUtils.unwrap(this.unspreadArgs[pos + this.unspreadArgsOffset]);
    }

    @Override
    @Nullable
    public Object callNext() throws Throwable {
        return this.original.invokeExact(this.originalArgs);
    }
}

