/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.capability;

import java.io.IOException;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.internal.artifacts.capability.DefaultFeatureCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.DefaultSpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.FeatureCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.SpecificCapabilitySelector;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class CapabilitySelectorSerializer
implements Serializer<CapabilitySelector> {
    private static final int SPECIFIC_CAPABILITY_SELECTOR = 1;
    private static final int FEATURE_CAPABILITY_SELECTOR = 2;

    public CapabilitySelector read(Decoder decoder) throws IOException {
        int type = decoder.readSmallInt();
        switch (type) {
            case 1: {
                return CapabilitySelectorSerializer.readSpecificCapabilitySelector(decoder);
            }
            case 2: {
                return CapabilitySelectorSerializer.readFeatureCapabilitySelector(decoder);
            }
        }
        throw new IllegalArgumentException("Unknown capability selector type: " + type);
    }

    private static CapabilitySelector readSpecificCapabilitySelector(Decoder decoder) throws IOException {
        String group = decoder.readString();
        String name = decoder.readString();
        String version = decoder.readNullableString();
        return new DefaultSpecificCapabilitySelector((ImmutableCapability)new DefaultImmutableCapability(group, name, version));
    }

    private static CapabilitySelector readFeatureCapabilitySelector(Decoder decoder) throws IOException {
        String feature = decoder.readString();
        return new DefaultFeatureCapabilitySelector(feature);
    }

    public void write(Encoder encoder, CapabilitySelector value) throws IOException {
        if (value instanceof SpecificCapabilitySelector) {
            encoder.writeSmallInt(1);
            CapabilitySelectorSerializer.writeSpecificCapabilitySelector(encoder, (DefaultSpecificCapabilitySelector)value);
        } else if (value instanceof FeatureCapabilitySelector) {
            encoder.writeSmallInt(2);
            CapabilitySelectorSerializer.writeFeatureCapabilitySelector(encoder, (FeatureCapabilitySelector)value);
        } else {
            throw new IllegalArgumentException("Unknown capability selector type: " + value.getClass());
        }
    }

    private static void writeSpecificCapabilitySelector(Encoder encoder, DefaultSpecificCapabilitySelector value) throws IOException {
        encoder.writeString((CharSequence)value.getGroup());
        encoder.writeString((CharSequence)value.getName());
        encoder.writeNullableString((CharSequence)value.getBackingCapability().getVersion());
    }

    private static void writeFeatureCapabilitySelector(Encoder encoder, FeatureCapabilitySelector value) throws IOException {
        encoder.writeString((CharSequence)value.getFeatureName());
    }
}

