"""Generated message classes for agentregistry version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'agentregistry'


class Agent(_messages.Message):
  r"""Represents an Agent. "A2A" below refers to the Agent-to-Agent protocol.

  Enums:
    AgentIdTypeValueValuesEnum: Output only. The type of the agent ID.

  Fields:
    agentId: Output only. A stable, globally unique identifier for agents.
      Example: `urn:agent:acme.com:my-agent`
    agentIdType: Output only. The type of the agent ID.
    createTime: Output only. Create time.
    description: Output only. The description of the Agent, often obtained
      from the A2A Agent Card. Empty if Agent Card has no description.
    displayName: Output only. The display name of the agent, often obtained
      from the A2A Agent Card.
    location: Output only. The location where agent is hosted. The value is
      defined by the hosting environment (i.e. cloud provider).
    name: Identifier. The resource name of an Agent. Format:
      `projects/{project}/locations/{location}/agents/{agent}`.
    protocols: Output only. The connection details for the Agent.
    skills: Output only. Skills the agent possesses, often obtained from the
      A2A Agent Card.
    uid: Output only. A universally unique identifier for the Agent.
    updateTime: Output only. Update time.
    version: Output only. The version of the Agent, often obtained from the
      A2A Agent Card. Empty if Agent Card has no version or agent is not an
      A2A Agent.
  """

  class AgentIdTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the agent ID.

    Values:
      AGENT_ID_TYPE_UNSPECIFIED: Unspecified type.
      URN: The agent ID is a URN. Examples: * `urn:agent:acme.com:my-agent` *
        `urn:agent:acme.com:sales-department:supply-chain-agent`
    """
    AGENT_ID_TYPE_UNSPECIFIED = 0
    URN = 1

  agentId = _messages.StringField(1)
  agentIdType = _messages.EnumField('AgentIdTypeValueValuesEnum', 2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  location = _messages.StringField(6)
  name = _messages.StringField(7)
  protocols = _messages.MessageField('Protocol', 8, repeated=True)
  skills = _messages.MessageField('Skill', 9, repeated=True)
  uid = _messages.StringField(10)
  updateTime = _messages.StringField(11)
  version = _messages.StringField(12)


class AgentSpec(_messages.Message):
  r"""The spec of the agent.

  Enums:
    TypeValueValuesEnum: Required. The type of the agent spec content.

  Messages:
    ContentValue: Optional. The content of the Agent spec in the JSON format.
      This payload is validated against the schema for the specified type.

  Fields:
    content: Optional. The content of the Agent spec in the JSON format. This
      payload is validated against the schema for the specified type.
    type: Required. The type of the agent spec content.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the agent spec content.

    Values:
      TYPE_UNSPECIFIED: Unspecified type.
      NO_SPEC: There is no spec for the Agent. The content field must be
        empty.
      A2A_AGENT_CARD: The content is an A2A Agent Card following the A2A
        specification. The interfaces field must be empty.
    """
    TYPE_UNSPECIFIED = 0
    NO_SPEC = 1
    A2A_AGENT_CARD = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ContentValue(_messages.Message):
    r"""Optional. The content of the Agent spec in the JSON format. This
    payload is validated against the schema for the specified type.

    Messages:
      AdditionalProperty: An additional property for a ContentValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ContentValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  content = _messages.MessageField('ContentValue', 1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class AgentregistryProjectsLocationsAgentsGetRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsAgentsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class AgentregistryProjectsLocationsAgentsListRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsAgentsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListAgentsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AgentregistryProjectsLocationsEndpointsGetRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsEndpointsGetRequest object.

  Fields:
    name: Required. The name of the endpoint to retrieve. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  name = _messages.StringField(1, required=True)


class AgentregistryProjectsLocationsEndpointsListRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsEndpointsListRequest object.

  Fields:
    filter: Optional. A query string used to filter the list of endpoints
      returned. The filter expression must follow AIP-160 syntax. Filtering is
      supported on the `name`, `display_name`, `description`, `version`, and
      `interfaces` fields. Some examples: * `name =
      "projects/p1/locations/l1/endpoints/e1"` * `display_name = "my-
      endpoint"` * `description = "my-endpoint-description"` * `version =
      "v1"` * `interfaces.transport = "HTTP_JSON"`
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The project and location to list endpoints in. Expected
      format: `projects/{project}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class AgentregistryProjectsLocationsGetRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class AgentregistryProjectsLocationsListRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class AgentregistryProjectsLocationsMcpServersGetRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsMcpServersGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class AgentregistryProjectsLocationsMcpServersListRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsMcpServersListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListMcpServersRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AgentregistryProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class AgentregistryProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AgentregistryProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AgentregistryProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class AgentregistryProjectsLocationsServicesCreateRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsServicesCreateRequest object.

  Fields:
    parent: Required. The project and location to create the Service in.
      Expected format: `projects/{project}/locations/{location}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    service: A Service resource to be passed as the request body.
    serviceId: Required. The ID to use for the service, which will become the
      final component of the service's resource name. This value should be
      4-63 characters, and valid characters are `/a-z-/`.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  service = _messages.MessageField('Service', 3)
  serviceId = _messages.StringField(4)


class AgentregistryProjectsLocationsServicesDeleteRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsServicesDeleteRequest object.

  Fields:
    name: Required. The name of the Service. Format:
      `projects/{project}/locations/{location}/services/{service}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class AgentregistryProjectsLocationsServicesGetRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsServicesGetRequest object.

  Fields:
    name: Required. The name of the Service. Format:
      `projects/{project}/locations/{location}/services/{service}`.
  """

  name = _messages.StringField(1, required=True)


class AgentregistryProjectsLocationsServicesListRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsServicesListRequest object.

  Fields:
    filter: Optional. A query string used to filter the list of services
      returned. The filter expression must follow AIP-160 syntax. Filtering is
      supported on the `name`, `display_name`, `description`, and `labels`
      fields. Some examples: * `name = "projects/p1/locations/l1/services/s1"`
      * `display_name = "my-service"` * `description : "myservice
      description"` * `labels.env = "prod"`
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The project and location to list services in. Expected
      format: `projects/{project}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class AgentregistryProjectsLocationsServicesPatchRequest(_messages.Message):
  r"""A AgentregistryProjectsLocationsServicesPatchRequest object.

  Fields:
    name: Identifier. The resource name of the Service. Format:
      `projects/{project}/locations/{location}/services/{service}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    service: A Service resource to be passed as the request body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Service resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields present in the request will be
      overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  service = _messages.MessageField('Service', 3)
  updateMask = _messages.StringField(4)


class Annotations(_messages.Message):
  r"""Annotations describing the characteristics and behavior of a tool or
  operation.

  Fields:
    destructiveHint: Output only. If true, the tool may perform destructive
      updates to its environment. If false, the tool performs only additive
      updates. NOTE: This property is meaningful only when `read_only_hint ==
      false` Default: true
    idempotentHint: Output only. If true, calling the tool repeatedly with the
      same arguments will have no additional effect on its environment. NOTE:
      This property is meaningful only when `read_only_hint == false. Default:
      false
    openWorldHint: Output only. If true, this tool may interact with an "open
      world" of external entities. If false, the tool's domain of interaction
      is closed. For example, the world of a web search tool is open, whereas
      that of a memory tool is not. Default: true
    readOnlyHint: Output only. If true, the tool does not modify its
      environment. Default: false
    title: Output only. A human-readable title for the tool.
  """

  destructiveHint = _messages.BooleanField(1)
  idempotentHint = _messages.BooleanField(2)
  openWorldHint = _messages.BooleanField(3)
  readOnlyHint = _messages.BooleanField(4)
  title = _messages.StringField(5)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Endpoint(_messages.Message):
  r"""Represents an Endpoint.

  Fields:
    createTime: Output only. Create time.
    description: Output only. Description of an Endpoint.
    displayName: Output only. Display name for the Endpoint.
    interfaces: Required. The connection details for the Endpoint.
    name: Identifier. The resource name of the Endpoint. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`.
    updateTime: Output only. Update time.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  interfaces = _messages.MessageField('Interface', 4, repeated=True)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class EndpointSpec(_messages.Message):
  r"""The spec of the endpoint.

  Enums:
    TypeValueValuesEnum: Required. The type of the endpoint spec content.

  Messages:
    ContentValue: Optional. The content of the endpoint spec. Reserved for
      future use.

  Fields:
    content: Optional. The content of the endpoint spec. Reserved for future
      use.
    type: Required. The type of the endpoint spec content.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the endpoint spec content.

    Values:
      TYPE_UNSPECIFIED: Unspecified type.
      NO_SPEC: There is no spec for the Endpoint. The content field must be
        empty.
    """
    TYPE_UNSPECIFIED = 0
    NO_SPEC = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ContentValue(_messages.Message):
    r"""Optional. The content of the endpoint spec. Reserved for future use.

    Messages:
      AdditionalProperty: An additional property for a ContentValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ContentValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  content = _messages.MessageField('ContentValue', 1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class Interface(_messages.Message):
  r"""Represents the connection details for an Agent or MCP Server.

  Enums:
    ProtocolBindingValueValuesEnum: Required. The protocol binding of the
      interface.

  Fields:
    protocolBinding: Required. The protocol binding of the interface.
    url: Required. The destination URL.
  """

  class ProtocolBindingValueValuesEnum(_messages.Enum):
    r"""Required. The protocol binding of the interface.

    Values:
      PROTOCOL_BINDING_UNSPECIFIED: Unspecified transport protocol.
      JSONRPC: JSON-RPC specification.
      GRPC: gRPC specification.
      HTTP_JSON: HTTP+JSON specification.
    """
    PROTOCOL_BINDING_UNSPECIFIED = 0
    JSONRPC = 1
    GRPC = 2
    HTTP_JSON = 3

  protocolBinding = _messages.EnumField('ProtocolBindingValueValuesEnum', 1)
  url = _messages.StringField(2)


class ListAgentsResponse(_messages.Message):
  r"""Message for response to listing Agents

  Fields:
    agents: The list of Agent
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  agents = _messages.MessageField('Agent', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEndpointsResponse(_messages.Message):
  r"""Message for response to listing Endpoints

  Fields:
    endpoints: The list of Endpoint resources matching the parent and filter
      criteria in the request. Each Endpoint resource follows the format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`.
    nextPageToken: A token identifying a page of results the server should
      return. Used in page_token.
  """

  endpoints = _messages.MessageField('Endpoint', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMcpServersResponse(_messages.Message):
  r"""Message for response to listing McpServers

  Fields:
    mcpServers: The list of McpServer
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  mcpServers = _messages.MessageField('McpServer', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListServicesResponse(_messages.Message):
  r"""Message for response to listing Services

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return. Used in page_token.
    services: The list of Service resources matching the parent and filter
      criteria in the request. Each Service resource follows the format:
      `projects/{project}/locations/{location}/services/{service}`.
  """

  nextPageToken = _messages.StringField(1)
  services = _messages.MessageField('Service', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class McpServer(_messages.Message):
  r"""Represents an MCP (Model Context Protocol) Server.

  Fields:
    createTime: Output only. Create time.
    description: Output only. The description of the MCP Server.
    displayName: Output only. The display name of the MCP Server.
    interfaces: Output only. The connection details for the MCP Server.
    name: Identifier. The resource name of the MCP Server. Format:
      `projects/{project}/locations/{location}/mcpServers/{mcp_server}`.
    tools: Output only. Tools provided by the MCP Server.
    updateTime: Output only. Update time.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  interfaces = _messages.MessageField('Interface', 4, repeated=True)
  name = _messages.StringField(5)
  tools = _messages.MessageField('Tool', 6, repeated=True)
  updateTime = _messages.StringField(7)


class McpServerSpec(_messages.Message):
  r"""The spec of the MCP Server.

  Enums:
    TypeValueValuesEnum: Required. The type of the MCP Server spec content.

  Messages:
    ContentValue: Optional. The content of the MCP Server spec. This payload
      is validated against the schema for the specified type.

  Fields:
    content: Optional. The content of the MCP Server spec. This payload is
      validated against the schema for the specified type.
    type: Required. The type of the MCP Server spec content.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the MCP Server spec content.

    Values:
      TYPE_UNSPECIFIED: Unspecified type.
      NO_SPEC: There is no spec for the MCP Server. The content field must be
        empty.
      TOOL_SPEC: The content is a MCP Tool Spec following the One MCP
        specification. The payload is the same as the tools/list response.
    """
    TYPE_UNSPECIFIED = 0
    NO_SPEC = 1
    TOOL_SPEC = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ContentValue(_messages.Message):
    r"""Optional. The content of the MCP Server spec. This payload is
    validated against the schema for the specified type.

    Messages:
      AdditionalProperty: An additional property for a ContentValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ContentValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  content = _messages.MessageField('ContentValue', 1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have google.longrunning.Operation.error value
      with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Protocol(_messages.Message):
  r"""Represents the protocol of an Agent.

  Enums:
    TypeValueValuesEnum: Output only. The type of the protocol.

  Fields:
    interfaces: Output only. The connection details for the Agent.
    protocolVersion: Output only. The version of the protocol, for example,
      the A2A Agent Card version.
    type: Output only. The type of the protocol.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the protocol.

    Values:
      TYPE_UNSPECIFIED: Unspecified type.
      A2A_AGENT: The interfaces point to an A2A Agent following the A2A
        specification.
      CUSTOM: Agent does not follow any standard protocol.
    """
    TYPE_UNSPECIFIED = 0
    A2A_AGENT = 1
    CUSTOM = 2

  interfaces = _messages.MessageField('Interface', 1, repeated=True)
  protocolVersion = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class Service(_messages.Message):
  r"""Represents a user-defined Service.

  Fields:
    agentSpec: Optional. The spec of the Agent. When set, the type of the
      service is Agent.
    createTime: Output only. Create time.
    description: Optional. User-defined description of an Service. Can have a
      maximum length of 2048 characters.
    displayName: Optional. User-defined display name for the Service. Can have
      a maximum length of 63 characters.
    endpointSpec: Optional. The spec of the Endpoint. When set, the type of
      the service is Endpoint.
    interfaces: Required. The connection details for the Service.
    mcpServerSpec: Optional. The spec of the MCP Server. When set, the type of
      the service is MCP Server.
    name: Identifier. The resource name of the Service. Format:
      `projects/{project}/locations/{location}/services/{service}`.
    updateTime: Output only. Update time.
  """

  agentSpec = _messages.MessageField('AgentSpec', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  endpointSpec = _messages.MessageField('EndpointSpec', 5)
  interfaces = _messages.MessageField('Interface', 6, repeated=True)
  mcpServerSpec = _messages.MessageField('McpServerSpec', 7)
  name = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class Skill(_messages.Message):
  r"""Represents the skills of an Agent.

  Fields:
    description: Output only. A more detailed description of the skill.
    examples: Output only. Example prompts or scenarios this skill can handle.
    id: Output only. A unique identifier for the agent's skill.
    name: Output only. A human-readable name for the agent's skill.
    tags: Output only. Keywords describing the skill.
  """

  description = _messages.StringField(1)
  examples = _messages.StringField(2, repeated=True)
  id = _messages.StringField(3)
  name = _messages.StringField(4)
  tags = _messages.StringField(5, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Tool(_messages.Message):
  r"""Represents a single tool provided by an MCP Server.

  Fields:
    annotations: Output only. Annotations associated with the tool.
    description: Output only. Description of what the tool does.
    name: Output only. Human-readable name of the tool.
  """

  annotations = _messages.MessageField('Annotations', 1)
  description = _messages.StringField(2)
  name = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
