"""Generated message classes for cloudapiregistry version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudapiregistry'


class CloudapiregistryProjectsLocationsGetRequest(_messages.Message):
  r"""A CloudapiregistryProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class CloudapiregistryProjectsLocationsListRequest(_messages.Message):
  r"""A CloudapiregistryProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class CloudapiregistryProjectsLocationsMcpServersGetRequest(_messages.Message):
  r"""A CloudapiregistryProjectsLocationsMcpServersGetRequest object.

  Fields:
    name: Required. Name of the resource Format:
      projects/{project}/locations/{location}/mcpServers/{mcp_server}
  """

  name = _messages.StringField(1, required=True)


class CloudapiregistryProjectsLocationsMcpServersListRequest(_messages.Message):
  r"""A CloudapiregistryProjectsLocationsMcpServersListRequest object.

  Fields:
    filter: Optional. An expression that filters the results. For syntax, see
      https://google.aip.dev/160.
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. For
      syntax, see https://google.aip.dev/132#ordering.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, at most 50 items will be returned. The
      maximum value is 100; values above 100 will be coerced to 100.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListMcpServersRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudapiregistryProjectsLocationsMcpServersMcpToolsGetRequest(_messages.Message):
  r"""A CloudapiregistryProjectsLocationsMcpServersMcpToolsGetRequest object.

  Fields:
    name: Required. Name of the resource Format: projects/{project}/locations/
      {location}/mcpServers/{mcp_server}/mcpTools/{mcp_tool}
  """

  name = _messages.StringField(1, required=True)


class CloudapiregistryProjectsLocationsMcpServersMcpToolsListRequest(_messages.Message):
  r"""A CloudapiregistryProjectsLocationsMcpServersMcpToolsListRequest object.

  Fields:
    filter: Optional. An expression that filters the results. For syntax, see
      https://google.aip.dev/160.
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. For
      syntax, see https://google.aip.dev/132#ordering.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, at most 50 items will be returned. The
      maximum value is 100; values above 100 will be coerced to 100.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListMcpToolsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMcpServersResponse(_messages.Message):
  r"""Message for response to listing McpServers

  Fields:
    mcpServers: The list of McpServer
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
  """

  mcpServers = _messages.MessageField('McpServer', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListMcpToolsResponse(_messages.Message):
  r"""Message for response to listing McpTools

  Fields:
    mcpTools: The list of McpTool
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
  """

  mcpTools = _messages.MessageField('McpTool', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class McpServer(_messages.Message):
  r"""Represents an MCP Server. MCP Servers act as endpoints that expose a
  collection of tools that can be invoked by agents.

  Enums:
    StateValueValuesEnum: Output only. The state of the MCP Server.

  Messages:
    CapabilitiesValue: The capabilities that a server may support. Known
      capabilities defined in https://modelcontextprotocol.io/specification/20
      25-06-18/schema#servercapabilities and additional capabilities defined
      by the servers.

  Fields:
    capabilities: The capabilities that a server may support. Known
      capabilities defined in https://modelcontextprotocol.io/specification/20
      25-06-18/schema#servercapabilities and additional capabilities defined
      by the servers.
    description: Optional. A human-readable description of the MCP Server's
      functionality.
    displayName: Optional. A human readable name for the MCP server.
    name: Identifier. The resource name of the MCP Server. Format:
      `projects/{project}/locations/{location}/mcpServers/{mcp_server}`.
      Example: projects/12345/locations/us-
      central1/mcpServers/google:bigquery.googleapis.com:mcp for 1p
      projects/12345/locations/us-central1/mcpServers/apphub:starbucks for 2p
    state: Output only. The state of the MCP Server.
    urls: The base URL of the MCP server. Example:
      [geolocation.googleapis.com/mcp].
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the MCP Server.

    Values:
      STATE_UNSPECIFIED: The McpServer state is unspecified.
      ENABLED: The McpServer is enabled.
      DISABLED: The McpServer is disabled.
    """
    STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class CapabilitiesValue(_messages.Message):
    r"""The capabilities that a server may support. Known capabilities defined
    in https://modelcontextprotocol.io/specification/2025-06-
    18/schema#servercapabilities and additional capabilities defined by the
    servers.

    Messages:
      AdditionalProperty: An additional property for a CapabilitiesValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a CapabilitiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  capabilities = _messages.MessageField('CapabilitiesValue', 1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  urls = _messages.StringField(6, repeated=True)


class McpTool(_messages.Message):
  r"""Message describing McpTool object

  Messages:
    AnnotationsValue: Optional key-value object that allows developers to
      provide additional information regarding tool properties, behavior, and
      usage best practices. Annotations or tags to facilitate semantic search
      across tools ("semantic tags") are not in the MVP scope. When
      implemented, the first set of supported annotations will likely be the
      standard, predefined annotations from the open-source MCP spec. These
      include: - title: A human-readable title for the tool, useful for UI
      display. - readOnlyHint: If true, indicates the tool does not modify its
      environment. - destructiveHint: If true, the tool may perform
      destructive updates (only meaningful when readOnlyHint is false). -
      idempotentHint: If true, calling the tool repeatedly with the same
      arguments has no additional effect (only meaningful when readOnlyHint is
      false). - openWorldHint: If true, the tool may interact with an "open
      world" of external entities.
    InputSchemaValue: A JSON Schema object defining the expected parameters
      for invoking the tool.
    OutputSchemaValue: Optional. A JSON Schema object defining the expected
      structure of the tool's output.

  Fields:
    annotations: Optional key-value object that allows developers to provide
      additional information regarding tool properties, behavior, and usage
      best practices. Annotations or tags to facilitate semantic search across
      tools ("semantic tags") are not in the MVP scope. When implemented, the
      first set of supported annotations will likely be the standard,
      predefined annotations from the open-source MCP spec. These include: -
      title: A human-readable title for the tool, useful for UI display. -
      readOnlyHint: If true, indicates the tool does not modify its
      environment. - destructiveHint: If true, the tool may perform
      destructive updates (only meaningful when readOnlyHint is false). -
      idempotentHint: If true, calling the tool repeatedly with the same
      arguments has no additional effect (only meaningful when readOnlyHint is
      false). - openWorldHint: If true, the tool may interact with an "open
      world" of external entities.
    description: A human-readable description of the tool's functionality.
    displayName: Optional. A human-readable name for the tool, suitable for
      display.
    inputSchema: A JSON Schema object defining the expected parameters for
      invoking the tool.
    mcpServerUrls: Automatically populated reference to MCP Server. Helpful
      when multiple tools are requested across different MCP Servers.
    name: Identifier. The resource name of the McpTool. Format: `projects/{pro
      ject}/locations/{location}/mcpServers/{mcp_server}/mcpTools/{mcp_tool}`.
      Example: projects/12345/locations/us-central1/mcpServers/google:bigquery
      .googleapis.com:mcp/mcpTools/insert_job for 1p
      projects/12345/locations/us-
      central1/mcpServers/apphub:starbucks/mcpTools/order_pizza for 2p
    outputSchema: Optional. A JSON Schema object defining the expected
      structure of the tool's output.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional key-value object that allows developers to provide additional
    information regarding tool properties, behavior, and usage best practices.
    Annotations or tags to facilitate semantic search across tools ("semantic
    tags") are not in the MVP scope. When implemented, the first set of
    supported annotations will likely be the standard, predefined annotations
    from the open-source MCP spec. These include: - title: A human-readable
    title for the tool, useful for UI display. - readOnlyHint: If true,
    indicates the tool does not modify its environment. - destructiveHint: If
    true, the tool may perform destructive updates (only meaningful when
    readOnlyHint is false). - idempotentHint: If true, calling the tool
    repeatedly with the same arguments has no additional effect (only
    meaningful when readOnlyHint is false). - openWorldHint: If true, the tool
    may interact with an "open world" of external entities.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputSchemaValue(_messages.Message):
    r"""A JSON Schema object defining the expected parameters for invoking the
    tool.

    Messages:
      AdditionalProperty: An additional property for a InputSchemaValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputSchemaValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputSchemaValue(_messages.Message):
    r"""Optional. A JSON Schema object defining the expected structure of the
    tool's output.

    Messages:
      AdditionalProperty: An additional property for a OutputSchemaValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputSchemaValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  inputSchema = _messages.MessageField('InputSchemaValue', 4)
  mcpServerUrls = _messages.StringField(5, repeated=True)
  name = _messages.StringField(6)
  outputSchema = _messages.MessageField('OutputSchemaValue', 7)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
