"""Generated message classes for managedkafka version v1.

Manage Apache Kafka clusters and resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'managedkafka'


class AccessConfig(_messages.Message):
  r"""The configuration of access to the Kafka cluster.

  Fields:
    networkConfigs: Required. Virtual Private Cloud (VPC) networks that must
      be granted direct access to the Kafka cluster. Minimum of 1 network is
      required. Maximum 10 networks can be specified.
  """

  networkConfigs = _messages.MessageField('NetworkConfig', 1, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CapacityConfig(_messages.Message):
  r"""A capacity configuration of a Kafka cluster.

  Fields:
    memoryBytes: Required. The memory to provision for the cluster in bytes.
      The CPU:memory ratio (vCPU:GiB) must be between 1:1 and 1:8. Minimum:
      3221225472 (3 GiB).
    vcpuCount: Required. The number of vCPUs to provision for the cluster.
      Minimum: 3.
  """

  memoryBytes = _messages.IntegerField(1)
  vcpuCount = _messages.IntegerField(2)


class Cluster(_messages.Message):
  r"""An Apache Kafka cluster deployed in a location.

  Enums:
    StateValueValuesEnum: Output only. The current state of the cluster.

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    capacityConfig: Required. Capacity configuration for the Kafka cluster.
    createTime: Output only. The time when the cluster was created.
    gcpConfig: Required. Configuration properties for a Kafka cluster deployed
      to Google Cloud Platform.
    labels: Optional. Labels as key value pairs.
    name: Identifier. The name of the cluster. Structured like:
      projects/{project_number}/locations/{location}/clusters/{cluster_id}
    rebalanceConfig: Optional. Rebalance configuration for the Kafka cluster.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    state: Output only. The current state of the cluster.
    updateTime: Output only. The time when the cluster was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the cluster.

    Values:
      STATE_UNSPECIFIED: A state was not specified.
      CREATING: The cluster is being created.
      ACTIVE: The cluster is active.
      DELETING: The cluster is being deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  capacityConfig = _messages.MessageField('CapacityConfig', 1)
  createTime = _messages.StringField(2)
  gcpConfig = _messages.MessageField('GcpConfig', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  rebalanceConfig = _messages.MessageField('RebalanceConfig', 6)
  satisfiesPzi = _messages.BooleanField(7)
  satisfiesPzs = _messages.BooleanField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  updateTime = _messages.StringField(10)


class ConnectAccessConfig(_messages.Message):
  r"""The configuration of access to the Kafka Connect cluster.

  Fields:
    networkConfigs: Required. Virtual Private Cloud (VPC) networks that must
      be granted direct access to the Kafka Connect cluster. Minimum of 1
      network is required. Maximum 10 networks can be specified.
  """

  networkConfigs = _messages.MessageField('ConnectNetworkConfig', 1, repeated=True)


class ConnectCluster(_messages.Message):
  r"""An Apache Kafka Connect cluster deployed in a location.

  Enums:
    StateValueValuesEnum: Output only. The current state of the cluster.

  Messages:
    ConfigValue: Optional. Configurations for the worker that are overridden
      from the defaults. The key of the map is a Kafka Connect worker property
      name, for example: `exactly.once.source.support`.
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    capacityConfig: Required. Capacity configuration for the Kafka Connect
      cluster.
    config: Optional. Configurations for the worker that are overridden from
      the defaults. The key of the map is a Kafka Connect worker property
      name, for example: `exactly.once.source.support`.
    createTime: Output only. The time when the cluster was created.
    gcpConfig: Required. Configuration properties for a Kafka Connect cluster
      deployed to Google Cloud Platform.
    kafkaCluster: Required. Immutable. The name of the Kafka cluster this
      Kafka Connect cluster is attached to. Structured like:
      projects/{project}/locations/{location}/clusters/{cluster}
    labels: Optional. Labels as key value pairs.
    name: Identifier. The name of the Kafka Connect cluster. Structured like:
      projects/{project_number}/locations/{location}/connectClusters/{connect_
      cluster_id}
    state: Output only. The current state of the cluster.
    updateTime: Output only. The time when the cluster was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the cluster.

    Values:
      STATE_UNSPECIFIED: A state was not specified.
      CREATING: The cluster is being created.
      ACTIVE: The cluster is active.
      DELETING: The cluster is being deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigValue(_messages.Message):
    r"""Optional. Configurations for the worker that are overridden from the
    defaults. The key of the map is a Kafka Connect worker property name, for
    example: `exactly.once.source.support`.

    Messages:
      AdditionalProperty: An additional property for a ConfigValue object.

    Fields:
      additionalProperties: Additional properties of type ConfigValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  capacityConfig = _messages.MessageField('CapacityConfig', 1)
  config = _messages.MessageField('ConfigValue', 2)
  createTime = _messages.StringField(3)
  gcpConfig = _messages.MessageField('ConnectGcpConfig', 4)
  kafkaCluster = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  updateTime = _messages.StringField(9)


class ConnectGcpConfig(_messages.Message):
  r"""Configuration properties for a Kafka Connect cluster deployed to Google
  Cloud Platform.

  Fields:
    accessConfig: Required. Access configuration for the Kafka Connect
      cluster.
    secretPaths: Optional. Secrets to load into workers. Exact SecretVersions
      from Secret Manager must be provided -- aliases are not supported. Up to
      32 secrets may be loaded into one cluster. Format:
      projects//secrets//versions/
  """

  accessConfig = _messages.MessageField('ConnectAccessConfig', 1)
  secretPaths = _messages.StringField(2, repeated=True)


class ConnectNetworkConfig(_messages.Message):
  r"""The configuration of a Virtual Private Cloud (VPC) network that can
  access the Kafka Connect cluster.

  Fields:
    additionalSubnets: Optional. Additional subnets may be specified. They may
      be in another region, but must be in the same VPC network. The Connect
      workers can communicate with network endpoints in either the primary or
      additional subnets.
    dnsDomainNames: Optional. Additional DNS domain names from the subnet's
      network to be made visible to the Connect Cluster. When using
      MirrorMaker2, it's necessary to add the bootstrap address's dns domain
      name of the target cluster to make it visible to the connector. For
      example: my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog
    primarySubnet: Required. VPC subnet to make available to the Kafka Connect
      cluster. Structured like:
      projects/{project}/regions/{region}/subnetworks/{subnet_id} It is used
      to create a Private Service Connect (PSC) interface for the Kafka
      Connect workers. It must be located in the same region as the Kafka
      Connect cluster. The CIDR range of the subnet must be within the IPv4
      address ranges for private networks, as specified in RFC 1918. The
      primary subnet CIDR range must have a minimum size of /22 (1024
      addresses).
  """

  additionalSubnets = _messages.StringField(1, repeated=True)
  dnsDomainNames = _messages.StringField(2, repeated=True)
  primarySubnet = _messages.StringField(3)


class Connector(_messages.Message):
  r"""A Kafka Connect connector in a given ConnectCluster.

  Enums:
    StateValueValuesEnum: Output only. The current state of the connector.

  Messages:
    ConfigsValue: Optional. Connector config as keys/values. The keys of the
      map are connector property names, for example: `connector.class`,
      `tasks.max`, `key.converter`.

  Fields:
    configs: Optional. Connector config as keys/values. The keys of the map
      are connector property names, for example: `connector.class`,
      `tasks.max`, `key.converter`.
    name: Identifier. The name of the connector. Structured like: projects/{pr
      oject}/locations/{location}/connectClusters/{connect_cluster}/connectors
      /{connector}
    state: Output only. The current state of the connector.
    taskRestartPolicy: Optional. Restarts the individual tasks of a Connector.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the connector.

    Values:
      STATE_UNSPECIFIED: A state was not specified.
      UNASSIGNED: The connector is not assigned to any tasks, usually
        transient.
      RUNNING: The connector is running.
      PAUSED: The connector has been paused.
      FAILED: The connector has failed. See logs for why.
      RESTARTING: The connector is restarting.
      STOPPED: The connector has been stopped.
    """
    STATE_UNSPECIFIED = 0
    UNASSIGNED = 1
    RUNNING = 2
    PAUSED = 3
    FAILED = 4
    RESTARTING = 5
    STOPPED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigsValue(_messages.Message):
    r"""Optional. Connector config as keys/values. The keys of the map are
    connector property names, for example: `connector.class`, `tasks.max`,
    `key.converter`.

    Messages:
      AdditionalProperty: An additional property for a ConfigsValue object.

    Fields:
      additionalProperties: Additional properties of type ConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  configs = _messages.MessageField('ConfigsValue', 1)
  name = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  taskRestartPolicy = _messages.MessageField('TaskRetryPolicy', 4)


class ConsumerGroup(_messages.Message):
  r"""A Kafka consumer group in a given cluster.

  Messages:
    TopicsValue: Optional. Metadata for this consumer group for all topics it
      has metadata for. The key of the map is a topic name, structured like: p
      rojects/{project}/locations/{location}/clusters/{cluster}/topics/{topic}

  Fields:
    name: Identifier. The name of the consumer group. The `consumer_group`
      segment is used when connecting directly to the cluster. Structured
      like: projects/{project}/locations/{location}/clusters/{cluster}/consume
      rGroups/{consumer_group}
    topics: Optional. Metadata for this consumer group for all topics it has
      metadata for. The key of the map is a topic name, structured like: proje
      cts/{project}/locations/{location}/clusters/{cluster}/topics/{topic}
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TopicsValue(_messages.Message):
    r"""Optional. Metadata for this consumer group for all topics it has
    metadata for. The key of the map is a topic name, structured like:
    projects/{project}/locations/{location}/clusters/{cluster}/topics/{topic}

    Messages:
      AdditionalProperty: An additional property for a TopicsValue object.

    Fields:
      additionalProperties: Additional properties of type TopicsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TopicsValue object.

      Fields:
        key: Name of the additional property.
        value: A ConsumerTopicMetadata attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ConsumerTopicMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  name = _messages.StringField(1)
  topics = _messages.MessageField('TopicsValue', 2)


class ConsumerPartitionMetadata(_messages.Message):
  r"""Metadata for a consumer group corresponding to a specific partition.

  Fields:
    metadata: Optional. The associated metadata for this partition, or empty
      if it does not exist.
    offset: Required. The current offset for this partition, or 0 if no offset
      has been committed.
  """

  metadata = _messages.StringField(1)
  offset = _messages.IntegerField(2)


class ConsumerTopicMetadata(_messages.Message):
  r"""Metadata for a consumer group corresponding to a specific topic.

  Messages:
    PartitionsValue: Optional. Metadata for this consumer group and topic for
      all partition indexes it has metadata for.

  Fields:
    partitions: Optional. Metadata for this consumer group and topic for all
      partition indexes it has metadata for.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PartitionsValue(_messages.Message):
    r"""Optional. Metadata for this consumer group and topic for all partition
    indexes it has metadata for.

    Messages:
      AdditionalProperty: An additional property for a PartitionsValue object.

    Fields:
      additionalProperties: Additional properties of type PartitionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PartitionsValue object.

      Fields:
        key: Name of the additional property.
        value: A ConsumerPartitionMetadata attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ConsumerPartitionMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  partitions = _messages.MessageField('PartitionsValue', 1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GcpConfig(_messages.Message):
  r"""Configuration properties for a Kafka cluster deployed to Google Cloud
  Platform.

  Fields:
    accessConfig: Required. Access configuration for the Kafka cluster.
    kmsKey: Optional. Immutable. The Cloud KMS Key name to use for encryption.
      The key must be located in the same region as the cluster and cannot be
      changed. Structured like: projects/{project}/locations/{location}/keyRin
      gs/{key_ring}/cryptoKeys/{crypto_key}.
  """

  accessConfig = _messages.MessageField('AccessConfig', 1)
  kmsKey = _messages.StringField(2)


class ListClustersResponse(_messages.Message):
  r"""Response for ListClusters.

  Fields:
    clusters: The list of Clusters in the requested parent.
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page of results. If this field is omitted, there are no more
      results.
    unreachable: Locations that could not be reached.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListConnectClustersResponse(_messages.Message):
  r"""Response for ListConnectClusters.

  Fields:
    connectClusters: The list of Connect clusters in the requested parent.
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page of results. If this field is omitted, there are no more
      results.
    unreachable: Locations that could not be reached.
  """

  connectClusters = _messages.MessageField('ConnectCluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListConnectorsResponse(_messages.Message):
  r"""Response for ListConnectors.

  Fields:
    connectors: The list of connectors in the requested parent.
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page of results. If this field is omitted, there are no more
      results.
  """

  connectors = _messages.MessageField('Connector', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListConsumerGroupsResponse(_messages.Message):
  r"""Response for ListConsumerGroups.

  Fields:
    consumerGroups: The list of consumer group in the requested parent. The
      order of the consumer groups is unspecified.
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page of results. If this field is omitted, there are no more
      results.
  """

  consumerGroups = _messages.MessageField('ConsumerGroup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListTopicsResponse(_messages.Message):
  r"""Response for ListTopics.

  Fields:
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page of results. If this field is omitted, there are no more
      results.
    topics: The list of topics in the requested parent. The order of the
      topics is unspecified.
  """

  nextPageToken = _messages.StringField(1)
  topics = _messages.MessageField('Topic', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ManagedkafkaProjectsLocationsClustersConsumerGroupsDeleteRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersConsumerGroupsDeleteRequest
  object.

  Fields:
    name: Required. The name of the consumer group to delete. `projects/{proje
      ct}/locations/{location}/clusters/{cluster}/consumerGroups/{consumerGrou
      p}`.
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsClustersConsumerGroupsGetRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersConsumerGroupsGetRequest object.

  Fields:
    name: Required. The name of the consumer group whose configuration to
      return. `projects/{project}/locations/{location}/clusters/{cluster}/cons
      umerGroups/{consumerGroup}`.
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsClustersConsumerGroupsListRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersConsumerGroupsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of consumer groups to return. The
      service may return fewer than this value. If unset or zero, all consumer
      groups for the parent is returned.
    pageToken: Optional. A page token, received from a previous
      `ListConsumerGroups` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListConsumerGroups`
      must match the call that provided the page token.
    parent: Required. The parent cluster whose consumer groups are to be
      listed. Structured like
      `projects/{project}/locations/{location}/clusters/{cluster}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ManagedkafkaProjectsLocationsClustersConsumerGroupsPatchRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersConsumerGroupsPatchRequest
  object.

  Fields:
    consumerGroup: A ConsumerGroup resource to be passed as the request body.
    name: Identifier. The name of the consumer group. The `consumer_group`
      segment is used when connecting directly to the cluster. Structured
      like: projects/{project}/locations/{location}/clusters/{cluster}/consume
      rGroups/{consumer_group}
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the ConsumerGroup resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. The mask is
      required and a value of * will update all fields.
  """

  consumerGroup = _messages.MessageField('ConsumerGroup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ManagedkafkaProjectsLocationsClustersCreateRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: Required. The ID to use for the cluster, which will become the
      final component of the cluster's name. The ID must be 1-63 characters
      long, and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to
      comply with RFC 1035. This value is structured like: `my-cluster-id`.
    parent: Required. The parent region in which to create the cluster.
      Structured like `projects/{project}/locations/{location}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID to avoid duplication of requests. If a request times
      out or fails, retrying with the same ID allows the server to recognize
      the previous attempt. For at least 60 minutes, the server ignores
      duplicate requests bearing the same ID. For example, consider a
      situation where you make an initial request and the request times out.
      If you make the request again with the same request ID within 60 minutes
      of the last request, the server checks if an original operation with the
      same request ID was received. If so, the server ignores the second
      request. The request ID must be a valid UUID. A zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ManagedkafkaProjectsLocationsClustersDeleteRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersDeleteRequest object.

  Fields:
    name: Required. The name of the cluster to delete.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID to avoid duplication of requests. If a request times
      out or fails, retrying with the same ID allows the server to recognize
      the previous attempt. For at least 60 minutes, the server ignores
      duplicate requests bearing the same ID. For example, consider a
      situation where you make an initial request and the request times out.
      If you make the request again with the same request ID within 60 minutes
      of the last request, the server checks if an original operation with the
      same request ID was received. If so, the server ignores the second
      request. The request ID must be a valid UUID. A zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ManagedkafkaProjectsLocationsClustersGetRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersGetRequest object.

  Fields:
    name: Required. The name of the cluster whose configuration to return.
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsClustersListRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersListRequest object.

  Fields:
    filter: Optional. Filter expression for the result.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. The maximum number of clusters to return. The service
      may return fewer than this value. If unspecified, server will pick an
      appropriate default.
    pageToken: Optional. A page token, received from a previous `ListClusters`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListClusters` must match the call that
      provided the page token.
    parent: Required. The parent location whose clusters are to be listed.
      Structured like `projects/{project}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedkafkaProjectsLocationsClustersPatchRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    name: Identifier. The name of the cluster. Structured like:
      projects/{project_number}/locations/{location}/clusters/{cluster_id}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID to avoid duplication of requests. If a request times
      out or fails, retrying with the same ID allows the server to recognize
      the previous attempt. For at least 60 minutes, the server ignores
      duplicate requests bearing the same ID. For example, consider a
      situation where you make an initial request and the request times out.
      If you make the request again with the same request ID within 60 minutes
      of the last request, the server checks if an original operation with the
      same request ID was received. If so, the server ignores the second
      request. The request ID must be a valid UUID. A zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the cluster resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. The mask is required and
      a value of * will update all fields.
  """

  cluster = _messages.MessageField('Cluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ManagedkafkaProjectsLocationsClustersTopicsCreateRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersTopicsCreateRequest object.

  Fields:
    parent: Required. The parent cluster in which to create the topic.
      Structured like
      `projects/{project}/locations/{location}/clusters/{cluster}`.
    topic: A Topic resource to be passed as the request body.
    topicId: Required. The ID to use for the topic, which will become the
      final component of the topic's name. This value is structured like: `my-
      topic-name`.
  """

  parent = _messages.StringField(1, required=True)
  topic = _messages.MessageField('Topic', 2)
  topicId = _messages.StringField(3)


class ManagedkafkaProjectsLocationsClustersTopicsDeleteRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersTopicsDeleteRequest object.

  Fields:
    name: Required. The name of the topic to delete. `projects/{project}/locat
      ions/{location}/clusters/{cluster}/topics/{topic}`.
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsClustersTopicsGetRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersTopicsGetRequest object.

  Fields:
    name: Required. The name of the topic whose configuration to return.
      Structured like: projects/{project}/locations/{location}/clusters/{clust
      er}/topics/{topic}.
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsClustersTopicsListRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersTopicsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of topics to return. The service
      may return fewer than this value. If unset or zero, all topics for the
      parent is returned.
    pageToken: Optional. A page token, received from a previous `ListTopics`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListTopics` must match the call that
      provided the page token.
    parent: Required. The parent cluster whose topics are to be listed.
      Structured like
      `projects/{project}/locations/{location}/clusters/{cluster}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ManagedkafkaProjectsLocationsClustersTopicsPatchRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsClustersTopicsPatchRequest object.

  Fields:
    name: Identifier. The name of the topic. The `topic` segment is used when
      connecting directly to the cluster. Structured like: projects/{project}/
      locations/{location}/clusters/{cluster}/topics/{topic}
    topic: A Topic resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Topic resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. The mask is required and
      a value of * will update all fields.
  """

  name = _messages.StringField(1, required=True)
  topic = _messages.MessageField('Topic', 2)
  updateMask = _messages.StringField(3)


class ManagedkafkaProjectsLocationsConnectClustersConnectorsCreateRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersConnectorsCreateRequest
  object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    connectorId: Required. The ID to use for the connector, which will become
      the final component of the connector's name. The ID must be 1-63
      characters long, and match the regular expression
      `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with RFC 1035. This value is
      structured like: `my-connector-id`.
    parent: Required. The parent Connect cluster in which to create the
      connector. Structured like `projects/{project}/locations/{location}/conn
      ectClusters/{connect_cluster_id}`.
  """

  connector = _messages.MessageField('Connector', 1)
  connectorId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ManagedkafkaProjectsLocationsConnectClustersConnectorsDeleteRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersConnectorsDeleteRequest
  object.

  Fields:
    name: Required. The name of the connector to delete. Structured like: proj
      ects/{project}/locations/{location}/connectClusters/{connectCluster}/con
      nectors/{connector}
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsConnectClustersConnectorsGetRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersConnectorsGetRequest
  object.

  Fields:
    name: Required. The name of the connector whose configuration to return.
      Structured like: projects/{project}/locations/{location}/connectClusters
      /{connectCluster}/connectors/{connector}
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsConnectClustersConnectorsListRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersConnectorsListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of connectors to return. The
      service may return fewer than this value. If unspecified, server will
      pick an appropriate default.
    pageToken: Optional. A page token, received from a previous
      `ListConnectors` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListConnectors` must
      match the call that provided the page token.
    parent: Required. The parent Connect cluster whose connectors are to be
      listed. Structured like `projects/{project}/locations/{location}/connect
      Clusters/{connect_cluster_id}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ManagedkafkaProjectsLocationsConnectClustersConnectorsPatchRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersConnectorsPatchRequest
  object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    name: Identifier. The name of the connector. Structured like: projects/{pr
      oject}/locations/{location}/connectClusters/{connect_cluster}/connectors
      /{connector}
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the cluster resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. The mask is required and
      a value of * will update all fields.
  """

  connector = _messages.MessageField('Connector', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ManagedkafkaProjectsLocationsConnectClustersConnectorsPauseRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersConnectorsPauseRequest
  object.

  Fields:
    name: Required. The name of the connector to pause. Structured like: proje
      cts/{project}/locations/{location}/connectClusters/{connectCluster}/conn
      ectors/{connector}
    pauseConnectorRequest: A PauseConnectorRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  pauseConnectorRequest = _messages.MessageField('PauseConnectorRequest', 2)


class ManagedkafkaProjectsLocationsConnectClustersConnectorsRestartRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersConnectorsRestartRequest
  object.

  Fields:
    name: Required. The name of the connector to restart. Structured like: pro
      jects/{project}/locations/{location}/connectClusters/{connectCluster}/co
      nnectors/{connector}
    restartConnectorRequest: A RestartConnectorRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  restartConnectorRequest = _messages.MessageField('RestartConnectorRequest', 2)


class ManagedkafkaProjectsLocationsConnectClustersConnectorsResumeRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersConnectorsResumeRequest
  object.

  Fields:
    name: Required. The name of the connector to pause. Structured like: proje
      cts/{project}/locations/{location}/connectClusters/{connectCluster}/conn
      ectors/{connector}
    resumeConnectorRequest: A ResumeConnectorRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  resumeConnectorRequest = _messages.MessageField('ResumeConnectorRequest', 2)


class ManagedkafkaProjectsLocationsConnectClustersConnectorsStopRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersConnectorsStopRequest
  object.

  Fields:
    name: Required. The name of the connector to stop. Structured like: projec
      ts/{project}/locations/{location}/connectClusters/{connectCluster}/conne
      ctors/{connector}
    stopConnectorRequest: A StopConnectorRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  stopConnectorRequest = _messages.MessageField('StopConnectorRequest', 2)


class ManagedkafkaProjectsLocationsConnectClustersCreateRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersCreateRequest object.

  Fields:
    connectCluster: A ConnectCluster resource to be passed as the request
      body.
    connectClusterId: Required. The ID to use for the Connect cluster, which
      will become the final component of the cluster's name. The ID must be
      1-63 characters long, and match the regular expression
      `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with RFC 1035. This value is
      structured like: `my-cluster-id`.
    parent: Required. The parent project/location in which to create the Kafka
      Connect cluster. Structured like
      `projects/{project}/locations/{location}/`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID to avoid duplication of requests. If a request times
      out or fails, retrying with the same ID allows the server to recognize
      the previous attempt. For at least 60 minutes, the server ignores
      duplicate requests bearing the same ID. For example, consider a
      situation where you make an initial request and the request times out.
      If you make the request again with the same request ID within 60 minutes
      of the last request, the server checks if an original operation with the
      same request ID was received. If so, the server ignores the second
      request. The request ID must be a valid UUID. A zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  connectCluster = _messages.MessageField('ConnectCluster', 1)
  connectClusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ManagedkafkaProjectsLocationsConnectClustersDeleteRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersDeleteRequest object.

  Fields:
    name: Required. The name of the Kafka Connect cluster to delete.
      Structured like `projects/{project}/locations/{location}/connectClusters
      /{connect_cluster_id}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID to avoid duplication of requests. If a request times
      out or fails, retrying with the same ID allows the server to recognize
      the previous attempt. For at least 60 minutes, the server ignores
      duplicate requests bearing the same ID. For example, consider a
      situation where you make an initial request and the request times out.
      If you make the request again with the same request ID within 60 minutes
      of the last request, the server checks if an original operation with the
      same request ID was received. If so, the server ignores the second
      request. The request ID must be a valid UUID. A zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ManagedkafkaProjectsLocationsConnectClustersGetRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersGetRequest object.

  Fields:
    name: Required. The name of the Kafka Connect cluster whose configuration
      to return. Structured like `projects/{project}/locations/{location}/conn
      ectClusters/{connect_cluster_id}`.
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsConnectClustersListRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersListRequest object.

  Fields:
    filter: Optional. Filter expression for the result.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. The maximum number of Connect clusters to return. The
      service may return fewer than this value. If unspecified, server will
      pick an appropriate default.
    pageToken: Optional. A page token, received from a previous
      `ListConnectClusters` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListConnectClusters` must match the call that provided the page token.
    parent: Required. The parent project/location whose Connect clusters are
      to be listed. Structured like `projects/{project}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedkafkaProjectsLocationsConnectClustersPatchRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsConnectClustersPatchRequest object.

  Fields:
    connectCluster: A ConnectCluster resource to be passed as the request
      body.
    name: Identifier. The name of the Kafka Connect cluster. Structured like:
      projects/{project_number}/locations/{location}/connectClusters/{connect_
      cluster_id}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID to avoid duplication of requests. If a request times
      out or fails, retrying with the same ID allows the server to recognize
      the previous attempt. For at least 60 minutes, the server ignores
      duplicate requests bearing the same ID. For example, consider a
      situation where you make an initial request and the request times out.
      If you make the request again with the same request ID within 60 minutes
      of the last request, the server checks if an original operation with the
      same request ID was received. If so, the server ignores the second
      request. The request ID must be a valid UUID. A zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the cluster resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. The mask is required and
      a value of * will update all fields.
  """

  connectCluster = _messages.MessageField('ConnectCluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ManagedkafkaProjectsLocationsGetRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsListRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ManagedkafkaProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ManagedkafkaProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ManagedkafkaProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ManagedkafkaProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetworkConfig(_messages.Message):
  r"""The configuration of a Virtual Private Cloud (VPC) network that can
  access the Kafka cluster.

  Fields:
    subnet: Required. Name of the VPC subnet in which to create Private
      Service Connect (PSC) endpoints for the Kafka brokers and bootstrap
      address. Structured like:
      projects/{project}/regions/{region}/subnetworks/{subnet_id} The subnet
      must be located in the same region as the Kafka cluster. The project may
      differ. Multiple subnets from the same parent network must not be
      specified.
  """

  subnet = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class PauseConnectorRequest(_messages.Message):
  r"""Request for PauseConnector."""


class PauseConnectorResponse(_messages.Message):
  r"""Response for PauseConnector."""


class RebalanceConfig(_messages.Message):
  r"""Defines rebalancing behavior of a Kafka cluster.

  Enums:
    ModeValueValuesEnum: Optional. The rebalance behavior for the cluster.
      When not specified, defaults to `NO_REBALANCE`.

  Fields:
    mode: Optional. The rebalance behavior for the cluster. When not
      specified, defaults to `NO_REBALANCE`.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Optional. The rebalance behavior for the cluster. When not specified,
    defaults to `NO_REBALANCE`.

    Values:
      MODE_UNSPECIFIED: A mode was not specified. Do not use.
      NO_REBALANCE: Do not rebalance automatically.
      AUTO_REBALANCE_ON_SCALE_UP: Automatically rebalance topic partitions
        among brokers when the cluster is scaled up.
    """
    MODE_UNSPECIFIED = 0
    NO_REBALANCE = 1
    AUTO_REBALANCE_ON_SCALE_UP = 2

  mode = _messages.EnumField('ModeValueValuesEnum', 1)


class RestartConnectorRequest(_messages.Message):
  r"""Request for RestartConnector."""


class RestartConnectorResponse(_messages.Message):
  r"""Response for RestartConnector."""


class ResumeConnectorRequest(_messages.Message):
  r"""Request for ResumeConnector."""


class ResumeConnectorResponse(_messages.Message):
  r"""Response for ResumeConnector."""


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StopConnectorRequest(_messages.Message):
  r"""Request for StopConnector."""


class StopConnectorResponse(_messages.Message):
  r"""Response for StopConnector."""


class TaskRetryPolicy(_messages.Message):
  r"""Task Retry Policy is implemented on a best-effort basis. Retry delay
  will be exponential based on provided minimum and maximum backoffs.
  https://en.wikipedia.org/wiki/Exponential_backoff. Note that the delay
  between consecutive task restarts may not always precisely match the
  configured settings. This can happen when the ConnectCluster is in
  rebalancing state or if the ConnectCluster is unresponsive etc.

  Fields:
    maximumBackoff: Optional. The maximum amount of time to wait before
      retrying a failed task. This sets an upper bound for the backoff delay.
    minimumBackoff: Optional. The minimum amount of time to wait before
      retrying a failed task. This sets a lower bound for the backoff delay.
  """

  maximumBackoff = _messages.StringField(1)
  minimumBackoff = _messages.StringField(2)


class Topic(_messages.Message):
  r"""A Kafka topic in a given cluster.

  Messages:
    ConfigsValue: Optional. Configurations for the topic that are overridden
      from the cluster defaults. The key of the map is a Kafka topic property
      name, for example: `cleanup.policy`, `compression.type`.

  Fields:
    configs: Optional. Configurations for the topic that are overridden from
      the cluster defaults. The key of the map is a Kafka topic property name,
      for example: `cleanup.policy`, `compression.type`.
    name: Identifier. The name of the topic. The `topic` segment is used when
      connecting directly to the cluster. Structured like: projects/{project}/
      locations/{location}/clusters/{cluster}/topics/{topic}
    partitionCount: Required. The number of partitions this topic has. The
      partition count can only be increased, not decreased. Please note that
      if partitions are increased for a topic that has a key, the partitioning
      logic or the ordering of the messages will be affected.
    replicationFactor: Required. Immutable. The number of replicas of each
      partition. A replication factor of 3 is recommended for high
      availability.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigsValue(_messages.Message):
    r"""Optional. Configurations for the topic that are overridden from the
    cluster defaults. The key of the map is a Kafka topic property name, for
    example: `cleanup.policy`, `compression.type`.

    Messages:
      AdditionalProperty: An additional property for a ConfigsValue object.

    Fields:
      additionalProperties: Additional properties of type ConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  configs = _messages.MessageField('ConfigsValue', 1)
  name = _messages.StringField(2)
  partitionCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  replicationFactor = _messages.IntegerField(4, variant=_messages.Variant.INT32)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
