"""Generated message classes for storagebatchoperations version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'storagebatchoperations'


class CancelJobRequest(_messages.Message):
  r"""Message for Job to Cancel

  Fields:
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request. Requests
      with same `request_id` will ignored for least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class CancelJobResponse(_messages.Message):
  r"""Message for response to cancel Job."""


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Counters(_messages.Message):
  r"""Describes details about the progress of the job.

  Fields:
    failedObjectCount: Output only. Number of objects failed.
    succeededObjectCount: Output only. Number of objects completed.
    totalObjectCount: Output only. Number of objects listed.
  """

  failedObjectCount = _messages.IntegerField(1)
  succeededObjectCount = _messages.IntegerField(2)
  totalObjectCount = _messages.IntegerField(3)


class DeleteObject(_messages.Message):
  r"""Describes options to delete an object.

  Fields:
    permanentObjectDeletionEnabled: Required. Controls deletion behavior when
      versioning is enabled for the object's bucket. If true both live and
      noncurrent objects will be permanently deleted. Otherwise live objects
      in versioned buckets will become noncurrent and objects that were
      already noncurrent will be skipped. This setting doesn't have any impact
      on the Soft Delete feature. All objects deleted by this service can be
      be restored for the duration of the Soft Delete retention duration if
      enabled.
  """

  permanentObjectDeletionEnabled = _messages.BooleanField(1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ErrorLogEntry(_messages.Message):
  r"""An entry describing an error that has occurred.

  Fields:
    errorDetails: Optional. Output only. At most 5 error log entries are
      recorded for a given error code for a job.
    objectUri: Required. Output only. Object URL. e.g.
      gs://my_bucket/object.txt
  """

  errorDetails = _messages.StringField(1, repeated=True)
  objectUri = _messages.StringField(2)


class ErrorSummary(_messages.Message):
  r"""A summary of errors by error code, plus a count and sample error log
  entries.

  Enums:
    ErrorCodeValueValuesEnum: Required. The canonical error code.

  Fields:
    errorCode: Required. The canonical error code.
    errorCount: Required. Number of errors encountered per `error_code`.
    errorLogEntries: Required. Sample error logs.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Required. The canonical error code.

    Values:
      OK: Not an error; returned on success. HTTP Mapping: 200 OK
      CANCELLED: The operation was cancelled, typically by the caller. HTTP
        Mapping: 499 Client Closed Request
      UNKNOWN: Unknown error. For example, this error may be returned when a
        `Status` value received from another address space belongs to an error
        space that is not known in this address space. Also errors raised by
        APIs that do not return enough error information may be converted to
        this error. HTTP Mapping: 500 Internal Server Error
      INVALID_ARGUMENT: The client specified an invalid argument. Note that
        this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT` indicates
        arguments that are problematic regardless of the state of the system
        (e.g., a malformed file name). HTTP Mapping: 400 Bad Request
      DEADLINE_EXCEEDED: The deadline expired before the operation could
        complete. For operations that change the state of the system, this
        error may be returned even if the operation has completed
        successfully. For example, a successful response from a server could
        have been delayed long enough for the deadline to expire. HTTP
        Mapping: 504 Gateway Timeout
      NOT_FOUND: Some requested entity (e.g., file or directory) was not
        found. Note to server developers: if a request is denied for an entire
        class of users, such as gradual feature rollout or undocumented
        allowlist, `NOT_FOUND` may be used. If a request is denied for some
        users within a class of users, such as user-based access control,
        `PERMISSION_DENIED` must be used. HTTP Mapping: 404 Not Found
      ALREADY_EXISTS: The entity that a client attempted to create (e.g., file
        or directory) already exists. HTTP Mapping: 409 Conflict
      PERMISSION_DENIED: The caller does not have permission to execute the
        specified operation. `PERMISSION_DENIED` must not be used for
        rejections caused by exhausting some resource (use
        `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
        must not be used if the caller can not be identified (use
        `UNAUTHENTICATED` instead for those errors). This error code does not
        imply the request is valid or the requested entity exists or satisfies
        other pre-conditions. HTTP Mapping: 403 Forbidden
      UNAUTHENTICATED: The request does not have valid authentication
        credentials for the operation. HTTP Mapping: 401 Unauthorized
      RESOURCE_EXHAUSTED: Some resource has been exhausted, perhaps a per-user
        quota, or perhaps the entire file system is out of space. HTTP
        Mapping: 429 Too Many Requests
      FAILED_PRECONDITION: The operation was rejected because the system is
        not in a state required for the operation's execution. For example,
        the directory to be deleted is non-empty, an rmdir operation is
        applied to a non-directory, etc. Service implementors can use the
        following guidelines to decide between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`: (a) Use `UNAVAILABLE` if the client can
        retry just the failing call. (b) Use `ABORTED` if the client should
        retry at a higher level. For example, when a client-specified test-
        and-set fails, indicating the client should restart a read-modify-
        write sequence. (c) Use `FAILED_PRECONDITION` if the client should not
        retry until the system state has been explicitly fixed. For example,
        if an "rmdir" fails because the directory is non-empty,
        `FAILED_PRECONDITION` should be returned since the client should not
        retry unless the files are deleted from the directory. HTTP Mapping:
        400 Bad Request
      ABORTED: The operation was aborted, typically due to a concurrency issue
        such as a sequencer check failure or transaction abort. See the
        guidelines above for deciding between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 409 Conflict
      OUT_OF_RANGE: The operation was attempted past the valid range. E.g.,
        seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`, this
        error indicates a problem that may be fixed if the system state
        changes. For example, a 32-bit file system will generate
        `INVALID_ARGUMENT` if asked to read at an offset that is not in the
        range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to read
        from an offset past the current file size. There is a fair bit of
        overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`. We recommend
        using `OUT_OF_RANGE` (the more specific error) when it applies so that
        callers who are iterating through a space can easily look for an
        `OUT_OF_RANGE` error to detect when they are done. HTTP Mapping: 400
        Bad Request
      UNIMPLEMENTED: The operation is not implemented or is not
        supported/enabled in this service. HTTP Mapping: 501 Not Implemented
      INTERNAL: Internal errors. This means that some invariants expected by
        the underlying system have been broken. This error code is reserved
        for serious errors. HTTP Mapping: 500 Internal Server Error
      UNAVAILABLE: The service is currently unavailable. This is most likely a
        transient condition, which can be corrected by retrying with a
        backoff. Note that it is not always safe to retry non-idempotent
        operations. See the guidelines above for deciding between
        `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 503
        Service Unavailable
      DATA_LOSS: Unrecoverable data loss or corruption. HTTP Mapping: 500
        Internal Server Error
    """
    OK = 0
    CANCELLED = 1
    UNKNOWN = 2
    INVALID_ARGUMENT = 3
    DEADLINE_EXCEEDED = 4
    NOT_FOUND = 5
    ALREADY_EXISTS = 6
    PERMISSION_DENIED = 7
    UNAUTHENTICATED = 8
    RESOURCE_EXHAUSTED = 9
    FAILED_PRECONDITION = 10
    ABORTED = 11
    OUT_OF_RANGE = 12
    UNIMPLEMENTED = 13
    INTERNAL = 14
    UNAVAILABLE = 15
    DATA_LOSS = 16

  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 1)
  errorCount = _messages.IntegerField(2)
  errorLogEntries = _messages.MessageField('ErrorLogEntry', 3, repeated=True)


class Job(_messages.Message):
  r"""The Storage Batch Operations Job description.

  Enums:
    StateValueValuesEnum: Output only. State of the job.

  Fields:
    completeTime: Output only. The time that the job was completed.
    counters: Output only. Information about the progress of the job.
    createTime: Output only. The time that the job was created.
    deleteObject: Delete objects.
    description: Optional. A description provided by the user for the job. Its
      max length is 1024 bytes when Unicode-encoded.
    errorSummaries: Output only. Summarizes errors encountered with sample
      error log entries.
    manifest: Manifest specifies list of objects to be transformed.
    name: Identifier. The resource name of the Job. job_id is unique within
      the project and location, that is either set by the customer or defined
      by the service. Format:
      projects/{project}/locations/{location}/jobs/{job_id} . For example:
      "projects/123456/locations/us-central1/jobs/job01".
    prefixList: Specifies prefixes of objects to be transformed. Note:
      `prefix_list` must belong to the same bucket.
    putKmsKey: Update objects KMS key.
    putMetadata: Updates object metadata. Allows updating fixed-key and custom
      metadata and fixed-key metadata i.e. Cache-Control, Content-Disposition,
      Content-Encoding, Content-Language, Content-Type, Custom-Time.
    putObjectHold: Changes object hold status.
    scheduleTime: Output only. The time that the job was scheduled.
    state: Output only. State of the job.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the job.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      RUNNING: In progress.
      SUCCEEDED: Completed successfully.
      CANCELED: Cancelled by the user.
      FAILED: Terminated due to an unrecoverable failure.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    SUCCEEDED = 2
    CANCELED = 3
    FAILED = 4

  completeTime = _messages.StringField(1)
  counters = _messages.MessageField('Counters', 2)
  createTime = _messages.StringField(3)
  deleteObject = _messages.MessageField('DeleteObject', 4)
  description = _messages.StringField(5)
  errorSummaries = _messages.MessageField('ErrorSummary', 6, repeated=True)
  manifest = _messages.MessageField('Manifest', 7)
  name = _messages.StringField(8)
  prefixList = _messages.MessageField('PrefixList', 9)
  putKmsKey = _messages.MessageField('PutKmsKey', 10)
  putMetadata = _messages.MessageField('PutMetadata', 11)
  putObjectHold = _messages.MessageField('PutObjectHold', 12)
  scheduleTime = _messages.StringField(13)
  state = _messages.EnumField('StateValueValuesEnum', 14)


class ListJobsResponse(_messages.Message):
  r"""Message for response to listing Jobs

  Fields:
    jobs: A list of storage batch jobs.
    nextPageToken: A token identifying a page of results.
    unreachable: Locations that could not be reached.
  """

  jobs = _messages.MessageField('Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Manifest(_messages.Message):
  r"""Describes list of objects to be transformed.

  Fields:
    manifestLocation: Required. `manifest_location` must contain the manifest
      source file is a CSV file in a Google Cloud Storage bucket. Each row in
      the file must include the object details i.e. ProjectId, BucketId and
      Name. Generation may optionally be specified, when it is not specified
      the live object is acted upon. `manifest_location` must be an absolute
      path to the object. NOTE: All the objects must belong to the same
      bucket. Format: gs://bucket_name/path/object_name.csv.
  """

  manifestLocation = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    job: Output only. The Job associated with the operation.
    jobDeprecated: Output only.
    operation: Output only. The unique operation resource name. Format:
      projects/{project}/locations/{location}/operations/{operation}.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  job = _messages.MessageField('Job', 4)
  jobDeprecated = _messages.StringField(5)
  operation = _messages.StringField(6)
  requestedCancellation = _messages.BooleanField(7)


class Prefix(_messages.Message):
  r"""Describes prefix of objects to be transformed.

  Fields:
    bucket: Optional. Bucket name on which batch ops is being performed Note:
      Only one bucket is supported for v1. For future versions we will extend
      this to multi bucket.
    objectPrefix: Optional. object must be in the `bucket`. * Supports full
      object name * Supports prefix of the object name * Wildcards are not
      supported * Supports empty string for all objects in a bucket.
  """

  bucket = _messages.StringField(1)
  objectPrefix = _messages.StringField(2)


class PrefixList(_messages.Message):
  r"""Describes prefixes of objects to be transformed.

  Fields:
    prefixes: Optional. Prefixes of the objects to be transformed. This field
      does not support multiple prefixes. Use `included_object_prefixes`
      instead to specify multiple prefixes.
  """

  prefixes = _messages.MessageField('Prefix', 1, repeated=True)


class PutKmsKey(_messages.Message):
  r"""Describes options for object KMS key update.

  Fields:
    kmsKey: Required. Resource name of the Cloud KMS key that will be used to
      encrypt the object. The Cloud KMS key must be located in same location
      as the object. Refer to
      https://cloud.google.com/storage/docs/encryption/using-customer-managed-
      keys#add-object-key for additional documentation. Format: projects/{proj
      ect}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key} For
      example: "projects/123456/locations/us-central1/keyRings/my-
      keyring/cryptoKeys/my-key".
  """

  kmsKey = _messages.StringField(1)


class PutMetadata(_messages.Message):
  r"""Describes options for object metadata update.

  Messages:
    CustomMetadataValue: Optional. Updates objects custom metadata. Adds or
      sets individual custom metadata key value pairs on objects. Empty custom
      metadata values are ignored. Existing custom metadata not specified with
      this flag is not changed. Refer to documentation in
      https://cloud.google.com/storage/docs/metadata#custom-metadata

  Fields:
    cacheControl: Optional. Updates objects Cache-Control fixed metadata.
      Empty values are ignored. Additionally, the value for Custom-Time cannot
      decrease. Refer to documentation in
      https://cloud.google.com/storage/docs/metadata#caching_data.
    contentDisposition: Optional. Updates objects Content-Disposition fixed
      metadata. Empty values will be ignored. Refer
      https://cloud.google.com/storage/docs/metadata#content-disposition for
      additional documentation.
    contentEncoding: Optional. Updates objects Content-Encoding fixed
      metadata. Empty values will be ignored. Refer to documentation in
      https://cloud.google.com/storage/docs/metadata#content-encoding.
    contentLanguage: Optional. Updates objects Content-Language fixed
      metadata. Refer to ISO 639-1 language codes for typical values of this
      metadata. Max length 100 characters. Empty values are ignored. Refer to
      documentation in https://cloud.google.com/storage/docs/metadata#content-
      language.
    contentType: Optional. Updates objects Content-Type fixed metadata. Refer
      to documentation in
      https://cloud.google.com/storage/docs/metadata#content-type
    customMetadata: Optional. Updates objects custom metadata. Adds or sets
      individual custom metadata key value pairs on objects. Empty custom
      metadata values are ignored. Existing custom metadata not specified with
      this flag is not changed. Refer to documentation in
      https://cloud.google.com/storage/docs/metadata#custom-metadata
    customTime: Optional. Updates objects Custom-Time fixed metadata. Empty
      values are ignored. Refer to documentation in
      https://cloud.google.com/storage/docs/metadata#custom-time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class CustomMetadataValue(_messages.Message):
    r"""Optional. Updates objects custom metadata. Adds or sets individual
    custom metadata key value pairs on objects. Empty custom metadata values
    are ignored. Existing custom metadata not specified with this flag is not
    changed. Refer to documentation in
    https://cloud.google.com/storage/docs/metadata#custom-metadata

    Messages:
      AdditionalProperty: An additional property for a CustomMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type CustomMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a CustomMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cacheControl = _messages.StringField(1)
  contentDisposition = _messages.StringField(2)
  contentEncoding = _messages.StringField(3)
  contentLanguage = _messages.StringField(4)
  contentType = _messages.StringField(5)
  customMetadata = _messages.MessageField('CustomMetadataValue', 6)
  customTime = _messages.StringField(7)


class PutObjectHold(_messages.Message):
  r"""Describes options to update object hold.

  Enums:
    EventBasedHoldValueValuesEnum: Required. Updates object event based holds
      state. When object event based hold is set, object cannot be deleted or
      replaced. Resets object's time in the bucket for the purposes of the
      retention period.
    TemporaryHoldValueValuesEnum: Required. Updates object temporary holds
      state. When object temporary hold is set, object cannot be deleted or
      replaced.

  Fields:
    eventBasedHold: Required. Updates object event based holds state. When
      object event based hold is set, object cannot be deleted or replaced.
      Resets object's time in the bucket for the purposes of the retention
      period.
    temporaryHold: Required. Updates object temporary holds state. When object
      temporary hold is set, object cannot be deleted or replaced.
  """

  class EventBasedHoldValueValuesEnum(_messages.Enum):
    r"""Required. Updates object event based holds state. When object event
    based hold is set, object cannot be deleted or replaced. Resets object's
    time in the bucket for the purposes of the retention period.

    Values:
      HOLD_STATUS_UNSPECIFIED: Default value, Object hold status will not be
        changed.
      SET: Places the hold.
      UNSET: Releases the hold.
    """
    HOLD_STATUS_UNSPECIFIED = 0
    SET = 1
    UNSET = 2

  class TemporaryHoldValueValuesEnum(_messages.Enum):
    r"""Required. Updates object temporary holds state. When object temporary
    hold is set, object cannot be deleted or replaced.

    Values:
      HOLD_STATUS_UNSPECIFIED: Default value, Object hold status will not be
        changed.
      SET: Places the hold.
      UNSET: Releases the hold.
    """
    HOLD_STATUS_UNSPECIFIED = 0
    SET = 1
    UNSET = 2

  eventBasedHold = _messages.EnumField('EventBasedHoldValueValuesEnum', 1)
  temporaryHold = _messages.EnumField('TemporaryHoldValueValuesEnum', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StoragebatchoperationsProjectsLocationsGetRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class StoragebatchoperationsProjectsLocationsJobsCancelRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsJobsCancelRequest object.

  Fields:
    cancelJobRequest: A CancelJobRequest resource to be passed as the request
      body.
    name: Required. The `name` of the job to cancel. Format:
      projects/{project_id}/locations/{location_id}/jobs/{job_id}.
  """

  cancelJobRequest = _messages.MessageField('CancelJobRequest', 1)
  name = _messages.StringField(2, required=True)


class StoragebatchoperationsProjectsLocationsJobsCreateRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsJobsCreateRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    jobId: Required. The optional `job_id` for this Job . If not specified, an
      id is generated. `job_id` should be no more than 128 characters and must
      include only characters available in DNS names, as defined by RFC-1123.
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request. Requests
      with same `request_id` will ignored for least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  job = _messages.MessageField('Job', 1)
  jobId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class StoragebatchoperationsProjectsLocationsJobsDeleteRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsJobsDeleteRequest object.

  Fields:
    name: Required. The `name` of the job to delete. Format:
      projects/{project_id}/locations/{location_id}/jobs/{job_id} .
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request. Requests
      with same `request_id` will ignored for least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class StoragebatchoperationsProjectsLocationsJobsGetRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsJobsGetRequest object.

  Fields:
    name: Required. `name` of the job to retrieve. Format:
      projects/{project_id}/locations/{location_id}/jobs/{job_id} .
  """

  name = _messages.StringField(1, required=True)


class StoragebatchoperationsProjectsLocationsJobsListRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsJobsListRequest object.

  Fields:
    filter: Optional. Filters results as defined by
      https://google.aip.dev/160.
    orderBy: Optional. Field to sort by. Supported fields are name,
      create_time.
    pageSize: Optional. The list page size. default page size is 100.
    pageToken: Optional. The list page token.
    parent: Required. Format: projects/{project_id}/locations/{location_id} .
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class StoragebatchoperationsProjectsLocationsListRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class StoragebatchoperationsProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class StoragebatchoperationsProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class StoragebatchoperationsProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class StoragebatchoperationsProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A StoragebatchoperationsProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
