// Code generated by go generate; DO NOT EDIT.
package square

import "errors"

type Permission int

const (
    Invalid Permission = iota
    BankAccountsRead Permission = iota
    AppointmentsWrite Permission = iota
    AppointmentsAllWrite Permission = iota
    AppointmentsRead Permission = iota
    AppointmentsAllRead Permission = iota
    AppointmentsBusinessSettingsRead Permission = iota
    PaymentsRead Permission = iota
    PaymentsWrite Permission = iota
    CashDrawerRead Permission = iota
    ItemsWrite Permission = iota
    ItemsRead Permission = iota
    OrdersWrite Permission = iota
    OrdersRead Permission = iota
    CustomersWrite Permission = iota
    CustomersRead Permission = iota
    DeviceCredentialManagement Permission = iota
    DevicesRead Permission = iota
    DisputesWrite Permission = iota
    DisputesRead Permission = iota
    EmployeesRead Permission = iota
    GiftcardsRead Permission = iota
    GiftcardsWrite Permission = iota
    InventoryWrite Permission = iota
    InventoryRead Permission = iota
    InvoicesWrite Permission = iota
    InvoicesRead Permission = iota
    TimecardsSettingsWrite Permission = iota
    TimecardsWrite Permission = iota
    TimecardsSettingsRead Permission = iota
    TimecardsRead Permission = iota
    MerchantProfileWrite Permission = iota
    MerchantProfileRead Permission = iota
    LoyaltyRead Permission = iota
    LoyaltyWrite Permission = iota
    PaymentsWriteInPerson Permission = iota
    PaymentsWriteSharedOnfile Permission = iota
    PaymentsWriteAdditionalRecipients Permission = iota
    PayoutsRead Permission = iota
    OnlineStoreSiteRead Permission = iota
    OnlineStoreSnippetsWrite Permission = iota
    OnlineStoreSnippetsRead Permission = iota
    SubscriptionsWrite Permission = iota
    SubscriptionsRead Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        BankAccountsRead: "bank_accounts_read",
        AppointmentsWrite: "appointments_write",
        AppointmentsAllWrite: "appointments_all_write",
        AppointmentsRead: "appointments_read",
        AppointmentsAllRead: "appointments_all_read",
        AppointmentsBusinessSettingsRead: "appointments_business_settings_read",
        PaymentsRead: "payments_read",
        PaymentsWrite: "payments_write",
        CashDrawerRead: "cash_drawer_read",
        ItemsWrite: "items_write",
        ItemsRead: "items_read",
        OrdersWrite: "orders_write",
        OrdersRead: "orders_read",
        CustomersWrite: "customers_write",
        CustomersRead: "customers_read",
        DeviceCredentialManagement: "device_credential_management",
        DevicesRead: "devices_read",
        DisputesWrite: "disputes_write",
        DisputesRead: "disputes_read",
        EmployeesRead: "employees_read",
        GiftcardsRead: "giftcards_read",
        GiftcardsWrite: "giftcards_write",
        InventoryWrite: "inventory_write",
        InventoryRead: "inventory_read",
        InvoicesWrite: "invoices_write",
        InvoicesRead: "invoices_read",
        TimecardsSettingsWrite: "timecards_settings_write",
        TimecardsWrite: "timecards_write",
        TimecardsSettingsRead: "timecards_settings_read",
        TimecardsRead: "timecards_read",
        MerchantProfileWrite: "merchant_profile_write",
        MerchantProfileRead: "merchant_profile_read",
        LoyaltyRead: "loyalty_read",
        LoyaltyWrite: "loyalty_write",
        PaymentsWriteInPerson: "payments_write_in_person",
        PaymentsWriteSharedOnfile: "payments_write_shared_onfile",
        PaymentsWriteAdditionalRecipients: "payments_write_additional_recipients",
        PayoutsRead: "payouts_read",
        OnlineStoreSiteRead: "online_store_site_read",
        OnlineStoreSnippetsWrite: "online_store_snippets_write",
        OnlineStoreSnippetsRead: "online_store_snippets_read",
        SubscriptionsWrite: "subscriptions_write",
        SubscriptionsRead: "subscriptions_read",
    }

    StringToPermission = map[string]Permission{
        "bank_accounts_read": BankAccountsRead,
        "appointments_write": AppointmentsWrite,
        "appointments_all_write": AppointmentsAllWrite,
        "appointments_read": AppointmentsRead,
        "appointments_all_read": AppointmentsAllRead,
        "appointments_business_settings_read": AppointmentsBusinessSettingsRead,
        "payments_read": PaymentsRead,
        "payments_write": PaymentsWrite,
        "cash_drawer_read": CashDrawerRead,
        "items_write": ItemsWrite,
        "items_read": ItemsRead,
        "orders_write": OrdersWrite,
        "orders_read": OrdersRead,
        "customers_write": CustomersWrite,
        "customers_read": CustomersRead,
        "device_credential_management": DeviceCredentialManagement,
        "devices_read": DevicesRead,
        "disputes_write": DisputesWrite,
        "disputes_read": DisputesRead,
        "employees_read": EmployeesRead,
        "giftcards_read": GiftcardsRead,
        "giftcards_write": GiftcardsWrite,
        "inventory_write": InventoryWrite,
        "inventory_read": InventoryRead,
        "invoices_write": InvoicesWrite,
        "invoices_read": InvoicesRead,
        "timecards_settings_write": TimecardsSettingsWrite,
        "timecards_write": TimecardsWrite,
        "timecards_settings_read": TimecardsSettingsRead,
        "timecards_read": TimecardsRead,
        "merchant_profile_write": MerchantProfileWrite,
        "merchant_profile_read": MerchantProfileRead,
        "loyalty_read": LoyaltyRead,
        "loyalty_write": LoyaltyWrite,
        "payments_write_in_person": PaymentsWriteInPerson,
        "payments_write_shared_onfile": PaymentsWriteSharedOnfile,
        "payments_write_additional_recipients": PaymentsWriteAdditionalRecipients,
        "payouts_read": PayoutsRead,
        "online_store_site_read": OnlineStoreSiteRead,
        "online_store_snippets_write": OnlineStoreSnippetsWrite,
        "online_store_snippets_read": OnlineStoreSnippetsRead,
        "subscriptions_write": SubscriptionsWrite,
        "subscriptions_read": SubscriptionsRead,
    }

    PermissionIDs = map[Permission]int{
        BankAccountsRead: 1,
        AppointmentsWrite: 2,
        AppointmentsAllWrite: 3,
        AppointmentsRead: 4,
        AppointmentsAllRead: 5,
        AppointmentsBusinessSettingsRead: 6,
        PaymentsRead: 7,
        PaymentsWrite: 8,
        CashDrawerRead: 9,
        ItemsWrite: 10,
        ItemsRead: 11,
        OrdersWrite: 12,
        OrdersRead: 13,
        CustomersWrite: 14,
        CustomersRead: 15,
        DeviceCredentialManagement: 16,
        DevicesRead: 17,
        DisputesWrite: 18,
        DisputesRead: 19,
        EmployeesRead: 20,
        GiftcardsRead: 21,
        GiftcardsWrite: 22,
        InventoryWrite: 23,
        InventoryRead: 24,
        InvoicesWrite: 25,
        InvoicesRead: 26,
        TimecardsSettingsWrite: 27,
        TimecardsWrite: 28,
        TimecardsSettingsRead: 29,
        TimecardsRead: 30,
        MerchantProfileWrite: 31,
        MerchantProfileRead: 32,
        LoyaltyRead: 33,
        LoyaltyWrite: 34,
        PaymentsWriteInPerson: 35,
        PaymentsWriteSharedOnfile: 36,
        PaymentsWriteAdditionalRecipients: 37,
        PayoutsRead: 38,
        OnlineStoreSiteRead: 39,
        OnlineStoreSnippetsWrite: 40,
        OnlineStoreSnippetsRead: 41,
        SubscriptionsWrite: 42,
        SubscriptionsRead: 43,
    }

    IdToPermission = map[int]Permission{
        1: BankAccountsRead,
        2: AppointmentsWrite,
        3: AppointmentsAllWrite,
        4: AppointmentsRead,
        5: AppointmentsAllRead,
        6: AppointmentsBusinessSettingsRead,
        7: PaymentsRead,
        8: PaymentsWrite,
        9: CashDrawerRead,
        10: ItemsWrite,
        11: ItemsRead,
        12: OrdersWrite,
        13: OrdersRead,
        14: CustomersWrite,
        15: CustomersRead,
        16: DeviceCredentialManagement,
        17: DevicesRead,
        18: DisputesWrite,
        19: DisputesRead,
        20: EmployeesRead,
        21: GiftcardsRead,
        22: GiftcardsWrite,
        23: InventoryWrite,
        24: InventoryRead,
        25: InvoicesWrite,
        26: InvoicesRead,
        27: TimecardsSettingsWrite,
        28: TimecardsWrite,
        29: TimecardsSettingsRead,
        30: TimecardsRead,
        31: MerchantProfileWrite,
        32: MerchantProfileRead,
        33: LoyaltyRead,
        34: LoyaltyWrite,
        35: PaymentsWriteInPerson,
        36: PaymentsWriteSharedOnfile,
        37: PaymentsWriteAdditionalRecipients,
        38: PayoutsRead,
        39: OnlineStoreSiteRead,
        40: OnlineStoreSnippetsWrite,
        41: OnlineStoreSnippetsRead,
        42: SubscriptionsWrite,
        43: SubscriptionsRead,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
