param(
    [switch]
    $AllUsers
)

function FolderIsInPATH($Path_to_directory) {
    return ([Environment]::GetEnvironmentVariable("PATH", "User") -split ';').TrimEnd('\') -contains $Path_to_directory.TrimEnd('\')
}

Write-Host -ForegroundColor DarkRed     "                                                    ______   __  __           "
Write-Host -ForegroundColor Red         "                                                   /      \ /  |/  |          "
Write-Host -ForegroundColor DarkYellow  "  _______  __    __   ______    ______    ______  /`$`$`$`$`$`$  |`$`$/ `$`$ |  ______  "
Write-Host -ForegroundColor Yellow      " /       |/  |  /  | /      \  /      \  /      \ `$`$ |_ `$`$/ /  |`$`$ | /      \ "
Write-Host -ForegroundColor DarkGreen   "/`$`$`$`$`$`$`$/ `$`$ |  `$`$ |/`$`$`$`$`$`$  |/`$`$`$`$`$`$  |/`$`$`$`$`$`$  |`$`$   |    `$`$ |`$`$ |/`$`$`$`$`$`$  |"
Write-Host -ForegroundColor Green       "`$`$      \ `$`$ |  `$`$ |`$`$ |  `$`$ |`$`$    `$`$ |`$`$ |  `$`$/ `$`$`$`$/     `$`$ |`$`$ |`$`$    `$`$ |"
Write-Host -ForegroundColor DarkBlue    " `$`$`$`$`$`$  |`$`$ \__`$`$ |`$`$ |__`$`$ |`$`$`$`$`$`$`$`$/ `$`$ |      `$`$ |      `$`$ |`$`$ |`$`$`$`$`$`$`$`$/ "
Write-Host -ForegroundColor Blue        "      `$`$/ `$`$    `$`$/ `$`$    `$`$/ `$`$       |`$`$ |      `$`$ |      `$`$ |`$`$ |`$`$       |"
Write-Host -ForegroundColor DarkMagenta "`$`$`$`$`$`$`$/   `$`$`$`$`$`$/  `$`$`$`$`$`$`$/   `$`$`$`$`$`$`$/ `$`$/       `$`$/       `$`$/ `$`$/  `$`$`$`$`$`$`$/ "
Write-Host -ForegroundColor Magenta     "                    `$`$ |                                                      "
Write-Host -ForegroundColor DarkRed     "                    `$`$ |                                                      "
Write-Host -ForegroundColor Red         "                    `$`$/                                                       "
Write-Host ""

$package = "superfile"
$version = "1.1.7.1"

$installInstructions = @'
This uninstaller is only available for Windows.
'@
if ($IsMacOS) {
    Write-Host "$installInstructions"
    exit
}
if ($IsLinux) {
    Write-Host "$installInstructions"
    exit
}

Write-Host "Removing folder..."

$superfileProgramPath = [Environment]::GetFolderPath("LocalApplicationData") + "\Programs\superfile"
try {
    if (Test-Path $superfileProgramPath) {
        Remove-Item -Path $superfileProgramPath -Recurse -Force
    }
}
catch {
    Write-Host "An error occurred: $_"
    exit
}

Write-Host "Removing environment path..."

try {
    if (FolderIsInPATH "$superfileProgramPath\") {
        $envPath = [Environment]::GetEnvironmentVariable("PATH", "User")
        $updatedPath =($envPath.Split(';') | Where-Object { $_ -ne "$superfileProgramPath" }) -join ';' 
        [Environment]::SetEnvironmentVariable("PATH", $updatedPath, "User")
    }
}
catch {
    Write-Host "An error occurred: $_"
    exit
}

Write-Host @'
Uninstall Done!
'@

