## Description
Amazon S3 provides a variety of no, or low, cost encryption options to protect data at rest.

## Rationale Statement
Encrypting data at rest reduces the likelihood that it is unintentionally exposed and can nullify the impact of disclosure if the encryption remains unbroken.

Amazon S3 buckets with default bucket encryption using SSE-KMS cannot be used as destination buckets for Amazon S3 server access logging. Only SSE-S3 default encryption is supported for server access log destination buckets.

## Remediation Procedure

### From Console:
1. Login to AWS Management Console and open the Amazon S3 console using https://console.aws.amazon.com/s3/
1. Select the Check box next to the Bucket.
1. Click on 'Properties'.
1. Click on Default Encryption.
1. Select either AES-256 or AWS-KMS
1. Click Save
1. Repeat for all the buckets in your AWS account lacking encryption.

### From Command Line:
Run either
```bash
aws s3api put-bucket-encryption --bucket <bucket name> --server-side-encryption-configuration '{"Rules": [{"ApplyServerSideEncryptionByDefault": {"SSEAlgorithm": "AES256"}}]}'
```
or
```bash
aws s3api put-bucket-encryption --bucket <bucket name> --server-side-encryption-configuration '{"Rules": [{"ApplyServerSideEncryptionByDefault": {"SSEAlgorithm": "aws:kms","KMSMasterKeyID": "aws/s3"}}]}'
Note: the KMSMasterKeyID can be set to the master key of your choosing; aws/s3 is an AWS preconfigured default.
```

## References
- https://docs.aws.amazon.com/AmazonS3/latest/user-guide/default-bucket-encryption.html
- https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-related-resources

## Additional Information
S3 bucket encryption only applies to objects as they are placed in the bucket. Enabling S3 bucket encryption does not encrypt objects previously stored within the bucket.
