<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw keymanager`
This API allows you to conveniently store and use cryptographic keys.
  
- [Key management commands](#key-management-commands)
  - [Create a key](#create-a-key)
  - [Decrypt an encrypted payload](#decrypt-an-encrypted-payload)
  - [Delete a key](#delete-a-key)
  - [Delete key material](#delete-key-material)
  - [Disable key](#disable-key)
  - [Enable key](#enable-key)
  - [Encrypt a payload](#encrypt-a-payload)
  - [Create a data encryption key](#create-a-data-encryption-key)
  - [Get key metadata](#get-key-metadata)
  - [Import key material](#import-key-material)
  - [List keys](#list-keys)
  - [Apply key protection](#apply-key-protection)
  - [Rotate a key](#rotate-a-key)
  - [Remove key protection](#remove-key-protection)
  - [Update a key](#update-a-key)

  
## Key management commands

Keys are logical containers which store cryptographic keys.


### Create a key

Create a key in a given region specified by the `region` parameter. Keys only support symmetric encryption. You can use keys to encrypt or decrypt arbitrary payloads, or to generate data encryption keys. **Data encryption keys are not stored in Key Manager**.

**Usage:**

```
scw keymanager key create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name |  | (Optional) Name of the key |
| usage.symmetric-encryption | One of: `unknown_symmetric_encryption`, `aes_256_gcm` | Algorithm used to encrypt and decrypt arbitrary payloads. |
| description |  | (Optional) Description of the key |
| tags.{index} |  | (Optional) List of the key's tags |
| rotation-policy.rotation-period |  | Rotation period |
| rotation-policy.next-rotation-at |  | Key next rotation date |
| unprotected |  | (Optional) Defines whether key protection is applied to a key. Protected keys can be used but not deleted |
| origin | One of: `unknown_origin`, `scaleway_kms`, `external` | Key origin |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Decrypt an encrypted payload

Decrypt an encrypted payload using an existing key, specified by the `key_id` parameter. The maximum payload size that can be decrypted is equivalent to the encrypted output of 64 KB of data (around 131 KB).

**Usage:**

```
scw keymanager key decrypt <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to decrypt |
| ciphertext | Required | Base64 Ciphertext data to decrypt |
| associated-data |  | (Optional) Additional authenticated data |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a key

Permanently delete a key specified by the `region` and `key_id` parameters. This action is irreversible. Any data encrypted with this key, including data encryption keys, will no longer be decipherable.

**Usage:**

```
scw keymanager key delete <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete key material

Delete previously imported key material. This renders the associated cryptographic key unusable for any operation. The key's origin must be `external`.

**Usage:**

```
scw keymanager key delete-key-material <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key of which to delete the key material |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Disable key

Disable a given key, preventing it to be used for cryptographic operations. Disabling a key renders it unusable. You must specify the `region` and `key_id` parameters.

**Usage:**

```
scw keymanager key disable <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to disable |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Enable key

Enable a given key to be used for cryptographic operations. Enabling a key allows you to make a disabled key usable again. You must specify the `region` and `key_id` parameters.

**Usage:**

```
scw keymanager key enable <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to enable |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Encrypt a payload

Encrypt a payload using an existing key, specified by the `key_id` parameter. Only keys with a usage set to `symmetric_encryption` are supported by this method. The maximum payload size that can be encrypted is 64 KB of plaintext.

**Usage:**

```
scw keymanager key encrypt <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to encrypt |
| plaintext | Required | Base64 Plaintext data to encrypt |
| associated-data |  | (Optional) Additional authenticated data |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Create a data encryption key

Create a new data encryption key for cryptographic operations outside of Key Manager. The data encryption key is encrypted and must be decrypted using the key you have created in Key Manager.

The data encryption key is returned in plaintext and ciphertext but it should only be stored in its encrypted form (ciphertext). Key Manager does not store your data encryption key. To retrieve your key's plaintext, use the `Decrypt` method with your key's ID and ciphertext.

**Usage:**

```
scw keymanager key generate-data-key <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key |
| algorithm | Default: `aes_256_gcm`<br />One of: `unknown_symmetric_encryption`, `aes_256_gcm` | Algorithm with which the data encryption key will be used to encrypt and decrypt arbitrary payloads |
| without-plaintext |  | (Optional) Defines whether to return the data encryption key's plaintext in the response object |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get key metadata

Retrieve metadata for a specified key using the `region` and `key_id` parameters.

**Usage:**

```
scw keymanager key get <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to target |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Import key material

Import externally generated key material into Key Manager to derive a new cryptographic key. The key's origin must be `external`.

**Usage:**

```
scw keymanager key import-key-material <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key in which to import key material |
| key-material |  | The key material The key material is a random sequence of bytes used to derive a cryptographic key. |
| salt |  | (Optional) Salt value to pass the key derivation function |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List keys

Retrieve a list of keys across all Projects in an Organization or within a specific Project. You must specify the `region`, and either the `organization_id` or the `project_id`.

**Usage:**

```
scw keymanager key list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | (Optional) Filter by Project ID |
| order-by | One of: `name_asc`, `name_desc`, `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc` |  |
| tags.{index} |  | (Optional) List of tags to filter on |
| name |  | (Optional) Filter by key name |
| organization-id |  | (Optional) Filter by Organization ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Apply key protection

Apply protection to a given key specified by the `key_id` parameter. Applying key protection means that your key can be used and modified, but it cannot be deleted.

**Usage:**

```
scw keymanager key protect <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to apply key protection to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Rotate a key

Generate a new version of an existing key with new key material. Previous key versions remain usable to decrypt previously encrypted data, but the key's new version will be used for subsequent encryption operations and data key generation.

**Usage:**

```
scw keymanager key rotate <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to rotate |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Remove key protection

Remove key protection from a given key specified by the `key_id` parameter. Removing key protection means that your key can be deleted anytime.

**Usage:**

```
scw keymanager key unprotect <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to remove key protection from |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Update a key

Modify a key's metadata including name, description and tags, specified by the `key_id` and `region` parameters.

**Usage:**

```
scw keymanager key update <key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key-id | Required | ID of the key to update |
| name |  | (Optional) Updated name of the key |
| description |  | (Optional) Updated description of the key |
| tags.{index} |  | (Optional) Updated list of the key's tags |
| rotation-policy.rotation-period |  | Rotation period |
| rotation-policy.next-rotation-at |  | Key next rotation date |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



