# Usage

<!-- This is generated by scripts/generate-usage.sh. Don't edit this file directly. -->

```console
$ pinact --help
NAME:
   pinact - Pin GitHub Actions versions. https://github.com/suzuki-shunsuke/pinact

USAGE:
   pinact [global options] [command [command options]]

VERSION:
   3.0.3 (307194e27c916f53c084bbc1fb560a1452fb2dea)

COMMANDS:
   init     Create .pinact.yaml if it doesn't exist
   run      Pin GitHub Actions versions
   migrate  Migrate .pinact.yaml
   version  Show version
   help, h  Shows a list of commands or help for one command

GLOBAL OPTIONS:
   --log-level string          log level [$PINACT_LOG_LEVEL]
   --config string, -c string  configuration file path [$PINACT_CONFIG]
   --help, -h                  show help
   --version, -v               print the version
```

## pinact init

```console
$ pinact init --help
NAME:
   pinact init - Create .pinact.yaml if it doesn't exist

USAGE:
   pinact init

DESCRIPTION:
   Create .pinact.yaml if it doesn't exist

   $ pinact init

   You can also pass configuration file path.

   e.g.

   $ pinact init .github/pinact.yaml


OPTIONS:
   --help, -h  show help
```

## pinact run

```console
$ pinact run --help
NAME:
   pinact run - Pin GitHub Actions versions

USAGE:
   pinact run

DESCRIPTION:
   If no argument is passed, pinact searches GitHub Actions workflow files from .github/workflows.

   $ pinact run

   You can also pass workflow file paths as arguments.

   e.g.

   $ pinact run .github/actions/foo/action.yaml .github/actions/bar/action.yaml


OPTIONS:
   --verify, -v  Verify if pairs of commit SHA and version are correct (default: false)
   --check       Exit with a non-zero status code if actions are not pinned. If this is true, files aren't updated (default: false)
   --update, -u  Update actions to latest versions (default: false)
   --help, -h    show help
```

## pinact migrate

```console
$ pinact migrate --help
NAME:
   pinact migrate - Migrate .pinact.yaml

USAGE:
   pinact migrate

DESCRIPTION:
   Migrate the version of .pinact.yaml

   $ pinact migrate


OPTIONS:
   --help, -h  show help
```

## pinact version

```console
$ pinact version --help
NAME:
   pinact version - Show version

USAGE:
   pinact version

OPTIONS:
   --json, -j  Output version in JSON format (default: false)
   --help, -h  show help
```
