---
title: v1.28.0
weight: 998972000
---

## (ansible) - Upgrade kubernetes.core collection to v2.4.0

In the requirements.yaml file replace:
```yaml
  - name: kubernetes.core
    version: "2.3.1"
```
with:
```yaml
  - name: kubernetes.core
    version: "2.4.0"
```

_See [#6334](https://github.com/operator-framework/operator-sdk/pull/6334) for more details._

## Upgrade K8s versions to use 1.26

Regarding the upcoming major changes in the plugin, please note that `go/v3` is being deprecated by Kubebuilder hence Operator SDK would also be migrating to `go/v4` soon. Following are the changes to be addressed in your project structure, `Makefile` and `go.mod` files: 1) [go/v3, ansible/v1, helm/v1] Update your `go.mod` file to upgrade the dependencies and run `go mod tidy` to download them ```go k8s.io/api v0.26.2 k8s.io/apiextensions-apiserver v0.26.2 k8s.io/apimachinery v0.26.2 k8s.io/cli-runtime v0.26.2 k8s.io/client-go v0.26.2 k8s.io/kubectl v0.26.2 sigs.k8s.io/controller-runtime v0.14.5 sigs.k8s.io/controller-tools v0.11.3 sigs.k8s.io/kubebuilder/v3 v3.9.1 ``` 2) [go/v3, ansible/v1, helm/v1] With the bump to Kubebuilder 3.9.1, the `go/v3` projects are now scaffolded with 0.13.1 version of kube-rbac-proxy. Modify the version of kube-rbac-proxy in the following scaffolded files: - config/default/manager_auth_proxy_patch.yaml - bundle/manifests/memcached-operator.clusterserviceversion.yaml        

  ```diff
    - gcr.io/kubebuilder/kube-rbac-proxy:v0.13.0
    + gcr.io/kubebuilder/kube-rbac-proxy:v0.13.1
  ```
3) [gov4alpha] For scaffolds, replace scaffoldings of v1beta1 by using `k8s.io/api/admission/v1` instead of `k8s.io/api/admission/v1beta1` as v1beta1 is removed in latest k8s.
  ```diff
    - admissionv1beta1 "k8s.io/api/admission/v1beta1"
    + admissionv1 "k8s.io/api/admission/v1"
  ```
4) [gov4alpha] The project structure has changed from `/controllers` to `internal/controller/`. Modify the Dockerfile of the `go/v4-alpha` plugin to below:
  ```diff
    - COPY controllers/ controllers/
    + COPY internal/controller/ internal/controller/
  ```
5) [go/v3, gov4alpha] Update your Makefile by
  - Replacing `ENVTEST_K8S_VERSION = 1.25` with `ENVTEST_K8S_VERSION = 1.26`.
  - Using `manifests generate fmt vet` to build manager binary by replacing `generate fmt vet` in the build target to `manifests generate fmt vet`:
  ```diff
    - build: generate fmt vet ## Build manager binary.
    + build: manifests generate fmt vet ## Build manager binary.
  ```
6) [gov4alpha] The gov4alpha plugin is now being scaffolded with Kubebuilder's go/v4-alpha which has a modified project file structure according to Go's best practices. Refer https://github.com/kubernetes-sigs/kubebuilder/pull/2985 for changes. Make the following changes in your scaffolded project if gov4aplha plugin was used:          - Replacing `go run ./main.go` to `go run ./cmd/main.go` due to the change in project structure.
   - Replacing 
  ```diff 
    - `test -s $(LOCALBIN)/controller-gen || GOBIN=$(LOCALBIN) go install sigs.k8s.io/controller-tools/cmd/controller-gen@$(CONTROLLER_TOOLS_VERSION)`
    + test -s $(LOCALBIN)/controller-gen && $(LOCALBIN)/controller-gen --version | grep -q $(CONTROLLER_TOOLS_VERSION) || \
    GOBIN=$(LOCALBIN) go install sigs.k8s.io/controller-tools/cmd/controller-gen@$(CONTROLLER_TOOLS_VERSION)
  ```

_See [#6352](https://github.com/operator-framework/operator-sdk/pull/6352) for more details._
