// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/openshift/api/template/v1"
	templatev1 "github.com/openshift/client-go/template/applyconfigurations/template/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeBrokerTemplateInstances implements BrokerTemplateInstanceInterface
type FakeBrokerTemplateInstances struct {
	Fake *FakeTemplateV1
}

var brokertemplateinstancesResource = v1.SchemeGroupVersion.WithResource("brokertemplateinstances")

var brokertemplateinstancesKind = v1.SchemeGroupVersion.WithKind("BrokerTemplateInstance")

// Get takes name of the brokerTemplateInstance, and returns the corresponding brokerTemplateInstance object, and an error if there is any.
func (c *FakeBrokerTemplateInstances) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.BrokerTemplateInstance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(brokertemplateinstancesResource, name), &v1.BrokerTemplateInstance{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.BrokerTemplateInstance), err
}

// List takes label and field selectors, and returns the list of BrokerTemplateInstances that match those selectors.
func (c *FakeBrokerTemplateInstances) List(ctx context.Context, opts metav1.ListOptions) (result *v1.BrokerTemplateInstanceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(brokertemplateinstancesResource, brokertemplateinstancesKind, opts), &v1.BrokerTemplateInstanceList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.BrokerTemplateInstanceList{ListMeta: obj.(*v1.BrokerTemplateInstanceList).ListMeta}
	for _, item := range obj.(*v1.BrokerTemplateInstanceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested brokerTemplateInstances.
func (c *FakeBrokerTemplateInstances) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(brokertemplateinstancesResource, opts))
}

// Create takes the representation of a brokerTemplateInstance and creates it.  Returns the server's representation of the brokerTemplateInstance, and an error, if there is any.
func (c *FakeBrokerTemplateInstances) Create(ctx context.Context, brokerTemplateInstance *v1.BrokerTemplateInstance, opts metav1.CreateOptions) (result *v1.BrokerTemplateInstance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(brokertemplateinstancesResource, brokerTemplateInstance), &v1.BrokerTemplateInstance{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.BrokerTemplateInstance), err
}

// Update takes the representation of a brokerTemplateInstance and updates it. Returns the server's representation of the brokerTemplateInstance, and an error, if there is any.
func (c *FakeBrokerTemplateInstances) Update(ctx context.Context, brokerTemplateInstance *v1.BrokerTemplateInstance, opts metav1.UpdateOptions) (result *v1.BrokerTemplateInstance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(brokertemplateinstancesResource, brokerTemplateInstance), &v1.BrokerTemplateInstance{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.BrokerTemplateInstance), err
}

// Delete takes name of the brokerTemplateInstance and deletes it. Returns an error if one occurs.
func (c *FakeBrokerTemplateInstances) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(brokertemplateinstancesResource, name, opts), &v1.BrokerTemplateInstance{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeBrokerTemplateInstances) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(brokertemplateinstancesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1.BrokerTemplateInstanceList{})
	return err
}

// Patch applies the patch and returns the patched brokerTemplateInstance.
func (c *FakeBrokerTemplateInstances) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.BrokerTemplateInstance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(brokertemplateinstancesResource, name, pt, data, subresources...), &v1.BrokerTemplateInstance{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.BrokerTemplateInstance), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied brokerTemplateInstance.
func (c *FakeBrokerTemplateInstances) Apply(ctx context.Context, brokerTemplateInstance *templatev1.BrokerTemplateInstanceApplyConfiguration, opts metav1.ApplyOptions) (result *v1.BrokerTemplateInstance, err error) {
	if brokerTemplateInstance == nil {
		return nil, fmt.Errorf("brokerTemplateInstance provided to Apply must not be nil")
	}
	data, err := json.Marshal(brokerTemplateInstance)
	if err != nil {
		return nil, err
	}
	name := brokerTemplateInstance.Name
	if name == nil {
		return nil, fmt.Errorf("brokerTemplateInstance.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(brokertemplateinstancesResource, *name, types.ApplyPatchType, data), &v1.BrokerTemplateInstance{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.BrokerTemplateInstance), err
}
