// Code generated by applyconfiguration-gen. DO NOT EDIT.

package internal

import (
	"fmt"
	"sync"

	typed "sigs.k8s.io/structured-merge-diff/v4/typed"
)

func Parser() *typed.Parser {
	parserOnce.Do(func() {
		var err error
		parser, err = typed.NewParser(schemaYAML)
		if err != nil {
			panic(fmt.Sprintf("Failed to parse schema: %v", err))
		}
	})
	return parser
}

var parserOnce sync.Once
var parser *typed.Parser
var schemaYAML = typed.YAMLObject(`types:
- name: com.github.openshift.api.config.v1.ConfigMapFileReference
  map:
    fields:
    - name: key
      type:
        scalar: string
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ConfigMapNameReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.CustomTLSProfile
  map:
    fields:
    - name: ciphers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: minTLSVersion
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.IntermediateTLSProfile
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.ModernTLSProfile
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.OldTLSProfile
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.SecretNameReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.TLSProfileSpec
  map:
    fields:
    - name: ciphers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: minTLSVersion
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.TLSSecurityProfile
  map:
    fields:
    - name: custom
      type:
        namedType: com.github.openshift.api.config.v1.CustomTLSProfile
    - name: intermediate
      type:
        namedType: com.github.openshift.api.config.v1.IntermediateTLSProfile
    - name: modern
      type:
        namedType: com.github.openshift.api.config.v1.ModernTLSProfile
    - name: old
      type:
        namedType: com.github.openshift.api.config.v1.OldTLSProfile
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: custom
        discriminatorValue: Custom
      - fieldName: intermediate
        discriminatorValue: Intermediate
      - fieldName: modern
        discriminatorValue: Modern
      - fieldName: old
        discriminatorValue: Old
- name: com.github.openshift.api.operator.v1.AWSCSIDriverConfigSpec
  map:
    fields:
    - name: kmsKeyARN
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.AWSClassicLoadBalancerParameters
  map:
    fields:
    - name: connectionIdleTimeout
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
- name: com.github.openshift.api.operator.v1.AWSLoadBalancerParameters
  map:
    fields:
    - name: classicLoadBalancer
      type:
        namedType: com.github.openshift.api.operator.v1.AWSClassicLoadBalancerParameters
    - name: networkLoadBalancer
      type:
        namedType: com.github.openshift.api.operator.v1.AWSNetworkLoadBalancerParameters
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: classicLoadBalancer
        discriminatorValue: ClassicLoadBalancerParameters
      - fieldName: networkLoadBalancer
        discriminatorValue: NetworkLoadBalancerParameters
- name: com.github.openshift.api.operator.v1.AWSNetworkLoadBalancerParameters
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.operator.v1.AccessLogging
  map:
    fields:
    - name: destination
      type:
        namedType: com.github.openshift.api.operator.v1.LoggingDestination
      default: {}
    - name: httpCaptureCookies
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.IngressControllerCaptureHTTPCookie
          elementRelationship: atomic
    - name: httpCaptureHeaders
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerCaptureHTTPHeaders
      default: {}
    - name: httpLogFormat
      type:
        scalar: string
    - name: logEmptyRequests
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.AddPage
  map:
    fields:
    - name: disabledActions
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.AdditionalNetworkDefinition
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
    - name: rawCNIConfig
      type:
        scalar: string
    - name: simpleMacvlanConfig
      type:
        namedType: com.github.openshift.api.operator.v1.SimpleMacvlanConfig
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.Authentication
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.AuthenticationSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.AuthenticationStatus
      default: {}
- name: com.github.openshift.api.operator.v1.AuthenticationSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.AuthenticationStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: oauthAPIServer
      type:
        namedType: com.github.openshift.api.operator.v1.OAuthAPIServerStatus
      default: {}
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.AzureCSIDriverConfigSpec
  map:
    fields:
    - name: diskEncryptionSet
      type:
        namedType: com.github.openshift.api.operator.v1.AzureDiskEncryptionSet
- name: com.github.openshift.api.operator.v1.AzureDiskEncryptionSet
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: resourceGroup
      type:
        scalar: string
      default: ""
    - name: subscriptionID
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.CSIDriverConfigSpec
  map:
    fields:
    - name: aws
      type:
        namedType: com.github.openshift.api.operator.v1.AWSCSIDriverConfigSpec
    - name: azure
      type:
        namedType: com.github.openshift.api.operator.v1.AzureCSIDriverConfigSpec
    - name: driverType
      type:
        scalar: string
      default: ""
    - name: gcp
      type:
        namedType: com.github.openshift.api.operator.v1.GCPCSIDriverConfigSpec
    - name: ibmcloud
      type:
        namedType: com.github.openshift.api.operator.v1.IBMCloudCSIDriverConfigSpec
    - name: vSphere
      type:
        namedType: com.github.openshift.api.operator.v1.VSphereCSIDriverConfigSpec
    unions:
    - discriminator: driverType
      fields:
      - fieldName: aws
        discriminatorValue: AWS
      - fieldName: azure
        discriminatorValue: Azure
      - fieldName: gcp
        discriminatorValue: GCP
      - fieldName: ibmcloud
        discriminatorValue: IBMCloud
      - fieldName: vSphere
        discriminatorValue: VSphere
- name: com.github.openshift.api.operator.v1.CSISnapshotController
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.CSISnapshotControllerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.CSISnapshotControllerStatus
      default: {}
- name: com.github.openshift.api.operator.v1.CSISnapshotControllerSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.CSISnapshotControllerStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.ClientTLS
  map:
    fields:
    - name: allowedSubjectPatterns
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: clientCA
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: clientCertificatePolicy
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.CloudCredential
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.CloudCredentialSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.CloudCredentialStatus
      default: {}
- name: com.github.openshift.api.operator.v1.CloudCredentialSpec
  map:
    fields:
    - name: credentialsMode
      type:
        scalar: string
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.CloudCredentialStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.ClusterCSIDriver
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.ClusterCSIDriverSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.ClusterCSIDriverStatus
      default: {}
- name: com.github.openshift.api.operator.v1.ClusterCSIDriverSpec
  map:
    fields:
    - name: driverConfig
      type:
        namedType: com.github.openshift.api.operator.v1.CSIDriverConfigSpec
      default: {}
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: storageClassState
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.ClusterCSIDriverStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.ClusterNetworkEntry
  map:
    fields:
    - name: cidr
      type:
        scalar: string
      default: ""
    - name: hostPrefix
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.Config
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.ConfigSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.ConfigStatus
      default: {}
- name: com.github.openshift.api.operator.v1.ConfigSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.ConfigStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.Console
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.ConsoleSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.ConsoleStatus
      default: {}
- name: com.github.openshift.api.operator.v1.ConsoleConfigRoute
  map:
    fields:
    - name: hostname
      type:
        scalar: string
      default: ""
    - name: secret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.operator.v1.ConsoleCustomization
  map:
    fields:
    - name: addPage
      type:
        namedType: com.github.openshift.api.operator.v1.AddPage
      default: {}
    - name: brand
      type:
        scalar: string
    - name: customLogoFile
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapFileReference
      default: {}
    - name: customProductName
      type:
        scalar: string
    - name: developerCatalog
      type:
        namedType: com.github.openshift.api.operator.v1.DeveloperConsoleCatalogCustomization
      default: {}
    - name: documentationBaseURL
      type:
        scalar: string
    - name: perspectives
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.Perspective
          elementRelationship: associative
          keys:
          - id
    - name: projectAccess
      type:
        namedType: com.github.openshift.api.operator.v1.ProjectAccess
      default: {}
    - name: quickStarts
      type:
        namedType: com.github.openshift.api.operator.v1.QuickStarts
      default: {}
- name: com.github.openshift.api.operator.v1.ConsoleProviders
  map:
    fields:
    - name: statuspage
      type:
        namedType: com.github.openshift.api.operator.v1.StatuspageProvider
- name: com.github.openshift.api.operator.v1.ConsoleSpec
  map:
    fields:
    - name: customization
      type:
        namedType: com.github.openshift.api.operator.v1.ConsoleCustomization
      default: {}
    - name: ingress
      type:
        namedType: com.github.openshift.api.operator.v1.Ingress
      default: {}
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: plugins
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: providers
      type:
        namedType: com.github.openshift.api.operator.v1.ConsoleProviders
      default: {}
    - name: route
      type:
        namedType: com.github.openshift.api.operator.v1.ConsoleConfigRoute
      default: {}
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.ConsoleStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.ContainerLoggingDestinationParameters
  map:
    fields:
    - name: maxLength
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.DNS
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.DNSSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.DNSStatus
      default: {}
- name: com.github.openshift.api.operator.v1.DNSCache
  map:
    fields:
    - name: negativeTTL
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: positiveTTL
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
- name: com.github.openshift.api.operator.v1.DNSNodePlacement
  map:
    fields:
    - name: nodeSelector
      type:
        map:
          elementType:
            scalar: string
    - name: tolerations
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Toleration
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.DNSOverTLSConfig
  map:
    fields:
    - name: caBundle
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: serverName
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.DNSSpec
  map:
    fields:
    - name: cache
      type:
        namedType: com.github.openshift.api.operator.v1.DNSCache
      default: {}
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
    - name: nodePlacement
      type:
        namedType: com.github.openshift.api.operator.v1.DNSNodePlacement
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: servers
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.Server
          elementRelationship: atomic
    - name: upstreamResolvers
      type:
        namedType: com.github.openshift.api.operator.v1.UpstreamResolvers
      default: {}
- name: com.github.openshift.api.operator.v1.DNSStatus
  map:
    fields:
    - name: clusterDomain
      type:
        scalar: string
      default: ""
    - name: clusterIP
      type:
        scalar: string
      default: ""
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
- name: com.github.openshift.api.operator.v1.DNSTransportConfig
  map:
    fields:
    - name: tls
      type:
        namedType: com.github.openshift.api.operator.v1.DNSOverTLSConfig
    - name: transport
      type:
        scalar: string
    unions:
    - discriminator: transport
      fields:
      - fieldName: tls
        discriminatorValue: TLS
- name: com.github.openshift.api.operator.v1.DefaultNetworkDefinition
  map:
    fields:
    - name: openshiftSDNConfig
      type:
        namedType: com.github.openshift.api.operator.v1.OpenShiftSDNConfig
    - name: ovnKubernetesConfig
      type:
        namedType: com.github.openshift.api.operator.v1.OVNKubernetesConfig
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.DeveloperConsoleCatalogCategory
  map:
    fields:
    - name: id
      type:
        scalar: string
      default: ""
    - name: label
      type:
        scalar: string
      default: ""
    - name: subcategories
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.DeveloperConsoleCatalogCategoryMeta
          elementRelationship: atomic
    - name: tags
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.DeveloperConsoleCatalogCategoryMeta
  map:
    fields:
    - name: id
      type:
        scalar: string
      default: ""
    - name: label
      type:
        scalar: string
      default: ""
    - name: tags
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.DeveloperConsoleCatalogCustomization
  map:
    fields:
    - name: categories
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.DeveloperConsoleCatalogCategory
          elementRelationship: atomic
    - name: types
      type:
        namedType: com.github.openshift.api.operator.v1.DeveloperConsoleCatalogTypes
      default: {}
- name: com.github.openshift.api.operator.v1.DeveloperConsoleCatalogTypes
  map:
    fields:
    - name: disabled
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: enabled
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: state
      type:
        scalar: string
      default: Enabled
    unions:
    - discriminator: state
      fields:
      - fieldName: disabled
        discriminatorValue: Disabled
      - fieldName: enabled
        discriminatorValue: Enabled
- name: com.github.openshift.api.operator.v1.EgressIPConfig
  map:
    fields:
    - name: reachabilityTotalTimeoutSeconds
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.EndpointPublishingStrategy
  map:
    fields:
    - name: hostNetwork
      type:
        namedType: com.github.openshift.api.operator.v1.HostNetworkStrategy
    - name: loadBalancer
      type:
        namedType: com.github.openshift.api.operator.v1.LoadBalancerStrategy
    - name: nodePort
      type:
        namedType: com.github.openshift.api.operator.v1.NodePortStrategy
    - name: private
      type:
        namedType: com.github.openshift.api.operator.v1.PrivateStrategy
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: hostNetwork
        discriminatorValue: HostNetwork
      - fieldName: loadBalancer
        discriminatorValue: LoadBalancer
      - fieldName: nodePort
        discriminatorValue: NodePort
      - fieldName: private
        discriminatorValue: Private
- name: com.github.openshift.api.operator.v1.Etcd
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.EtcdSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.EtcdStatus
      default: {}
- name: com.github.openshift.api.operator.v1.EtcdSpec
  map:
    fields:
    - name: backendQuotaGiB
      type:
        scalar: numeric
      default: 8
    - name: controlPlaneHardwareSpeed
      type:
        scalar: string
      default: ""
    - name: failedRevisionLimit
      type:
        scalar: numeric
    - name: forceRedeploymentReason
      type:
        scalar: string
      default: ""
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: succeededRevisionLimit
      type:
        scalar: numeric
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.EtcdStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: controlPlaneHardwareSpeed
      type:
        scalar: string
      default: ""
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: latestAvailableRevision
      type:
        scalar: numeric
    - name: latestAvailableRevisionReason
      type:
        scalar: string
    - name: nodeStatuses
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeStatus
          elementRelationship: associative
          keys:
          - nodeName
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.ExportNetworkFlows
  map:
    fields:
    - name: ipfix
      type:
        namedType: com.github.openshift.api.operator.v1.IPFIXConfig
    - name: netFlow
      type:
        namedType: com.github.openshift.api.operator.v1.NetFlowConfig
    - name: sFlow
      type:
        namedType: com.github.openshift.api.operator.v1.SFlowConfig
- name: com.github.openshift.api.operator.v1.FeaturesMigration
  map:
    fields:
    - name: egressFirewall
      type:
        scalar: boolean
    - name: egressIP
      type:
        scalar: boolean
    - name: multicast
      type:
        scalar: boolean
- name: com.github.openshift.api.operator.v1.ForwardPlugin
  map:
    fields:
    - name: policy
      type:
        scalar: string
    - name: protocolStrategy
      type:
        scalar: string
      default: ""
    - name: transportConfig
      type:
        namedType: com.github.openshift.api.operator.v1.DNSTransportConfig
      default: {}
    - name: upstreams
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.GCPCSIDriverConfigSpec
  map:
    fields:
    - name: kmsKey
      type:
        namedType: com.github.openshift.api.operator.v1.GCPKMSKeyReference
- name: com.github.openshift.api.operator.v1.GCPKMSKeyReference
  map:
    fields:
    - name: keyRing
      type:
        scalar: string
      default: ""
    - name: location
      type:
        scalar: string
    - name: name
      type:
        scalar: string
      default: ""
    - name: projectID
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.GCPLoadBalancerParameters
  map:
    fields:
    - name: clientAccess
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.GatewayConfig
  map:
    fields:
    - name: ipForwarding
      type:
        scalar: string
    - name: ipv4
      type:
        namedType: com.github.openshift.api.operator.v1.IPv4GatewayConfig
      default: {}
    - name: ipv6
      type:
        namedType: com.github.openshift.api.operator.v1.IPv6GatewayConfig
      default: {}
    - name: routingViaHost
      type:
        scalar: boolean
- name: com.github.openshift.api.operator.v1.GatherStatus
  map:
    fields:
    - name: gatherers
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GathererStatus
          elementRelationship: atomic
    - name: lastGatherDuration
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: lastGatherTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
      default: {}
- name: com.github.openshift.api.operator.v1.GathererStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: atomic
    - name: lastGatherDuration
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
      default: 0
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.GenerationStatus
  map:
    fields:
    - name: group
      type:
        scalar: string
      default: ""
    - name: hash
      type:
        scalar: string
      default: ""
    - name: lastGeneration
      type:
        scalar: numeric
      default: 0
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
      default: ""
    - name: resource
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.HTTPCompressionPolicy
  map:
    fields:
    - name: mimeTypes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
- name: com.github.openshift.api.operator.v1.HealthCheck
  map:
    fields:
    - name: advisorURI
      type:
        scalar: string
      default: ""
    - name: description
      type:
        scalar: string
      default: ""
    - name: state
      type:
        scalar: string
      default: ""
    - name: totalRisk
      type:
        scalar: numeric
      default: 0
- name: com.github.openshift.api.operator.v1.HostNetworkStrategy
  map:
    fields:
    - name: httpPort
      type:
        scalar: numeric
    - name: httpsPort
      type:
        scalar: numeric
    - name: protocol
      type:
        scalar: string
    - name: statsPort
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.HybridOverlayConfig
  map:
    fields:
    - name: hybridClusterNetwork
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.ClusterNetworkEntry
          elementRelationship: atomic
    - name: hybridOverlayVXLANPort
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.IBMCloudCSIDriverConfigSpec
  map:
    fields:
    - name: encryptionKeyCRN
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.IBMLoadBalancerParameters
  map:
    fields:
    - name: protocol
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.IPAMConfig
  map:
    fields:
    - name: staticIPAMConfig
      type:
        namedType: com.github.openshift.api.operator.v1.StaticIPAMConfig
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.IPFIXConfig
  map:
    fields:
    - name: collectors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.IPsecConfig
  map:
    fields:
    - name: mode
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.IPv4GatewayConfig
  map:
    fields:
    - name: internalMasqueradeSubnet
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.IPv4OVNKubernetesConfig
  map:
    fields:
    - name: internalJoinSubnet
      type:
        scalar: string
    - name: internalTransitSwitchSubnet
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.IPv6GatewayConfig
  map:
    fields:
    - name: internalMasqueradeSubnet
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.IPv6OVNKubernetesConfig
  map:
    fields:
    - name: internalJoinSubnet
      type:
        scalar: string
    - name: internalTransitSwitchSubnet
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.Ingress
  map:
    fields:
    - name: clientDownloadsURL
      type:
        scalar: string
      default: ""
    - name: consoleURL
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.IngressController
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerStatus
      default: {}
- name: com.github.openshift.api.operator.v1.IngressControllerCaptureHTTPCookie
  map:
    fields:
    - name: matchType
      type:
        scalar: string
    - name: maxLength
      type:
        scalar: numeric
      default: 0
    - name: name
      type:
        scalar: string
      default: ""
    - name: namePrefix
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: matchType
      fields:
      - fieldName: name
        discriminatorValue: Name
      - fieldName: namePrefix
        discriminatorValue: NamePrefix
- name: com.github.openshift.api.operator.v1.IngressControllerCaptureHTTPHeader
  map:
    fields:
    - name: maxLength
      type:
        scalar: numeric
      default: 0
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.IngressControllerCaptureHTTPHeaders
  map:
    fields:
    - name: request
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.IngressControllerCaptureHTTPHeader
          elementRelationship: atomic
    - name: response
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.IngressControllerCaptureHTTPHeader
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.IngressControllerHTTPHeader
  map:
    fields:
    - name: action
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerHTTPHeaderActionUnion
      default: {}
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.IngressControllerHTTPHeaderActionUnion
  map:
    fields:
    - name: set
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerSetHTTPHeader
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: set
        discriminatorValue: Set
- name: com.github.openshift.api.operator.v1.IngressControllerHTTPHeaderActions
  map:
    fields:
    - name: request
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.IngressControllerHTTPHeader
          elementRelationship: associative
          keys:
          - name
    - name: response
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.IngressControllerHTTPHeader
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.operator.v1.IngressControllerHTTPHeaders
  map:
    fields:
    - name: actions
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerHTTPHeaderActions
      default: {}
    - name: forwardedHeaderPolicy
      type:
        scalar: string
    - name: headerNameCaseAdjustments
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: uniqueId
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicy
      default: {}
- name: com.github.openshift.api.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicy
  map:
    fields:
    - name: format
      type:
        scalar: string
    - name: name
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.IngressControllerLogging
  map:
    fields:
    - name: access
      type:
        namedType: com.github.openshift.api.operator.v1.AccessLogging
- name: com.github.openshift.api.operator.v1.IngressControllerSetHTTPHeader
  map:
    fields:
    - name: value
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.IngressControllerSpec
  map:
    fields:
    - name: clientTLS
      type:
        namedType: com.github.openshift.api.operator.v1.ClientTLS
      default: {}
    - name: defaultCertificate
      type:
        namedType: io.k8s.api.core.v1.LocalObjectReference
    - name: domain
      type:
        scalar: string
    - name: endpointPublishingStrategy
      type:
        namedType: com.github.openshift.api.operator.v1.EndpointPublishingStrategy
    - name: httpCompression
      type:
        namedType: com.github.openshift.api.operator.v1.HTTPCompressionPolicy
      default: {}
    - name: httpEmptyRequestsPolicy
      type:
        scalar: string
    - name: httpErrorCodePages
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: httpHeaders
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerHTTPHeaders
    - name: logging
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerLogging
    - name: namespaceSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: nodePlacement
      type:
        namedType: com.github.openshift.api.operator.v1.NodePlacement
    - name: replicas
      type:
        scalar: numeric
    - name: routeAdmission
      type:
        namedType: com.github.openshift.api.operator.v1.RouteAdmissionPolicy
    - name: routeSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: tlsSecurityProfile
      type:
        namedType: com.github.openshift.api.config.v1.TLSSecurityProfile
    - name: tuningOptions
      type:
        namedType: com.github.openshift.api.operator.v1.IngressControllerTuningOptions
      default: {}
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.IngressControllerStatus
  map:
    fields:
    - name: availableReplicas
      type:
        scalar: numeric
      default: 0
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: atomic
    - name: domain
      type:
        scalar: string
      default: ""
    - name: endpointPublishingStrategy
      type:
        namedType: com.github.openshift.api.operator.v1.EndpointPublishingStrategy
    - name: namespaceSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: observedGeneration
      type:
        scalar: numeric
    - name: routeSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: selector
      type:
        scalar: string
      default: ""
    - name: tlsProfile
      type:
        namedType: com.github.openshift.api.config.v1.TLSProfileSpec
- name: com.github.openshift.api.operator.v1.IngressControllerTuningOptions
  map:
    fields:
    - name: clientFinTimeout
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: clientTimeout
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: connectTimeout
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: headerBufferBytes
      type:
        scalar: numeric
    - name: headerBufferMaxRewriteBytes
      type:
        scalar: numeric
    - name: healthCheckInterval
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: maxConnections
      type:
        scalar: numeric
    - name: reloadInterval
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: serverFinTimeout
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: serverTimeout
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: threadCount
      type:
        scalar: numeric
    - name: tlsInspectDelay
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: tunnelTimeout
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
- name: com.github.openshift.api.operator.v1.InsightsOperator
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.InsightsOperatorSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.InsightsOperatorStatus
      default: {}
- name: com.github.openshift.api.operator.v1.InsightsOperatorSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.InsightsOperatorStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: gatherStatus
      type:
        namedType: com.github.openshift.api.operator.v1.GatherStatus
      default: {}
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: insightsReport
      type:
        namedType: com.github.openshift.api.operator.v1.InsightsReport
      default: {}
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.InsightsReport
  map:
    fields:
    - name: downloadedAt
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
      default: {}
    - name: healthChecks
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.HealthCheck
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.KubeAPIServer
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.KubeAPIServerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.KubeAPIServerStatus
      default: {}
- name: com.github.openshift.api.operator.v1.KubeAPIServerSpec
  map:
    fields:
    - name: failedRevisionLimit
      type:
        scalar: numeric
    - name: forceRedeploymentReason
      type:
        scalar: string
      default: ""
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: succeededRevisionLimit
      type:
        scalar: numeric
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.KubeAPIServerStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: latestAvailableRevision
      type:
        scalar: numeric
    - name: latestAvailableRevisionReason
      type:
        scalar: string
    - name: nodeStatuses
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeStatus
          elementRelationship: associative
          keys:
          - nodeName
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: serviceAccountIssuers
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.ServiceAccountIssuerStatus
          elementRelationship: atomic
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.KubeControllerManager
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.KubeControllerManagerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.KubeControllerManagerStatus
      default: {}
- name: com.github.openshift.api.operator.v1.KubeControllerManagerSpec
  map:
    fields:
    - name: failedRevisionLimit
      type:
        scalar: numeric
    - name: forceRedeploymentReason
      type:
        scalar: string
      default: ""
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: succeededRevisionLimit
      type:
        scalar: numeric
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: useMoreSecureServiceCA
      type:
        scalar: boolean
      default: false
- name: com.github.openshift.api.operator.v1.KubeControllerManagerStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: latestAvailableRevision
      type:
        scalar: numeric
    - name: latestAvailableRevisionReason
      type:
        scalar: string
    - name: nodeStatuses
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeStatus
          elementRelationship: associative
          keys:
          - nodeName
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.KubeScheduler
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.KubeSchedulerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.KubeSchedulerStatus
      default: {}
- name: com.github.openshift.api.operator.v1.KubeSchedulerSpec
  map:
    fields:
    - name: failedRevisionLimit
      type:
        scalar: numeric
    - name: forceRedeploymentReason
      type:
        scalar: string
      default: ""
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: succeededRevisionLimit
      type:
        scalar: numeric
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.KubeSchedulerStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: latestAvailableRevision
      type:
        scalar: numeric
    - name: latestAvailableRevisionReason
      type:
        scalar: string
    - name: nodeStatuses
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeStatus
          elementRelationship: associative
          keys:
          - nodeName
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.KubeStorageVersionMigrator
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.KubeStorageVersionMigratorSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.KubeStorageVersionMigratorStatus
      default: {}
- name: com.github.openshift.api.operator.v1.KubeStorageVersionMigratorSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.KubeStorageVersionMigratorStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.LoadBalancerStrategy
  map:
    fields:
    - name: allowedSourceRanges
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: dnsManagementPolicy
      type:
        scalar: string
      default: Managed
    - name: providerParameters
      type:
        namedType: com.github.openshift.api.operator.v1.ProviderLoadBalancerParameters
    - name: scope
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.LoggingDestination
  map:
    fields:
    - name: container
      type:
        namedType: com.github.openshift.api.operator.v1.ContainerLoggingDestinationParameters
    - name: syslog
      type:
        namedType: com.github.openshift.api.operator.v1.SyslogLoggingDestinationParameters
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: container
        discriminatorValue: Container
      - fieldName: syslog
        discriminatorValue: Syslog
- name: com.github.openshift.api.operator.v1.MTUMigration
  map:
    fields:
    - name: machine
      type:
        namedType: com.github.openshift.api.operator.v1.MTUMigrationValues
    - name: network
      type:
        namedType: com.github.openshift.api.operator.v1.MTUMigrationValues
- name: com.github.openshift.api.operator.v1.MTUMigrationValues
  map:
    fields:
    - name: from
      type:
        scalar: numeric
    - name: to
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.MachineConfiguration
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.MachineConfigurationSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.MachineConfigurationStatus
      default: {}
- name: com.github.openshift.api.operator.v1.MachineConfigurationSpec
  map:
    fields:
    - name: failedRevisionLimit
      type:
        scalar: numeric
    - name: forceRedeploymentReason
      type:
        scalar: string
      default: ""
    - name: logLevel
      type:
        scalar: string
    - name: managedBootImages
      type:
        namedType: com.github.openshift.api.operator.v1.ManagedBootImages
      default: {}
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: nodeDisruptionPolicy
      type:
        namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicyConfig
      default: {}
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: succeededRevisionLimit
      type:
        scalar: numeric
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.MachineConfigurationStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
    - name: nodeDisruptionPolicyStatus
      type:
        namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatus
      default: {}
    - name: observedGeneration
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.MachineManager
  map:
    fields:
    - name: apiGroup
      type:
        scalar: string
      default: ""
    - name: resource
      type:
        scalar: string
      default: ""
    - name: selection
      type:
        namedType: com.github.openshift.api.operator.v1.MachineManagerSelector
      default: {}
- name: com.github.openshift.api.operator.v1.MachineManagerSelector
  map:
    fields:
    - name: mode
      type:
        scalar: string
      default: ""
    - name: partial
      type:
        namedType: com.github.openshift.api.operator.v1.PartialSelector
    unions:
    - discriminator: mode
      fields:
      - fieldName: partial
        discriminatorValue: Partial
- name: com.github.openshift.api.operator.v1.ManagedBootImages
  map:
    fields:
    - name: machineManagers
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.MachineManager
          elementRelationship: associative
          keys:
          - resource
          - apiGroup
- name: com.github.openshift.api.operator.v1.NetFlowConfig
  map:
    fields:
    - name: collectors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.Network
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.NetworkSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.NetworkStatus
      default: {}
- name: com.github.openshift.api.operator.v1.NetworkMigration
  map:
    fields:
    - name: features
      type:
        namedType: com.github.openshift.api.operator.v1.FeaturesMigration
    - name: mode
      type:
        scalar: string
      default: ""
    - name: mtu
      type:
        namedType: com.github.openshift.api.operator.v1.MTUMigration
    - name: networkType
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.NetworkSpec
  map:
    fields:
    - name: additionalNetworks
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.AdditionalNetworkDefinition
          elementRelationship: atomic
    - name: clusterNetwork
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.ClusterNetworkEntry
          elementRelationship: atomic
    - name: defaultNetwork
      type:
        namedType: com.github.openshift.api.operator.v1.DefaultNetworkDefinition
      default: {}
    - name: deployKubeProxy
      type:
        scalar: boolean
    - name: disableMultiNetwork
      type:
        scalar: boolean
    - name: disableNetworkDiagnostics
      type:
        scalar: boolean
      default: false
    - name: exportNetworkFlows
      type:
        namedType: com.github.openshift.api.operator.v1.ExportNetworkFlows
    - name: kubeProxyConfig
      type:
        namedType: com.github.openshift.api.operator.v1.ProxyConfig
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: migration
      type:
        namedType: com.github.openshift.api.operator.v1.NetworkMigration
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: serviceNetwork
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: useMultiNetworkPolicy
      type:
        scalar: boolean
- name: com.github.openshift.api.operator.v1.NetworkStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicyClusterStatus
  map:
    fields:
    - name: files
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusFile
          elementRelationship: associative
          keys:
          - path
    - name: sshkey
      type:
        namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusSSHKey
      default: {}
    - name: units
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusUnit
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicyConfig
  map:
    fields:
    - name: files
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecFile
          elementRelationship: associative
          keys:
          - path
    - name: sshkey
      type:
        namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecSSHKey
      default: {}
    - name: units
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecUnit
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecAction
  map:
    fields:
    - name: reload
      type:
        namedType: com.github.openshift.api.operator.v1.ReloadService
    - name: restart
      type:
        namedType: com.github.openshift.api.operator.v1.RestartService
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: reload
        discriminatorValue: Reload
      - fieldName: restart
        discriminatorValue: Restart
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecFile
  map:
    fields:
    - name: actions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecAction
          elementRelationship: atomic
    - name: path
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecSSHKey
  map:
    fields:
    - name: actions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecAction
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecUnit
  map:
    fields:
    - name: actions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicySpecAction
          elementRelationship: atomic
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatus
  map:
    fields:
    - name: clusterPolicies
      type:
        namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicyClusterStatus
      default: {}
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusAction
  map:
    fields:
    - name: reload
      type:
        namedType: com.github.openshift.api.operator.v1.ReloadService
    - name: restart
      type:
        namedType: com.github.openshift.api.operator.v1.RestartService
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: reload
        discriminatorValue: Reload
      - fieldName: restart
        discriminatorValue: Restart
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusFile
  map:
    fields:
    - name: actions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusAction
          elementRelationship: atomic
    - name: path
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusSSHKey
  map:
    fields:
    - name: actions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusAction
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusUnit
  map:
    fields:
    - name: actions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.NodeDisruptionPolicyStatusAction
          elementRelationship: atomic
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.NodePlacement
  map:
    fields:
    - name: nodeSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: tolerations
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Toleration
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.NodePortStrategy
  map:
    fields:
    - name: protocol
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.NodeStatus
  map:
    fields:
    - name: currentRevision
      type:
        scalar: numeric
      default: 0
    - name: lastFailedCount
      type:
        scalar: numeric
    - name: lastFailedReason
      type:
        scalar: string
    - name: lastFailedRevision
      type:
        scalar: numeric
    - name: lastFailedRevisionErrors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: lastFailedTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: lastFallbackCount
      type:
        scalar: numeric
    - name: nodeName
      type:
        scalar: string
      default: ""
    - name: targetRevision
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.OAuthAPIServerStatus
  map:
    fields:
    - name: latestAvailableRevision
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.OVNKubernetesConfig
  map:
    fields:
    - name: egressIPConfig
      type:
        namedType: com.github.openshift.api.operator.v1.EgressIPConfig
      default: {}
    - name: gatewayConfig
      type:
        namedType: com.github.openshift.api.operator.v1.GatewayConfig
    - name: genevePort
      type:
        scalar: numeric
    - name: hybridOverlayConfig
      type:
        namedType: com.github.openshift.api.operator.v1.HybridOverlayConfig
    - name: ipsecConfig
      type:
        namedType: com.github.openshift.api.operator.v1.IPsecConfig
      default:
        mode: Disabled
    - name: ipv4
      type:
        namedType: com.github.openshift.api.operator.v1.IPv4OVNKubernetesConfig
    - name: ipv6
      type:
        namedType: com.github.openshift.api.operator.v1.IPv6OVNKubernetesConfig
    - name: mtu
      type:
        scalar: numeric
    - name: policyAuditConfig
      type:
        namedType: com.github.openshift.api.operator.v1.PolicyAuditConfig
    - name: v4InternalSubnet
      type:
        scalar: string
    - name: v6InternalSubnet
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.OpenShiftAPIServer
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.OpenShiftAPIServerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.OpenShiftAPIServerStatus
      default: {}
- name: com.github.openshift.api.operator.v1.OpenShiftAPIServerSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.OpenShiftAPIServerStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: latestAvailableRevision
      type:
        scalar: numeric
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.OpenShiftControllerManager
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.OpenShiftControllerManagerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.OpenShiftControllerManagerStatus
      default: {}
- name: com.github.openshift.api.operator.v1.OpenShiftControllerManagerSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.OpenShiftControllerManagerStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.OpenShiftSDNConfig
  map:
    fields:
    - name: enableUnidling
      type:
        scalar: boolean
    - name: mode
      type:
        scalar: string
      default: ""
    - name: mtu
      type:
        scalar: numeric
    - name: useExternalOpenvswitch
      type:
        scalar: boolean
    - name: vxlanPort
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.OperatorCondition
  map:
    fields:
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
      default: {}
    - name: message
      type:
        scalar: string
    - name: reason
      type:
        scalar: string
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.PartialSelector
  map:
    fields:
    - name: machineResourceSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
- name: com.github.openshift.api.operator.v1.Perspective
  map:
    fields:
    - name: id
      type:
        scalar: string
      default: ""
    - name: pinnedResources
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.PinnedResourceReference
          elementRelationship: atomic
    - name: visibility
      type:
        namedType: com.github.openshift.api.operator.v1.PerspectiveVisibility
      default: {}
- name: com.github.openshift.api.operator.v1.PerspectiveVisibility
  map:
    fields:
    - name: accessReview
      type:
        namedType: com.github.openshift.api.operator.v1.ResourceAttributesAccessReview
    - name: state
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: state
      fields:
      - fieldName: accessReview
        discriminatorValue: AccessReview
- name: com.github.openshift.api.operator.v1.PinnedResourceReference
  map:
    fields:
    - name: group
      type:
        scalar: string
      default: ""
    - name: resource
      type:
        scalar: string
      default: ""
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.PolicyAuditConfig
  map:
    fields:
    - name: destination
      type:
        scalar: string
    - name: maxFileSize
      type:
        scalar: numeric
    - name: maxLogFiles
      type:
        scalar: numeric
    - name: rateLimit
      type:
        scalar: numeric
    - name: syslogFacility
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.PrivateStrategy
  map:
    fields:
    - name: protocol
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.ProjectAccess
  map:
    fields:
    - name: availableClusterRoles
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.ProviderLoadBalancerParameters
  map:
    fields:
    - name: aws
      type:
        namedType: com.github.openshift.api.operator.v1.AWSLoadBalancerParameters
    - name: gcp
      type:
        namedType: com.github.openshift.api.operator.v1.GCPLoadBalancerParameters
    - name: ibm
      type:
        namedType: com.github.openshift.api.operator.v1.IBMLoadBalancerParameters
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: aws
        discriminatorValue: AWS
      - fieldName: gcp
        discriminatorValue: GCP
      - fieldName: ibm
        discriminatorValue: IBM
- name: com.github.openshift.api.operator.v1.ProxyConfig
  map:
    fields:
    - name: bindAddress
      type:
        scalar: string
    - name: iptablesSyncPeriod
      type:
        scalar: string
    - name: proxyArguments
      type:
        map:
          elementType:
            list:
              elementType:
                scalar: string
              elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.QuickStarts
  map:
    fields:
    - name: disabled
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.ReloadService
  map:
    fields:
    - name: serviceName
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.ResourceAttributesAccessReview
  map:
    fields:
    - name: missing
      type:
        list:
          elementType:
            namedType: io.k8s.api.authorization.v1.ResourceAttributes
          elementRelationship: atomic
    - name: required
      type:
        list:
          elementType:
            namedType: io.k8s.api.authorization.v1.ResourceAttributes
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.RestartService
  map:
    fields:
    - name: serviceName
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.RouteAdmissionPolicy
  map:
    fields:
    - name: namespaceOwnership
      type:
        scalar: string
    - name: wildcardPolicy
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.SFlowConfig
  map:
    fields:
    - name: collectors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.Server
  map:
    fields:
    - name: forwardPlugin
      type:
        namedType: com.github.openshift.api.operator.v1.ForwardPlugin
      default: {}
    - name: name
      type:
        scalar: string
      default: ""
    - name: zones
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.ServiceAccountIssuerStatus
  map:
    fields:
    - name: expirationTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.ServiceCA
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.ServiceCASpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.ServiceCAStatus
      default: {}
- name: com.github.openshift.api.operator.v1.ServiceCASpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.ServiceCAStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.ServiceCatalogAPIServer
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.ServiceCatalogAPIServerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.ServiceCatalogAPIServerStatus
      default: {}
- name: com.github.openshift.api.operator.v1.ServiceCatalogAPIServerSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.ServiceCatalogAPIServerStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.ServiceCatalogControllerManager
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.ServiceCatalogControllerManagerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.ServiceCatalogControllerManagerStatus
      default: {}
- name: com.github.openshift.api.operator.v1.ServiceCatalogControllerManagerSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1.ServiceCatalogControllerManagerStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.SimpleMacvlanConfig
  map:
    fields:
    - name: ipamConfig
      type:
        namedType: com.github.openshift.api.operator.v1.IPAMConfig
    - name: master
      type:
        scalar: string
    - name: mode
      type:
        scalar: string
    - name: mtu
      type:
        scalar: numeric
- name: com.github.openshift.api.operator.v1.StaticIPAMAddresses
  map:
    fields:
    - name: address
      type:
        scalar: string
      default: ""
    - name: gateway
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.StaticIPAMConfig
  map:
    fields:
    - name: addresses
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.StaticIPAMAddresses
          elementRelationship: atomic
    - name: dns
      type:
        namedType: com.github.openshift.api.operator.v1.StaticIPAMDNS
    - name: routes
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.StaticIPAMRoutes
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.StaticIPAMDNS
  map:
    fields:
    - name: domain
      type:
        scalar: string
    - name: nameservers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: search
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.StaticIPAMRoutes
  map:
    fields:
    - name: destination
      type:
        scalar: string
      default: ""
    - name: gateway
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.StatuspageProvider
  map:
    fields:
    - name: pageID
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.Storage
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1.StorageSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1.StorageStatus
      default: {}
- name: com.github.openshift.api.operator.v1.StorageSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: vsphereStorageDriver
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.StorageStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1.SyslogLoggingDestinationParameters
  map:
    fields:
    - name: address
      type:
        scalar: string
      default: ""
    - name: facility
      type:
        scalar: string
    - name: maxLength
      type:
        scalar: numeric
    - name: port
      type:
        scalar: numeric
      default: 0
- name: com.github.openshift.api.operator.v1.Upstream
  map:
    fields:
    - name: address
      type:
        scalar: string
    - name: port
      type:
        scalar: numeric
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1.UpstreamResolvers
  map:
    fields:
    - name: policy
      type:
        scalar: string
    - name: protocolStrategy
      type:
        scalar: string
      default: ""
    - name: transportConfig
      type:
        namedType: com.github.openshift.api.operator.v1.DNSTransportConfig
      default: {}
    - name: upstreams
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.Upstream
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1.VSphereCSIDriverConfigSpec
  map:
    fields:
    - name: globalMaxSnapshotsPerBlockVolume
      type:
        scalar: numeric
    - name: granularMaxSnapshotsPerBlockVolumeInVSAN
      type:
        scalar: numeric
    - name: granularMaxSnapshotsPerBlockVolumeInVVOL
      type:
        scalar: numeric
    - name: topologyCategories
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1alpha1.BackupJobReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1alpha1.EtcdBackup
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1alpha1.EtcdBackupSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1alpha1.EtcdBackupStatus
      default: {}
- name: com.github.openshift.api.operator.v1alpha1.EtcdBackupSpec
  map:
    fields:
    - name: pvcName
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.operator.v1alpha1.EtcdBackupStatus
  map:
    fields:
    - name: backupJob
      type:
        namedType: com.github.openshift.api.operator.v1alpha1.BackupJobReference
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
- name: com.github.openshift.api.operator.v1alpha1.ImageContentSourcePolicy
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1alpha1.ImageContentSourcePolicySpec
      default: {}
- name: com.github.openshift.api.operator.v1alpha1.ImageContentSourcePolicySpec
  map:
    fields:
    - name: repositoryDigestMirrors
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1alpha1.RepositoryDigestMirrors
          elementRelationship: atomic
- name: com.github.openshift.api.operator.v1alpha1.OLM
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.operator.v1alpha1.OLMSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.operator.v1alpha1.OLMStatus
      default: {}
- name: com.github.openshift.api.operator.v1alpha1.OLMSpec
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: managementState
      type:
        scalar: string
      default: ""
    - name: observedConfig
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: operatorLogLevel
      type:
        scalar: string
    - name: unsupportedConfigOverrides
      type:
        namedType: __untyped_atomic_
      default: {}
- name: com.github.openshift.api.operator.v1alpha1.OLMStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.OperatorCondition
          elementRelationship: associative
          keys:
          - type
    - name: generations
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.operator.v1.GenerationStatus
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
    - name: readyReplicas
      type:
        scalar: numeric
      default: 0
    - name: version
      type:
        scalar: string
- name: com.github.openshift.api.operator.v1alpha1.RepositoryDigestMirrors
  map:
    fields:
    - name: mirrors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: source
      type:
        scalar: string
      default: ""
- name: io.k8s.api.authorization.v1.ResourceAttributes
  map:
    fields:
    - name: group
      type:
        scalar: string
    - name: name
      type:
        scalar: string
    - name: namespace
      type:
        scalar: string
    - name: resource
      type:
        scalar: string
    - name: subresource
      type:
        scalar: string
    - name: verb
      type:
        scalar: string
    - name: version
      type:
        scalar: string
- name: io.k8s.api.core.v1.LocalObjectReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.api.core.v1.Toleration
  map:
    fields:
    - name: effect
      type:
        scalar: string
    - name: key
      type:
        scalar: string
    - name: operator
      type:
        scalar: string
    - name: tolerationSeconds
      type:
        scalar: numeric
    - name: value
      type:
        scalar: string
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
  map:
    fields:
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
      default: {}
    - name: message
      type:
        scalar: string
      default: ""
    - name: observedGeneration
      type:
        scalar: numeric
    - name: reason
      type:
        scalar: string
      default: ""
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
  scalar: string
- name: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
  map:
    fields:
    - name: matchExpressions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
          elementRelationship: atomic
    - name: matchLabels
      type:
        map:
          elementType:
            scalar: string
    elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: operator
      type:
        scalar: string
      default: ""
    - name: values
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: fieldsType
      type:
        scalar: string
    - name: fieldsV1
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1
    - name: manager
      type:
        scalar: string
    - name: operation
      type:
        scalar: string
    - name: subresource
      type:
        scalar: string
    - name: time
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
- name: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
  map:
    fields:
    - name: annotations
      type:
        map:
          elementType:
            scalar: string
    - name: creationTimestamp
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
      default: {}
    - name: deletionGracePeriodSeconds
      type:
        scalar: numeric
    - name: deletionTimestamp
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: finalizers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: generateName
      type:
        scalar: string
    - name: generation
      type:
        scalar: numeric
    - name: labels
      type:
        map:
          elementType:
            scalar: string
    - name: managedFields
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
          elementRelationship: atomic
    - name: name
      type:
        scalar: string
    - name: namespace
      type:
        scalar: string
    - name: ownerReferences
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference
          elementRelationship: associative
          keys:
          - uid
    - name: resourceVersion
      type:
        scalar: string
    - name: selfLink
      type:
        scalar: string
    - name: uid
      type:
        scalar: string
- name: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
      default: ""
    - name: blockOwnerDeletion
      type:
        scalar: boolean
    - name: controller
      type:
        scalar: boolean
    - name: kind
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: uid
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Time
  scalar: untyped
- name: io.k8s.apimachinery.pkg.runtime.RawExtension
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: __untyped_atomic_
  scalar: untyped
  list:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
  map:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
- name: __untyped_deduced_
  scalar: untyped
  list:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
  map:
    elementType:
      namedType: __untyped_deduced_
    elementRelationship: separable
`)
