// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1alpha1 "github.com/openshift/api/machineconfiguration/v1alpha1"
	machineconfigurationv1alpha1 "github.com/openshift/client-go/machineconfiguration/applyconfigurations/machineconfiguration/v1alpha1"
	scheme "github.com/openshift/client-go/machineconfiguration/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// MachineConfigNodesGetter has a method to return a MachineConfigNodeInterface.
// A group's client should implement this interface.
type MachineConfigNodesGetter interface {
	MachineConfigNodes() MachineConfigNodeInterface
}

// MachineConfigNodeInterface has methods to work with MachineConfigNode resources.
type MachineConfigNodeInterface interface {
	Create(ctx context.Context, machineConfigNode *v1alpha1.MachineConfigNode, opts v1.CreateOptions) (*v1alpha1.MachineConfigNode, error)
	Update(ctx context.Context, machineConfigNode *v1alpha1.MachineConfigNode, opts v1.UpdateOptions) (*v1alpha1.MachineConfigNode, error)
	UpdateStatus(ctx context.Context, machineConfigNode *v1alpha1.MachineConfigNode, opts v1.UpdateOptions) (*v1alpha1.MachineConfigNode, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.MachineConfigNode, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.MachineConfigNodeList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.MachineConfigNode, err error)
	Apply(ctx context.Context, machineConfigNode *machineconfigurationv1alpha1.MachineConfigNodeApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.MachineConfigNode, err error)
	ApplyStatus(ctx context.Context, machineConfigNode *machineconfigurationv1alpha1.MachineConfigNodeApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.MachineConfigNode, err error)
	MachineConfigNodeExpansion
}

// machineConfigNodes implements MachineConfigNodeInterface
type machineConfigNodes struct {
	client rest.Interface
}

// newMachineConfigNodes returns a MachineConfigNodes
func newMachineConfigNodes(c *MachineconfigurationV1alpha1Client) *machineConfigNodes {
	return &machineConfigNodes{
		client: c.RESTClient(),
	}
}

// Get takes name of the machineConfigNode, and returns the corresponding machineConfigNode object, and an error if there is any.
func (c *machineConfigNodes) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.MachineConfigNode, err error) {
	result = &v1alpha1.MachineConfigNode{}
	err = c.client.Get().
		Resource("machineconfignodes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of MachineConfigNodes that match those selectors.
func (c *machineConfigNodes) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.MachineConfigNodeList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.MachineConfigNodeList{}
	err = c.client.Get().
		Resource("machineconfignodes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested machineConfigNodes.
func (c *machineConfigNodes) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("machineconfignodes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a machineConfigNode and creates it.  Returns the server's representation of the machineConfigNode, and an error, if there is any.
func (c *machineConfigNodes) Create(ctx context.Context, machineConfigNode *v1alpha1.MachineConfigNode, opts v1.CreateOptions) (result *v1alpha1.MachineConfigNode, err error) {
	result = &v1alpha1.MachineConfigNode{}
	err = c.client.Post().
		Resource("machineconfignodes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(machineConfigNode).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a machineConfigNode and updates it. Returns the server's representation of the machineConfigNode, and an error, if there is any.
func (c *machineConfigNodes) Update(ctx context.Context, machineConfigNode *v1alpha1.MachineConfigNode, opts v1.UpdateOptions) (result *v1alpha1.MachineConfigNode, err error) {
	result = &v1alpha1.MachineConfigNode{}
	err = c.client.Put().
		Resource("machineconfignodes").
		Name(machineConfigNode.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(machineConfigNode).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *machineConfigNodes) UpdateStatus(ctx context.Context, machineConfigNode *v1alpha1.MachineConfigNode, opts v1.UpdateOptions) (result *v1alpha1.MachineConfigNode, err error) {
	result = &v1alpha1.MachineConfigNode{}
	err = c.client.Put().
		Resource("machineconfignodes").
		Name(machineConfigNode.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(machineConfigNode).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the machineConfigNode and deletes it. Returns an error if one occurs.
func (c *machineConfigNodes) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("machineconfignodes").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *machineConfigNodes) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("machineconfignodes").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched machineConfigNode.
func (c *machineConfigNodes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.MachineConfigNode, err error) {
	result = &v1alpha1.MachineConfigNode{}
	err = c.client.Patch(pt).
		Resource("machineconfignodes").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied machineConfigNode.
func (c *machineConfigNodes) Apply(ctx context.Context, machineConfigNode *machineconfigurationv1alpha1.MachineConfigNodeApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.MachineConfigNode, err error) {
	if machineConfigNode == nil {
		return nil, fmt.Errorf("machineConfigNode provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(machineConfigNode)
	if err != nil {
		return nil, err
	}
	name := machineConfigNode.Name
	if name == nil {
		return nil, fmt.Errorf("machineConfigNode.Name must be provided to Apply")
	}
	result = &v1alpha1.MachineConfigNode{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("machineconfignodes").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *machineConfigNodes) ApplyStatus(ctx context.Context, machineConfigNode *machineconfigurationv1alpha1.MachineConfigNodeApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.MachineConfigNode, err error) {
	if machineConfigNode == nil {
		return nil, fmt.Errorf("machineConfigNode provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(machineConfigNode)
	if err != nil {
		return nil, err
	}

	name := machineConfigNode.Name
	if name == nil {
		return nil, fmt.Errorf("machineConfigNode.Name must be provided to Apply")
	}

	result = &v1alpha1.MachineConfigNode{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("machineconfignodes").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
