// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apiimagev1 "github.com/openshift/api/image/v1"
	internal "github.com/openshift/client-go/image/applyconfigurations/internal"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// ImageApplyConfiguration represents an declarative configuration of the Image type for use
// with apply.
type ImageApplyConfiguration struct {
	v1.TypeMetaApplyConfiguration    `json:",inline"`
	*v1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	DockerImageReference             *string                            `json:"dockerImageReference,omitempty"`
	DockerImageMetadata              *runtime.RawExtension              `json:"dockerImageMetadata,omitempty"`
	DockerImageMetadataVersion       *string                            `json:"dockerImageMetadataVersion,omitempty"`
	DockerImageManifest              *string                            `json:"dockerImageManifest,omitempty"`
	DockerImageLayers                []ImageLayerApplyConfiguration     `json:"dockerImageLayers,omitempty"`
	Signatures                       []ImageSignatureApplyConfiguration `json:"signatures,omitempty"`
	DockerImageSignatures            [][]byte                           `json:"dockerImageSignatures,omitempty"`
	DockerImageManifestMediaType     *string                            `json:"dockerImageManifestMediaType,omitempty"`
	DockerImageConfig                *string                            `json:"dockerImageConfig,omitempty"`
	DockerImageManifests             []ImageManifestApplyConfiguration  `json:"dockerImageManifests,omitempty"`
}

// Image constructs an declarative configuration of the Image type for use with
// apply.
func Image(name string) *ImageApplyConfiguration {
	b := &ImageApplyConfiguration{}
	b.WithName(name)
	b.WithKind("Image")
	b.WithAPIVersion("image.openshift.io/v1")
	return b
}

// ExtractImage extracts the applied configuration owned by fieldManager from
// image. If no managedFields are found in image for fieldManager, a
// ImageApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// image must be a unmodified Image API object that was retrieved from the Kubernetes API.
// ExtractImage provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
// Experimental!
func ExtractImage(image *apiimagev1.Image, fieldManager string) (*ImageApplyConfiguration, error) {
	return extractImage(image, fieldManager, "")
}

// ExtractImageStatus is the same as ExtractImage except
// that it extracts the status subresource applied configuration.
// Experimental!
func ExtractImageStatus(image *apiimagev1.Image, fieldManager string) (*ImageApplyConfiguration, error) {
	return extractImage(image, fieldManager, "status")
}

func extractImage(image *apiimagev1.Image, fieldManager string, subresource string) (*ImageApplyConfiguration, error) {
	b := &ImageApplyConfiguration{}
	err := managedfields.ExtractInto(image, internal.Parser().Type("com.github.openshift.api.image.v1.Image"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(image.Name)

	b.WithKind("Image")
	b.WithAPIVersion("image.openshift.io/v1")
	return b, nil
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithKind(value string) *ImageApplyConfiguration {
	b.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithAPIVersion(value string) *ImageApplyConfiguration {
	b.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithName(value string) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithGenerateName(value string) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithNamespace(value string) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithUID(value types.UID) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithResourceVersion(value string) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithGeneration(value int64) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithCreationTimestamp(value metav1.Time) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithDeletionTimestamp(value metav1.Time) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *ImageApplyConfiguration) WithLabels(entries map[string]string) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Labels == nil && len(entries) > 0 {
		b.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *ImageApplyConfiguration) WithAnnotations(entries map[string]string) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Annotations == nil && len(entries) > 0 {
		b.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *ImageApplyConfiguration) WithOwnerReferences(values ...*v1.OwnerReferenceApplyConfiguration) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.OwnerReferences = append(b.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *ImageApplyConfiguration) WithFinalizers(values ...string) *ImageApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.Finalizers = append(b.Finalizers, values[i])
	}
	return b
}

func (b *ImageApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &v1.ObjectMetaApplyConfiguration{}
	}
}

// WithDockerImageReference sets the DockerImageReference field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DockerImageReference field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithDockerImageReference(value string) *ImageApplyConfiguration {
	b.DockerImageReference = &value
	return b
}

// WithDockerImageMetadata sets the DockerImageMetadata field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DockerImageMetadata field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithDockerImageMetadata(value runtime.RawExtension) *ImageApplyConfiguration {
	b.DockerImageMetadata = &value
	return b
}

// WithDockerImageMetadataVersion sets the DockerImageMetadataVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DockerImageMetadataVersion field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithDockerImageMetadataVersion(value string) *ImageApplyConfiguration {
	b.DockerImageMetadataVersion = &value
	return b
}

// WithDockerImageManifest sets the DockerImageManifest field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DockerImageManifest field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithDockerImageManifest(value string) *ImageApplyConfiguration {
	b.DockerImageManifest = &value
	return b
}

// WithDockerImageLayers adds the given value to the DockerImageLayers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DockerImageLayers field.
func (b *ImageApplyConfiguration) WithDockerImageLayers(values ...*ImageLayerApplyConfiguration) *ImageApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDockerImageLayers")
		}
		b.DockerImageLayers = append(b.DockerImageLayers, *values[i])
	}
	return b
}

// WithSignatures adds the given value to the Signatures field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Signatures field.
func (b *ImageApplyConfiguration) WithSignatures(values ...*ImageSignatureApplyConfiguration) *ImageApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSignatures")
		}
		b.Signatures = append(b.Signatures, *values[i])
	}
	return b
}

// WithDockerImageSignatures adds the given value to the DockerImageSignatures field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DockerImageSignatures field.
func (b *ImageApplyConfiguration) WithDockerImageSignatures(values ...[]byte) *ImageApplyConfiguration {
	for i := range values {
		b.DockerImageSignatures = append(b.DockerImageSignatures, values[i])
	}
	return b
}

// WithDockerImageManifestMediaType sets the DockerImageManifestMediaType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DockerImageManifestMediaType field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithDockerImageManifestMediaType(value string) *ImageApplyConfiguration {
	b.DockerImageManifestMediaType = &value
	return b
}

// WithDockerImageConfig sets the DockerImageConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DockerImageConfig field is set to the value of the last call.
func (b *ImageApplyConfiguration) WithDockerImageConfig(value string) *ImageApplyConfiguration {
	b.DockerImageConfig = &value
	return b
}

// WithDockerImageManifests adds the given value to the DockerImageManifests field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DockerImageManifests field.
func (b *ImageApplyConfiguration) WithDockerImageManifests(values ...*ImageManifestApplyConfiguration) *ImageApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDockerImageManifests")
		}
		b.DockerImageManifests = append(b.DockerImageManifests, *values[i])
	}
	return b
}
