// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/openshift/api/config/v1"
	configv1 "github.com/openshift/client-go/config/applyconfigurations/config/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSchedulers implements SchedulerInterface
type FakeSchedulers struct {
	Fake *FakeConfigV1
}

var schedulersResource = v1.SchemeGroupVersion.WithResource("schedulers")

var schedulersKind = v1.SchemeGroupVersion.WithKind("Scheduler")

// Get takes name of the scheduler, and returns the corresponding scheduler object, and an error if there is any.
func (c *FakeSchedulers) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Scheduler, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(schedulersResource, name), &v1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Scheduler), err
}

// List takes label and field selectors, and returns the list of Schedulers that match those selectors.
func (c *FakeSchedulers) List(ctx context.Context, opts metav1.ListOptions) (result *v1.SchedulerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(schedulersResource, schedulersKind, opts), &v1.SchedulerList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.SchedulerList{ListMeta: obj.(*v1.SchedulerList).ListMeta}
	for _, item := range obj.(*v1.SchedulerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested schedulers.
func (c *FakeSchedulers) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(schedulersResource, opts))
}

// Create takes the representation of a scheduler and creates it.  Returns the server's representation of the scheduler, and an error, if there is any.
func (c *FakeSchedulers) Create(ctx context.Context, scheduler *v1.Scheduler, opts metav1.CreateOptions) (result *v1.Scheduler, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(schedulersResource, scheduler), &v1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Scheduler), err
}

// Update takes the representation of a scheduler and updates it. Returns the server's representation of the scheduler, and an error, if there is any.
func (c *FakeSchedulers) Update(ctx context.Context, scheduler *v1.Scheduler, opts metav1.UpdateOptions) (result *v1.Scheduler, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(schedulersResource, scheduler), &v1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Scheduler), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSchedulers) UpdateStatus(ctx context.Context, scheduler *v1.Scheduler, opts metav1.UpdateOptions) (*v1.Scheduler, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(schedulersResource, "status", scheduler), &v1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Scheduler), err
}

// Delete takes name of the scheduler and deletes it. Returns an error if one occurs.
func (c *FakeSchedulers) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(schedulersResource, name, opts), &v1.Scheduler{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSchedulers) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(schedulersResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1.SchedulerList{})
	return err
}

// Patch applies the patch and returns the patched scheduler.
func (c *FakeSchedulers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Scheduler, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(schedulersResource, name, pt, data, subresources...), &v1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Scheduler), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied scheduler.
func (c *FakeSchedulers) Apply(ctx context.Context, scheduler *configv1.SchedulerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Scheduler, err error) {
	if scheduler == nil {
		return nil, fmt.Errorf("scheduler provided to Apply must not be nil")
	}
	data, err := json.Marshal(scheduler)
	if err != nil {
		return nil, err
	}
	name := scheduler.Name
	if name == nil {
		return nil, fmt.Errorf("scheduler.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(schedulersResource, *name, types.ApplyPatchType, data), &v1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Scheduler), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeSchedulers) ApplyStatus(ctx context.Context, scheduler *configv1.SchedulerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Scheduler, err error) {
	if scheduler == nil {
		return nil, fmt.Errorf("scheduler provided to Apply must not be nil")
	}
	data, err := json.Marshal(scheduler)
	if err != nil {
		return nil, err
	}
	name := scheduler.Name
	if name == nil {
		return nil, fmt.Errorf("scheduler.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(schedulersResource, *name, types.ApplyPatchType, data, "status"), &v1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Scheduler), err
}
