// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/openshift/api/config/v1"
	configv1 "github.com/openshift/client-go/config/applyconfigurations/config/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeDNSes implements DNSInterface
type FakeDNSes struct {
	Fake *FakeConfigV1
}

var dnsesResource = v1.SchemeGroupVersion.WithResource("dnses")

var dnsesKind = v1.SchemeGroupVersion.WithKind("DNS")

// Get takes name of the dNS, and returns the corresponding dNS object, and an error if there is any.
func (c *FakeDNSes) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(dnsesResource, name), &v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DNS), err
}

// List takes label and field selectors, and returns the list of DNSes that match those selectors.
func (c *FakeDNSes) List(ctx context.Context, opts metav1.ListOptions) (result *v1.DNSList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(dnsesResource, dnsesKind, opts), &v1.DNSList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.DNSList{ListMeta: obj.(*v1.DNSList).ListMeta}
	for _, item := range obj.(*v1.DNSList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested dNSes.
func (c *FakeDNSes) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(dnsesResource, opts))
}

// Create takes the representation of a dNS and creates it.  Returns the server's representation of the dNS, and an error, if there is any.
func (c *FakeDNSes) Create(ctx context.Context, dNS *v1.DNS, opts metav1.CreateOptions) (result *v1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(dnsesResource, dNS), &v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DNS), err
}

// Update takes the representation of a dNS and updates it. Returns the server's representation of the dNS, and an error, if there is any.
func (c *FakeDNSes) Update(ctx context.Context, dNS *v1.DNS, opts metav1.UpdateOptions) (result *v1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(dnsesResource, dNS), &v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DNS), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeDNSes) UpdateStatus(ctx context.Context, dNS *v1.DNS, opts metav1.UpdateOptions) (*v1.DNS, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(dnsesResource, "status", dNS), &v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DNS), err
}

// Delete takes name of the dNS and deletes it. Returns an error if one occurs.
func (c *FakeDNSes) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(dnsesResource, name, opts), &v1.DNS{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDNSes) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(dnsesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1.DNSList{})
	return err
}

// Patch applies the patch and returns the patched dNS.
func (c *FakeDNSes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(dnsesResource, name, pt, data, subresources...), &v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DNS), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied dNS.
func (c *FakeDNSes) Apply(ctx context.Context, dNS *configv1.DNSApplyConfiguration, opts metav1.ApplyOptions) (result *v1.DNS, err error) {
	if dNS == nil {
		return nil, fmt.Errorf("dNS provided to Apply must not be nil")
	}
	data, err := json.Marshal(dNS)
	if err != nil {
		return nil, err
	}
	name := dNS.Name
	if name == nil {
		return nil, fmt.Errorf("dNS.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(dnsesResource, *name, types.ApplyPatchType, data), &v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DNS), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeDNSes) ApplyStatus(ctx context.Context, dNS *configv1.DNSApplyConfiguration, opts metav1.ApplyOptions) (result *v1.DNS, err error) {
	if dNS == nil {
		return nil, fmt.Errorf("dNS provided to Apply must not be nil")
	}
	data, err := json.Marshal(dNS)
	if err != nil {
		return nil, err
	}
	name := dNS.Name
	if name == nil {
		return nil, fmt.Errorf("dNS.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(dnsesResource, *name, types.ApplyPatchType, data, "status"), &v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DNS), err
}
