package autogeneratedskip

import (
	"testing"

	"github.com/chigopher/pathlib"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestFooExists(t *testing.T) {
	mockFile := pathlib.NewPath("./mocks_testify_autogeneratedskip_test.go")
	mockContents, err := mockFile.ReadFile()
	require.NoError(t, err)

	assert.NotContains(t, string(mockContents), "func NewMockBar", "mock for type Bar was generated when it shouldn't have been because it's in an auto-generated file.")
	assert.Contains(t, string(mockContents), "func NewMockFoo")
}
