// Code generated by smithy-go-codegen DO NOT EDIT.

package route53

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the private hosted zones that a specified VPC is associated with,
// regardless of which Amazon Web Services account or Amazon Web Services service
// owns the hosted zones. The HostedZoneOwner structure in the response contains
// one of the following values:
//
//   - An OwningAccount element, which contains the account number of either the
//     current Amazon Web Services account or another Amazon Web Services account. Some
//     services, such as Cloud Map, create hosted zones using the current account.
//
//   - An OwningService element, which identifies the Amazon Web Services service
//     that created and owns the hosted zone. For example, if a hosted zone was created
//     by Amazon Elastic File System (Amazon EFS), the value of Owner is
//     efs.amazonaws.com .
//
// When listing private hosted zones, the hosted zone and the Amazon VPC must
// belong to the same partition where the hosted zones were created. A partition is
// a group of Amazon Web Services Regions. Each Amazon Web Services account is
// scoped to one partition.
//
// The following are the supported partitions:
//
//   - aws - Amazon Web Services Regions
//
//   - aws-cn - China Regions
//
//   - aws-us-gov - Amazon Web Services GovCloud (US) Region
//
// For more information, see [Access Management] in the Amazon Web Services General Reference.
//
// [Access Management]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
func (c *Client) ListHostedZonesByVPC(ctx context.Context, params *ListHostedZonesByVPCInput, optFns ...func(*Options)) (*ListHostedZonesByVPCOutput, error) {
	if params == nil {
		params = &ListHostedZonesByVPCInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListHostedZonesByVPC", params, optFns, c.addOperationListHostedZonesByVPCMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListHostedZonesByVPCOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Lists all the private hosted zones that a specified VPC is associated with,
// regardless of which Amazon Web Services account created the hosted zones.
type ListHostedZonesByVPCInput struct {

	// The ID of the Amazon VPC that you want to list hosted zones for.
	//
	// This member is required.
	VPCId *string

	// For the Amazon VPC that you specified for VPCId , the Amazon Web Services Region
	// that you created the VPC in.
	//
	// This member is required.
	VPCRegion types.VPCRegion

	// (Optional) The maximum number of hosted zones that you want Amazon Route 53 to
	// return. If the specified VPC is associated with more than MaxItems hosted
	// zones, the response includes a NextToken element. NextToken contains an
	// encrypted token that identifies the first hosted zone that Route 53 will return
	// if you submit another request.
	MaxItems *int32

	// If the previous response included a NextToken element, the specified VPC is
	// associated with more hosted zones. To get more hosted zones, submit another
	// ListHostedZonesByVPC request.
	//
	// For the value of NextToken , specify the value of NextToken from the previous
	// response.
	//
	// If the previous response didn't include a NextToken element, there are no more
	// hosted zones to get.
	NextToken *string

	noSmithyDocumentSerde
}

type ListHostedZonesByVPCOutput struct {

	// A list that contains one HostedZoneSummary element for each hosted zone that
	// the specified Amazon VPC is associated with. Each HostedZoneSummary element
	// contains the hosted zone name and ID, and information about who owns the hosted
	// zone.
	//
	// This member is required.
	HostedZoneSummaries []types.HostedZoneSummary

	// The value that you specified for MaxItems in the most recent
	// ListHostedZonesByVPC request.
	//
	// This member is required.
	MaxItems *int32

	// The value that you will use for NextToken in the next ListHostedZonesByVPC
	// request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListHostedZonesByVPCMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListHostedZonesByVPC{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListHostedZonesByVPC{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListHostedZonesByVPC"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListHostedZonesByVPCValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListHostedZonesByVPC(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListHostedZonesByVPC(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListHostedZonesByVPC",
	}
}
