/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
	"time"
)

// checks if the StatusApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &StatusApiModel{}

// StatusApiModel Details of the test run status.
type StatusApiModel struct {
	// Type of simple test run status: `created`, `queued`, `initializing`, `running`, `processing_metrics`, `completed` or `aborted`.
	Type string `json:"type"`
	// Date and time when the test run entered the status.
	Entered              time.Time                   `json:"entered"`
	Extra                NullableStatusExtraApiModel `json:"extra,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _StatusApiModel StatusApiModel

// NewStatusApiModel instantiates a new StatusApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewStatusApiModel(type_ string, entered time.Time) *StatusApiModel {
	this := StatusApiModel{}
	this.Type = type_
	this.Entered = entered
	return &this
}

// NewStatusApiModelWithDefaults instantiates a new StatusApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewStatusApiModelWithDefaults() *StatusApiModel {
	this := StatusApiModel{}
	return &this
}

// GetType returns the Type field value
func (o *StatusApiModel) GetType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *StatusApiModel) GetTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value
func (o *StatusApiModel) SetType(v string) {
	o.Type = v
}

// GetEntered returns the Entered field value
func (o *StatusApiModel) GetEntered() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.Entered
}

// GetEnteredOk returns a tuple with the Entered field value
// and a boolean to check if the value has been set.
func (o *StatusApiModel) GetEnteredOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Entered, true
}

// SetEntered sets field value
func (o *StatusApiModel) SetEntered(v time.Time) {
	o.Entered = v
}

// GetExtra returns the Extra field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *StatusApiModel) GetExtra() StatusExtraApiModel {
	if o == nil || IsNil(o.Extra.Get()) {
		var ret StatusExtraApiModel
		return ret
	}
	return *o.Extra.Get()
}

// GetExtraOk returns a tuple with the Extra field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *StatusApiModel) GetExtraOk() (*StatusExtraApiModel, bool) {
	if o == nil {
		return nil, false
	}
	return o.Extra.Get(), o.Extra.IsSet()
}

// HasExtra returns a boolean if a field has been set.
func (o *StatusApiModel) HasExtra() bool {
	if o != nil && o.Extra.IsSet() {
		return true
	}

	return false
}

// SetExtra gets a reference to the given NullableStatusExtraApiModel and assigns it to the Extra field.
func (o *StatusApiModel) SetExtra(v StatusExtraApiModel) {
	o.Extra.Set(&v)
}

// SetExtraNil sets the value for Extra to be an explicit nil
func (o *StatusApiModel) SetExtraNil() {
	o.Extra.Set(nil)
}

// UnsetExtra ensures that no value is present for Extra, not even an explicit nil
func (o *StatusApiModel) UnsetExtra() {
	o.Extra.Unset()
}

func (o StatusApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o StatusApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["type"] = o.Type
	toSerialize["entered"] = o.Entered
	if o.Extra.IsSet() {
		toSerialize["extra"] = o.Extra.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *StatusApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"type",
		"entered",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varStatusApiModel := _StatusApiModel{}

	err = json.Unmarshal(data, &varStatusApiModel)

	if err != nil {
		return err
	}

	*o = StatusApiModel(varStatusApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "type")
		delete(additionalProperties, "entered")
		delete(additionalProperties, "extra")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableStatusApiModel struct {
	value *StatusApiModel
	isSet bool
}

func (v NullableStatusApiModel) Get() *StatusApiModel {
	return v.value
}

func (v *NullableStatusApiModel) Set(val *StatusApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableStatusApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableStatusApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableStatusApiModel(val *StatusApiModel) *NullableStatusApiModel {
	return &NullableStatusApiModel{value: val, isSet: true}
}

func (v NullableStatusApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableStatusApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
