/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
)

// checks if the Options type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Options{}

// Options struct for Options
type Options struct {
	Cloud                *OptionsCloud `json:"cloud,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _Options Options

// NewOptions instantiates a new Options object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewOptions() *Options {
	this := Options{}
	return &this
}

// NewOptionsWithDefaults instantiates a new Options object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewOptionsWithDefaults() *Options {
	this := Options{}
	return &this
}

// GetCloud returns the Cloud field value if set, zero value otherwise.
func (o *Options) GetCloud() OptionsCloud {
	if o == nil || IsNil(o.Cloud) {
		var ret OptionsCloud
		return ret
	}
	return *o.Cloud
}

// GetCloudOk returns a tuple with the Cloud field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Options) GetCloudOk() (*OptionsCloud, bool) {
	if o == nil || IsNil(o.Cloud) {
		return nil, false
	}
	return o.Cloud, true
}

// HasCloud returns a boolean if a field has been set.
func (o *Options) HasCloud() bool {
	if o != nil && !IsNil(o.Cloud) {
		return true
	}

	return false
}

// SetCloud gets a reference to the given OptionsCloud and assigns it to the Cloud field.
func (o *Options) SetCloud(v OptionsCloud) {
	o.Cloud = &v
}

func (o Options) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Options) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Cloud) {
		toSerialize["cloud"] = o.Cloud
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *Options) UnmarshalJSON(data []byte) (err error) {
	varOptions := _Options{}

	err = json.Unmarshal(data, &varOptions)

	if err != nil {
		return err
	}

	*o = Options(varOptions)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "cloud")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableOptions struct {
	value *Options
	isSet bool
}

func (v NullableOptions) Get() *Options {
	return v.value
}

func (v *NullableOptions) Set(val *Options) {
	v.value = val
	v.isSet = true
}

func (v NullableOptions) IsSet() bool {
	return v.isSet
}

func (v *NullableOptions) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableOptions(val *Options) *NullableOptions {
	return &NullableOptions{value: val, isSet: true}
}

func (v NullableOptions) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableOptions) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
