/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the ErrorResponseApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ErrorResponseApiModel{}

// ErrorResponseApiModel struct for ErrorResponseApiModel
type ErrorResponseApiModel struct {
	Error                ErrorApiModel `json:"error"`
	AdditionalProperties map[string]interface{}
}

type _ErrorResponseApiModel ErrorResponseApiModel

// NewErrorResponseApiModel instantiates a new ErrorResponseApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewErrorResponseApiModel(error_ ErrorApiModel) *ErrorResponseApiModel {
	this := ErrorResponseApiModel{}
	this.Error = error_
	return &this
}

// NewErrorResponseApiModelWithDefaults instantiates a new ErrorResponseApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewErrorResponseApiModelWithDefaults() *ErrorResponseApiModel {
	this := ErrorResponseApiModel{}
	return &this
}

// GetError returns the Error field value
func (o *ErrorResponseApiModel) GetError() ErrorApiModel {
	if o == nil {
		var ret ErrorApiModel
		return ret
	}

	return o.Error
}

// GetErrorOk returns a tuple with the Error field value
// and a boolean to check if the value has been set.
func (o *ErrorResponseApiModel) GetErrorOk() (*ErrorApiModel, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Error, true
}

// SetError sets field value
func (o *ErrorResponseApiModel) SetError(v ErrorApiModel) {
	o.Error = v
}

func (o ErrorResponseApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ErrorResponseApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["error"] = o.Error

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ErrorResponseApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"error",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varErrorResponseApiModel := _ErrorResponseApiModel{}

	err = json.Unmarshal(data, &varErrorResponseApiModel)

	if err != nil {
		return err
	}

	*o = ErrorResponseApiModel(varErrorResponseApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "error")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableErrorResponseApiModel struct {
	value *ErrorResponseApiModel
	isSet bool
}

func (v NullableErrorResponseApiModel) Get() *ErrorResponseApiModel {
	return v.value
}

func (v *NullableErrorResponseApiModel) Set(val *ErrorResponseApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableErrorResponseApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableErrorResponseApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableErrorResponseApiModel(val *ErrorResponseApiModel) *NullableErrorResponseApiModel {
	return &NullableErrorResponseApiModel{value: val, isSet: true}
}

func (v NullableErrorResponseApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableErrorResponseApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
