/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the AllowedLoadZoneToUpdateApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AllowedLoadZoneToUpdateApiModel{}

// AllowedLoadZoneToUpdateApiModel struct for AllowedLoadZoneToUpdateApiModel
type AllowedLoadZoneToUpdateApiModel struct {
	// ID of the load zone.
	Id                   int32 `json:"id"`
	AdditionalProperties map[string]interface{}
}

type _AllowedLoadZoneToUpdateApiModel AllowedLoadZoneToUpdateApiModel

// NewAllowedLoadZoneToUpdateApiModel instantiates a new AllowedLoadZoneToUpdateApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAllowedLoadZoneToUpdateApiModel(id int32) *AllowedLoadZoneToUpdateApiModel {
	this := AllowedLoadZoneToUpdateApiModel{}
	this.Id = id
	return &this
}

// NewAllowedLoadZoneToUpdateApiModelWithDefaults instantiates a new AllowedLoadZoneToUpdateApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAllowedLoadZoneToUpdateApiModelWithDefaults() *AllowedLoadZoneToUpdateApiModel {
	this := AllowedLoadZoneToUpdateApiModel{}
	return &this
}

// GetId returns the Id field value
func (o *AllowedLoadZoneToUpdateApiModel) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *AllowedLoadZoneToUpdateApiModel) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *AllowedLoadZoneToUpdateApiModel) SetId(v int32) {
	o.Id = v
}

func (o AllowedLoadZoneToUpdateApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AllowedLoadZoneToUpdateApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AllowedLoadZoneToUpdateApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varAllowedLoadZoneToUpdateApiModel := _AllowedLoadZoneToUpdateApiModel{}

	err = json.Unmarshal(data, &varAllowedLoadZoneToUpdateApiModel)

	if err != nil {
		return err
	}

	*o = AllowedLoadZoneToUpdateApiModel(varAllowedLoadZoneToUpdateApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "id")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAllowedLoadZoneToUpdateApiModel struct {
	value *AllowedLoadZoneToUpdateApiModel
	isSet bool
}

func (v NullableAllowedLoadZoneToUpdateApiModel) Get() *AllowedLoadZoneToUpdateApiModel {
	return v.value
}

func (v *NullableAllowedLoadZoneToUpdateApiModel) Set(val *AllowedLoadZoneToUpdateApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableAllowedLoadZoneToUpdateApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableAllowedLoadZoneToUpdateApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAllowedLoadZoneToUpdateApiModel(val *AllowedLoadZoneToUpdateApiModel) *NullableAllowedLoadZoneToUpdateApiModel {
	return &NullableAllowedLoadZoneToUpdateApiModel{value: val, isSet: true}
}

func (v NullableAllowedLoadZoneToUpdateApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAllowedLoadZoneToUpdateApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
