// Package bluetoothemulation provides the Chrome DevTools Protocol
// commands, types, and events for the BluetoothEmulation domain.
//
// This domain allows configuring virtual Bluetooth devices to test the
// web-bluetooth API.
//
// Generated by the cdproto-gen command.
package bluetoothemulation

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// EnableParams enable the BluetoothEmulation domain.
type EnableParams struct {
	State       CentralState `json:"state"`       // State of the simulated central.
	LeSupported bool         `json:"leSupported"` // If the simulated central supports low-energy.
}

// Enable enable the BluetoothEmulation domain.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-enable
//
// parameters:
//
//	state - State of the simulated central.
//	leSupported - If the simulated central supports low-energy.
func Enable(state CentralState, leSupported bool) *EnableParams {
	return &EnableParams{
		State:       state,
		LeSupported: leSupported,
	}
}

// Do executes BluetoothEmulation.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, p, nil)
}

// SetSimulatedCentralStateParams set the state of the simulated central.
type SetSimulatedCentralStateParams struct {
	State CentralState `json:"state"` // State of the simulated central.
}

// SetSimulatedCentralState set the state of the simulated central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-setSimulatedCentralState
//
// parameters:
//
//	state - State of the simulated central.
func SetSimulatedCentralState(state CentralState) *SetSimulatedCentralStateParams {
	return &SetSimulatedCentralStateParams{
		State: state,
	}
}

// Do executes BluetoothEmulation.setSimulatedCentralState against the provided context.
func (p *SetSimulatedCentralStateParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetSimulatedCentralState, p, nil)
}

// DisableParams disable the BluetoothEmulation domain.
type DisableParams struct{}

// Disable disable the BluetoothEmulation domain.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-disable
func Disable() *DisableParams {
	return &DisableParams{}
}

// Do executes BluetoothEmulation.disable against the provided context.
func (p *DisableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisable, nil, nil)
}

// SimulatePreconnectedPeripheralParams simulates a peripheral with
// |address|, |name| and |knownServiceUuids| that has already been connected to
// the system.
type SimulatePreconnectedPeripheralParams struct {
	Address           string              `json:"address"`
	Name              string              `json:"name"`
	ManufacturerData  []*ManufacturerData `json:"manufacturerData"`
	KnownServiceUUIDs []string            `json:"knownServiceUuids"`
}

// SimulatePreconnectedPeripheral simulates a peripheral with |address|,
// |name| and |knownServiceUuids| that has already been connected to the system.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-simulatePreconnectedPeripheral
//
// parameters:
//
//	address
//	name
//	manufacturerData
//	knownServiceUUIDs
func SimulatePreconnectedPeripheral(address string, name string, manufacturerData []*ManufacturerData, knownServiceUUIDs []string) *SimulatePreconnectedPeripheralParams {
	return &SimulatePreconnectedPeripheralParams{
		Address:           address,
		Name:              name,
		ManufacturerData:  manufacturerData,
		KnownServiceUUIDs: knownServiceUUIDs,
	}
}

// Do executes BluetoothEmulation.simulatePreconnectedPeripheral against the provided context.
func (p *SimulatePreconnectedPeripheralParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSimulatePreconnectedPeripheral, p, nil)
}

// SimulateAdvertisementParams simulates an advertisement packet described in
// |entry| being received by the central.
type SimulateAdvertisementParams struct {
	Entry *ScanEntry `json:"entry"`
}

// SimulateAdvertisement simulates an advertisement packet described in
// |entry| being received by the central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-simulateAdvertisement
//
// parameters:
//
//	entry
func SimulateAdvertisement(entry *ScanEntry) *SimulateAdvertisementParams {
	return &SimulateAdvertisementParams{
		Entry: entry,
	}
}

// Do executes BluetoothEmulation.simulateAdvertisement against the provided context.
func (p *SimulateAdvertisementParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSimulateAdvertisement, p, nil)
}

// SimulateGATTOperationResponseParams simulates the response code from the
// peripheral with |address| for a GATT operation of |type|. The |code| value
// follows the HCI Error Codes from Bluetooth Core Specification Vol 2 Part D
// 1.3 List Of Error Codes.
type SimulateGATTOperationResponseParams struct {
	Address string            `json:"address"`
	Type    GATTOperationType `json:"type"`
	Code    int64             `json:"code"`
}

// SimulateGATTOperationResponse simulates the response code from the
// peripheral with |address| for a GATT operation of |type|. The |code| value
// follows the HCI Error Codes from Bluetooth Core Specification Vol 2 Part D
// 1.3 List Of Error Codes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-simulateGATTOperationResponse
//
// parameters:
//
//	address
//	type
//	code
func SimulateGATTOperationResponse(address string, typeVal GATTOperationType, code int64) *SimulateGATTOperationResponseParams {
	return &SimulateGATTOperationResponseParams{
		Address: address,
		Type:    typeVal,
		Code:    code,
	}
}

// Do executes BluetoothEmulation.simulateGATTOperationResponse against the provided context.
func (p *SimulateGATTOperationResponseParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSimulateGATTOperationResponse, p, nil)
}

// SimulateCharacteristicOperationResponseParams simulates the response from
// the characteristic with |characteristicId| for a characteristic operation of
// |type|. The |code| value follows the Error Codes from Bluetooth Core
// Specification Vol 3 Part F 3.4.1.1 Error Response. The |data| is expected to
// exist when simulating a successful read operation response.
type SimulateCharacteristicOperationResponseParams struct {
	CharacteristicID string                      `json:"characteristicId"`
	Type             CharacteristicOperationType `json:"type"`
	Code             int64                       `json:"code"`
	Data             string                      `json:"data,omitempty,omitzero"`
}

// SimulateCharacteristicOperationResponse simulates the response from the
// characteristic with |characteristicId| for a characteristic operation of
// |type|. The |code| value follows the Error Codes from Bluetooth Core
// Specification Vol 3 Part F 3.4.1.1 Error Response. The |data| is expected to
// exist when simulating a successful read operation response.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-simulateCharacteristicOperationResponse
//
// parameters:
//
//	characteristicID
//	type
//	code
func SimulateCharacteristicOperationResponse(characteristicID string, typeVal CharacteristicOperationType, code int64) *SimulateCharacteristicOperationResponseParams {
	return &SimulateCharacteristicOperationResponseParams{
		CharacteristicID: characteristicID,
		Type:             typeVal,
		Code:             code,
	}
}

// WithData [no description].
func (p SimulateCharacteristicOperationResponseParams) WithData(data string) *SimulateCharacteristicOperationResponseParams {
	p.Data = data
	return &p
}

// Do executes BluetoothEmulation.simulateCharacteristicOperationResponse against the provided context.
func (p *SimulateCharacteristicOperationResponseParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSimulateCharacteristicOperationResponse, p, nil)
}

// SimulateDescriptorOperationResponseParams simulates the response from the
// descriptor with |descriptorId| for a descriptor operation of |type|. The
// |code| value follows the Error Codes from Bluetooth Core Specification Vol 3
// Part F 3.4.1.1 Error Response. The |data| is expected to exist when
// simulating a successful read operation response.
type SimulateDescriptorOperationResponseParams struct {
	DescriptorID string                  `json:"descriptorId"`
	Type         DescriptorOperationType `json:"type"`
	Code         int64                   `json:"code"`
	Data         string                  `json:"data,omitempty,omitzero"`
}

// SimulateDescriptorOperationResponse simulates the response from the
// descriptor with |descriptorId| for a descriptor operation of |type|. The
// |code| value follows the Error Codes from Bluetooth Core Specification Vol 3
// Part F 3.4.1.1 Error Response. The |data| is expected to exist when
// simulating a successful read operation response.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-simulateDescriptorOperationResponse
//
// parameters:
//
//	descriptorID
//	type
//	code
func SimulateDescriptorOperationResponse(descriptorID string, typeVal DescriptorOperationType, code int64) *SimulateDescriptorOperationResponseParams {
	return &SimulateDescriptorOperationResponseParams{
		DescriptorID: descriptorID,
		Type:         typeVal,
		Code:         code,
	}
}

// WithData [no description].
func (p SimulateDescriptorOperationResponseParams) WithData(data string) *SimulateDescriptorOperationResponseParams {
	p.Data = data
	return &p
}

// Do executes BluetoothEmulation.simulateDescriptorOperationResponse against the provided context.
func (p *SimulateDescriptorOperationResponseParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSimulateDescriptorOperationResponse, p, nil)
}

// AddServiceParams adds a service with |serviceUuid| to the peripheral with
// |address|.
type AddServiceParams struct {
	Address     string `json:"address"`
	ServiceUUID string `json:"serviceUuid"`
}

// AddService adds a service with |serviceUuid| to the peripheral with
// |address|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-addService
//
// parameters:
//
//	address
//	serviceUUID
func AddService(address string, serviceUUID string) *AddServiceParams {
	return &AddServiceParams{
		Address:     address,
		ServiceUUID: serviceUUID,
	}
}

// AddServiceReturns return values.
type AddServiceReturns struct {
	ServiceID string `json:"serviceId,omitempty,omitzero"` // An identifier that uniquely represents this service.
}

// Do executes BluetoothEmulation.addService against the provided context.
//
// returns:
//
//	serviceID - An identifier that uniquely represents this service.
func (p *AddServiceParams) Do(ctx context.Context) (serviceID string, err error) {
	// execute
	var res AddServiceReturns
	err = cdp.Execute(ctx, CommandAddService, p, &res)
	if err != nil {
		return "", err
	}

	return res.ServiceID, nil
}

// RemoveServiceParams removes the service respresented by |serviceId| from
// the simulated central.
type RemoveServiceParams struct {
	ServiceID string `json:"serviceId"`
}

// RemoveService removes the service respresented by |serviceId| from the
// simulated central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-removeService
//
// parameters:
//
//	serviceID
func RemoveService(serviceID string) *RemoveServiceParams {
	return &RemoveServiceParams{
		ServiceID: serviceID,
	}
}

// Do executes BluetoothEmulation.removeService against the provided context.
func (p *RemoveServiceParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveService, p, nil)
}

// AddCharacteristicParams adds a characteristic with |characteristicUuid|
// and |properties| to the service represented by |serviceId|.
type AddCharacteristicParams struct {
	ServiceID          string                    `json:"serviceId"`
	CharacteristicUUID string                    `json:"characteristicUuid"`
	Properties         *CharacteristicProperties `json:"properties"`
}

// AddCharacteristic adds a characteristic with |characteristicUuid| and
// |properties| to the service represented by |serviceId|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-addCharacteristic
//
// parameters:
//
//	serviceID
//	characteristicUUID
//	properties
func AddCharacteristic(serviceID string, characteristicUUID string, properties *CharacteristicProperties) *AddCharacteristicParams {
	return &AddCharacteristicParams{
		ServiceID:          serviceID,
		CharacteristicUUID: characteristicUUID,
		Properties:         properties,
	}
}

// AddCharacteristicReturns return values.
type AddCharacteristicReturns struct {
	CharacteristicID string `json:"characteristicId,omitempty,omitzero"` // An identifier that uniquely represents this characteristic.
}

// Do executes BluetoothEmulation.addCharacteristic against the provided context.
//
// returns:
//
//	characteristicID - An identifier that uniquely represents this characteristic.
func (p *AddCharacteristicParams) Do(ctx context.Context) (characteristicID string, err error) {
	// execute
	var res AddCharacteristicReturns
	err = cdp.Execute(ctx, CommandAddCharacteristic, p, &res)
	if err != nil {
		return "", err
	}

	return res.CharacteristicID, nil
}

// RemoveCharacteristicParams removes the characteristic respresented by
// |characteristicId| from the simulated central.
type RemoveCharacteristicParams struct {
	CharacteristicID string `json:"characteristicId"`
}

// RemoveCharacteristic removes the characteristic respresented by
// |characteristicId| from the simulated central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-removeCharacteristic
//
// parameters:
//
//	characteristicID
func RemoveCharacteristic(characteristicID string) *RemoveCharacteristicParams {
	return &RemoveCharacteristicParams{
		CharacteristicID: characteristicID,
	}
}

// Do executes BluetoothEmulation.removeCharacteristic against the provided context.
func (p *RemoveCharacteristicParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveCharacteristic, p, nil)
}

// AddDescriptorParams adds a descriptor with |descriptorUuid| to the
// characteristic respresented by |characteristicId|.
type AddDescriptorParams struct {
	CharacteristicID string `json:"characteristicId"`
	DescriptorUUID   string `json:"descriptorUuid"`
}

// AddDescriptor adds a descriptor with |descriptorUuid| to the
// characteristic respresented by |characteristicId|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-addDescriptor
//
// parameters:
//
//	characteristicID
//	descriptorUUID
func AddDescriptor(characteristicID string, descriptorUUID string) *AddDescriptorParams {
	return &AddDescriptorParams{
		CharacteristicID: characteristicID,
		DescriptorUUID:   descriptorUUID,
	}
}

// AddDescriptorReturns return values.
type AddDescriptorReturns struct {
	DescriptorID string `json:"descriptorId,omitempty,omitzero"` // An identifier that uniquely represents this descriptor.
}

// Do executes BluetoothEmulation.addDescriptor against the provided context.
//
// returns:
//
//	descriptorID - An identifier that uniquely represents this descriptor.
func (p *AddDescriptorParams) Do(ctx context.Context) (descriptorID string, err error) {
	// execute
	var res AddDescriptorReturns
	err = cdp.Execute(ctx, CommandAddDescriptor, p, &res)
	if err != nil {
		return "", err
	}

	return res.DescriptorID, nil
}

// RemoveDescriptorParams removes the descriptor with |descriptorId| from the
// simulated central.
type RemoveDescriptorParams struct {
	DescriptorID string `json:"descriptorId"`
}

// RemoveDescriptor removes the descriptor with |descriptorId| from the
// simulated central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-removeDescriptor
//
// parameters:
//
//	descriptorID
func RemoveDescriptor(descriptorID string) *RemoveDescriptorParams {
	return &RemoveDescriptorParams{
		DescriptorID: descriptorID,
	}
}

// Do executes BluetoothEmulation.removeDescriptor against the provided context.
func (p *RemoveDescriptorParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveDescriptor, p, nil)
}

// SimulateGATTDisconnectionParams simulates a GATT disconnection from the
// peripheral with |address|.
type SimulateGATTDisconnectionParams struct {
	Address string `json:"address"`
}

// SimulateGATTDisconnection simulates a GATT disconnection from the
// peripheral with |address|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-simulateGATTDisconnection
//
// parameters:
//
//	address
func SimulateGATTDisconnection(address string) *SimulateGATTDisconnectionParams {
	return &SimulateGATTDisconnectionParams{
		Address: address,
	}
}

// Do executes BluetoothEmulation.simulateGATTDisconnection against the provided context.
func (p *SimulateGATTDisconnectionParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSimulateGATTDisconnection, p, nil)
}

// Command names.
const (
	CommandEnable                                  = "BluetoothEmulation.enable"
	CommandSetSimulatedCentralState                = "BluetoothEmulation.setSimulatedCentralState"
	CommandDisable                                 = "BluetoothEmulation.disable"
	CommandSimulatePreconnectedPeripheral          = "BluetoothEmulation.simulatePreconnectedPeripheral"
	CommandSimulateAdvertisement                   = "BluetoothEmulation.simulateAdvertisement"
	CommandSimulateGATTOperationResponse           = "BluetoothEmulation.simulateGATTOperationResponse"
	CommandSimulateCharacteristicOperationResponse = "BluetoothEmulation.simulateCharacteristicOperationResponse"
	CommandSimulateDescriptorOperationResponse     = "BluetoothEmulation.simulateDescriptorOperationResponse"
	CommandAddService                              = "BluetoothEmulation.addService"
	CommandRemoveService                           = "BluetoothEmulation.removeService"
	CommandAddCharacteristic                       = "BluetoothEmulation.addCharacteristic"
	CommandRemoveCharacteristic                    = "BluetoothEmulation.removeCharacteristic"
	CommandAddDescriptor                           = "BluetoothEmulation.addDescriptor"
	CommandRemoveDescriptor                        = "BluetoothEmulation.removeDescriptor"
	CommandSimulateGATTDisconnection               = "BluetoothEmulation.simulateGATTDisconnection"
)
