{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='volume', url='', help='"Volume represents a named volume in a pod that may be accessed by any container in the pod."'),
  '#awsElasticBlockStore':: d.obj(help='"Represents a Persistent Disk resource in AWS.\\n\\nAn AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling."'),
  awsElasticBlockStore: {
    '#withFsType':: d.fn(help='"fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { awsElasticBlockStore+: { fsType: fsType } },
    '#withPartition':: d.fn(help='"partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \\"1\\". Similarly, the volume partition for /dev/sda is \\"0\\" (or you can leave the property empty)."', args=[d.arg(name='partition', type=d.T.integer)]),
    withPartition(partition): { awsElasticBlockStore+: { partition: partition } },
    '#withReadOnly':: d.fn(help='"readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { awsElasticBlockStore+: { readOnly: readOnly } },
    '#withVolumeID':: d.fn(help='"volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"', args=[d.arg(name='volumeID', type=d.T.string)]),
    withVolumeID(volumeID): { awsElasticBlockStore+: { volumeID: volumeID } },
  },
  '#azureDisk':: d.obj(help='"AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod."'),
  azureDisk: {
    '#withCachingMode':: d.fn(help='"cachingMode is the Host Caching mode: None, Read Only, Read Write."', args=[d.arg(name='cachingMode', type=d.T.string)]),
    withCachingMode(cachingMode): { azureDisk+: { cachingMode: cachingMode } },
    '#withDiskName':: d.fn(help='"diskName is the Name of the data disk in the blob storage"', args=[d.arg(name='diskName', type=d.T.string)]),
    withDiskName(diskName): { azureDisk+: { diskName: diskName } },
    '#withDiskURI':: d.fn(help='"diskURI is the URI of data disk in the blob storage"', args=[d.arg(name='diskURI', type=d.T.string)]),
    withDiskURI(diskURI): { azureDisk+: { diskURI: diskURI } },
    '#withFsType':: d.fn(help='"fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { azureDisk+: { fsType: fsType } },
    '#withKind':: d.fn(help='"kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared"', args=[d.arg(name='kind', type=d.T.string)]),
    withKind(kind): { azureDisk+: { kind: kind } },
    '#withReadOnly':: d.fn(help='"readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { azureDisk+: { readOnly: readOnly } },
  },
  '#azureFile':: d.obj(help='"AzureFile represents an Azure File Service mount on the host and bind mount to the pod."'),
  azureFile: {
    '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { azureFile+: { readOnly: readOnly } },
    '#withSecretName':: d.fn(help='"secretName is the  name of secret that contains Azure Storage Account Name and Key"', args=[d.arg(name='secretName', type=d.T.string)]),
    withSecretName(secretName): { azureFile+: { secretName: secretName } },
    '#withShareName':: d.fn(help='"shareName is the azure share Name"', args=[d.arg(name='shareName', type=d.T.string)]),
    withShareName(shareName): { azureFile+: { shareName: shareName } },
  },
  '#cephfs':: d.obj(help='"Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling."'),
  cephfs: {
    '#secretRef':: d.obj(help='"LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace."'),
    secretRef: {
      '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { cephfs+: { secretRef+: { name: name } } },
    },
    '#withMonitors':: d.fn(help='"monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='monitors', type=d.T.array)]),
    withMonitors(monitors): { cephfs+: { monitors: if std.isArray(v=monitors) then monitors else [monitors] } },
    '#withMonitorsMixin':: d.fn(help='"monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='monitors', type=d.T.array)]),
    withMonitorsMixin(monitors): { cephfs+: { monitors+: if std.isArray(v=monitors) then monitors else [monitors] } },
    '#withPath':: d.fn(help='"path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /"', args=[d.arg(name='path', type=d.T.string)]),
    withPath(path): { cephfs+: { path: path } },
    '#withReadOnly':: d.fn(help='"readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { cephfs+: { readOnly: readOnly } },
    '#withSecretFile':: d.fn(help='"secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='secretFile', type=d.T.string)]),
    withSecretFile(secretFile): { cephfs+: { secretFile: secretFile } },
    '#withUser':: d.fn(help='"user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='user', type=d.T.string)]),
    withUser(user): { cephfs+: { user: user } },
  },
  '#cinder':: d.obj(help='"Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling."'),
  cinder: {
    '#secretRef':: d.obj(help='"LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace."'),
    secretRef: {
      '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { cinder+: { secretRef+: { name: name } } },
    },
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { cinder+: { fsType: fsType } },
    '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { cinder+: { readOnly: readOnly } },
    '#withVolumeID':: d.fn(help='"volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md"', args=[d.arg(name='volumeID', type=d.T.string)]),
    withVolumeID(volumeID): { cinder+: { volumeID: volumeID } },
  },
  '#configMap':: d.obj(help="\"Adapts a ConfigMap into a volume.\\n\\nThe contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.\""),
  configMap: {
    '#withDefaultMode':: d.fn(help='"defaultMode is optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set."', args=[d.arg(name='defaultMode', type=d.T.integer)]),
    withDefaultMode(defaultMode): { configMap+: { defaultMode: defaultMode } },
    '#withItems':: d.fn(help="\"items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.\"", args=[d.arg(name='items', type=d.T.array)]),
    withItems(items): { configMap+: { items: if std.isArray(v=items) then items else [items] } },
    '#withItemsMixin':: d.fn(help="\"items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='items', type=d.T.array)]),
    withItemsMixin(items): { configMap+: { items+: if std.isArray(v=items) then items else [items] } },
    '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
    withName(name): { configMap+: { name: name } },
    '#withOptional':: d.fn(help='"optional specify whether the ConfigMap or its keys must be defined"', args=[d.arg(name='optional', type=d.T.boolean)]),
    withOptional(optional): { configMap+: { optional: optional } },
  },
  '#csi':: d.obj(help='"Represents a source location of a volume to mount, managed by an external CSI driver"'),
  csi: {
    '#nodePublishSecretRef':: d.obj(help='"LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace."'),
    nodePublishSecretRef: {
      '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { csi+: { nodePublishSecretRef+: { name: name } } },
    },
    '#withDriver':: d.fn(help='"driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster."', args=[d.arg(name='driver', type=d.T.string)]),
    withDriver(driver): { csi+: { driver: driver } },
    '#withFsType':: d.fn(help='"fsType to mount. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { csi+: { fsType: fsType } },
    '#withReadOnly':: d.fn(help='"readOnly specifies a read-only configuration for the volume. Defaults to false (read/write)."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { csi+: { readOnly: readOnly } },
    '#withVolumeAttributes':: d.fn(help="\"volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.\"", args=[d.arg(name='volumeAttributes', type=d.T.object)]),
    withVolumeAttributes(volumeAttributes): { csi+: { volumeAttributes: volumeAttributes } },
    '#withVolumeAttributesMixin':: d.fn(help="\"volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='volumeAttributes', type=d.T.object)]),
    withVolumeAttributesMixin(volumeAttributes): { csi+: { volumeAttributes+: volumeAttributes } },
  },
  '#downwardAPI':: d.obj(help='"DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling."'),
  downwardAPI: {
    '#withDefaultMode':: d.fn(help='"Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set."', args=[d.arg(name='defaultMode', type=d.T.integer)]),
    withDefaultMode(defaultMode): { downwardAPI+: { defaultMode: defaultMode } },
    '#withItems':: d.fn(help='"Items is a list of downward API volume file"', args=[d.arg(name='items', type=d.T.array)]),
    withItems(items): { downwardAPI+: { items: if std.isArray(v=items) then items else [items] } },
    '#withItemsMixin':: d.fn(help='"Items is a list of downward API volume file"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='items', type=d.T.array)]),
    withItemsMixin(items): { downwardAPI+: { items+: if std.isArray(v=items) then items else [items] } },
  },
  '#emptyDir':: d.obj(help='"Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling."'),
  emptyDir: {
    '#withMedium':: d.fn(help="\"medium represents what type of storage medium should back this directory. The default is \\\"\\\" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir\"", args=[d.arg(name='medium', type=d.T.string)]),
    withMedium(medium): { emptyDir+: { medium: medium } },
    '#withSizeLimit':: d.fn(help="\"Quantity is a fixed-point representation of a number. It provides convenient marshaling/unmarshaling in JSON and YAML, in addition to String() and AsInt64() accessors.\\n\\nThe serialization format is:\\n\\n``` \u003cquantity\u003e        ::= \u003csignedNumber\u003e\u003csuffix\u003e\\n\\n\\t(Note that \u003csuffix\u003e may be empty, from the \\\"\\\" case in \u003cdecimalSI\u003e.)\\n\\n\u003cdigit\u003e           ::= 0 | 1 | ... | 9 \u003cdigits\u003e          ::= \u003cdigit\u003e | \u003cdigit\u003e\u003cdigits\u003e \u003cnumber\u003e          ::= \u003cdigits\u003e | \u003cdigits\u003e.\u003cdigits\u003e | \u003cdigits\u003e. | .\u003cdigits\u003e \u003csign\u003e            ::= \\\"+\\\" | \\\"-\\\" \u003csignedNumber\u003e    ::= \u003cnumber\u003e | \u003csign\u003e\u003cnumber\u003e \u003csuffix\u003e          ::= \u003cbinarySI\u003e | \u003cdecimalExponent\u003e | \u003cdecimalSI\u003e \u003cbinarySI\u003e        ::= Ki | Mi | Gi | Ti | Pi | Ei\\n\\n\\t(International System of units; See: http://physics.nist.gov/cuu/Units/binary.html)\\n\\n\u003cdecimalSI\u003e       ::= m | \\\"\\\" | k | M | G | T | P | E\\n\\n\\t(Note that 1024 = 1Ki but 1000 = 1k; I didn't choose the capitalization.)\\n\\n\u003cdecimalExponent\u003e ::= \\\"e\\\" \u003csignedNumber\u003e | \\\"E\\\" \u003csignedNumber\u003e ```\\n\\nNo matter which of the three exponent forms is used, no quantity may represent a number greater than 2^63-1 in magnitude, nor may it have more than 3 decimal places. Numbers larger or more precise will be capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be extended in the future if we require larger or smaller quantities.\\n\\nWhen a Quantity is parsed from a string, it will remember the type of suffix it had, and will use the same type again when it is serialized.\\n\\nBefore serializing, Quantity will be put in \\\"canonical form\\\". This means that Exponent/suffix will be adjusted up or down (with a corresponding increase or decrease in Mantissa) such that:\\n\\n- No precision is lost - No fractional digits will be emitted - The exponent (or suffix) is as large as possible.\\n\\nThe sign will be omitted unless the number is negative.\\n\\nExamples:\\n\\n- 1.5 will be serialized as \\\"1500m\\\" - 1.5Gi will be serialized as \\\"1536Mi\\\"\\n\\nNote that the quantity will NEVER be internally represented by a floating point number. That is the whole point of this exercise.\\n\\nNon-canonical values will still parse as long as they are well formed, but will be re-emitted in their canonical form. (So always use canonical form, or don't diff.)\\n\\nThis format is intended to make it difficult to use these numbers without writing some sort of special handling code in the hopes that that will cause implementors to also use a fixed point implementation.\"", args=[d.arg(name='sizeLimit', type=d.T.string)]),
    withSizeLimit(sizeLimit): { emptyDir+: { sizeLimit: sizeLimit } },
  },
  '#ephemeral':: d.obj(help='"Represents an ephemeral volume that is handled by a normal storage driver."'),
  ephemeral: {
    '#volumeClaimTemplate':: d.obj(help='"PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource."'),
    volumeClaimTemplate: {
      '#metadata':: d.obj(help='"ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create."'),
      metadata: {
        '#withAnnotations':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"', args=[d.arg(name='annotations', type=d.T.object)]),
        withAnnotations(annotations): { ephemeral+: { volumeClaimTemplate+: { metadata+: { annotations: annotations } } } },
        '#withAnnotationsMixin':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='annotations', type=d.T.object)]),
        withAnnotationsMixin(annotations): { ephemeral+: { volumeClaimTemplate+: { metadata+: { annotations+: annotations } } } },
        '#withCreationTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='creationTimestamp', type=d.T.string)]),
        withCreationTimestamp(creationTimestamp): { ephemeral+: { volumeClaimTemplate+: { metadata+: { creationTimestamp: creationTimestamp } } } },
        '#withDeletionGracePeriodSeconds':: d.fn(help='"Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only."', args=[d.arg(name='deletionGracePeriodSeconds', type=d.T.integer)]),
        withDeletionGracePeriodSeconds(deletionGracePeriodSeconds): { ephemeral+: { volumeClaimTemplate+: { metadata+: { deletionGracePeriodSeconds: deletionGracePeriodSeconds } } } },
        '#withDeletionTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='deletionTimestamp', type=d.T.string)]),
        withDeletionTimestamp(deletionTimestamp): { ephemeral+: { volumeClaimTemplate+: { metadata+: { deletionTimestamp: deletionTimestamp } } } },
        '#withFinalizers':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."', args=[d.arg(name='finalizers', type=d.T.array)]),
        withFinalizers(finalizers): { ephemeral+: { volumeClaimTemplate+: { metadata+: { finalizers: if std.isArray(v=finalizers) then finalizers else [finalizers] } } } },
        '#withFinalizersMixin':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='finalizers', type=d.T.array)]),
        withFinalizersMixin(finalizers): { ephemeral+: { volumeClaimTemplate+: { metadata+: { finalizers+: if std.isArray(v=finalizers) then finalizers else [finalizers] } } } },
        '#withGenerateName':: d.fn(help='"GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\\n\\nIf this field is specified and the generated name exists, the server will return a 409.\\n\\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency"', args=[d.arg(name='generateName', type=d.T.string)]),
        withGenerateName(generateName): { ephemeral+: { volumeClaimTemplate+: { metadata+: { generateName: generateName } } } },
        '#withGeneration':: d.fn(help='"A sequence number representing a specific generation of the desired state. Populated by the system. Read-only."', args=[d.arg(name='generation', type=d.T.integer)]),
        withGeneration(generation): { ephemeral+: { volumeClaimTemplate+: { metadata+: { generation: generation } } } },
        '#withLabels':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"', args=[d.arg(name='labels', type=d.T.object)]),
        withLabels(labels): { ephemeral+: { volumeClaimTemplate+: { metadata+: { labels: labels } } } },
        '#withLabelsMixin':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='labels', type=d.T.object)]),
        withLabelsMixin(labels): { ephemeral+: { volumeClaimTemplate+: { metadata+: { labels+: labels } } } },
        '#withManagedFields':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"", args=[d.arg(name='managedFields', type=d.T.array)]),
        withManagedFields(managedFields): { ephemeral+: { volumeClaimTemplate+: { metadata+: { managedFields: if std.isArray(v=managedFields) then managedFields else [managedFields] } } } },
        '#withManagedFieldsMixin':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='managedFields', type=d.T.array)]),
        withManagedFieldsMixin(managedFields): { ephemeral+: { volumeClaimTemplate+: { metadata+: { managedFields+: if std.isArray(v=managedFields) then managedFields else [managedFields] } } } },
        '#withName':: d.fn(help='"Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names"', args=[d.arg(name='name', type=d.T.string)]),
        withName(name): { ephemeral+: { volumeClaimTemplate+: { metadata+: { name: name } } } },
        '#withNamespace':: d.fn(help='"Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \\"default\\" namespace, but \\"default\\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\\n\\nMust be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces"', args=[d.arg(name='namespace', type=d.T.string)]),
        withNamespace(namespace): { ephemeral+: { volumeClaimTemplate+: { metadata+: { namespace: namespace } } } },
        '#withOwnerReferences':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."', args=[d.arg(name='ownerReferences', type=d.T.array)]),
        withOwnerReferences(ownerReferences): { ephemeral+: { volumeClaimTemplate+: { metadata+: { ownerReferences: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } } } },
        '#withOwnerReferencesMixin':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='ownerReferences', type=d.T.array)]),
        withOwnerReferencesMixin(ownerReferences): { ephemeral+: { volumeClaimTemplate+: { metadata+: { ownerReferences+: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } } } },
        '#withResourceVersion':: d.fn(help='"An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\\n\\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
        withResourceVersion(resourceVersion): { ephemeral+: { volumeClaimTemplate+: { metadata+: { resourceVersion: resourceVersion } } } },
        '#withSelfLink':: d.fn(help='"Deprecated: selfLink is a legacy read-only field that is no longer populated by the system."', args=[d.arg(name='selfLink', type=d.T.string)]),
        withSelfLink(selfLink): { ephemeral+: { volumeClaimTemplate+: { metadata+: { selfLink: selfLink } } } },
        '#withUid':: d.fn(help='"UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\\n\\nPopulated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids"', args=[d.arg(name='uid', type=d.T.string)]),
        withUid(uid): { ephemeral+: { volumeClaimTemplate+: { metadata+: { uid: uid } } } },
      },
      '#spec':: d.obj(help='"PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes"'),
      spec: {
        '#dataSource':: d.obj(help='"TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace."'),
        dataSource: {
          '#withApiGroup':: d.fn(help='"APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required."', args=[d.arg(name='apiGroup', type=d.T.string)]),
          withApiGroup(apiGroup): { ephemeral+: { volumeClaimTemplate+: { spec+: { dataSource+: { apiGroup: apiGroup } } } } },
          '#withKind':: d.fn(help='"Kind is the type of resource being referenced"', args=[d.arg(name='kind', type=d.T.string)]),
          withKind(kind): { ephemeral+: { volumeClaimTemplate+: { spec+: { dataSource+: { kind: kind } } } } },
          '#withName':: d.fn(help='"Name is the name of resource being referenced"', args=[d.arg(name='name', type=d.T.string)]),
          withName(name): { ephemeral+: { volumeClaimTemplate+: { spec+: { dataSource+: { name: name } } } } },
        },
        '#dataSourceRef':: d.obj(help=''),
        dataSourceRef: {
          '#withApiGroup':: d.fn(help='"APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required."', args=[d.arg(name='apiGroup', type=d.T.string)]),
          withApiGroup(apiGroup): { ephemeral+: { volumeClaimTemplate+: { spec+: { dataSourceRef+: { apiGroup: apiGroup } } } } },
          '#withKind':: d.fn(help='"Kind is the type of resource being referenced"', args=[d.arg(name='kind', type=d.T.string)]),
          withKind(kind): { ephemeral+: { volumeClaimTemplate+: { spec+: { dataSourceRef+: { kind: kind } } } } },
          '#withName':: d.fn(help='"Name is the name of resource being referenced"', args=[d.arg(name='name', type=d.T.string)]),
          withName(name): { ephemeral+: { volumeClaimTemplate+: { spec+: { dataSourceRef+: { name: name } } } } },
          '#withNamespace':: d.fn(help="\"Namespace is the namespace of resource being referenced Note that when a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant object is required in the referent namespace to allow that namespace's owner to accept the reference. See the ReferenceGrant documentation for details. (Alpha) This field requires the CrossNamespaceVolumeDataSource feature gate to be enabled.\"", args=[d.arg(name='namespace', type=d.T.string)]),
          withNamespace(namespace): { ephemeral+: { volumeClaimTemplate+: { spec+: { dataSourceRef+: { namespace: namespace } } } } },
        },
        '#resources':: d.obj(help='"VolumeResourceRequirements describes the storage resource requirements for a volume."'),
        resources: {
          '#withLimits':: d.fn(help='"Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"', args=[d.arg(name='limits', type=d.T.object)]),
          withLimits(limits): { ephemeral+: { volumeClaimTemplate+: { spec+: { resources+: { limits: limits } } } } },
          '#withLimitsMixin':: d.fn(help='"Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='limits', type=d.T.object)]),
          withLimitsMixin(limits): { ephemeral+: { volumeClaimTemplate+: { spec+: { resources+: { limits+: limits } } } } },
          '#withRequests':: d.fn(help='"Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"', args=[d.arg(name='requests', type=d.T.object)]),
          withRequests(requests): { ephemeral+: { volumeClaimTemplate+: { spec+: { resources+: { requests: requests } } } } },
          '#withRequestsMixin':: d.fn(help='"Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. Requests cannot exceed Limits. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='requests', type=d.T.object)]),
          withRequestsMixin(requests): { ephemeral+: { volumeClaimTemplate+: { spec+: { resources+: { requests+: requests } } } } },
        },
        '#selector':: d.obj(help='"A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects."'),
        selector: {
          '#withMatchExpressions':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."', args=[d.arg(name='matchExpressions', type=d.T.array)]),
          withMatchExpressions(matchExpressions): { ephemeral+: { volumeClaimTemplate+: { spec+: { selector+: { matchExpressions: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } } } },
          '#withMatchExpressionsMixin':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchExpressions', type=d.T.array)]),
          withMatchExpressionsMixin(matchExpressions): { ephemeral+: { volumeClaimTemplate+: { spec+: { selector+: { matchExpressions+: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } } } },
          '#withMatchLabels':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."', args=[d.arg(name='matchLabels', type=d.T.object)]),
          withMatchLabels(matchLabels): { ephemeral+: { volumeClaimTemplate+: { spec+: { selector+: { matchLabels: matchLabels } } } } },
          '#withMatchLabelsMixin':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchLabels', type=d.T.object)]),
          withMatchLabelsMixin(matchLabels): { ephemeral+: { volumeClaimTemplate+: { spec+: { selector+: { matchLabels+: matchLabels } } } } },
        },
        '#withAccessModes':: d.fn(help='"accessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1"', args=[d.arg(name='accessModes', type=d.T.array)]),
        withAccessModes(accessModes): { ephemeral+: { volumeClaimTemplate+: { spec+: { accessModes: if std.isArray(v=accessModes) then accessModes else [accessModes] } } } },
        '#withAccessModesMixin':: d.fn(help='"accessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='accessModes', type=d.T.array)]),
        withAccessModesMixin(accessModes): { ephemeral+: { volumeClaimTemplate+: { spec+: { accessModes+: if std.isArray(v=accessModes) then accessModes else [accessModes] } } } },
        '#withStorageClassName':: d.fn(help='"storageClassName is the name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1"', args=[d.arg(name='storageClassName', type=d.T.string)]),
        withStorageClassName(storageClassName): { ephemeral+: { volumeClaimTemplate+: { spec+: { storageClassName: storageClassName } } } },
        '#withVolumeAttributesClassName':: d.fn(help="\"volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim. If specified, the CSI driver will create or update the volume with the attributes defined in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName, it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass will be applied to the claim but it's not allowed to reset this field to empty string once it is set. If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass will be set by the persistentvolume controller if it exists. If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource exists. More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/ (Alpha) Using this field requires the VolumeAttributesClass feature gate to be enabled.\"", args=[d.arg(name='volumeAttributesClassName', type=d.T.string)]),
        withVolumeAttributesClassName(volumeAttributesClassName): { ephemeral+: { volumeClaimTemplate+: { spec+: { volumeAttributesClassName: volumeAttributesClassName } } } },
        '#withVolumeMode':: d.fn(help='"volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec."', args=[d.arg(name='volumeMode', type=d.T.string)]),
        withVolumeMode(volumeMode): { ephemeral+: { volumeClaimTemplate+: { spec+: { volumeMode: volumeMode } } } },
        '#withVolumeName':: d.fn(help='"volumeName is the binding reference to the PersistentVolume backing this claim."', args=[d.arg(name='volumeName', type=d.T.string)]),
        withVolumeName(volumeName): { ephemeral+: { volumeClaimTemplate+: { spec+: { volumeName: volumeName } } } },
      },
    },
  },
  '#fc':: d.obj(help='"Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling."'),
  fc: {
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { fc+: { fsType: fsType } },
    '#withLun':: d.fn(help='"lun is Optional: FC target lun number"', args=[d.arg(name='lun', type=d.T.integer)]),
    withLun(lun): { fc+: { lun: lun } },
    '#withReadOnly':: d.fn(help='"readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { fc+: { readOnly: readOnly } },
    '#withTargetWWNs':: d.fn(help='"targetWWNs is Optional: FC target worldwide names (WWNs)"', args=[d.arg(name='targetWWNs', type=d.T.array)]),
    withTargetWWNs(targetWWNs): { fc+: { targetWWNs: if std.isArray(v=targetWWNs) then targetWWNs else [targetWWNs] } },
    '#withTargetWWNsMixin':: d.fn(help='"targetWWNs is Optional: FC target worldwide names (WWNs)"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='targetWWNs', type=d.T.array)]),
    withTargetWWNsMixin(targetWWNs): { fc+: { targetWWNs+: if std.isArray(v=targetWWNs) then targetWWNs else [targetWWNs] } },
    '#withWwids':: d.fn(help='"wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously."', args=[d.arg(name='wwids', type=d.T.array)]),
    withWwids(wwids): { fc+: { wwids: if std.isArray(v=wwids) then wwids else [wwids] } },
    '#withWwidsMixin':: d.fn(help='"wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='wwids', type=d.T.array)]),
    withWwidsMixin(wwids): { fc+: { wwids+: if std.isArray(v=wwids) then wwids else [wwids] } },
  },
  '#flexVolume':: d.obj(help='"FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin."'),
  flexVolume: {
    '#secretRef':: d.obj(help='"LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace."'),
    secretRef: {
      '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { flexVolume+: { secretRef+: { name: name } } },
    },
    '#withDriver':: d.fn(help='"driver is the name of the driver to use for this volume."', args=[d.arg(name='driver', type=d.T.string)]),
    withDriver(driver): { flexVolume+: { driver: driver } },
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". The default filesystem depends on FlexVolume script."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { flexVolume+: { fsType: fsType } },
    '#withOptions':: d.fn(help='"options is Optional: this field holds extra command options if any."', args=[d.arg(name='options', type=d.T.object)]),
    withOptions(options): { flexVolume+: { options: options } },
    '#withOptionsMixin':: d.fn(help='"options is Optional: this field holds extra command options if any."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='options', type=d.T.object)]),
    withOptionsMixin(options): { flexVolume+: { options+: options } },
    '#withReadOnly':: d.fn(help='"readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { flexVolume+: { readOnly: readOnly } },
  },
  '#flocker':: d.obj(help='"Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling."'),
  flocker: {
    '#withDatasetName':: d.fn(help='"datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated"', args=[d.arg(name='datasetName', type=d.T.string)]),
    withDatasetName(datasetName): { flocker+: { datasetName: datasetName } },
    '#withDatasetUUID':: d.fn(help='"datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset"', args=[d.arg(name='datasetUUID', type=d.T.string)]),
    withDatasetUUID(datasetUUID): { flocker+: { datasetUUID: datasetUUID } },
  },
  '#gcePersistentDisk':: d.obj(help='"Represents a Persistent Disk resource in Google Compute Engine.\\n\\nA GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling."'),
  gcePersistentDisk: {
    '#withFsType':: d.fn(help='"fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { gcePersistentDisk+: { fsType: fsType } },
    '#withPartition':: d.fn(help='"partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \\"1\\". Similarly, the volume partition for /dev/sda is \\"0\\" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='partition', type=d.T.integer)]),
    withPartition(partition): { gcePersistentDisk+: { partition: partition } },
    '#withPdName':: d.fn(help='"pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='pdName', type=d.T.string)]),
    withPdName(pdName): { gcePersistentDisk+: { pdName: pdName } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { gcePersistentDisk+: { readOnly: readOnly } },
  },
  '#gitRepo':: d.obj(help="\"Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.\\n\\nDEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.\""),
  gitRepo: {
    '#withDirectory':: d.fn(help="\"directory is the target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.\"", args=[d.arg(name='directory', type=d.T.string)]),
    withDirectory(directory): { gitRepo+: { directory: directory } },
    '#withRepository':: d.fn(help='"repository is the URL"', args=[d.arg(name='repository', type=d.T.string)]),
    withRepository(repository): { gitRepo+: { repository: repository } },
    '#withRevision':: d.fn(help='"revision is the commit hash for the specified revision."', args=[d.arg(name='revision', type=d.T.string)]),
    withRevision(revision): { gitRepo+: { revision: revision } },
  },
  '#glusterfs':: d.obj(help='"Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling."'),
  glusterfs: {
    '#withEndpoints':: d.fn(help='"endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='endpoints', type=d.T.string)]),
    withEndpoints(endpoints): { glusterfs+: { endpoints: endpoints } },
    '#withPath':: d.fn(help='"path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='path', type=d.T.string)]),
    withPath(path): { glusterfs+: { path: path } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { glusterfs+: { readOnly: readOnly } },
  },
  '#hostPath':: d.obj(help='"Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling."'),
  hostPath: {
    '#withPath':: d.fn(help='"path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath"', args=[d.arg(name='path', type=d.T.string)]),
    withPath(path): { hostPath+: { path: path } },
    '#withType':: d.fn(help='"type for HostPath Volume Defaults to \\"\\" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath"', args=[d.arg(name='type', type=d.T.string)]),
    withType(type): { hostPath+: { type: type } },
  },
  '#iscsi':: d.obj(help='"Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling."'),
  iscsi: {
    '#secretRef':: d.obj(help='"LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace."'),
    secretRef: {
      '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { iscsi+: { secretRef+: { name: name } } },
    },
    '#withChapAuthDiscovery':: d.fn(help='"chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication"', args=[d.arg(name='chapAuthDiscovery', type=d.T.boolean)]),
    withChapAuthDiscovery(chapAuthDiscovery): { iscsi+: { chapAuthDiscovery: chapAuthDiscovery } },
    '#withChapAuthSession':: d.fn(help='"chapAuthSession defines whether support iSCSI Session CHAP authentication"', args=[d.arg(name='chapAuthSession', type=d.T.boolean)]),
    withChapAuthSession(chapAuthSession): { iscsi+: { chapAuthSession: chapAuthSession } },
    '#withFsType':: d.fn(help='"fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { iscsi+: { fsType: fsType } },
    '#withInitiatorName':: d.fn(help='"initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection."', args=[d.arg(name='initiatorName', type=d.T.string)]),
    withInitiatorName(initiatorName): { iscsi+: { initiatorName: initiatorName } },
    '#withIqn':: d.fn(help='"iqn is the target iSCSI Qualified Name."', args=[d.arg(name='iqn', type=d.T.string)]),
    withIqn(iqn): { iscsi+: { iqn: iqn } },
    '#withIscsiInterface':: d.fn(help="\"iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).\"", args=[d.arg(name='iscsiInterface', type=d.T.string)]),
    withIscsiInterface(iscsiInterface): { iscsi+: { iscsiInterface: iscsiInterface } },
    '#withLun':: d.fn(help='"lun represents iSCSI Target Lun number."', args=[d.arg(name='lun', type=d.T.integer)]),
    withLun(lun): { iscsi+: { lun: lun } },
    '#withPortals':: d.fn(help='"portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260)."', args=[d.arg(name='portals', type=d.T.array)]),
    withPortals(portals): { iscsi+: { portals: if std.isArray(v=portals) then portals else [portals] } },
    '#withPortalsMixin':: d.fn(help='"portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260)."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='portals', type=d.T.array)]),
    withPortalsMixin(portals): { iscsi+: { portals+: if std.isArray(v=portals) then portals else [portals] } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { iscsi+: { readOnly: readOnly } },
    '#withTargetPortal':: d.fn(help='"targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260)."', args=[d.arg(name='targetPortal', type=d.T.string)]),
    withTargetPortal(targetPortal): { iscsi+: { targetPortal: targetPortal } },
  },
  '#nfs':: d.obj(help='"Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling."'),
  nfs: {
    '#withPath':: d.fn(help='"path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"', args=[d.arg(name='path', type=d.T.string)]),
    withPath(path): { nfs+: { path: path } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { nfs+: { readOnly: readOnly } },
    '#withServer':: d.fn(help='"server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"', args=[d.arg(name='server', type=d.T.string)]),
    withServer(server): { nfs+: { server: server } },
  },
  '#persistentVolumeClaim':: d.obj(help="\"PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).\""),
  persistentVolumeClaim: {
    '#withClaimName':: d.fn(help='"claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims"', args=[d.arg(name='claimName', type=d.T.string)]),
    withClaimName(claimName): { persistentVolumeClaim+: { claimName: claimName } },
    '#withReadOnly':: d.fn(help='"readOnly Will force the ReadOnly setting in VolumeMounts. Default false."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { persistentVolumeClaim+: { readOnly: readOnly } },
  },
  '#photonPersistentDisk':: d.obj(help='"Represents a Photon Controller persistent disk resource."'),
  photonPersistentDisk: {
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { photonPersistentDisk+: { fsType: fsType } },
    '#withPdID':: d.fn(help='"pdID is the ID that identifies Photon Controller persistent disk"', args=[d.arg(name='pdID', type=d.T.string)]),
    withPdID(pdID): { photonPersistentDisk+: { pdID: pdID } },
  },
  '#portworxVolume':: d.obj(help='"PortworxVolumeSource represents a Portworx volume resource."'),
  portworxVolume: {
    '#withFsType':: d.fn(help='"fSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { portworxVolume+: { fsType: fsType } },
    '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { portworxVolume+: { readOnly: readOnly } },
    '#withVolumeID':: d.fn(help='"volumeID uniquely identifies a Portworx volume"', args=[d.arg(name='volumeID', type=d.T.string)]),
    withVolumeID(volumeID): { portworxVolume+: { volumeID: volumeID } },
  },
  '#projected':: d.obj(help='"Represents a projected volume source"'),
  projected: {
    '#withDefaultMode':: d.fn(help='"defaultMode are the mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set."', args=[d.arg(name='defaultMode', type=d.T.integer)]),
    withDefaultMode(defaultMode): { projected+: { defaultMode: defaultMode } },
    '#withSources':: d.fn(help='"sources is the list of volume projections"', args=[d.arg(name='sources', type=d.T.array)]),
    withSources(sources): { projected+: { sources: if std.isArray(v=sources) then sources else [sources] } },
    '#withSourcesMixin':: d.fn(help='"sources is the list of volume projections"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='sources', type=d.T.array)]),
    withSourcesMixin(sources): { projected+: { sources+: if std.isArray(v=sources) then sources else [sources] } },
  },
  '#quobyte':: d.obj(help='"Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling."'),
  quobyte: {
    '#withGroup':: d.fn(help='"group to map volume access to Default is no group"', args=[d.arg(name='group', type=d.T.string)]),
    withGroup(group): { quobyte+: { group: group } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { quobyte+: { readOnly: readOnly } },
    '#withRegistry':: d.fn(help='"registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes"', args=[d.arg(name='registry', type=d.T.string)]),
    withRegistry(registry): { quobyte+: { registry: registry } },
    '#withTenant':: d.fn(help='"tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin"', args=[d.arg(name='tenant', type=d.T.string)]),
    withTenant(tenant): { quobyte+: { tenant: tenant } },
    '#withUser':: d.fn(help='"user to map volume access to Defaults to serivceaccount user"', args=[d.arg(name='user', type=d.T.string)]),
    withUser(user): { quobyte+: { user: user } },
    '#withVolume':: d.fn(help='"volume is a string that references an already created Quobyte volume by name."', args=[d.arg(name='volume', type=d.T.string)]),
    withVolume(volume): { quobyte+: { volume: volume } },
  },
  '#rbd':: d.obj(help='"Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling."'),
  rbd: {
    '#secretRef':: d.obj(help='"LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace."'),
    secretRef: {
      '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { rbd+: { secretRef+: { name: name } } },
    },
    '#withFsType':: d.fn(help='"fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { rbd+: { fsType: fsType } },
    '#withImage':: d.fn(help='"image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='image', type=d.T.string)]),
    withImage(image): { rbd+: { image: image } },
    '#withKeyring':: d.fn(help='"keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='keyring', type=d.T.string)]),
    withKeyring(keyring): { rbd+: { keyring: keyring } },
    '#withMonitors':: d.fn(help='"monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='monitors', type=d.T.array)]),
    withMonitors(monitors): { rbd+: { monitors: if std.isArray(v=monitors) then monitors else [monitors] } },
    '#withMonitorsMixin':: d.fn(help='"monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='monitors', type=d.T.array)]),
    withMonitorsMixin(monitors): { rbd+: { monitors+: if std.isArray(v=monitors) then monitors else [monitors] } },
    '#withPool':: d.fn(help='"pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='pool', type=d.T.string)]),
    withPool(pool): { rbd+: { pool: pool } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { rbd+: { readOnly: readOnly } },
    '#withUser':: d.fn(help='"user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='user', type=d.T.string)]),
    withUser(user): { rbd+: { user: user } },
  },
  '#scaleIO':: d.obj(help='"ScaleIOVolumeSource represents a persistent ScaleIO volume"'),
  scaleIO: {
    '#secretRef':: d.obj(help='"LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace."'),
    secretRef: {
      '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { scaleIO+: { secretRef+: { name: name } } },
    },
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Default is \\"xfs\\"."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { scaleIO+: { fsType: fsType } },
    '#withGateway':: d.fn(help='"gateway is the host address of the ScaleIO API Gateway."', args=[d.arg(name='gateway', type=d.T.string)]),
    withGateway(gateway): { scaleIO+: { gateway: gateway } },
    '#withProtectionDomain':: d.fn(help='"protectionDomain is the name of the ScaleIO Protection Domain for the configured storage."', args=[d.arg(name='protectionDomain', type=d.T.string)]),
    withProtectionDomain(protectionDomain): { scaleIO+: { protectionDomain: protectionDomain } },
    '#withReadOnly':: d.fn(help='"readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { scaleIO+: { readOnly: readOnly } },
    '#withSslEnabled':: d.fn(help='"sslEnabled Flag enable/disable SSL communication with Gateway, default false"', args=[d.arg(name='sslEnabled', type=d.T.boolean)]),
    withSslEnabled(sslEnabled): { scaleIO+: { sslEnabled: sslEnabled } },
    '#withStorageMode':: d.fn(help='"storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned."', args=[d.arg(name='storageMode', type=d.T.string)]),
    withStorageMode(storageMode): { scaleIO+: { storageMode: storageMode } },
    '#withStoragePool':: d.fn(help='"storagePool is the ScaleIO Storage Pool associated with the protection domain."', args=[d.arg(name='storagePool', type=d.T.string)]),
    withStoragePool(storagePool): { scaleIO+: { storagePool: storagePool } },
    '#withSystem':: d.fn(help='"system is the name of the storage system as configured in ScaleIO."', args=[d.arg(name='system', type=d.T.string)]),
    withSystem(system): { scaleIO+: { system: system } },
    '#withVolumeName':: d.fn(help='"volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source."', args=[d.arg(name='volumeName', type=d.T.string)]),
    withVolumeName(volumeName): { scaleIO+: { volumeName: volumeName } },
  },
  '#secret':: d.obj(help="\"Adapts a Secret into a volume.\\n\\nThe contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names. Secret volumes support ownership management and SELinux relabeling.\""),
  secret: {
    '#withDefaultMode':: d.fn(help='"defaultMode is Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set."', args=[d.arg(name='defaultMode', type=d.T.integer)]),
    withDefaultMode(defaultMode): { secret+: { defaultMode: defaultMode } },
    '#withItems':: d.fn(help="\"items If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.\"", args=[d.arg(name='items', type=d.T.array)]),
    withItems(items): { secret+: { items: if std.isArray(v=items) then items else [items] } },
    '#withItemsMixin':: d.fn(help="\"items If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='items', type=d.T.array)]),
    withItemsMixin(items): { secret+: { items+: if std.isArray(v=items) then items else [items] } },
    '#withOptional':: d.fn(help='"optional field specify whether the Secret or its keys must be defined"', args=[d.arg(name='optional', type=d.T.boolean)]),
    withOptional(optional): { secret+: { optional: optional } },
    '#withSecretName':: d.fn(help="\"secretName is the name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret\"", args=[d.arg(name='secretName', type=d.T.string)]),
    withSecretName(secretName): { secret+: { secretName: secretName } },
  },
  '#storageos':: d.obj(help='"Represents a StorageOS persistent volume resource."'),
  storageos: {
    '#secretRef':: d.obj(help='"LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace."'),
    secretRef: {
      '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { storageos+: { secretRef+: { name: name } } },
    },
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { storageos+: { fsType: fsType } },
    '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { storageos+: { readOnly: readOnly } },
    '#withVolumeName':: d.fn(help='"volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace."', args=[d.arg(name='volumeName', type=d.T.string)]),
    withVolumeName(volumeName): { storageos+: { volumeName: volumeName } },
    '#withVolumeNamespace':: d.fn(help="\"volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to \\\"default\\\" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.\"", args=[d.arg(name='volumeNamespace', type=d.T.string)]),
    withVolumeNamespace(volumeNamespace): { storageos+: { volumeNamespace: volumeNamespace } },
  },
  '#vsphereVolume':: d.obj(help='"Represents a vSphere volume resource."'),
  vsphereVolume: {
    '#withFsType':: d.fn(help='"fsType is filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { vsphereVolume+: { fsType: fsType } },
    '#withStoragePolicyID':: d.fn(help='"storagePolicyID is the storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName."', args=[d.arg(name='storagePolicyID', type=d.T.string)]),
    withStoragePolicyID(storagePolicyID): { vsphereVolume+: { storagePolicyID: storagePolicyID } },
    '#withStoragePolicyName':: d.fn(help='"storagePolicyName is the storage Policy Based Management (SPBM) profile name."', args=[d.arg(name='storagePolicyName', type=d.T.string)]),
    withStoragePolicyName(storagePolicyName): { vsphereVolume+: { storagePolicyName: storagePolicyName } },
    '#withVolumePath':: d.fn(help='"volumePath is the path that identifies vSphere volume vmdk"', args=[d.arg(name='volumePath', type=d.T.string)]),
    withVolumePath(volumePath): { vsphereVolume+: { volumePath: volumePath } },
  },
  '#withName':: d.fn(help='"name of the volume. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
  withName(name): { name: name },
  '#mixin': 'ignore',
  mixin: self,
}
