{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='persistentVolumeSpec', url='', help='"PersistentVolumeSpec is the specification of a persistent volume."'),
  '#awsElasticBlockStore':: d.obj(help='"Represents a Persistent Disk resource in AWS.\\n\\nAn AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling."'),
  awsElasticBlockStore: {
    '#withFsType':: d.fn(help='"fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { awsElasticBlockStore+: { fsType: fsType } },
    '#withPartition':: d.fn(help='"partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \\"1\\". Similarly, the volume partition for /dev/sda is \\"0\\" (or you can leave the property empty)."', args=[d.arg(name='partition', type=d.T.integer)]),
    withPartition(partition): { awsElasticBlockStore+: { partition: partition } },
    '#withReadOnly':: d.fn(help='"readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { awsElasticBlockStore+: { readOnly: readOnly } },
    '#withVolumeID':: d.fn(help='"volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"', args=[d.arg(name='volumeID', type=d.T.string)]),
    withVolumeID(volumeID): { awsElasticBlockStore+: { volumeID: volumeID } },
  },
  '#azureDisk':: d.obj(help='"AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod."'),
  azureDisk: {
    '#withCachingMode':: d.fn(help='"cachingMode is the Host Caching mode: None, Read Only, Read Write."', args=[d.arg(name='cachingMode', type=d.T.string)]),
    withCachingMode(cachingMode): { azureDisk+: { cachingMode: cachingMode } },
    '#withDiskName':: d.fn(help='"diskName is the Name of the data disk in the blob storage"', args=[d.arg(name='diskName', type=d.T.string)]),
    withDiskName(diskName): { azureDisk+: { diskName: diskName } },
    '#withDiskURI':: d.fn(help='"diskURI is the URI of data disk in the blob storage"', args=[d.arg(name='diskURI', type=d.T.string)]),
    withDiskURI(diskURI): { azureDisk+: { diskURI: diskURI } },
    '#withFsType':: d.fn(help='"fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { azureDisk+: { fsType: fsType } },
    '#withKind':: d.fn(help='"kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared"', args=[d.arg(name='kind', type=d.T.string)]),
    withKind(kind): { azureDisk+: { kind: kind } },
    '#withReadOnly':: d.fn(help='"readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { azureDisk+: { readOnly: readOnly } },
  },
  '#azureFile':: d.obj(help='"AzureFile represents an Azure File Service mount on the host and bind mount to the pod."'),
  azureFile: {
    '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { azureFile+: { readOnly: readOnly } },
    '#withSecretName':: d.fn(help='"secretName is the name of secret that contains Azure Storage Account Name and Key"', args=[d.arg(name='secretName', type=d.T.string)]),
    withSecretName(secretName): { azureFile+: { secretName: secretName } },
    '#withSecretNamespace':: d.fn(help='"secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod"', args=[d.arg(name='secretNamespace', type=d.T.string)]),
    withSecretNamespace(secretNamespace): { azureFile+: { secretNamespace: secretNamespace } },
    '#withShareName':: d.fn(help='"shareName is the azure Share Name"', args=[d.arg(name='shareName', type=d.T.string)]),
    withShareName(shareName): { azureFile+: { shareName: shareName } },
  },
  '#cephfs':: d.obj(help='"Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling."'),
  cephfs: {
    '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    secretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { cephfs+: { secretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { cephfs+: { secretRef+: { namespace: namespace } } },
    },
    '#withMonitors':: d.fn(help='"monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='monitors', type=d.T.array)]),
    withMonitors(monitors): { cephfs+: { monitors: if std.isArray(v=monitors) then monitors else [monitors] } },
    '#withMonitorsMixin':: d.fn(help='"monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='monitors', type=d.T.array)]),
    withMonitorsMixin(monitors): { cephfs+: { monitors+: if std.isArray(v=monitors) then monitors else [monitors] } },
    '#withPath':: d.fn(help='"path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /"', args=[d.arg(name='path', type=d.T.string)]),
    withPath(path): { cephfs+: { path: path } },
    '#withReadOnly':: d.fn(help='"readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { cephfs+: { readOnly: readOnly } },
    '#withSecretFile':: d.fn(help='"secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='secretFile', type=d.T.string)]),
    withSecretFile(secretFile): { cephfs+: { secretFile: secretFile } },
    '#withUser':: d.fn(help='"user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"', args=[d.arg(name='user', type=d.T.string)]),
    withUser(user): { cephfs+: { user: user } },
  },
  '#cinder':: d.obj(help='"Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling."'),
  cinder: {
    '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    secretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { cinder+: { secretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { cinder+: { secretRef+: { namespace: namespace } } },
    },
    '#withFsType':: d.fn(help='"fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { cinder+: { fsType: fsType } },
    '#withReadOnly':: d.fn(help='"readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { cinder+: { readOnly: readOnly } },
    '#withVolumeID':: d.fn(help='"volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md"', args=[d.arg(name='volumeID', type=d.T.string)]),
    withVolumeID(volumeID): { cinder+: { volumeID: volumeID } },
  },
  '#claimRef':: d.obj(help='"ObjectReference contains enough information to let you inspect or modify the referred object."'),
  claimRef: {
    '#withApiVersion':: d.fn(help='"API version of the referent."', args=[d.arg(name='apiVersion', type=d.T.string)]),
    withApiVersion(apiVersion): { claimRef+: { apiVersion: apiVersion } },
    '#withFieldPath':: d.fn(help='"If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: \\"spec.containers{name}\\" (where \\"name\\" refers to the name of the container that triggered the event) or if no container name is specified \\"spec.containers[2]\\" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object."', args=[d.arg(name='fieldPath', type=d.T.string)]),
    withFieldPath(fieldPath): { claimRef+: { fieldPath: fieldPath } },
    '#withKind':: d.fn(help='"Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"', args=[d.arg(name='kind', type=d.T.string)]),
    withKind(kind): { claimRef+: { kind: kind } },
    '#withName':: d.fn(help='"Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
    withName(name): { claimRef+: { name: name } },
    '#withNamespace':: d.fn(help='"Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/"', args=[d.arg(name='namespace', type=d.T.string)]),
    withNamespace(namespace): { claimRef+: { namespace: namespace } },
    '#withResourceVersion':: d.fn(help='"Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
    withResourceVersion(resourceVersion): { claimRef+: { resourceVersion: resourceVersion } },
    '#withUid':: d.fn(help='"UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids"', args=[d.arg(name='uid', type=d.T.string)]),
    withUid(uid): { claimRef+: { uid: uid } },
  },
  '#csi':: d.obj(help='"Represents storage that is managed by an external CSI volume driver (Beta feature)"'),
  csi: {
    '#controllerExpandSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    controllerExpandSecretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { csi+: { controllerExpandSecretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { csi+: { controllerExpandSecretRef+: { namespace: namespace } } },
    },
    '#controllerPublishSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    controllerPublishSecretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { csi+: { controllerPublishSecretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { csi+: { controllerPublishSecretRef+: { namespace: namespace } } },
    },
    '#nodeExpandSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    nodeExpandSecretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { csi+: { nodeExpandSecretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { csi+: { nodeExpandSecretRef+: { namespace: namespace } } },
    },
    '#nodePublishSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    nodePublishSecretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { csi+: { nodePublishSecretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { csi+: { nodePublishSecretRef+: { namespace: namespace } } },
    },
    '#nodeStageSecretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    nodeStageSecretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { csi+: { nodeStageSecretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { csi+: { nodeStageSecretRef+: { namespace: namespace } } },
    },
    '#withDriver':: d.fn(help='"driver is the name of the driver to use for this volume. Required."', args=[d.arg(name='driver', type=d.T.string)]),
    withDriver(driver): { csi+: { driver: driver } },
    '#withFsType':: d.fn(help='"fsType to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\"."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { csi+: { fsType: fsType } },
    '#withReadOnly':: d.fn(help='"readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write)."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { csi+: { readOnly: readOnly } },
    '#withVolumeAttributes':: d.fn(help='"volumeAttributes of the volume to publish."', args=[d.arg(name='volumeAttributes', type=d.T.object)]),
    withVolumeAttributes(volumeAttributes): { csi+: { volumeAttributes: volumeAttributes } },
    '#withVolumeAttributesMixin':: d.fn(help='"volumeAttributes of the volume to publish."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='volumeAttributes', type=d.T.object)]),
    withVolumeAttributesMixin(volumeAttributes): { csi+: { volumeAttributes+: volumeAttributes } },
    '#withVolumeHandle':: d.fn(help='"volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required."', args=[d.arg(name='volumeHandle', type=d.T.string)]),
    withVolumeHandle(volumeHandle): { csi+: { volumeHandle: volumeHandle } },
  },
  '#fc':: d.obj(help='"Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling."'),
  fc: {
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { fc+: { fsType: fsType } },
    '#withLun':: d.fn(help='"lun is Optional: FC target lun number"', args=[d.arg(name='lun', type=d.T.integer)]),
    withLun(lun): { fc+: { lun: lun } },
    '#withReadOnly':: d.fn(help='"readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { fc+: { readOnly: readOnly } },
    '#withTargetWWNs':: d.fn(help='"targetWWNs is Optional: FC target worldwide names (WWNs)"', args=[d.arg(name='targetWWNs', type=d.T.array)]),
    withTargetWWNs(targetWWNs): { fc+: { targetWWNs: if std.isArray(v=targetWWNs) then targetWWNs else [targetWWNs] } },
    '#withTargetWWNsMixin':: d.fn(help='"targetWWNs is Optional: FC target worldwide names (WWNs)"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='targetWWNs', type=d.T.array)]),
    withTargetWWNsMixin(targetWWNs): { fc+: { targetWWNs+: if std.isArray(v=targetWWNs) then targetWWNs else [targetWWNs] } },
    '#withWwids':: d.fn(help='"wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously."', args=[d.arg(name='wwids', type=d.T.array)]),
    withWwids(wwids): { fc+: { wwids: if std.isArray(v=wwids) then wwids else [wwids] } },
    '#withWwidsMixin':: d.fn(help='"wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='wwids', type=d.T.array)]),
    withWwidsMixin(wwids): { fc+: { wwids+: if std.isArray(v=wwids) then wwids else [wwids] } },
  },
  '#flexVolume':: d.obj(help='"FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin."'),
  flexVolume: {
    '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    secretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { flexVolume+: { secretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { flexVolume+: { secretRef+: { namespace: namespace } } },
    },
    '#withDriver':: d.fn(help='"driver is the name of the driver to use for this volume."', args=[d.arg(name='driver', type=d.T.string)]),
    withDriver(driver): { flexVolume+: { driver: driver } },
    '#withFsType':: d.fn(help='"fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". The default filesystem depends on FlexVolume script."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { flexVolume+: { fsType: fsType } },
    '#withOptions':: d.fn(help='"options is Optional: this field holds extra command options if any."', args=[d.arg(name='options', type=d.T.object)]),
    withOptions(options): { flexVolume+: { options: options } },
    '#withOptionsMixin':: d.fn(help='"options is Optional: this field holds extra command options if any."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='options', type=d.T.object)]),
    withOptionsMixin(options): { flexVolume+: { options+: options } },
    '#withReadOnly':: d.fn(help='"readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { flexVolume+: { readOnly: readOnly } },
  },
  '#flocker':: d.obj(help='"Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling."'),
  flocker: {
    '#withDatasetName':: d.fn(help='"datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated"', args=[d.arg(name='datasetName', type=d.T.string)]),
    withDatasetName(datasetName): { flocker+: { datasetName: datasetName } },
    '#withDatasetUUID':: d.fn(help='"datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset"', args=[d.arg(name='datasetUUID', type=d.T.string)]),
    withDatasetUUID(datasetUUID): { flocker+: { datasetUUID: datasetUUID } },
  },
  '#gcePersistentDisk':: d.obj(help='"Represents a Persistent Disk resource in Google Compute Engine.\\n\\nA GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling."'),
  gcePersistentDisk: {
    '#withFsType':: d.fn(help='"fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { gcePersistentDisk+: { fsType: fsType } },
    '#withPartition':: d.fn(help='"partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \\"1\\". Similarly, the volume partition for /dev/sda is \\"0\\" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='partition', type=d.T.integer)]),
    withPartition(partition): { gcePersistentDisk+: { partition: partition } },
    '#withPdName':: d.fn(help='"pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='pdName', type=d.T.string)]),
    withPdName(pdName): { gcePersistentDisk+: { pdName: pdName } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { gcePersistentDisk+: { readOnly: readOnly } },
  },
  '#glusterfs':: d.obj(help='"Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling."'),
  glusterfs: {
    '#withEndpoints':: d.fn(help='"endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='endpoints', type=d.T.string)]),
    withEndpoints(endpoints): { glusterfs+: { endpoints: endpoints } },
    '#withEndpointsNamespace':: d.fn(help='"endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='endpointsNamespace', type=d.T.string)]),
    withEndpointsNamespace(endpointsNamespace): { glusterfs+: { endpointsNamespace: endpointsNamespace } },
    '#withPath':: d.fn(help='"path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='path', type=d.T.string)]),
    withPath(path): { glusterfs+: { path: path } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { glusterfs+: { readOnly: readOnly } },
  },
  '#hostPath':: d.obj(help='"Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling."'),
  hostPath: {
    '#withPath':: d.fn(help='"path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath"', args=[d.arg(name='path', type=d.T.string)]),
    withPath(path): { hostPath+: { path: path } },
    '#withType':: d.fn(help='"type for HostPath Volume Defaults to \\"\\" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath"', args=[d.arg(name='type', type=d.T.string)]),
    withType(type): { hostPath+: { type: type } },
  },
  '#iscsi':: d.obj(help='"ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling."'),
  iscsi: {
    '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    secretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { iscsi+: { secretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { iscsi+: { secretRef+: { namespace: namespace } } },
    },
    '#withChapAuthDiscovery':: d.fn(help='"chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication"', args=[d.arg(name='chapAuthDiscovery', type=d.T.boolean)]),
    withChapAuthDiscovery(chapAuthDiscovery): { iscsi+: { chapAuthDiscovery: chapAuthDiscovery } },
    '#withChapAuthSession':: d.fn(help='"chapAuthSession defines whether support iSCSI Session CHAP authentication"', args=[d.arg(name='chapAuthSession', type=d.T.boolean)]),
    withChapAuthSession(chapAuthSession): { iscsi+: { chapAuthSession: chapAuthSession } },
    '#withFsType':: d.fn(help='"fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { iscsi+: { fsType: fsType } },
    '#withInitiatorName':: d.fn(help='"initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection."', args=[d.arg(name='initiatorName', type=d.T.string)]),
    withInitiatorName(initiatorName): { iscsi+: { initiatorName: initiatorName } },
    '#withIqn':: d.fn(help='"iqn is Target iSCSI Qualified Name."', args=[d.arg(name='iqn', type=d.T.string)]),
    withIqn(iqn): { iscsi+: { iqn: iqn } },
    '#withIscsiInterface':: d.fn(help="\"iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).\"", args=[d.arg(name='iscsiInterface', type=d.T.string)]),
    withIscsiInterface(iscsiInterface): { iscsi+: { iscsiInterface: iscsiInterface } },
    '#withLun':: d.fn(help='"lun is iSCSI Target Lun number."', args=[d.arg(name='lun', type=d.T.integer)]),
    withLun(lun): { iscsi+: { lun: lun } },
    '#withPortals':: d.fn(help='"portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260)."', args=[d.arg(name='portals', type=d.T.array)]),
    withPortals(portals): { iscsi+: { portals: if std.isArray(v=portals) then portals else [portals] } },
    '#withPortalsMixin':: d.fn(help='"portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260)."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='portals', type=d.T.array)]),
    withPortalsMixin(portals): { iscsi+: { portals+: if std.isArray(v=portals) then portals else [portals] } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { iscsi+: { readOnly: readOnly } },
    '#withTargetPortal':: d.fn(help='"targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260)."', args=[d.arg(name='targetPortal', type=d.T.string)]),
    withTargetPortal(targetPortal): { iscsi+: { targetPortal: targetPortal } },
  },
  '#local':: d.obj(help='"Local represents directly-attached storage with node affinity (Beta feature)"'),
  'local': {
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". The default value is to auto-select a filesystem if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { 'local'+: { fsType: fsType } },
    '#withPath':: d.fn(help='"path of the full path to the volume on the node. It can be either a directory or block device (disk, partition, ...)."', args=[d.arg(name='path', type=d.T.string)]),
    withPath(path): { 'local'+: { path: path } },
  },
  '#nfs':: d.obj(help='"Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling."'),
  nfs: {
    '#withPath':: d.fn(help='"path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"', args=[d.arg(name='path', type=d.T.string)]),
    withPath(path): { nfs+: { path: path } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { nfs+: { readOnly: readOnly } },
    '#withServer':: d.fn(help='"server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"', args=[d.arg(name='server', type=d.T.string)]),
    withServer(server): { nfs+: { server: server } },
  },
  '#nodeAffinity':: d.obj(help='"VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from."'),
  nodeAffinity: {
    '#required':: d.obj(help='"A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms."'),
    required: {
      '#withNodeSelectorTerms':: d.fn(help='"Required. A list of node selector terms. The terms are ORed."', args=[d.arg(name='nodeSelectorTerms', type=d.T.array)]),
      withNodeSelectorTerms(nodeSelectorTerms): { nodeAffinity+: { required+: { nodeSelectorTerms: if std.isArray(v=nodeSelectorTerms) then nodeSelectorTerms else [nodeSelectorTerms] } } },
      '#withNodeSelectorTermsMixin':: d.fn(help='"Required. A list of node selector terms. The terms are ORed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='nodeSelectorTerms', type=d.T.array)]),
      withNodeSelectorTermsMixin(nodeSelectorTerms): { nodeAffinity+: { required+: { nodeSelectorTerms+: if std.isArray(v=nodeSelectorTerms) then nodeSelectorTerms else [nodeSelectorTerms] } } },
    },
  },
  '#photonPersistentDisk':: d.obj(help='"Represents a Photon Controller persistent disk resource."'),
  photonPersistentDisk: {
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { photonPersistentDisk+: { fsType: fsType } },
    '#withPdID':: d.fn(help='"pdID is the ID that identifies Photon Controller persistent disk"', args=[d.arg(name='pdID', type=d.T.string)]),
    withPdID(pdID): { photonPersistentDisk+: { pdID: pdID } },
  },
  '#portworxVolume':: d.obj(help='"PortworxVolumeSource represents a Portworx volume resource."'),
  portworxVolume: {
    '#withFsType':: d.fn(help='"fSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { portworxVolume+: { fsType: fsType } },
    '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { portworxVolume+: { readOnly: readOnly } },
    '#withVolumeID':: d.fn(help='"volumeID uniquely identifies a Portworx volume"', args=[d.arg(name='volumeID', type=d.T.string)]),
    withVolumeID(volumeID): { portworxVolume+: { volumeID: volumeID } },
  },
  '#quobyte':: d.obj(help='"Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling."'),
  quobyte: {
    '#withGroup':: d.fn(help='"group to map volume access to Default is no group"', args=[d.arg(name='group', type=d.T.string)]),
    withGroup(group): { quobyte+: { group: group } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { quobyte+: { readOnly: readOnly } },
    '#withRegistry':: d.fn(help='"registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes"', args=[d.arg(name='registry', type=d.T.string)]),
    withRegistry(registry): { quobyte+: { registry: registry } },
    '#withTenant':: d.fn(help='"tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin"', args=[d.arg(name='tenant', type=d.T.string)]),
    withTenant(tenant): { quobyte+: { tenant: tenant } },
    '#withUser':: d.fn(help='"user to map volume access to Defaults to serivceaccount user"', args=[d.arg(name='user', type=d.T.string)]),
    withUser(user): { quobyte+: { user: user } },
    '#withVolume':: d.fn(help='"volume is a string that references an already created Quobyte volume by name."', args=[d.arg(name='volume', type=d.T.string)]),
    withVolume(volume): { quobyte+: { volume: volume } },
  },
  '#rbd':: d.obj(help='"Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling."'),
  rbd: {
    '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    secretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { rbd+: { secretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { rbd+: { secretRef+: { namespace: namespace } } },
    },
    '#withFsType':: d.fn(help='"fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd"', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { rbd+: { fsType: fsType } },
    '#withImage':: d.fn(help='"image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='image', type=d.T.string)]),
    withImage(image): { rbd+: { image: image } },
    '#withKeyring':: d.fn(help='"keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='keyring', type=d.T.string)]),
    withKeyring(keyring): { rbd+: { keyring: keyring } },
    '#withMonitors':: d.fn(help='"monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='monitors', type=d.T.array)]),
    withMonitors(monitors): { rbd+: { monitors: if std.isArray(v=monitors) then monitors else [monitors] } },
    '#withMonitorsMixin':: d.fn(help='"monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='monitors', type=d.T.array)]),
    withMonitorsMixin(monitors): { rbd+: { monitors+: if std.isArray(v=monitors) then monitors else [monitors] } },
    '#withPool':: d.fn(help='"pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='pool', type=d.T.string)]),
    withPool(pool): { rbd+: { pool: pool } },
    '#withReadOnly':: d.fn(help='"readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { rbd+: { readOnly: readOnly } },
    '#withUser':: d.fn(help='"user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"', args=[d.arg(name='user', type=d.T.string)]),
    withUser(user): { rbd+: { user: user } },
  },
  '#scaleIO':: d.obj(help='"ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume"'),
  scaleIO: {
    '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
    secretRef: {
      '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { scaleIO+: { secretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { scaleIO+: { secretRef+: { namespace: namespace } } },
    },
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Default is \\"xfs\\', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { scaleIO+: { fsType: fsType } },
    '#withGateway':: d.fn(help='"gateway is the host address of the ScaleIO API Gateway."', args=[d.arg(name='gateway', type=d.T.string)]),
    withGateway(gateway): { scaleIO+: { gateway: gateway } },
    '#withProtectionDomain':: d.fn(help='"protectionDomain is the name of the ScaleIO Protection Domain for the configured storage."', args=[d.arg(name='protectionDomain', type=d.T.string)]),
    withProtectionDomain(protectionDomain): { scaleIO+: { protectionDomain: protectionDomain } },
    '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { scaleIO+: { readOnly: readOnly } },
    '#withSslEnabled':: d.fn(help='"sslEnabled is the flag to enable/disable SSL communication with Gateway, default false"', args=[d.arg(name='sslEnabled', type=d.T.boolean)]),
    withSslEnabled(sslEnabled): { scaleIO+: { sslEnabled: sslEnabled } },
    '#withStorageMode':: d.fn(help='"storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned."', args=[d.arg(name='storageMode', type=d.T.string)]),
    withStorageMode(storageMode): { scaleIO+: { storageMode: storageMode } },
    '#withStoragePool':: d.fn(help='"storagePool is the ScaleIO Storage Pool associated with the protection domain."', args=[d.arg(name='storagePool', type=d.T.string)]),
    withStoragePool(storagePool): { scaleIO+: { storagePool: storagePool } },
    '#withSystem':: d.fn(help='"system is the name of the storage system as configured in ScaleIO."', args=[d.arg(name='system', type=d.T.string)]),
    withSystem(system): { scaleIO+: { system: system } },
    '#withVolumeName':: d.fn(help='"volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source."', args=[d.arg(name='volumeName', type=d.T.string)]),
    withVolumeName(volumeName): { scaleIO+: { volumeName: volumeName } },
  },
  '#storageos':: d.obj(help='"Represents a StorageOS persistent volume resource."'),
  storageos: {
    '#secretRef':: d.obj(help='"ObjectReference contains enough information to let you inspect or modify the referred object."'),
    secretRef: {
      '#withApiVersion':: d.fn(help='"API version of the referent."', args=[d.arg(name='apiVersion', type=d.T.string)]),
      withApiVersion(apiVersion): { storageos+: { secretRef+: { apiVersion: apiVersion } } },
      '#withFieldPath':: d.fn(help='"If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: \\"spec.containers{name}\\" (where \\"name\\" refers to the name of the container that triggered the event) or if no container name is specified \\"spec.containers[2]\\" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object."', args=[d.arg(name='fieldPath', type=d.T.string)]),
      withFieldPath(fieldPath): { storageos+: { secretRef+: { fieldPath: fieldPath } } },
      '#withKind':: d.fn(help='"Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"', args=[d.arg(name='kind', type=d.T.string)]),
      withKind(kind): { storageos+: { secretRef+: { kind: kind } } },
      '#withName':: d.fn(help='"Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
      withName(name): { storageos+: { secretRef+: { name: name } } },
      '#withNamespace':: d.fn(help='"Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/"', args=[d.arg(name='namespace', type=d.T.string)]),
      withNamespace(namespace): { storageos+: { secretRef+: { namespace: namespace } } },
      '#withResourceVersion':: d.fn(help='"Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
      withResourceVersion(resourceVersion): { storageos+: { secretRef+: { resourceVersion: resourceVersion } } },
      '#withUid':: d.fn(help='"UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids"', args=[d.arg(name='uid', type=d.T.string)]),
      withUid(uid): { storageos+: { secretRef+: { uid: uid } } },
    },
    '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { storageos+: { fsType: fsType } },
    '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
    withReadOnly(readOnly): { storageos+: { readOnly: readOnly } },
    '#withVolumeName':: d.fn(help='"volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace."', args=[d.arg(name='volumeName', type=d.T.string)]),
    withVolumeName(volumeName): { storageos+: { volumeName: volumeName } },
    '#withVolumeNamespace':: d.fn(help="\"volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to \\\"default\\\" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.\"", args=[d.arg(name='volumeNamespace', type=d.T.string)]),
    withVolumeNamespace(volumeNamespace): { storageos+: { volumeNamespace: volumeNamespace } },
  },
  '#vsphereVolume':: d.obj(help='"Represents a vSphere volume resource."'),
  vsphereVolume: {
    '#withFsType':: d.fn(help='"fsType is filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
    withFsType(fsType): { vsphereVolume+: { fsType: fsType } },
    '#withStoragePolicyID':: d.fn(help='"storagePolicyID is the storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName."', args=[d.arg(name='storagePolicyID', type=d.T.string)]),
    withStoragePolicyID(storagePolicyID): { vsphereVolume+: { storagePolicyID: storagePolicyID } },
    '#withStoragePolicyName':: d.fn(help='"storagePolicyName is the storage Policy Based Management (SPBM) profile name."', args=[d.arg(name='storagePolicyName', type=d.T.string)]),
    withStoragePolicyName(storagePolicyName): { vsphereVolume+: { storagePolicyName: storagePolicyName } },
    '#withVolumePath':: d.fn(help='"volumePath is the path that identifies vSphere volume vmdk"', args=[d.arg(name='volumePath', type=d.T.string)]),
    withVolumePath(volumePath): { vsphereVolume+: { volumePath: volumePath } },
  },
  '#withAccessModes':: d.fn(help='"accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes"', args=[d.arg(name='accessModes', type=d.T.array)]),
  withAccessModes(accessModes): { accessModes: if std.isArray(v=accessModes) then accessModes else [accessModes] },
  '#withAccessModesMixin':: d.fn(help='"accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='accessModes', type=d.T.array)]),
  withAccessModesMixin(accessModes): { accessModes+: if std.isArray(v=accessModes) then accessModes else [accessModes] },
  '#withCapacity':: d.fn(help="\"capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity\"", args=[d.arg(name='capacity', type=d.T.object)]),
  withCapacity(capacity): { capacity: capacity },
  '#withCapacityMixin':: d.fn(help="\"capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='capacity', type=d.T.object)]),
  withCapacityMixin(capacity): { capacity+: capacity },
  '#withMountOptions':: d.fn(help='"mountOptions is the list of mount options, e.g. [\\"ro\\", \\"soft\\"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options"', args=[d.arg(name='mountOptions', type=d.T.array)]),
  withMountOptions(mountOptions): { mountOptions: if std.isArray(v=mountOptions) then mountOptions else [mountOptions] },
  '#withMountOptionsMixin':: d.fn(help='"mountOptions is the list of mount options, e.g. [\\"ro\\", \\"soft\\"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='mountOptions', type=d.T.array)]),
  withMountOptionsMixin(mountOptions): { mountOptions+: if std.isArray(v=mountOptions) then mountOptions else [mountOptions] },
  '#withPersistentVolumeReclaimPolicy':: d.fn(help='"persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming"', args=[d.arg(name='persistentVolumeReclaimPolicy', type=d.T.string)]),
  withPersistentVolumeReclaimPolicy(persistentVolumeReclaimPolicy): { persistentVolumeReclaimPolicy: persistentVolumeReclaimPolicy },
  '#withStorageClassName':: d.fn(help='"storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass."', args=[d.arg(name='storageClassName', type=d.T.string)]),
  withStorageClassName(storageClassName): { storageClassName: storageClassName },
  '#withVolumeAttributesClassName':: d.fn(help='"Name of VolumeAttributesClass to which this persistent volume belongs. Empty value is not allowed. When this field is not set, it indicates that this volume does not belong to any VolumeAttributesClass. This field is mutable and can be changed by the CSI driver after a volume has been updated successfully to a new class. For an unbound PersistentVolume, the volumeAttributesClassName will be matched with unbound PersistentVolumeClaims during the binding process. This is an alpha field and requires enabling VolumeAttributesClass feature."', args=[d.arg(name='volumeAttributesClassName', type=d.T.string)]),
  withVolumeAttributesClassName(volumeAttributesClassName): { volumeAttributesClassName: volumeAttributesClassName },
  '#withVolumeMode':: d.fn(help='"volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec."', args=[d.arg(name='volumeMode', type=d.T.string)]),
  withVolumeMode(volumeMode): { volumeMode: volumeMode },
  '#mixin': 'ignore',
  mixin: self,
}
