{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='podFailurePolicyRule', url='', help='"PodFailurePolicyRule describes how a pod failure is handled when the requirements are met. One of onExitCodes and onPodConditions, but not both, can be used in each rule."'),
  '#onExitCodes':: d.obj(help='"PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check."'),
  onExitCodes: {
    '#withContainerName':: d.fn(help='"Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template."', args=[d.arg(name='containerName', type=d.T.string)]),
    withContainerName(containerName): { onExitCodes+: { containerName: containerName } },
    '#withOperator':: d.fn(help="\"Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:\\n\\n- In: the requirement is satisfied if at least one container exit code\\n  (might be multiple if there are multiple containers not restricted\\n  by the 'containerName' field) is in the set of specified values.\\n- NotIn: the requirement is satisfied if at least one container exit code\\n  (might be multiple if there are multiple containers not restricted\\n  by the 'containerName' field) is not in the set of specified values.\\nAdditional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.\"", args=[d.arg(name='operator', type=d.T.string)]),
    withOperator(operator): { onExitCodes+: { operator: operator } },
    '#withValues':: d.fn(help="\"Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.\"", args=[d.arg(name='values', type=d.T.array)]),
    withValues(values): { onExitCodes+: { values: if std.isArray(v=values) then values else [values] } },
    '#withValuesMixin':: d.fn(help="\"Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='values', type=d.T.array)]),
    withValuesMixin(values): { onExitCodes+: { values+: if std.isArray(v=values) then values else [values] } },
  },
  '#withAction':: d.fn(help="\"Specifies the action taken on a pod failure when the requirements are satisfied. Possible values are:\\n\\n- FailJob: indicates that the pod's job is marked as Failed and all\\n  running pods are terminated.\\n- FailIndex: indicates that the pod's index is marked as Failed and will\\n  not be restarted.\\n  This value is beta-level. It can be used when the\\n  `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).\\n- Ignore: indicates that the counter towards the .backoffLimit is not\\n  incremented and a replacement pod is created.\\n- Count: indicates that the pod is handled in the default way - the\\n  counter towards the .backoffLimit is incremented.\\nAdditional values are considered to be added in the future. Clients should react to an unknown action by skipping the rule.\"", args=[d.arg(name='action', type=d.T.string)]),
  withAction(action): { action: action },
  '#withOnPodConditions':: d.fn(help='"Represents the requirement on the pod conditions. The requirement is represented as a list of pod condition patterns. The requirement is satisfied if at least one pattern matches an actual pod condition. At most 20 elements are allowed."', args=[d.arg(name='onPodConditions', type=d.T.array)]),
  withOnPodConditions(onPodConditions): { onPodConditions: if std.isArray(v=onPodConditions) then onPodConditions else [onPodConditions] },
  '#withOnPodConditionsMixin':: d.fn(help='"Represents the requirement on the pod conditions. The requirement is represented as a list of pod condition patterns. The requirement is satisfied if at least one pattern matches an actual pod condition. At most 20 elements are allowed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='onPodConditions', type=d.T.array)]),
  withOnPodConditionsMixin(onPodConditions): { onPodConditions+: if std.isArray(v=onPodConditions) then onPodConditions else [onPodConditions] },
  '#mixin': 'ignore',
  mixin: self,
}
