{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='ruleWithOperations', url='', help='"RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid."'),
  '#withApiGroups':: d.fn(help="\"APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.\"", args=[d.arg(name='apiGroups', type=d.T.array)]),
  withApiGroups(apiGroups): { apiGroups: if std.isArray(v=apiGroups) then apiGroups else [apiGroups] },
  '#withApiGroupsMixin':: d.fn(help="\"APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='apiGroups', type=d.T.array)]),
  withApiGroupsMixin(apiGroups): { apiGroups+: if std.isArray(v=apiGroups) then apiGroups else [apiGroups] },
  '#withApiVersions':: d.fn(help="\"APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.\"", args=[d.arg(name='apiVersions', type=d.T.array)]),
  withApiVersions(apiVersions): { apiVersions: if std.isArray(v=apiVersions) then apiVersions else [apiVersions] },
  '#withApiVersionsMixin':: d.fn(help="\"APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='apiVersions', type=d.T.array)]),
  withApiVersionsMixin(apiVersions): { apiVersions+: if std.isArray(v=apiVersions) then apiVersions else [apiVersions] },
  '#withOperations':: d.fn(help="\"Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.\"", args=[d.arg(name='operations', type=d.T.array)]),
  withOperations(operations): { operations: if std.isArray(v=operations) then operations else [operations] },
  '#withOperationsMixin':: d.fn(help="\"Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='operations', type=d.T.array)]),
  withOperationsMixin(operations): { operations+: if std.isArray(v=operations) then operations else [operations] },
  '#withResources':: d.fn(help="\"Resources is a list of resources this rule applies to.\\n\\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\\n\\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\\n\\nDepending on the enclosing object, subresources might not be allowed. Required.\"", args=[d.arg(name='resources', type=d.T.array)]),
  withResources(resources): { resources: if std.isArray(v=resources) then resources else [resources] },
  '#withResourcesMixin':: d.fn(help="\"Resources is a list of resources this rule applies to.\\n\\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\\n\\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\\n\\nDepending on the enclosing object, subresources might not be allowed. Required.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='resources', type=d.T.array)]),
  withResourcesMixin(resources): { resources+: if std.isArray(v=resources) then resources else [resources] },
  '#withScope':: d.fn(help='"scope specifies the scope of this rule. Valid values are \\"Cluster\\", \\"Namespaced\\", and \\"*\\" \\"Cluster\\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \\"Namespaced\\" means that only namespaced resources will match this rule. \\"*\\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \\"*\\"."', args=[d.arg(name='scope', type=d.T.string)]),
  withScope(scope): { scope: scope },
  '#mixin': 'ignore',
  mixin: self,
}
