---
_comment: Do not remove front matter.
---

## Prerequisites

Although not required in all cases, [Git], [Go], and [Dart Sass] are commonly used when working with Hugo.

Git is required to:

- Build Hugo from source
- Use the [Hugo Modules] feature
- Install a theme as a Git submodule
- Access [commit information] from a local Git repository
- Host your site on [CI/CD](g) platforms such as [Cloudflare][], [GitHub Pages][], [GitLab Pages][], [Netlify][], [Render][], or [Vercel][]

Go is required to:

- Build Hugo from source
- Use the Hugo Modules feature

Dart Sass is required to transpile Sass to CSS when using the latest features of the Sass language.

Please refer to the relevant documentation for installation instructions:

- [Git][git install]
- [Go][go install]
- [Dart Sass][dart sass install]

[Cloudflare]: /host-and-deploy/host-on-cloudflare/
[commit information]: /methods/page/GitInfo
[dart sass install]: /functions/css/sass/#dart-sass
[dart sass]: https://sass-lang.com/dart-sass
[git install]: https://git-scm.com/book/en/v2/Getting-Started-Installing-Git
[git]: https://git-scm.com/
[GitHub Pages]: /host-and-deploy/host-on-github-pages/
[GitLab Pages]: /host-and-deploy/host-on-gitlab-pages/
[go install]: https://go.dev/doc/install
[go]: https://go.dev/
[hugo modules]: /hugo-modules/
[Netlify]: /host-and-deploy/host-on-netlify/
[Render]: /host-and-deploy/host-on-render/
[Vercel]: /host-and-deploy/host-on-vercel/
