# Summary

- [Introduction](introduction.md)
- [Q & A](questions.md)
- [Install](install.md)
- [Configuration](configuration.md)
- [Integration](integration.md)
- [Commands](all-commands.md)
  - [Basic workflow](basic-commands.md)
    - [hack](commands/hack.md)
    - [sync](commands/sync.md)
    - [switch](commands/switch.md)
    - [propose](commands/propose.md)
  - [Dealing with errors](error-commands.md)
    - [continue](commands/continue.md)
    - [skip](commands/skip.md)
    - [status](commands/status.md)
    - [status.reset](commands/status-reset.md)
    - [status.show](commands/status-show.md)
    - [undo](commands/undo.md)
  - [Stacked changes](stacked-changes.md)
    - [append](commands/append.md)
    - [detach](commands/detach.md)
    - [diff-parent](commands/diff-parent.md)
    - [merge](commands/merge.md)
    - [prepend](commands/prepend.md)
    - [set-parent](commands/set-parent.md)
    - [swap](commands/swap.md)
  - [Limit branch syncing](branch-types.md)
    - [contribute](commands/contribute.md)
    - [observe](commands/observe.md)
    - [park](commands/park.md)
    - [prototype](commands/prototype.md)
  - [Configuration commands](configuration-commands.md)
    - [completions](commands/completions.md)
    - [config](commands/config.md)
    - [config.get-parent](commands/config-get-parent.md)
    - [config.remove](commands/config-remove.md)
    - [config.setup](commands/config-setup.md)
    - [offline](commands/offline.md)
  - [Additional commands](additional-commands.md)
    - [branch](commands/branch.md)
    - [compress](commands/compress.md)
    - [delete](commands/delete.md)
    - [help](commands/help.md)
    - [rename](commands/rename.md)
    - [repo](commands/repo.md)
    - [ship](commands/ship.md)
- [Configuration file](configuration-file.md)
- [Preferences](preferences.md)
  - [Branches]()
    - [Contribution branches](preferences/contribution-branches.md)
    - [Contribution regex](preferences/contribution-regex.md)
    - [Default branch type](preferences/default-branch-type.md)
    - [Feature regex](preferences/feature-regex.md)
    - [Main branch](preferences/main-branch.md)
    - [Observed branches](preferences/observed-branches.md)
    - [Observed regex](preferences/observed-regex.md)
    - [Parked branches](preferences/parked-branches.md)
    - [Perennial branches](preferences/perennial-branches.md)
    - [Perennial regex](preferences/perennial-regex.md)
    - [Prototype branches](preferences/prototype-branches.md)
  - [Create]()
    - [Create prototype branches](preferences/create-prototype-branches.md)
    - [New branch type](preferences/new-branch-type.md)
    - [Push new branches](preferences/push-new-branches.md)
  - [Hosting]()
    - [Development remote](preferences/dev-remote.md)
    - [Forge Type](preferences/forge-type.md)
    - [Origin hostname](preferences/hosting-origin-hostname.md)
    - [Bitbucket access token](preferences/bitbucket-app-password.md)
    - [Bitbucket username](preferences/bitbucket-username.md)
    - [Codeberg token](preferences/codeberg-token.md)
    - [Gitea token](preferences/gitea-token.md)
    - [GitHub token](preferences/github-token.md)
    - [GitLab token](preferences/gitlab-token.md)
  - [Ship]()
    - [Delete tracking branch](preferences/ship-delete-tracking-branch.md)
    - [Ship strategy](preferences/ship-strategy.md)
  - [Sync]()
    - [Feature sync strategy](preferences/sync-feature-strategy.md)
    - [Perennial sync strategy](preferences/sync-perennial-strategy.md)
    - [Prototype sync strategy](preferences/sync-prototype-strategy.md)
    - [Run pre-push hook](preferences/push-hook.md)
    - [Sync tags](preferences/sync-tags.md)
    - [Sync with upstream](preferences/sync-upstream.md)
  - [Offline mode](preferences/offline.md)
  - [Branch lineage](preferences/parent.md)
