-- MySQL dump 10.16  Distrib 10.2.36-MariaDB, for debian-linux-gnu (aarch64)
--
-- Host: localhost    Database: extradb
-- ------------------------------------------------------
-- Server version	10.2.36-MariaDB-1:10.2.36+maria~bionic-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `extradb`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `extradb` /*!40100 DEFAULT CHARACTER SET utf8mb4 */;

USE `extradb`;

--
-- Table structure for table `wp_posts`
--

DROP TABLE IF EXISTS `wp_posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3930 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_posts`
--

LOCK TABLES `wp_posts` WRITE;
/*!40000 ALTER TABLE `wp_posts` DISABLE KEYS */;
INSERT INTO `wp_posts` VALUES (1305,1,'2020-08-12 05:31:16','2020-08-12 11:31:16','<!-- wp:paragraph -->\n<p>Getting new developers up to speed with your procedures and their projects can be a time-consuming and complex process. Unfortunately, we’re still hearing stories about new hires taking as much 1-2 days to get their laptops properly set up and 1-2 weeks of onboarding before they can deliver code to production. In today’s competitive, fast-paced world, the amount of wasted time is untenable at best. The faster a team can deliver code to production, the better. However, you can’t cut corners without causing quality and efficiency to suffer. In this article, we’ll take a look at the process of onboarding new developers and discuss how the right development tools, like <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a>, can help.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Why is it important to streamline developer onboarding?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>When you\'ve just made a bet on a talented, promising new hire, of course you don’t want to risk them making expensive mistakes. But why waste their time and your bottom line by not getting them up-and-running as fast and as well as possible? In the 2018 StackOverflow Developer Survey, more than 50,000 software developers from around the world answered the question, “<a href=\"https://insights.stackoverflow.com/survey/2018#work-how-long-do-developers-expect-new-coworkers-to-take-to-be-productive\">How Long Do Developers Expect New Coworkers to Take to Be Productive?</a>” 70% answered that it would take one month or more. We aimed to help speed that up.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Update: While the <a href=\"https://insights.stackoverflow.com/survey/2020#work-onboarding\">2020 StackOverflow survey</a> does not have the same question, it does ask if an onboarding process exists. The chart is a bit ambiguous but suffice to say half of the respondents were unsatisfied with the lack of onboarding process, or lack of good onboarding process, at their company.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":3207} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2018/05/Screen-Shot-2020-08-11-at-7.17.40-PM-1024x466.png\" alt=\"Half of respondents reported having an onboarding process, one fifth reported no on boarding process\" class=\"wp-image-3207\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Five years ago, we had a constant problem when a new person came on at my old agency. A new hire would come in and everyone was running around too busy to help, but the new person still couldn\'t access, download, and set up the site they were tasked to work on. Instead of getting to it, they were effectively told, \"Here, wait until someone is available, and sit on your thumbs.\" How demoralizing! Particularly for high achievers who want to jump in and make a big impact out of the gates. Fortunately, we knew we were on the right track with the tools we built as early versions of DDEV-Local. We got onboarding down to a where we had new developers and designers contributing their first commit to production by lunchtime on their first day. This was the benefit of having consistency in our teams and our onboarding process.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>That’s why it’s so important to onboard new developers consistently and systematically. By giving them the information they need about workflows, tools, and projects, they can quickly adapt to how things are done at your agency. It\'s not just a time savings. It\'s how much more efficient you can be with a consistent process. This becomes even more important as the organization grows and independent teams need to start forming, causing processes to drift apart to the point where teams are unable to effectively working together.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In turn, consistency leads to a faster “time-to-productivity” for new team members and contractors alike, which in turn, ties to concepts of motivation and autonomy that Daniel Pink describes in his book<a href=\"https://en.wikipedia.org/wiki/Drive:_The_Surprising_Truth_About_What_Motivates_Us\"> Drive</a>. “The first week on the job is always going to be stressful for new team members, but enabling them to make a contribution early on helps them feel they are moving towards the Autonomy, Mastery, and Purpose that Pink talks about in his book,” explains my colleague Kevin Bridges, DDEV CTO.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Of course, this is all great in theory. But how can you make sure your onboarding process is thorough, comprehensive, and provides your new devs with everything they need to get started?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Some onboarding challenges</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>One challenge of developer onboarding is assumed knowledge. Current team members already have a lot of knowledge about current projects and systems gained over their time in your organization. It can be hard for them to have the perspective distinguish between what’s essential what’s need-to-know (or nice-to-know) for new hires. How to communicate what and when in and around this knowledge gap can add to the stress during onboarding. Worse, if there are many different ways of doing something (even as simple as setting up and configuring a laptop with a local environment), you can find yourself in a situation where new hires can only receive support from the person that onboarded them versus the broader organization.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>You’ll need to help prioritize this information, get your developers familiar with the basics first – and to let them start making contributions on their own. In this article about<a href=\"https://stackoverflow.blog/2018/02/05/secret-behind-great-developer-onboarding/\"> The Secret Behind Great Developer Onboarding</a>, two Runtastic employees suggest “Write code, learn about the company, and get to know your colleagues”, including using a buddy system, pairing new devs with someone who knows the ropes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Faster doesn’t always equal better. Care should be taken not to rush the onboarding process or cut corners. A junior developer’s<a href=\"https://www.reddit.com/r/cscareerquestions/comments/6ez8ag/accidentally_destroyed_production_database_on/\"> Reddit CS Career Questions post</a> is a great illustration of this. This junior employee was given incorrect information about how to set up their development environment and ended up wiping the entire production database. While this is an extreme case, this is the sort of thing you’ll face if you don’t have systematic, consistent onboarding procedures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Codementor.io posted a great follow-up post in reaction to this Reddit post:<a href=\"https://www.codementor.io/blog/developer-onboarding-process-32y3zqg1vc\"> 7 Best Practices for Your Developer Onboarding Process</a>. The<a href=\"https://github.com/92bondstreet/awesome-onboarding\"> Awesome Onboarding project</a> on GitHub has more valuable resources in this vein.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Consistency is key to onboarding and delivery quality</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Maintaining consistent development environments across different projects helps make developer onboarding faster and your teams more efficient. Whether you’re talking about working on client projects, or collaborating on open source projects, for newcomers - <a href=\"https://www.ddev.com/xxx/removing-the-biggest-barrier-to-contribution/\">the biggest barrier to contribution is getting a local development environment set up</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>As the team grew in the agency, so did the number of ways to configure and set up local development environments. This stifled collaboration. Whether or not you could work on a project depended on who had onboarded you to their idiosyncratic methods. We knew we couldn’t scale and improve if we didn’t have a consistent process. That was a major motivating factor in building the tools that became DDEV.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Now you can use DDEV-Local to work on all your projects, no matter what open source CMS and deployment models you are using. Once you know a few simple commands, you can spin up any project on your local machine and get to work. And once you are familiar with it, you can apply your knowledge to projects across the board, easily sharing and spinning up projects from any existing configuration.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Improve developer onboarding with DDEV-Local</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Here are two ways that DDEV-Local helps get your team members on board:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Consistency across platforms</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>DDEV-Local offers a single, consistent set of commands when working on projects, across multiple CMSs and across all the major operating systems, no matter what deployment model a project requires. Clients with multi-site portfolios may run Drupal sites, WordPress sites, or even Node.js applications and keep everything running smoothly. DDEV-Local provides a cross-platform PHP-based development environment that works the same on macOS, Windows, and Linux. Update: In our latest <a href=\"https://github.com/ddev/ddev/releases/tag/v1.15.3\">DDEV-Local release, v1.15.3</a>, hundreds of tools, including Node.js, npm, Yarn, Drush, WP-CLI, and mysql are pre-installed in the web container. This means you can use DDEV-Local across your on-going projects.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>By having a consistent approach you make it easier for team members to reuse what they learn for their first project, and apply it to the next.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Take the guesswork out of getting started</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Previously, I wrote about<a href=\"https://www.ddev.com/workflow/the-practicality-of-project-reference-guides/\"> Project Reference Guides</a> to show how a simple-to-maintain resource can effectively improve communication and handoffs between teams. One of those challenges is keeping track of the credential and dependencies for any particular client project, as well as the tools required to get client sites built and running locally so you can get to work.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>When a team member wants to start collaborating they’ll need to <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#importing-assets-for-an-existing-project\">import assets for an existing project</a>. The first time they set it up, they can run <code>ddev describe</code> to see details about the status of the project and in-depth application monitoring. This also provides the project credentials they need to get started.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ddev.readthedocs.io/en/stable/users/extending-commands/\">Extend ddev Commands</a> to run tasks, for example before or after a project starts. To automate setup tasks specific to your project, define them in the project\'s config.yaml file. This can make it easier for your team to employ best practices and greatly reduced the time it takes to scaffold a project.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Get started with DDEV-Local</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>With DDEV-Local, you can speed up developer onboarding dramatically, while ensuring that new developers have all of the information they need to be effective.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ddev.readthedocs.io/en/stable/#intro-to-ddev-local\">Get started with DDEV-Local</a> today and see how easy and reliable a local development environment can be.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><small>Photo credit hagman23 Pixabay <br>Originally published May 17, 2018</small></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Reduce the Time to Onboard New Developers with DDEV','','publish','open','open','','reduce-time-onboard-new-developers-ddev','','https://www.ddev.com/workflow/the-practicality-of-project-reference-guides/\nhttps://www.ddev.com/ddev-local/ddev-local-release-v0-18-0-easier-xdebug-windows-installer-and-more/','2020-10-15 18:33:05','2020-10-16 00:33:05','',0,'https://www.ddev.com/?p=1305',0,'post','',0),(2038,16,'2019-01-15 04:00:37','2019-01-15 11:00:37','We\'re sponsoring and attending Drupal Camp Florida 15-17 February, 2019! Join us to connect with the Drupal community, chat about DevOps and see what we\'ve been up to.\r\n\r\nFlorida DrupalCamp is an annual conference that brings together web developers from all over the world to learn, network and discuss web development and the Drupal content management system.\r\n\r\n<strong>When</strong>: Friday, 15 February- Sunday, 17 February 2019\r\n\r\n<strong>Where</strong>: Florida Technical College, 12900 Challenger Parkway Orlando, Florida 32826\r\n\r\n<strong>Registration</strong>: <a href=\"https://www.fldrupal.camp/\">https://www.fldrupal.camp/</a>\r\n\r\n<strong>Who Attends</strong>: All who are interested in or active participants using Drupal; from site builders to content &amp; digital marketers to those selling and supporting Drupal.','Drupal Camp Florida 2019','We\'re sponsoring and attending Drupal Camp Florida 15-17 February, 2019!','publish','closed','closed','','drupal-camp-florida-2019','','','2020-10-19 18:56:02','2020-10-20 00:56:02','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2038',0,'tribe_events','',0),(2051,11,'2019-01-16 06:44:13','2019-01-16 13:44:13','We’ve just released DDEV v1.5.2! This is a minor release with a couple of very useful features. <a href=\"https://github.com/ddev/ddev/releases\">Install or upgrade now</a>. Here are a couple highlights:\r\n\r\n<strong>Added Linuxbrew for DDEV installation</strong> - <a href=\"http://linuxbrew.sh/\">Linuxbrew</a> is now our <a href=\"https://ddev.readthedocs.io/en/latest/#homebrewlinuxbrew-macoslinux\">preferred install/upgrade technique on all Linux distributions</a>. This makes installation easy and upgrades even easier. We would have loved to support every Linux package manager but the more sustainable solution is this one manager-fits-all. <a href=\"https://github.com/ddev/homebrew-ddev/pull/31\">“Fixes issue #1”</a>!\r\n\r\n<strong>Added php-apcu to the web container</strong> - php-apcu makes Composer classloading much faster. Drupal 8 and TYPO3 will see nice performance improvements, especially on the first visit to a project after a <code>ddev start</code>. For Drupal 8 <code>$settings[\'class_loader_auto_detect\'] = FALSE;</code> is added to the settings.ddev.php and it increases performance quite a lot with php-apcu. Thanks to Matt Glaman <a href=\"https://github.com/mglaman\">@mglaman</a> for the suggestion in <a href=\"https://stackoverflow.com/a/54049172/215713\">Stack Overflow.</a>\r\n\r\n<strong>Ghostscript in the web container</strong> - <a href=\"https://www.ghostscript.com/\">Ghostscript</a> is necessary for TYPO3 CMS to run with all its features. We’ve now added it as <a href=\"https://github.com/ddev/ddev/issues/920\">a standard component in DDEV</a>.\r\n\r\n<strong>Plus</strong>, we’ve added an upgrade to MariaDB in the database container, and PHP 7.3 now has <a href=\"https://github.com/ddev/ddev/issues/1350\">php-memcached in web container</a>. Thanks to Dave Long <a href=\"https://github.com/longwave\">@longwave</a> for contributing a <a href=\"https://github.com/ddev/ddev/pull/1349\">database import progress bar</a> as well!\r\n\r\nFor full details check out the <a href=\"https://github.com/ddev/ddev/releases/tag/v1.5.2\">DDEV v1.5.2 Release Notes</a>.\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"https://github.com/ddev/ddev\">Download DDEV-Local 1.5.2</a>\r\n<h3>Contribute back to DDEV-Local</h3>\r\nOpt-in usage information will help us understand how you’re using DDEV-Local in the wild, so we can improve it. Please consider opting-in to <a href=\"https://ddev.readthedocs.io/en/latest/users/cli-usage/#opt-in-usage-information\">usage and error reporting</a> on your DDEV projects. It helps us see where we can help you succeed in the long-term both in your local environment and on our hosting platform.\r\n\r\nWe\'d love to hear from you about new features that might be most important to you and we always want to hear about bugs. Please take a look around <a href=\"https://github.com/ddev/ddev/issues\">the DDEV issue queue</a> and <a href=\"https://stackoverflow.com/questions/tagged/ddev\">Stack Overflow</a> to spur your thinking!\r\n<h2>Going places with #DDEV!</h2>\r\nComing soon to <a href=\"https://www.fldrupal.camp/\">Florida Drupal Camp</a> and <a href=\"https://events.drupal.org/seattle2019\">DrupalCon Seattle</a>: us! We’re proud to be Platinum Sponsors for Florida Drupal Camp. We’ve <a href=\"https://www.fldrupal.camp/sessions/beginner-track/achieve-devops-nirvana-putting-one-foot-front-other\">proposed</a> <a href=\"https://www.fldrupal.camp/sessions/development-performance/local-development-environments-panel-discussion\">sessions</a> and plan on spending plenty of contribution time with <a href=\"https://www.ddev.com/ddev-local/\">DDEV</a>-Local and <a href=\"https://www.drupal.org/tools\">Quicksprint</a>. Follow along on <a href=\"https://twitter.com/ddev\">Twitter</a> and sign up for our newsletter for all the news on #DDEV.\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">Join Newsletter</a>\r\n\r\n\r\n<hr />\r\n\r\n<small>Photo by <a href=\"https://www.ddev.com/author/elli/\">Elli Ludwigson</a></small>','DDEV v1.5.2: Linuxbrew, php-apcu, Ghostscript and more','','publish','closed','closed','','ddev-v1-5-2-linuxbrew-php-apcu-ghostscript-and-more','','','2019-01-16 06:48:52','2019-01-16 13:48:52','',0,'https://www.ddev.com/?p=2051',0,'post','',0),(2058,16,'2019-01-28 09:15:23','2019-01-28 16:15:23','We\'re Gold Sponsors! We\'ll be on the ground in London talking about our DDEV products for local development and live hosting and connecting with community members. We\'re also looking forward to <a href=\"https://drupalcamp.london/about/why-attend-cxo\">CxO day</a> to hear what everyone is up to.\r\n\r\n\"DrupalCamp London is a fantastic opportunity to learn, meet old friends (and make new ones), network and give back to the community. With all the activity and over 500 attendees, there is something for everyone to get involved in.\"\r\n\r\n<strong>When</strong>: Friday, 1 March- Sunday, 3 march 2019\r\n\r\n<strong>Where</strong>: University Building, University of London, Northampton Square, London UK\r\n\r\n<strong>Registration</strong>: <a href=\"https://drupalcamp.london/tickets\">https://drupalcamp.london/tickets</a>\r\n\r\n<strong>Who Attends</strong>: DrupalCamp London brings together hundreds of people from across the globe who use, develop, design and support the Drupal platform.','Drupal Camp London','We\'re Gold Sponsors! We\'ll be on the ground in London talking about our DDEV products','publish','closed','closed','','drupal-camp-london','','','2020-10-19 18:57:30','2020-10-20 00:57:30','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2058',0,'tribe_events','',0),(2066,6,'2019-01-30 10:33:01','2019-01-30 17:33:01','We caught up with Matt Glaman from <a href=\"https://commerceguys.com/\">Commerce Guys</a>, who was first introduced to DDEV at <a href=\"https://www.fldrupal.camp/\">DrupalCamp Florida</a> 2018. Since then, he’s been an avid DDEV user, contributing great feedback and writing <a href=\"https://glamanate.com/tags/ddev\">blog posts</a> to help other DDEV users. He wrote about learning how to use <a href=\"https://glamanate.com/blog/xdebug-over-command-line-ddev\">Xdebug over the command line</a> and even a whole series on testing, which we’re going to look at in this post.\r\n\r\nMatt Glaman is an active member of the DDEV community, <a href=\"https://twitter.com/randyfay/status/1090727584457940993\">Randy Fay pointed out</a> that \"Matt <a href=\"https://glamanate.com/blog/goland-ide-and-local-vendor-directories\">also took up GoLang</a> and made *significant* contributions to ddev. The <a href=\"https://github.com/ddev/ddev/pulls?q=is%3Apr+author%3Amglaman+is%3Aclosed\">docroot detection he wrote</a> has made ddev ever-so-much better.\" Thanks Matt!\r\n<h3>Tell us a bit about yourself, Matt!</h3>\r\n<img class=\" wp-image-2070 alignright\" src=\"https://www.ddev.com/content/uploads/2019/01/author-matt-glaman-e1548869414810-1024x966.jpg\" alt=\"\" width=\"292\" height=\"266\" />\r\n\r\nI’m Matt Glaman. I\'ve been working with Drupal for a little over six years, now. I first got into web development so that I could make a website for our Rainbow 6 clan, back in the good old days of MSN Zone and using Tripod UK so I could get free hosting that supported PHP.\r\n\r\nI joined Commerce Guys in 2015 after contributing to Drupal Commerce 1.x on a personal basis while working for two other Drupal-related businesses. I help co-maintain Commerce 2.x and a wide variety of contributed modules and work primarily with other agencies to help implement large Commerce 2.x projects successfully. I also remained a part of the core team at Commerce Guys when it split from Platform.sh to refocus on Drupal Commerce in 2016.\r\n<h3>You’ve written <a href=\"https://glamanate.com/tags/testing\">a three-part series about test-driven development</a> with Drupal. What was the big change with writing tests in Drupal 8?</h3>\r\nDrupal 8 adopted <a href=\"https://phpunit.de/\">PHPUnit</a> and deprecated Simpletest. This is probably one of my most favorite things about Drupal 8. Really. Writing tests for Drupal 7 was abhorrent and I like to work in a test-driven development mode.\r\n\r\nWith the <a href=\"https://www.drupal.org/node/2304461\">KernelTestBaseTNG™</a> issue, Drupal core officially moved to being based on top of PHPUnit for Kernel and Unit tests. Soon more test types were to follow, such as <a href=\"https://www.drupal.org/node/2232861\">browser tests</a> and <a href=\"https://www.drupal.org/node/2469713\">JavaScript testing</a>.\r\n\r\nPHPUnit is the de facto xUnit implementation for PHP. That means Drupal tests are now written using the same testing infrastructure as Symfony and most other PHP projects. In fact, one of our earliest contributors for Drupal Commerce 2.x was new to Drupal but able to contribute code because they could easily write tests.\r\n<h3>That shows that when open source projects standardize, they make it easier for new contributors. What prompted you to write this series?</h3>\r\nA few years ago, I wrote <a href=\"https://drupalcommerce.org/blog/45322/commerce-2x-unit-kernel-and-functional-tests-oh-my\">a blog post for Drupal Commerce users</a> that helped explain the different test suites and how to run them—especially PhantomJS for the JavaScript tests. Recently, before writing the series, Drupal had finally dropped PhantomJS in favor of Chromedriver. After Chrome announced headless support, PhantomJS became antiquated as it was a headless WebKit browser. PhantomJS was also buggy and using Chrome via Chromedriver makes things must more stable.\r\n\r\nHowever, it is still hard for people to run tests locally, at least the JavaScript tests. This is especially true now that Nightwatch.js—a JavaScript testing framework which also runs Chromedriver—was added.\r\n\r\nSo I decided to write about how DDEV can make life easier.\r\n<h3>“Making life easier,” that’s what DDEV is aiming for! Tell us what you used for development before DDEV, and why you switched?</h3>\r\nBefore DDEV I managed my own tooling called <a href=\"https://github.com/mglaman/platform-docker\">platform-docker</a>. This was before Lando, Docksal, DDEV, and such. DrupalVM had just come out. I had been using Vagrant based tools but kept running out of disk space due to the sheer size of each VM required to meet client requirements. Then I found out about DDEV at Florida DrupalCamp 2018.\r\n\r\nI was glad I could finally drop my own blob of tooling and use a shared tool. I got sick of having to not only manage client sites but also manage my own tooling. I also stopped having to cycle through new projects. I would only have to spin up a new environment once every few months.\r\n\r\nI switched to DDEV so that I could just contribute to a tool and have what goodies I liked and take in goodies from others. We have also made DDEV our official local stack tool at Commerce Guys. It has allowed us to streamline local environments without any issues. We have projects set up for testing and Blackfire.io so everyone can do performance profiling.\r\n<h3>Thanks, Matt!</h3>\r\nThanks for all your contributions, Matt. It’s great that you’re investing the effort you used to put into your own tools into DDEV and helping so many other people. You sharing your knowledge with the community is making a big difference to a lot of developers.\r\n<h3>Learn more ...</h3>\r\nMatt Glaman wrote the <a href=\"https://www.packtpub.com/web-development/drupal-8-development-cookbook-second-edition\">Drupal 8 Development Cookbook</a>, which includes 60 hands-on recipes that get you acquainted with Drupal 8. Matt will be speaking at <a href=\"https://www.midcamp.org/\">MidCamp</a> (March 20-23, 2019), and DrupalCon Seattle (April 8-12, 2019) about <a href=\"https://events.drupal.org/seattle2019/sessions/delivering-headless-commerce\">delivering headless eCommerce with Drupal Commerce</a>.\r\n\r\nRead Matt Glaman’s series on test-driven development with Drupal and DDEV.\r\n\r\n<strong>Part 1. <a href=\"https://glamanate.com/blog/running-drupals-phpunit-test-suites-ddev\">Running Drupal\'s PHPUnit test suites on DDEV</a>.</strong> How to execute PHPUnit from within the web container in DDEV for Unit, Kernel, and Functional tests.\r\n\r\n<strong>Part 2. <a href=\"https://glamanate.com/blog/running-drupals-functionaljavascript-tests-ddev\">Running Drupal\'s FunctionalJavascript tests on DDEV</a>.</strong> How to Chromedriver running to execute the FunctionalJavascript test suite.\r\n\r\n<strong>Part 3. <a href=\"https://glamanate.com/blog/running-drupals-nightwatch-test-suite-ddev\">Running Drupal\'s Nightwatch test suite on DDEV</a>.</strong> How to run Drupal\'s newest testing framework: Nightwatch.js, for end-to-end tests in Node.js run against a Selenium/WebDriver server.\r\n<h3>Sign up to the mailing list!</h3>\r\nYou’ll be the first to know about tips, tutorials, and community news.\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">Join the DDEV Newsletter</a>\r\n\r\n<small>Photo by <a href=\"https://unsplash.com/photos/2IkxeDKaZdY?utm_source=unsplash&amp;utm_medium=referral&amp;utm_content=creditCopyText\">Mike Enerio</a> on <a href=\"https://unsplash.com/?utm_source=unsplash&amp;utm_medium=referral&amp;utm_content=creditCopyText\">Unsplash</a>.</small>','Matt Glaman’s Guide to Test-Driven Development with DDEV and Drupal','','publish','closed','closed','','test-driven-development-with-ddev-and-drupal','','','2019-02-07 06:37:55','2019-02-07 13:37:55','',0,'https://www.ddev.com/?p=2066',0,'post','',0),(2077,2,'2019-02-06 11:10:57','2019-02-06 18:10:57','<!-- wp:paragraph -->\n<p>Coming soon to an open source community event near you: us! We’re very pleased to be able to sponsor and attend three upcoming Drupal events: Drupal Camp Florida, Drupal Camp London, and DrupalCon Seattle.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We’d like to take the opportunity to share what we’ve been up to developing DDEV-Local and DDEV-Live, some tidbits of wisdom on DevOps workflows, and especially to hear what you’ve been working on. Our goal is to support your work from development to deployment, and we love seeing what you’ve built and how DDEV has helped enable Drupal contributions.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Bonus: we’ve have a couple of giveaways lined up for you if you subscribe to our newsletter.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3><a href=\"https://www.fldrupal.camp/\">Drupal Camp Florida - 15-17 February 2019</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>First up, we’re heading to Orlando as sponsors and presenters. It’s a pleasure and an honor to support the community as the Platinum Sponsor of Florida Drupal Camp. Catch Drud CTO Kevin Bridges presenting and participating:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.fldrupal.camp/sessions/beginner-track/achieve-devops-nirvana-putting-one-foot-front-other\">Achieve DevOps Nirvana by Putting One Foot in Front of the Other</a></li><li><a href=\"https://www.fldrupal.camp/sessions/development-performance/local-development-environments-panel-discussion\">Local Development Environments Panel Discussion</a>, presented with these friends and colleagues: <a href=\"https://www.fldrupal.camp/users/volkswagenchick\">volkswagenchick</a>, <a href=\"https://www.fldrupal.camp/users/cyberswat\">cyberswat</a>, <a href=\"https://www.fldrupal.camp/users/wjackson\">wjackson</a>, <a href=\"https://www.fldrupal.camp/users/labboy0276\">labboy0276</a>, ekl1773, <a href=\"https://www.fldrupal.camp/users/jmolivas\">jmolivas</a>, &amp; <a href=\"https://www.fldrupal.camp/users/socketwench\">socketwench</a></li><li>We will be hanging around the “Genius Bar” at the camp if you want to connect further and we’ll be attending the <a href=\"https://www.fldrupal.camp/conference/contribution-day\">Contribution Day on Sunday</a>.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Sign up for our newsletter and pick up your complimentary t-shirt at the camp!<a id=\"DCSeattle\"></a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3><a href=\"https://drupalcamp.london/\">Drupal Camp London - 1-3 March 2019</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Next up is a hop across the pond to London. We’re supporting this Drupal Camp as Gold Sponsors.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>We’ll be opening up another round of Golden Tickets for early access to our hosting platform! Come see us to learn more.</li><li>Stop by our booth to receive a Golden Ticket and your complimentary t-shirt if you sign up now.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3><a href=\"https://events.drupal.org/seattle2019\">DrupalCon Seattle - 8-12 April 2019</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>In April we\'re headed to the US West Coast for DrupalCon Seattle! We will once again be sponsors, and we’ll have a booth right next to the games area on the exhibit hall floor.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>You can&nbsp;choose to pick up your complimentary, soft, stylish DDEV t-shirt! We\'ll send you the DDEV book when you sign up.</li><li>Ask about our latest and greatest hosting platform developments when you stop by, we’d love to show you what’s new.</li><li>Check your program for a #DDEV Golden Ticket for early access to the hosting platform!</li><li>Our CTO Kevin Bridges will be presenting a <a href=\"https://events.drupal.org/seattle2019/lightning-talk-presentations\">lightning talk on DevOps and creating a culture of safety</a></li><li>And don’t forget to attend the contribution times throughout the week! This DrupalCon includes workshops to get you set up for <a href=\"http://drupal.org/tools\">local Drupal development</a>&nbsp;with the <a href=\"https://github.com/ddev/quicksprint\">DDEV Quicksprint</a>&nbsp;toolset on <a href=\"https://events.drupal.org/seattle2019/news/contributing-drupalcon\">Monday, Tuesday, and Friday</a> so you can get started contributing ASAP.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Not attending those events?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We’re always adding more events where we can meet you. Currently, we’ve got our eyes on a couple of <a href=\"http://typo3.org\">TYPO3</a> events later in the year and will be making plans and updating you as soon as possible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In the meantime, consider signing up for the next online training from DrupalEasy on <a href=\"https://www.drupaleasy.com/ddev\">Professional Local Development with DDEV.</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Safe Travels!</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We’re looking forward to seeing everyone soon. Give us a shout <a href=\"http://twitter.com/ddev\">on Twitter</a> with #DDEV anytime.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Join our newsletter and be one of the first to know about new DDEV features and releases, community success stories, and more. If you sign up now, we’ll also send you a copy of the <a href=\"https://www.amazon.com/Local-Development-Explained-Step-Step/dp/1731048858/ref=tmm_pap_swatch_0\">DDEV ebook by Mike Anello</a>, aka @ultimike, and a T-Shirt to pick up at one of these events.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->\n\n<!-- wp:paragraph -->\n<p><small>Photo of Seattle by <a href=\"https://www.ddev.com/author/elli/\">Elli Ludwigson</a></small></p>\n<!-- /wp:paragraph -->','Meet up with the DDEV team in early 2019','','publish','closed','closed','','meet-up-with-the-ddev-team-in-early-2019','','','2020-10-15 18:25:24','2020-10-16 00:25:24','',0,'https://www.ddev.com/?p=2077',0,'post','',0),(2086,11,'2019-02-12 10:12:36','2019-02-12 17:12:36','<!-- wp:paragraph -->\n<p>We’ve just released <strong>DDEV v1.6.0</strong>! This release includes NFS mounting and Chocolatey for Windows. <a href=\"https://github.com/ddev/ddev/releases\">Install or upgrade now</a>. Here are a couple of highlights:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>NFS Mounting</strong> - DDEV now supports <a href=\"https://github.com/ddev/ddev/pull/1396\">NFS mounting</a> into the container on all platforms. This provides nearly the speed increase of the<a href=\"https://www.ddev.com/ddev-local/ddev-locals-new-webcache-feature/\"> experimental macOS webcache feature</a>, but with far greater reliability. Bonus on this one is that it also solves symlink issues on Windows. It does require some configuration on the host side, so please <a href=\"https://ddev.readthedocs.io/en/latest/users/performance/#using-nfs-to-mount-the-project-into-the-container\">read the docs, </a> <a href=\"https://www.ddev.com/ddev-local/ddev-local-nfs-mounting-setup-macos/\">this post for config on macOS</a>, and keep an eye out here for upcoming screencasts with more detail (hint: sign up for the <a href=\"http://eepurl.com/gFfwFb\">newsletter</a>). And if you have any trouble setting up NFS on your composer, please <a href=\"https://ddev.readthedocs.io/en/latest/users/performance/#debugging-ddev-start-failures-with-nfs_mount_enabled-true\">read the debugging instructions</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Chocolatey for Windows</strong> - Now you can install DDEV via the <a href=\"https://chocolatey.org/\">Chocolatey</a> package manager on Windows. Fun fact, on our Windows testbots we use choco to install all the key items that a testbot needs with <code>choco install -y git mysql-cli golang make docker-desktop nssm GoogleChrome zip jq composer cmder netcat ddev</code> ddev is now included there in the choco command! Please note that the approval process for Chocolately takes a few days, but DDEV is already available via <code>choco install ddev --version=1.6.0</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Plus</strong>, <a href=\"https://github.com/ddev/ddev/pull/1391\">Xdebug</a> works out of the box on Docker toolbox, a small fix to <a href=\"https://github.com/ddev/ddev/pull/1390\">webcache</a> for non-Mac users, and <a href=\"https://github.com/ddev/ddev/pull/1399\">triggers</a> now work in the ddev-dbserver container.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Community contributions</strong> as issues, reviews, PRs and Stack Overflow articles are all part of how this project works. Read our <a href=\"https://github.com/ddev/ddev/blob/master/CONTRIBUTING.md\">contribution guidelines</a> and <a href=\"https://ddev.readthedocs.io/en/stable/#support\">reach out to us</a> anytime!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>To Install:</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>macOS Homebrew and Linux Linuxbrew: <code>brew upgrade ddev</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Linux or macOS via script:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><code>curl https://raw.githubusercontent.com/ddev/ddev/master/scripts/install_ddev.sh | bash</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Windows: Download the ddev_windows_installer.v1.6.0.exe above or with Chocolatey <code>choco install ddev</code> or <code>choco upgrade ddev</code>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>More details in the release notes:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"https://github.com/ddev/ddev/releases/tag/v1.6.0\">DDEV v1.6.0 Release</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>CTO\'s corner: DDEV Hosting Updates from Kevin</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>When creating a product on the scale of an enterprise hosting system, there are a couple of ways to expose it to the public. &nbsp;We\'ve chosen a slow approach that is filtered by our Golden Ticket programs so that we can align our product vision with the needs of our audience. &nbsp;We have a respectable workload being processed by our production clusters that are delivering traffic for a number of TYPO3 and Drupal sites ranging from small to large.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In the last quarter of 2018, we brought our initial hosting APIs online and began using them. &nbsp;We have dedicated the first quarter of 2019 to focus on increasing functionality in the API so that self-managing organizations, teams, and developers as well as projects, environments and sites is possible. &nbsp;We\'ve been listening to the feedback of our users as they come online and are moving steadily to incorporate the functionality our community is requesting.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Over the coming months, you will continue to hear from various Golden Ticket winners building up to an announcement of general availability for DDEV-Live.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>DDEV Community</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Want to know more about DDEV-Local developer Randy Fay? The <a href=\"https://www.ostraining.com/blog/podcasting/randy-ddev/\">OSTraining podcast has a fun interview</a>, covering everything from an epic self-supported bike trip to Drupal to DDEV.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Want to do a deep dive on DDEV-Local? Mike Anello runs a regular training on DrupalEasy called <a href=\"https://www.drupaleasy.com/ddev\">Professional Local Development with DDEV</a>. The next session is Wednesday, February 20th, so sign up now!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Where in the world is the #DDEV team?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Sign up for the DDEV newsletter below to receive a free copy of <a href=\"https://www.amazon.com/Local-Development-Explained-Step-Step/dp/1731048858/ref=tmm_pap_swatch_0\">Mike Anello’s DDEV ebook</a> and a DDEV t-shirt at one of our upcoming events! We’re headed to <a href=\"https://www.fldrupal.camp/\">Florida Drupal Camp</a>, <a href=\"http://drupalcamp.london\">Drupal Camp London</a> and <a href=\"https://events.drupal.org/seattle2019\">DrupalCon Seattle</a>. Follow along on <a href=\"https://twitter.com/ddev\">Twitter</a> with #DDEV.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->\n\n<!-- wp:paragraph -->\n<p><small>Photo by <a href=\"https://www.ddev.com/author/elli/\">Elli Ludwigson</a></small></p>\n<!-- /wp:paragraph -->','DDEV v1.6.0: NFS Mounting and Chocolatey','','publish','closed','closed','','ddev-v1-6-0-nfs-mounting-and-chocolatey','','','2020-10-07 11:37:47','2020-10-07 17:37:47','',0,'https://www.ddev.com/?p=2086',0,'post','',0),(2093,11,'2019-02-13 07:15:08','2019-02-13 14:15:08','In <a href=\"https://www.ddev.com/ddev-local/ddev-v1-6-0-nfs-mounting-and-chocolatey/\">DDEV-Local v1.6.0</a> we\'ve introduced NFS mounting, which really speeds things up over standard Docker mounting. We\'d love to have you try it, but it does require just a little bit of configuration on the host side.\n\nIn the above chart are some quick performance comparisons. Here you see times for a Drupal 8 install with traditional Docker mounting, NFS mounting, and webcache. The bottom line is NFS mounting is about 3 times as fast as traditional Docker mounting!\n\nOK, let\'s get started. On macOS, you need to do three basic things:\n<ol>\n 	<li>Give \"Full Disk Access\" to the terminal app you\'re going to use (on macOS Mojave and later). For example, if using iTerm2, you would go to Mac preferences -&gt; Security and Privacy -&gt; Privacy and click on \"Full Disk Access\" at the bottom of the list and then use the \"+\" to add iTerm2. This is demonstrated in the screencast below.</li>\n 	<li>Configure NFS on your machine. The simplest way to do this is by running the script <a href=\"https://raw.githubusercontent.com/ddev/ddev/master/scripts/macos_ddev_nfs_setup.sh\">we provide for this purpose</a>. But it\'s your machine, so you can configure it manually or however you like, as long as the directory where you have your projects is shared. The script adds /Users to /etc/exports and then enables and start the nfsd daemon. After it\'s done, run <code>showmount -e</code> and you should see it exporting your /Users directory.</li>\n 	<li>Test and make sure it\'s all working! To do this, go to a project and just <code>ddev debug nfsmount</code> to see if it\'s working or not. When it is, <code>ddev config --nfs-mount-enabled=true</code> and <code>ddev start</code> and you\'re off to the races.</li>\n</ol>\nFor more detail and for Windows and Linux setup do please <a href=\"https://ddev.readthedocs.io/en/stable/users/performance/#using-nfs-to-mount-the-project-into-the-container\">read the docs</a>.\n\nThere are also a number of debugging hints in the <a href=\"https://ddev.readthedocs.io/en/stable/users/performance/#debugging-ddev-start-failures-with-nfs_mount_enabled-true\">debugging section of the docs</a>.\n\n[embed]https://www.youtube.com/watch?v=KtpXFanf8cI&amp;feature=youtu.be&amp;hd=1[/embed]\n\nStay up to date with DDEV:\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">Join Newsletter</a>','DDEV-Local NFS Mounting Setup: macOS','','publish','closed','closed','','ddev-local-nfs-mounting-setup-macos','','','2021-01-06 16:09:28','2021-01-06 23:09:28','',0,'https://www.ddev.com/?p=2093',0,'post','',0),(2109,1,'2019-02-14 15:42:23','2019-02-14 22:42:23','a:10:{s:4:\"type\";s:7:\"wysiwyg\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:4:\"tabs\";s:3:\"all\";s:7:\"toolbar\";s:4:\"full\";s:12:\"media_upload\";i:1;s:5:\"delay\";i:0;}','Newsletter Sales Copy','product_newsletter_sales_copy','publish','closed','closed','','field_5c63069f50ead','','','2019-02-14 15:42:23','2019-02-14 22:42:23','',1838,'https://www.ddev.com/?post_type=acf-field&p=2109',10,'acf-field','',0),(2110,1,'2019-02-14 15:42:23','2019-02-14 22:42:23','a:10:{s:4:\"type\";s:7:\"wysiwyg\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:4:\"tabs\";s:3:\"all\";s:7:\"toolbar\";s:5:\"basic\";s:12:\"media_upload\";i:0;s:5:\"delay\";i:0;}','Newsletter Form Text','product_newsletter_form_text','publish','closed','closed','','field_5c630499fbcc6','','','2019-02-14 15:42:23','2019-02-14 22:42:23','',1838,'https://www.ddev.com/?post_type=acf-field&p=2110',11,'acf-field','',0),(2111,1,'2019-02-14 15:42:23','2019-02-14 22:42:23','a:12:{s:4:\"type\";s:6:\"number\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:4:\"step\";s:0:\"\";}','Newsletter Form ID','product_newsletter_form_id','publish','closed','closed','','field_5c63062d50eac','','','2019-02-14 15:42:23','2019-02-14 22:42:23','',1838,'https://www.ddev.com/?post_type=acf-field&p=2111',12,'acf-field','',0),(2112,1,'2019-02-14 15:42:23','2019-02-14 22:42:23','a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:5:\"array\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}','Newsletter Image','product_newsletter_image','publish','closed','closed','','field_5c6308783ee42','','','2019-02-14 15:42:23','2019-02-14 22:42:23','',1838,'https://www.ddev.com/?post_type=acf-field&p=2112',13,'acf-field','',0),(2119,2,'2019-02-25 07:00:27','2019-02-25 14:00:27','<!-- wp:paragraph -->\n<p>We had a very productive time at <a href=\"https://www.fldrupal.camp\">Drupal Camp Florida</a> last weekend! Thank you to the organizers for all your hard work and to the attendees for your enthusiasm. The camp was a great chance to talk with so many of you about our shared values, projects, and long term goals.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The open source ethos is all about working together and using existing technology to create something bigger. That’s what we’re doing with our hosting platform and local development environment, and that’s what we saw reflected in conversations around the camp. Join our newsletter to hear more about releases and platform updates as they roll out:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Highlights from the Camp</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>An active community and a supportive culture are the bedrock of a long term viable strategy. This was <a href=\"https://drupal.tv/curated-playlists/florida-drupalcamp-2019\">clearly highlighted in several sessions</a> over the weekend in Florida, and it was really good to see that agreement. We’re all talking more about how to improve and develop our culture and systems, how to support our teams and continue to create complex projects.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>One Foot In Front of the Other</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Our CTO Kevin Bridges gave a session on DevOps methodology with a focus on planning and managing a team (or yourself) for reasonable levels of productivity. Kevin showed everyone some of the ways in which work on DDEV products is structured using goals, initiatives, epics, milestones, and tasks. He really drove home the point that it doesn’t matter as much what tools you use as it does how you take care of the people involved so they can do their best work. Takeaways included balanced planning to avoid burnout, team morale checks, and mapping out your goals and the steps to get to them.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>You can <a href=\"https://drupal.tv/external-video/2019-02-16/achieve-devops-nirvana-putting-one-foot-front-other\">check out the entire session here</a> on Drupal.tv</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2121} -->\n<figure class=\"wp-block-image\"><img src=\"https://www.ddev.com/content/uploads/2019/02/IMG_20190216_111142-1024x689.jpg\" alt=\"Kevin presenting at Drupal Camp Florida. Slide is a quote from Randy Fay reading &quot;people need to know that their life is more important than the project they are working on&quot;\" class=\"wp-image-2121\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:quote {\"className\":\"twitter-tweet\"} -->\n<blockquote class=\"wp-block-quote twitter-tweet\"><p dir=\"ltr\" lang=\"en\">\"Creating an environment where people feel safe surfacing problems results in a happy team and greater success delivering your project.\"<br>\"High morale people are more productive.\" <a href=\"https://twitter.com/hashtag/DevOps?src=hash&amp;ref_src=twsrc%5Etfw\">#DevOps</a> is about culture! <a href=\"https://twitter.com/cyberswat?ref_src=twsrc%5Etfw\">@cyberswat</a> presenting at <a href=\"https://twitter.com/hashtag/fldc2019?src=hash&amp;ref_src=twsrc%5Etfw\">#fldc2019</a></p><p>— DRUD Technology (@ddev) <a href=\"https://twitter.com/ddev/status/1096814069498171393?ref_src=twsrc%5Etfw\">February 16, 2019</a></p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p><script async=\"\" src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Local Environments Roadshow</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A massive Thank You to AmyJune Hineline for organizing a panel on local development environments and inviting us to participate! This was a truly great discussion between the folks behind Lando, Flight Deck, Docksal and DDEV. There seemed to be agreement that there is a tool for every job and we’re all pleased to provide an array of Docker-based solutions for users to choose from.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://drupal.tv/external-video/2019-02-17/local-development-environments-panel-discussion\">Listen to the full conversation here.</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote {\"className\":\"twitter-tweet\"} -->\n<blockquote class=\"wp-block-quote twitter-tweet\"><p dir=\"ltr\" lang=\"en\">Fantastic session with all these local development environment folks! Thank you <a href=\"https://twitter.com/volkswagenchick?ref_src=twsrc%5Etfw\">@volkswagenchick</a> for organizing?<br>w/ OSP person <a href=\"https://twitter.com/ekl1773?ref_src=twsrc%5Etfw\">@ekl1773</a> and <a href=\"https://twitter.com/willjackson00?ref_src=twsrc%5Etfw\">@willjackson00</a> <a href=\"https://twitter.com/socketwench?ref_src=twsrc%5Etfw\">@socketwench</a> <a href=\"https://twitter.com/pirogcommamike?ref_src=twsrc%5Etfw\">@pirogcommamike</a> <a href=\"https://twitter.com/labboy0276?ref_src=twsrc%5Etfw\">@labboy0276</a> <a href=\"https://twitter.com/cyberswat?ref_src=twsrc%5Etfw\">@cyberswat</a> <a href=\"https://t.co/sHrvjWc4dT\">pic.twitter.com/sHrvjWc4dT</a></p><p>— OpenStrategyPartners (@open_strategy) <a href=\"https://twitter.com/open_strategy/status/1096867110637187073?ref_src=twsrc%5Etfw\">February 16, 2019</a></p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p><script async=\"\" src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Coming soon...</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Our mission is to support other people\'s work, so <a href=\"https://ddev.readthedocs.io/en/stable/#support\">we’re eager to hear more from you</a> about how DDEV-Local and DDEV-Live can be the most use to you. Find us at our next events, <a href=\"http://drupalcamp.london\">Drupal Camp London</a> or <a href=\"https://events.drupal.org/seattle2019\">DrupalCon Seattle</a>, to learn more about what we can offer you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you sign up for our newsletter now, you’ll also receive the <a href=\"https://www.amazon.com/Local-Development-Explained-Step-Step-ebook/dp/B07KBFR5GQ/ref=sr_1_1?s=books&amp;ie=UTF8&amp;qid=1550795669&amp;sr=1-1\">DDEV ebook</a> by <a href=\"https://twitter.com/ultimike\">@ultimike</a> (Mike Anello) from <a href=\"https://www.drupaleasy.com/ddev\">DrupalEasy</a> and a DDEV t-shirt at our booth:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->','Drupal Camp Florida Wrap-Up','','publish','closed','closed','','drupal-camp-florida-wrap-up','','','2020-10-07 15:11:02','2020-10-07 21:11:02','',0,'https://www.ddev.com/?p=2119',0,'post','',0),(2128,6,'2019-02-26 15:03:20','2019-02-26 22:03:20','When I heard that Oliver Hader, a <a href=\"https://typo3.org/\">TYPO3 CMS</a> core developer, was using DDEV-Local to teach web development to university students, I wanted to know more. So I sat down with him to find out about the course, his students, and how DDEV helps. It’s great to see students working with professional tools to learn industry-relevant skills.\r\n\r\nFor more updates from the DDEV community, join our mailing list.\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">Join Newsletter</a>\r\n\r\nOliver Hader lives in Bavaria, Germany. “Fifty percent of the time I work for <a href=\"https://typo3.com\">TYPO3 GmbH</a> as a core developer, doing research and development. I keep up with new developments and see how we can include and support them in TYPO3. I also took over being the Security Team Lead at the beginning of this year. The other fifty percent of my time, I\'m self-employed, working for web agencies with JavaScript development and frameworks like Angular or Polymer. I also do some consulting in software architecture on how to build flexible applications that are scalable on cloud services. So my work is a mix between consulting and development.”\r\n\r\nOliver is motivated by his own experience as a student, even considering his busy schedule. “The teaching is another 10% on top of my schedule, which means a lot of preparation and feedback happens at the weekends. So this is 105%-110%. :) I think it\'s a good thing to pass on knowledge that you’ve collected, especially to let others know how they can improve make use of new technologies. I realized from my previous time of being a student, we felt ‘If we had known that earlier, it would have helped us a lot.’”\r\n\r\nHe brings his professional experience and aims to create a collaborative atmosphere in the course. “I don’t treat students as students, I try to treat them as new colleagues in a company.”\r\n<h3>Helping students gain professional skills</h3>\r\n“My students are part of a Masters program called Software Engineering and Industrial Applications.” Students come to take this course from all over the world, from North America, the Indian Subcontinent, and Africa. They all have bachelor degrees, but they don’t need to be computer science majors. “Some did electronic engineering, so web development and how it works is new to them. Others have worked with WordPress or other CMSs before. So it’s interesting to see how they interact with each other.”\r\n\r\nOliver teaches the course during the winter semester. The module includes 45 hours of in-classroom contact time and 105 hours of self-directed project work. The contact time is divided between lectures in the morning and hands-on practical instruction in the lab in the afternoon.\r\n\r\nThey work on projects around content management, which fits well with their overall degree goals of learning software design principles. “They have to think in containers, packages, and reusable components. And a content management system qualifies quite well for that because you also find these patterns in a CMS.”\r\n\r\nSince the coursework is project-based, there’s no final exam. For their grade, students complete a project and document their approach. “They write about what went wrong and what went well, design patterns, and their initial plan of what they wanted to achieve.”\r\n\r\nIn the process, they create extensions, build websites and applications. That’s how they’re assessed. “If they created cool software, that\'s a good thing. If the application is complex enough, that\'s a good thing ... It\'s really focused on practical work, and not just learning for one exam and forgetting everything.”\r\n\r\n“I get them to work as a team, in groups of 4-5 people, rather than taking a teacher/student approach. When I get feedback from students, they tell me they like this practical approach, especially the aspects of collaboration. They learn how to work together.”\r\n\r\n“I appreciate that because it\'s what I wanted to achieve. I don\'t want to treat students as students but as my colleagues. I want to help them be successful with the project and the challenge they have to solve.”\r\n<h3>Consistent web development environments help teachers</h3>\r\nBefore DDEV came along, Oliver tried to find a reliable solution to help students set up a local development environment. When he first tried plain Docker there were known issues with Windows, which meant it wasn’t working well. So he set up VirtualBox for his students to use. It promised a consistent environment. “That\'s something I really wanted to have: that all the plugins packages and software that is installed are the same. For example, this would include the proper PHP version, PHP &amp; web server modules, virtual host configuration, ImageMagick, Node.js, and so forth.”\r\n\r\n“The sad thing is, whenever I made a mistake (and I make a lot of mistakes!) such as forgetting to configure packages, forgetting to figure out if image generation or PDF is working, it was difficult to make improvements and distribute them. I had to distribute a 4GB file on a USB stick.”\r\n\r\nIt seemed like there had to be a better way to do it. “DDEV eases the pain of using Docker,” though the students were struggling with limited hardware resources. Considering that, Oliver said, “It’s easier now to use DDEV, it works well for the TYPO3 environment.”\r\n\r\nThe biggest advantage comes from using containers. “That’s something I really wanted to have,” consistent environments means it’s easier to troubleshoot. “All the software and plugins are the same for everyone. If someone has an error we’re talking about the same environment.”\r\n\r\n“Using DDEV it\'s pretty easy to use a full blown web application. Everything that\'s required is defined in that DDEV container. And I can continue evaluating their projects.” For teachers looking at how to ease the pain of <a href=\"https://www.ddev.com/ddev-live/removing-the-biggest-barrier-to-contribution/\">setting local development environments for newcomers</a>, that is really great to hear.\r\n\r\n“The good thing about using DDEV is that the students can share their projects very easily. They have the .ddev configuration file and they are using PHP Composer where they can define the package states of the extensions. This means, whenever there\'s a problem or they have a question on their application, I can check out that repository, and give them feedback to solve the problem.”\r\n<h3>Using open source - the software and the community</h3>\r\nThe students are getting a taste of what it’s like to work in open source, but it’s still a challenge. “I realized my students were really shy. They would try and solve problems on their own. I had to remind them that there\'s an open source community behind what they are using. There\'s a TYPO3 OSS community. You can ask the community. You can make use of any extensions available.”\r\n\r\nGiving students industry-standard professional tools and exposing them to open source communities is a win-win for employability and skills that will set them up for life.\r\n\r\nWe love to hear stories about how you’re using DDEV. Are you using DDEV for teaching or training? Say hi to us on Twitter and tell us!\r\n\r\n<a class=\"twitter-mention-button\" href=\"https://twitter.com/intent/tweet?screen_name=ddev&amp;ref_src=twsrc%5Etfw\" data-show-count=\"false\">Tweet to @ddev</a><script async src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>\r\n<h3>Try out DDEV for yourself</h3>\r\nWe have quickstart documentation for major CMSs and you can use DDEV to run other types of projects as well.\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"https://ddev.readthedocs.io/en/latest/\">Try DDEV</a>\r\n\r\n<small>Photo by <a href=\"https://unsplash.com/photos/xt9tb6oa42o?utm_source=unsplash&amp;utm_medium=referral&amp;utm_content=creditCopyText\">Jantine Doornbos</a> on <a href=\"https://unsplash.com/?utm_source=unsplash&amp;utm_medium=referral&amp;utm_content=creditCopyText\">Unsplash</a></small>','Using DDEV to Teach Open Source Web Development','','publish','closed','closed','','using-ddev-to-teach-open-source-web-development','','','2019-02-26 19:46:54','2019-02-27 02:46:54','',0,'https://www.ddev.com/?p=2128',0,'post','',0),(2137,11,'2019-03-21 17:46:16','2019-03-21 23:46:16','<!-- wp:paragraph -->\n<p><span style=\"font-weight: 400;\">We introduced <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#opt-in-usage-information\">opt-in instrumentation</a>&nbsp;using <a href=\"http://sentry.io\">Sentry.io</a> in <a href=\"https://github.com/ddev/ddev/releases\">DDEV-Local v1.5.0</a> (December 2018). This feature sends some information about <code>ddev</code> usage so that we can understand our users better and help you do your best work. Now that we\'re a few months in we\'ve learned a number of things, and so appreciate those of you who opted-in to this feature. </span></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><span style=\"font-weight: 400;\">If you want to try it out, please&nbsp;<a href=\"https://ddev.readthedocs.io/en/stable/\">download and set up DDEV</a> with your own project or one of our quickstart guides.</span></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><span style=\"font-weight: 400;\">Of course, we only have information about DDEV-Local users who have opted in, and it\'s a limited amount of data, but it\'s super important to us and we thank you so much for allowing this information to be sent. It will help us enormously in learning how the community uses DDEV-Local and how best to serve you as we move forward developing the beta release of our hosting platform, DDEV-Live.</span></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><span style=\"font-weight: 400;\">Some of the most interesting data so far:</span></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2142} -->\n<figure class=\"wp-block-image\"><img src=\"https://www.ddev.com/content/uploads/2019/03/1-OS-1024x633.png\" alt=\"\" class=\"wp-image-2142\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":2143} -->\n<figure class=\"wp-block-image\"><img src=\"https://www.ddev.com/content/uploads/2019/03/2-php-1024x633.png\" alt=\"\" class=\"wp-image-2143\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":2144} -->\n<figure class=\"wp-block-image\"><img src=\"https://www.ddev.com/content/uploads/2019/03/3-CMS-1024x633.png\" alt=\"\" class=\"wp-image-2144\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":2145} -->\n<figure class=\"wp-block-image\"><img src=\"https://www.ddev.com/content/uploads/2019/03/4-Webserver-1024x633.png\" alt=\"\" class=\"wp-image-2145\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":2146} -->\n<figure class=\"wp-block-image\"><img src=\"https://www.ddev.com/content/uploads/2019/03/5-Windows-1024x633.png\" alt=\"\" class=\"wp-image-2146\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p><span style=\"font-weight: 400;\">If you\'d like to browse the actual numbers, the (rough) spreadsheet data is <a href=\"https://docs.google.com/spreadsheets/d/135MIJBPQifLyssM-CjxGotH3XTrtdCTkcEOb9SQOU6E/edit?usp=sharing\">available here.</a></span></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Again, thanks so much for using DDEV and for your many <a href=\"https://github.com/ddev/ddev/blob/master/CONTRIBUTING.md\">contributions</a> to its success, whether by sending stats, suggesting features, supporting others, or <a href=\"https://ddev.readthedocs.io/en/stable/#support\">reporting issues</a>. Thank you!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Join our newsletter for more news and updates:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->','DDEV-Local Usage Statistics (Updated 2019-03-21)','','publish','closed','closed','','ddev-local-usage-statistics-updated-2019-03-21','','','2020-10-07 11:40:02','2020-10-07 17:40:02','',0,'https://www.ddev.com/?p=2137',0,'post','',0),(2139,11,'2019-03-28 22:34:50','2019-03-29 04:34:50','Much of what we do here on the DDEV team is in support of the modern projects users want to create, whether that means building out our highly flexible, customizable, Kubernetes-based hosting platform or our robust local development environment. Our goal is to support our users in as much of your work as we can, and that also means supporting many older projects.\r\n\r\nAlthough the <a href=\"http://drupal.org\">Drupal</a> project officially discontinued all forms of support for Drupal 6 (D6) in February 2016 (six months after the release of Drupal 8), a couple of vendors signed up to continue support for D6 and they\'ve done an absolutely stupendous job, exceeding everyone\'s expectations. The original idea was that they\'d deal with security fixes only, mostly backporting issues found in current Drupal versions. But they also supported and made public quite a number of key modules.\r\n\r\nAnd then the big deal: PHP 5.6 went End-Of-Life at the end of December, 2018, meaning no more support for *it*. <em>And</em> PHP 5.6 was the highest version of PHP that D6 could run on. Amazingly though, one of the D6LTS maintainers, <a href=\"https://www.mydropwizard.com/drupal-6-lts\">myDropWizard</a>, came out with versions of D6 and many modules that are compatible with PHP 7.2. It\'s a game-changer that nobody expected, and was *not* a part of the original plan.\r\n\r\nHere\'s what I\'ve done to upgrade the Drupal 6 projects that I still maintain:\r\n<ol>\r\n 	<li>Check out the project.</li>\r\n 	<li>Download the latest d6lts/drupal [release] (<a href=\"https://github.com/d6lts/drupal/releases\">https://github.com/d6lts/drupal/releases</a>) or add it to your project with git.</li>\r\n 	<li>Overwrite your D6 core with the downloaded version.</li>\r\n 	<li><code>ddev config --php-version=7.2</code></li>\r\n 	<li><code>mkdir .ddev/php and add file there called mbstring.ini</code> (it can be called anything ending in .ini) with these contents:\r\n<code>mbstring.func_overload=0\r\nmbstring.encoding_translation=0\r\nmbstring.http_input=pass\r\nmbstring.http_output=pass&gt;/code&gt;</code></li>\r\n 	<li><code>ddev start</code></li>\r\n 	<li>Load your database and begin testing.</li>\r\n 	<li>You\'ll likely want to download key modules from <a href=\"https://github.com/d6lts\">https://github.com/d6lts</a> (use the \"Find a repository\" search box. But cck, panels, views are all there. I was able to find everything I needed for my smallish sites.</li>\r\n</ol>\r\nIf you\'re successful with your site (likely!) then you will have a D6 site that\'s supported at least until February 2020 by myDropWizard and the D6lts project, and PHP 7.2 is supported through November, 2020.\r\n\r\n<a href=\"https://github.com/ddev/ddev\">DDEV</a> makes maintaining sites easy, just as in this case. You can have multiple CMSs, multiple PHP versions, and even both Apache and Nginx, all running at the same time on different sites, with basically no configuration. I found updating and testing these D6 sites to be a breeze.\r\n\r\nAnd of course, if I had known that D6 support would last this long and be of such high quality, it would have made a very significant difference in some decisions I made in 2015 and some things would have been much easier. Thanks to those D6LTS vendors for taking on the challenge and sticking with it, and especially to MyDropWizard for taking the challenge to an even higher level.\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"https://ddev.readthedocs.io/en/stable/\">Download DDEV-Local</a>','DDEV-Local, D6LTS, PHP 7.2, and Drupal 6 projects','','publish','closed','closed','','ddev-local-d6lts-php-7-2-and-drupal-6-projects','','','2019-03-28 22:34:50','2019-03-29 04:34:50','',0,'https://www.ddev.com/?p=2139',0,'post','',0),(2153,16,'2019-03-21 18:29:55','2019-03-22 00:29:55','Sign up for a two-hour course to learn how to use our open source local development environment <a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local</a> to streamline your web development workflow in Drupal Easy’s online course.\r\n\r\nApril 17, 2019 (1-3 pm EDT)\r\n\r\n<a href=\"https://www.drupaleasy.com/ddev\">Sign up here!</a>\r\n\r\nFind out <a href=\"https://www.drupaleasy.com/ddev\">what’s included, and the details about the course.</a>','DrupalEasy – Online Course April 2019','Sign up for a two-hour course to learn how to use our open source local development environment DDEV-Local to streamline your web development workflow in Drupal Easy’s online course.','publish','closed','closed','','drupaleasy-online-course-april-2019','','','2020-10-19 19:05:33','2020-10-20 01:05:33','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2153',0,'tribe_events','',0),(2158,11,'2019-04-04 13:33:19','2019-04-04 19:33:19','<!-- wp:paragraph -->\n<p>We\'re quite proud of the automated testing setup we use to develop&nbsp;<a href=\"https://github.com/ddev/ddev\">DDEV-Local</a>. Each pushed commit to the project gets a full set of tests run on macOS, Windows with Docker-for-Windows, Windows with Docker Toolbox, and Linux (Ubuntu).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Originally we tested quite nicely with just <a href=\"https://circleci.com\">CircleCI</a> (on Linux), and that did pretty well at finding issues with macOS. But when we started supporting Windows 10 Pro with Docker-for-Windows, and then Windows 10 Home with Docker Toolbox, we found that we really needed explicit coverage on those machines because there are a *lot* of behavior differences, so we implemented tests for each platform using <a href=\"https://buildkite.com\">Buildkite</a> and test machines that we maintain.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Even though DDEV is written in <a href=\"https://golang.org/\">Go</a>, which is amazingly complete for each platform, things like filesystem case-sensitivity, slashes, and behavior of docker-compose cause plenty of unexpected issues. So we run more than 10 test suites on each push, building and testing the containers on Windows, Linux, and&nbsp; macOS, then a full application test suite on macOS, Windows 10 Pro, Windows 10 Home, and Linux. And also with permutations for Apache support and the NFS mount feature. It\'s a lot of computing power but it\'s paid off enormously. All of this shows up very nicely on the DDEV-Local&nbsp;<a href=\"https://github.com/ddev/ddev/pulls\">pull request</a> and <a href=\"https://github.com/ddev/ddev/commits/master\">commits</a> pages, so it\'s easy to see at a glance what\'s happened with testing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Our test suite is large and has grown over the lifespan of DDEV-Local, up to about 5500 lines of test code (out of the 14,680 lines of code that make up DDEV) that get run on every push.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The biggest problems we have with this whole setup is it seems to push Docker to the limit, especially on Windows. So we see too often the Docker failures and hangs that users see only infrequently. Currently, this means a lot of random maintenance of Docker on the test machines. We recently found a way to make CircleCI\'s macOS support work with Docker and that\'s been a win, but it\'s a bit costly and may not work out in the end.&nbsp;Upcoming features of <a href=\"https://www.appveyor.com/\">Appveyor</a>, for continuous integration on&nbsp;Windows, will allow its use with Linux containers, which should help smooth out our process even further.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Try out DDEV-Local for yourself, and consider contributing to it as an open source project! We have a <a href=\"https://github.com/ddev/ddev/blob/master/CONTRIBUTING.md\">contribution guide for this project</a> as well as a <a href=\"https://github.com/ddev/community\">Community Guide and Code of Conduct</a> for all of our projects.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->','DDEV-Local Automated Testing','','publish','closed','closed','','ddev-local-automated-testing','','','2020-10-07 11:24:35','2020-10-07 17:24:35','',0,'https://www.ddev.com/?p=2158',0,'post','',0),(2181,11,'2019-04-08 15:55:56','2019-04-08 21:55:56','<!-- wp:paragraph -->\n<p>We’ve just released <a href=\"https://github.com/ddev/ddev/releases/tag/v1.7.1\">DDEV v1.7.1</a>! This release includes the ability to override a committed config.yaml, static port binds and longer project names. <a href=\"https://github.com/ddev/ddev/releases\">Install or upgrade now</a>. Here are a couple of highlights:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>config.*.yaml</strong> - If you\'ve been using DDEV on a team across different operating systems you’ve experienced how wonderful it is to be able to ship your project around from Windows to Linux. But, you may have needed to override a committed config.yaml with custom configuration for your local environment. Now we have included config.*.yaml so you can retain your custom settings while <a href=\"https://ddev.readthedocs.io/en/latest/users/extend/customization-extendibility/#extending-configyaml-with-custom-configyaml-files\">working seamlessly on a team</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Optional static bind ports for db and webserver containers</strong> - Those who want the dbserver or webserver bound port to be static within a project can use host_db_port or host_webserver_port to specify it. Thanks to <a href=\"https://github.com/tmotyl\">tmotyl</a> for getting the ball rolling. <a href=\"https://github.com/ddev/ddev/pull/1502\">More details here</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Longer project names should be possible</strong> - Previously, a long server name would cause the ddev-router to stop working. Now you can use a very long name with no trouble. Thank you to <a href=\"https://github.com/janhelke\">janhelke</a> for <a href=\"https://github.com/ddev/ddev/pull/1484\">this PR</a>!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Plus, php 7.2 is the <a href=\"https://github.com/ddev/ddev/pull/1497\">default for new projects</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://github.com/ddev/ddev/releases/tag/v1.7.1\">Read the full release notes here.</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>To Download:</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>macOS and Linux Homebrew: <code>brew upgrade ddev</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Linux or macOS via script:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><code>curl https://raw.githubusercontent.com/ddev/ddev/master/scripts/install_ddev.sh | bash</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Windows: Download the ddev_windows_installer.v1.7.1.exe above or with Chocolatey <code>choco install ddev</code> or <code>choco upgrade ddev</code> (or <code>choco install ddev --version=1.7.1</code> while it\'s in the approval process.)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>And anywhere, you can just download the tarball or zipball, untar or unzip it, and place the executable in your path where it belongs.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>NOTE: Especially to mariadb 10.1 users: If you had to explicitly set the dbcontainer version in your .ddev/config.yaml due to the bug in v1.6.0, please remove that now.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>[<a href=\"https://github.com/ddev/ddev/releases/tag/v1.7.1\">DDEV v1.7.1 Release</a>]</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>DDEV Events</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We are <a href=\"https://www.ddev.com/events/meet-up-with-the-ddev-team-in-early-2019/#DCSeattle\">currently at DrupalCon Seattle</a> and we can’t wait to show you what we’ve been up to with our hosting platform! Sign up for the DDEV newsletter below to receive a free copy of <a href=\"https://www.amazon.com/Local-Development-Explained-Step-Step/dp/1731048858/ref=tmm_pap_swatch_0\">Mike Anello’s DDEV ebook</a> and a DDEV t-shirt from our booth in exhibit hall. Follow along during the event on <a href=\"https://twitter.com/ddev\">Twitter</a> with #DDEV.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The next session of Mike Anello’s online DrupalEasy course, <a href=\"https://www.drupaleasy.com/ddev\">Professional Local Development with DDEV</a>, is Wednesday, April 17th. Sign up now to beat the rush!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Contribute back to DDEV-Local</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Thank you very much to <a href=\"https://github.com/akalata\">akalata</a> on github for testing this release! Many of you also filed issues and helped point out important improvements.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://github.com/ddev/ddev/blob/master/CONTRIBUTING.md\">DDEV is an open source project</a> and we very much appreciate the time our contributors give to improving the tool for everyone. Please continue to submit issues for new features and bugs, and take a look around <a href=\"https://github.com/ddev/ddev/issues\">the DDEV issue queue</a> and <a href=\"https://stackoverflow.com/questions/tagged/ddev\">Stack Overflow</a> to spur your thinking!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->\n\n<!-- wp:paragraph -->\n<p><small>Photo courtesy <a href=\"https://www.ddev.com/author/elli/\">Elli Ludwigson</a></small></p>\n<!-- /wp:paragraph -->','DDEV v1.7.1: config.*.yaml, static bind ports, longer project names','','publish','closed','closed','','ddev-v1-7-1-config-yaml-static-bind-ports-longer-project-names','','','2020-10-07 11:38:58','2020-10-07 17:38:58','',0,'https://www.ddev.com/?p=2181',0,'post','',0),(2192,16,'2019-04-16 14:15:32','2019-04-16 20:15:32','Sign up for a two-hour course to learn how to use our open source local development environment <a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local</a> to streamline your web development workflow in Drupal Easy’s online course.\r\n\r\nMay 8, 2019 (1-3 pm EDT)\r\n\r\n<a href=\"https://www.drupaleasy.com/ddev\">Sign up here!</a>\r\n\r\nFind out <a href=\"https://www.drupaleasy.com/ddev\">what’s included, and the details about the course.</a>','DrupalEasy – Online Course May 2019','Sign up for a two-hour course to learn how to use our open source local development environment DDEV-Local to streamline your web development workflow in Drupal Easy’s online course.','publish','closed','closed','','drupaleasy-online-course-may-2019','','','2020-10-19 19:07:41','2020-10-20 01:07:41','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2192',0,'tribe_events','',0),(2194,16,'2019-04-16 14:16:45','2019-04-16 20:16:45','Sign up for a two-hour course to learn how to use our open source local development environment <a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local</a> to streamline your web development workflow in Drupal Easy’s online course.\r\n\r\nJune 12, 2019 (1-3 pm EDT)\r\n\r\n<a href=\"https://www.drupaleasy.com/ddev\">Sign up here!</a>\r\n\r\nFind out <a href=\"https://www.drupaleasy.com/ddev\">what’s included, and the details about the course.</a>','DrupalEasy – Online Course June 2019','Sign up for a two-hour course to learn how to use our open source local development environment DDEV-Local to streamline your web development workflow in Drupal Easy’s online course.','publish','closed','closed','','drupaleasy-online-course-june-2019','','','2020-10-19 19:07:22','2020-10-20 01:07:22','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2194',0,'tribe_events','',0),(2197,2,'2019-04-22 20:00:15','2019-04-23 02:00:15','Our time at <a href=\"https://events.drupal.org/seattle2019\">DrupalCon Seattle</a> strongly reinforced the core principles and values we’ve been building our tools on. We’re always excited to share updates and benefits of our DDEV local development environment and hosting platform, but even better is hearing what <em>you’ve</em> been working on and where your interests lie. The most valuable experiences at DrupalCon were all about working together and supporting success for as many people as we can.\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">Join the DDEV Newsletter</a>\r\n<h3>Thank you, DrupalCon Seattle!</h3>\r\nWith only two days of time on the exhibit hall floor we were bustling at the booth! Thank you to everyone who stopped by to explore and chat about your experiences with DDEV. We gave away all our t-shirts and flash-drives loaded with DDEV Quicksprint toolkits, and we doubled our contact list ?\r\n\r\nPlus, if you snagged a golden ticket at the booth or found it printed in your program, you can now redeem it to get on the early access list for our Kubernetes-based hosting platform, <a href=\"http://ddev.com/ddev-live\">DDEV-Live</a>. We’ll be rolling out access to small groups of users this year and are super eager to hear what you think. Redeem here: <a href=\"http://ddev.com/early-access\">ddev.com/early-access</a>\r\n\r\nKevin, our CTO, gave a very brief talk on how having a clearly defined plan that the entire team bought into allowed us to adapt and adjust our hosting platform to take full advantage of Kubernetes.\r\n\r\nhttps://twitter.com/ddev/status/1116073579504783360\r\n\r\nOn Thursday at DrupalCon we also gathered up a few folks who share our interest in working with <a href=\"https://coreos.com/operators/\">Kubernetes operators</a> and controllers to solve common hosting challenges as we continue building DDEV-Live hosting. As a result of this BoF there is now an active <a href=\"https://drupal.slack.com/messages/CHTP7ELE9\">#kubernetes channel </a>in <a href=\"http://www.drupal.org/community/contributor-guide/reference-information/talk/tools/slack\">Drupal Slack</a> and plans for a regular special interest group (SIG) meeting. If this sounds like something you’d like to participate in, please check in that channel for news, updates, and meeting times and/or <a href=\"http://twitter.com/ddev\">follow us on Twitter</a>.\r\n\r\nSpeaking of cross-community collaboration, it was our pleasure to spend time with <a href=\"https://twitter.com/bennimack/status/1117085918823890944\">Benni Mack</a>, technical lead of <a href=\"https://typo3.org/\">TYPO3 CMS</a>, while he was at DrupalCon! We talked about common pain points, how each of <a href=\"https://events.drupal.org/seattle2019/sessions/hello-neighboring-island-typo3-cms-postcard-edition\">our open source communities manages contribution</a>, and how we can help each other in the future. Hoping to see more of the TYPO3 community at events later this year!\r\n\r\nThe best day of a week at DrupalCon is always contribution day, when new contributors can join the Drupal community with the support of an amazing team of mentors. Thank you especially to the mentors who ran the first time contributors workshop to orient new contributors and help install the local development toolset for those who needed it. If you’d like to get started contributing, just head for <a href=\"https://github.com/ddev/quicksprint\">github.com/ddev/quicksprint</a> to try it yourself.\r\n<h3>Product updates</h3>\r\n<img class=\"alignnone size-large wp-image-2200\" src=\"https://www.ddev.com/content/uploads/2019/04/Screen-Shot-2019-04-18-at-9.28.15-AM-1024x572.png\" alt=\"Organizations that contribute to Drupal, Drud is highlighted for sponsoring contribution tools\" width=\"1024\" height=\"572\" />\r\n\r\nAs Dries mentioned in <a href=\"https://dri.es/state-of-drupal-presentation-april-2019\">his keynote</a> at DrupalCon, we’ve sponsored and supported the <a href=\"https://github.com/ddev/quicksprint\">Quicksprint package</a> as a tool for new contributors to the Drupal project. <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a> has also been <a href=\"https://www.drupal.org/docs/official_docs/en/_local_development_guide.html\">added to the Drupal 8 Official Docs</a> to help users get started installing Drupal on their local machine. It’s been a pleasure to work with other members of the Drupal community to clarify how DDEV can help. Please drop by the <a href=\"https://drupal.slack.com/messages/C5TQRQZRR\">#ddev channel</a> in <a href=\"http://www.drupal.org/community/contributor-guide/reference-information/talk/tools/slack\">Drupal Slack</a> if you have questions.\r\n\r\nDevelopment of our <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live hosting platform</a> is rapidly gaining velocity thanks to our team’s hard work on the API and some exciting conversations about Kubernetes coming out of DrupalCon. We’ve also been focusing on a migration to Google Cloud services and are pleased to see all these pieces coming together into the installable platform we envisioned. We’ll be sharing hosting updates with everyone regularly over the coming months and sharing access with early adopters as services become available.\r\n\r\nKeep an eye out <a href=\"https://www.ddev.com/blog/\">here</a> on the blog and on <a href=\"https://twitter.com/ddev\">Twitter</a> for a series of posts called “CTO’s Corner” in which we’ll dig into the architecture, open source theory, and benefits of DDEV-Live as the platform starts rolling out. <a href=\"http://eepurl.com/dlqkUD\">Sign up for our newsletter</a> to make sure you get all the updates.\r\n<h3>DDEV ebook &amp; training</h3>\r\nCurious how you can get the most out of DDEV-Local for your projects? Our friend <a href=\"http://twitter.com/ultimike\">Mike Anello</a> runs <a href=\"https://www.drupaleasy.com/ddev\">regular training sessions online</a> and has written an <a href=\"https://www.amazon.com/Local-Development-Explained-Step-Step/dp/1731048858/ref=tmm_pap_swatch_0\">ebook on DDEV</a> for your reference. To receive a complimentary copy of the ebook or a special deal for the course please <a href=\"mailto:accounts@ddev.com\">drop us an email</a>. The next classes are May 8 and June 12.\r\n<h3>Next up:</h3>\r\nKevin will be speaking on <a href=\"https://boulderstartupweek2019.sched.com/event/NNY7/so-you-want-to-launch-a-devtool\">a panel on DevTools at Boulder Startup Week</a> on May 13th! If you’re in the area or already attending the event be sure to stop by, it’s an honor to be included on this panel. For more on our developments and upcoming events, please join us:\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">DDEV Newsletter Sign-up</a>','DrupalCon Seattle Wrap-up','','publish','closed','closed','','drupalcon-seattle-wrap-up','','','2019-04-20 15:54:40','2019-04-20 21:54:40','',0,'https://www.ddev.com/?p=2197',0,'post','',0),(2207,11,'2019-05-23 15:58:46','2019-05-23 21:58:46','Security is critical on the modern web, and so all sites should ideally be developed, tested, and deployed with https. But it has been hard to do that in your local development environment.\r\n\r\nWith <a href=\"http://github.com/ddev/ddev\">DDEV-Local</a> you can use the https version of your project in a browser that trusts your project and you don\'t have to click through the nasty security warning this had triggered previously.\r\n\r\nHTTPS with DDEV-Local now works...\r\n<ul>\r\n 	<li>On macOS, Windows, and Linux</li>\r\n 	<li>On Firefox, Chrome, Chromium, Safari</li>\r\n 	<li>With curl on the host (macOS and Linux, not Windows)</li>\r\n 	<li>With curl inside the web container</li>\r\n</ul>\r\nThere is a tiny bit of one-time setup to get your OS and browser to trust the root certificate authority that DDEV-Local uses. The 3-minute screencast below shows how installation and setup works on all 3 platforms.\r\n\r\n<strong>macOS</strong>: After installing DDEV-Local v1.8.0 and running <code>ddev stop --all</code>, run <code>mkcert -install</code> and provide your password at the sudo prompt.\r\n\r\n<strong>Linux</strong>: After installing DDEV-Local v1.8.0 and <code>ddev stop --all</code>, run <code>mkcert -install</code> and follow the instructions given. You\'ll likely have to install the libnss3-tools package (Debian/Ubuntu <code>apt-get install -y libnss3-tools</code>). Add /usr/sbin to your path, and <code>mkcert -install</code> again.\r\n\r\n<strong>Windows</strong>: After installing DDEV-Local v1.8.0 and <code>ddev stop --all</code>, run <code>mkcert -install</code> and accept the dialog that pops up.\r\n\r\nThis entire feature is made possible by the outstanding <a href=\"https://github.com/FiloSottile/mkcert\">mkcert</a> project, another major triumph of open-source and open-source collaboration. Thanks to <a href=\"https://github.com/FiloSottile\">@FiloSottile</a> for an outstanding project.\r\n\r\nThe <a href=\"https://ddev.readthedocs.io/en/stable/#installation\">DDEV-Local Installation Documentation</a> has full details about mkcert operation.\r\n\r\n[embed]https://youtu.be/T7M2c8Y9IiA[/embed]','DDEV-Local Trusted HTTPS Certificates','','publish','closed','closed','','ddev-local-trusted-https-certificates','','','2020-02-05 11:57:21','2020-02-05 18:57:21','',0,'https://www.ddev.com/?p=2207',0,'post','',0),(2209,11,'2019-06-03 07:26:27','2019-06-03 13:26:27','There\'s never any end to the number of things you might need to do with the web container to make it \"just right\" for your project. In <a href=\"https://github.com/ddev/ddev/releases/tag/v1.8.0\">DDEV-Local v1.8.0</a> you can do that much more easily than in the past. Here are a couple of examples of how you might make these modifications, and a screencast with a walkthrough:\r\n\r\n<strong>Simple: Add webimage_extra_packages to config.yaml</strong>\r\n\r\nIf you need extra packages, just find out what they are (for Debian) and add them to your .ddev/config.yaml, like\r\n\r\n<code>webimage_extra_packages: [php-yaml]</code>\r\n\r\n(or use <code>ddev config --webimage-extra-packages=php-yaml</code>)\r\n\r\n<strong>Fancy and Unlimited: Build your own .ddev/web-build/Dockerfile</strong>\r\n\r\nFor people with a need for more complex changes, copy the .ddev/web-build/Dockerfile.example to .ddev/web-build/Dockerfile and hack at it. Note that a Dockerfile overrides any <code>webimage_extra_packages</code> you may have added, as you\'d want to take on all customization yourself. <code>ddev start</code> will remind you of this if you have both.\r\n\r\nThanks for your support for DDEV-Local, and we look forward to hearing what you do with these new capabilities. Please post your recipes on <a href=\"https://stackoverflow.com/tags/ddev\">Stack Overflow</a> tagged with \"ddev.\" Use the \"question and answer\" format where you answer your own question. Have fun!\r\n\r\n[embed]https://youtu.be/XD3KWlYCiCo[/embed]','DDEV-Local Web Container Customization in v1.8.0','','publish','closed','closed','','ddev-local-web-container-customization-in-v1-8-0','','','2019-05-30 15:37:05','2019-05-30 21:37:05','',0,'https://www.ddev.com/?p=2209',0,'post','',0),(2215,11,'2019-05-16 14:18:51','2019-05-16 20:18:51','We’ve just released <a href=\"https://github.com/ddev/ddev/releases/tag/v1.8.0\">DDEV-Local v1.8.0</a>! This release includes trusted SSL, refreshed <code>ddev stop</code> behavior, and updated <code>ddev exec</code> functionality. <a href=\"https://github.com/ddev/ddev/releases\">Install or upgrade now</a>. Below are a couple of highlights, or you can read the <a href=\"https://github.com/ddev/ddev/releases/tag/v1.8.0\">full release notes here</a>.\r\n<ul>\r\n 	<li><strong>Browsers and host OSs now trust ddev sites over https</strong>: After a one-time action to run <code>mkcert -install</code>, you can visit the https link to your project without needing to click past the security warning. <a href=\"https://ddev.readthedocs.io/en/latest/#linux-mkcert-install-additional-instructions\">Extra details for Linux users here</a>. <a href=\"https://ddev.readthedocs.io/en/latest/#installation\">More info in the install instructions here</a>.</li>\r\n 	<li><strong>Dynamic container updates</strong>: If you need extra Debian packages in your web or db container (or need to make more sophisticated adjustments) you no longer have to wait for them, or install them every time you start a project. You can add <a href=\"https://ddev.readthedocs.io/en/latest/users/extend/customizing-images/#adding-extra-debian-packages-with-webimage_extra_packages-and-dbimage_extra_packages\">webimage_extra_packages</a> to your config.yaml or <a href=\"https://ddev.readthedocs.io/en/latest/users/extend/customizing-images/#adding-extra-dockerfiles-for-webimage-and-dbimage\">build a free-form Dockerfile</a> (Dockerfile.example is provided in your .ddev folder).</li>\r\n 	<li><strong>Updates to <code>ddev stop</code></strong>: <code>ddev stop</code> now does what <code>ddev remove</code> used to do. It removes the containers and saves resources on your host. <code>ddev remove</code> is still available as an alias of <code>ddev stop</code>. New! <code>ddev pause</code> takes the place of the former <code>ddev stop</code> using \"docker stop\" on the project containers. Because of the way ddev works (storing everything outside the container) it\'s cleaner to get rid of a container and recreate it when starting a project.</li>\r\n 	<li><strong>ddev exec and exec hooks now interpret commands using bash</strong>: This means you can have a hook like <code>sudo apt-get update &amp;&amp; sudo apt-get install -y [some-package]</code> without putting <code>bash -c</code> in front of it. And you can <code>ddev exec sudo apt-get update &amp;&amp; sudo apt-get upgrade -y [some-package]</code> as well, no <code>bash -c</code> required.</li>\r\n 	<li><strong>ddev exec can now work with interactive situations</strong>: So for example, you can run  <code>ddev exec mysql</code> and interact with the mysql program directly.</li>\r\n</ul>\r\n<h2>Important notes:</h2>\r\n<ul>\r\n 	<li>The base nginx configuration has changed. If you are overriding configuration with an nginx-site.conf file, you\'ll want to re-do it (much easier now!). In addition, small pieces of nginx configuration can now be added in the .ddev/nginx directory. See the <a href=\"https://ddev.readthedocs.io/en/latest/users/extend/customization-extendibility/#providing-custom-nginx-configuration\">docs</a> for more information.</li>\r\n 	<li>config.yaml exec hooks are now executed with bash context by default. If you have exec hooks that have <code>bash -c</code> in them, please remove that, as they can\'t be interpreted correctly by the new execution mechanism. If using custom nginx configuration update your nginx config as well.</li>\r\n 	<li>If you or your team used to use <code>ddev stop</code> instead of <code>ddev remove</code>, the new behavior of \"stop\" may seem different, but it hopefully won\'t affect most people. However, if you have an add-on docker-compose.*.yaml service that has volatile storage, you may want to change it to save its database on a volume, as <code>ddev stop</code> now completely brings down the containers, and if they had volatile content, it will be gone.</li>\r\n 	<li>If you use drush in exec hooks, and the action you take requires confirmation, please change the exec hook to use <code>drush --yes</code>. Formerly, --yes was implied by exec hooks and <code>ddev exec</code>, but it isn\'t any more.</li>\r\n</ul>\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"https://github.com/ddev/ddev/releases/tag/v1.8.0\">Read the full release notes &amp; installation info</a>\r\n<h2>Contributing to DDEV-Local</h2>\r\nThank you very much to all the DDEV community members who helped out with this release!\r\n<ul>\r\n 	<li><a href=\"https://github.com/damienmckenna\">@damienmckenna</a>, <a href=\"https://github.com/wizonesolutions\">@wizonesolutions</a>, and <a href=\"https://github.com/mglaman\">@mglaman</a> among others worked to significantly improve the <a href=\"https://ddev.readthedocs.io/en/latest/users/extend/additional-services/#apache-solr\">Apache Solr docs</a> and example docker-compose.solr.yaml, and added a docker volume so the solr database would be nonvolatile after ddev stop.</li>\r\n 	<li><a href=\"https://github.com/AronNovak\">@AronNovak</a> created the PR to have the ddev-webserver nginx configuration not intercept 40x errors.</li>\r\n 	<li><a href=\"https://github.com/yanniboi\">@yanniboi</a> and <a href=\"https://github.com/isholgueras\">@isholgueras</a> were kind enough to catch and PR docs errors.</li>\r\n 	<li><a href=\"https://github.com/dacostafilipe\">@dacostafilipe</a> introduced a PR adding pgsql libraries</li>\r\n 	<li>@jonaseverle and <a href=\"https://github.com/hebbet\">@hebbet</a> helped test the release</li>\r\n 	<li>And the amazing <a href=\"https://github.com/FiloSottile/mkcert\">mkcert</a> from <a href=\"https://github.com/FiloSottile\">@FiloSottile</a> made the seemingly impossible task of trusted local development certificates possible.</li>\r\n</ul>\r\n<a href=\"https://github.com/ddev/ddev/blob/master/CONTRIBUTING.md\">DDEV is an open source project</a> and we very much appreciate the time our contributors give creating issues, surfacing bugs, requesting features, supporting other users in <a href=\"https://ddev.readthedocs.io/en/stable/#support\">Slack</a> and <a href=\"https://twitter.com/hashtag/ddev\">Twitter</a> and for your support of DDEV!\r\n<h2>DDEV-Live Hosting Updates</h2>\r\nWe recently gathered our hosting team for a week of time together pushing ahead on development. Not only did we progress on existing tasks and clarify the roadmap for everyone, but we had time to really connect and make decisions in face-to-face conversations. Being able to have those discussions in person meant that we could review options, considerations, and come to an agreement three to five times faster than when working remotely.\r\n\r\nSome technical highlights we had a lot of movement on were global user management, the details of how the UI, CLI and platform interact, building Kubernetes controllers for various functions, and planning ahead so that we can stay in sync and balanced while continuing to work remotely.\r\n\r\nWe’ve also been doing more work as pairs to encourage frequent conversation, questioning, and combining our individual knowledge and ideas earlier in the process. It’s the varied backgrounds and perspectives of everyone on the DDEV team that really create strength when combined, so we’re eager to give everyone’s ideas a chance to surface naturally and frequently. We’re very grateful that it was possible for us to bring everyone together and look forward to the next group gathering!\r\n\r\n<img class=\"size-medium wp-image-2216 alignleft\" src=\"https://www.ddev.com/content/uploads/2019/05/IMG_0160-300x245.jpg\" alt=\"Boulder Startup Week DevTools panel\" width=\"300\" height=\"245\" />\r\n<h2>DDEV Events</h2>\r\nThis week we visited <a href=\"https://boulderstartupweek2019.sched.com/event/NNY7/so-you-want-to-launch-a-devtool\">Boulder Startup Week and talked about DevTools</a>! Our CTO Kevin Bridges (center in the above photo) spoke on a sold-out panel with other builders and leaders about the ins and outs of building, managing, and implementing a dev tool. Thank you very much to the other panelists and organizers, it was a great conversation!\r\n\r\nOur friend Mike Anello’s DDEV book was recently featured on a “<a href=\"https://bookauthority.org/books/new-php-books\">Top 11 PHP books of 2019</a>” list! The next session of Mike’s online DrupalEasy course, <a href=\"https://www.drupaleasy.com/ddev\">Professional Local Development with DDEV</a>, is Wednesday, June 12th.\r\n\r\nTo receive all our most recent news and developments straight to your inbox, please join our newsletter:\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">DDEV Newsletter Sign-up</a>\r\n\r\n<small>Photo courtesy <a href=\"https://www.ddev.com/author/elli/\">Elli Ludwigson</a></small>','DDEV-Local v1.8.0: Trusted SSL, `stop` commands, plus a hosting team hackathon','','publish','closed','closed','','ddev-local-v1-8-0-trusted-ssl-stop-commands-plus-a-hosting-team-hackathon','','','2019-05-16 14:32:20','2019-05-16 20:32:20','',0,'https://www.ddev.com/?p=2215',0,'post','',0),(2235,16,'2019-05-30 16:04:13','2019-05-30 22:04:13','Last week in Barcelona the <a href=\"https://kubernetes.io/\">Kubernetes</a> and <a href=\"https://www.cncf.io/\">Cloud Native</a> communities gathered for <a href=\"https://events.linuxfoundation.org/events/kubecon-cloudnativecon-europe-2019/\">KubeCon</a> to learn from each other and collaborate on open source projects. We’ve been working hard to use the native features of Kubernetes to build our hosting platform, <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a>, and we’re invested in contributing back to Kubernetes itself to strengthen and extend functionality for everyone. I asked our DDEV team members who attended for some highlights and a little background to introduce themselves. Meet Jason, Nic, and Jan!\r\n<h3>Jason:</h3>\r\n<strong>Could you tell us a little about yourself and your approach to your work?</strong>\r\n\r\nI’m a native Texan, frequent traveler, based in San Antonio. I’m passionate about bringing cloud native practices like observability, self healing and repeatability to the enterprise world. My philosophy is that if you can write down the process of operating a software system on paper in plain english, you can describe it in code!\r\n\r\n<strong>What’s your role with DDEV and how to does Kubernetes figure into that?</strong>\r\n\r\nI joined the DDEV team in January 2018 as a Cloud Architect for DDEV-Live. My initial focus was to implement a process for managing Kubernetes clusters in AWS, along with a full monitoring stack, networking and storage add-ons.\r\n\r\nI later became more involved in the software development side of DDEV-Live, and eventually took on the role of engineering lead. Since then, I realized that our existing implementation of the platform had gotten us far, but we wanted to add several fundamental architectural features to meet the needs of our community.\r\n\r\nKubernetes at its core is not really just about container orchestration, but a set of design principles. A declarative API, which uses abstract vocabulary to describe computing concepts, combined with an event driven, eventually consistent controller pattern is why Kubernetes won the container orchestrator war. DDEV-Live is a platform which does not focus on hacking together older tools in an effort to force them to work in a cloud native environment, but rather implementing Kube-native APIs to describe the process of operating PHP Sites. As Kubernetes matures, we are able to learn and develop DDEV-Live along with it, so that now we are effectively extending Kubernetes.\r\n\r\n<strong>What is your history with Kubernetes and KubeCon?</strong>\r\n\r\nThis is my third KubeCon and my first time to attend it in Europe. I got introduced to Kubernetes for the first time at <a href=\"https://conferences.oreilly.com/oscon/open-source-2015/public/schedule/detail/45281\">OSCON back in 2015 at the 1.0 launch in Portland</a>. I could already see its potential as the revolution we had needed in managing cloud technology. I have been using Kubernetes now for over 2 years to orchestrate containers in production.\r\n\r\nOver the last 6 months, my focus has shifted more from using Kubernetes to extending Kubernetes. Some of my contributions so far have been to Kube Ecosystem projects such as <a href=\"https://prometheus.io/docs/alerting/alertmanager/\">AlertManager</a> and <a href=\"https://kubernetes.github.io/ingress-nginx/\">NGINX Ingress Controller</a>. I am looking to get further involved with the Kubernetes SIGs, which are special interest groups who focus on certain topic areas of the platform such as Instrumentation and MultiCluster.\r\n\r\nWe’ve also had a lot of interest for the new <a href=\"https://github.com/ddev/sig-drupal\">Drupal/Kubernetes SIG</a>, where we’re starting to collaborate on creating reusable patterns that will support everyone working with Kubernetes in the Drupal community. It’s been interesting to hear how others are approaching similar problems to what we’ve seen and to combine our efforts to help builders get started more quickly in the future.\r\n\r\n<strong>What sessions at KubeCon really struck your interest?<img class=\"alignright wp-image-2237\" src=\"https://www.ddev.com/content/uploads/2019/05/KubeCon-Nic-Jason-1024x768.jpg\" alt=\"Nic and Jason at KubeCon\" width=\"467\" height=\"350\" /></strong>\r\n\r\nMo Khan gave a really good deep dive session into the <a href=\"https://www.youtube.com/watch?v=-2xcNjKLU9E&amp;list=PLj6h78yzYM2PpmMAnvpvsnR4c27wJePh3&amp;index=249&amp;t=0s\">inner workings of the Kube-API</a>, focusing on how authentication and authorization works, and how it could be extended. This is an area I have already been developing in and I am grateful to have gotten the chance to talk to Mo and other contributors about this rather obscure area of Kubernetes.\r\n\r\nJason DeTiberus and Hardik Dodiya gave a great presentation over the architecture and goals of the <a href=\"https://www.youtube.com/watch?v=Mtg8jygK3Hs&amp;list=PLj6h78yzYM2PpmMAnvpvsnR4c27wJePh3&amp;index=291&amp;t=0s\">Cluster and Machine APIs</a>. These APIs are key to being able to use a Kube control plane to manage Kubernetes clusters. Kubernetes to manage Kubernetes? Pretty cool right? The development of APIs like this further a prediction that I share with others that the control plane pattern of Kubernetes will live on long after containers are replaced by something else.\r\n\r\n<strong>What else about the event would you like to highlight?</strong>\r\n\r\nThis KubeCon was really unique for me in that it reinforced how diverse and powerful the cloud native community really is, and that this is a global effort. There were far more tracks that were oriented towards contributors looking to extend Kubernetes, rather than it overly being an avenue for vendors to showcase their Kubernetes products, talk about service meshes or running stateful sets.\r\n\r\nI was able to connect directly with several Kubernetes SIGs that I am planning to be more involved with, <a href=\"https://github.com/kubernetes/community/tree/master/sig-api-machinery\">api-machinery</a> and <a href=\"https://github.com/kubernetes/community/tree/master/sig-cluster-lifecycle\">cluster lifecycle</a> in particular. The maintainers in these SIGs are always looking for help, so I have several issues in the apiserver-builder and controller-runtime that I plan to work on and offer pull requests for this summer.\r\n<h3>Nic:</h3>\r\n<strong>Please tell us a bit about yourself.</strong>\r\n\r\nHi, my name is Nic and I originally joined the DDEV team as an intern while I finished the last semester of my B.S. in Computer Science at the University of Texas at San Antonio (I actually graduated the day before heading to KubeCon!). I aspire to grow into a Site Reliability Engineer (SRE) and/or Platform Architect in the Cloud/Kubernetes space. I’m always hungry for knowledge, and my coworkers can definitely confirm that I ask a massive amount of questions on a regular basis.\r\n\r\n<strong>What’s your role with DDEV and how does Kubernetes figure into that?</strong>\r\n\r\nI am currently a Software Developer, having joined DDEV in December 2018. I work with my fellow hosting team engineers to build the next iteration of our Kubernetes-native hosting platform: DDEV-Live. Kubernetes and its ecosystem is where I do my day-to-day work, and have had the opportunity to be exposed to, learn, and develop in a wide slew of different areas within this ecosystem. These areas include platform API and Operator development, monitoring, logging, CI/CD, and testing.\r\n\r\n<strong>What is your history with  Kubernetes and KubeCon?</strong>\r\n\r\nThis is my second Kubecon. I previously went to Kubecon Austin in December 2017 where I got my first true exposure to Kubernetes and the cloud-native community. Since then, I can’t begin to describe how much I’ve learned about Kubernetes. My latest big project outside of my work on DDEV-Live was an automated Kubernetes microservice testing project I had to develop as a research assistant for a Ph.D research project during my last semester of college. During this time I was also working with DDEV full time, and was able to directly apply what I learned at work to this research-oriented work.\r\n\r\n<strong><img class=\"alignleft wp-image-2238\" src=\"https://www.ddev.com/content/uploads/2019/05/KubeCon-Nic-768x1024.jpg\" alt=\"Nic at KubeCon\" width=\"383\" height=\"510\" /></strong>\r\n\r\n<strong>What sessions at KubeCon really struck your interest?</strong>\r\n\r\n<a href=\"https://www.youtube.com/watch?v=G8swjziYjY8&amp;list=PLj6h78yzYM2PpmMAnvpvsnR4c27wJePh3&amp;index=117&amp;t=0s\">Scavenging for Reusable Code in the Kubernetes Codebase - Kevin Lingerfelt</a>\r\n\r\nIt was insightful to get a practical example of something that I have been doing since day one with DDEV, so learning a few tips and tricks throughout this talk only improved my ability to find and implement new and exciting ideas and concepts.\r\n\r\n<a style=\"background-color: #ffffff; font-size: 1rem;\" href=\"https://www.youtube.com/watch?v=n6VPBUIkgqo&amp;list=PLj6h78yzYM2PpmMAnvpvsnR4c27wJePh3&amp;index=296&amp;t=0s\">How to Create Kubernetes Experts - Clarke Vennerbeck &amp; Aaron Teague</a>\r\n\r\nAs a newcomer to the professional world of I.T. and I.S. this talk relayed to me a few key points that I should keep in the back of my mind during my journey along this road.\r\n\r\n<strong>What else about the event would you like to highlight?</strong>\r\n\r\nIt was honestly surprising to see the amount of progress in the Kubernetes ecosystem compared to the last Kubecon I attended in December 2017. It seems now that the shift in industry use of Kubernetes has gone from working within the pre-defined boundaries of core Kubernetes to now creating custom extensions of Kubernetes concepts like custom API servers, and custom resource definitions (CRDs), along with the controllers and operators that are used to define and execute the logic for these custom resources.\r\n\r\nWe on the DDEV team have already started this journey as we built this iteration of DDEV-Live, so to be able to expand my existing knowledge through going to these talks was an invaluable experience. To add to this, talking to vendors in the vendor hall also gave me advantageous insight into the present state of the Kubernetes and Cloud Native business landscape.\r\n<h3>Jan:</h3>\r\n<strong>Please tell us a bit about yourself and your role with DDEV.</strong>\r\n\r\nI am yet another engineer trying to automate repetitive and mundane operations tasks, breaking as few things as possible along the way. I’m a Site Reliability Engineer, and so I spend my time writing, deploying and breaking Kubernetes operators.\r\n\r\n<strong>What is your history with Kubernetes or KubeCon?</strong>\r\n\r\nI have contributed to both <a href=\"https://github.com/wozniakjan\">Kubernetes and OpenShift</a>.\r\n\r\n<strong>What sessions at KubeCon really struck your interest?</strong>\r\n\r\n<a href=\"https://www.youtube.com/watch?v=zCXiXKMqnuE&amp;list=PLj6h78yzYM2PpmMAnvpvsnR4c27wJePh3&amp;index=96&amp;t=0s\">The Kubernetes Control Plane for Busy People Who Like Pictures - Daniel Smith</a>\r\n\r\nInspiring insight into how people at Google design their Kubernetes controllers and operators, and how they split really complicated problems into simpler sub-problems.\r\n\r\n<a href=\"https://www.youtube.com/watch?v=6sDTB4eV4F8&amp;list=PLj6h78yzYM2PpmMAnvpvsnR4c27wJePh3&amp;index=31&amp;t=0s\">Kubernetes Failure Stories and How to Crash Your Clusters - Henning Jacobs</a>\r\n\r\nFailure stories and most importantly how to recover and plan for preventing those are always very valuable. It’s also pleasant to hear and reassuring that other people break things too.\r\n\r\n<strong>Any final Kubernetes thoughts?</strong>\r\n\r\nKubernetes growth is unprecedented. This software really helps with sore spots probably every modern company has been dealing with. It’s been remarkable being along for this ride!\r\n<h3>Thank you KubeCon!</h3>\r\nOpen source engagement in the communities around the software we use is central to our mission with DDEV. KubeCon was a really good opportunity to hear from others and have conversations about how we can work together to continue extending Kubernetes and the projects we build with it. Thank you to the presenters, organizers, and folks we got a chance to connect with!\r\n\r\nFor more on our developments and upcoming events, please sign up for our newsletter:\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">DDEV Newsletter Sign-up</a>','KubeCon Barcelona Wrap-up','','publish','closed','closed','','kubecon-barcelona-wrap-up','','','2019-05-30 17:10:12','2019-05-30 23:10:12','',0,'https://www.ddev.com/?p=2235',0,'post','',0),(2257,16,'2019-07-02 13:06:25','2019-07-02 19:06:25','Sign up for a two-hour course to learn how to use our open source local development environment <a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local</a> to streamline your web development workflow in Drupal Easy’s online course.\r\n\r\nJuly 16, 2019 (10am-12pm EDT)\r\n\r\n<a href=\"https://www.drupaleasy.com/ddev\">Sign up here!</a>\r\n\r\nFind out <a href=\"https://www.drupaleasy.com/ddev\">what’s included, and the details about the course.</a>','DrupalEasy – Online Course July 2019','Sign up for a two-hour course to learn how to use our open source local development environment DDEV-Local to streamline your web development workflow in Drupal Easy’s online course.','publish','closed','closed','','drupaleasy-online-course-july-2019','','','2020-10-19 19:06:55','2020-10-20 01:06:55','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2257',0,'tribe_events','',0),(2260,16,'2019-07-02 13:32:23','2019-07-02 19:32:23','We are sponsoring and speaking at Decoupled Days 17-18 July, 2019! Join us to connect with folks building new stacks of tech, hear about <a href=\"https://2019.decoupleddays.com/session/decoupled-drupal-ddev\">how to manage a decoupled project on our dev-to-deploy platform, DDEV</a>, and see what exactly we\'ve been up to.\r\n\r\nDecoupled Days is a conference for architects, developers, and businesspeople involved in implementing decoupled CMS architectures.\r\n\r\n<strong>When</strong>: 17-18 July 2019\r\n\r\n<strong>Where</strong>: John Jay College of Criminal Justice 524 W 59th St, New York, NY 10019\r\n\r\n<strong>Registration</strong>: https://www.eventbrite.com/e/decoupled-days-2019-registration-61699231061\r\n\r\n<strong>Who Attends</strong>: Folks using, developing on, or managing: Drupal, WordPress, etc as a content service for other non-CMS applications, whether they are in native desktop or mobile, universal JavaScript, set-top boxes, IoT devices, conversational interfaces, or other technologies.','Decoupled Days','We are sponsoring and speaking at Decoupled Days 17-18 July, 2019!','publish','closed','closed','','decoupled-days','','','2020-10-19 18:54:16','2020-10-20 00:54:16','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2260',0,'tribe_events','',0),(2263,16,'2019-07-02 13:32:23','2019-07-02 19:32:23','','Decoupled Days','','publish','closed','closed','','decoupled-days','','','2019-07-02 13:32:23','2019-07-02 19:32:23','',0,'https://www.ddev.com/organizer/decoupled-days/',0,'tribe_organizer','',0),(2264,16,'2019-07-15 16:57:27','2019-07-15 22:57:27','We are sponsoring and speaking at TYPO3 Dev Days 14 August, 2019! Join us to connect with folks building with TYPO3 and hear from our team. We\'ve got a few presentations for you:\r\n<ul>\r\n 	<li><a href=\"https://t3dd19.typo3.com/program/sessions/t3dd19-talk-local-to-live-deployment-for-a-typo3-beginner\">Local to Live Development for a TYO3 Beginner</a> - Elli Ludwigson</li>\r\n 	<li><a href=\"https://t3dd19.typo3.com/program/sessions/ddev-local-advanced-tips-and-tricks\">DDEV-Local Tips and Tricks</a> - Andrew French</li>\r\n 	<li><a href=\"https://t3dd19.typo3.com/program/sessions/kubernetes-x-typo3\">Kubernetes x TYPO3</a> - Jan Wozniak &amp; Kevin Bridges</li>\r\n</ul>\r\n<strong>When</strong>: 1-4 August 2019\r\n\r\n<strong>Where</strong>: AkademieHotel Am Rüppurrer Schloss 40 76199 Karlsruhe\r\n\r\n<strong>Registration</strong>: <a href=\"https://www.eventbrite.com/e/typo3-developer-days-2019-karlsruhe-tickets-58428631610\">https://www.eventbrite.com/e/typo3-developer-days-2019-karlsruhe-tickets-58428631610</a>\r\n\r\n<strong>Who Attends</strong>: \"TYPO3 Developer Days is the place to be if you want to see what is happening within the TYPO3 universe. We will have stimulating talks around what\'s going on in the IT world as well as talks about what cool stuff people have done in and with TYPO3. So this event is for everybody interested in using TYPO3 from front end to back end, from hardcore nerd to newbie. \"','TYPO3 Dev Days 2019','We are sponsoring and speaking at TYPO3 Dev Days 14 August, 2019!','publish','closed','closed','','typo3-dev-days-2019','','','2020-10-19 19:11:10','2020-10-20 01:11:10','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2264',0,'tribe_events','',0),(2268,16,'2019-07-15 16:57:27','2019-07-15 22:57:27','',' Akademie Hotel','','publish','closed','closed','','akademie-hotel','','','2019-07-15 16:57:27','2019-07-15 22:57:27','',0,'https://www.ddev.com/venue/akademie-hotel/',0,'tribe_venue','',0),(2270,16,'2019-07-15 17:30:13','2019-07-15 23:30:13','We are attending and speaking at Drupal Camp Colorado 2-4 August, 2019! Join us to connect with the local Drupal community, get hands-on experience with <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a> tips and tricks, and hear what we\'ve up to with DDEV-Live!\r\n<ul>\r\n 	<li>Randy Fay will present DDEV-Local tips and tricks</li>\r\n</ul>\r\n<strong>When</strong>: 2-4 August 2019\r\n\r\n<strong>Where</strong>: King Center, 855 Lawrence Way, Denver, CO 80204\r\n\r\n<strong>Registration</strong>:  Ended\r\n\r\n<strong>Who Attends</strong>: \"DrupalCamp Colorado provides industry leading experiences that help propel ideas forward. We’re here to connect you with the best organizations, industry professionals and Drupal practitioners in the Southwest.\"','Drupal Camp Colorado','We are attending and speaking at Drupal Camp Colorado 2-4 August, 2019!','publish','closed','closed','','drupal-camp-colorado','','','2020-10-19 18:55:37','2020-10-20 00:55:37','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2270',0,'tribe_events','',0),(2273,16,'2019-07-15 17:30:14','2019-07-15 23:30:14','','King Center, Auraria Campus','','publish','closed','closed','','king-center-auraria-campus','','','2019-07-15 17:30:14','2019-07-15 23:30:14','',0,'https://www.ddev.com/venue/king-center-auraria-campus/',0,'tribe_venue','',0),(2274,16,'2019-07-15 17:30:14','2019-07-15 23:30:14','','Drupal Camp Colorado','','publish','closed','closed','','drupal-camp-colorado','','','2019-07-15 17:30:14','2019-07-15 23:30:14','',0,'https://www.ddev.com/organizer/drupal-camp-colorado/',0,'tribe_organizer','',0),(2277,16,'2019-07-18 16:49:56','2019-07-18 22:49:56','We are <a href=\"https://2019.badcamp.org/sponsors\">sponsoring</a> and speaking at Bay Area Drupal Camp (BADCamp) 2-5 October, 2019! Join us to connect with the local Drupal community, get hands-on experience with <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a> tips and tricks, and hear what we\'ve been up to with DDEV-Live! <em>Plus </em>we\'re hosting a happy hour, <a href=\"https://www.eventbrite.com/e/devops-after-dark-tickets-71407538871\">DevOps After Dark</a>, for anyone and everyone.\r\n<ul>\r\n 	<li>We\'re sponsoring the <a href=\"https://2019.badcamp.org/summit/devops-summit\">DevOps summit!</a>\r\n<ul>\r\n 	<li>DDEV CTO/Founder Kevin Bridges will be joining <a href=\"https://2019.badcamp.org/summit/devops-summit\">The Kubernetes Konversation</a> panel to talk about how we\'re using Kubernetes and how important it is to coordinate around it as an open source project. Check back for more info on what goes down at the summit.</li>\r\n 	<li>Kevin will also be presenting on <a href=\"https://2019.badcamp.org/summit/devops-summit\">Buildpacks during the summit</a> and how we can come together <em>now</em> as open source communities to support each other in our <em>future</em> work.</li>\r\n 	<li>Join us at our social event, <a href=\"https://www.eventbrite.com/e/devops-after-dark-tickets-71407538871\">DevOps After Dark,</a> to spend more time chatting and enjoy a relaxed atmosphere. The event is free but please register so we have a headcount :)</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://2019.badcamp.org/session/local-development-environments-panel-discussion\">Local Development Environments Panel Discussion</a>\r\n<ul>\r\n 	<li>DDEV developer and maintainer Randy Fay will chat with some of our colleagues about how various tools solve different problems</li>\r\n</ul>\r\n</li>\r\n 	<li>Workshop &amp; Hands-on time with DDEV-Local!\r\n<ul>\r\n 	<li>Randy Fay will be on deck in the <a href=\"https://2019.badcamp.org/contribution-lounge\">contribution space</a> and in our booth space to talk with you in depth about your pain points, custom configurations, and other solutions with DDEV.</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://2019.badcamp.org/session/decoupled-drupal-ddev-gatsbyjs\">Decoupled Drupal on DDEV with GatsbyJS</a>\r\n<ul>\r\n 	<li>DDEV CTO Kevin Bridges will walk you through how to manage complex workflows and projects from dev to deploy</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>When</strong>: 2-5 October 2019\r\n\r\n<strong>Where</strong>: Hotel Shattuck 2086 Allston Way Berkeley, CA 94704\r\n\r\n<strong>Registration</strong>: https://2019.badcamp.org/registration\r\n\r\n<strong>About</strong>: BADCamp is a four-day annual event celebrating open-source software in Berkeley, California. The 100% volunteer organized, and run entirely for free. As they say \"BADCamp is a Drupal conference for the people.\" The event includes talks, training, and summits such as the Nonprofit Summit (NPS.)','BADCamp 2019','We are sponsoring and speaking at Bay Area Drupal Camp (BADCamp) 2-5 October, 2019!','publish','closed','closed','','badcamp','','','2020-10-19 18:52:55','2020-10-20 00:52:55','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2277',0,'tribe_events','',0),(2280,16,'2019-07-18 16:49:58','2019-07-18 22:49:58','','Hotel Shattuck','','publish','closed','closed','','hotel-shattuck','','','2019-07-18 16:49:58','2019-07-18 22:49:58','',0,'https://www.ddev.com/venue/hotel-shattuck/',0,'tribe_venue','',0),(2282,16,'2019-07-18 17:07:00','2019-07-18 23:07:00','It\'s October in The Hague! We will be sponsoring and attending the <a href=\"https://t3con19.typo3.com/\">14th annual International TYPO3 Conference</a> 17-18 October, 2019! We\'ll be there to talk with you about DDEV-Local and DDEV-Live as well as the business value of open source.\r\n<ul>\r\n 	<li><a href=\"https://t3con19.typo3.com/sessions/help-im-drowning-in-tools-and-technology-and-need-to-stay-competitive-80\">Help! I\'m drowning in tools and technology and need to stay competitive</a>\r\n<ul>\r\n 	<li>DDEV CTO Kevin Bridges on how to Lead and Succeed.</li>\r\n 	<li>18.10.2019 15:35 - 16:20 Main stage hangar</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://t3con19.typo3.com/sessions/panel-business-value-of-open-source-136\">Panel: Business value of open source</a>\r\n<ul>\r\n 	<li>DDEV CEO Steve Grandchamp in a nifty panel discussion with a few of our colleagues!</li>\r\n 	<li>17.10.2019 16:15 - 17:00 Main stage hangar</li>\r\n</ul>\r\n</li>\r\n 	<li>DDEV-Live Early Access trials!\r\n<ul>\r\n 	<li>Visit our booth to try out our hosting platform, DDEV-Live</li>\r\n 	<li>We\'ll make a donation to an open source project (choose from several) in exchange for your valuable feedback!</li>\r\n</ul>\r\n</li>\r\n 	<li>DDEV-Local hands-on help time\r\n<ul>\r\n 	<li>DDEV guru Randy Fay will be on deck to help you with your DDEV setups, questions, solutions, and novel integrations</li>\r\n 	<li>Drop by our booth to tell us how you would like to see DDEV develop to help you from dev-to-deploy.</li>\r\n 	<li>BoF to talk about DDEV development priorities</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>When</strong>: 17-18 October 2019\r\n\r\n<strong>Where</strong>: Fokker Terminal, Binckhorstlaan 249, 2516 BB The Hague\r\n\r\n<strong>Registration</strong>: <a href=\"https://www.eventbrite.com/e/14th-international-typo3-conference-2019-tickets-52352927014\">https://www.eventbrite.com/e/14th-international-typo3-conference-2019-tickets-52352927014</a>\r\n\r\n<strong>About</strong>:  This conference combines both presentations and practical workshops. It attracts developers, TYPO3 users, and decision makers. We\'re looking forward to learning and discussing how DDEV can further support the TYPO3 community.','TYPO3 Conference 2019','It\'s October in The Hague! We will be sponsoring and attending the 14th annual International TYPO3 Conference 17-18 October, 2019!','publish','closed','closed','','typo3-conference-2019','','','2020-10-19 19:10:46','2020-10-20 01:10:46','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2282',0,'tribe_events','',0),(2285,16,'2019-07-18 17:07:00','2019-07-18 23:07:00','','Fokker Terminal','','publish','closed','closed','','fokker-terminal','','','2019-07-18 17:07:00','2019-07-18 23:07:00','',0,'https://www.ddev.com/venue/fokker-terminal/',0,'tribe_venue','',0),(2288,16,'2019-07-18 17:19:30','2019-07-18 23:19:30','We are platinum <a href=\"https://events.drupal.org/amsterdam2019/sponsors\">sponsors</a> and we\'re speaking at DrupalCon Amsterdam 28-31 October, 2019. Join us to connect with the Drupal community and hear about how DDEV can help you from dev-to-deploy. We\'ve got a busy Wednesday planned:\r\n<ul>\r\n 	<li><a href=\"https://drupal.kuoni-congress.info/2019/program/abstract/324\">Panel: How companies are currently using Kubernetes with Drupal</a>\r\n<ul>\r\n 	<li>DDEV CTO Kevin Bridges</li>\r\n 	<li>with Michael Schmid, Thom Toogood, and Florian Loretan</li>\r\n 	<li>30 October 2019 From 10:15 to 10:55 G 102</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://drupal.kuoni-congress.info/2019/program/abstract/321\">Panel: The \"battle\" of the local development tools</a>\r\n<ul>\r\n 	<li>DDEV developer and maintainer Randy Fay</li>\r\n 	<li>with Ricardo Amaro, Mattias Michaux, Michael Schmid, Engin Yilmaz, Mark Casias, Alejandro Moreno-Lopez</li>\r\n 	<li>30 October 2019 from 11:30 to 12:10 G 102</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://drupal.kuoni-congress.info/2019/program/abstract/343\">Combining DevOps and Emotional Intelligence</a>\r\n<ul>\r\n 	<li>DDEV CTO Kevin Bridges and Open Strategy Partners Content Creator Elli Ludwigson</li>\r\n 	<li>30 October, 15:00-15:20 in room G109</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://drupal.kuoni-congress.info/2019/program/abstract/1038\">BoF: Continue the Kubernetes conversation!</a>\r\n<ul>\r\n 	<li>Followup to the Kubernetes panel. Join the conversation and find our more about how we can move forward together.</li>\r\n 	<li>30 October 2019 From 17:15 to 18:00 G 108 (BoF 38)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>When:</strong> Monday October 28-Thursday October 31, 2019\r\n\r\n<strong>Where</strong>: RAI Amsterdam, Europaplein 24 1078 GZ Amsterdam, The Netherlands\r\n\r\n<strong>Registration:</strong> <a href=\"https://events.drupal.org/amsterdam2019/registration\">https://events.drupal.org/amsterdam2019/registration</a>\r\n\r\n<strong>Who Attends:</strong> All who are interested in or active participants using Drupal; from site builders to content &amp; digital marketers to those selling and supporting Drupal.','DrupalCon Amsterdam 2019','We are platinum sponsors and we\'re speaking at DrupalCon Amsterdam 28-31 October, 2019.','publish','closed','closed','','drupalcon-amsterdam-2019','','','2020-10-19 19:01:50','2020-10-20 01:01:50','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2288',0,'tribe_events','',0),(2291,16,'2019-07-18 17:19:30','2019-07-18 23:19:30','','RAI Amsterdam','','publish','closed','closed','','rai-amsterdam','','','2019-07-18 17:19:30','2019-07-18 23:19:30','',0,'https://www.ddev.com/venue/rai-amsterdam/',0,'tribe_venue','',0),(2295,11,'2019-08-13 10:45:00','2019-08-13 16:45:00','DDEV-Local is a powerful local development tool that many of you are fond of for its simplicity and extensibility. Recent versions of <a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local (v1.10+)</a> add custom commands and loads of other goodies we\'d like to show you how to use. In this screencast and tutorial, we\'ll show you how to make use of DDEV-Local custom commands, adding webserver packages, and adding extras in .ddev/homeadditions to support your specific project needs.\r\n\r\nWhen in doubt, update DDEV-Local on your machine and run <code>ddev config</code> on a project before getting started with new features.\r\n\r\nAs an example, and since there are many folks who absolutely love <a href=\"https://www.zsh.org/\">zsh</a> and <a href=\"https://ohmyz.sh/\">oh-my-zsh</a> (an alternative Unix shell and an accompanying framework), we\'ll demonstrate these features by showing you how to add zsh and oh-my-zsh to a DDEV project. We\'re going to do three things to demonstrate this:\r\n<ul>\r\n 	<li>Add the zsh Debian package into the web container with <code>webimage_extra_packages</code></li>\r\n 	<li>Add a custom command that works just like <code>ddev ssh</code>, but it\'s going to be <code>ddev zsh</code></li>\r\n 	<li>Add all the scaffolding for oh-my-zsh in the home directory for lovers of oh-my-zsh</li>\r\n</ul>\r\nWatch the video below and read the detailed instructions to configure your own project:\r\n\r\n[embed]https://www.youtube.com/watch?v=eyhzszuF9Rg&feature=youtu.be&hd=1[/embed]\r\n<h5>How to add zsh and oh-my-zsh to DDEV-Local:</h5>\r\n<ol>\r\n 	<li>From the root of an existing project configured with DDEV-Local: Add the zsh package to the webserver container by adding <code>webimage_extra_packages: [\"zsh\"]</code> to the .ddev/config.yaml (or run <code>ddev config --webimage-extra-packages=zsh</code>, which does the exact same thing). If you only want zsh in the web container, you can <code>ddev restart</code> and you\'re done!</li>\r\n 	<li>To add a <code>ddev zsh</code> custom command to your project, place a file named \"zsh\' in .ddev/commands/web/zsh with the following contents and make it executable with <code>chmod +x zsh</code>:\r\n<pre>#!/bin/bash\r\n\r\n## Description: ssh into web container using zsh\r\n## Usage: zsh [flags] [args]\r\n## Example: \"ddev zsh\"\r\n\r\nzsh $@</pre>\r\nNow you can run <code>ddev zsh</code> and be in your familiar zsh environment (if you did the <code>ddev restart</code> after adding the package in step 1) .</li>\r\n 	<li>If zsh is all you want, copy your favorite .zshrc into .ddev/homeadditions for your project and zsh will be set up with your .zshrc every time you start the project. You\'re done now.</li>\r\n 	<li>Now to add all the goodies that make <a href=\"https://github.com/robbyrussell/oh-my-zsh\">oh-my-zsh</a> work:\r\n<ol>\r\n 	<li>If you already have a ~/.oh-my-zsh and ~/.zshrc, you probably can just copy those into .ddev/homeadditions and they will be added on every <code>ddev start</code>.</li>\r\n 	<li>Otherwise, create the .oh-my-zsh like this:</li>\r\n 	<li><code>cd .ddev/homeadditions</code></li>\r\n 	<li>`curl -Lo <a style=\"background-color: #ffffff; font-size: 1rem;\" href=\"http://install.sh/\" target=\"_blank\" rel=\"noopener noreferrer\" data-token-index=\"1\" data-reactroot=\"\">install.sh</a> <a style=\"background-color: #ffffff; font-size: 1rem;\" href=\"https://raw.githubusercontent.com/robbyrussell/oh-my-zsh/master/tools/install.sh\" target=\"_blank\" rel=\"noopener noreferrer\" data-token-index=\"3\" data-reactroot=\"\">https://raw.githubusercontent.com/robbyrussell/oh-my-zsh/master/tools/install.sh`</a></li>\r\n 	<li><code>ZSH=./.oh-my-zsh sh ./install.sh --unattended</code></li>\r\n 	<li><code>cp ~/.zshrc .</code> (This copies the .zshrc that install.sh will have mistakenly put in your home directory.</li>\r\n 	<li>Change the line near the top of the .ddev/homeadditions/.zshrc to `export ZSH=~/.oh-my-zsh` instead of what the oh-my-zsh installer generated.</li>\r\n</ol>\r\n</li>\r\n 	<li>Now you can run <code>ddev start</code> and <code>ddev zsh</code> will have all the oh-my-zsh goodies.</li>\r\n</ol>\r\n<strong>To review,</strong> we used three advanced features of ddev:\r\n<ul>\r\n 	<li>Added an extra Debian package (zsh) with webimage_extra_packages (<a href=\"https://ddev.readthedocs.io/en/stable/users/extend/customizing-images/#adding-extra-debian-packages-with-webimage_extra_packages-and-dbimage_extra_packages\">docs</a>)</li>\r\n 	<li>Added a custom command (zsh) in .ddev/commands/web by adding a simple script (<a href=\"https://ddev.readthedocs.io/en/stable/users/extend/custom-commands/\">docs</a>)</li>\r\n 	<li>Added extra stuff (oh-my-zsh and .zshrc) into .ddev/homeadditions that will be added to the home directory in the web container on every <code>ddev start</code> (<a href=\"https://ddev.readthedocs.io/en/stable/users/extend/in-container-configuration/\">docs</a>).</li>\r\n</ul>\r\nHappy customizing! If you have questions, check out our <a href=\"https://ddev.readthedocs.io/en/stable/#support\">support channels</a>. Otherwise, sign up for our newsletter to stay in touch:\r\n\r\n<a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">DDEV Newsletter Sign-up</a>','How to use DDEV custom commands and other goodies to add zsh','','publish','closed','closed','','oh-my-zsh-using-custom-commands-and-other-goodies-to-add-to-ddev','','','2019-08-14 15:10:29','2019-08-14 21:10:29','',0,'https://www.ddev.com/?p=2295',0,'post','',0),(2316,16,'2019-08-19 16:43:24','2019-08-19 22:43:24','<!-- wp:heading -->\n<h2>Thank you, T3DD!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We had an amazing time at TYPO3 Developer Days (T3DD) in Karlsruhe, Germany this month. The sessions were enlightening, the venue was pleasant and peaceful, and the entire event so professionally organized by <a href=\"https://punkt.de/de/blog/2019/das-waren-die-typo3-devdays.html\">punkt.de</a>. We were happy to be able to support the TYPO3 community by sponsoring T3DD and pleased especially that the DDEV team spent time just being part of the community. Thank you all very much for a great event!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>As this was a developer focused event, it was a great opportunity to talk technical details with TYPO3 community members who build their own tools and pipelines and have very specific needs for their projects. Learning what is important to you in a development workflow and supporting how you want to work is part of the DDEV mission to help advance developer communities.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>While the <a href=\"https://www.youtube.com/playlist?list=PL-sDBIrOKGOa5dOz-5Moitxv5k3a8JFcn\">session recordings are still being processed</a>, our slides are all linked from each of the session pages below. Please feel free to reach out to us with any questions, especially in <a href=\"https://typo3.slack.com/messages/C8TRNQ601\">#DDEV in TYPO3 Slack</a>, or sign up for our newsletter:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a class=\"btn btn-outline-primary-light btn-lg d-block d-md-inline-block mb-1 ml-md-3\" href=\"http://eepurl.com/dlqkUD\">Join the DDEV Newsletter</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2320} -->\n<figure class=\"wp-block-image\"><img src=\"https://www.ddev.com/content/uploads/2019/08/IMG_20190803_102203-2-1024x768.jpg\" alt=\"DDEV-Local Tips and Tricks Andrew\" class=\"wp-image-2320\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>DDEV-Local</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>One definite highlight of the event was DDEV engineer Andrew French receiving a “best presentation” award for his session on DDEV-Local Tips &amp; Tricks. Talk about an amazing experience for a first-time attendee to a TYPO3 event; thank you very much to everyone who attended the talk and asked questions. A couple things you asked about:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>The DDEV-Local <code>ddev share</code> command - this command is for temporarily sharing a project on your local machine via the web. While we will have a more typical preview functionality on the DDEV-Live platform, <code>ddev share</code> is meant only for giving your mom or client a quick look at work in progress. There’s<a href=\"https://www.drupaleasy.com/blogs/ultimike/2019/06/sharing-your-ddev-local-site-public-url-using-ddev-share-and-ngrok\"> a great blog here from DrupalEasy</a> with details, or just run <code>ddev help share</code>.</li><li>Container modifications - There are a few ways to add custom configuration to your DDEV containers, such as working directly with Dockerfiles. Check out <a href=\"https://www.ddev.com/ddev-local/ddev-local-web-container-customization-in-v1-8-0/\">our blog post here</a> to get started.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Info and slides: <a href=\"https://t3dd19.typo3.com/program/sessions/ddev-local-advanced-tips-and-tricks\">DDEV-Local Advanced tips and tricks</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2319} -->\n<figure class=\"wp-block-image\"><img src=\"https://www.ddev.com/content/uploads/2019/08/IMG_4780-2-1024x768.jpg\" alt=\"TYPO3 Kubernetes Operator DDEV-Live\" class=\"wp-image-2319\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>K8s &amp; T3</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Jan and Kevin’s presentation on TYPO3 and Kubernetes session also drew an interested audience who were full of questions. The best part of these sessions is so often the Q&amp;A, and folks were eager to get into the specifics of how operators work. We invited anyone who is interested to <a href=\"http://bit.ly/sig-cms\">join a Kubernetes special interest group (SIG)</a> that focuses on how we can build and define standards for operators, controllers, and other resources across CMS communities.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Info and slides: <a href=\"https://t3dd19.typo3.com/program/sessions/kubernetes-x-typo3\">Kubernetes x TYPO3</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2318} -->\n<figure class=\"wp-block-image\"><img src=\"https://www.ddev.com/content/uploads/2019/08/Image-from-iOS-2-1024x768.jpg\" alt=\"DDEV-Live demo\" class=\"wp-image-2318\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>DDEV-Live, Live!</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We also demoed deploying a TYPO3 site to our hosting platform, DDEV-Live, for the very first time. We’re finessing the TYPO3 operator for a public release, but it was really fun to work towards a deployment for this event. This presentation talked about some of the ways the entire DDEV workflow makes development simpler, but also flexible and highly extensible in all components from Local to Live. We’ll be expanding on this significantly at <a href=\"https://t3con19.typo3.com/\">TYPO3 Con in The Hague</a> (T3Con) later this year and hope to see you there.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Info and slides:&nbsp; <a href=\"https://t3dd19.typo3.com/program/sessions/t3dd19-talk-local-to-live-deployment-for-a-typo3-beginner\">Local to Live deployment for a TYPO3 beginner</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Next up:</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>After such a positive experience at T3DD we’re very much looking forward to T3Con. It was a pleasure to connect with some of the folks we see online and to have conversations about the TYPO3 community and your projects. Hearing more about the unique parameters and needs for your work is inspiring and productive; now we’re back home tuning DDEV to be as useful as possible to you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Please do sign up below for early access to DDEV-Live as we are opening it up for feedback in the coming weeks and are eager to hear your experience with it. We’ll also be sponsoring and doing more demos at <a href=\"https://t3con19.typo3.com/\">T3Con in October</a>! Purchase your ticket and book your trip so we can chat more.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Thanks very much for having us!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','TYPO3 Dev Days Wrap-Up','','publish','closed','closed','','typo3-dev-days-wrap-up','','','2020-10-14 14:30:55','2020-10-14 20:30:55','',0,'https://www.ddev.com/?p=2316',0,'post','',0),(2343,1,'2019-09-23 10:20:54','2019-09-23 16:20:54','<span style=\"font-weight: 400;\">Please read these Terms carefully.  By accessing the DDEV Platform(“Platform”) or signing up for an account you are agreeing to these Terms (“Agreement”), which will result in a legal agreement between you and Drud Technology, LLC (“Agreement”).  The Platform, a web Platform of Drud Technology, LLC and its affiliated entities, which are referred to herein as \"Drud,\" \"we,\" or \"us.\" provides an online hosting platform that allows you to manage, backup, restore and make changes to your websites.  The “Platform” is accessed through the following websites </span><a href=\"https://dash.ddev.io/\"><span style=\"font-weight: 400;\">https://dash.ddev.io/</span></a><span style=\"font-weight: 400;\">, <a href=\"https://xxx\">https://xxx</a> , </span><a href=\"https://ddev.com\"><span style=\"font-weight: 400;\">https://DDEV.com</span></a><span style=\"font-weight: 400;\"> and includes our API guidelines,  Privacy Policy, Cookie Statement, Copyright and Trademark policy,  Service Level Agreement and any documentation,all of which, define the terms and conditions under which you’re allowed to use the Platform, and how we’ll treat your account while you are a User.  if you don’t agree with these Terms, you must immediately discontinue your use of this Platform. Materials being defined as the elements that contribute to the platform such as documentations, FAQ’s, test data or other items that make up or contribute to the Platform.</span>\r\n\r\n<span style=\"font-weight: 400;\">For the avoidance of doubt, these Terms supplement and do not modify or replace any other agreements entered into between you and Drud, including, but not limited to, a Master Subscription Agreement or other agreement with customers for access and use of Drud’s products or services (the \"Main Agreement\").</span>\r\n\r\n<b>YOU MAY NOT ACCESS, OR ATTEMPT TO ACCESS, THE PORTIONS OF THE PLATFORM THAT REQUIRE A PASSWORD OR ELEVATED PERMISSIONS  FOR ACCESS OTHER THAN AS AN AUTHORIZED USER PURSUANT TO THE MAIN AGREEMENT OR THESE TERMS </b>\r\n\r\n<b>Failure to use the Platform or Materials in accordance with these Terms may subject you to civil and criminal actions and penalties under applicable law.  </b><span style=\"font-weight: 400;\">Except with respect to the Main Agreement, these Terms constitute the entire and only agreement between Drud and you and supersede all prior or contemporaneous agreements, representations, warranties, and understandings with respect to the Materials and Platform. These Terms may be amended by Drud at any time without notice to you. Your continued use of the Platform indicates your acknowledgment of, and consent to, updated Terms.</span>\r\n\r\n<b>Requirements and Restrictions:</b>\r\n<ol>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">When accessing the Platform and Materials, you represent that you are of sufficient age to form legally binding contracts. The Platform and Materials are not designed to solicit or collect information of any kind from persons under the age of 13, and we do not knowingly collect any information from persons under the age of 13.</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Drud reserves the right to discontinue or modify the Platform or Materials, temporarily or permanently, at any time without notice.</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">You agree to provide accurate information when interacting with the Platform or Materials. Failure to provide accurate contact information, and billing information may result in you not receiving access to the Platform or Materials. In addition to other remedies available to Drud, if you provide fraudulent, misrepresented, or otherwise untruthful information, we may terminate your access and prevent you from using the Platform or Materials in the future.</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">You agree to comply with all applicable federal, state, or local laws, ordinances, regulations, rules, decisions, orders, or requirements in connection with your use of the Platform and Materials.</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">You may not use the Platform or Materials in any manner that negatively impacts Drud or its authorized users.</span></li>\r\n</ol>\r\n<span style=\"font-weight: 400;\">By using the Platform, you represent and warrant that you meet all of the requirements listed above.  Note that by representing and warranting, you are making a legally enforceable promise.</span>\r\n\r\n<span style=\"font-weight: 400;\">Drud may refuse service, close accounts of any user and change eligibility requirements at any time under the Agreement.</span>\r\n\r\n<b>Closing your account-</b><span style=\"font-weight: 400;\"> You or Drud may terminate your Agreement at any time and for any reason by giving notice to the other party.  We may suspend your account, under an Agreement, at any time, with or without notice. Once your Agreement account is terminated, you acknowledge and agree that we may permanently delete your account and all of the data associated with it. </span>\r\n\r\n<span style=\"font-weight: 400;\">Your Main Agreement, if you have one, will dictate the terms of closing of your account and will supercede the Agreement.</span>\r\n\r\n<span style=\"font-weight: 400;\">When you set up your Account you will be required to pick a tier  If you go over any plan limits repeatedly for the plan that you picked, you will be required to either cancel your account, or upgrade your account  by signing a Main Agreement with Drud.</span>\r\n\r\n<b>Privacy.</b><span style=\"font-weight: 400;\"> By accessing the Platform or reviewing the Materials, you represent that you have read and agree to the terms of the Drud Privacy Policy for which a link is provided at the bottom of this page and available at </span><a href=\"http://www.ddev.com/privacy-policy/\"><span style=\"font-weight: 400;\">www.ddev.com/privacy-policy/</span></a><span style=\"font-weight: 400;\"> (Privacy Policy). By agreeing to these Terms you consent to Drud’s collection, use, storage, and disclosure of information associated with your use of the Platform and Materials in accordance with the Privacy Policy.</span>\r\n\r\n<b>Ownership.</b><span style=\"font-weight: 400;\"> Subject to the limited rights expressly granted herein, Drud reserves all rights, title, and interest in and to the Platform and Materials, including all related intellectual property rights.</span>\r\n\r\n<b>Limited Rights; Restrictions.</b><span style=\"font-weight: 400;\"> Your right to use the Materials is set forth your Main Agreement, as may be supplemented and modified by these Terms. Certain Materials are subject to an open source license and you agree that the terms of such license will govern your use of those Materials. The Platform and Materials may not be used for any benchmarking or other competitive purposes. Copying, redistribution, use, display, or publication by you of any part of the Platform or Materials is strictly prohibited. You may not use any robot, spider, scraper, deep link or other similar automated data gathering or extraction tools, program, algorithm, or methodology to access, acquire, copy, or monitor the Platform or Materials. Except in connection with permitted activity pursuant to a Drud partner program, you may not link to the Platform without Drud’s prior written consent. You may not: (i) access or use the Platform in any manner that could damage, disable, overburden, or impair any Drud accounts, computer systems, or networks; (ii) attempt to gain unauthorized access to any parts of the Platform or any accounts, computer systems, or networks; or (iii) interfere or attempt to interfere with the proper working of the Platform, Materials, or any accounts, computer systems, or networks.</span>\r\n\r\n<span style=\"font-weight: 400;\">This Platform is not a part of the \"Drud Services\" or \"Services\" (as defined in your Main Agreement) and does not grant to you the right to access or use an account of the Drud Services or Services. If you require a development account of the Drud Services or Services, please contact Drud. Upon any termination of your Main Agreement, you must cease access of the Platform and destroy all full and partial copies of the Materials immediately and, if requested by Drud, certify in writing that the Materials were destroyed.</span>\r\n\r\n<span style=\"font-weight: 400;\">If the use of any aspect of the Platform requires you to register for an account, you must complete the registration process by providing us with current, complete, and accurate information as required by the applicable registration form. You may also be required to choose a password and a user name. Access to and use of password protected or secure areas of the Platform are restricted to authorized users only. You agree not to share your passwords, account information, or access to the Platform with any other person. You are responsible for maintaining the confidentiality of passwords and account information, and you are responsible for all activities that occur through the use of your passwords or accounts, or as a result of your access to the Platform. You agree to notify Drud immediately of any use of your passwords or accounts that you did not authorize or that is not authorized by these Terms or the Main Agreement.</span>\r\n\r\n<span style=\"font-weight: 400;\">If you suspect that the Platform or Materials include a security vulnerability, you agree to report such suspected vulnerability to privacy@ddev.com.</span>\r\n\r\n<span style=\"font-weight: 400;\">If you are a user of the Services pursuant to your Main Agreement, the Drud Acceptable Use Policy also applies to you.</span>\r\n\r\n<b>U.S. Government Rights.</b><span style=\"font-weight: 400;\"> The Materials are \"commercial items\" as such term is defined at FAR 2.101. If you are a U.S. Federal Government (Government) Executive Agency (as defined in FAR 2.101), Drud provides the Materials, including any related software, technology, technical data in accordance with the following: (a) if acquired by or on behalf of any Executive Agency (other than an agency within the Department of Defense (DoD), the Government acquires in accordance with FAR 12.211 (Technical Data) and FAR 12.212 (Computer Software), only those rights in technical data and software customarily provided to users set forth in these Terms; or (b) if acquired by or on behalf of an Executive Agency within the DoD, the Government acquires, in accordance with DFARS 227.7202-3 (Rights in commercial computer software or commercial computer software documentation), only those rights in technical data and software customarily provided in these Terms. In addition, DFARS 252.227-7015 (Technical Data-Commercial Items) applies to technical data acquired by DoD agencies. Any Federal Legislative Agency or Federal Judicial Agency will obtain only those rights in technical data and software customarily provided to the public as set forth in these Terms. If any Federal Executive Agency, Federal Legislative Agency, or Federal Judicial Agency has a need for rights not conveyed under the terms described in this Section, it must negotiate with Drud to determine if there are acceptable terms for transferring such rights, and a mutually acceptable written addendum specifically conveying such rights must be included in any applicable contract or agreement to be effective. This U.S. Government Rights Section is in lieu of, and supersedes, any other FAR, DFARS, or other clause, provision, or supplemental regulation that addresses Government rights in computer software or technical data under these Terms.</span>\r\n\r\n<b>Trademark Information.</b><span style=\"font-weight: 400;\"> You are expressly prohibited from using Drud’s trademarks, service marks, name, and logos without Drud’s prior written consent in each instance. Without limiting the foregoing, you acknowledge and agree that you may not use the name”Drud Technology, LLC”, \"Drud, Inc.\" or \"Drud\" or any other Drud intellectual property to endorse or promote products derived from the Materials without express and specific prior written permission of Drud.</span>\r\n\r\n<b>Copyright Infringement.</b><span style=\"font-weight: 400;\"> If you believe that your work has been copied in a way that constitutes copyright infringement on the Platform or through the Materials, please provide Drud’s copyright agent the written information specified below. Please note that this procedure is exclusively for notifying Drud that your copyrighted material has been infringed.</span>\r\n<ol>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">An electronic or physical signature of the person authorized to act on behalf of the owner of the copyright interest;</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">A description of the copyrighted work that you claim has been infringed upon;</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">A description of where the material that you claim is infringing is located on the Platform;</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Your address, telephone number, and e-mail address;</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">A statement by you that you have a good-faith belief that the disputed use is not authorized by the copyright owner, its agent, or the law; and</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">A statement by you, made under penalty of perjury, that the above information in your notice is accurate and that you are the copyright owner or authorized to act on the copyright owner\'s behalf.</span></li>\r\n</ol>\r\n<span style=\"font-weight: 400;\">Drud’s Copyright Agent for notice of claims of copyright infringement on the Platform can be contacted as follows: </span>\r\n\r\n<span style=\"font-weight: 400;\">Drud Technology, LLC</span>\r\n\r\n<span style=\"font-weight: 400;\">Attn: Privacy Officer</span>\r\n\r\n<span style=\"font-weight: 400;\">700 Broadway Suite 800</span>\r\n\r\n<span style=\"font-weight: 400;\">Denver, CO 80203</span>\r\n\r\n<span style=\"font-weight: 400;\">e-mail: </span><a href=\"mailto:privacy@ddev.com\"><span style=\"font-weight: 400;\">privacy@ddev.com</span></a>\r\n\r\n<b>Editing, Deleting, and Modification.</b><span style=\"font-weight: 400;\"> Drud reserves the right to change, edit, or delete any documents, information, or Materials appearing on the Platform.</span>\r\n\r\n<b>Indemnification. </b><span style=\"font-weight: 400;\">You agree to indemnify, defend and hold Drud and its respective directors, officers, shareholders, employees, agents, attorneys, and affiliates (collectively, \"Affiliated Parties\") harmless from any liability, loss, claim or expense, including reasonable attorneys\' fees, related to your use of the Platform or Materials, or any violation of these Terms.</span>\r\n\r\n<b>Assignment.</b><span style=\"font-weight: 400;\"> Drud may assign these Terms to an entity in connection with a merger, acquisition, asset transfer, or corporate reorganization.</span>\r\n\r\n<b>WARRANTY DISCLAIMER.</b><span style=\"font-weight: 400;\"> THE Platform AND THE MATERIALS ARE PROVIDED \"AS IS\" AND \"AS AVAILABLE.\" TO THE FULLEST EXTENT PERMISSIBLE PURSUANT TO APPLICABLE LAW, DRUD AND ITS AFFILIATED PARTIES DISCLAIM ALL WARRANTIES EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, NON-INFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE, OR MERCHANTABILITY. DRUD DOES NOT WARRANT THAT THE Platform OR MATERIALS WILL BE UNINTERRUPTED, ERROR-FREE, CORRECT, ACCURATE, OR RELIABLE, THAT DEFECTS WILL BE CORRECTED, THAT THERE ARE NO VIRUSES OR OTHER HARMFUL COMPONENTS, OR THAT SECURITY METHODS EMPLOYED WILL BE SUFFICIENT.</span>\r\n\r\n<b>LIMITATION OF LIABILITY.</b><span style=\"font-weight: 400;\"> IN NO EVENT WILL DRUD OR AFFILIATED PARTIES BE LIABLE FOR ANY LOSS OF USE, LOSS OF PROFITS, INTERRUPTION OF BUSINESS, INDIRECT, INCIDENTAL, CONSEQUENTIAL, PUNITIVE, OR SPECIAL DAMAGES ARISING HEREFROM OR RELATED HERETO IN ANY CAUSES OF ACTION OF ANY KIND, EVEN IF DRUD WAS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES OR SHOULD HAVE BEEN AWARE OF THE POSSIBILITY OF SUCH DAMAGES. DRUD’S AGGREGATE LIABILITY TO YOU FOR EVERY REASON UNDER THESE TERMS WILL BE LIMITED TO US\\$50.00. NO ADVICE OR INFORMATION, WHETHER ORAL OR WRITTEN, YOU OBTAIN FROM US FROM OR THROUGH THE Platform OR MATERIALS WILL CREATE ANY WARRANTY, REPRESENTATION, OR GUARANTEE NOT EXPRESSLY STATED IN THESE TERMS.</span>\r\n\r\n<b>Links to Other Websites; Third Party Materials.</b><span style=\"font-weight: 400;\"> The Platform and Materials may now, or hereafter, contain links to third-party webPlatforms or content provided by third parties, including User Submissions, as defined below (collectively, \"Third Party Materials\"). Drud does not control, investigate, monitor, or check such Third Party Materials. Drud is not responsible for the Third Party Materials or opinions expressed therein. The inclusion of Third Party Materials on the Platform does not imply approval or endorsement of such Third Party Materials by Drud. If you decide to leave the Platform and access any Third Party Materials, you do so at your own risk. The Third Party Materials may be subject to the terms of third-party license agreements that may be made available to you when you view or download the applicable Third Party Materials.</span>\r\n\r\n<b>User Submissions.</b><span style=\"font-weight: 400;\"> Certain areas of the Platform (such as forums, customer ratings, or review areas) may permit you to submit feedback, feature requests, comments, information, ideas, data, text, software, music, sound, photographs, graphics, video, messages, or other materials (\"User Submissions\"). All User Submissions that you submit will be considered non-confidential by Drud. By submitting such User Submissions to us: (i) you represent and warrant that Drud’s use of your User Submissions does not and will not breach any agreement, violate any law, or infringe any third party\'s rights and that such User Submissions are accurate and true; (ii) you represent and warrant that you have all necessary rights and authorizations, including any required authorization from your employer or company with which you are affiliated, to enter into these Terms and provide User Submissions; (iii) you understand and agree that Drud is free to use in any manner all or part of the User Submissions on an unrestricted basis without the obligation to notify, identify, or compensate you or anyone else; and (iv) you grant Drud, and to the extent applicable other Drud customers, all necessary rights, including a waiver of all privacy and moral rights, to use and display all User Submissions, in whole or in part, or as a derivative work, without any duty by Drud to anyone whatsoever. You acknowledge that you are responsible for and bear all risk as to the use or distribution of User Submissions.</span>\r\n\r\n<span style=\"font-weight: 400;\">In addition, in the event that you provide User Submissions to Drud for publication as a Drud \"Customer Success\" story, Drud may, in its sole discretion, accept, reject, and edit such content. Any such editing will be in good faith, and Drud will endeavor not to misrepresent your testimonials.</span>\r\n\r\n<span style=\"font-weight: 400;\">If you provide User Submissions to Drud for publication as a product or service review on the Platform, Drud may (i) edit such User Submissions for style or length and (ii) to the extent the review is negative, as determined by Drud in its reasonable opinion, provide such User Submission to the developer or distributor of such product or service for consideration or response and enable such developer or distributor to contact you directly to discuss your User Submissions, and you expressly authorize Drud to share your contact information with such developer or distributor for such purpose. Drud is not obligated to provide you with any feedback or response related to a User Submission or to post or publish User Submissions. If Drud provides you with feedback of any kind, Drud retains all right, title, and interest in and to such information, and you may use such information for your non-commercial internal business purposes only. If you are viewing User Submissions in the form of a product or service review any review area on the Platform, be advised that Drud may not post or publish all User Submissions related to such product or service, and that Drud may modify the original User Submissions as permitted in these Terms.</span>\r\n\r\n<span style=\"font-weight: 400;\">To the extent that your User Submissions are feature requests and notwithstanding anything to the contrary set forth in these Terms, you agree that Drud will own all right, title, and interest in and to such User Submissions and you are not a contributing inventor to any inventions that may arise from Drud’s development of any products, services or applications implementing such User Submission. In the event that you are determined to be a contributing inventor by any court or government agency competent to make such a determination, at Drud’s request you will (i) cooperate with Drud in procuring patents to protect the invention; (ii) execute all necessary paperwork required to procure patents to the invention on Drud’s behalf; and (iii) request execute any ownership assignments of any patents or patent applications. To the extent Drud does not own a User Submission, you hereby grant to Drud a nonexclusive, worldwide, irrevocable, perpetual, transferable, fully paid-up, royalty free, sublicensable license to all such rights.</span>\r\n\r\n<span style=\"font-weight: 400;\">Any unreleased services or features discussed on the Platform are not currently available and may not be delivered on time or at all. If you post a feature request on the Platform, Drud may comment on the feature request by appending a status to the request in order to communicate with the Drud community regarding implementation of feature requests. Posting a status to a feature request does not impose any obligation on Drud, such as, for example, to develop, implement, release, use, or not use such feature request, and Drud can change the status at any time in its sole discretion.</span>\r\n\r\n<span style=\"font-weight: 400;\">You are expressly prohibited from collecting information about other users of the Platform, Materials, or Service for the purpose of sending, or to facilitate the sending of, unsolicited bulk communication, advertising, promotional materials, junk mail, spam, chain letters, pyramid schemes, or any other solicitation to other users of the Platform. Drud retains the right to remove or correct any posting that violates these Terms or Drud’s policies, at its sole discretion. Certain User Submissions may be subject to additional terms and requirements.</span>\r\n\r\n<b>Export Compliance.</b><span style=\"font-weight: 400;\"> The Materials and derivatives thereof may be subject to export and import laws and regulations of the United States and other jurisdictions. You represent that you are not named on any U.S. government denied-party list. You will not permit any access or use any Materials in or from a U.S.-embargoed country (currently Cuba, Iran, North Korea, Sudan, and Syria) or in violation of any export or import law or regulation of any jurisdiction.</span>\r\n\r\n<b>Force Majeure</b><span style=\"font-weight: 400;\">  Drud will not be held Liable for any delays or failure in performance of any part of the Platform due from any cause beyond our control.  This includes but is not limited to, acts of god, changes in laws or regulations , embargoes, war, terrorist acts, riots, fires, earthquakes, nuclear accidents, floods, strikes, power blackouts, volcanic actions, unusually severe weather conditions, and acts of hackers, or third party internet service providers.</span>\r\n\r\n<b>Miscellaneous.</b><span style=\"font-weight: 400;\"> Any cause of action by you with respect to the Platform or Materials must be instituted within one (1) year after the cause of action arose or be forever waived and barred. All actions will be subject to the limitations set forth under \"Warranty Disclaimer\" and \"Limitation of Liability\" above. The language in these Terms will be interpreted as to its fair meaning and not strictly for or against you or us. Should any part of these Terms be held invalid or unenforceable, that portion will be construed consistent with applicable law and the remaining portions will remain in full force and effect. To the extent that anything in or associated with the Platform or Materials is in conflict or inconsistent with these Terms, these Terms will take precedence. Our failure to enforce any provision of these Terms will not be deemed a waiver of such provision.</span>\r\n\r\n<b>Dispute Resolution.</b><span style=\"font-weight: 400;\"> These Terms will be governed by the laws of the State of Colorado, excluding conflicts of laws principles. The United Nations Convention on Contracts for the International Sale of Goods does not apply to these Terms. In the event of a dispute, Drud encourages you first to contact Drud to resolve your problem directly with us. You may contact Drud regarding any complaints or disputes at privacy@ddev.com.</span>\r\n\r\n<span style=\"font-weight: 400;\">Except in the event that Drud or an Affiliated Party seeks a provisional remedy related to claims of misappropriation or ownership of intellectual property, trade secrets, or confidential information, any and all disputes, claims or controversies arising out of or relating to these Terms must be submitted to JAMS for mediation before arbitration or any other form of legal relief may be instituted. Mediation may be commenced by a party providing JAMS a written request for mediation setting forth the subject of the dispute and the relief requested. The parties will cooperate with JAMS in selecting a single mediator and scheduling a mediation, which should take place within 45 days following a request for mediation. The mediator will be a retired judge who has had experience with technology disputes. The parties agree that they will participate in the mediation in good faith and share equally in its costs. The mediation will take place in Denver, Colorado.</span>\r\n\r\n<span style=\"font-weight: 400;\">If for any reason a claim proceeds in court rather than in arbitration, you and Drud each waive any right to a jury trial and agree to proceed only on an individual basis and not in a class, consolidated, or representative action. The parties hereby appoint the arbitrator the exclusive power to rule on any challenges to the requirement for the use of alternative dispute resolution in these Terms.</span>\r\n\r\n<span style=\"font-weight: 400;\">Except as explicitly provided in these Terms, all claims you bring against Drud must be resolved in accordance with this Dispute Resolution section. Any claim filed or brought contrary to this Dispute Resolution section will be considered improperly filed. Should you file a claim contrary to this section, Drud may recover from you attorneys\' fees and costs up to \\$1500 per claim, provided that Drud first has notified you in writing of the improperly filed claim and you have failed to promptly withdraw the claim.</span>\r\n\r\n<b><i>Version: May, 2019</i></b>','Terms of Service Agreement','','publish','closed','closed','','terms-of-service-agreement','','','2019-09-23 10:29:57','2019-09-23 16:29:57','',0,'https://www.ddev.com/?page_id=2343',0,'page','',0),(2347,1,'2019-09-23 10:33:06','2019-09-23 16:33:06','','Terms of Service','','publish','closed','closed','','terms-of-service','','','2020-06-11 15:14:36','2020-06-11 21:14:36','',0,'https://www.ddev.com/?p=2347',1,'nav_menu_item','',0),(2362,16,'2019-10-09 13:37:36','2019-10-09 19:37:36','<!-- wp:heading -->\n<h2>Thank you, BADCamp!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We had a great couple of days out in Berkeley with you all! It was our pleasure to be Exhibition Hall sponsors for the event as well as sponsoring the DevOps summit and DevOps after Dark. That evening event was especially good for having more engaged conversations with many of you this year, and we’re always happy to support a little relaxation after a long day. <br><br>Helping Drupal folks advance as developers, contributors, and solid community members is part of our mission both with our tools and our philosophy. BADCamp felt like a really great, connected time with everyone and we’re grateful to the organizers and volunteers for all their hard work in making it happen.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>All the recorded sessions from the event are <a href=\"http://drupal.tv/curated-playlists/badcamp-2019\">here on Drupal.tv</a>. If you need anything at all, you can always reach out to us at <a href=\"mailto:info@ddev.com\">info@ddev.com</a>, the<a href=\"https://drupal.slack.com/messages/C5TQRQZRR\"> #ddev channel in Drupal Slack</a>, and on <a href=\"https://twitter.com/ddev\">Twitter: #DDEV @Drud</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Local Development Environments Panel</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Randy Fay, developer and maintainer of <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a>, was invited to a <a href=\"https://twitter.com/PhilAlonso/status/1180223218231103488\">well-attended panel</a> of folks who have built various <a href=\"https://2019.badcamp.org/session/local-development-environments-panel-discussion\">local development environments</a> for use with Drupal. All the panelists had great answers for “Why should I switch away from MAMP?” and “What’s so great about Docker?” The key to success for any of the tools seemed to be the integration of that tool into a workflow and CI/CD process, including deployments to production.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://drupal.tv/external-video/2019-10-05/local-development-environments-panel-discussion\">Watch the full discussion here.</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Hands-On Time with DDEV-Local</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Randy also made a point of being available to answer your questions and have time for 1:1 mentoring sessions to get started with DDEV-Local. It can be challenging to start from scratch on your own, and there are loads of advanced DDEV users out there who have very complex needs. Wherever you fit in that spectrum we’re always happy to see you and lend a hand!&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Start with <a href=\"https://github.com/ddev/ddev\">DDEV-Local here</a>, and drop by Slack or StackOverflow to <a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">dig deeper</a>.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2367,\"width\":512,\"height\":385,\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image is-resized\"><a href=\"https://photos.google.com/share/AF1QipNYRVVDL2qhiu-GeRX-v3Q4OznvzQESnz8ZVBc7TmtACcRsscm6oyrb82pupeEUEg?key=b2pWTWdNdGU0dTgwU3JDLTN0Q1pDZ3QtN0VfQXJB\" target=\"_blank\" rel=\"noreferrer noopener\"><img src=\"https://www.ddev.com/content/uploads/2019/10/P1020089-1024x769.jpg\" alt=\"BADCamp Kubernetes Konversation panel with socketwench, schnitzel, cyberswat and \" class=\"wp-image-2367\" width=\"512\" height=\"385\"/></a><figcaption>photo by <a href=\"https://www.drupal.org/u/areynolds\">Alec Reynolds</a></figcaption></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Kubernetes Panel</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>It was an honor to be invited to participate in the <a href=\"https://2019.badcamp.org/summit/devops-summit\">Kubernetes Konversation panel at BADCamp</a> and hear how others have been approaching the same problems we have. We’re building a hosting platform based on Kubernetes to run Drupal, WordPress, TYPO3 and much much more. We’re passionate about building it in a way that is sustainable, flexible, and can help others in the future.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>That’s why we also started a Kubernetes special interest group (SIG) to bring folks together for more collaboration and agreement around how we architect infrastructure for sustainable CMS hosting. <a href=\"https://github.com/ddev/sig-cms\">Join the SIG for meetings and projects here</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Building for the Pack with Buildpacks</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>As part of the DevOps summit, Kevin presented <a href=\"https://docs.google.com/presentation/d/1vI9NhlnQOdVIHLuqHwe6D2CpaqUbNmQP8KwhhiYXiR8/edit#slide=id.g5ee46e403c_0_55\">an overview of Buildpacks</a> and how this tool can help us to “describe Drupal to modern infrastructure to address day 1 and day 2 operations.” Unfortunately it doesn’t seem that this session was recorded, or it hasn’t been posted yet. We’ll share it if it turns up! Please enjoy the <a href=\"https://docs.google.com/presentation/d/1vI9NhlnQOdVIHLuqHwe6D2CpaqUbNmQP8KwhhiYXiR8/edit#slide=id.g5ee46e403c_0_55\">the slides</a> in the meantime.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Decoupled Drupal &amp; DDEV</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Kevin also presented an overview of how <a href=\"https://2019.badcamp.org/session/decoupled-drupal-ddev-gatsbyjs\">DDEV can help run a complex decoupled Drupal/Gatsby project</a> from dev to deploy. Part of our mission is to look for patterns that apply across communities so that we can create solutions that are as helpful as possible to you. That includes building our dev-to-deploy platform with the flexibility to create workflows that match your project needs. <a href=\"http://drupal.tv/external-video/2019-10-05/decoupled-drupal-ddev-gatsbyjs\">Watch the presentation here</a> to learn more.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Next up:&nbsp;</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Thank you to everyone who attended BADCamp and especially to those of you who stopped by to say hi and get some tips and tricks with our dev-to-deploy platform. We’re pleased we could sponsor and support you in your creative endeavors with DDEV from Local development to Live hosting.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Next week we’re headed to the Netherlands! We’ll be sharing more demos at <a href=\"https://www.ddev.com/event/typo3-conference-2019/\">TYPO3Con in the Hague</a> and <a href=\"https://www.ddev.com/event/drupalcon-amsterdam-2019/\">DrupalCon in Amsterdam</a>. Will we see you there? Register and book your trip if you haven’t already, time’s running out!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you can’t make it this time, you can still check out DDEV-Live online. We’ll be sharing more demo videos on the blog, in newsletters, and letting everyone onboard for trials (already started!):</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"http://eepurl.com/gFfwFb\">Join our mailing list!</a></div>\n<!-- /wp:button -->\n\n<!-- wp:image {\"id\":2368,\"width\":512,\"height\":384} -->\n<figure class=\"wp-block-image is-resized\"><img src=\"https://www.ddev.com/content/uploads/2019/10/Image-from-iOS-1024x768.jpg\" alt=\"\" class=\"wp-image-2368\" width=\"512\" height=\"384\"/><figcaption>Spot our booth at upcoming events!</figcaption></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p><br></p>\n<!-- /wp:paragraph -->','BADCamp 2019 Wrap-Up','','publish','closed','closed','','badcamp-2019-wrapup','','','2020-04-20 09:51:45','2020-04-20 15:51:45','',0,'https://www.ddev.com/?p=2362',0,'post','',0),(2393,16,'2019-11-11 14:28:48','2019-11-11 21:28:48','<!-- wp:heading -->\n<h2>Thank you, TYPO3Con!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We were pleased to sponsor the <a href=\"https://t3con19.typo3.com/\">14th International TYPO3 Conference</a> in the Hague this October and grateful to be able to support TYPO3 users! The TYPO3 community is an energetic and driven space full of people who are eager to share ideas and get to work making things happen. Thank you to everyone who stopped by the booth, shared your knowledge in sessions, and especially to the organizers at <a href=\"https://www.maxserv.com/\">MaxServ</a> for putting the conference together.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The best part of conferences is having time to bring a group together quickly for discussion of new ideas and initiatives to work on remotely together. At TYPO3Con, we started a conversation about the patterns needed to establish good practices, standardizations, and reliability to shepherd projects from dev-to-deploy. Plans are still just kicking off but we hope to have more updates on this conversation soon!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Updates from DDEV-Live</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Many of you stopped by our booth for an update on our DDEV-Live dev-to-deploy platform or to learn how DDEV-Local and DDEV-Live can help in your current workflows. We had a demo reel playing showing the <a href=\"https://youtu.be/iHY1gtrENJQ\">deployment of a TYPO3 site from DDEV-Local to DDEV-Live</a> using the latest version of the full platform.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We’ve begun sharing access to the platform with early access users to get in-depth feedback, questions, and suggestions regarding the experience. With each round of reviews we can bring on more and more users, but we’re taking the time to integrate that feedback as we go so the experience is as robust as possible. Many of you are on the early access list and we are looking forward to sharing more with you very soon.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In exchange for your time and effort in reviewing DDEV-Live, we’re making donations to a variety of open source projects from our shortlist. If you haven’t registered for our early access program, please sign up below and we’ll be in touch regarding the next steps. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->\n\n<!-- wp:image {\"id\":2395,\"width\":512,\"height\":342} -->\n<figure class=\"wp-block-image is-resized\"><img src=\"https://www.ddev.com/content/uploads/2019/11/DSC09463-Richard-Vollebregt-1024x683.jpg\" alt=\"Kevin Bridges presenting at TYPO3Con 2019\" class=\"wp-image-2395\" width=\"512\" height=\"342\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Help! I’m drowning in tools and technology</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>DDEV CTO Kevin Bridges presented on <a href=\"https://t3con19.typo3.com/sessions/help-im-drowning-in-tools-and-technology-and-need-to-stay-competitive-80\">how to lead and succeed</a> while facing the challenges and demands of the modern web. He talked about how a team can benefit from using tools (such as DDEV) that facilitate quick collaboration for any project on any machine at any stage in the process. View the <a href=\"https://drive.google.com/open?id=1kJxet_Rdc_ISXTpwzs1ZDVBFwkk1GZuC\">slides for this presentation here</a>. Video <a href=\"http://youtube.com/typo3\">coming soon</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2397,\"width\":512,\"height\":384} -->\n<figure class=\"wp-block-image is-resized\"><img src=\"https://www.ddev.com/content/uploads/2019/11/IMG_20191017_162310-1024x768.jpg\" alt=\"Panel discussion on the TYPO3Con main stage.\" class=\"wp-image-2397\" width=\"512\" height=\"384\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Panel: Business value of open source</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A highlight of the conference was the <a href=\"https://t3con19.typo3.com/sessions/panel-business-value-of-open-source-136\">panel discussion</a> our CEO Steve Grandchamp participated in with Mathias Schreiber, CEO TYPO3 GmbH, Ben Marks, Magento/Adobe, Campbell Vertesi, Principal Software Engineering Manager at Microsoft, Cecilia Fernandez de Cordoba, Senior Director DevOps at FICO, and Jeffrey A. “jam” McGuire, Partner at Open Strategy Partners GmbH.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>It was fascinating and illuminating to hear everyone’s perspectives on the current landscape of open source projects and initiatives in the larger business world and how companies are adapting and adopting open source as a business strategy. Video <a href=\"http://youtube.com/typo3\">coming soon</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2398,\"width\":512,\"height\":384} -->\n<figure class=\"wp-block-image is-resized\"><img src=\"https://www.ddev.com/content/uploads/2019/11/IMG_20191017_140635-1024x768.jpg\" alt=\"Randy Fay and @Codemonkey1988 talking and gesturing at the DDEV booth at TYPO3Con\" class=\"wp-image-2398\" width=\"512\" height=\"384\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>DDEV-Local</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Randy Fay, developer and maintainer of DDEV-Local, was thrilled to be on site at TYPO3Con to talk with longtime users and contributors! There were also interesting conversations around DDEV support for Magento that we’re eager to follow up on. The TYPO3 community has been really wonderful to collaborate with on our open source local development environment so it was good to see folks in person. :)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Start with <a href=\"https://github.com/ddev/ddev\">DDEV-Local here</a>, and drop by Slack or StackOverflow to <a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">dig deeper</a>.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We’ll share all the recorded sessions from the event as soon as they are posted. If you need anything at all, you can always reach out to us at <a href=\"mailto:info@ddev.com\">info@ddev.com</a>, the <a href=\"https://typo3.slack.com/archives/C8TRNQ601\">#ddev channel in TYPO3 Slack</a>, and on <a href=\"https://twitter.com/ddev\">Twitter: #DDEV @Drud</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->\n\n<!-- wp:paragraph -->\n<p><br></p>\n<!-- /wp:paragraph -->','TYPO3Con 2019 Wrap-Up','','publish','closed','closed','','typo3con-2019-wrapup','','','2020-10-07 15:14:15','2020-10-07 21:14:15','',0,'https://www.ddev.com/?p=2393',0,'post','',0),(2409,16,'2019-11-21 17:46:31','2019-11-22 00:46:31','<!-- wp:heading -->\n<h2>Thank you, DrupalCon Amsterdam!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We would like to extend a big <strong>Thank You</strong> to all the organizers and volunteers who helped make <a href=\"https://events.drupal.org/amsterdam2019\">DrupalCon Amsterdam</a> happen! Many community members contributed significant personal time and effort to make the event welcoming and useful for both attendees and those following along online. We were happy we could contribute ourselves as platinum sponsors and mentors on contribution day. All the <a href=\"https://www.youtube.com/playlist?list=PLpeDXSh4nHjSZET8xL2RyK3_2WeXxyWkY\">recorded DrupalCon sessions are available</a> to share and learn from for anyone in the Drupal community and beyond.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Our focus at DrupalCon was on offering time for new and existing DDEV users to meet one-on-one with our team members for in-depth conversations about our dev-to-deploy platform. Thank you very much to everyone who took us up on this offer! Your feedback, ideas, questions, and enthusiasm had real and immediate impact on our roadmaps for both <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a> and <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We are strong proponents of a “<a href=\"https://circleci.com/blog/how-my-distributed-team-communicates-so-no-context-is-left-behind/\">remote-first</a>” work environment for our highly distributed team, which means that the opportunity to gather with our own team and many of you was both valuable and validating. DDEV CTO Kevin Bridges and Content Creator Elli Ludwigson also did a presentation that touched on some of the considerations our remote team has been working through to <a href=\"#DevOps\">balance productivity with human compassion</a>. We’re a small company doing big things, like building DDEV-Live hosting!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Hands-on time with DDEV for local development and cloud hosting</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>With three days in the exhibit hall we had lots of time for one-on-one sessions for both DDEV-Local and DDEV-Live users. We were especially excited to walk through how to deploy a project on DDEV-Live with a bunch of you; thank you for the real-time feedback! You can <a href=\"https://www.youtube.com/watch?v=9Vbwj_TKeU8\">watch the DDEV dev-to-deploy demo video</a> showing everything from local to live (with Umami!) to get an idea of the process.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Our goal is for DDEV to be a platform to support local to live workflows for all types of teams and projects. We’re always happy to hear about how you’re using DDEV-Local, and we collect your contributions in <a href=\"https://github.com/ddev/ddev-contrib\">ddev-contrib</a> and resources in <a href=\"https://github.com/ddev/awesome-ddev\">awesome-ddev</a>. The flexibility of the DDEV platform means you have the option of plugging various tools together to create your workflow of choice.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Start by <a href=\"https://github.com/ddev/ddev#ddev\">setting up a project for local development with DDEV-Local</a>, and drop by Slack or StackOverflow to <a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">ask questions or share your contributions</a>. Then, learn how we’ll support your project launch with DDEV-Live— we’re offering remote one-on-one walkthroughs! Sign up below and we’ll be in touch to provision your trial account.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Kubernetes + Drupal for modern hosting</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The highlights of DrupalCon included a couple of really excellent panel discussions on technical topics near and dear to us. First up was a panel organized by @<a href=\"https://www.drupal.org/u/schnitzel\">schnitzel</a>, <a href=\"https://youtu.be/boEjn_22wNA\">How companies are currently using Kubernetes with Drupal.</a> DDEV CTO Kevin Bridges joined Michael Schmid, Thom Toogood, Brad Jones, and Florian Loretan to talk about some of the joys and challenges of building with Kubernetes.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We followed up the panel with a “Birds of a Feather” <a href=\"https://www.youtube.com/watch?v=TsyC_96X9tg\">Kubernetes BoF session</a>, which was recorded as well. Please join the Kubernetes x CMS community for regular <a href=\"https://github.com/ddev/sig-cms\">special interest group (SIG) meetings</a>, which are also announced in our <a href=\"https://t.co/otQEnxH6LG?amp=1\">Drupal Slack #kubernetes channel</a>. It’s important that we work together across our open source <a href=\"https://www.ddev.com/ddev-live/kubecon-barcelona-wrap-up/\">communities like Kubernetes</a> to build infrastructure capable of supporting all our projects into the future.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">We\'re looking at <a href=\"https://twitter.com/hashtag/buildpacks?src=hash&amp;ref_src=twsrc%5Etfw\">#buildpacks</a> to describe project packages from <a href=\"https://twitter.com/hashtag/Docker?src=hash&amp;ref_src=twsrc%5Etfw\">#Docker</a>-based Local to <a href=\"https://twitter.com/hashtag/Kubernetes?src=hash&amp;ref_src=twsrc%5Etfw\">#Kubernetes</a>-based Live (<a href=\"https://twitter.com/hashtag/DDEV?src=hash&amp;ref_src=twsrc%5Etfw\">#DDEV</a> or otherwise). There\'s a lot to understand to help this happen for more <a href=\"https://twitter.com/hashtag/opensource?src=hash&amp;ref_src=twsrc%5Etfw\">#opensource</a> projects!<br>Join us later today at <a href=\"https://twitter.com/hashtag/DrupalCon?src=hash&amp;ref_src=twsrc%5Etfw\">#DrupalCon</a> ✨BoF 16:15 to 17:00 G 108! <a href=\"https://t.co/eptYVkANse\">pic.twitter.com/eptYVkANse</a></p>— DDEV (@ddev) <a href=\"https://twitter.com/ddev/status/1189480600882864133?ref_src=twsrc%5Etfw\">October 30, 2019</a></blockquote> <script async=\"\" src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>The “battle” of the local development tools</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>What’s even more exciting than containers and cloud hosting? Local development environments for Drupal! Randy Fay, developer and maintainer of DDEV-Local, joined <a href=\"https://youtu.be/5RyehstAgdg\">a panel of other Docker-based local development environment experts</a> to talk about the finer details of each tool. As Randy said, “All of these tools are aiming to solve the problem of unpredictable local development environments.”&nbsp;&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A big thank you to <a href=\"https://www.drupal.org/u/ricardoamaro\">Ricardo Amaro</a> for moderating, as well as the other panelists Mattias Michaux, Michael Schmid, Engin Yilmaz, and Mark Casias. Everyone bonded over our desires to create the perfect tool for a specific use-case and the overhead of maintaining that tool in perpetuity. There was also discussion of the possibility of combining efforts more in the future!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Thank you <a href=\"https://twitter.com/ricardoamaro?ref_src=twsrc%5Etfw\">@ricardoamaro</a> for putting together this panel of local development tools! Some great conversation about our similarities and differences and how we can maybe work together more in the future ? <a href=\"https://twitter.com/hashtag/DrupalCon?src=hash&amp;ref_src=twsrc%5Etfw\">#DrupalCon</a> <a href=\"https://twitter.com/hashtag/DDEV?src=hash&amp;ref_src=twsrc%5Etfw\">#DDEV</a> <a href=\"https://twitter.com/randyfay?ref_src=twsrc%5Etfw\">@randyfay</a> <a href=\"https://twitter.com/Schnitzel?ref_src=twsrc%5Etfw\">@Schnitzel</a> <a href=\"https://twitter.com/Mollux?ref_src=twsrc%5Etfw\">@Mollux</a> <a href=\"https://twitter.com/teampoop?ref_src=twsrc%5Etfw\">@teampoop</a> <a href=\"https://twitter.com/FFWglobal?ref_src=twsrc%5Etfw\">@FFWglobal</a> <a href=\"https://t.co/vdmqFUJd8Z\">pic.twitter.com/vdmqFUJd8Z</a></p>— DDEV (@ddev) <a href=\"https://twitter.com/ddev/status/1189500880443322368?ref_src=twsrc%5Etfw\">October 30, 2019</a></blockquote> <script async=\"\" src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 id=\"DevOps\">Combining DevOps and emotional intelligence</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Finally, DDEV CTO Kevin Bridges and Content Creator Elli Ludwigson talked about <a href=\"https://youtu.be/nNS5pDHe-FY\">Combining DevOps and Emotional Intelligence</a> to support a remote startup team. Our key takeaways included that we’re all still learning, that tools are only part of the solution, and that we need to take the time to listen and understand what our team members are experiencing. It can feel like magic when you get it right, but there’s no “fairy dust” available to get there, just time and hard work.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2414,\"width\":512,\"height\":289,\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image is-resized\"><a href=\"https://youtu.be/nNS5pDHe-FY\"><img src=\"https://www.ddev.com/content/uploads/2019/11/Screen-Shot-2019-11-20-at-8.22.11-PM-1024x577.png\" alt=\"Hiker overlooking an impressive mountain range with arms spread. Slide text reads &quot;DevOps is not Easy.&quot;\" class=\"wp-image-2414\" width=\"512\" height=\"289\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading -->\n<h2>Want to learn more about DDEV-Live Drupal hosting?&nbsp;</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We’re winding down the year and starting to think about 2020! If you have time, we’d be very grateful for your feedback on DDEV-Live. Please <a href=\"http://ddev.com/trylive\">sign up for early access</a>, we’ve got a couple of nice thank you offers in return :)&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For in-depth questions and comments, please email us <a href=\"mailto:info@ddev.com\">info@ddev.com</a>, for DDEV-Local collaborations and conversations there’s the<a href=\"https://drupal.slack.com/messages/C5TQRQZRR\"> #ddev channel in Drupal Slack</a>, and please join us on <a href=\"https://twitter.com/ddev\">Twitter: #DDEV @Drud</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"http://eepurl.com/gFfwFb\">Join the DDEV mailing list</a></div>\n<!-- /wp:button -->','Introducing DDEV-Live Drupal hosting at DrupalCon','','publish','closed','closed','','introducing-ddev-live-drupal-hosting-at-drupalcon','','','2020-01-09 15:08:23','2020-01-09 22:08:23','',0,'https://www.ddev.com/?p=2409',0,'post','',0),(2410,16,'2019-11-21 15:57:15','2019-11-21 22:57:15','<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://ddev.com/ddev-live/\">   Check out DDEV-Live hosting  </a></div>\n<!-- /wp:button -->','DDEV-Live','','publish','closed','closed','','untitled-reusable-block','','','2020-11-02 15:18:08','2020-11-02 22:18:08','',0,'https://www.ddev.com/uncategorized/untitled-reusable-block/',0,'wp_block','',0),(2435,16,'2019-12-09 14:37:17','2019-12-09 21:37:17','<!-- wp:heading -->\n<h2>DDEV Drupal development to deployment demo!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Yes, we’re fans of alliteration. We’re also fans of creating a straightforward workflow for you to take a PHP project from <a href=\"https://www.ddev.com/ddev-live/\">development to deployment</a> as quickly and simply as possible. To that end, we’ve brought you DDEV-Local to get your projects started locally, and we now bring you DDEV-Live to take your projects through to production.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>At <a href=\"https://www.ddev.com/events/introducing-ddev-live-drupal-hosting-at-drupalcon/\">DrupalCon Amsterdam</a> we shared a full end-to-end workflow demo using DDEV-Local, Drupal Umami, and DDEV-Live to show you how to set up an account on our Kubernetes-based DDEV-Live platform and connect your local project via GitHub. The video includes Drupal local development environment setup, connecting to the DDEV-Live platform, and deploying your Drupal project to DDEV-Live.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {\"url\":\"https://www.youtube.com/embed/9Vbwj_TKeU8\",\"type\":\"rich\",\"providerNameSlug\":\"embed-handler\",\"responsive\":true,\"className\":\"wp-embed-aspect-16-9 wp-has-aspect-ratio\"} -->\n<figure class=\"wp-block-embed is-type-rich is-provider-embed-handler wp-block-embed-embed-handler wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\nhttps://www.youtube.com/embed/9Vbwj_TKeU8\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:heading -->\n<h2>DDEV-Live cloud hosting early access sign-up</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>When you’re done watching the deployment workflow demo, sign up at <a href=\"https://www.ddev.com/try-live/\">ddev.com/trylive</a> to give it a spin yourself and send us your feedback. By trying out the platform as an early access user you are helping to fine-tune the most important features and functions of the future platform for everyone, including future-you! Your comments will be integrated as we receive them to continuously improve the platform, <em>and</em> we have a couple of offers on hand in exchange for your time. Thank you :)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','Drupal deployment workflow on DDEV','','publish','closed','closed','','drupal-deployment-workflow-on-ddev','','','2021-01-18 11:19:08','2021-01-18 18:19:08','',0,'https://www.ddev.com/?p=2435',0,'post','',0),(2446,11,'2019-12-17 10:09:03','2019-12-17 17:09:03','<!-- wp:paragraph -->\n<p><a href=\"http://ddev.com/ddev-local\">DDEV-Local\'s</a> first official third-party service was Apache Solr, and lots of people have used it successfully over the years. But I never actually took the time to explore what was going on, and to support people who are having trouble it\'s best if you actually understand the context :) Since I had to do a deep dive into <a href=\"https://ddev.readthedocs.io/en/stable/users/extend/additional-services/#apache-solr\">DDEV\'s Solr setup</a> recently, here are some of the things I learned. I was mostly focused on Drupal 8, but many of the things I learned are applicable to any DDEV (or other Docker-based) Solr environment.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This will be a Drupal 8-specific Solr setup, but the fundamentals can be applied to any CMS.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Many, many of the problems people have with Solr are a result of our highly advanced copy/paste culture :) I\'m going to go into minor detail about the component parts here because I think you have to understand at least a little bit about each one.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://lucene.apache.org/solr/\">Apache Solr</a> is a famous search-indexing and search platform written in Java and based on Apache Lucene. Its jobs are to 1) take content given to it and create a search index so key words and phrases can find particular content and 2) tell clients how to find something using that search index.</li><li><a href=\"https://hub.docker.com/_/solr/\">Docker Solr</a> is the official Docker Hub Solr image. It is provided in many versions. I\'m only discussing v8 (current) in this article. There\'s a <a href=\"https://github.com/docker-solr/docker-solr\">Docker Solr github repo</a> and a super-important <a href=\"https://github.com/docker-solr/docker-solr/blob/master/README.md\">README</a>. You probably can\'t understand what\'s going on in any docker-compose setup that uses Docker Solr if you don\'t read that README.</li><li>Drupal 8\'s <a href=\"https://www.drupal.org/project/search_api\">Search API</a> module is the generic search approach used by most Drupal sites. Solr is the most popular backend for search_api module.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>The big-picture job that we have to do with Solr and DDEV-Local (with <em>any</em> CMS type) is to add a Solr server and configure its datasets.  Then the CMS itself has to be configured to talk to the Solr server.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For Drupal 8, the <a href=\"https://www.drupal.org/project/search_api_solr\">Search API Solr</a> module adds the Solr piece to Search API module. It has very explicit <a href=\"https://git.drupalcode.org/project/search_api_solr/blob/8.x-3.x/INSTALL.md\">installation instructions</a> on how to set up Solr and configure it, but they assume a bare-metal Solr server, rather than docker-solr.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>DDEV-Local\'s strategy is to use a single-core Docker Solr in a docker-compose.solr.yaml file, so I\'ll walk through what I learned there piece by piece.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Some assumptions:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>The name of the core we\'ll use is \"dev\". That\'s referred to throughout the configuration</li><li>There is a single core. It\'s named \"dev\" :)</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>DDEV-Local Solr Big Picture</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>Add a .ddev/docker-compose.solr.yaml that sets up Docker Solr</li><li>Add the .ddev/solr/solr_configupdate.sh script to cause Solr configuration to be re-read on each <code>ddev restart</code>.</li><li>Add the Solr configuration files into .ddev/solr/conf</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Drupal 8 and Module Setup</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>In the interest of starting from scratch, I\'ll start with a completely clean Drupal 8 project. I\'m doing this in a project and directory called \"d8solr\", so URLs will look like <code>https://d8solr.ddev.site.</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Based on the regular <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#drupal-8-quickstart\">Drupal 8 quickstart</a>, modified with instructions from search_api_solr concerning Symfony\'s event-dispatcher that may not be required in the long run, we\'ll do a:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Composer install</li><li>Basic quick <code>drush si</code> of Drupal 8</li><li>Enable the search_api_solr module with drush</li><li>Add the docker-compose.solr.yaml</li><li>Add .ddev/solr/solr_configupdate.sh to automatically update the Solr config when it changes</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">ddev composer create drupal/recommended-project:~8.8.0 \nddev composer require symfony/event-dispatcher:\\\"4.3.4 as 3.4.35\\\" drupal/search_api_solr ddev config --project-type=drupal8 --docroot=web\nddev composer create drupal/recommended-project:~8.8.0\nddev composer require symfony/event-dispatcher:\\\"4.3.4 as 3.4.35\\\" drupal/search_api_solr\nddev config --project-type=drupal8 --docroot=web\n\n#\n# Quick-install Drupal\'s demo_umami profile and enable search_api_solr\nddev exec drush si demo_umami --db-url=mysqli://db:db@db/db --account-name=admin --account-pass=admin\nddev exec drush en -y search_api_solr\n\n#\n# Get the docker-compose.solr.yaml\ncd .ddev &amp;&amp; curl -O https://raw.githubusercontent.com/ddev/ddev/master/pkg/servicetest/testdata/TestServices/docker-compose.solr.yaml\n\n#\n# Add the solr-configupdate.sh script\nmkdir -p solr/conf\ncd solr &amp;&amp; rm -rf solr-configupdate.sh &amp;&amp; curl -O https://raw.githubusercontent.com/ddev/ddev/master/pkg/servicetest/testdata/TestServices/solr-configupdate.sh &amp;&amp; chmod +x solr-configupdate.sh\nddev restart\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>Now I can go to the Search API configuration at /admin/config/search/search-api (https://d8solr.ddev.site/admin/config/search/search-api in my case). There I have to take these steps based on the <a href=\"https://git.drupalcode.org/project/search_api_solr/blob/8.x-3.x/INSTALL.md\">search_api_solr INSTALL directions:</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Click \"Add server\"</li><li>The server name is descriptive rather than important here. Call it \"ddev_solr\"</li><li>Use the \"standard\" Solr connector</li><li>Use the \"http\" protocol</li><li>The \"solr host\" should be <strong>\"solr\"</strong> NOT the default \"localhost\". It\'s the name of the \"host\" running the solr server inside docker-land, and its hostname is \"solr\" with the docker-compose.solr.yaml we\'re using</li><li>The \"solr core\" <strong>must be named \"dev\"</strong> unless you are going to customize the docker-compose.solr.yaml</li><li>Under \"Advanced server configuration\" set the \"solr.install.dir\" to <code>/opt/solr</code></li><li>After you\'ve clicked \"Save\", download the config.zip provided on /admin/config/search/search-api/server/dev (or create it using <code>ddev exec drush solr-gsc ddev_solr /tmp/config.zip</code>)</li><li>Unzip the config.zip into .ddev/solr/conf. For example, ddev ssh and then <code>cd /var/www/html/ddev/solr/conf &amp;&amp; unzip ~/Downloads/solr_8.x-config.zip</code></li><li><code>ddev restart</code></li><li>It\'s now time to create a search index. On /admin/config/search/search-api (my <a href=\"https://d8solr.ddev.site/en/admin/config/search/search-api\">https://d8solr.ddev.site/en/admin/config/search/search-api</a>), click \"Add index\", give a name to the index, and check at least \"Content\" for indexing. Choose the \"ddev_solr\" server for the index. After clicking \"Save\" you can choose to do the indexing immediately. (<code>ddev exec drush sapi-i</code> is another way to do this.)</li><li>At this point, you should be able to access the dev core at http://&lt;project>.ddev.site:8983/solr/#/~cores/dev where you\'ll see that numDocs is 36 (or something related to the number of nodes in your project)</li><li>In addition, https://&lt;project>.ddev.site/admin/config/search/search-api/server/ddev_solr should show some of the same information.</li><li>To re-index, you can use the web UI to \"delete all indexed data\" and then reindex, or <code>ddev exec \"drush sapi-sc ddev_solr &amp;&amp; drush sapi-i\"</code></li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Resources</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>DDEV-Local\'s <a href=\"https://ddev.readthedocs.io/en/latest/users/extend/additional-services/#apache-solr\">regular Solr documentation</a> has been updated to match this tutorial. It\'s slightly less verbose than this blog post and tries to be a bit less Drupal-oriented.</li><li>DDEV-Local\'s suggested <a href=\"https://github.com/ddev/ddev/blob/master/pkg/servicetest/testdata/TestServices/docker-compose.solr.yaml\">starter docker-compose.solr.yaml</a> configuration file has been updated with more comments and hopefully a predictable usage.</li><li>@mglaman\'s <a href=\"https://glamanate.com/blog/using-multiple-solr-cores-ddev\">writeup on multiple Solr cores</a> explains that subject. It does require a more in-depth understanding of docker-solr.</li><li><a href=\"https://github.com/docker-solr/docker-solr\">Docker Solr repository</a>, <a href=\"https://hub.docker.com/_/solr/\">Docker Hub</a>, <a href=\"https://github.com/docker-solr/docker-solr/blob/master/README.md\">README</a>, <a href=\"https://github.com/docker-solr/docker-solr/blob/master/scripts/solr-precreate\">solr_precreate script</a></li><li>For TYPO3 Solr support, an approach using TYPO3\'s Solr extension is in <a href=\"https://github.com/ddev/ddev-contrib\">ddev-contrib</a>, <a href=\"https://github.com/ddev/ddev-contrib/tree/master/docker-compose-services/typo3-solr\">TYPO3-specific Apache Solr Integration for DDEV-Local</a>.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-very-dark-gray-color has-luminous-vivid-amber-background-color has-text-color has-background\" href=\"http://eepurl.com/gFfwFb\">Sign up for the DDEV Newsletter</a></div>\n<!-- /wp:button -->','Apache Solr with Drupal 8 and Search API Solr','','publish','closed','closed','','apache-solr-with-drupal-8-and-search-api-solr','','','2021-02-16 09:40:43','2021-02-16 16:40:43','',0,'https://www.ddev.com/?p=2446',0,'post','',0),(2467,16,'2019-12-23 11:20:29','2019-12-23 18:20:29','We are attending <strong>Drupal Camp Florida</strong> as Platinum Sponsors, 21-23 February, 2020! Join us to connect with the Drupal community, chat about DevOps and hear what we\'ve been up to. Florida DrupalCamp is an annual conference that brings together web developers from all over the world to learn, network and discuss web development and the Drupal content management system.\r\n\r\n<strong>What:</strong>\r\n<ul>\r\n 	<li>DDEV CTO Kevin Bridges will be presenting an intro level DevOps session: <a href=\"https://www.fldrupal.camp/sessions/beginner-track/devops-and-emotional-intelligence-taking-next-step\">DevOps and Emotional Intelligence: Taking that next step</a>\r\n<ul>\r\n 	<li><span class=\"field-content session-room\">Room: Auditorium</span> <span class=\"field-content session-slot\">11:30am to 12:15pm</span></li>\r\n</ul>\r\n</li>\r\n 	<li>We\'ll have a table in the hallway with some small swag, tips and tricks for local development and the latest from our DDEV-Live hosting platform.</li>\r\n 	<li>Florida Drupal Camp organizer Mike Anello is also the author of <a href=\"https://www.ostraining.com/books/local/\">Local Web Development With DDEV Explained</a>, which has a new edition coming out this winter! Stay tuned for more about that.</li>\r\n 	<li><a href=\"https://www.fldrupal.camp/conference/contribution-day\">Contribution time</a>!\r\n<ul>\r\n 	<li>Afternoon of Sunday, February 23</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>When</strong>: Friday, 21 February- Sunday, 23 February 2020\r\n\r\n<strong>Where</strong>: Florida Technical College, 12900 Challenger Parkway Orlando, Florida 32826\r\n\r\n<strong>Registration</strong>: <a href=\"https://www.fldrupal.camp/\">https://www.fldrupal.camp/</a>\r\n\r\n<strong>Who Attends</strong>: All who are interested in or active participants using Drupal; from site builders to content &amp; digital marketers to those selling and supporting Drupal.','Drupal Camp Florida 2020','We are attending Drupal Camp Florida as Platinum Sponsors, 21-23 February, 2020!','publish','closed','closed','','drupal-camp-florida-2020','','','2020-10-19 18:56:25','2020-10-20 00:56:25','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2467',0,'tribe_events','',0),(2476,20,'2020-01-09 14:30:38','2020-01-09 21:30:38','<!-- wp:paragraph -->\n<p>Last autumn we began early access trials of our DDEV-Live <a href=\"https://www.ddev.com/ddev-live/drupal-deployment-workflow-on-ddev/\">cloud hosting platform</a> for a small group of users in order to collect feedback and build out features together. DDEV-Live is the culmination of years of experience and experimentation amidst maturing technologies and changing landscapes in open source. Our mission is to deliver tools that give you access to powerful new technology like Kubernetes with full control over the level of complexity that is right for you to help you advance as a modern developer.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The first users of DDEV-Live generously spent time with us via calls and written feedback to share their thoughts and reactions to the experience. The unique perspectives of each of our early access users have provided material for systematic improvements to the platform as well as making the user experience the best it can be. Following every early access trial the DDEV engineering team has examined the input, plotted out where it fits in the roadmap, and tackled components that are critical to the widest audience to start.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you are interested in joining the early access trials, <a href=\"https://www.ddev.com/trylive/\">please sign up on this form</a>. Once we’ve connected, we’ll also make a donation to an open source project of your choice to pass on the good will!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>One comment we heard a lot is quite a compliment: “you’re doing for Kubernetes what you did for Docker with DDEV-Local.” A special thank you to all you <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a> users who have given so much feedback, contributions, and support to our <a href=\"http://github.com/ddev/ddev\">open source local development tool</a>. We are strong believers in continuing the culture of collaboration and mentorship in everything we do to support you in your own work. <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a> is a growing platform, and it needs your input to help us deliver what you need. Here’s some of what we’ve done so far thanks to feedback from the Drupal community:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Documentation: helping you help yourself</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>For a completely new platform like DDEV-Live, it’s necessary that we do some extra explaining around new processes, terms, and commands. Our early access users are a particularly curious and ambitious bunch who voraciously consumed both the getting started guides and command line help, really exploring the extent of the platform’s capabilities. Everyone helped to identify documentation gaps, steps to clarify, and some areas where we determined that changing the overall command structure would be the most effective solution.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The system aims to be as friendly, logical, and straightforward as possible so that when you log in you can use commands in a way that feels familiar. There’s a lot of functionality available in the back-end of the platform that we are exposing via the Command Line Interface (CLI), so you’ll see more updates as those features are released to users. For example, additional commands or scripts in the remote environment, such as Drush for Drupal, are available via `ddev-live exec`, much like in DDEV-Local. While we’re building out user-facing documentation, many of these answers and pointers can be found in the FAQ section of the dashboard once you sign up.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Getting started</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The process for getting started is a bit different from what you may be used to, and includes installing a GitHub App as well as the DDEV-Live CLI. We designed DDEV-Live to be accessed via our CLI tool in order to bring platform functionality directly to developers before fully developing a graphical user interface. One early access user mentioned that CLI-first design is a big plus for developers who want a direct connection to the platform without hunting for the newest button.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For macOS users, we’re very pleased to have added the DDEV-Live CLI to Homebrew, so setup is much easier and requires fewer steps (one step!). Package manager support will come soon for Linux and Windows users, as well. This eliminates the need to adjust your $PATH variable and other terminal settings, making the process more universal and simple.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Additionally, we first gave options for setting some defaults when you got started, but this turned out to be confusing for users who weren’t familiar with some of the terminology. In order to reduce the amount of repetitive typing required to get your work done on the platform, we introduced setting your “default org” as a first step. That makes it easy for you to reference when running commands, and for all of us in subsequent documentation steps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Pushing your project to DDEV-Live</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We changed how the platform handles assets – both database and files – &nbsp;when uploading a new project as well as when executing backups and regular syncing to work locally. To make this easier on you, we restructured the logic of asset push and pull to mimic the `mv` command you are likely familiar with. As a result, you can move your assets precisely where you want them according to your usual workflows, rather than working with the platform’s assumptions based on your project type (so far we’ve primarily been testing with Drupal users).&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Currently, DDEV-Live offers manual backups of your data. Users were quick to request automated backups in the trial as well, so the ability to set or unset automation is coming in the next CLI release. Your data is critically important, and with this additional functionality you can control your data backups to meet your needs or your client’s needs.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Flexibility is another key feature of DDEV-Live, and it will manifest in a wide variety of ways. Integration with other version control systems like GitLab and Bitbucket was frequently mentioned in user feedback and is in our roadmap. GitHub is the first option because it is the most commonly used and offered a quick way to get started.&nbsp;We designed DDEV to work well with CI/CD integration, which has struck the interest of several larger agencies who could especially benefit from this level of flexibility.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Early access users have also been interested in the installability of the platform. Giving you the ability to control the exact location (i.e., cloud, in-house hardware, etc.) of your data is a central part of our mission. <a href=\"https://www.ddev.com/contact/\">Please get in touch with us</a> if this is something you or your organization are interested in so we can work together to set our roadmap priorities.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Coming soon</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We’ve been adding in additional support for TYPO3 CMS projects and have successfully launched several internally, as well as working with a TYPO3 expert to define additional needs before sending a release to <a href=\"https://www.ddev.com/ddev-local/using-ddev-to-teach-open-source-web-development/\">the very enthusiastic TYPO3 community</a>. Thank you all especially for your eagerness to start using DDEV-Live; we’re committed to bringing you the reliable and robust experience you’ve come to expect from DDEV.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Several early access users mentioned functionality they’re familiar with in DDEV-Local, namely being able to set configuration and then take that configuration to another instance, or in this case, to DDEV-Live. For example, more fine-grained control over PHP versions is in the roadmap for the next round of feature updates.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Another wishlist item was for an interactive command line similar to `ddev config` for DDEV-Local, which walks a user through several set-up steps to set or confirm basic configuration. This early access user said, “[an interactive command line] is less scary for my junior devs,” which is exactly what we’re aiming for – simplicity and approachability so that everyone can get the benefits of modern infrastructure without being cloud architects.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Real, live, cloud-hosting with DDEV</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>For these early access customers DDEV-Live is not hosting production sites. However, we did launch our first employee site into production and I’m pleased to announce that <a href=\"https://randyfay.com\">randyfay</a><a href=\"https://randyfay.com/ddev-live\">.com</a> is the first live website on DDEV-Live! Thank you to Randy (maintainer of DDEV-Local) for all of your feedback and support for users throughout the DDEV platform. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Thank you to all who took the time to try out DDEV-Live so far! We’re eager to release access to a wider audience this year, but if you would like to try it out in the meantime, please <a href=\"http://ddev.com/trylive\">sign up</a>, log in, and sit down to chat with us.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>By trying out the platform as an early access user you are helping to identify and fine-tune the most important features and functions for everyone. Your comments will be integrated as we receive them to continuously improve the platform. In exchange for your time, we are also offering to make a donation to an open source project of your choice when you share your feedback!&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Your expertise will be critical to building an effective and essential tool so all DDEV users can harness the capabilities of the modern web. Thank you, and I look forward to hearing from you!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','How DDEV-Live users contribute to our cloud hosting platform','','publish','closed','closed','','how-ddev-live-users-contribute-to-our-cloud-hosting-platform','','','2020-10-15 18:38:41','2020-10-16 00:38:41','',0,'https://www.ddev.com/?p=2476',0,'post','',0),(2507,16,'2020-01-23 11:08:14','2020-01-23 18:08:14','We are sponsoring and speaking at <strong>Drupal Camp London </strong>March 13-15, 2020! <a href=\"https://drupalcamp.london/our-sponsors\">DDEV are Diamond Sponsors</a> this year to support the CxO summit and weekend event for Drupal business leaders and users of all sorts.\r\n\r\nFind recordings of the entire event [free!] on <a href=\"https://www.youtube.com/channel/UCsaB96zszIP4Y3czs-ndiIA\">Drupal Camp London YouTube</a> or <a href=\"http://drupal.tv/curated-playlists\">Drupal.tv</a>.\r\n\r\n<b>What we’re up to:</b>\r\n<ul>\r\n 	<li><a href=\"https://drupalcamp.london/schedule/cxo\">CxO day: Taming Complexity to Champion Creativity</a>\r\n<ul>\r\n 	<li>DDEV CTO Kevin Bridges</li>\r\n 	<li>Friday at 14:00</li>\r\n 	<li><a href=\"https://youtu.be/y5_7NxZnGVE\">Watch the recording here</a>.</li>\r\n</ul>\r\n</li>\r\n 	<li style=\"font-weight: 400;\"><a href=\"https://drupalcamp.london/saturday-keynote\"><span style=\"font-weight: 400;\">Keynote: DevOps and Emotional Intelligence</span></a>\r\n<ul>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">DDEV CTO Kevin Bridges</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Saturday 09:30-10:30 in the Main Hall and livestreamed!</span></li>\r\n 	<li><a href=\"https://youtu.be/WtPQYCMfBfY\">Watch the recording here</a>.</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://drupalcamp.london/session/auto-updates-update\">Session: Auto updates, an update!</a>\r\n<ul>\r\n 	<li>David Stoline, Director of Global Product</li>\r\n 	<li>Saturday 14:00 - 14:45 room b200</li>\r\n 	<li><a href=\"https://youtu.be/ZkxraI-oUE0\">Watch the recording here.</a></li>\r\n</ul>\r\n</li>\r\n 	<li>Don\'t forget about <a href=\"https://drupalcamp.london/get-involved/contribute\">contribution time</a>!\r\n<ul>\r\n 	<li>Saturday (10:50 - 17:00) and Sunday (10.50-14:00)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<b>When</b><span style=\"font-weight: 400;\">: 13-15 March, 2020</span>\r\n\r\n<b>Where</b><span style=\"font-weight: 400;\">: </span>\r\n<em>CxO Day:</em>\r\nCCT Venues-Smithfield\r\nTwo East Poultry Avenue\r\nSmithfield, London, EC1A 9PT\r\n\r\n<em>Drupal Camp:</em>\r\nUniversity Building\r\nCity, University of London\r\nNorthampton Square\r\nLondon EC1V 0HB\r\n\r\n<b>Registration</b><span style=\"font-weight: 400;\">: <a href=\"https://drupalcamp.london/tickets\">https://drupalcamp.london/tickets</a></span>\r\n\r\n<b>About the event</b><span style=\"font-weight: 400;\">: Drupal Camp London offers the opportunity for learning from your peers, connecting with new contacts, sharing your own experiences and of course working on open source contributions. </span>','Drupal Camp London 2020','We are sponsoring and speaking at Drupal Camp London March 13-15, 2020!','publish','closed','closed','','drupal-camp-london-2020','','','2020-10-19 18:56:51','2020-10-20 00:56:51','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2507',0,'tribe_events','',0),(2514,16,'2020-01-27 08:41:36','2020-01-27 15:41:36','<span style=\"font-weight: 400;\">We\'re looking forward to the brand new experience of DrupalCon Global this July! There\'s a lot we\'re hoping to offer you in summer 2020, so please stay tuned to this page for updates on sessions we are presenting, special event offers, as well as DDEV news and updates to our platform! </span>\r\n\r\n<b>What we’re up to:</b>\r\n<ul>\r\n 	<li style=\"font-weight: 400;\"><a href=\"https://events.drupal.org/global2020/sessions/local-development-environments-panel-discussion\">Local development environments panel discussion</a>\r\n<ul>\r\n 	<li>Join DDEV-Local maintainer Randy Fay, local environments expert Jeff Geerling, and Docksal master Blanca Esqueda on a panel moderated by Ricardo Amaro. We\'ll discuss the local development options available, why so many tools have moved towards Docker, and where the future may lie.</li>\r\n 	<li>Jul 15, 15:15 - Jul 15 16:00 UTC</li>\r\n 	<li><a href=\"https://vimeo.com/showcase/7303843/video/441097561\">Initial recording (password protected for event attendees)</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://events.drupal.org/global2020/sessions/volunteer-led-strategies-helping-drupal-community\">Volunteer-led strategies for helping the Drupal community</a>\r\n<ul>\r\n 	<li>DDEV communications/marketing manager <a href=\"https://ddev.com/author/elli/\">Elli Ludwigson</a> is a member of the Drupal Diversity and Inclusion (DDI) Leadership Team and joins this panel with Tara King, Alanna Burke, and Ruby Sinreich to discuss how everyone can help make the Drupal community a welcoming and equitable open source space.</li>\r\n 	<li>July 14, 2020 21:15-22:00 UTC</li>\r\n 	<li><a href=\"https://vimeo.com/showcase/7303843/video/441107325\">Initial recording (password protected for event attendees)</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://events.drupal.org/global2020/sessions/drupal-initiatives-plenary\">Drupal Initiatives Plenary</a>\r\n<ul>\r\n 	<li>Elli will also be presenting on Drupal Core Mentoring during this keynote time. Various Drupal initiative leads will be speaking about the work their teams are doing and how you can get involved contributing to Drupal.</li>\r\n 	<li>July 15, 13:15-14:00 UTC</li>\r\n 	<li><a href=\"https://vimeo.com/showcase/7303843/video/441091467\">Initial recording (password protected for event attendees)</a></li>\r\n</ul>\r\n</li>\r\n 	<li style=\"font-weight: 400;\"><a href=\"https://events.drupal.org/global2020/program/contribution-events\"><span style=\"font-size: 1rem;\">Contribution time!</span></a>\r\n<ul>\r\n 	<li>Be sure to stay tuned in through Friday at DrupalCon so you can get started contributing! Working together on hard problems is why we are so passionate about open source.</li>\r\n 	<li>We\'ll be using <a href=\"https://contrib2020.getopensocial.net/all-groups\">OpenSocial</a> to host a free virtual contribution day. Anyone familiar with Drupal is welcome to help mentor, anyone who otherwise wants to contribute but isn\'t sure how is welcome to join for a first time contributors workshop.\r\n<ul>\r\n 	<li>Join DDEV Product Director <a href=\"https://ddev.com/author/dstoline/\">David Stoline</a> for <a href=\"https://contrib2020.getopensocial.net/group/autoupdates-initiative/about\">contributions to the AutoUpdates Initiative</a></li>\r\n 	<li>Help <a href=\"https://contrib2020.getopensocial.net/group/new-contributor-guide/about\">build a new Contributor Guide on Drupal.org</a> to replace the Getting Involved Guide! Elli will be helping out in this group as well.</li>\r\n 	<li>For new contributors, please join the First Time Contributors group to get started and meet mentors and others.</li>\r\n</ul>\r\n</li>\r\n 	<li>If you\'d like to get a head start with a local development environment, our <a href=\"http://ddev.com/ddev-local\">DDEV-Local tool</a> is available, just follow the <a href=\"https://ddev.readthedocs.io/en/stable/#installation\">DDEV installation steps. </a>Usually at IRL DrupalCons we use <a href=\"http://drupal.org/tools\">drupal.org/tools</a> and the <a href=\"https://github.com/ddev/quicksprint/releases\">Quicksprint package</a> for a more one-size-fits-all approach that takes conference wifi bandwidth into account, but this time we\'re all on our own internet connections! Please do consider downloading and getting set up in advance regardless, hop into the <a href=\"https://drupal.slack.com/archives/C5TQRQZRR\">#ddev channel in Drupal Slack</a> for troubleshooting.</li>\r\n 	<li>First Time Contributor Workshops will happen twice during the week, times and dates TBA.</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<b>When</b><span style=\"font-weight: 400;\">: 14-17 July 2020</span>\r\n\r\n<b>Where</b><span style=\"font-weight: 400;\">: Online!</span>\r\n\r\n<b>Registration</b><span style=\"font-weight: 400;\">: <a href=\"https://events.drupal.org/global2020/ticket-faq\">https://events.drupal.org/global2020/ticket-faq</a></span>\r\n\r\n<b>About the event</b><span style=\"font-weight: 400;\">: DrupalCon is the largest gathering of Drupal users and stakeholders in the world. We get together to share knowledge and experience, connect with old friends and new, and of course contribute back to Drupal as an open source project. </span>\r\n\r\n&nbsp;','DrupalCon Global 2020','We\'re looking forward to the brand new experience of DrupalCon Global this July!','publish','closed','closed','','drupalcon-global-2020','','','2020-10-19 19:03:51','2020-10-20 01:03:51','',0,'https://www.ddev.com/?post_type=tribe_events&#038;p=2514',0,'tribe_events','',0),(2519,16,'2020-01-27 08:41:36','2020-01-27 15:41:36','','Minneapolis Convention Center','','publish','closed','closed','','minneapolis-convention-center-2','','','2020-01-27 08:41:36','2020-01-27 15:41:36','',0,'https://www.ddev.com/?post_type=tribe_venue&#038;p=2519',0,'tribe_venue','',0),(2521,16,'2020-01-27 08:41:36','2020-01-27 15:41:36','','Minneapolis Convention Center','','publish','closed','closed','','minneapolis-convention-center-3','','','2020-01-27 08:42:33','2020-01-27 15:42:33','',0,'https://www.ddev.com/venue/minneapolis-convention-center-3/',0,'tribe_venue','',0),(2527,16,'2020-01-30 14:57:57','2020-01-30 21:57:57','<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"http://eepurl.com/gFfwFb\">Sign up for the latest news and releases</a></div>\n<!-- /wp:button -->','DDEV Newsletter','','publish','closed','closed','','untitled-reusable-block-2','','','2020-01-30 14:58:57','2020-01-30 21:58:57','',0,'https://www.ddev.com/uncategorized/untitled-reusable-block-2/',0,'wp_block','',0),(2571,11,'2020-03-25 13:48:59','2020-03-25 19:48:59','<span style=\"font-weight: 400;\">Sometimes as the releases go by not everybody ends up noticing new features in <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a>. People liked it the</span><a href=\"https://www.ddev.com/ddev-local/eight-more-ways-to-get-the-most-out-of-ddev-local/\"> <span style=\"font-weight: 400;\">last time</span></a><span style=\"font-weight: 400;\"> we did a \"remember these simple new features\" article, so here comes another one:</span>\n<ol>\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\"><strong>Built-in docs</strong>: Never forget you can just type <code>ddev</code> (which shows all available commands) and <code>ddev help &lt;command&gt;</code>. Those are generally faster than searching the docs any time.</span></li>\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\"><strong><code>ddev launch</code></strong> is pretty nifty. It works on most platforms, and opens a web browser to the current project. You can also add a URI, like <code>ddev launch /admin/reports/status/php</code></span></li>\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\"><strong><code>ddev snapshot</code></strong> does a very fast save of your database. I like to use it with a name, for example <code>ddev snapshot --name=before_phase2_upgrade</code> so that I can remember what in the world it was about (and use <code>ddev restore-snapshot before_phase2_upgrade</code> to restore it). Otherwise it just gets a date/timestamp (</span><a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#snapshotting-and-restoring-a-database\"><span style=\"font-weight: 400;\">docs</span></a><span style=\"font-weight: 400;\">).</span></li>\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\"><strong><code>ddev mysql</code></strong> launches the mysql client in the db container and lets you interact with it, so you can do anything you might usually do with mysql. And you don\'t need to have the mysql client installed on your local machine. I mostly use the interactive mode, but also with <code>ddev mysql -uroot -proot</code> to use root privileges, or <code>echo \"SHOW TABLES;\" | ddev mysql</code></span></li>\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\"><strong><code>ddev share</code></strong> is a wonderful way to show off your work to a collaborator or client. You just need</span><a href=\"https://ngrok.com/\"> <span style=\"font-weight: 400;\">ngrok</span></a><span style=\"font-weight: 400;\"> (even without a login, even without a paid account) and you can <a href=\"https://www.ddev.com/ddev-local/sharing-a-ddev-local-project-with-other-collaborators/\">look at your project together</a> with somebody else anywhere in the world.</span></li>\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\"><strong>HTTPS</strong>: Are you getting the most out of DDEV-Local\'s HTTPS support? It was the most popular feature of 2019 in our</span><a href=\"https://www.ddev.com/ddev-local/vote-for-your-favorite-new-ddev-local-development-environment-features/\"> <span style=\"font-weight: 400;\">recent survey</span></a><span style=\"font-weight: 400;\"> about favorite features. Run <code>ddev poweroff &amp;&amp; mkcert -install</code> and you\'ll have trusted local https URLs in most browsers (and the HTTP urls still work fine too).</span></li>\n 	<li><strong>NFS</strong>: If you\'re on macOS or Windows and not yet using NFS to mount files into the container, you\'ll find it provides better performance by quite a bit, and also provides more consistent server-like behavior than Docker mounts do on macOS or Windows. See the <a href=\"https://ddev.readthedocs.io/en/stable/users/performance/\">docs</a>.</li>\n 	<li><strong>Custom Commands</strong> are amazingly easy to create. Does your team have a workflow that isn\'t built into DDEV-Local? Add a <a href=\"https://ddev.readthedocs.io/en/stable/users/extend/custom-commands/\">custom command </a>- it\'s just a simple shell script. The <a href=\"https://github.com/ddev/ddev-contrib\">ddev-contrib</a> repository has a number of <a href=\"https://github.com/ddev/ddev-contrib#custom-command-examples\">custom command examples</a> as well.</li>\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\"><strong>Updating</strong>: Are you updating DDEV-Local the easy way? Homebrew for macOS and Linux and Chocolatey for Windows make it pretty painless. <code>ddev poweroff &amp;&amp; brew upgrade ddev</code>, <code>ddev poweroff &amp;&amp; choco upgrade -y ddev</code> Recommended! (</span><a href=\"https://ddev.readthedocs.io/en/stable/#installation\"><span style=\"font-weight: 400;\">docs</span></a><span style=\"font-weight: 400;\">) (Note that we also maintain the ddev-bin AUR repository for ArchLinux/Manjaro users).</span></li>\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\"><strong>FAQ</strong>: Have you glanced at the</span><a href=\"https://ddev.readthedocs.io/en/stable/users/faq/\"> <span style=\"font-weight: 400;\">FAQ</span></a><span style=\"font-weight: 400;\"> lately? We\'d love to hear about new things you would like to see there or anywhere in our docs, just hit us up on</span><a href=\"https://ddev.readthedocs.io/en/stable/#support\"> <span style=\"font-weight: 400;\">any of our support channels</span></a><span style=\"font-weight: 400;\">.</span></li>\n</ol>\n<span style=\"font-weight: 400;\">Take a look at my own</span><a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#favorite-commands\"> <span style=\"font-weight: 400;\">favorite commands</span></a><span style=\"font-weight: 400;\"> and see if you\'re using them all. Is there anything we should add there? <a href=\"http://twitter.com/ddev\">Give us a shout on Twitter!</a></span>','Ten more ways to increase your efficiency with DDEV-Local','','publish','closed','closed','','ten-more-ways-to-increase-your-efficiency-with-ddev-local','','','2020-03-25 13:49:00','2020-03-25 19:49:00','',0,'https://www.ddev.com/?p=2571',0,'post','',0),(2575,11,'2020-03-17 13:03:27','2020-03-17 19:03:27','<!-- wp:paragraph -->\n<p>Even though <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a> is intended for local development on a single machine, not as a public server, there are a number of reasons you might want to expose your work in progress more broadly:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Testing with a mobile device</li><li>Sharing on a local network so that everybody on the local network can see your project</li><li>Some CI applications</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>There are at least three different ways to share a running DDEV-Local project outside the local developer machine:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li><code>ddev share</code> (using ngrok to share over the internet)</li><li>Local name resolution and sharing the project on the local network</li><li>Sharing just the http port of the local machine on the local network</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2><strong>1. Using <code>ddev share</code> to share project (easiest)</strong></h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><code>ddev share</code> proxies the project via <a href=\"http://ngrok.com\">ngrok</a>, and it\'s by far the easiest way to solve the problem of sharing your project with others on your team or around the world. It\'s built into ddev and \"just works\" for most people, even people who don\'t sign up for a paid ngrok account. All you do is run <code>ddev share</code> and then give the resultant URL to your collaborator or use it on your mobile device. <a href=\"https://www.drupaleasy.com/blogs/ultimike/2019/06/sharing-your-ddev-local-site-public-url-using-ddev-share-and-ngrok\">Read the basic how-to from DrupalEasy</a> or run <code>ddev share -h</code> for more.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>There are CMSs that make this a little harder, especially WordPress and Magento 2. Both of those only respond to a single base URL, and that URL is coded into the database, so it makes this a little harder. For both of these I recommend paying ngrok the $5/month for a<a href=\"https://ngrok.com/pricing\"> basic plan</a> so you can use a stable subdomain with ngrok.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4><strong>Setting up a stable subdomain with ngrok</strong></h4>\n<!-- /wp:heading -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Get a paid token with at least the basic plan, and configure it. (It will be in ~/.ngrok2/ngrok.yml as authtoken.</li><li>Configure ngrok_args to use a stable subdomain. In .ddev/config.yaml, ngrok_args: --subdomain wp23 will result in ngrok always using \"wp23.ngrok.io\" as the URL, so it\'s not changing on you all the time.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4><strong>WordPress: Change the URL with wp search-replace</strong></h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>WordPress only has the one base URL, but the wp command is built into DDEV-Local\'s web container.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This set of steps assumes an ngrok subdomain of \"wp23\" and a starting URL of \"<a href=\"https://wordpress.ddev.site\">https://wordpress.ddev.site</a>\".</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Configure .ddev/config.yaml to use a custom subdomain: <code>ngrok_args: --subdomain wp23</code></li><li>Make a backup of your database with <code>ddev export-db</code> or <code>ddev shapshot</code></li><li>Edit wp-config-ddev.php (or whatever your config is) to change WP_HOME, for example, <code>define(\'WP_HOME\', \'[&lt;https://wp23.ngrok.io&gt;](&lt;https://wp23.ngrok.io/&gt;)\');</code></li><li><code>ddev ssh</code></li><li><code>wp search-replace [&lt;https://wordpress.ddev.site&gt;](&lt;https://wordpress.ddev.site/&gt;) [&lt;https://wp23.ngrok.io&gt;](&lt;https://wp23.ngrok.io/&gt;)</code><br>(assuming your project is configured for<a href=\"https://wordpress.ddev.site\"> https://wordpress.ddev.site</a> and your ngrok_args are configured for the wp23 subdomain)</li><li>Now <code>ddev share</code></li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4><strong>Magento2: Change the URL with magento tool</strong></h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>This set of steps assumes an ngrok subdomain \"mg2\"</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Configure .ddev/config.yaml to use a custom subdomain: <code>ngrok_args: --subdomain mg2</code></li><li>Make a backup of your database.</li><li>Edit your .ddev/config.yaml</li><li><code>ddev ssh</code> and</li><li><code>bin/magento setup:store-config:set --base-url=\"[&lt;https://mg2.ngrok.io/&gt;](&lt;https://mg2.ngrok.io/&gt;)\"</code></li><li><code>ddev share</code> and you\'ll see your project on mg2.ngrok.io</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2><strong>2. Using xip.io and or your own name resolution and open up to the local network</strong></h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The second solution is to <em>not</em> use *.ddev.site as your project URLs, but to use DNS that you control (and that points to the host machine where your project lives). In general you\'ll want to use http URLs with this approach, because it requires manual configuration of the client machine to get it to trust the development certificate that ddev uses (and configures with mkcert on the local machine).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Use <a href=\"http://xip.io/\">xip.io</a> to point a domain name to your host.  If your computer\'s IP address is 192.168.5.101, you can use a domain name like mysite.192.168.5.101.xip.io and that domain name will point to your computer. Now add that as an additional_fqdn to your project, <code>ddev config --additional-fqdns=mysite.192.168.5.101.xip.io</code> and <code>ddev start</code>. Now people in your internal network should be able to <code>ping mysite.192.168.5.101.xip.io</code> if your firewall allows it. (Note that if you have other convenient ways to create a DNS entry for this, you can use those instead of using xip.io.)</li><li>Configure ~/.ddev/global_config.yaml to bind to all ports:<code> ddev config global --router-bind-all-interfaces &amp;&amp; ddev poweroff &amp;&amp; ddev start</code></li><li>Now mobile apps or other computers which are on your <em>local</em> network should be able to access your project. Use the http URL rather than the https URL because computers outside yours don\'t know how to trust the developer TLS certificate you\'re using. (You can use <code>ddev describe</code> to see the http URL, but it\'s typically the same as the https URL, but with \"http\" instead of \"https\".)</li><li>Make sure your firewall allows access from your local network to the main interface you\'re using. In the example here you should be able to ping 192.168.5.101 and <code>curl [&lt;http://192.168.5.101&gt;](&lt;http://192.168.5.101&gt;)</code> and get an answer in each case.</li><li>If you\'re using WordPress or Magento 2 you\'ll need to change the base URL as described in the <code>ddev share</code> instructions above.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2><strong>3. Exposing just a port from the host</strong></h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>DDEV-Local\'s web container also exposes an HTTP port directly (in addition to the normal routing by name and via ddev_router). You can expose this port and it may be a useful approach in some situations.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Add a docker-compose.localnet.yaml to your project\'s .ddev directory. This example will expose HTTP on port 8080:<br><code>version: \'3.6\' </code><br><code>services: </code><br>  <code>web: </code><br>    <code>ports: </code><br>    <code>- \"0.0.0.0:8080:80\" </code><br>    <code>- \"0.0.0.0:8443:443\"</code></li><li><code>ddev start</code></li><li>Make sure your firewall allows access to the port on your host machine.</li><li>If you\'re using WordPress or Magento 2 you\'ll need to change the base URL as described in the <code>ddev share</code> instructions above.</li><li>Each site on your computer must use different ports or you\'ll have port conflicts, and you can\'t typically use ports 80 or 443 because ddev-router is already using those for normal routing.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Computers and mobile devices on your local network should now be able to access port 8080, on the (example) host address 192.168.5.23, so<a href=\"http://192.168.5.23:8080\"> http://192.168.5.23:8080</a>. You\'ll probably want to use the http URL your coworker\'s browser will not trust the developer TLS certificate you\'re using.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>What next?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Find us and other DDEV community experts via one of our <a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">support channels</a>. <br>Take a look around the <a href=\"http://github.com/ddev/ddev\">project on GitHub</a> and feel free to contribute! <br>Please <a href=\"http://eepurl.com/gFfwFb\">sign up for our mailing list</a> or follow along on <a href=\"http://twitter.com/ddev\">Twitter</a> for the latest news. </p>\n<!-- /wp:paragraph -->','DDEV share: Sharing a DDEV-Local project with other collaborators in real time','','publish','closed','closed','','sharing-a-ddev-local-project-with-other-collaborators','','','2020-12-02 15:16:59','2020-12-02 22:16:59','',0,'https://www.ddev.com/?p=2575',0,'post','',0),(2596,11,'2020-04-03 11:12:29','2020-04-03 17:12:29','<!-- wp:paragraph -->\n<p><em>Updated 2020-12-07</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://github.com/ddev/ddev\">DDEV-Local</a> provides lots and lots of flexibility for you in managing your databases between your local development, staging and production environments. Most people know about <code>ddev import-db</code> and <code>ddev export-db</code> but those tools now have more flexibility and there are plenty of other adaptable ways to work with your databases.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Remember, you can run <code>ddev [command] --help</code> for more info on many of the topics below.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Many database backends</strong>: You can use a vast array of different database types, including MariaDB from 5.5 through 10.4 and MySQL from 5.5 through 8.0 (<a href=\"https://ddev.readthedocs.io/en/stable/users/extend/database_types/#database-server-types\">docs</a>). Note that if you want to <em>change</em> database type, especially to downgrade, you need to export your database and then <code>ddev delete</code> the project (to kill off the existing database), make the change to a new db type, start again, and import.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Default database</strong>: DDEV-Local creates a default database named \"db\" and default permissions for the \"db\" user with password \"db\", and it\'s on the (inside Docker) hostname \"db\".</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Extra databases</strong>: In <a href=\"https://github.com/ddev/ddev/releases\">DDEV-Local v1.13+</a> you can easily create and populate other databases as well. For example, <code>ddev import-db --target-db=backend --src=backend.sql.gz</code> will create the database named \"backend\" with permissions for that same \"db\" user and import from the backend.sql.gz dumpfile.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Exporting extra databases</strong>: You can export in the same way: <code>ddev export-db -f mysite.sql.gz</code> will export your default database (\"db\"). <code>ddev export-db --target-db=backend -f backend-export.sql.gz</code> will dump the database named \"backend\".</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Database snapshots</strong>: With <em>snapshots</em> you can easily save the entire status of all of your databases. It\'s great for when you\'re working incrementally on migrations or updates and want to save state so you can start right back where you were. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I like to name my snapshots so I can find them later, so <code>ddev snapshot --name=two-dbs</code> would make a snapshot named \"two-dbs\" in the .ddev/db_snapshots directory. It includes the entire state of the db server, so in the case of our two databases above, both databases and the system level \"mysql\" database will all be snapshotted. Then if you want to delete everything with <code>ddev delete -O</code> (omitting the snapshot since we have one already), and then <code>ddev start</code> again, we can <code>ddev restore-snapshot two-dbs</code> and we\'ll be right back where we were.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>ddev mysql</strong>: <code>ddev mysql</code> gives you direct access to the mysql client in the db container. I like to use it for lots of things because I like the command line. I might just <code>ddev mysql</code> and give an interactive command like <code>DROP DATABASE backend;</code>. Or <code>SHOW TABLES;</code>. You can also do things like <code>echo \"SHOW TABLES;\" | ddev mysql or <code>ddev mysql -uroot -proot</code></code> to get root privileges.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>mysql client in containers</strong>: Both the web and db containers have the mysql client all set up and configured, so you can just <code>ddev ssh</code> or <code>ddev ssh -s db</code> and then use <code>mysql</code> however you choose to.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>mysqldump</strong>: The web and db containers also have <code>mysqldump</code> so you can use it any way you want inside there. I like to <code>ddev ssh</code> (into the web container) and then <code>mkdir /var/www/html/.tarballs</code> and <code>mysqldump db &gt;/var/www/html/.tarballs/db.sql</code> or <code>mysqldump db | gzip &gt;/var/www/html/.tarballs/db.sql.gz</code> (Because /var/www/html is mounted into the container from your project root, the .tarballs folder will also show up in the root of the project on the host.)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Other database explorers</strong>: There are lots of alternatives for GUI database explorers:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>macOS users love <code>ddev sequelpro</code>, which launches the free Sequelpro database browser. However, it\'s gotten little love in recent years, so ddev now supports TablePlus and SequelAce if they\'re installed. <code>ddev tableplus</code> and <code>ddev sequelace</code>.</li><li><code>ddev describe</code> database browser (Hint: It\'s <code>http://&lt;yourproject>.ddev.site:8036</code>).</li><li>PHPStorm (and all JetBrains tools) have a nice database browser: <ul><li>Choose a static <code>host_db_port</code> for your project. For example <code>host_db_port: 59002</code> (each project\'s db port has to be different). (<code>ddev start</code> to make it take effect)</li><li>Use the \"database\" tool to create a source from \"localhost\", with type \"mysql\" and the port you chose, credentials username: db and password: db</li><li>Explore away! </li></ul></li><li>There\'s a sample custom command that will run the free <a href=\"https://dev.mysql.com/downloads/workbench/\">mysqlworkbench</a> GUI database explorer on macOS, Windows or Linux. You just have to: <ul><li><code>cp .ddev/commands/host/mysqlworkbench.example .ddev/commands/host/mysqlworkbench &amp;&amp; chmod +x .ddev/commands/host/mysqlworkbench</code> </li><li>and then <code>ddev mysqlworkbench</code></li></ul></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>What are your favorite DDEV-Local database tweaks, hacks, approaches, strategies? We\'d love to hear about them <a href=\"https://twitter.com/ddev\">on Twitter</a> (<a href=\"https://twitter.com/hashtag/ddev?src=hashtag_click\">tag #ddev</a>) or any of our <a href=\"https://ddev.readthedocs.io/en/stable/#support\">support channels</a>. Join the conversation!</p>\n<!-- /wp:paragraph -->','DDEV-Local Database Management','','publish','closed','closed','','ddev-local-database-management','','','2020-12-07 07:25:55','2020-12-07 14:25:55','',0,'https://ddev.com/?p=2596',0,'post','',0),(2600,11,'2020-04-07 09:50:11','2020-04-07 15:50:11','<!-- wp:paragraph -->\n<p>Did you know that you can customize <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a> Docker images with some very simple changes? We talked about <a href=\"https://www.ddev.com/ddev-local/ddev-local-web-container-customization-in-v1-8-0/\">web container customization</a> a little with the release of DDEV-Local 1.8.0, and now we\'re back with more details!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>There are two major ways to customize your DDEV-Local web image, but they\'re <em>mutually incompatible</em>:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Add a Debian package into the image with <code>webimage_extra_packages</code> (<a href=\"https://ddev.readthedocs.io/en/stable/users/extend/customizing-images/#adding-extra-debian-packages-with-webimage_extra_packages-and-dbimage_extra_packages\">docs</a>).</li><li>Add an \"extension\" Dockerfile with free-form instructions for adding onto the container (<a href=\"https://ddev.readthedocs.io/en/stable/users/extend/customizing-images/#adding-extra-dockerfiles-for-webimage-and-dbimage\">docs</a>).</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3><code>webimage_extra_packages</code> in config.yaml</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The simplest thing to do is just add new Debian packages. For example, add to the .ddev/config.yaml: <code>webimage_extra_packages: [redis-tools, php-yaml]</code>, and the \"redis-tools\" and \"php-yaml\" packages will be installed in the web container. This little addition to the container happens just once, and doesn\'t slow down your <code>ddev start</code> after that.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Simple npm install with custom Dockerfile</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Sometimes, though, people need to do things that are not just Debian apt package management changes. For example, you might want to override a configuration file with a replacement, or you might want to use npm to install something that is not managed with Debian\'s package system.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This kind of change can be done by creating a <code>.ddev/web-build/Dockerfile</code> (start by copying <code>.ddev/web-build/Dockerfile.example</code>).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>So, for example, if you have a <code>.ddev/web-build/Dockerfile</code> with these contents:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><code>ARG BASE_IMAGE<br>FROM $BASE_IMAGE<br>RUN npm install --global gulp-cli</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Then the <code>npm install</code> to install gulp-cli will be done (once) at build time.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em><strong>Note that the default to BASE_IMAGE is overridden by ddev at image build time, so does not have to be maintained as versions of ddev-webserver change</strong></em>, so \"ddev/ddev-webserver:v1.13.1\" is just a filler.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Modifying configuration files</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>If you want to add files or override configuration files, it\'s easy enough to do. For example, in this<a href=\"https://stackoverflow.com/questions/60162842/how-can-i-add-basic-authentication-to-the-mailhog-service-in-ddev-local\"> Stack Overflow question</a>, a user wanted to put basic authentication in front of the Mailpit configuration. The easiest way to do this is to override the /etc/supervisor/conf.d/mailhog.conf. So as that answer suggests:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Put the new mailhog.conf and mailhog-auth.txt into the <code>.ddev/web-build</code> directory.</li><li>Add a Dockerfile to .ddev/web-build that uses the Docker build ADD command to put them into place:<br><code>ARG BASE_IMAGE<br>FROM $BASE_IMAGE ADD mailhog-auth.txt /etc<br>ADD mailhog.conf /etc/supervisor/conf.d</code></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>(Caveat: This strategy only works in <a href=\"https://github.com/ddev/ddev/releases\">DDEV-Local v1.13+</a>)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>But you could use this same technique for so many things. Do you need to completely override the /etc/php/7.3/fpm/php-fpm.conf file? Do it. Do you need to completely revamp the entire nginx configuration directory? Now you can do it. You can also add scripts into the container or even Linux binaries. And you can check the whole thing into your project so that other members of your team automatically have it.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>pip3 installs</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The Python world uses <a href=\"https://pip.pypa.io/en/stable/\">pip3</a> to install packages, and you can do that too.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This <a href=\"https://stackoverflow.com/a/60683558/215713\">Stack Overflow answer</a> goes into the details, but this Dockerfile should be a start:<br><code>ARG BASE_IMAGE<br>FROM $BASE_IMAGE<br>RUN apt-get update &amp;&amp; DEBIAN_FRONTEND=noninteractive apt-get install -y -o Dpkg::Options::=\"--force-confnew\" --no-install-recommends --no-install-suggests python3-pip python3-setuptools<br>RUN pip3 install mycli</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>pecl/pear installs</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Some PHP packages aren\'t available as Debian packages, so this <a href=\"https://stackoverflow.com/a/60554990/215713\">Stack Overflow answer</a> shows how to install a package from the PEAR repository using a custom Dockerfile:<br><code>ARG BASE_IMAGE<br>FROM $BASE_IMAGE<br>ENV PHP_VERSION=7.3<br>RUN apt-get update &amp;&amp; DEBIAN_FRONTEND=noninteractive apt-get install -y -o Dpkg::Options::=\"--force-confnew\" --no-install-recommends --no-install-suggests gcc make autoconf libc-dev pkg-config php-pear php${PHP_VERSION}-dev libmcrypt-dev<br># The \"echo\" below just forces accepting the \"automatic\" configuration, the same as hitting &lt;RETURN><br>RUN echo | sudo pecl install mcrypt<br># Because php7.1-mcrypt is already installed in web container we can just copy its mcrypt.ini<br>RUN cp /etc/php/7.1/mods-available/mcrypt.ini /etc/php/${PHP_VERSION}/mods-available/ &amp;&amp; phpenmod mcrypt</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Join the conversation!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We\'d love to hear about your recipes! PR them into <a href=\"http://github.com/ddev/ddev-contrib\">ddev-contrib</a>, or tweet, or blog about them. Give us a holler when you do with <a href=\"http://twitter.com/ddev\">@ddev and #DDEV</a> on Twitter. And we\'re always happy to hear from you on any of our<a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\"> support channels.</a></p>\n<!-- /wp:paragraph -->','Customizing DDEV-Local images with a custom Dockerfile','','publish','closed','closed','','customizing-ddev-local-images-with-a-custom-dockerfile','','','2020-04-08 11:57:03','2020-04-08 17:57:03','',0,'https://ddev.com/?p=2600',0,'post','',0),(2632,11,'2020-04-16 12:18:19','2020-04-16 18:18:19','<!-- wp:paragraph -->\n<p>One <a href=\"http://github.com/ddev/ddev\">DDEV-Local</a> feature that lots of people love is DDEV\'s creation and management of CMS-specific settings files. This makes starting and installing a new project a breeze, and is a fantastic time-saver for many users. People can follow one of the many DDEV-Local <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#quickstart-guides\">Quickstart Guides</a> and have a project up and installed in no time.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To make this happen, DDEV-Local does a quite a bit of settings management for explicitly supported CMSs. DDEV will:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Create a main settings file if none exists (like Drupal or Backdrop\'s settings.php).</li><li>Create a specialty config file with DDEV-specific settings (like AdditionalSettings.php for TYPO3 or settings.ddev.php for Drupal).</li><li>Add an include of the specialty file if needed (like adding settings.ddev.php include to the bottom of settings.php for Drupal.</li><li>Create additional common configs as needed (like drush.yml for Drupal).</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>This really helps new users and people who are kicking the tires on a CMS. Plus it\'s helpful for many developers in their regular workflow. However, there are plenty of you who have sophisticated team and project workflows and don\'t want DDEV-Local to manage settings files, or prefer to manage your own. DDEV has always tried to give you control as needed:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>If you don\'t want DDEV to touch a file, remove the <code>#ddev-generated</code> line from that file, empty it or put your own contents in it, and check it into version control. DDEV will then ignore that file and not try to regenerate it.</li><li>If you don\'t want DDEV to even know what kind of CMS (or other project) you have, just use <code>type: php</code> in your .ddev/config.yaml (or run <code>ddev config --project-type=php</code>). DDEV will no longer create or tweak any settings files, you\'re now on your own (The one drawback of this approach is that you don\'t get the nginx configuration which has been tweaked for your CMS. But, as always, you can create your own nginx or apache configurations.) (<a href=\"https://ddev.readthedocs.io/en/stable/users/extend/customization-extendibility/\">docs</a>).</li><li>In DDEV-Local <a href=\"https://github.com/ddev/ddev/releases\">v1.13</a> we added a community-requested feature, <code>disable_settings_management: true</code>. If you want DDEV to use the CMS-specific nginx configuration, but don\'t want it to touch anything else, you can put <code>disable_settings_management: true</code> in your .ddev/config.yaml (or run <code>ddev config --disable-settings-management</code>) and DDEV won\'t try to create any of the CMS-specific settings files.</li><li>In v1.13+ there is also an environment variable <code>$IS_DDEV_PROJECT</code> that can be used to fence off DDEV-specific behavior. For example, with <code>$IS_DDEV_PROJECT</code> empty, the important parts of settings.ddev.php and AdditionalSettings.php (for TYPO3) are not executed.&nbsp; This means that DDEV\'s settings.ddev.php won\'t be invoked if it somehow ends up in a production environment or in a non-DDEV local development environment.</li><li>The .ddev/.gitignore is created by <code>ddev start</code> because it gitignores itself. So the intention is that you can <em>not</em> check in the .ddev/.gitignore and it will be created on start <em>if</em> disable_settings_management is false. This helps teams to share .ddev folder checked in by git, even if the .ddev/.gitignore changes with different versions.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Is DDEV-Local currently missing explicit support for your CMS? So far we have many flavors of TYPO3, Drupal, Magento, and WordPress available. There are feature requests for support for <a href=\"https://github.com/ddev/ddev/issues/1988\">Shopware</a>, <a href=\"https://github.com/ddev/ddev/issues/2154\">Mautic</a>, and some others. If you\'d like DDEV-Local settings support for your CMS, <a href=\"https://github.com/ddev/ddev/issues/new/choose\">open an issue</a>, we love to hear from you!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We want DDEV-Local to meet the needs of your team and your workflow, so please continue to <a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">tell us</a> how these approaches work out for you and your team. We\'d be happy to host guest posts here on the blog from you about how your team shares projects and on-boards new team members using DDEV, or, post on your own blog and we can link to it on the DDEV community resources repo, <a href=\"http://github.com/ddev/awesome-ddev\">awesome-ddev</a>! </p>\n<!-- /wp:paragraph -->','Controlling CMS Settings Files in DDEV-Local','','publish','closed','closed','','controlling-cms-settings-files-in-ddev-local','','','2020-04-16 12:18:19','2020-04-16 18:18:19','',0,'https://ddev.com/?p=2632',0,'post','',0),(2646,11,'2020-05-04 08:36:19','2020-05-04 14:36:19','<!-- wp:paragraph -->\n<p>Updated 2021-01-25 with <a href=\"https://github.com/ddev/ddev/discussions/2740\">input from </a><a href=\"https://github.com/ops-andy\">@ops-andy</a> (thanks!)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://github.com/ddev/ddev\">DDEV-Local</a> and Docker work fine for local development on an inexpensive Chromebook!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I\'d been wanting to try out a Chromebook for DDEV-Local development for a while and I confess that I did an impulse buy on Amazon and got the 8GB<a href=\"https://www.asus.com/us/Laptops/ASUS-Chromebook-14-C425TA/\"> Asus C425</a> for $329, which is a lot less than the fancy loaded Macbook Pro I usually use. It works great, mostly because it runs pure Debian Linux in what it calls the \"Terminal\".</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Here\'s the step-by-step to set up a DDEV-Local development environment:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>In Settings→Linux (Beta) \"Turn on\" Linux.</li><li>In Linux, create a password for the username you\'ve created, <code>sudo passwd $USER</code></li><li>Install Docker for Linux as in the <a href=\"https://ddev.readthedocs.io/en/stable/users/docker_installation/#linux-installation-docker-ce\">ddev docs</a>. You\'ll be installing the <em>Debian</em> version (<a href=\"https://docs.docker.com/install/linux/docker-ce/debian/\">link</a>).</li><li>Install Linuxbrew with (<code style=\"background-color: rgb(255, 255, 255); font-size: 16px;\">/bin/bash -c \"$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install.sh)\"</code></li><li>Install ddev and docker-compose: <code>brew tap ddev/ddev &amp;&amp; brew install ddev docker-compose</code></li><li>Add your user to the \"docker\" group with <code>sudo usermod -aG docker $USER</code></li><li>Reboot the Debian container with <code>sudo reboot</code> and then open \"Terminal\" again. You should be able to <code>docker ps</code> successfully.</li><li>Allow ddev to bind to all interfaces: <code>ddev config global --router-bind-all-interfaces</code></li><li>To use a browser to visit your site, you have two options. The first is to just install a browser like Firefox or Chromium inside Linux and use the built-in X11 capabilities to use that browser.  The second is to use Chrome\'s browser; that has some problems especially with https, as described below.<ul><li>To install a browser, <code>sudo apt-get update &amp;&amp; sudo apt-get install -y chromium-browser</code>.  You\'ll also want to run <code>mkcert -install</code>. Then use the browser inside Linux.</li><li>To use the built-in Chrome browser:<ul><li>Find out the IP address of your Debian terminal with <code>ip -a | grep eth0</code>. You\'ll see something like \"inet 100.105.93.95/28 brd 100.115.92.207\" and the \"100.115.92.195\" is what you\'re after.</li><li>Install a Chrome extension like Host Switch Plus and configure it (Edit 2020-10-14: Host Switch Plus is no longer available, but <a href=\"https://chrome.google.com/webstore/detail/livehosts/hdpoplemgeaioijkmoebnnjcilfjnjdi\">Livehosts</a> may offer the same capability). Unfortunately the Chrome browser doesn\'t innately understand how to connect to the webserver running in the Debian terminal system, so we\'ll use Host Switch Plus to convert \"*.ddev.site\" to connect to 100.115.92.195 (in my case). Here\'s the configuration:</li></ul></li></ul></li></ol>\n<!-- /wp:list -->\n\n<!-- wp:image {\"id\":2681} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/04/HostSwitchPlus.png\" alt=\"Screenshot of the &quot;Host Switch Plus&quot; plugin configuration panel set as described in the preceding text. Default set to &quot;direct&quot;. Checkbox for &quot;enable&quot; selected. IP set to the IP you just grepped for and Domain set to *.ddev.site\" class=\"wp-image-2681\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Now you can create a project the normal way and get to work! This is the simple path to a Drupal 8 composer build, but there are lots of other DDEV-Local <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#quickstart-guides\">quickstart guides</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><code>mkdir -p ~/workspace/d8composer &amp;&amp; cd ~/workspace/d8composer</code></li><li><code>ddev config --project-type=drupal8 --docroot=web --create-docroot</code></li><li><code>ddev composer create drupal/recommended-project:^8</code></li><li><code>ddev launch</code> and go install it!</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Note: I haven\'t figured out a way to get Host Switch Plus to work with https port 443.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Some comments about working with the Asus Chromebook:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>It was a pleasant experience with a nice keyboard (far better than the Macbook Pro). Acceptable performance for a laptop deep in the low-cost realm. It has great battery life, even with docker running and doing lots. It has Linux (Debian Stretch), which is lovely. And it\'s nicely integrated, including default X11 support (GUI Linux apps \"just work\" and display with no effort). It has two USB-C ports (fantastic) but also a USB-A (unlike Apple!)</li><li>I have to confess I\'d probably buy a more powerful Chromebook, with more RAM and storage, if I were going to work with this for the long term; perhaps I\'d get a Pixelbook.</li><li>Mostly there\'s nothing fiddly to do. You just have a great Linux computer that works with the nice ChromeOS desktop, and the Linux is pretty much natural, standard, no hoops to jump through.</li><li>I ran into some apps that I was unsatisfied with. Slack and<a href=\"http://notion.so\"> Notion.so</a> didn\'t work well as Android apps (too slow on this computer, which also doesn\'t have a touchscreen, so not that much of a fit for Android apps.</li><li>There were some apps that I couldn\'t use at all unless I ran them in Linux. They ran fine, but Linux GUI apps just aren\'t as well-tuned as those on other platforms. I had to run PHPStorm in Linux, and Firefox or Chrome if I wanted to use https.</li><li>Of course I didn\'t have the versatility of the Mac or the predictability and wide app support of Windows. But if I were doing only web development and normal editing/daily work stuff it might just work out.</li><li>Installing PHPStorm and other Jetbrains applications on the Linux side was not very hard: <ul><li><code>sudo apt-get install libnss3</code></li><li>Download<a href=\"https://www.jetbrains.com/toolbox-app/\"> Jetbrains Toolbox for Linux</a> and install and run it, then use it to fetch and install PHPStorm. </li></ul></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Since we\'re in the era of Linux laptops with Chromebooks and WSL2, we\'ll soon be doing a full writeup on how to use DDEV-Local with WSL2. It\'s crazy fast. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Where do <em>you</em> run DDEV? If you have a unique setup, consider sharing the specs and adding a link in our <a href=\"https://github.com/ddev/awesome-ddev\">community repo</a> so others can check it out too! </p>\n<!-- /wp:paragraph -->','DDEV, Docker, Chromebook!','','publish','closed','closed','','ddev-docker-chromebook','','','2021-01-25 11:08:32','2021-01-25 18:08:32','',0,'https://ddev.com/?p=2646',0,'post','',0),(2661,20,'2020-04-30 14:23:53','2020-04-30 20:23:53','<!-- wp:paragraph -->\n<p>Being forced into workflows that don’t work for your development team is like forcing a digital nomad into a mobile data plan from the ’90s — it’s frustrating, difficult to justify, and costly. Here at DDEV, we take a developer-first approach.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We’re committed to enabling you to use the tools that make your unique workflows the most efficient. That’s why we built our dev-to-deploy solution on cloud-native principles and designed it to reliably scale — empowering enterprise-level clients and lone developers alike. To that end, <a href=\"https://www.ddev.com/xxx/\">xxx</a> easily integrates into your existing workflows as a hosting platform or additional CI/CD tool. To add even more flexibility to the equation, our dev-to-deploy solution includes a simple-to-use CLI and the ability to effortlessly switch from human readable/editable format to YAML or JSON depending on your needs.&nbsp;&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Need to quickly deploy a test site or replace existing CI/CD pipelines? Click below to read the tutorial.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://docs.ddev.com/jenkins/\">How to integrate Jenkins with DDEV-Live</a></div>\n<!-- /wp:button -->\n\n<!-- wp:heading -->\n<h2>Is Jenkins Becoming a Roadblock?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Let’s face it: Website projects and deployments are no longer simple. Odds are you’re dealing with complex digital experiences and <a href=\"https://www.ddev.com/ddev-local/ddev-v-build-it-yourself/\">custom workflows</a>. Add to that the pressure to keep up with companies that deliver software in minutes instead of days, and you’re probably already sold on <a href=\"https://devops.com/predictions-2020-how-to-make-the-case-for-adopting-ci-cd-in-your-organization/\">the case for CI/CD</a> and have incorporated a popular tool like <a href=\"https://jenkins.io/\">Jenkins</a> into an <a href=\"https://www.ddev.com/devops/tools-efficient-devops-workflow/\">efficient DevOps workflow</a>.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Jenkins itself is a phenomenal choice: It’s a powerful open source automation server that’s easily extensible — currently supported with hundreds of plugins — and has the advantage of being distributed across multiple machines to drive builds, tests, and deployments. Not to mention the advantages of automation when it comes to reducing the risk of human error.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>But connecting Jenkins to other hosting platforms can be a frustrating process. After all, poorly functioning or undocumented APIs often result in finicky connections, slow-moving support tickets, and the ensuing headaches to match. Just like that, the tool you depended on to reliably detect and locate errors in new code — allowing you to quickly move through the steps of your workflow — has suddenly become a roadblock itself.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>The DDEV Difference</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>By contrast, DDEV-Live<em> </em>just works — enabling you to perform a simple, <a href=\"https://youtu.be/PO01MX2ZE8k\">one-time setup to configure Jenkins</a> and run regular automatic deployments into DDEV-Live. No roadblocks, no learning curves, just our cloud-native/API-focused approach to add a little extra efficiency to your day. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Building on the success of <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a>, we designed DDEV-Live to be the world’s first fully-integrated dev-to-deploy hosting platform — and to advance our mission of delivering tools that give developers access to powerful new technologies, like <a href=\"https://kubernetes.io/\">Kubernetes</a>, with control over the level of complexity that makes the most sense to them. In fact, one of the major draws of<a href=\"https://www.ddev.com/ddev-live/how-ddev-live-users-contribute-to-our-cloud-hosting-platform/\"> our early access trials</a> was the flexibility offered by well-engineered CI/CD integration. With the installable DDEV-Live CLI and API token, you have the ability to easily make connections to Jenkins or other existing tools on your own.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>All you need is a fully configured account on DDEV-Live, and a Jenkins server and user with access/permissions to install new executables. From there, you’ll follow these <a href=\"https://docs.ddev.com/jenkins/\">six steps</a> to connect your CI/CD process with DDEV — allowing you to run functional tests, automatically deploy to QA, test mobile devices, and share projects with clients in a user acceptance testing (UAT) environment. Even if your client is already locked into a hosting provider, you can simply set up previews of their projects by automatically deploying a test site via Jenkins onto DDEV-Live — skipping the hassle of going all the way to production before review. A bonus: While the above tutorial uses <a href=\"https://www.drupal.org/\">Drupal</a> as an example, DDEV-Live is made for flexibility and supports a wide array of PHP applications and CMSs.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Get Started with DDEV-Live Today</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Thank you to all of you who are already using DDEV-Local — with special thanks to everyone who took the time to help us fine-tune DDEV-Live’s most important features and functions in the early access trials. We strive to constantly improve our services and stay ahead of the shifting hosting landscape. With that in mind, we’re excited to share this latest piece of the puzzle to help you save time deploying sites, instill repeatable and dependable processes into your workflow, and skip the frustrations that come with the constant need to test and debug— enabling you to increase the value provided to your clients.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To get started, click below to create an account and start your free 10 day trial of DDEV-Live. As always, your expertise is essential to helping us build the best tools we possibly can, and we welcome your feedback!&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://dash.ddev.com/\">Create your DDEV-Live account</a></div>\n<!-- /wp:button -->','Simplify Your End-to-End Workflow: Integrate DDEV-Live with Jenkins','','publish','closed','closed','','simplify-your-end-to-end-workflow-integrate-ddev-live-with-jenkins','','','2020-06-10 15:09:31','2020-06-10 21:09:31','',0,'https://ddev.com/?p=2661',0,'post','',0),(2682,11,'2020-05-13 13:47:26','2020-05-13 19:47:26','<!-- wp:paragraph -->\n<p>As Apple has ratcheted up the pressure on developers with new security requirements, we wanted the users of both <a href=\"http://ddev.com/ddev-local\">DDEV-Local</a> and <a href=\"http://ddev.com/ddev-live\">DDEV-Live</a> to have command-line tools they could depend on without macOS Catalina randomly disabling them and making life difficult. It\'s been a challenging task, with Apple first requiring code signing and then later increasing the requirement to notarization (actually submitting the binary to Apple for review).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Along the way, we noticed that we needed to do the exact same thing for our DDEV-Local and DDEV-Live binaries, and we noticed that it was getting more and more complex. So we split out the logic scripts into their own repository, <a href=\"http://github.com/ddev/signing_tools\">ddev/signing_tools</a>, and fashioned our build processes to use that for signing and notarization.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you have binaries that you need to run on macOS Catalina and above, you can use these same tools. <a href=\"https://github.com/ddev/signing_tools/blob/master/macos_sign.sh\">macos_sign.sh</a> and <a href=\"https://github.com/ddev/signing_tools/blob/master/macos_notarize.sh\">macos_notarize.sh</a> do the job shown, and can be incorporated into most any CI/CD system.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The <a href=\"https://github.com/ddev/signing_tools/blob/master/README.md\">README</a> explains all the gory details behind these tools, including Apple\'s policies. And you probably need to have a basic understanding of the big picture to use these tools successfully. But you don\'t have to write your own process!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>(We\'ve also been signing our DDEV-Local Windows binary and installer for a really long time. That was an easier process, but we expect to incorporate that process into signing_tools as well in the future.)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Both DDEV-Local and DDEV-Live stand on the shoulders of open-source giants, from Linux to Go to Lets Encrypt, there are hundreds of projects we rely on every day. We\'re happy to share one of our pieces of work to make things easier on macOS Catalina and beyond. We invite your participation in <a href=\"https://github.com/ddev/signing_tools\">signing_tools</a>, and would love to hear your experiences.</p>\n<!-- /wp:paragraph -->','Open source collaboration: signing_tools for macOS Catalina','','publish','closed','closed','','open-source-collaboration-signing-tools-for-macos-catalina','','','2020-05-14 06:17:00','2020-05-14 12:17:00','',0,'https://ddev.com/?p=2682',0,'post','',0),(2694,16,'2020-05-04 15:41:18','2020-05-04 21:41:18','','DDEV-Live Docs','','publish','closed','closed','','ddev-live-docs','','','2020-06-11 15:14:27','2020-06-11 21:14:27','',0,'https://ddev.com/?p=2694',5,'nav_menu_item','',0),(2700,20,'2020-05-05 16:51:43','2020-05-05 22:51:43','<!-- wp:paragraph -->\n<p><strong>CI/CD—continuous integration and delivery—helps your developers achieve the most (and their best), and is a faster, more reliable way of delivering code to clients. DDEV-Live integrates with your CI/CD tools of choice.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>New to CI/CD?</em> Integrate with <a href=\"https://ddev.com/ddev-live/\">DDEV-Live</a> for a scalable, sustainable future of efficient development and deployment.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>Already doing CI/CD? </em>You shouldn\'t have to change your existing CI/CD setup to suit your hosting provider (or any other vendor). With DDEV-Live, you and your team can keep using your favorite tools. We offer flexible and adaptable integration options, so you can continue delivering uninterrupted value to your customers.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>What is CI/CD?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>CI and CD are defined thus:&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><strong>CI: Continuous Integration</strong>—Automated merging and testing of development work.</li><li><strong>CD: Continuous Delivery</strong>—Automated release of (merged and tested) development work into the production environment.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>CI/CD reduces risk and increases the velocity of software delivery. \"It\'s not a particular technological setup,\" explains Steve Grandchamp, DDEV CEO, \"It\'s a whole different approach. CI/CD embodies continual, incremental changes, updates, and deployments to a particular deliverable such as a website. We assume no project is ever \'done,\' but instead in a state of constant improvement. And these small, incremental changes are faster, easier, and more reliable to deliver, making your developers much more effective.\"</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>You can put this into practice with many different tools, and developers all have their favorites. The exact setup you choose can depend on project and client requirements, as well as personal preference, and can consist of various combinations of \"point\" solutions that each solve one part of the puzzle. Your teams probably already have their favorites, such as Jenkins, CircleCI, and Travis. Ready to get started? Here is a step-by-step guide for teams to integrate one standard tool, <a href=\"https://docs.ddev.com/jenkins/\">Jenkins, with DDEV-Live</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2710} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 id=\"benefits\">The Benefits of CI/CD</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><strong>Deploy Faster More Often.</strong> Testing, merging, and deploying your work in small steps is much less risky than massive deployments. Every CI/CD solution promises this risk reduction. What’s unique about DDEV-Live’s approach is that you don’t have to switch existing tools or workflows for deploying applications. The deployment process begins when code is checked into your code repository (GitHub, Gitlab). DDEV-Live then works in concert with popular CI/CD tools such as Jenkins, CircleCI or Travis creating a way to ship safely, many times a day if necessary.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Improve your bottom line. </strong>\"If you could save just one hour per day, per developer, on a team of twenty, that\'s like getting a half-time dev more working for you for the same price,\" Steve explains. \"CI/CD can make a fixed number of dollars much more efficient, productive, and less prone to error. Not doing it—not enabling your teams with these proven tools and processes—is ignoring some low hanging fruit for cost savings. It doesn\'t make sense to me.\"</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Free your teams to work more effectively. </strong>And it\'s not only developers who are freed to concentrate on their work when operations take a back seat. Steve says, \"A web designer or front-end engineer can do more of what gets them up in the morning, which for many people isn\'t operations. That way, they\'re also delivering the most value.\"</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Shared responsibility versus single-point-of-failure. </strong>If you\'re still not too excited about CI/CD, DDEV-Live Cloud Technical Architect, Jason Roberts, has a scenario that will make you sit up and listen. \"If the engineer who performs your deployments suddenly leaves the company (or goes on vacation, extended sick leave, or gets married), could your organization continue to perform deployments and releases of new sites or features? How long would it take for you to get back up to speed?\" With CI/CD, the deployment process is automated, therefore more reliable and owned by the organization, rather than just a few individuals.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>How DDEV-Live Fits In</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We build the DDEV platform to fit our clients’ processes and tooling, not the other way around. You should not have to change the way you work to suit a particular vendor.&nbsp; Here\'s an example of how DDEV fits into a client\'s existing CI/CD setup:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2706} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/DDEV-Jenkins-workflow-1.jpg\" alt=\"A flowchart showing a dev-test-deploy workflow which incorporates DDEV-Local and DDEV-Live with Continuous Integration tools Travis and Jenkins for testing.\" class=\"wp-image-2706\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>DDEV gives your team powerful, flexible technology at every stage. It integrates into your workflows and supports the tools and systems you already use. From the DDEV-Local development environment to hosting with DDEV-Live, our tools are there to accommodate your requirements, not the other way around.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This flexibility applies to CI/CD processes, too: we support integration with many popular tools. If you\'re setting out on your CI/CD journey, you can be sure your chosen path won\'t clash with your hosting setup if you decide to integrate DDEV-Live. Because of the flexibility offered by our system, if you have existing workflows your team can set up integrations with the tools that are already working for them. This reduces their learning curve to near-zero, saving time and money. Future iterations can be rapid, smooth, and predictable, with clear and known costs.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Your CI/CD Journey</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>CI/CD, like DevOps and other modern development practices, is all about minimizing risk by taking small steps, while \"banking\" the gains by automating more and more of what you learn over time. This philosophy applies to establishing your CI/CD processes, too.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Steve has some tips for starting out or expanding your existing setup: \"Concentrate on one part of the process first, such as deploying changes you make locally to a test site where others can see it. Then repeat and refine the steps it takes to make it happen.\" Sorting through the many tools available for CI/CD purposes can be a challenge. For this, he recommends seeking recommendations from other engineers you trust and sticking to the open-source principles that have made DDEV and what we do possible. \"Search for open source tools with lots of users that recommend them,\" he says.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Start small in the beginning and experiment with different tools. Use monitoring and reporting results to get better and better over time. Every developer hour you save through automation and improved reliability is an hour that your teams can put into delivering more value. Wherever you are with CI/CD in your organization, use the tools that make you and your teams productive, efficient, and happy.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Have more questions?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Have more questions? Want to see DDEV-Live in action? Book a demo of DDEV-Live and talk with us about the benefits of integrating us into your CI/CD workflows.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://www.ddev.com/contact\">Contact DDEV</a></div>\n<!-- /wp:button -->','Bringing CI/CD to your Agency with DDEV-Live','','publish','closed','closed','','bringing-ci-cd-to-your-agency-with-ddev-live','','','2020-06-25 15:00:03','2020-06-25 21:00:03','',0,'https://ddev.com/?p=2700',0,'post','',0),(2710,16,'2020-05-05 15:00:01','2020-05-05 21:00:01','<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-very-dark-gray-color has-luminous-vivid-amber-background-color has-text-color has-background\" href=\"https://dash.ddev.com\">Free DDEV-Live trial</a></div>\n<!-- /wp:button -->','Dash 10 day trial','','publish','closed','closed','','untitled-reusable-block-3','','','2021-02-04 14:29:18','2021-02-04 21:29:18','',0,'https://ddev.com/uncategorized/untitled-reusable-block-3/',0,'wp_block','',0),(2717,16,'2020-05-07 15:30:28','2020-05-07 21:30:28','','DDEV-Live & CI/CD','','publish','closed','closed','','ci-cd','','','2020-06-10 15:20:18','2020-06-10 21:20:18','',47,'https://ddev.com/?page_id=2717',0,'page','',0),(2764,11,'2020-05-19 08:44:10','2020-05-19 14:44:10','<!-- wp:paragraph -->\n<p>Many of you allow <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a> to <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#opt-in-usage-information\">use telemetry to collect statistics</a> about DDEV usage. Thanks! We last shared these stats with you way back in <a href=\"https://ddev.com/ddev-local/ddev-local-usage-statistics-updated-2019-03-21/\">March, 2019</a>, so it\'s time for an update. Here\'s a report about usage patterns from recent months.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Operating System Usage</strong>: Because DDEV-Local <a href=\"https://ddev.readthedocs.io/en/stable/#system-requirements\">works the same</a> on macOS, Windows, and Linux, there\'s a great spread of usage there. macOS is about 60% of the usage, Linux about 22%, and Windows about 18%.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2781,\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ddev.com/content/uploads/2020/05/Local-OSes.jpg\" target=\"_blank\" rel=\"noreferrer noopener\"><img src=\"https://ddev.com/content/uploads/2020/05/Local-OSes-1024x483.jpg\" alt=\"\" class=\"wp-image-2781\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p><strong>PHP Versions:</strong> DDEV-Local supports <a href=\"https://ddev.readthedocs.io/en/stable/users/extend/customization-extendibility/#changing-php-version\">PHP versions from 5.6 through 7.4</a> - you can change it easily with <code>ddev config --php-version=7.4</code>. PHP7.2 was the DDEV default for a long time, but PHP7.3 is now the default.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2767} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/PHP-versions-relative.png\" alt=\"PHP versions\" class=\"wp-image-2767\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p><strong>CMS Project Types:</strong> TYPO3 is the most active single <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#quickstart-guides\">project type</a>, but if you add up Drupal8, Drupal7, Drupal6, and Drupal9, TYPO3 still comes out on top by just a bit. The \"php\" project type can also mask project types, as it\'s the generic type that may have any number of project types running underneath it. It looks like Magento2 is making a strong showing, having just been added in DDEV v1.13.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2768,\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ddev.com/content/uploads/2020/05/CMS-project-types.png\" target=\"_blank\" rel=\"noreferrer noopener\"><img src=\"https://ddev.com/content/uploads/2020/05/CMS-project-types.png\" alt=\"\" class=\"wp-image-2768\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":2774} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/CMS-Project-Type-combined.png\" alt=\"CMS Project Type (combined)\" class=\"wp-image-2774\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p><strong>Top Events</strong>: This chart shows the commands (<a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#executing-commands-in-containers\">exec</a>, start, stop, etc) that get used most. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2769} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/Top-events.png\" alt=\"Top events\" class=\"wp-image-2769\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p><strong>Webserver Types</strong>: About 75% of people use nginx with php-fpm, nearly 25% use apache with fpm, and a tiny fraction use the less performant apache-cgi.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2770} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/Webserver-types.png\" alt=\"Webserver types\" class=\"wp-image-2770\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p><strong>NFS Mount Enabled</strong>: For users on Windows and macOS, using <a href=\"https://ddev.readthedocs.io/en/stable/users/performance/#using-nfs-to-mount-the-project-into-the-web-container\">nfs_mount_enabled</a> enables massive webserving performance with just a quick workstation setup. It looks like just under half of projects are using <code>nfs_mount_enabled: true</code> (which can be set globally as of DDEV-Local v1.14).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2771} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/DDEVLocal-nfs_mount_enabled.png\" alt=\"DDEVLocal nfs_mount_enabled\" class=\"wp-image-2771\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p><strong>Docker Toolbox Usage (Windows):</strong> Docker Toolbox is a somewhat obsolete version of Docker that is used mostly by people with Windows 10 Home. It will be deprecated in a future version of DDEV because <a href=\"https://ddev.com/ddev-local/ddev-wsl2-getting-started/\">Windows 10 Home and Docker Desktop (with WSL2) will shortly play well together</a>, with far better performance and reliability. But it seems only 3.5% of Windows users are on Docker Toolbox, whereas it seems about 80% of the OS-specific code in DDEV is devoted to Docker Toolbox differences!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2772} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/Docker-Toolbox-Windows-Usage.png\" alt=\"\" class=\"wp-image-2772\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Again, thanks so much for using DDEV and for your many <a href=\"https://github.com/ddev/ddev/blob/master/CONTRIBUTING.md\">contributions</a> to its success, whether by sending stats, suggesting features, supporting others, or <a href=\"https://ddev.readthedocs.io/en/stable/#support\">reporting issues</a>. Thank you! </p>\n<!-- /wp:paragraph -->','DDEV-Local Usage Statistics (Updated 2020-05-18)','','publish','closed','closed','','ddev-local-usage-statistics-updated-2020-05-18','','','2020-05-26 14:59:26','2020-05-26 20:59:26','',0,'https://ddev.com/?p=2764',0,'post','',0),(2791,1,'2020-05-26 08:26:23','2020-05-26 14:26:23','<!-- wp:paragraph -->\n<p><em>This is a guest post from web developer and open source contributor </em><a href=\"https://github.com/dennisameling\"><strong>Dennis Ameling</strong></a><em>, owner of </em><a href=\"https://github.com/fits4all\"><em>fits4all</em></a><em>. Dennis also contributed this guide to the DDEV-Local documentation! Find out </em><a href=\"https://twitter.com/dennisameling\"><em>more about Dennis</em></a><em>.</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Now that WSL2 is <a href=\"https://devblogs.microsoft.com/commandline/wsl2-will-be-generally-available-in-windows-10-version-2004/\">generally available</a> as part of the Windows 10 May 2020 (2004) update, it’s time to look into running <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a> on WSL2! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Wait, what is \"WSL\" anyway? It stands for the \"Windows Subsystem for Linux\", and in version 2 it\'s a full-powered implementation of Linux inside Windows. Read more in the <a href=\"https://docs.microsoft.com/en-us/windows/wsl/\">WSL Documentation</a> and  <a href=\"https://docs.microsoft.com/en-us/windows/wsl/wsl2-faq\">WSL2 FAQ</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>All Windows 10 editions (including Windows 10 Home) support WSL2</strong>. Docker Toolbox support for DDEV will be deprecated, as we’ll move testing capacity towards WSL2. If you’re already familiar with DDEV on Windows, you might have been using <a href=\"https://ddev.readthedocs.io/en/stable/users/performance/#windows-nfs-setup\">NFS for better filesystem performance</a>. <strong>You won’t need NFS anymore once you switch to WSL2</strong>, since it provides awesome filesystem performance out of the box ?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Outline</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"#install-wsl2\">Install WSL2</a></li><li><a href=\"#install-docker\">Install Docker</a></li><li><a href=\"#install-ddev\">Install DDEV</a><ul><li><a href=\"#prepare-ssl-certificate\">Prepare SSL certificate (mkcert)</a></li><li><a href=\"#installing-the-linux-version-of-ddev\">Installing the Linux version of DDEV</a></li></ul></li><li><a href=\"#using-ddev\">Using DDEV</a></li><li><a href=\"#ddev-launch\">DDEV launch command (optional) </a></li><li><a href=\"#working-with-ides\">Working with IDEs (optional) </a><ul><li><a href=\"#vs-code\">VS Code</a><ul><li><a href=\"#xdebug-in-vs-code\">XDebug in VS Code</a></li></ul></li><li><a href=\"#phpstorm\">PhpStorm</a></li></ul></li><li><a href=\"#resources\">Resources</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:html -->\n<a name=\"install-wsl2\"></a><h2>Install WSL2</h2>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>First, we’ll have to install WSL2 on our machine. You can follow Microsoft’s <a href=\"https://docs.microsoft.com/en-us/windows/wsl/install-win10\">official instructions</a> to do this. <strong>Don’t forget to set the default WSL version to WSL2!</strong> <code>wsl --set-default-version 2</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In this example, we’ll be using Ubuntu 20.04, which you can download <a href=\"https://www.microsoft.com/store/productId/9N6SVWS3RX71\">from the Microsoft Store</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Make sure to install Ubuntu (or any other distro) <em>before</em> installing Docker, so that Ubuntu becomes the default WSL distro.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Double-check to make sure that you have installed using WSL version 2: </strong><code><strong>wsl -l -v</strong></code><strong> should show your distro as version 2. </strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<a name=\"install-docker\"></a><h2>Install Docker</h2>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>Next up is Docker Desktop, which uses the WSL2 backend by default <a href=\"https://docs.docker.com/docker-for-windows/release-notes/#docker-desktop-community-2302\">since version 2.3.0.2</a>. Go ahead and <a href=\"https://hub.docker.com/editions/community/docker-ce-desktop-windows/\">download Docker Desktop for Windows from Docker Hub</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>When you’re done, go to Docker Desktop settings &gt; Resources &gt; WSL integration &gt; enable integration for your distro (now <code>docker</code> commands will be available from within your WSL2 distro):</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2795} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/settings.png\" alt=\"\" class=\"wp-image-2795\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:html -->\n<a name=\"install-ddev\"></a><h2>Install DDEV</h2>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>We’re ready to install DDEV! <strong>Please note that there’s one gotcha here</strong>: we’ll install DDEV for Linux, <strong>not</strong> for Windows! This is because you will get the best performance when working in the Linux filesystem. Don’t go back and forth between the regular Windows side and WSL2. This is also <a href=\"https://docs.microsoft.com/en-us/windows/wsl/compare-versions#use-the-linux-file-system-for-faster-performance\">Microsoft’s recommended approach</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To make things more visual, let’s take a look at the image below. Docker + DDEV will basically be running in WSL2 and expose ports to Windows. This way, you benefit from very good (Linux-based) performance while having the convenience to access your DDEV sites from within Windows.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Make sure you put your projects in the Linux filesystem (e.g. /home/LINUX_USERNAME), <em>not</em> in the Windows filesystem (/mnt/c), for vastly superior performance.</strong> You\'ll be very, very disappointed if you put them on /mnt/c.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2794} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/diagram.png\" alt=\"\" class=\"wp-image-2794\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:html -->\n<a name=\"prepare-ssl-certificate\"></a><h3>Prepare SSL certificate (mkcert)</h3>\n<!-- /wp:html -->\n\n<!-- wp:list -->\n<ul><li>Install Chocolatey on Windows: <a href=\"https://chocolatey.org/install\">https://chocolatey.org/install</a></li><li>Open a PowerShell windows with administrator rights and run <code>choco install mkcert</code></li><li>Run <code>mkcert -install</code>. </li><li>Run <code>setx CAROOT \"$(mkcert -CAROOT)\"; If ($Env:WSLENV -notlike \"*CAROOT*\") { setx WSLENV \"CAROOT/up:$Env:WSLENV\" }</code> - this will set the CAROOT environment variable on the WSL2 side to point to the Windows CAROOT, so your Windows browser can trust sites running in WSL2.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:html -->\n<a name=\"installing-the-linux-version-of-ddev\"></a><h3>Installing the Linux version of DDEV</h3>\n<!-- /wp:html -->\n\n<!-- wp:list -->\n<ul><li>Open the Ubuntu 20.04 terminal from the Windows start menu.</li><li>Follow the <a href=\"https://ddev.readthedocs.io/en/stable/#homebrewlinuxbrew-macoslinux\">install instructions for Linux/MacOS</a> as provided in the DDEV docs. </li><li>After install, run <code>mkcert -install</code> in the Ubuntu terminal and you should see that mkcert will use your Windows CA certificates: <ul><li><code>Using the local CA at “/mnt/c/Users/YOUR_WINDOWS_USERNAME/AppData/Local/mkcert”</code></li></ul></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>That’s it! You have now installed DDEV on WSL2 ? Remember to run all <code>ddev</code> commands in your Ubuntu/WSL2 terminal, <strong>not</strong> in PowerShell/Command Prompt.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<a name=\"using-ddev\"></a><h2>Using DDEV</h2>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>Let’s try to get a DDEV site up and running using the <a href=\"https://ddev.readthedocs.io/en/latest/users/cli-usage/#wordpress-quickstart\">WordPress Quickstart</a>. The first time it might take a while for the database/webserver/etc images to download, but after that you can start new instances lightning-fast. ⚡</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>When navigating to <a href=\"https://my-wp-bedrock-site.ddev.site\">https://my-wp-bedrock-site.ddev.site</a>, we are presented with the WordPress install screen:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":2793} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/wp_install.png\" alt=\"\" class=\"wp-image-2793\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Fantastic! Even the SSL certificate works as expected. You’re now ready to start developing with DDEV on WSL2 ?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<a name=\"ddev-launch\"></a><h2>DDEV launch command (optional) </h2>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>If you want to use the <code>ddev launch</code> command, you’ll need to install xdg-utils with <code>sudo apt-get update &amp;&amp; sudo apt-get install xdg-utils</code>. After that, when you run <code>ddev launch</code> within a DDEV project directory, the site will launch in your default browser on Windows. Pretty awesome, right?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<a name=\"working-with-ides\"></a><h2>Working with IDEs (optional) </h2>\n<!-- /wp:html -->\n\n<!-- wp:html -->\n<a name=\"vs-code\"></a><h3>VS Code</h3>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>VS Code has a special integration with WSL2 in its Remote Development extension pack. This allows you to directly work in the Linux filesystem from within your IDE.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Install <a href=\"https://code.visualstudio.com/docs/remote/wsl#_getting-started\">VS Code + the Remote Development extension pack</a></li><li>Open VS Code, connect to your WSL2 distro. You can now access the file system of your Linux distro from within Windows ✨</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:image {\"id\":2814} -->\n<figure class=\"wp-block-image\"><img src=\"https://ddev.com/content/uploads/2020/05/vs-code-wsl2-windows.jpg\" alt=\"\" class=\"wp-image-2814\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:list -->\n<ul><li>If you open a terminal by going to Terminal in the top menu &gt; New terminal, you are immediately in the WSL2 environment and can run commands over there, like <code>ddev start</code>.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:html -->\n<a name=\"xdebug-in-vs-code\"></a><h4>XDebug in VS Code</h4>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>If you want to use XDebug in VS Code, make sure you set the hostname to <code>0.0.0.0</code> and set the correct <code>pathMappings</code> for DDEV. This way, you can use XDebug like you’re used to:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre>{\n    \"version\": \"0.2.0\",\n    \"configurations\": [\n        {\n            \"name\": \"Listen for XDebug\",\n            \"type\": \"php\",\n            \"request\": \"launch\",\n            \"hostname\": \"0.0.0.0\",\n            \"port\": 9000,\n            \"pathMappings\": {\n                \"/var/www/html\": \"${workspaceRoot}\"\n            }\n        },\n        {\n            \"name\": \"Launch currently open script\",\n            \"type\": \"php\",\n            \"request\": \"launch\",\n            \"program\": \"${file}\",\n            \"cwd\": \"${fileDirname}\",\n            \"port\": 9000\n        }\n    ]\n}\n</pre>\n<!-- /wp:html -->\n\n<!-- wp:html -->\n<a name=\"phpstorm\"></a><h3>PhpStorm</h3>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>PhpStorm supports WSL2 since <a href=\"https://blog.jetbrains.com/phpstorm/2019/11/phpstorm-2019-3-release/#wsl\">its 2019.3 release</a>, but the experience is not fine-tuned yet.  There are two ways to use it - you can use it as a Windows app or use the Linux version of PHPStorm inside WSL2. We\'ve got it written up for you in <a href=\"https://ddev.com/ddev-local/ddev-local-and-phpstorm-debugging-with-wsl2/\">DDEV-Local and PHPStorm Debugging with WSL2</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<a name=\"resources\"></a><h2>Resources</h2>\n<!-- /wp:html -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.docker.com/blog/docker-desktop-wsl-2-best-practices/\">Docker WSL2 Best Practices</a></li><li><a href=\"https://docs.microsoft.com/en-us/windows/wsl/\">WSL Documentation</a></li><li><a href=\"https://docs.microsoft.com/en-us/windows/wsl/wsl2-faq\">WSL2 FAQ</a></li></ul>\n<!-- /wp:list -->','DDEV ❤️ WSL2: getting started','','publish','closed','closed','','ddev-wsl2-getting-started','','','2020-07-21 15:28:14','2020-07-21 21:28:14','',0,'https://ddev.com/?p=2791',0,'post','',0),(2847,8,'2020-05-28 10:05:28','2020-05-28 16:05:28','','Documentation','','publish','closed','closed','','documentation-3','','','2020-11-03 09:40:29','2020-11-03 16:40:29','',0,'https://www.ddev.com/?p=2847',5,'nav_menu_item','',0),(2848,8,'2020-05-28 10:05:28','2020-05-28 16:05:28','','Get Started','','publish','closed','closed','','get-started','','','2020-11-03 09:40:28','2020-11-03 16:40:28','',0,'https://www.ddev.com/?p=2848',4,'nav_menu_item','',0),(2849,8,'2020-05-28 10:09:23','2020-05-28 16:09:23',' ','','','publish','closed','closed','','2849','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2849',1,'nav_menu_item','',0),(2850,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','Documentation','','publish','closed','closed','','documentation-4','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2850',2,'nav_menu_item','',0),(2851,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','Quickstart Guides','','publish','closed','closed','','quickstart-guides','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2851',3,'nav_menu_item','',0),(2852,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','PHP','','publish','closed','closed','','php','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2852',4,'nav_menu_item','',0),(2853,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','WordPress','','publish','closed','closed','','wordpress','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2853',5,'nav_menu_item','',0),(2854,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','Drupal 8','','publish','closed','closed','','drupal-8','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2854',6,'nav_menu_item','',0),(2855,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','Drupal 9','','publish','closed','closed','','drupal-9','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2855',7,'nav_menu_item','',0),(2856,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','Drupal 6 & 7','','publish','closed','closed','','drupal-6-7','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2856',8,'nav_menu_item','',0),(2857,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','TYPO3','','publish','closed','closed','','typo3','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2857',9,'nav_menu_item','',0),(2858,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','Backdrop','','publish','closed','closed','','backdrop','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2858',10,'nav_menu_item','',0),(2859,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','Magento 1','','publish','closed','closed','','magento-1','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2859',11,'nav_menu_item','',0),(2860,8,'2020-05-28 10:09:23','2020-05-28 16:09:23','','Magento 2','','publish','closed','closed','','magento-2','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2860',12,'nav_menu_item','',0),(2861,8,'2020-05-28 10:15:04','2020-05-28 16:15:04','','Products','','publish','closed','closed','','products','','','2021-02-22 12:50:16','2021-02-22 19:50:16','',0,'https://www.ddev.com/?p=2861',1,'nav_menu_item','',0),(2862,8,'2020-05-28 10:15:04','2020-05-28 16:15:04',' ','','','publish','closed','closed','','2862','','','2021-02-22 12:50:16','2021-02-22 19:50:16','',0,'https://www.ddev.com/?p=2862',4,'nav_menu_item','',0),(2863,8,'2020-05-28 10:15:04','2020-05-28 16:15:04','','DDEV-Local','','publish','closed','closed','','ddev-local','','','2021-02-22 12:50:16','2021-02-22 19:50:16','',0,'https://www.ddev.com/?p=2863',2,'nav_menu_item','',0),(2864,8,'2020-05-28 10:15:04','2020-05-28 16:15:04','','Developers','','publish','closed','closed','','developers-2','','','2021-02-22 12:50:16','2021-02-22 19:50:16','',0,'https://www.ddev.com/?p=2864',5,'nav_menu_item','',0),(2865,8,'2020-05-28 10:15:04','2020-05-28 16:15:04','','Documentation','','publish','closed','closed','','documentation-5','','','2021-02-22 12:50:16','2021-02-22 19:50:16','',0,'https://www.ddev.com/?p=2865',6,'nav_menu_item','',0),(2866,8,'2020-05-28 10:15:04','2020-05-28 16:15:04','','DDEV-Live Docs','','publish','closed','closed','','ddev-live-docs-2','','','2021-02-22 12:50:16','2021-02-22 19:50:16','',0,'https://www.ddev.com/?p=2866',7,'nav_menu_item','',0),(2867,8,'2020-05-28 10:15:04','2020-05-28 16:15:04','','DDEV-Local Docs','','publish','closed','closed','','ddev-local-docs','','','2021-02-22 12:50:17','2021-02-22 19:50:17','',0,'https://www.ddev.com/?p=2867',8,'nav_menu_item','',0),(2868,8,'2020-05-28 10:15:04','2020-05-28 16:15:04','','GitHub','','publish','closed','closed','','github','','','2021-02-22 12:50:17','2021-02-22 19:50:17','',0,'https://www.ddev.com/?p=2868',9,'nav_menu_item','',0),(2869,8,'2020-05-28 10:15:04','2020-05-28 16:15:04',' ','','','publish','closed','closed','','2869','','','2021-02-22 12:50:17','2021-02-22 19:50:17','',0,'https://www.ddev.com/?p=2869',10,'nav_menu_item','',0),(2870,8,'2020-05-28 10:15:04','2020-05-28 16:15:04','','Events','','publish','closed','closed','','events-2','','','2021-02-22 12:50:17','2021-02-22 19:50:17','',0,'https://www.ddev.com/?p=2870',11,'nav_menu_item','',0),(2871,8,'2020-05-28 10:15:04','2020-05-28 16:15:04',' ','','','publish','closed','closed','','2871','','','2021-02-22 12:50:17','2021-02-22 19:50:17','',0,'https://www.ddev.com/?p=2871',12,'nav_menu_item','',0),(2872,8,'2020-05-28 10:15:04','2020-05-28 16:15:04',' ','','','publish','closed','closed','','2872','','','2021-02-22 12:50:17','2021-02-22 19:50:17','',0,'https://www.ddev.com/?p=2872',13,'nav_menu_item','',0),(2873,8,'2020-05-28 10:16:24','2020-05-28 16:16:24','','DDEV-Local','','publish','closed','closed','','ddev-local-2','','','2020-05-28 10:16:24','2020-05-28 16:16:24','',0,'https://www.ddev.com/?p=2873',2,'nav_menu_item','',0),(2874,8,'2020-05-28 10:16:24','2020-05-28 16:16:24',' ','','','publish','closed','closed','','2874','','','2020-05-28 10:16:24','2020-05-28 16:16:24','',0,'https://www.ddev.com/?p=2874',1,'nav_menu_item','',0),(2875,8,'2020-05-28 10:20:05','2020-05-28 16:20:05','','Events','','publish','closed','closed','','events-3','','','2021-01-08 16:36:59','2021-01-08 23:36:59','',0,'https://www.ddev.com/?p=2875',1,'nav_menu_item','',0),(2876,8,'2020-05-28 10:20:05','2020-05-28 16:20:05','','GitHub','','publish','closed','closed','','github-2','','','2021-01-08 16:36:59','2021-01-08 23:36:59','',0,'https://www.ddev.com/?p=2876',2,'nav_menu_item','',0),(2877,8,'2020-05-28 10:24:56','2020-05-28 16:24:56','','DDEV-Live','','publish','closed','closed','','ddev-live','','','2020-12-01 17:30:31','2020-12-02 00:30:31','',0,'https://www.ddev.com/?p=2877',1,'nav_menu_item','',0),(2878,8,'2020-05-28 10:24:56','2020-05-28 16:24:56','','DDEV-Local','','publish','closed','closed','','ddev-local-3','','','2020-12-01 17:30:33','2020-12-02 00:30:33','',0,'https://www.ddev.com/?p=2878',5,'nav_menu_item','',0),(2879,8,'2020-05-28 10:24:56','2020-05-28 16:24:56','','Documentation','','publish','closed','closed','','documentation-6','','','2020-12-01 17:30:31','2020-12-02 00:30:31','',0,'https://www.ddev.com/?p=2879',2,'nav_menu_item','',0),(2880,8,'2020-05-28 10:24:56','2020-05-28 16:24:56','','Getting Started','','publish','closed','closed','','getting-started','','','2020-12-01 17:30:32','2020-12-02 00:30:32','',0,'https://www.ddev.com/?p=2880',3,'nav_menu_item','',0),(2881,8,'2020-05-28 10:24:56','2020-05-28 16:24:56','','Documentation','','publish','closed','closed','','documentation-7','','','2020-12-01 17:30:34','2020-12-02 00:30:34','',0,'https://www.ddev.com/?p=2881',6,'nav_menu_item','',0),(2882,8,'2020-05-28 10:24:56','2020-05-28 16:24:56',' ','','','publish','closed','closed','','2882','','','2020-12-01 17:30:34','2020-12-02 00:30:34','',0,'https://www.ddev.com/?p=2882',7,'nav_menu_item','',0),(2883,8,'2020-05-28 10:24:56','2020-05-28 16:24:56','','Favorite Commands','','publish','closed','closed','','favorite-commands','','','2020-12-01 17:30:35','2020-12-02 00:30:35','',0,'https://www.ddev.com/?p=2883',8,'nav_menu_item','',0),(2884,8,'2020-05-28 10:24:56','2020-05-28 16:24:56','','Quickstart Guides','','publish','closed','closed','','quickstart-guides-2','','','2020-12-01 17:30:35','2020-12-02 00:30:35','',0,'https://www.ddev.com/?p=2884',9,'nav_menu_item','',0),(2885,8,'2020-05-28 10:27:10','2020-05-28 16:27:10',' ','','','publish','closed','closed','','2885','','','2021-01-08 16:32:08','2021-01-08 23:32:08','',0,'https://www.ddev.com/?p=2885',1,'nav_menu_item','',0),(2886,8,'2020-05-28 10:27:10','2020-05-28 16:27:10',' ','','','publish','closed','closed','','2886','','','2021-01-08 16:32:08','2021-01-08 23:32:08','',0,'https://www.ddev.com/?p=2886',2,'nav_menu_item','',0),(2887,8,'2020-05-28 10:27:11','2020-05-28 16:27:11',' ','','','publish','closed','closed','','2887','','','2021-01-08 16:32:08','2021-01-08 23:32:08','',0,'https://www.ddev.com/?p=2887',3,'nav_menu_item','',0),(2888,8,'2020-05-28 10:27:11','2020-05-28 16:27:11',' ','','','publish','closed','closed','','2888','','','2021-01-08 16:32:09','2021-01-08 23:32:09','',0,'https://www.ddev.com/?p=2888',4,'nav_menu_item','',0),(2889,8,'2020-05-28 10:28:11','2020-05-28 16:28:11','<b>Acceptable Use Policy</b>\r\n\r\n<span style=\"font-weight: 400;\">This Acceptable Use Policy (“</span><b>AUP”</b><span style=\"font-weight: 400;\">) describes prohibited uses of the subscription services offered by Drud Technology, LLC and its affiliates (the</span><b> “Subscription Services”</b><span style=\"font-weight: 400;\">). The examples described in this AUP are not exhaustive. We may modify this AUP at any time by posting a revised version on our website or where you access the Subscription Services.  By using the Subscription Services, you agree to the latest version of this AUP. If you violate the AUP or authorize or help others to do so, we may suspend or terminate your use of the Subscription Services.</span>\r\n\r\n<b>No Illegal, Harmful, or Offensive Use or Content </b>\r\n\r\n<span style=\"font-weight: 400;\">You may not use, or encourage, promote, facilitate or instruct others to use, the Subscription Services for any illegal, harmful, fraudulent, infringing or offensive use, or to transmit, store, display, distribute or otherwise make available content that is illegal, harmful, fraudulent, infringing or offensive. Prohibited activities or content include:</span>\r\n<ul>\r\n 	<li style=\"font-weight: 400;\"><b>Illegal, Harmful or Fraudulent Activities.</b><span style=\"font-weight: 400;\"> Any activities that are illegal, that violate the rights of others, or that may be harmful to others, our operations or reputation, including disseminating, promoting or facilitating child pornography, offering or disseminating fraudulent goods, services, schemes, or promotions, make-money-fast schemes, ponzi and pyramid schemes, phishing, or pharming.</span></li>\r\n 	<li style=\"font-weight: 400;\"><b>Infringing Content.</b><span style=\"font-weight: 400;\"> Content that infringes or misappropriates the intellectual property or proprietary rights of others.</span></li>\r\n 	<li style=\"font-weight: 400;\"><b>Offensive Content.</b><span style=\"font-weight: 400;\"> Content that is defamatory, obscene, abusive, invasive of privacy, or otherwise objectionable, including content that constitutes child pornography, relates to bestiality, or depicts non-consensual sex acts.</span></li>\r\n 	<li style=\"font-weight: 400;\"><b>Harmful Content</b><span style=\"font-weight: 400;\">. Content or other computer technology that may damage, interfere with, surreptitiously intercept, or expropriate any system, program, or data, including viruses, Trojan horses, worms, time bombs, or cancelbots.</span></li>\r\n</ul>\r\n<b>No Security Violations </b>\r\n\r\n<span style=\"font-weight: 400;\">You may not use the Subscription Services to violate the security or integrity of any network, computer or communications system, software application, or network or computing device (each, a “</span><b>System</b><span style=\"font-weight: 400;\">”). Prohibited activities include:</span>\r\n<ul>\r\n 	<li style=\"font-weight: 400;\"><b>Unauthorized Access. </b><span style=\"font-weight: 400;\">Accessing or using any System without permission, including attempting to probe, scan, or test the vulnerability of a System or to breach any security or authentication measures used by a System.</span></li>\r\n 	<li style=\"font-weight: 400;\"><b>Interception.</b><span style=\"font-weight: 400;\"> Monitoring of data or traffic on a System without permission.</span></li>\r\n 	<li style=\"font-weight: 400;\"><b>Falsification of Origin.</b><span style=\"font-weight: 400;\"> Forging TCP-IP packet headers, e-mail headers, or any part of a message describing its origin or route. The legitimate use of aliases and anonymous remailers is not prohibited by this provision.</span></li>\r\n</ul>\r\n<b>No Network Abuse </b>\r\n\r\n<span style=\"font-weight: 400;\">You may not make network connections to any users, hosts, or networks unless you have permission to communicate with them. Prohibited activities include:</span>\r\n<ul>\r\n 	<li style=\"font-weight: 400;\"><b>Monitoring or Crawling.</b><span style=\"font-weight: 400;\"> Monitoring or crawling of a System that impairs or disrupts the System being monitored or crawled.</span></li>\r\n 	<li style=\"font-weight: 400;\"><b>Denial of Service (DoS).</b><span style=\"font-weight: 400;\"> Inundating a target with communications requests so the target either cannot respond to legitimate traffic or responds so slowly that it becomes ineffective.</span></li>\r\n 	<li style=\"font-weight: 400;\"><b>Intentional Interference.</b><span style=\"font-weight: 400;\"> Interfering with the proper functioning of any System, including any deliberate attempt to overload a system by mail bombing, news bombing, broadcast attacks, or flooding techniques.</span></li>\r\n 	<li style=\"font-weight: 400;\"><b>Operation of Certain Network Subscription Services. </b><span style=\"font-weight: 400;\">Operating network Subscription Services like open proxies, open mail relays, or open recursive domain name servers.</span></li>\r\n 	<li style=\"font-weight: 400;\"><b>Avoiding System Restrictions. </b><span style=\"font-weight: 400;\">Using manual or electronic means to avoid any use limitations placed on a System, such as access and storage restrictions.</span></li>\r\n</ul>\r\n<b>No E-Mail or Other Message Abuse </b>\r\n\r\n<span style=\"font-weight: 400;\">You will not distribute, publish, send, or facilitate the sending of unsolicited mass e-mail or other messages, promotions, advertising, or solicitations (like “spam”), including commercial advertising and informational announcements. You will not alter or obscure mail headers or assume a sender’s identity without the sender’s explicit permission. You will not collect replies to messages sent from another internet service provider if those messages violate this AUP or the acceptable use policy of that provider.</span>\r\n\r\n<b>Our Monitoring and Enforcement </b>\r\n\r\n<span style=\"font-weight: 400;\">We reserve the right, but do not assume the obligation, to investigate any violation of this AUP or misuse of the Subscription Services. We may:</span>\r\n<ul>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">investigate violations of this AUP or misuse of the Subscription Services; or</span></li>\r\n 	<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">remove, disable access to, or modify any content or resource that violates this AUP or any other agreement we have with you for use of the Subscription Services.</span></li>\r\n</ul>\r\n<span style=\"font-weight: 400;\">We may report any activity that we suspect violates any law or regulation to appropriate law enforcement officials, regulators, or other appropriate third parties. Our reporting may include disclosing appropriate customer information. We also may cooperate with appropriate law enforcement agencies, regulators, or other appropriate third parties to help with the investigation and prosecution of illegal conduct by providing network and systems information related to alleged violations of this AUP.</span>\r\n\r\n<b>Reporting of Violations of this AUP </b>\r\n\r\n<span style=\"font-weight: 400;\">If you become aware of any violation of this AUP, you will immediately notify us and provide us with assistance, as requested, to stop or remedy the violation. To report any violation of this AUP, please contact us at <a href=\"mailto:accounts@ddev.com\">accounts@ddev.com</a>.</span>\r\n\r\n&nbsp;','Acceptable Use Policy','','publish','closed','closed','','acceptable-use-policy','','','2020-06-03 10:52:57','2020-06-03 16:52:57','',0,'https://www.ddev.com/?page_id=2889',0,'page','',0),(2891,8,'2020-05-28 10:28:43','2020-05-28 16:28:43','<strong>THESE SUBSCRIPTION TERMS GOVERNS USE OF THE SERVICES (AS DEFINED IN THIS AGREEMENT).  THESE SUBSCRIPTION TERMS WILL BE LEGALLY BINDING WHEN YOU CLICK THE “I AGREE” BUTTON BELOW. CAREFULLY READ THIS AGREEMENT BEFORE CLICKING “I AGREE.”  YOU REPRESENT THAT YOU HAVE AUTHORITY TO ENTER INTO THIS AGREEMENT ON BEHALF OF YOUR COMPANY (OR OTHER LEGAL ENTITY).  IF YOU DO NOT HAVE SUCH AUTHORITY, OR YOU DO NOT AGREE WITH THESE SUBSCRIPTION TERMS, DO NOT CLICK THE “I AGREE” BUTTON. </strong>\r\n<h1>Subscription Services Agreement</h1>\r\nThis Subscription Services Agreement (<strong>“Agreement”</strong>) is entered into by the entity accepting this Agreement (<strong>“Customer”</strong>) and Drud Technology, LLC (<strong>“Drud”</strong>) (each, a <strong>“Party”</strong>). This Agreement is effective as of the date accepted by Customer (<strong>“Effective Date”</strong>).\r\n\r\n<strong>Definitions</strong>\r\n\r\n<strong>“Affiliate”</strong> means any company controlling, controlled by or under common control with a Party, where “control” means ownership, directly or indirectly, of the shares of a company representing fifty percent (50%) or more of the voting rights in such company.\r\n\r\n<strong>“Cloud Environment”</strong> cloud infrastructure environment selected by Drud.\r\n\r\n<strong>“Customer Content”</strong> means (a) all data submitted by Customer to Drud for processing in the Subscription Services databases and (b) Customer Confidential Information used to provision the Subscription.\r\n\r\n<strong>“Documentation”</strong> means the support policies set forth at which may be modified from time to time.\r\n\r\n<strong>“DPA”</strong> means the Customer Content Processing Addendum entered into by the Parties, if applicable.\r\n\r\n<strong> “Order”</strong> means the order detailing the Subscriptions ordered, the Subscription Term, and applicable Fees.\r\n\r\n<strong>“Software”</strong> means the Drud DDEV and Drud Hosting software.\r\n\r\n<strong>“Subscription Services”</strong> means the hosted web services using the Software provided Drud and Cloud Environment as described in the Documentation.\r\n\r\n<strong>“Subscription”</strong> means the subscription for Subscription Services acquired by Customer.\r\n\r\n&nbsp;\r\n<ol>\r\n 	<li><strong>Scope. </strong> Drud will provide the applicable Subscriptions ordered by Customer. The Subscription Services are further described in the Documentation.  Customer will comply with the Acceptable Use Policy set forth at <a href=\"https://ddev.com/acceptable-use-policy\">https://ddev.com/acceptable-use-policy</a>, as may be updated from time to time.  Customer’s use of the Cloud Environment is subject to terms presented to or made available to Customer.  Customer agrees to comply with the applicable then-current terms for such Cloud Environment.  Drud has no liability or responsibility for the Cloud Environment, including without limitation, its availability or security.  Customer acknowledges and agrees that the Cloud Environments may modify its capabilities, and Drud may adjust the Subscription Services accordingly.</li>\r\n 	<li><strong>Fees.</strong>\r\n<ul>\r\n 	<li><strong>2.1</strong> <span style=\"text-decoration: underline;\">Fees</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Customer will pay the Fees set forth in the Order.  All Fees are non-refundable, non-cancelable, and exclusive of applicable taxes.  If you choose monthly billing by credit card, you authorize a recurring monthly charge to your credit card based on the applicable fee schedule. Customer will pay Drud the applicable fees and charges for use of the Subscription Services as described in the applicable fee schedule using Customer’s credit card. For orders placed online, payments will be processed by Drud’s third-party payment processor.  Drud may increase or add new fees and charges for a Subscription Service by updating the fee schedule set forth at the Order site.  In the event that Drud changes the pricing for the Subscription Services, the fees payable by Customer will increase or decrease in accordance with any such modification upon the date specified on the applicable site. Customer acknowledges and agrees that access Fees for the Subscription Services will be due and payable in advance by credit card at the time of the Order, and usage Fees will charged in arrears to the credit card of file with Drud.  Drud may suspend provision of the Subscription Services for delinquent payments. Customer’s payment obligation will remain in effect during any such suspension. Drud may charge Customer interest at the rate of 1% per month or the highest rate permitted by law on any late payment.  Customer will not chargeback any amounts paid to Drud by credit card and will reimburse Drud for any chargeback fees associated with the foregoing.</span></li>\r\n 	<li><strong>2.2</strong> <span style=\"text-decoration: underline;\">Taxes</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Customer will pay directly any taxes arising out of this Agreement, including applicable local, state, federal and international sales taxes, value added taxes, withholding taxes, and any other taxes or duties of any kind, but excluding taxes on Drud’s net income and all employer reporting and payment obligations with respect to Drud’s personnel. If any applicable law requires Customer to withhold amounts from any payments to Drud under this Agreement, (a) Customer will effect such withholding, remit such amounts to the appropriate taxing authorities and promptly furnish Drud with tax receipts evidencing the payments of such amounts and (b) the sum payable by Customer upon which the deduction or withholding is based will be increased to the extent necessary to ensure that, after such deduction or withholding, Drud receives and retains, free from liability for such deduction or withholding, a net amount equal to the amount Drud would have received and retained absent the required deduction or withholding.</span></li>\r\n</ul>\r\n</li>\r\n 	<li><strong>Subscription Access; Restrictions.</strong>\r\n<ul>\r\n 	<li><strong>3.1 </strong><span style=\"text-decoration: underline;\">Access</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Drud will provide access to the Subscription Services to Customer solely for Customer’s business operations and subject to the restrictions set forth in this Section 3.  During the Subscription Term, Customer will make available to Drud as needed, access to Customer’s code repository for the Customer Content (as defined herein) that Drud will manage as part of the Subscription Services.  Customer is solely responsible for the development and management of such Customer Content</span></li>\r\n 	<li><strong>3.2</strong> <span style=\"text-decoration: underline;\">Requirements.</span> Customer shall: (a) use the Subscription  Services in accordance with this Agreement and all Documentation; (b) be responsible for its users’ compliance with this Agreement; (c) use commercially reasonable efforts to prevent unauthorized use of or access to the Subscription  Services or any related account or password, or any copying of the Subscription Services, and shall notify Drud immediately of any such unauthorized use, access or copying; and (d) be solely responsible for the accuracy and legality of Customer Content, the means by which it acquires and uses such Customer Content, including compliance with any regulations and laws applicable to the Customer Content (including, without limitation, privacy and data protection), and has obtained all rights in the Customer Content necessary to permit Drud’s compliance with its obligations under this Agreement.  Customer may not perform benchmarks or comparative tests or evaluations for disclosure to a third party of the Subscription Services without Drud’s prior written consent.</li>\r\n 	<li><strong>3.3 </strong><span style=\"text-decoration: underline;\">Restrictions</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Customer shall not, and shall not allow others to: (a) except as permitted by this Agreement, directly or indirectly: distribute, sell, sublicense, rent, lease, market, use or commercialize the Subscription (or any portion thereof); (b) provide the Subscription  Services on a time sharing, hosting, service provider or other similar basis; (c) circumvent or attempt to circumvent contractual usage restrictions, (d) send, store, access or authorize a third party to send, store or access spam, unlawful, infringing, obscene or libelous material, viruses, worms, time bombs, Trojan horses and other harmful or malicious code, files, scripts, agents or programs; or (e) interfere with or disrupt the integrity or performance of the Subscription  Services. </span></li>\r\n 	<li><strong>3.4 </strong><span style=\"text-decoration: underline;\">OSS</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> The Subscription  Services may include individual open source software components, each of which has its own copyright and its own applicable license conditions. Open source software is licensed to Customer under the terms of the applicable open source license conditions and copyright notices that can be found in the Documentation or other materials made available to Customer. In the event of a conflict between the licenses and restrictions set forth in this Section 3 and the terms of the open source license governing open source software, the terms of the open source software license will prevail.  </span></li>\r\n 	<li><strong>3.5</strong> <span style=\"text-decoration: underline;\">HIPAA</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span>  Customer agrees that: (i) Drud is not acting on Customer’s behalf as a Business Associate or subcontractor; (ii) the Subscription Services may not be used to store, maintain, process or transmit protected health information (“PHI”) and (iii) the Subscription Services will not be used in any manner that would require Drud, the Software, or the Subscription Services to be compliant with the Health Insurance Portability and Accountability Act of 1996, as amended and supplemented (“HIPAA”).  In the preceding sentence, the terms “Business Associate,” “subcontractor,” “protected health information” or “PHI” shall have the meanings described in HIPAA.  </span></li>\r\n 	<li><strong>3.6</strong> <span style=\"text-decoration: underline;\">Prohibited Data</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Customer agrees not to store unmasked credit card and social security data in the Subscription Services. Customer agrees that (i) Customer’s use of the Subscription Services complies with applicable requirements of the Payment Card Industry Data Security Standards, and (ii) Customer shall not disclose (and shall not require any individuals to disclose) the personal data of any individuals under the age of 18 to Drud for processing.</span></li>\r\n 	<li><strong>3.7 </strong><span style=\"text-decoration: underline;\">Privacy Policy</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span>  Customer agrees that Drud’s privacy policy set forth at <a href=\"https://ddev.com/privacy-policy\">https://ddev.com/privacy-policy</a> in incorporated herein by reference. </span></li>\r\n</ul>\r\n</li>\r\n 	<li><strong>Customer Content; Security.</strong>\r\n<ul>\r\n 	<li><strong>4.1 </strong><span style=\"text-decoration: underline;\">Processing of Customer Content</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Customer grants Drud the non-exclusive right to access and process the Customer Content for the sole purpose and only to the extent necessary to provide the Subscription Services.  Drud agrees not to use, access, disclose or process any Customer Content, except to: (i) perform the obligations permitted by Customer under this Agreement; and (ii) comply with applicable laws. As between Customer and Drud, Customer retains all right, title, and interest in and to Customer Data.</span></li>\r\n 	<li><strong>4.2 </strong><span style=\"text-decoration: underline;\">Data Protection</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> To the extent any Personal Data (as defined in the DPA) is contained in Customer Content, the parties shall enter into the Data Protection Agreement (<strong>“</strong></span><strong><span style=\"font-size: 1rem;\">DPA</span></strong><span style=\"font-size: 1rem;\"><strong>”</strong>) and the terms of such DPA shall be incorporated into this Agreement by reference.</span></li>\r\n 	<li><strong>4.3 </strong><span style=\"text-decoration: underline;\">Security</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Company will maintain commercially reasonable administrative, physical and technical safeguards and controls for the availability, security, confidentiality and integrity of Customer Content stored in the Subscription Services. Company’s security policy is set forth in the Documentation.</span></li>\r\n 	<li><strong>4.4</strong> <span style=\"text-decoration: underline;\">Aggregated Data</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Customer acknowledges and agrees that Drud may collect aggregated and anonymized statistical and other performance information related to Customer’s use of the Subscription Services, which information will not include personal information, and Drud may use such information for, among other things, Support, reporting, research, improvements to the Subscription  Services, industry collaboration, and other reasonable business purposes.</span></li>\r\n</ul>\r\n</li>\r\n 	<li><strong>Publicity and Confidentiality.</strong>\r\n<ul>\r\n 	<li><strong>5.1 </strong><span style=\"text-decoration: underline;\">Publicity</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Drud will be permitted to reference its relationship with Customer on its website, during discussions with analysts and reporters and in customer briefings and regulatory filings. Drud will comply with Customer’s publicly available trademark usage policies.</span></li>\r\n 	<li><strong>5.2 </strong><span style=\"text-decoration: underline;\">Confidential Information.</span> For purposes of this Agreement, the party disclosing Confidential Information is the <strong>“Discloser”</strong>, and the party receiving Confidential Information is the <strong>“Recipient”</strong>. Confidential Information means all information that is marked or identified as confidential or proprietary at the time of disclosure or that would be reasonably understood to be confidential based on the nature and circumstances surrounding disclosure. Confidential Information excludes information that is: (a) known to Recipient without restriction before receipt from Discloser; (b) publicly available through no fault of Recipient; (c) rightfully received by Recipient from a third party without a duty of confidentiality; or (d) independently developed by Recipient. If Confidential Information is required to be produced by law, court order, or governmental authority, Recipient must (unless legally prohibited) notify Discloser in advance and only disclose the information required.  Recipient will use Discloser’s Confidential Information only for the purposes provided and as directed by Discloser. Confidential Information may not be disclosed to any third party other than Recipient’s and its Affiliates’ employees and contractors that need to access such information for purposes consistent with this Agreement and that are subject to obligations of confidentiality to Recipient no less restrictive than the terms set forth herein. At Discloser’s request, all written, recorded, graphical, or other tangible Confidential Information, including copies, must be returned to Discloser or destroyed by Recipient. Drud will store Confidential Information in accordance with data retention policies unless a longer period is required by law. At the request of Discloser, Recipient will certify in writing that any Confidential Information not returned to Discloser has been destroyed.</li>\r\n</ul>\r\n</li>\r\n 	<li><strong>Intellectual Property.</strong>\r\n<ul>\r\n 	<li><strong>6.1 </strong><span style=\"text-decoration: underline;\">Ownership</span><span style=\"font-size: 1rem;\"><span style=\"text-decoration: underline;\">.</span> Drud will own all intellectual property and proprietary rights in the Subscription Services, Documentation, and related works, including but not limited to any modifications and derivative works of the foregoing. Customer owns all right, title, and interest in and to the Customer Content.</span></li>\r\n 	<li><strong>6.2 </strong><span style=\"text-decoration: underline;\">Customer Content License.</span> During the Subscription Term and for as long as Drud processes Customer Content, Customer grants to Drud a nonexclusive, non- transferable, royalty-free license to access, host, use, display and process Customer Content solely for the purpose authorized by Customer in connection with the Subscription Services.</li>\r\n 	<li><strong>6.3 </strong><span style=\"text-decoration: underline;\">Feedback.</span> In the event that Customer provides Drud with suggestions, enhancement requests, recommendations, proposals, documents, or other feedback (collectively, <strong>“Communications”</strong>), Customer grants Drud a royalty-free, worldwide, transferable, sub-licenseable, irrevocable, perpetual license to use, modify, and distribute such Communications in any manner without compensation to Customer or attribution of any kind.</li>\r\n</ul>\r\n</li>\r\n 	<li><strong>Warranties and Disclaimers.</strong>\r\n<ul>\r\n 	<li><strong>7.1 </strong><span style=\"text-decoration: underline;\">Service Warranty. </span> Drud warrants that Subscription Services will be performed in a professional and workmanlike manner consistent with applicable industry standards. If Customer believes there has been a breach of this warranty, Customer must notify Drud in writing promptly following delivery of such Support stating in reasonable detail the nature of the alleged breach. As Drud’s sole obligation and Customer’s exclusive remedy, Drud will to correct or re-perform, at no additional charge, any non-conforming Subscription Services. Customer represents and warrants that it and its use of the Subscription Services will at all times comply with applicable laws.</li>\r\n 	<li><strong>7.2</strong> <span style=\"text-decoration: underline;\">Warranty Disclaimer.</span> EXCEPT AS SET FORTH IN THIS AGREEMENT, TO THE MAXIMUM EXTENT PROVIDED BY APPLICABLE LAWS, THE SUBSCRIPTION SERVICES, INCLUDING ALL UPDATES, BUG FIXES, WORK AROUNDS, OR ERROR CORRECTIONS, ARE PROVIDED TO CUSTOMER “AS-IS” AND “AS AVAILABLE” WITHOUT ANY WARRANTIES OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, INTEGRATION, NON-INFRINGEMENT, TITLE, PERFORMANCE, AND ACCURACY AND ANY IMPLIED WARRANTIES ARISING FROM STATUTE, COURSE OF DEALING, COURSE OF PERFORMANCE, OR USAGE OF TRADE.  DRUD DOES NOT WARRANT THAT USE OF THE SUBSCRIPTION SERVICES WILL BE UNINTERRUPTED OR ERROR-FREE.  DRUD SHALL NOT BE LIABLE FOR DELAYS, INTERRUPTIONS, SERVICE FAILURES OR OTHER PROBLEMS INHERENT IN USE OF THE INTERNET AND ELECTRONIC COMMUNICATIONS OR FOR ISSUES RELATED TO THIRD-PARTY HOSTING PROVIDERS WITH WHOM CUSTOMER SEPARATELY CONTRACTS.  DRUD DOES NOT MAKE ANY WARRANTIES AND SHALL HAVE NO OBLIGATIONS WITH RESPECT TO THIRD-PARTY APPLICATIONS.  CUSTOMER MAY HAVE OTHER STATUTORY RIGHTS, BUT THE DURATION OF STATUTORILY REQUIRED WARRANTIES, IF ANY, SHALL BE LIMITED TO THE SHORTEST PERIOD PERMITTED BY LAW.</li>\r\n</ul>\r\n</li>\r\n 	<li><strong>Limitation of Liability.</strong>\r\n<ul>\r\n 	<li><strong>8.1 </strong>IN NO EVENT WILL DRUD OR ITS AFFILIATES BE LIABLE UNDER THIS AGREEMENT FOR ANY INDIRECT, RELIANCE, PUNITIVE, CONSEQUENTIAL, SPECIAL, EXEMPLARY, OR INCIDENTAL DAMAGES OF ANY KIND AND HOWEVER CAUSED EVEN IF DRUD HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.</li>\r\n 	<li><strong>8.2 </strong>DRUD AND ITS AFFILIATES’ AGGREGATE AND CUMULATIVE LIABILITY ARISING OUT OF OR RELATING TO THIS AGREEMENT, SUBSCRIPTION SERVICES, OR SOFTWARE INCLUDING WITHOUT LIMITATION ON ACCOUNT OF PERFORMANCE OR NON-PERFORMANCE OF OBLIGATIONS, REGARDLESS OF THE FORM OF THE CAUSE OF ACTION, WHETHER IN CONTRACT, TORT (INCLUDING WITHOUT LIMITATION NEGLIGENCE), STATUTE OR OTHERWISE WILL BE LIMITED TO DIRECT DAMAGES AND WILL NOT EXCEED THE GREATER OF (I) THE TOTAL AMOUNT OF FEES ACTUALLY PAID (OR WITH RESPECT TO CLAIMS FOR FEES DUE, PAYABLE) TO DRUD BY CUSTOMER PURSUANT TO THE ORDER GIVING RISE TO THE CLAIM DURING THE TWELVE (12) MONTHS IMMEDIATELY PRECEDING THE TIME THE CLAIM AROSE AND (II) US $100.00.</li>\r\n 	<li><strong>8.3 </strong>THE PROVISIONS OF THIS SECTION 8 ALLOCATE RISKS UNDER THIS AGREEMENT BETWEEN CUSTOMER AND DRUD AND DRUD’S FEES FOR THE SUBSCRIPTIONS REFLECT THIS ALLOCATION OF RISKS AND LIMITATION OF LIABILITY.</li>\r\n</ul>\r\n</li>\r\n 	<li><strong>Term and Termination. </strong>\r\n<ul>\r\n 	<li><strong>9.1</strong> <span style=\"text-decoration: underline;\">Term; Termination.</span> This Agreement will be in effect until all outstanding Orders have expired or has been terminated in accordance with this Agreement. Each Order will be effective for the term specified therein (<strong>“Subscription Term”</strong>). During the Subscription Term, Customer may purchase Subscriptions and such Subscriptions will be co-terminus with the then-current Subscription Term. Either party may elect not to renew an Order by providing the other party with no less than thirty (30) days’ prior written notice (which notice may be by email). Either party may terminate all Orders with immediate effect: (a) in the event that the other party breaches this Agreement and does not cure such breach within thirty (30) days following of written notice of such breach, (b) in the event that the other party ceases business, becomes insolvent or bankrupt or if a receiver, examiner, administrator or administrative receiver is appointed over any part of that party’s business or if anything analogous occurs in relation to that party under the laws of another jurisdiction, or (c) upon the institution by or against the other party of insolvency, receivership or bankruptcy proceedings in relation to such party.</li>\r\n 	<li><strong>9.2</strong> <span style=\"text-decoration: underline;\">Suspension.</span> Drud may suspend Customer’s access to the Subscription Services immediately if Drud reasonably determines that there is a risk to the Subscription Services or any third party, or that Customer’s use of the Services violates applicable laws.  Additionally, Drud may suspend access to the Subscription Services in the event that Customer makes publicly available the Subscription Services, or any component thereof.  For the avoidance of doubt, payment obligations are not suspended or terminated if Drud suspends access to the Subscription Services.</li>\r\n 	<li><strong>9.3</strong> <span style=\"text-decoration: underline;\">Effect of Termination.</span>  Upon termination of this Agreement, (i) Customer’s rights to use the Subscription Services, Software, and all Drud Marks, including any included with software, will immediately cease, and (ii) unless Customer terminates due to Drud’s material, uncured breach, all Fees will become immediately due and payable.</li>\r\n 	<li><strong>9.4</strong> <span style=\"text-decoration: underline;\">Survival.</span> Sections 2 (Fees), 3.5 (Restrictions), 4.4 (Aggregated Data), 5 (Confidentiality), 6 (Intellectual Property), 7.2 (Warranty Disclaimer), 8-11 (Limitation of Liability, Term and Termination, Indemnification, and General) and Definitions will survive the expiration or termination of this Agreement.</li>\r\n</ul>\r\n</li>\r\n 	<li><strong>Indemnification.</strong>\r\n<ul>\r\n 	<li>Customer, at its own expense, will defend or settle any third party claims, actions and demands brought by a third party against Drud or its Affiliates, arising from: (a) Customer Content; (b) Customer’s breach of Section 3.3 of this Agreement; or (c) Customer failure to comply with applicable laws, rules or regulations in its performance of this Agreement.  Customer will defend Drud from and against any claim by a third party arising from or relating to any Customer Content or any product or service offered by Customer in connection with or related to the Subscription  Services, and will indemnify and hold harmless Drud from any damages and costs awarded against Drud or agreed in settlement by Customer (including reasonable attorneys’ fees) resulting from such claim.</li>\r\n</ul>\r\n</li>\r\n 	<li><strong>General.</strong>\r\n<ul>\r\n 	<li><strong>11.1</strong> From time to time, Drud may modify this Agreement.  Unless otherwise specified by Drud, changes become effective for Customer upon renewal of the then-current Subscription Term or entry into a new Order after the updated version of this Agreement goes into effect.  Drud will use reasonable efforts to notify Customer of the changes through its website, via Customer’s account, email or other means.  Customer may be required to click to accept or otherwise agree to the modified Agreement before renewing a Subscription Term or entering into a new Order. In any event, continued use of the Subscription Services after the updated version of this Agreement goes into effect will constitute Customer’s acceptance of such updated version.</li>\r\n 	<li><strong>11.2 </strong>This Agreement and any dispute relating to, or arising out of this Agreement or its formation or termination or actions or omissions contemplated by this Agreement, will be governed by and in accordance with the laws of Delaware, without giving effect to the conflict of laws provisions. For all disputes arising out of this Agreement, the parties consent to the exclusive jurisdiction of the federal and state courts located in Denver, Colorado</li>\r\n 	<li><strong>11.3</strong> Unless otherwise specified in this Agreement, all notices will be in writing and will be mailed (via registered or certified mail, return receipt requested), delivered by a nationally recognized express courier service with the ability to track shipments, or personally delivered to the other party at the address set forth above (or at such other address as either party may designate in writing to the other party). All notices are effective upon receipt.</li>\r\n 	<li><strong>11.4</strong> This Agreement is binding on the parties to this Agreement, and nothing in this Agreement confers upon any other person or entity any right, benefit or remedy of any nature whatsoever. This Agreement is assignable by either party only with the other party’s prior written consent, which will not be unreasonably withheld. Notwithstanding the foregoing, either party may assign this Agreement to an Affiliate or as a result of a merger or a sale of all or substantially all of such party’s assets or stock without the prior approval of the other party.  There are no third-party beneficiaries to this Agreement.</li>\r\n 	<li><strong>11.5 </strong>This Agreement, including any linked terms set forth herein, together with all Orders, is the parties’ entire agreement relating to its subject and supersedes any prior or contemporaneous agreements on that subject. All amendments to this Agreement must be in writing, provided that Drud amend this Agreement at any time by posting a revised version on its website, in the customer portal, or by providing notice to Customer by email. By continuing to use the Subscription Services after the effective date of the amendment, Customer agrees to be bound by the amended Agreement.  Additionally, Drud may modify the Subscription Services, provided that Drud not materially reduce such Subscription Services during the then-current Subscription Term. Purchase orders issued by Customer will be for the sole purpose of defining quantities, prices and describing the Subscription Services to be provided under this Agreement and to this extent only are incorporated as a part of this Agreement and all other terms in purchase orders are rejected.</li>\r\n 	<li><strong>11.6 </strong>Failure to enforce any provision of this Agreement will not constitute a waiver thereof. No waiver will be effective unless it is in writing and signed by the waiving party. If a party waives any right, power, or remedy, the waiver will not waive any successive or other right, power, or remedy the party may have under this Agreement. If any provision is found to be unenforceable, it and any related provisions will be interpreted to best accomplish the unenforceable provision’s essential purpose.</li>\r\n 	<li><strong>11.7 </strong>Neither party will be liable for failures or delays in performance due to causes beyond its reasonable control, including, but not limited to, any act of God, fire, earthquake, flood, storm, natural disaster, accident, pandemic, labor unrest, civil disobedience, act of terrorism or act of government; however, the inability to meet financial obligations is expressly excluded.</li>\r\n 	<li><strong>11.8 </strong>Customer agrees to comply with all export and re-export restrictions and regulations of the Department of Commerce and any other United States or foreign agencies and authorities in connection with Customer’s use of the Subscription Services and Software.  In particular, but without limitation, the Software may not, in violation of any laws, be exported or re-exported: (1) into any U.S. embargoed country; or (2) to anyone on the U.S. Treasury Department’s list of Specially Designated Nationals or the U.S. Commerce Department’s Table of Deny Orders.  Customer represents and warrants that Customer and its Affiliates are not located in, under the control of, or a national or resident of any such country or on any such list.</li>\r\n</ul>\r\n</li>\r\n</ol>\r\n<ol>\r\n 	<li style=\"list-style-type: none;\"></li>\r\n</ol>','Subscription Services Agreement','','publish','closed','closed','','subscription-services-agreement','','','2020-06-11 15:57:36','2020-06-11 21:57:36','',0,'https://www.ddev.com/?page_id=2891',0,'page','',0),(2893,8,'2020-05-28 10:31:36','2020-05-28 16:31:36',' ','','','publish','closed','closed','','2893','','','2021-01-06 15:21:29','2021-01-06 22:21:29','',0,'https://www.ddev.com/?p=2893',1,'nav_menu_item','',0),(2894,8,'2020-05-28 10:31:36','2020-05-28 16:31:36',' ','','','publish','closed','closed','','2894','','','2021-01-06 15:21:30','2021-01-06 22:21:30','',0,'https://www.ddev.com/?p=2894',2,'nav_menu_item','',0),(2895,8,'2020-05-28 10:31:36','2020-05-28 16:31:36',' ','','','publish','closed','closed','','2895','','','2021-01-06 15:21:31','2021-01-06 22:21:31','',0,'https://www.ddev.com/?p=2895',3,'nav_menu_item','',0),(2896,8,'2020-05-28 10:31:36','2020-05-28 16:31:36','','Privacy Policy','','publish','closed','closed','','privacy-policy','','','2021-01-06 15:21:32','2021-01-06 22:21:32','',0,'https://www.ddev.com/?p=2896',4,'nav_menu_item','',0),(2927,8,'2020-05-28 11:56:02','2020-05-28 17:56:02','','GitHub','','publish','closed','closed','','github-3','','','2020-06-02 13:13:26','2020-06-02 19:13:26','',0,'https://www.ddev.com/?p=2927',13,'nav_menu_item','',0),(2929,16,'2020-05-28 15:25:52','2020-05-28 21:25:52','','','','publish','closed','closed','','2929','','','2020-05-28 15:25:52','2020-05-28 21:25:52','',0,'https://ddev.com/venue/2929/',0,'tribe_venue','',0),(2931,11,'2020-06-03 16:36:32','2020-06-03 22:36:32','<!-- wp:paragraph -->\n<p>Congratulations to the Drupal community on today\'s release of Drupal 9! It\'s another amazing milestone in the 20-year story of Drupal. <a href=\"https://www.drupal.org/about/9\">Drupal 9</a> is set up to make migration from Drupal 8 easy, and is very much an incremental step, incorporating newer versions of Symfony and modernizing Drupal with a cleaner, leaner codebase. Thank you to all the contributors of every stripe who lent their time, expertise, and enthusiasm to making and sharing Drupal 9!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Join in the worldwide Drupal 9 celebrations at <a href=\"https://celebratedrupal.org/\">Celebrate Drupal</a>. You\'ll find music and art and just a general good time connecting with Drupalists from around the world. It\'s good to see everyone :)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Ready to take Drupal 9 for a spin in a local development environment? As of today, you can start up Drupal 9 in <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a> using this simple recipe:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><code> mkdir my-drupal9-site<br> cd my-drupal9-site<br> ddev config --project-type=drupal9 --docroot=web --create-docroot<br> ddev start<br> ddev composer create \"drupal/recommended-project\"<br> ddev composer require drush/drush<br> ddev launch</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>or see the DDEV-Local docs for the <a href=\"https://ddev.readthedocs.io/en/latest/users/cli-usage/#drupal-9-quickstart\">official Drupal 9 quickstart</a> guide. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Have fun exploring, or even <a href=\"https://www.drupal.org/community\">contributing</a>, and we look forward to seeing what you build with Drupal 9 and DDEV!</p>\n<!-- /wp:paragraph -->','Congratulations on Drupal 9 ?','','publish','closed','closed','','congratulations-on-drupal-9','','','2021-02-08 11:45:48','2021-02-08 18:45:48','',0,'https://ddev.com/?p=2931',0,'post','',0),(2958,8,'2020-06-11 09:54:44','2020-06-11 15:54:44','','Pricing','','publish','closed','closed','','pricing','','','2020-11-03 09:40:27','2020-11-03 16:40:27','',0,'https://ddev.com/?p=2958',2,'nav_menu_item','',0),(2959,8,'2020-06-11 09:54:44','2020-06-11 15:54:44','','Developers','','publish','closed','closed','','developers','','','2020-11-03 09:40:28','2020-11-03 16:40:28','',0,'https://ddev.com/?p=2959',3,'nav_menu_item','',0),(2968,8,'2020-06-11 15:40:40','2020-06-11 21:40:40','.subscription-services-agreement strong {\n	font-family: \'Palanquin Dark\'\n}\n\nbody.postid-3100 article img,\nbody.postid-3108 article img,\nbody.postid-3102 article img,\nbody.postid-3542 article img,\nbody.postid-3592 article img,\nbody.postid-3620 article img,\nbody.postid-3587 article img\n {\n  display: none !important;\n}','ddevcom_theme_2020','','publish','closed','closed','','ddevcom_theme_2020','','','2020-12-14 10:51:18','2020-12-14 17:51:18','',0,'https://www.ddev.com/uncategorized/ddevcom_theme_2020/',0,'custom_css','',0),(2986,16,'2020-06-16 12:10:23','2020-06-16 18:10:23','','Virtual Event','','publish','closed','closed','','virtual-event','','','2020-06-16 12:10:23','2020-06-16 18:10:23','',0,'https://ddev.com/venue/virtual-event/',0,'tribe_venue','',0),(2989,11,'2020-06-17 11:21:22','2020-06-17 17:21:22','<!-- wp:paragraph -->\n<p>WSL2 with <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a> is a wonderful new world for Windows developers. The performance is incredible (on a par with native Linux installations) and the WSL2 command-line environment is fresh and clean.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>As noted in the <a href=\"https://ddev.com/ddev-local/ddev-wsl2-getting-started/\">WSL2 blog article</a>, Visual Studio Code is doing great with WSL2, but PHPStorm is lagging a bit behind. However, it is possible right now to use PHPStorm with DDEV-Local on WSL2 in two different ways:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Running PHPStorm in Windows as usual, opening the project on the WSL2 filesystem at <code>\\\\wsl$\\&lt;distro&gt;</code> PHPStorm is slow to index files and is slow to respond to file changes in this mode.</li><li>Enabling X11 on Windows and running PHPStorm inside WSL2 as a Linux app. PHPStorm works fine this way, but it\'s yet another complexity to manage and requires enabling X11 (easy) on your Windows system.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>We\'ll walk through both of these approaches.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I tested these approaches on an 8GB Windows 10 Home VM with Docker 2.3.0.3 and DDEV-Local v1.14.2 and the Ubuntu 20.04 distro.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 id=\"basics\">Basics</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>Start with a working DDEV-Local/WSL2 setup as described in <a href=\"https://ddev.com/ddev-local/ddev-wsl2-getting-started/\">DDEV ❤️ WSL2: getting started</a>. Until that\'s all working it doesn\'t help to go farther.</li><li>If you haven\'t used Xdebug with DDEV-Local and PHPStorm before, you\'ll want to read the <a href=\"https://ddev.readthedocs.io/en/stable/users/step-debugging/#step-debugging-with-ddev-and-xdebug\">normal instructions</a> in the docs.</li><li>For good performance, you want your project to be in /home inside WSL2, which is on the Linux filesystem. Although you can certainly keep your project on the Windows filesystem and access it in WSL2 via /mnt/c, the performance is no better than native Windows. It does work though.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2 id=\"windows-phpstorm\">Windows PHPStorm</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Your working project should be on the /home partition, so you\'ll open it using Windows PHPStorm as <code>\\\\wsl$\\Ubuntu\\home\\&lt;username&gt;\\...\\&lt;projectdir&gt;</code>.\n<ul><li>On some systems and some projects it may take a very long time for PHPStorm to index the files. At one point I got frustrated and moved to a faster computer.</li><li>File changes are noticed only by polling, and PHPStorm will complain about this in the lower right, \"External file changes sync may be slow\".</li></ul>\n</li><li>Turn off your Windows firewall temporarily. When you have everything working you can turn it back on again.</li><li>Use <code>ddev start</code> and <code>ddev xdebug on</code></li><li>Click the Xdebug listen button on PHPStorm (the little phone icon) to make it start listening.</li><li>Set a breakpoint on or near the first line of your index.php</li><li>Visit the project with a web browser or curl. You should get a popup asking for mapping of the host-side files to the in-container files. You\'ll want to make sure that <code>/home/&lt;you&gt;/.../&lt;yourproject&gt;</code> gets mapped to <code>/var/www/html</code></li><li>Debugging should be working! You can step through your code, set breakpoints, view variables, etc.</li><li>(Nice to have) I set the PHPStorm terminal path (Settings→Tools→Terminal→Shell Path) to <code>C:\\Windows\\System32\\wsl.exe</code>. That way when I use the terminal Window in WSL2 it\'s using the wonderful shell in WSL2.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2 id=\"linux-phpstorm\">Using Linux PHPStorm inside WSL2</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>On Windows, Install <a href=\"https://www.microsoft.com/store/productId/9NLP712ZMN9Q\">X410</a> from the Microsoft Store, launch it, configure in the system tray with \"Windowed Apps\", \"Allow public access\", \"DPI Scaling\"→\"High quality\". Obviously you can use another X11 server, but this is the one I\'ve used.</li><li>Temporarily disable your Windows firewall. You can re-enable it after you get everything working.</li><li>In the WSL2 terminal <code>export DISPLAY=$(awk \'/^nameserver/ {print $2; exit;}\' &lt;/etc/resolv.conf):0.0</code> (You\'ll want to add this to your .profile in WSL2). This sets the X11 DISPLAY variable to point to your Windows host side. Microsoft has future plans to support this natively.</li><li><code>sudo apt-get update &amp;&amp; sudo apt-get install libatk1.0 libatk-bridge2.0 libxtst6 libxi6 libpangocairo-1.0 libcups2 libnss3 xdg-utils x11-apps</code></li><li>run <code>xeyes</code> - you should see the classic X11 play app \"xeyes\" on the screen. &lt;ctrl-c&gt; to exit. This is just a test to make sure X11 is working.</li><li>Download and un-tar PHPStorm for Linux from <a href=\"https://www.jetbrains.com/phpstorm/download/#section=linux\">https://www.jetbrains.com/phpstorm/download/#section=linux</a> - you need the <em>Linux</em> app.</li><li>Run <code>bin/phpstorm.sh &amp;</code></li><li>In PHPStorm, under Help→ Edit Custom VM Options, add an additional line: <code>-Djava.net.preferIPv4Stack=true</code> This makes PHPStorm listen for Xdebug using IPV4; for some reason the Linux version of PHPStorm defaults to using only IPV6.</li><li>Restart PHPStorm (File→Exit and then <code>bin/phpstorm.sh &amp;</code> again.</li><li>Use <code>ddev start</code> and <code>ddev xdebug on</code></li><li>Click the Xdebug listen button in PHPStorm (the little phone icon) to make it start listening.</li><li>Set a breakpoint on or near the first line of your index.php</li><li>Visit the project with a web browser or curl. You should get a popup asking for mapping of the host-side files to the in-container files. You\'ll want to make sure that <code>/home/&lt;you&gt;/.../&lt;yourproject&gt;</code> gets mapped to <code>/var/www/html</code></li><li>Debugging should be working! You can step through your code, set breakpoints, view variables, etc.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>We look forward to your feedback as you start using PHPStorm with WSL2! We\'re listening in <a href=\"https://ddev.readthedocs.io/en/stable/#support\">many support channels</a> and are happy to work with you and learn from you.</p>\n<!-- /wp:paragraph -->','DDEV-Local and PHPStorm Debugging with WSL2','','publish','closed','closed','','ddev-local-and-phpstorm-debugging-with-wsl2','','','2020-06-17 11:21:22','2020-06-17 17:21:23','',0,'https://ddev.com/?p=2989',0,'post','',0),(3027,11,'2020-06-23 18:35:44','2020-06-24 00:35:44','<!-- wp:paragraph -->\n<p>In 2020, users from designers to developers to testers and open source contributors have a wide variety of local development environments to chose from. Because most of the tools and platforms we use will run in many different operating systems and environments, we have the option of rolling our own, using a commercial project like <a href=\"https://www.mamp.info/en/mamp-pro/mac/\">MAMP</a> or <a href=\"https://localwp.com/\">Local</a> (for WordPress), or using one of the many Docker-based solutions like <a href=\"http://ddev.readthedocs.io\">DDEV-Local</a>, <a href=\"https://docksal.io/\">Docksal</a>, or <a href=\"https://lando.dev/\">Lando</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>But what\'s so special about DDEV-Local</strong>? What makes it different from other Docker-based solutions like <a href=\"https://lando.dev/\">Lando</a> or <a href=\"https://docksal.io/\">Docksal</a>? I recently spent a little time exploring several similar platforms to research a <a href=\"https://ddev.com/event/drupalcon-global-2020/\">presentation for DrupalCon Global</a>, and was impressed with what I saw, but definitely came away wanting to highlight a number of DDEV-Local features. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Top technical features of DDEV-Local</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><strong>Full cross-platform support on Windows, Linux, and macOS</strong>: We support and test DDEV-Local on <a href=\"https://ddev.readthedocs.io/en/stable/#system-requirements\">macOS, Windows 10 Home, Pro, and Linux.</a> Windows is a first-class citizen, both on the traditional Windows side and the new and exciting <a href=\"https://www.ddev.com/ddev-local/ddev-wsl2-getting-started/\">WSL2 feature</a>.</li><li><strong>Interoperability with many versions of Docker</strong>: While a number of tools require you to use one exact version of Docker (and may take the liberty of installing it themselves), DDEV-Local currently works fine with versions that are a couple of years old, and is always attempting to keep up with the bleeding edge as well.</li><li><strong>Performance</strong>: We think DDEV-Local on macOS and Windows has about the <a href=\"https://ddev.readthedocs.io/en/stable/users/performance/#performance\">best performance</a> you can get on a Docker-based platform, both in terms of starting ddev (around 20 seconds) and in terms of webserving. With a few seconds of setup the NFS mounting feature speeds up webserving by probably 3x.</li><li><strong>Settings file management</strong>: DDEV is happy to get you started quickly and easily and even manage your settings files. You can use your own repository or follow one of the <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#quickstart-guides\">quickstart guides</a> to create something new and you\'ll have a project going in no time. You can also <a href=\"https://ddev.com/ddev-local/controlling-cms-settings-files-in-ddev-local/\">turn off settings file management</a> to fine tune your team\'s approach when you need more customization.</li><li><strong>Trusted HTTPS</strong>: DDEV uses <a href=\"https://github.com/FiloSottile/mkcert\">mkcert</a> to allow you to conduct all your work using <a href=\"https://ddev.com/ddev-local/ddev-local-trusted-https-certificates/\">locally trusted HTTPS</a>, just like it will work in the real world. You don\'t have to click around scary browser warnings to view your project in development.</li><li><strong>Database snapshots</strong>: DDEV-Local has the <code style=\"font-size: 16px;\">ddev snapshot</code> feature, which allows you to quickly capture the state of your <a href=\"https://www.ddev.com/ddev-local/ddev-local-database-management/\">database</a> and then quickly restore to a different point. You can name snapshots for different branches of your project. It\'s far faster than traditional export and import.</li><li><strong>Golang deployment environment</strong>: <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a> is written in <a href=\"https://golang.org/\">Go</a>, a newer language. This is a bit of a disadvantage in terms of community involvement but it\'s a huge advantage for cross-platform support. Golang does cross-platform builds with ease, and the resulting fat binary has no dependencies at all (except Docker of course). There are no libraries to install, not DLLs to maintain, etc.</li><li><strong>Xdebug step-debugging out of the box</strong>: Lots of people have their first experience with a <a href=\"https://ddev.readthedocs.io/en/stable/users/step-debugging/#step-debugging-with-ddev-and-xdebug\">real step-debugging environment</a> for the first time with DDEV-Local because it\'s really, really easy. With PHPStorm, there\'s no setup at all. With VSCode, it\'s about 2 minutes of setup, and it \"just works.\" There\'s no need for inserting print statements into code any more.</li><li><strong>Explicit support</strong> for a growing number of CMSs and platforms: TYPO3, Drupal, Wordpress, Magento, Magento2, Laravel, and Backdrop. Explicit support means settings management and an NGINX configuration customized for the specific platform.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Plays well with others</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><strong>No vendor lock-in</strong>: There is absolutely no vendor lock-in in DDEV-Local. The idea behind the DDEV platform is that both DDEV-Local and <a href=\"https://ddev.com/ddev-live/\">DDEV-Live</a> can be plugged into a dev-to-deploy workflow as pieces of a puzzle that work <em>for you</em>. Mix and match! The full DDEV platform offers extra benefits from the complete <a href=\"https://ddev.readthedocs.io/en/latest/users/providers/DDEV-Live/\">integration</a>, but DDEV-Local is a community project that works great with any hosting service you can use, and DDEV-Live works with any local development environment. </li><li><strong>Respect for other tools and production environments</strong>: DDEV\'s settings files aren\'t used when they\'re not being used in a DDEV context, so your project won\'t accidentally have DDEV-Local settings if you deploy them accidentally to production, and if you have the same project set up for Lando <em>and</em> DDEV the DDEV settings won\'t break Lando.</li><li><strong>Respect for your host computer</strong>: DDEV-Local does <em>not</em> assume that you use your computer (or Docker) only for its sake. A number of local dev tools will happily reconfigure your host computer without your full involvement. More than one of them will edit your /etc/exports file, and there\'s no way to turn it off. A couple of them will actually overwrite your Docker install with a different version at install time. DDEV-Local tries to make sure that in the unlikely situation when anything needs to be changed on your computer, you\'re the one doing it and you have options. For example, HTTPS support requires running <code>mkcert -install</code> one time. <a href=\"https://www.ddev.com/ddev-local/ddev-local-nfs-mounting-setup-macos/\">NFS support</a> requires a bit of additional setup. Because nearly everything is delegated to Docker, there is very little that needs to be done on the host computer in the first place.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Most importantly: the DDEV community</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><strong>Amazing community involvement and support</strong>: The DDEV-Local community has been phenomenal through the years, contributing ideas, code, and shared support. There are open collections of <a href=\"https://github.com/ddev/ddev-contrib\">DDEV-Local services, tools, snippets, approaches</a> as well as <a href=\"https://github.com/ddev/awesome-ddev\">blogs and presentations</a> and more from users around the world. You\'ll find very deep <a href=\"https://ddev.readthedocs.io/en/stable/#support\">community support</a> in a number of slacks and Stack Overflow, etc. We are beyond grateful to all who have contributed to and shared DDEV, thank you!</li><li><strong>Amazing open source support</strong>: DDEV-Local is an open source tool developed at <a href=\"http://ddev.com\">DDEV</a>, where it is a privilege to focus on development and support of a free tool to help users advance and succeed. It\'s an amazing and unwavering commitment from <a href=\"https://ddev.com/about/\">our company</a>, and it gives DDEV-Local a significant advantage.</li><li><strong>DDEV in the Open Source ecosystem:</strong> Upstream and downstream, we\'re pleased to contribute and collaborate to a variety of open source projects, including: <ul><li><strong>Docker project</strong>: We\'re very involved with the Docker project, because DDEV users are always pushing the limits. We participate heavily in the <a href=\"https://github.com/docker/for-mac/issues\">Docker Desktop for Mac</a> and <a href=\"https://github.com/docker/for-win/issues\">Docker Desktop for Windows</a> issue queues, along with several others, and have recently become involved in a group that tests insider builds for Docker. </li><li><strong>mkcert</strong>: The <a href=\"https://github.com/FiloSottile/mkcert\">mkcert</a> tool allows DDEV-Local to provided trusted https in your local development environment. We\'ve benefited enormously from it and have contributed back tests and bugfixes.</li><li><strong>Xdebug</strong>: DDEV-Local is great with <a href=\"https://xdebug.org/\">Xdebug</a>, and of course we hear right away when there are problems and have been right in there in the issue queue.</li><li><strong>deb.sury.org PHP Packages</strong>: The Debian PHP packages (5.6 all the way through 7.4)  that we use come from <a href=\"https://deb.sury.org\">deb.sury.org</a>, and because the DDEV-Local community is an early consumer of those packages, we\'re often in that <a href=\"https://github.com/oerdnj/deb.sury.org/issues\">issue queue</a> too. </li></ul></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>We\'d love to hear what makes DDEV-Local <em>your</em> favorite, and we\'re always <a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">listening</a> to hear what you want in the future... and of course we want to hear when things don\'t work the way you want or expect. Hop in to the <a href=\"https://github.com/ddev/ddev\">open source repository on GitHub</a> to contribute!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2710} /-->','What\'s so different about DDEV-Local?','','publish','closed','closed','','whats-so-different-about-ddev-local','','','2020-06-23 19:00:34','2020-06-24 01:00:34','',0,'https://ddev.com/?p=3027',0,'post','',0),(3043,21,'2020-06-25 08:19:31','2020-06-25 14:19:31','<!-- wp:paragraph -->\n<p>I recently had the pleasure of virtually attending <a href=\"https://www.gitopsdays.com/\">GitOps Days</a> to learn more about GitOps as a principle and gain exposure to some of the major projects within its community. Much of my understanding of <a href=\"https://www.gitops.tech/\">GitOps</a> up to now has been self-guided or learned from coworkers, so I was especially seeking more depth as we intentionally incorporate these principles into DDEV as a platform and into <a href=\"https://ddev.com/about/\">how we work internally</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>As an SRE at DDEV, I’m currently focused on supporting and building our platform operations and improving our platform’s CI, CD, &amp; CO (continuous integration, continuous deployment, and continuous operations). We are starting to grow our GitOps processes and have already begun adopting GitOps into our workflows. This includes utilizing tools like <a href=\"https://argoproj.github.io/argo-cd/\">ArgoCD</a> in conjunction with various other processes and tools to manage declarative environment configurations.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>My teammate Shawn, from the DDEV ops/security team, also attended the event. We had the opportunity to discuss some of the tools/apps that were mentioned (ArgoCD, FluxCD, Flagger, GitOps Operator, etc) as well as some conceptual terminology that I had questions about from the sessions. The virtual format was great because I could pause, rewind, and see the chatter from other attendees, and the videos and slides are available in the <a href=\"https://gitops-community.github.io/kit/#gitops-days-2020-youtube-playlist\">GitOps conversation kit</a>. With two days of continuous live-stream there was a lot to take in!&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Highlights of GitOps Days</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Number one highlight was <a href=\"https://twitter.com/kelseyhightower\">Kelsey Hightower’s</a> keynote, where he demonstrated the power of GitOps. He is an incredible presenter, and understands the value of having a very basic &amp; beginner friendly demo. He started by using <a href=\"https://cdk8s.io/\">`cdk8s`</a> to define the most basic of apps, and from there used it to demonstrate the power and simplicity of GitOps.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<iframe width=\"560\" height=\"315\" src=\"https://www.youtube-nocookie.com/embed/jbDidLauGtQ\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen=\"\"></iframe>\n<!-- /wp:html -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph -->\n<p>My other favorite presentation was “GitOps Today and Tomorrow” by <a href=\"https://twitter.com/cdavisafc\">Cornelia Davis</a> (CTO at WeaveWorks, the event organizers). In it, she laid out many nuggets of wisdom that should help guide the future of GitOps. Here are a few notes:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Decouple “Declarative App Configurations” from “CI created binaries/executables” while still leveraging version control (such as git and container registries) for both.</li><li>Almost everything (if not everything) can be defined declaratively &amp; versioned.</li><li>Continuous Integration (CI) is NOT Continuous Delivery (CD)</li><li>Remember to keep deployment and operations <em>separate</em> from CI!</li><li>GitOps is invaluable when needing to connect CI processes to Continuous Operations (CO) processes.</li><li>“You can GitOps just about anything!” Examples include: Cloud-Native Apps, Infrastructure (in the form of Infrastructure as Code [IAC]), Identity Providers, Kubernetes Clusters, and so much more!</li><li>GitOps = CD + CO + some required CI.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:html -->\n<p>I especially appreciated <a href=\"https://gitops-community.github.io/kit/#gitops-days-2020-slides\">slide 16 of Cornelia\'s presentation</a> as it summarized GitOps Principles so concisely:</p>\n\n<iframe width=\"560\" height=\"315\" src=\"https://www.youtube-nocookie.com/embed/RMZOQwt21EM\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen=\"\"></iframe>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>GitOps and DDEV</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ddev.com/ddev-live/\">DDEV-Live</a> solves the problem of integrating your project’s GitOps workflow with a hosting provider by making integrations simple via our <a href=\"https://docs.ddev.com/authentication/#authenticating-with-a-token\">API token</a> and installable CLI, backed by the knowledge that we use the same GitOps processes internally. DDEV as a dev-to-deploy platform can be used to support the concept of GitOps because <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a> and DDEV-Live themselves can be adopted into a GitOps process because they already align with several of the core GitOps principles.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>As Weaveworks CTO Cornelia Davis said during her presentation, the key elements of GitOps are:&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><strong>“You can GitOps just about anything.”&nbsp;</strong></li><li><strong>Declarative Declaration</strong>. A declared intended state is taken and then interpreted. In our case, when a customer uses the <a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">DDEV-Live CLI</a>, their commands are backed by declarative APIs. We’ll&nbsp; talk more about the declarative approach in an upcoming blog.</li><li><strong>Versioned Configs/Resources</strong>. The configuration of some or all of the workload is versioned using some form of source control.&nbsp;<ul><li>This could mean using Github to version things like Application Configuration, Deployment Configurations, Infrastructure as Code (IaC) etc.&nbsp;</li><li>This could also mean using a container registry like DockerHub or GCR to store versioned container images.&nbsp;</li><li>In our case: DDEV-Live can be utilized as a tool to achieve parts of a GitOps workflow. Utilize <a href=\"https://docs.ddev.com/providers/\">Github</a> (or Gitlab in the coming future) to version control your site’s code, then use the CLI to declaratively define how that version controlled code should be configured, and assets added to it. You can even use the CLI to monitor the state of your application, as well as all of your assets.</li></ul></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Conclusions</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>GitOps, just like Kubernetes, is not the specific answer to any one question or problem. GitOps is a means to an end, just as Kubernetes or anything else in tech is. So before diving headlong into adopting GitOps, I’d advise first to identify what problems/deficiencies could be resolved or mitigated by implementing a GitOps workflow.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I do see this community growing in the future, gaining adoption and traction, as it can be applied to a vast set of situation specific problems.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','Continuous learning: Nic’s notes from GitOps Days','','publish','closed','closed','','continuous-learning-nics-notes-from-gitops-days','','','2020-06-24 17:42:05','2020-06-24 23:42:05','',0,'https://ddev.com/?p=3043',0,'post','',0),(3070,20,'2020-06-30 07:09:55','2020-06-30 13:09:55','<!-- wp:paragraph -->\n<p>In a tumultuous economic environment, a <a href=\"https://ddev.com/ddev-live/ci-cd/\">continuous integration and continuous delivery</a> (CI/CD) process will provide a safe harbor in the storm, enabling teams to drive consistency through reliability and repeatability. By automating and increasing the frequency of small, incremental changes in a project pipeline, it’s possible to reduce regressions, increase velocity, and support shared success. But, configuring all your CI/CD tools to work together can be a disruptive hurdle in and of itself.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Whether you’ve got a fully developed CI/CD pipeline in place or are looking to get started, DDEV delivers flexibility and straightforward integration to increase efficiency every step of the way. <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a> is designed to help developers to take advantage of cutting edge cloud technology while allowing them to define their own workflows. The resulting hosting experience is simple, scalable, and easily integrates with your team’s existing processes and favorite CI/CD tools like <a href=\"https://circleci.com/\">CircleCI</a>.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>CircleCI is an especially attractive option at a time when client needs are becoming increasingly variable. Just like DDEV-Live, CircleCI is there where you need it, offering a cloud based CI but also on-premises or private cloud connections for your sensitive workloads. For agencies new to standardized CI/CD processes, CircleCI is also incredibly approachable, helping teams reap the <a href=\"https://ddev.com/ddev-live/bringing-ci-cd-to-your-agency-with-ddev-live/#benefits\">benefits of continuous integration and continuous delivery</a> as fast as possible.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Already using on CircleCI and need to quickly deploy a test site, or in the mood to reevaluate your existing CI/CD tools? Click below to read the tutorial and take DDEV-Live for a spin. Otherwise, continue reading to learn how your teams can benefit from integrating CircleCI with DDEV-Live.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://docs.ddev.com/circleci/\">How to integrate CircleCI with DDEV-Live</a></div>\n<!-- /wp:button -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Flexibility Is Paramount for Agile Teams</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Agency life is challenging in the best of times — throw in a global pandemic and you can quickly find yourself in a state of constant flux. With client and project requirements changing rapidly and revenue forecasts uncertain, tech leads have had to make tough calls for their teams. What do you do if the engineer who’s handling your deployments has to reduce their hours because they no longer have childcare? How do you continue <a href=\"https://ddev.com/ddev-local/enabling-fast-flow-of-work-from-dev-to-deploy-with-devops-best-practices/\">driving consistency and parity</a> when your tight-knit team of in-office workers is suddenly remote?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A well-engineered CI/CD process will help you reduce risk while increasing the velocity of software delivery. More importantly, it eliminates your dependency on siloed developer knowledge, enabling the agency to improve ownership and deliver uninterrupted value to clients. However, no CI/CD process is futureproof. Maybe last year’s projects were best served by the <a href=\"https://www.ddev.com/ddev-live/simplify-your-end-to-end-workflow-integrate-ddev-live-with-jenkins/\">easily extensible Jenkins</a>, but changing client needs have your team eyeing CircleCI because of its <a href=\"https://circleci.com/docs/enterprise/whycci/\">developer-driven configuration</a>.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Flexibility is paramount for agile, resilient teams at any stage of their CI/CD integration journey. DDEV-Live ushers in a scalable and dependable future of hosting that’s flexible enough to accommodate changing workflows and tools while working seamlessly across multiple CMSs like Drupal, TYPO3, WordPress, and other PHP applications.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Why CircleCI?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>First off, it’s a time-saver: <a href=\"https://www.youtube.com/watch?v=B5-UWDnvKRo\">CircleCI’s orbs</a> save you valuable developer time by allowing you to share reusable packages of YAML config across teams and projects, and even other SaaS providers. Plus, its core components come built-in — eliminating the hassle and overhead of managing legions of plugins. There’s also minimal troubleshooting since all builds start in a clean environment and can be debugged by any engineer using SSH.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To get you up and running, we’ve created a <a href=\"https://circleci.com/orbs/registry/orb/ddev/ddev-live\">DDEV-Live orb</a> with four available commands that will help you with install and authorizations, as well as allowing you to create new sites for every push that happens to the repository and delete sites following functional tests or reviews in a user acceptance testing (UAT) environment. Even if your clients use another hosting provider, you can set up previews of their projects by automatically deploying a test site via CircleCI onto DDEV-Live — saving the developer hours needed to go all the way to production.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Ready to throw a few orbs at the wall and see what sticks for your team’s workflows?<strong> </strong>The best part is that connecting CircleCI to DDEV is as simple as this one-time setup: To get started, you’ll need a fully-configured account on DDEV-Live, a CircleCI organization configured to allow uncertified orbs, and a GitHub repository configured with the DDEV-Live GitHub app. Then you’ll follow this <a href=\"https://docs.ddev.com/circleci/\">six-step process</a> to connect your CI/CD pipeline with DDEV.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Futureproof Your Team</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>No one has a clear roadmap for what challenges the future will hold. DDEV empowers your team with powerful, flexible technology whether you’re a small shop or agency with bespoke needs. No matter what path you take, you’ll be riding on the shoulders of proven open source giants like Docker, Kubernetes, Helm, Prometheus, and more. As always, the DDEV team will be along for the ride with service guarantees for enterprise-level clients and product engineering teams on-call for everything from bug fixes to regular performance reviews.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Want to kick the tires on DDEV-Live? To test things yourself, create your account to start a free 10-day trial. If you’d rather have one of us walk you through the bells and whistles, reach out today to <a href=\"https://www.ddev.com/contact/\">book a demo</a> and discuss how we can accommodate your requirements.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://dash.ddev.com/pricing\">Get started with DDEV-Live</a></div>\n<!-- /wp:button -->','Drive Reliability with CI/CD: Integrate CircleCI with DDEV-Live','','publish','closed','closed','','drive-reliability-with-ci-cd-integrate-circleci-with-ddev-live','','','2020-06-30 07:58:38','2020-06-30 13:58:38','',0,'https://ddev.com/?p=3070',0,'post','',0),(3100,11,'2020-08-06 06:35:34','2020-08-06 12:35:34','<!-- wp:shortcode -->\n[embed width=\"750\"]https://www.youtube.com/embed/ZMfHaUkhfc0[/embed]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p>WSL2 (<a href=\"https://docs.microsoft.com/en-us/windows/wsl/wsl2-index\">Windows Subsystem for Linux version 2</a>) is finally generally available on recent editions of Windows! Because of <a href=\"https://docs.docker.com/docker-for-windows/wsl/\">Docker\'s great support for WSL2</a>, it\'s now the preferred way to run your <a href=\"https://ddev.com/ddev-local/\">DDEV-Local development environment</a> on Windows. DDEV-Local on WSL2 is as fast as DDEV-Local on Linux, but you have all the Windows niceties you love there.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Traditionally, web developers working on Windows have had to cobble together all the tools that Linux (and macOS) developers take for granted, as well as maintaining and managing versions. With WSL2 Windows developers now have a full Linux toolkit with anything they could ever want (bash, zsh, grep, awk, vim, composer, make, npm, yarn, and on and on), standard packaging, all readily available. With DDEV-Local in the mix they also have a super-fast local development environment that works just the same as it does on Linux, macOS, (or traditional Windows, but much, much faster). And of course the traditional Windows problems with symlinks, different line endings, file formats, shell script support, all are solved by WSL2.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In this screencast I\'m just walking through the official DDEV-Local <a href=\"https://ddev.readthedocs.io/en/stable/#installation-or-upgrade-windows-wsl2\">WSL2 Installation Docs</a>, but adding a little more detail. Then I show the basics of installing Chocolatey, mkcert, Docker Desktop, Homebrew, and DDEV-Local, and basic usage of DDEV-Local in action, including a <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#typo3-quickstart\">TYPO3 CMS Composer install</a> and demonstrations of a few key commands.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>Note</em>: One of the weaknesses of WSL2 is that PHPStorm isn\'t really completely ready for it yet. There are <a href=\"https://ddev.com/ddev-local/ddev-local-and-phpstorm-debugging-with-wsl2/\">two not-quite-satisfactory ways</a> to use PHPStorm though.  BUT... <a href=\"https://code.visualstudio.com/\">VSCode</a> has full and robust support for WSL2, including inside Docker containers. Our <a href=\"https://ddev.com/ddev-local/ddev-wsl2-getting-started/\">original article on WSL2</a> tells how to set up VSCode for use inside WSL2.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Here\'s the video table of contents (opens on YouTube):</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>What is DDEV-Local? (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=62\">1:02</a>)</li><li>What is WSL2? (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=172\">2:52</a>)</li><li>Advantages and Disadvantages of WSL2 (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=222\">3:44</a>)</li><li>WSL2 Installation (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=349\">5:49</a>)</li><li>Installing Docker Desktop (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=809\">13:29</a>)</li><li>Installing Homebrew and DDEV-Local inside WSL2 (<a href=\"https://youtu.be/SwahVCBTo3w?t=922\">15:22</a>)</li><li>Installing and using bash-completion (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=1146\">19:06</a>)</li><li>Creating a super-simple PHP project (junk project) (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=1234\">20:38</a>)</li><li>Creating a TYPO3 project with <code>ddev composer create</code> (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=1673\">27:57</a>)</li><li>Some most-important ddev commands (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=1931\">32:11</a>)</li><li>Resources and wrap-up (<a href=\"https://youtu.be/ZMfHaUkhfc0?t=2161\">36:01</a>)</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Resources for you:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local documentation</a>.</li><li><a href=\"https://ddev.readthedocs.io/en/stable/#installation-or-upgrade-windows-wsl2\">WSL2 and DDEV Installation docs</a></li><li><a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">Support</a>: Drupal slack and TYPO3 slack #ddev, gitter #ddev, Stack Overflow, and the <a href=\"https://github.com/ddev/ddev/issues\">DDEV-Local issue queue</a>.</li><li><a href=\"https://github.com/ddev/ddev\">DDEV-Local Project Repository</a></li><li>More about <a href=\"https://ddev.com/ddev-local/ddev-local-and-phpstorm-debugging-with-wsl2/\">PHPStorm on WSL2</a>, with full details about how to run it.</li><li>Using WSL2 (and <strong>VSCode</strong>), <a href=\"https://ddev.com/ddev-local/ddev-wsl2-getting-started/\">DDEV ❤️ WSL2: getting started</a></li><li>DDEV-Local\'s counterpart, <a href=\"https://ddev.com/ddev-live/https://ddev.com/ddev-live/\">DDEV-Live</a>: Includes a free 10-day trial for you to kick the tires on our hosting platform. </li></ul>\n<!-- /wp:list -->\n\n<!-- wp:block {\"ref\":2410} /-->','Watch: DDEV-Local from scratch with Windows WSL2','','publish','closed','closed','','watch-ddev-local-from-scratch-with-windows-wsl2','','','2020-08-06 12:59:34','2020-08-06 18:59:34','',0,'https://ddev.com/?p=3100',0,'post','',0),(3102,11,'2020-08-13 05:30:50','2020-08-13 11:30:50','<!-- wp:shortcode -->\n[embed]https://youtu.be/-firvjLr2hE[/embed]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a> is a local development environment based on Docker containers that gets you up and working on your project fast. Configuring Docker for local development performance is no longer a dark art when all the benefits are wrapped in a user friendly tool like DDEV-Local. When you\'re ready for <a href=\"https://ddev.readthedocs.io/en/stable/users/extend/customization-extendibility/#extending-and-customizing-environments\">additional configuration and customization</a>, you wont be starting from scratch with your docker-compose.yaml and can lean on <a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">the expertise of the DDEV community</a>. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In this screencast I\'ll just walk you through the first time set up of Docker, Homebrew, some initial configuration and optimization you might consider, and getting started with a basic project. We\'ll use a Composer-managed <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#drupal-9-quickstart\">Drupal 9 project</a> as an example, but we have a handful of quickstart recipes for other CMSs not to mention a huge variety of PHP projects and more that will happily run in DDEV.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>After watching this tutorial, you\'ll be able to run websites on your computer with no configurations needed and have hundreds of sites with different configurations available locally, all because Docker does the heavy lifting, while DDEV-Local does the simplifying. Whether you\'re a solo engineer, or a member of a team, DDEV-Local will help you to be more efficient. After all, we\'re all about <a href=\"https://ddev.com/about/\">Advancing Developer Communities</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>This screencast references the regular <a href=\"https://ddev.readthedocs.io/\">DDEV-Local documentation</a>:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://ddev.readthedocs.io/en/stable/#homebrewlinuxbrew-macoslinux\">DDEV-Local Installation with Homebrew</a></li><li><a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/\">Using the CLI</a></li><li><a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#drupal-9-quickstart\">Drupal 9 Quickstart</a></li><li>Support: Drupal Slack and TYPO3 Slack, Gitter, Stack Overflow: See&nbsp;<a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">Support docs</a>.</li><li><a href=\"https://github.com/ddev/ddev\">DDEV-Local Project Repository</a> and issue queue</li><li>DDEV also builds a container-based hosting platform,&nbsp;<a href=\"https://ddev.com/ddev-live/\">DDEV-Live</a>.&nbsp;There’s a free 10-day trial for you to kick the tires.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Here\'s the video table of contents (opens in YouTube):</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>What is DDEV-Local (<a href=\"https://youtu.be/-firvjLr2hE?t=31\">0:35</a>)</li><li>Install Homebrew (optional) (<a href=\"https://youtu.be/-firvjLr2hE?t=147\">2:27</a>)</li><li>Install Docker Desktop for Mac (<a href=\"https://youtu.be/-firvjLr2hE?t=178\">2:58</a>)</li><li>Install DDEV-Local (<a href=\"https://youtu.be/-firvjLr2hE?t=244\">4:05</a>)</li><li>Enable NFS (<a href=\"https://youtu.be/-firvjLr2hE?t=381\">6:21</a>)</li><li>Create a trivial \"junk\" project (<a href=\"https://youtu.be/-firvjLr2hE?t=555\">9:15</a>)</li><li>Create a Drupal 9 project (<a href=\"https://youtu.be/-firvjLr2hE?t=760\">12:40</a>)</li><li>Learn a few DDEV commands (<a href=\"https://youtu.be/-firvjLr2hE?t=1030\">17:10</a>)</li><li>DDEV-Local Resources (<a href=\"https://youtu.be/-firvjLr2hE?t=1182\">19:42</a>)</li></ul>\n<!-- /wp:list -->','Watch: DDEV-Local From Scratch with macOS','','publish','closed','closed','','watch-ddev-local-from-scratch-with-macos','','','2020-08-13 09:35:01','2020-08-13 15:35:01','',0,'https://ddev.com/?p=3102',0,'post','',0),(3108,11,'2020-08-27 08:19:30','2020-08-27 14:19:30','<!-- wp:shortcode -->\n[embed]https://www.youtube.com/watch?v=tvqwkymg6fE[/embed]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p>The days of print-debugging are long behind us! <a href=\"https://xdebug.org/\">Xdebug</a> and PHP IDEs have made that approach unwieldy, but often the configuration between your IDE, PHP, webserver, and Docker is challenging and fragile. Enter our open source local development environment, <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The combination of <a href=\"https://www.jetbrains.com/phpstorm/\">PhpStorm</a> and <a target=\"_blank\" href=\"https://ddev.com/ddev-local/\" rel=\"noopener noreferrer\">DDEV-Local</a>\'s plug-and-play approach to debugging makes those configuration struggles obsolete. You can easily get a working debug environment in just a few minutes! We\'ll walk you through it in this screencast using macOS. It works exactly the same on Windows or Linux, and with <a rel=\"noreferrer noopener\" href=\"https://ddev.com/ddev-local/ddev-local-and-phpstorm-debugging-with-wsl2/\" target=\"_blank\">WSL2 as well</a>. After all, we want you to be successful with the tools and <a href=\"https://ddev.com/ddev-live/a-git-based-workflow-from-dev-to-deploy/\">workflows</a> you know and love.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Debugging in your local development environment</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>What we\'re doing in this tutorial:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Installing DDEV-Local (<a href=\"https://ddev.readthedocs.io/en/stable/#homebrewlinuxbrew-macoslinux\">docs</a>)</li><li>Installing PhpStorm (we use Homebrew here, but you can install it with a download)</li><li>Setting a breakpoint</li><li>Telling PHPStorm to listen for Xdebug</li><li>Enabling DDEV-Local Xdebug with <code>ddev xdebug on</code></li><li>Visiting a page</li><li>Configuring the initial popup that makes a \"server\" or file mapping for us</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Outline:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Overview (<a href=\"https://youtu.be/tvqwkymg6fE?t=51\">0:51</a>)</li><li>Installing DDEV-Local (<a href=\"https://youtu.be/tvqwkymg6fE?t=59\">0:59</a>)</li><li>Installing PhpStorm (<a href=\"https://youtu.be/tvqwkymg6fE?t=100\">1:40</a>)</li><li>Creating a PhpStorm project and setting a breakpoint (<a href=\"https://youtu.be/tvqwkymg6fE?t=144\">2:24</a>)</li><li>Configure DDEV project (<a href=\"https://youtu.be/tvqwkymg6fE?t=198\">3:18</a>)</li><li><code>ddev xdebug on</code> (<a href=\"https://youtu.be/tvqwkymg6fE?t=252\">4:12</a>)</li><li>Creating a PhpStorm \"server\" or \"mapping\" automatically (<a href=\"https://youtu.be/tvqwkymg6fE?t=314\">5:14</a>)</li><li>First breakpoint! (<a href=\"https://youtu.be/tvqwkymg6fE?t=342\">5:42</a>)</li><li>Command-line debugging (<a href=\"https://youtu.be/tvqwkymg6fE?t=480\">8:00</a>)</li><li>Resources (<a href=\"https://www.youtube.com/watch?v=tvqwkymg6fE&amp;t=598s\">9:58</a>)</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Resources for you:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>DDEV-Local documentation: <a href=\"https://ddev.readthedocs.io\">https://ddev.readthedocs.io</a></li><li><a href=\"https://ddev.readthedocs.io/en/stable/users/step-debugging/\">DDEV-Local Xdebug docs</a> (including troubleshooting)</li><li><a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">Support docs</a>: Drupal Slack and TYPO3 Slack #ddev, gitter #ddev, Stack Overflow, and the <a href=\"https://github.com/ddev/ddev/issues\">DDEV-Local issue queue</a></li><li><a href=\"https://github.com/ddev/ddev\">DDEV-Local Project Repository</a></li><li>More about <a href=\"https://ddev.com/ddev-local/ddev-local-and-phpstorm-debugging-with-wsl2/\">PHPStorm on WSL2</a>, with full details about how to run it</li><li>Ready to deploy? Try out <a href=\"https://ddev.com/ddev-live/\">DDEV-Live</a> for hosting, there\'s a free 10-day trial for you to kick the tires</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:block {\"ref\":2410} /-->','Watch: DDEV-Local, PhpStorm, and Xdebug Debugging','','publish','closed','closed','','ddev-local-phpstorm-and-xdebug-debugging','','','2020-09-01 18:11:20','2020-09-02 00:11:20','',0,'https://ddev.com/?p=3108',0,'post','',0),(3113,16,'2020-08-03 11:20:13','2020-08-03 17:20:13','<!-- wp:paragraph -->\n<p>Recently Matt Glaman, who previously talked with us about <a href=\"https://ddev.com/ddev-local/test-driven-development-with-ddev-and-drupal/\">test-driven development and DDEV</a>, launched a Drupal 9 site in his first experience with <a href=\"https://ddev.com/ddev-live/\">DDEV-Live</a> <em>live</em> on YouTube. It was a bit emotional to watch the livestream (“Yes, you’ve got it! Just add the php-version flag!” I hollered at my monitor), but Matt was well equipped with the documentation, and deep Drupal and DDEV experience. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Many early adopters have contributed to the growth of DDEV-Live as it becomes a leading-edge <a href=\"https://ddev.com/ddev-live/how-ddev-live-users-contribute-to-our-cloud-hosting-platform/\">self-service hosting platform</a>. DDEV-Live solves the challenge of managing your own Kubernetes cluster by offering our Kubernetes-based hosting platform and tools to launch a site onto scalable container architecture whenever you want, giving you the freedom to grow and advance on your own terms. Please read about Matt’s full experience on his blog:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://glamanate.com/blog/launching-drupal-9-site-ddev-live\">Matt launches Drupal 9 on DDEV-Live</a></div>\n<!-- /wp:button -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Building your own Kubernetes cluster?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Of all the different ways to handle container orchestration, Kubernetes has come out on top.  Managing your own Kubernetes cluster is a fun (<a href=\"https://cloud.google.com/kubernetes-engine/kubernetes-comic/\">no really!</a>) challenge, a massive learning curve, and a lot to maintain. If you want to leverage Kubernetes for production web hosting you may want a little help and management, maybe even split the costs of AWS or GCP with some other folks.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>That’s the goal of DDEV-Live: we want to give you all the cool stuff without the hassle of maintaining the cluster on top of maintaining your projects. Sometimes you just want someone else to do the cooking.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>“It’s awesome that DDEV-Live is built on top of, and is <a href=\"https://ddev.com/ddev-live/kubecon-barcelona-wrap-up/\">helping to expand</a> an open source hosting solution such as Kubernetes,” as Matt said in the livestream.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>DDEV-Live managed Kubernetes hosting&nbsp;</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Using the <a href=\"https://docs.ddev.com/getting-started/\">DDEV-Live CLI and a fresh account</a>, spin up your own site quickly from your Git repo of choice. The details are in <a href=\"https://glamanate.com/blog/launching-drupal-9-site-ddev-live\">Matt’s DDEV livestream blog</a>. Here are a few highlights that stood out to us from Matt’s experience:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Once you’ve signed up and installed the CLI, you’ll run <code>ddev-live auth</code> to connect the CLI to your account on the platform. This is a great time to <a href=\"https://docs.ddev.com/organizations/#specify-organization-at-login\">set your default organization</a>. Matt said “The OAuth handshake with the command line tool is really seamless. Props to DDEV for doing that here.”</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Some hosting providers, as Matt noted, don’t allow you to run a build process in production, you have to commit your artifacts and vendor directory (<a href=\"https://getcomposer.org/doc/faqs/should-i-commit-the-dependencies-in-my-vendor-directory.md\">not recommended by the Composer documentation</a>) or use an intermediate CI build process. With DDEV, you can add a flag <code>--run-composer-install</code> on the platform when you create your site or later with <code>ddev-live config</code> and include <a href=\"https://docs.ddev.com/faq/#how-do-i-work-with-composer-on-the-platform\">additional Composer arguments</a>. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For deployments, subsequent pushes to the Git repo/branch you created your DDEV site from result in automatic deployments to production. We’re continuing to build out some support around this, such as reporting on status and more documentation regarding what tools run each time and so forth.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>“You should always have scheduled backups going on your site. Not all hosting providers make this easy.” Database backups can be created, configured, pushed, pulled, etc in DDEV-Live. It is important to remember that a backup must be created before it can be referred to in a pull, for instance. You can find details on any command by appending <code>--help</code> to learn more. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Matt also checked out the <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/DDEV-Live/\">DDEV-Local integration for DDEV-Live</a>. This allows you to easily pull down a site from Live to Local and sets up a connection for future work. It works in the same way as the DDEV-Local integration for Pantheon except DDEV uses your Git provider as the source of truth for code. This integration and the automatic deployments to production are just some of the <a href=\"https://ddev.com/events/continuous-learning-nics-notes-from-gitops-days/\">GitOps principles</a> DDEV leverages to bring you a reliable, flexible deployment workflow.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Open source principles&nbsp;</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>DDEV is adapting and updating all the time; we’re constantly observing how the platform is used and where we can smooth out wrinkles and improve it for everyone. Thanks to Matt sharing his experience with everyone, we were able to queue up and tackle a series of changes to the platform and documentation. Many of these updates are in the most recent release of the CLI, ddev-live version v0.6.0. Run <code>ddev-live --version</code> to see your current version, and <a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">upgrade via Homebrew or download the binary</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We had a lively internal conversation about the logic behind flags for enabling/disabling cron, made appropriate changes, and are currently finessing some validation for cron jobs in the backend. There were underlying issues in the <code>ddev exec</code> command which surfaced during the livestream and were remedied with RBAC changes for a controller as well as informing ongoing work for the DDEV API. The livestream walkthrough also prompted us to finalize how we offer setting the PHP version from the CLI in terms of commands and defaults.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Up next, we’ll be adding more guidance to the CLI and UI onboarding workflow to make the process of signing up and getting started much smoother, especially changing the concept away from the “organization.” This has folded into some other conversations about terminology, where we often internally reference terms from Kubernetes, but on the customer side that’s been abstracted back to terms that should be more broadly familiar. As Matt said:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>“Overall I’m pretty excited. I love the fact that it’s a wrapper around Kubernetes, so you get all that awesomesauce.”</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We also very much appreciated Matt saying, “When you’re working with a product and the company is open to feedback and has ways to give it easily, do it. That helps build a better product and shows their values— that they’re willing to listen to the customer and adopt some of the changes. Always recommend reaching out to the company, especially DDEV, they’re always really good on feedback.”&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Please, when you are using DDEV, do <a href=\"https://docs.ddev.com/support/\">send in feedback</a>, suggestions, comments, anything at all. We’re here to enable you to succeed, and your comments will lead to changes that benefit all users. Matt also thought to open <a href=\"https://github.com/ddev/ddev/issues/2357\">an issue</a> for a stumbling point in DDEV-Local, and made a point of searching to see if an issue existed already. Open source folks everywhere thank you for that.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Watch and learn</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Thank you again to Matt for sharing his first walk through with DDEV-Live! We hope his <a href=\"https://glamanate.com/blog/launching-drupal-9-site-ddev-live\">blog</a> and <a href=\"https://youtu.be/5IGit6oXc-0\">video</a> help you launch your sites onto our hosting platform as well. Everything you need is in the <a href=\"http://docs.ddev.com/\">documentation</a> so you can get started and deploy whenever you’re ready. Thanks for tuning in!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','The DDEV-Live hosting experience, livestreamed','','publish','closed','closed','','the-ddev-live-hosting-experience-livestreamed','','','2020-08-03 14:53:26','2020-08-03 20:53:26','',0,'https://ddev.com/?p=3113',0,'post','',0),(3193,16,'2020-08-06 22:33:26','2020-08-07 04:33:26','<!-- wp:paragraph -->\n<p>Thank you very much to the organizers and presenters at the recent <a href=\"https://t3oce.org/\">TYPO3 online community event</a> (T3oce)! I am grateful for the chance to join remotely, having had the privilege of traveling to <a href=\"https://ddev.com/events/typo3con-2019-wrapup/\">TYPO3</a> <a href=\"https://ddev.com/ddev-live/typo3-dev-days-wrap-up/\">events</a> in the past. In addition to the sessions, I was able to participate in live and text conversations and came away feeling pleasantly re-engaged with the community.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>My favorite part about recent virtual events has been seeing the generosity and compassion of open source communities. With the pivot to the virtual format tickets become more affordable, more people can access the event to learn or to share knowledge, and organizers can provide a platform for charitable giving (those saved travel funds) that reflects the community’s values. The T3oce organizing team <a href=\"https://t3oce.org/#donation-projects\">encouraged donations</a> to a COVID-19 relief fund, a far-reaching development aid non-profit, a human rights group, and a free radio initiative in Germany.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Since March, I’ve had a chance to see quite a range of solutions to taking an event completely virtual. For T3oce, there was a livestream on <a href=\"https://www.youtube.com/channel/UC4e9NXAZETw_7x2wsAGhIyQ/about\">YouTube</a>, a simultaneous chat hosted on <a href=\"https://mattermost.com/\">Mattermost</a>, and follow-up group video conversations on <a href=\"https://jitsi.org/\">Jitsi</a>. The organizers did a good job managing all those spaces, and I respect the community’s commitment to using open source solutions wherever possible.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Here are the sessions I attended, including two featuring <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a>!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Our Responsibilities as (Open Source) Developers</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Helmut Hummel is an excellent TYPO3 teacher and contributor. He is also an advocate for <a href=\"https://t3oce.org/sessions/our-responsibilities-as-opensource-developers-anti-discrimination-inclusivity-self-reflection-open-minded\">demonstrating individual and community values</a> (<a href=\"https://youtu.be/E2AqmxQIMOs\">session recording here</a>), whether that is through writing a community statement in support of <a href=\"https://twitter.com/helhum/status/1271030438455324672\">Black Lives Matter</a> or publishing and further <a href=\"https://typo3.org/community/values/code-of-conduct\">developing a code of conduct</a>. Helmut’s presentation covered a lot of topics and reminded me of my <a href=\"https://youtu.be/FoolIDaFQIc\">Drupal Diversity and Inclusion</a> group session.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Key concepts included: building a product for everyone. How can you know if your product is good for “everyone” if “everyone” isn’t represented on your team? As privileged people, we must take responsibility. Listen to and amplify people who have experiences different from your own. It’s our responsibility not just because it’s the right thing to do, but because it’s our job to build the right thing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>After the session, Helmut created a new channel in the TYPO3 Slack, named <a href=\"https://typo3.slack.com/archives/C01846XK010\">#cwg for community working group</a>, to talk about developing and enforcing the TYPO3 code of conduct. Hopefully we can continue the conversation and join with other initiatives to clearly show the values of TYPO3 and give space to underrepresented folks.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>10 Things about TYPO3 v10</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>TYPO3 project lead Benni Mack presented on <a href=\"https://t3oce.org/sessions/my-favorite-10-features-that-did-not-make-it-in-typo3-v10\">what did and did not make it into TYPO3 v10</a> (<a href=\"https://youtu.be/e5elFltztng\">recording</a>). Of particular interest to us at DDEV is Benni’s process of evaluating web hosts to see what infrastructure might be available to run TYPO3 in a year or more and what long term support is like in order to determine the roadmap for TYPO3 itself. We’re continuing conversations with Benni and other TYPO3 users to make sure we are offering <a href=\"https://ddev.com/ddev-live/\">DDEV-Live hosting</a> that is suitably adaptive and flexible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In an interesting overlap with upcoming <a href=\"https://noti.st/francescamarano/EAkrMm/the-future-of-wordpress#sSPOY53\">WordPress features</a> (my recap of <a href=\"https://2020.wpcampus.org/\">WPCampus</a> is coming soon), TYPO3 has prioritized lazy loading images. No one wants high bounce rates that result from waiting for pages to load, or to lose viewers with slower internet connections. <a href=\"https://b13.com/blog/lazy-loading-just-got-lazier-in-typo3-v10\">Lazy loading is now active</a> for Fluid Styled Content in TYPO3 v10.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Making TYPO3 explicitly require Composer package management is not in the future of TYPO3 for now. Benni said that according to hosting providers, 90% of TYPO3 sites in the wild are not using Composer! Why? Probably the high overhead of converting a project and pipelines to Composer management. In the meantime, you can <a href=\"https://docs.ddev.com/typo3-guide/\">give TYPO3 and Composer a spin</a> on DDEV-Live just to try it out.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>https://twitter.com/ekl1773/status/1289586125263130625</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Local Development Environment for TYPO3 with DDEV</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Peter Kraume has presented several times on how to use DDEV-Local to start up a <a href=\"https://t3oce.org/sessions/local-development-environment-for-typo3-with-ddev\">TYPO3 project for local development</a>. I was very pleased to finally catch him in action! It is really <a href=\"https://github.com/ddev/awesome-ddev\">always awesome</a> to see people take DDEV and run with it, highlight how it works for their use case, and share it with others.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Some of things Peter mentioned about DDEV included the out of the box <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#typo3-quickstart\">support for TYPO3</a>, that it’s <a href=\"https://github.com/ddev/ddev\">open source</a>, and that we’re “very community driven to adapt DDEV optimally for TYPO3 and other systems.”</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>https://speakerdeck.com/peterkraume/local-development-environment-for-typo3-with-ddev-number-t3oce-2020?slide=5</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>There was a question during the presentation about how to get a TYPO3 site from DDEV-Local to a live system or vice versa. Peter (and DDEV) recommends putting Git in the middle - dump your database, clone your repository to local, run <code>ddev config</code>, or use <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/DDEV-Live/\">the integration with DDEV-Live</a>. To <a href=\"https://docs.ddev.com/getting-started/\">deploy on DDEV-Live</a>, push your local project to a Git repository (<a href=\"https://docs.ddev.com/providers/\">GitHub or GitLab</a>) and then connect to your DDEV-Live account.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Starting a modern TYPO3 project from scratch with Composer and DDEV</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Thomas Löffler brought all of these concepts together in a <a href=\"https://t3oce.org/sessions/starting-a-modern-typo3-project-from-scratch-with-composer-and-ddev\">live demo session</a>. I learned about <a href=\"https://get.typo3.org/misc/composer/helper\">Composer Helper</a>! It’s a simple wizard that provides a UI for selecting Composer packages for TYPO3 and returns a command for you to run locally.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>You can also use <code>ddev exec</code> to run the TYPO3 Console tool inside the DDEV container, and add a short script to regenerate packagestates.php easily. With the provided details about .gitignore, not committing generated files, and creating a site package, you’ll also be ready to launch your local project through GitLab CI or other deployment tools. Hopefully the recording of this session will be available online, it’s very much worth following along.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Thank you TYPO3!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Thank you to all the TYPO3 Camp organizers (<a href=\"https://typo3camp-berlin.de/\">Berlin</a>, <a href=\"https://www.typo3camp-munich.de/\">Munich</a> and <a href=\"https://www.typo3camp-rheinruhr.de/\">RheinRuhr</a>) who came together to host this event. While getting up at 5am was a challenge, I was very grateful to be able to join the community and support the speakers. A massive thank you especially to Peter and Thomas! I am looking forward to connecting with everyone again soon – feel free to reach out in TYPO3 Slack @elli or in the <a href=\"https://typo3.slack.com/archives/C8TRNQ601\">#ddev</a> and <a href=\"https://typo3.slack.com/archives/CTKT5PHFZ\">#ddev-live</a> channels.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','TYPO3 online community event: Elli\'s notes','','publish','closed','closed','','typo3-online-community-event-ellis-notes','','','2020-08-21 11:54:52','2020-08-21 17:54:52','',0,'https://ddev.com/?p=3193',0,'post','',0),(3235,22,'2020-08-19 13:34:57','2020-08-19 19:34:57','<!-- wp:paragraph -->\n<p>It can be a challenge to get frequent and finite changes to web projects from concept to commit to deployment on your hosting platform. The work must be tracked to facilitate collaboration, accuracy, and accountability, and the deployment pipelines maintained, standardized, and sustainable. Using a version control system such as <a href=\"https://git-scm.com/\">Git</a> to track work is the standard for development teams today, but connecting a Git repository into every step in an end to end workflow requires time to configure and manage. It might feel complex and intimidating, but with some patience and a little assistance from <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a> you can save a lot of time and stress.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>DDEV-Live is our hosting platform, which not only connects to— and in fact relies on— your project’s Git repository, but also allows you to work with atomic deploys, CI/CD workflows, and many other tools and services you may already be using. With automated deploys as a standard feature and room for customization, it’s possible to get those small pieces of work through the pipeline to staging and production quickly and accurately, every time.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Using Git in your development workflow</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://git-scm.com/\">Git</a> is a free and open source distributed <a href=\"https://git-scm.com/video/what-is-version-control\">version control system</a> used by many of us to collaborate and develop both open source and proprietary software. Every project has its own Git repository, which must be hosted somewhere, often GitHub, GitLab, BitBucket, etc. Our own <a href=\"https://github.com/ddev\">open source projects at DDEV</a> are shared on GitHub, such as the <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a> development environment.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>While there is generally a central repository all work goes into, multiple streams of work can happen simultaneously, be merged without conflict, and you can track source code as well as static files. As <a href=\"https://www.tag1consulting.com/#team\">Tag1’s Greg Lund-Chaix</a> said in his <a href=\"https://youtu.be/fFmYkr8Ck5Y\">recent session on Git and DDEV-Local</a>: always work in a feature branch, pull the latest changes before you add your commit, and no editing on the server! It’s much easier to understand changes when everyone has been making small commits over time in clearly named branches which have been cleanly merged into the main branch of the repository.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Branches also allow you to contain and deploy discrete chunks of work based on the same codebase. For example, a set of new commits to a branch named “testing” can be deployed to a test server while the main “production” branch remains untouched on the production server. Or, a group of changes can be combined and tagged “myproject version 2.0” to capture that moment in development for future reference.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>So, you’re on board and set up with Git in general? You may be seeing some success with automation and the use of Git for version control but it’s been difficult to connect all the pieces and get the entire team into the workflow. To really start smoothing the wrinkles from development to deployment, it’s time to add DDEV-Live.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Deploy from Git to DDEV-Live&nbsp;</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ddev.com/ddev-live/\">DDEV-Live</a> is a modern hosting platform, built from the ground up on open source and <a href=\"https://ddev.com/devops/why-devops-containers-and-tooling-matter-in-digital-transformation/#containers\">cloud native principles</a>. When you connect your DDEV-Live account to your <a href=\"https://docs.ddev.com/providers/\">Git provider</a>, DDEV-Live watches for changes in your designated repositories and automatically deploys when a new commit is detected. That’s the out of the box, simple way to use DDEV-Live and Git.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>You can also <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/DDEV-Live/\">integrate the DDEV-Local development environment with DDEV-Live</a> in a similar fashion, passing code through Git. For <a href=\"https://ddev.com/ddev-live/bringing-ci-cd-to-your-agency-with-ddev-live/\">continuous integration and continuous delivery</a>, you can start adding in additional tools using your <a href=\"https://docs.ddev.com/authentication/#authenticating-with-a-token\">DDEV-Live API token</a>. Follow the tutorials for <a href=\"https://docs.ddev.com/circleci/\">CircleCI</a> or <a href=\"https://docs.ddev.com/jenkins/\">Jenkins</a> integrations, or just use them as inspiration for your own custom workflow. When an action or trigger is recognized by the DDEV-Live platform a new atomic (or zero down time) deployment can be initiated, including the creation of a fresh new container in Kubernetes (the underlying system in DDEV-Live).&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This allows you and your team to take full advantage of Git, creating as many branches and tags as required. You can now set up a workflow to run tests, stage new work, and cut a release to push a new chunk of code. With one code base, we can track many deploys and versions, dependencies via composer, and configurations stored per environment. It’s very granular but connected to that one code base. The hosting industry is moving in this direction, using triggers to create and manage complex or simple workflows that the hosting platform is “aware” of.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This Git-based workflow also supports one of the core concepts behind DDEV, the “<a href=\"https://www.ddev.com/devops/dev-to-deploy-the-evolution-landscape-of-modern-web-development/#12factor\">12 factor app</a>.” For example, Factor #9 is disposability: We are not just creating a new build, we are creating a fresh new container for each new build or site. Or Factor #10, parity between development and production: Especially by working with DDEV-Local and configuring your development environment, you can be certain that your project does work exactly the same in production. Add in a staging environment on DDEV-Live for extra assurance, deployed from a branch named “staging” perhaps, and you’re well on the way to an efficient, safe, sustainable deployment workflow.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Safe deployments and freedom for developers</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>It sounds like a lot, but by using Git to track your project through distributed development instances and DDEV-Live for automated, tagged deployments, you can save the time and manual work of shepherding changes through your release pipeline. The sense of safety and stability generated by automatically building testing and staging environments, or even to <a href=\"https://git-scm.com/docs/git-revert\">reverting</a> changes via Git-based workflows can mean greater innovation and freedom for developers to explore and experiment, achieving more, more easily.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Take a little time to create a test project or copy an existing project into a new hosted Git repository so you can <a href=\"https://docs.ddev.com/getting-started/\">try out DDEV-Live</a> and see the possibilities for your project. Whether you want to connect an existing workflow or finally start using some of the best practices you’ve heard about, there’s a free 10 day trial so you can see how DDEV-Live can support your work.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Thanks to <a href=\"https://ddev.com/author/jroberts/\">Jason Roberts</a>, <a href=\"https://ddev.com/author/elli/\">Elli Ludwigson</a> and <a href=\"https://ddev.com/author/sgrandchamp/\">Steve Grandchamp</a> for collaborating on this blog.</p>\n<!-- /wp:paragraph -->','A Git-based workflow from dev to deploy','','publish','closed','closed','','a-git-based-workflow-from-dev-to-deploy','','','2020-08-19 13:41:36','2020-08-19 19:41:36','',0,'https://ddev.com/?p=3235',0,'post','',0),(3254,16,'2020-08-25 15:17:39','2020-08-25 21:17:39','<span style=\"font-weight: 400;\">We\'re looking forward to the brand new experience of <a href=\"https://events.drupal.org/europe2020/news/drupalcon-barcelona-2020-going-virtual\">DrupalCon Europe in December</a>! Stay tuned to this page for updates on sessions we are presenting, special event offers, as well as DDEV news and updates to our platform! </span>\r\n\r\n<b>What we’re up to:</b>\r\n<ul>\r\n 	<li><a href=\"https://events.drupal.org/europe2020/sessions/drupal-dead-long-live-drupal\">Drupal is dead. Long Live Drupal!</a>\r\n<ul>\r\n 	<li>Join DDEV CTO Kevin Bridges, aka @cyberswat, for a review of the state of open source, the complexity of new paradigms, and how we might manage both the sociological and technical aspects of our current milieu.</li>\r\n 	<li>Tuesday, Dec 8, 2020, 14:30 to 15:10 UTC</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://events.drupal.org/europe2020/bofs/drupal-local-development-ask-me-anything-bof\">BoF session - Local development Ask Me Anything! (AMA)</a>\r\n<ul>\r\n 	<li>DDEV-Local maintainer Randy Fay and anyone who is interested can join this Birds of a Feather session to discuss and collaborate on all things Local Development.</li>\r\n 	<li>Wednesday, Dec 9, 2020 BoF slot 21 at 15:15 - 16:00 UTC</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://events.drupal.org/europe2020/bofs/best-practices-moving-and-deploying-sites-bof\">BoF session - Best practices in moving and deploying sites</a>\r\n<ul>\r\n 	<li>Randy Fay leads a discussion on what is needed to move a site anywhere- local to production, server to server. This session will no doubt mention some vendors, but the idea is to develop and agnostic understanding so users know what they need independent of the vendor.</li>\r\n 	<li>Wednesday, December 09 - 16:15 to 17:00 UTC</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://events.drupal.org/europe2020/sessions/state-drupal-development-environments-panel-discussion\">The state of Drupal Development Environments panel discussion</a>\r\n<ul>\r\n 	<li>Randy Fay will once again join a group of panelists to discuss local development tools for Drupal. The group will include Lando, Docksal, DrupalVM, and more.</li>\r\n 	<li>Thursday, December 10 - 16:15 to 16:55 UTC</li>\r\n</ul>\r\n</li>\r\n 	<li style=\"font-weight: 400;\"><a href=\"https://events.drupal.org/europe2020/contribution\"><span style=\"font-size: 1rem;\">Contribution time!</span></a>\r\n<ul>\r\n 	<li>Be sure to stay tuned in through Friday at DrupalCon so you can get started contributing! Working together on hard problems is why we are so passionate about open source. Join live in the OnAir platform, <a href=\"https://events.drupal.org/europe2020/contribution\">08:00 to 17:00 UTC</a>. We\'ll have Zoom rooms by topic, Drupal Slack as usual, and a first timer\'s workshop at 09:00 UTC. Watch the <a href=\"https://youtu.be/x32hXZ_Weu0\">workshop video here anytime</a>.</li>\r\n 	<li>If you\'d like to get a head start with a local development environment, our <a href=\"http://ddev.com/ddev-local\">DDEV-Local tool</a> is available, just follow the <a href=\"https://ddev.readthedocs.io/en/stable/#installation\">DDEV install steps. </a>Usually at IRL DrupalCons we use <a href=\"http://drupal.org/tools\">drupal.org/tools</a> and the <a href=\"https://github.com/ddev/quicksprint/releases\">Quicksprint package</a> for a more one-size-fits-all approach that takes conference wifi bandwidth into account, but this time we\'re all on our own internet connections! Please do consider downloading and getting set up in advance regardless, hop into the <a href=\"https://drupal.slack.com/archives/C5TQRQZRR\">#ddev channel in Drupal Slack</a> for troubleshooting.</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<b>When</b><span style=\"font-weight: 400;\">: December 8-11 2020, in the CET timezone.</span>\r\n\r\n<b>Where</b><span style=\"font-weight: 400;\">: Online! <a href=\"https://portalapp.kuonicongress.eventsair.com/VirtualAttendeePortal/drupalcon-europe-2020/virtual-drupal-europe/login\">Log in to the OnAir platform with your registration username and password here</a>. For the best help and to find the Drupal community at any time, please visit us in <a href=\"https://www.drupal.org/community/contributor-guide/reference-information/talk/tools/slack\">Drupal Slack</a>.</span>\r\n\r\n<b>Registration</b><span style=\"font-weight: 400;\">: <a href=\"https://events.drupal.org/europe2020/registration-ticket-information\">https://events.drupal.org/europe2020/registration-ticket-information</a></span>\r\n\r\n<b>About the event</b><span style=\"font-weight: 400;\">: DrupalCon is the largest gathering of Drupal users and stakeholders in the world. We get together to share knowledge and experience, connect with old friends and new, and of course contribute back to Drupal as an open source project. </span>\r\n\r\n&nbsp;','DrupalCon Europe 2020','Ready for a whirlwind virtual event? We\'re anticipating more collaborative conversations about Kubernetes, DevOps, GitOps, and the ever changing challenges ahead of us.','publish','closed','closed','','drupalcon-europe-2020','','','2020-12-07 15:17:52','2020-12-07 22:17:52','',0,'https://ddev.com/?post_type=tribe_events&#038;p=3254',0,'tribe_events','',0),(3259,16,'2020-08-25 16:09:11','2020-08-25 22:09:11','<!-- wp:paragraph -->\n<p>DrupalCon Global took me by surprise. With the planning for DrupalCon Minneapolis in a seemingly very distant past, the <a href=\"https://events.drupal.org/global2020/news/drupalcon-global-mega-update\">new virtual format</a> came together in July with a blur of last minute learning and organizing. Everyone who helped coordinate, explain, modify, moderate and more worked very hard to make the experience something unique and useful for attendees and they succeeded! Thank you to the organizers and especially volunteers who worked such long hours around the world.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>With the news that <a href=\"https://events.drupal.org/europe2020/news/drupalcon-barcelona-2020-going-virtual\">DrupalCon Barcelona will be completely virtual</a> as “DrupalCon Europe 2020,” which I believe is absolutely the right, though challenging, course to take, I’d like to share a few thoughts and highlights from DrupalCon Global.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>DrupalCon Global exceeded expectations</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The digital format enabled more people to attend DrupalCon, especially via the <a href=\"https://events.drupal.org/global2020/news/drupalcon-global-wrap\">Drupal Association’s scholarship program</a>. A virtual event can be more accessible for many people physically and mentally, as well as opening up the opportunity to people who can’t leave their family or fly across the world (regardless of pandemics). This is <em>fantastic</em>, I can’t emphasize enough the importance of inclusivity. When more people can join, participate, share, and learn the value to individuals and community as a whole far outweighs any direct business benefit.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The sessions I saw were all excellent, and while the live text chat next to a session in <a href=\"http://hopin.to/\">Hopin</a> was sometimes distracting, it was usually useful for sharing links, gathering questions, and connecting with other attendees. We don’t usually pass notes in person, but we sure did virtually. The “hallway track” morphed fairly well into the chat, as well as the chats in exhibitor booths where people could have conversations and wave hello at friends.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<blockquote class=\"twitter-tweet\" data-dnt=\"true\"><p lang=\"en\" dir=\"ltr\">So many things make sense in <a href=\"https://twitter.com/LeslieMac?ref_src=twsrc%5Etfw\">@LeslieMac</a>\'s <a href=\"https://twitter.com/hashtag/DrupalConGlobal?src=hash&amp;ref_src=twsrc%5Etfw\">#DrupalConGlobal</a> presentation: Empower local community members to do the work. Local communities trust the people they know and vice versa. <br><br>The joy people feel when they feel welcome and part of a space is so clear.?<br><br>Thank you Leslie! <a href=\"https://t.co/9CxhnXca2U\">pic.twitter.com/9CxhnXca2U</a></p>— Elli L ? (@ekl1773) <a href=\"https://twitter.com/ekl1773/status/1283460884661178369?ref_src=twsrc%5Etfw\">July 15, 2020</a></blockquote> <script async=\"\" src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://youtu.be/_u3JY5yiuBI\">Leslie Mac’s session</a> on event and initiative organizing, working with locals, and respecting the knowledge of the people who know their communities especially resonated. She recommended adapting your brand to the local community, rather than assuming the “national” message fits every smaller group the same. This applies well to the Drupal community and local meetups, as well as DDEV and the various CMS communities who use our tools. Knowing your audience and <a href=\"https://vimeo.com/showcase/7303843/video/441091433\">making sure they are represented</a> in the creation of your project is a frequent recent theme.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Contribution time during the week and on Friday seemed to go well for mentors and contributors. Thank you especially to Rachel Lawson, Chris Darke and Matthew Radcliffe for the additional work putting together an <a href=\"https://youtu.be/0K0uIgKaVNQ\">on-demand workshop</a> and <a href=\"https://contrib2020.getopensocial.net/\">contribution website</a>. DDEV-Local maintainer and mentor <a href=\"https://ddev.com/author/rfay/\">Randy Fay</a> also spun up some Zoom rooms to help contributors get started with their <a href=\"https://github.com/ddev/ddev\">local development environments</a>.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>There were more sessions that rocked than I have space for in this blog post. <a href=\"https://ddev.com/event/drupalcon-global-2020/\">Our own plans</a> changed a lot for this event, but Randy and I spoke in a couple sessions (EDIT: the <a href=\"https://www.youtube.com/playlist?list=PLpeDXSh4nHjQzENjcpLo6nO3A0AkBdF8w\">public youtube links</a> are live!):</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://youtu.be/psizofJoDg8\">Local Development Tools Panel</a> - Randy discussed various tools, the trend towards Docker, and what\'s next</li><li><a href=\"https://youtu.be/JIv6nbf9lUI\">Drupal Diversity and Inclusion session</a> - Elli presented some simple ways to include and lift up others</li><li><a href=\"https://youtu.be/6KQOEqX-b-4\">Drupal Initiatives plenary</a> - Elli presented her 5 minute \"come contribute to Drupal!\" pitch as Drupal core mentoring lead</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:html -->\n<blockquote class=\"twitter-tweet\" data-dnt=\"true\"><p lang=\"en\" dir=\"ltr\">Thank you <a href=\"https://twitter.com/hashtag/Drupal?src=hash&amp;ref_src=twsrc%5Etfw\">#Drupal</a> initiative leads for all the work you do!<br><br>Spot the <a href=\"https://twitter.com/hashtag/DDEV?src=hash&amp;ref_src=twsrc%5Etfw\">#DDEV</a> tshirt ? Happy to have <a href=\"https://twitter.com/ekl1773?ref_src=twsrc%5Etfw\">@ekl1773</a> \"on the ground\" at <a href=\"https://twitter.com/hashtag/DrupalConGlobal?src=hash&amp;ref_src=twsrc%5Etfw\">#DrupalConGlobal</a>. Get ready for some <a href=\"https://twitter.com/hashtag/DrupalContribution?src=hash&amp;ref_src=twsrc%5Etfw\">#DrupalContribution</a>! <a href=\"https://t.co/eNXLLfd8Qm\">https://t.co/eNXLLfd8Qm</a></p>— DDEV (@ddev) <a href=\"https://twitter.com/ddev/status/1283882981292224514?ref_src=twsrc%5Etfw\">July 16, 2020</a></blockquote> <script async=\"\" src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>The virtual conference juggling act</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>There was a lot going on for 12+ hours a day, 4 days straight. It was a little difficult to juggle the schedule from the events.drupal.org site with the schedule in Hopin, plus the addition of the contribution site and schedule. From the virtual events I’ve attended, there has been no unified solution to this. For Drupal contributions, we also wanted to bring new contributors into the regular space they would be using in the future, <a href=\"https://drupal.org/slack\">Slack</a>. Plus live tweets! I was holding down Twitter for <a href=\"https://twitter.com/search?q=%40ddev%20%23drupalconglobal&amp;src=typed_query&amp;f=live\">DDEV</a>, <a href=\"https://twitter.com/search?q=%40ekl1773%20%23drupalconglobal&amp;src=typed_query&amp;f=live\">myself</a>, and <a href=\"https://twitter.com/search?q=%40drupalmentoring%20%23drupalconglobal&amp;src=typed_query&amp;f=live\">Drupal Mentoring</a>, and following tweet responses to sessions.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Understanding the possibilities for the booths and how attendees would interact with them took actually being in the booth live during the event. The value for sponsors was a little unclear, especially because sponsors often see the greatest value in “leads” which are a little more difficult to acquire and retain virtually. Reorienting to find other, more nuanced value such as via one on one demos, workshops, Q&amp;A or more gamification might be the answer.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Supporting the open source community</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Whatever the platform and procedures, talking about it and sharing it early and often is key. For DrupalCon Global there were many demos, but details also kept changing, everything was very new, and until we could really get in and start participating with the full group it was hard to know how best to use the Hopin platform.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For booth staffers, offering something engaging and easy to drop in and out of seemed&nbsp; to be most popular (collaborative DJing? Making pasta? Testing hot sauces??). Offer something a bit fun alongside regular, clearly advertised product demo times and have additional team members on hand to take questions in the chat, and take notes for followup.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>My personal experience is mostly from a developer/speaker perspective, so I would prefer to have the <a href=\"https://www.youtube.com/playlist?list=PLpeDXSh4nHjQzENjcpLo6nO3A0AkBdF8w\">session recordings</a> publicly available soon after the event. Many speakers want to share with their team, family, clients, future employers. While I suspect the password has made the rounds, in the spirit of open source the videos should be freely available as soon as possible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Staying flexible is also crucial. There were a lot of rules at first, but as we became familiar with the platform I noticed that updates were made both to Hopin and to our DrupalCon instance to enable things that were going well. For example, Tim Lehnen at the Drupal Association was very open to giving us extra “live” booth time for Drupal Diversity and Inclusion, and many sessions/BoFs wound up having larger group chats. That’s the spirit of DrupalCon!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Maybe for <a href=\"https://ddev.com/event/drupalcon-europe-2020/\">DrupalCon Europe</a> we can implement <a href=\"https://twitter.com/ekl1773/status/1283980831032324096\">the holographic mentor idea</a> as well.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>See you on the Slacks</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The benefits of a virtual conference are huge. Still, nothing is quite the same as seeing friends in person, exploring a new place together, and introducing new folks to the entire bustling experience. They are simply different creatures, there is no equating the two. I hope that in the future we can have DrupalCon Global every year, in combination with more localized events like <a href=\"https://www.drupical.com/\">Drupal Camps</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We’re looking forward to seeing you in “Europe” and I am looking forward to working with everyone to organize and plan for more contribution mentoring and DDI activities! Thank you again for a really great virtual DrupalCon.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','DrupalCon Global Retrospective','','publish','closed','closed','','drupalcon-global-retrospective','','','2020-09-03 07:41:23','2020-09-03 13:41:23','',0,'https://ddev.com/?p=3259',0,'post','',0),(3286,16,'2020-09-09 10:27:37','2020-09-09 16:27:37','','online','','publish','closed','closed','','online','','','2020-09-09 10:27:37','2020-09-09 16:27:37','',0,'https://ddev.com/venue/online/',0,'tribe_venue','',0),(3288,1,'2020-09-24 13:59:36','2020-09-24 19:59:36','<!-- wp:paragraph -->\n<p><em>This is a guest post from </em><a href=\"https://github.com/NBZ4live\"><em>Sergey Fayngold</em></a><em>, Head of Web Development at </em><a href=\"https://my.games/\"><em>MY.GAMES</em></a><em> in Amsterdam. Sergey also </em><a href=\"https://github.com/ddev/ddev/releases/tag/v1.15.0\"><em>contributed to DDEV-Local</em></a><em> by adding explicit support for Laravel.</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In terms of local development environments (LDE), Laravel does have a lot of options. We have Homestead, Valet, Laradock, etc (In general, any PHP LDE can be tweaked to support <a href=\"https://laravel.com/\">Laravel</a>). They all do the job in their scopes. Now it\'s also possible to work on Laravel with <a href=\"https://ddev.com/ddev-local/\">DDEV-Local</a>, an open source, Docker-based LDE. So why consider one more option?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>“Everyone should use the tools that push their productivity the most” — This is an important point for many developers and teams. And a lot of different tools are available; users have lots of choice.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>When you do set up an LDE individually, in most cases you want something that does the job with the least amount of effort to install and maintain it. As a Laravel developer, the first choice might be <a href=\"https://laravel.com/docs/valet\">Laravel Valet</a> (on Mac) or <a href=\"https://laravel.com/docs/homestead\">Homestead</a>, which are official Laravel tools and are mentioned in the <a href=\"https://laravel.com/docs\">Laravel documentation</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>But when teams come together, a debate occurs about “what/how to use local development for the particular project/s.” At this point, worlds collide. Everyone is used to their own toolchain, might have a different OS, each project might have special requirements. All of this could become a “Holy War of Local Development Environments” inside the team or lead to everyone just using the tools they are familiar with.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For a long time I have had the opinion that there is no need for big holy wars (debate yes, but not wars) about which tools are better. And, people should not be forced into using certain hardware, OS, IDE, etc. If a team member is productive in VS Code, then why force this person to use PHPStorm? (Just an example).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>But in terms of LDE, if a team comes together and some team members use Valet on Mac, others prefer Laradock on Linux instead, and the Windows users go with Homestead, you could end up having to learn all of them to help solve problems with other team members’ preferred tool in the context of the project. Especially if the project has additional requirements like FQDN for SSO, custom Nginx configuration, etc.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Even if everything does run smoothly for a long time, you can end up with the “it works on my machine” situation. Team member A pulls the changes and everything breaks because team member B updated their local PHP version and some Composer dependencies require a certain PHP version. That leaves a lot of room for error, lack of safety in the process, and conflict on the team.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>How does DDEV solve the problem?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>As hinted above, I was dealing with a lot of different “tools of choice” across my team to help customize them to fit our projects’ requirements. We had team members who used Laradock, others (including myself) were using Valet, and some even used plain Nginx with custom configs provided by other team members. Sometimes it was hard to help everyone solve problems specific to their tool (some I described earlier).&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Meanwhile, I was searching for one solution which would help to unify the experience by providing all the features they need, but still be very easy to switch to (regardless of hardware and OS) and of course easy for new team members to get up and running. And at some point I found <a href=\"https://github.com/ddev/ddev\">DDEV</a> and set myself the final goal:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Cloning the project should be (almost) enough for getting up and running regardless of the skills of the team member.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local</a> combines a lot of the benefits of the other Laravel LDEs into one solution. In the context of a team, DDEV can bring additional benefits. It’s easy to learn for the members who set it up and customize it. And it’s super easy to use for the rest of the team to run multiple projects on any OS.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>After initial setup and configuration of the project, you can commit the DDEV configuration in your project repository. The next team member only need clone the repo and run <code>ddev start</code>, <code>ddev composer install</code> and <code>ddev exec artisan</code> (to run migrations, etc) inside of the project (or you can simply define a custom command that will replace them). Every team member can override parts of the config (like enabling NFS support or Xdebug) without committing it. The time between cloning and starting work on the code is reduced to almost nothing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In the end, the switch to DDEV did save a lot of time on the team (I have not heard about any LDE problems, since we switched :D ). That\'s also the reason why I decided to <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#laravel-quickstart\">“officially” add Laravel to DDEV-Local</a> as a contribution to the open source project.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Additional tips for Laravel + DDEV</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>1. Add a dedicated DB connection for DDEV</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Normally, you can define the values of all the DB_* env variables to use DDEV’s DB container (it will even be proposed by DDEV when you start your project). But you can define a DDEV DB connection in your config/database.php to make it even easier. Here is an example:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:code -->\n<pre class=\"wp-block-code\"><code>&lt;?php\n\nreturn [\n...\n    \'connections\' => [\n...\n        \'ddev\' => [\n            \'driver\' => \'mysql\',\n            \'host\' => \'db\',\n            \'port\' => 3306,\n            \'database\' => \'db\',\n            \'username\' => \'db\',\n            \'password\' => \'db\',\n            \'unix_socket\' => \'\',\n            \'charset\' => \'utf8mb4\',\n            \'collation\' => \'utf8mb4_unicode_ci\',\n            \'prefix\' => \'\',\n            \'strict\' => true,\n            \'engine\' => null,\n        ],\n...\n];</code></pre>\n<!-- /wp:code -->\n\n<!-- wp:paragraph -->\n<p>Alternatively you can (and probably should) change the DB_* values in the .env.example, to bring the number of changes the end user needs to do to 0.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>2. Add the artisan command to DDEV</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Normally to execute artisan commands inside the DDEV web container you would need to use <code>ddev exec php artisan …</code>. But to make it easier for yourself and your team, you could add the following content to the .ddev/commands/web/artisan file:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:code -->\n<pre class=\"wp-block-code\"><code>#!/bin/bash\n\n## #ddev-generated\n## Description: Run artisan inside the web container\n## Usage: artisan [flags] [args]\n## Example: \"ddev artisan list\" or \"ddev artisan cache:clear\"\n\nphp artisan $@</code></pre>\n<!-- /wp:code -->\n\n<!-- wp:paragraph -->\n<p>This way you can now just use <code>ddev artisan …</code>. It\'s trifling, but pleasant.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>3. Share It!</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Many of us work on more than one project. Some projects could require similar customizations (ddev commands, nginx customization, etc). To simplify project updates, you can:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Place these files in a composer package</li><li>Require it in all your projects</li><li>Commit to all projects a command that will update this package and copy the ddev config parts to the project’s .ddev directory.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>4. Provide an example for config overrides</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>In Laravel we are used to having an .env.example. You should do the same for your colleagues in the .ddev file. You can commit the .ddev/config.local.yaml.example with some frequently used overrides. This should make it easier for everyone to override the obvious things. Here’s the contents of my config.local.yaml.example:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:code -->\n<pre class=\"wp-block-code\"><code># router_http_port: &lt;port>  # Port to be used for http (if something else is running on default port \"80\")\nrouter_http_port: \"8008\"\n\n# router_https_port: &lt;port> # Port for https (if something else is running on default port \"443\")\nrouter_https_port: \"4430\"\n\n# xdebug_enabled: false  # Set to true to enable xdebug and \"ddev start\" or \"ddev restart\"\n# Note that for most people the commands\n# \"ddev exec enable_xdebug\" and \"ddev exec disable_xdebug\" work better,\n# as leaving xdebug enabled all the time is a big performance hit.\nxdebug_enabled: false\n\n# nfs_mount_enabled: false\n# Great performance improvement but requires host configuration first.\n# See https://ddev.readthedocs.io/en/stable/users/performance/#using-nfs-to-mount-the-project-into-the-container\nnfs_mount_enabled: false</code></pre>\n<!-- /wp:code -->\n\n<!-- wp:heading -->\n<h2>Conclusion</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Today, as Laravel developers, we have a lot of solutions to make our workflow more efficient and enjoyable. Now with DDEV-Local we get one tool that helps us to push our productivity and ensures comfort by committing configuration that runs the same local development environment on every team members’ machine. Get started with your own Laravel project and DDEV using the <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#laravel-quickstart\">quickstart guide</a>!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->','DDEV-Local for Laravel teams','Now it\'s also possible to work on Laravel with DDEV-Local, an open source, Docker-based LDE. So why consider one more option?','publish','closed','closed','','ddev-local-for-laravel-teams','','','2020-09-25 06:37:02','2020-09-25 12:37:02','',0,'https://www.ddev.com/?p=3288',0,'post','',0),(3307,2,'2020-10-05 16:35:48','2020-10-05 22:35:48','<!-- wp:heading -->\n<h2>Why did we build local development and web hosting solutions?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The complexity of early enterprise <a href=\"https://www.drupal.org/case-study/popular-science-magazine\">Drupal projects such as www.popsci.com</a> demonstrated the difficulty of moving between stages in the development process and replicating the stresses of the production site during development. Every team member had to configure their local AMP stack for every project they touched, with no easy way to ensure parity from one machine to the next. Delivering a code base and assets to the client’s internal operations team for deployment meant physically flying to headquarters and sitting down with the team to communicate the requirements of the application and associated services.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>That meant that any time a project moved, whether between team members for collaboration or to staging and production servers, environmental differences between development and delivery often surfaced, leading to hours of debugging and validation. As we struggled with handoffs to other team members and to the client’s operations team, we began to realize something was seriously broken with the process and the tools. How could a 15 minute code update take over 3 hours to get everything synced and updated live?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The problem was complexity. Each project needed environment configuration, importing assets, setting up customized services, databases, configuring web servers, memory allocation… etc. Once the site was delivered it would be under load experiencing pressure that was not easy to replicate in development. As complexity increased, we needed more hardware and extremely talented engineers who could navigate complexity and who weren’t easy to find. This led to exploring a solution that could manage the complexity in a way junior engineers could adapt to quickly.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Solving complexity in web development</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>To start solving this problem of complexity and collaboration, we began by simply documenting the process. By writing down the steps required to get a project set up on a local machine or moved to a production server, we were able to standardize and at least smooth out some of the speedbumps. Still, creating these complex sites for clients with lofty goals and very specific plans was causing us some big problems. A manual checklist wasn’t going to be enough for us to do this at scale, for multiple projects or multiple clients.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This realization led us to the major focal points for what would become the <a href=\"https://docs.ddev.com/introduction/\">DDEV solution</a>. First, even using scripted install profiles and migrations, subtle differences would surface in environment configurations. We needed a more unified, reliable way to replicate production environments on local machines.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We also had to have a way to merge and deploy changes automatically, in a way that could be viewed, tested and approved as a whole project, rather than individual PRs. It became difficult to find a place to host the projects clients had us building. None of the hosting providers at the time provided managed services that were designed to help the site succeed, hence the need on <em>our</em> team for engineers skilled in multiple disciplines to do the server management.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The concept of improving local development began to take hold initially not by planning to build a tool, but by scripting our checklists into install and migration profiles. These scripts were then converted to Jenkins jobs to ensure management of external environments. While that was a huge improvement, it was very fragile and prone to unexpected errors in different environments.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The concept of finding a way to pull all of the changes together as a whole and run them in an environment that was fast enough and could meet our needs led us down the road to “self-hosting.” At the time, as an agency building these sites, we realized that while we <em>could</em> build a self-hosted production environment, that really was not our core business.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Building on the lessons we learned from managing agencies, building enterprise sites, combined with deep open source knowledge, we decided to spin out <a href=\"https://www.ddev.com/about/\">DDEV</a> as a separate company. Our focus would be on advancing developers in open source communities by sharing the tools and processes we built to solve our own problems.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>It was at this intersection that we realized there was a significant gap for web developers, specifically PHP developers, that we were right in the middle of trying to solve. Like most startups, we looked in the mirror and said, “We can build a product to do this… it can’t be that difficult!”</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>It turns out that solving a complex problem is complex. Our overarching design goals from the very beginning for DDEV were focused on:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Reducing and managing complexity in the development process</li><li>Creating an easy way for team members to get a local copy of a project to work on</li><li>Creating a repeatable way for teams to work together using this process</li><li>Making best practices the easiest choice for developers</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>If doing something the right way isn’t also the easiest and fastest way, then developers won’t be happy about it and their productivity will be adversely affected. To unify and simplify the experience, we’ve focused on providing a complete end to end solution for the development and deployment of complex web projects. Docker and Kubernetes have also enabled us to build the platform we envisioned thanks to mature container technology and communities.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We’ve taken into account the many steps in the process of designing, building, deploying and maintaining web apps and digital properties. Each project has unique requirements. Each client has different technologies in play. Each developer has unique skill sets. We are focused on creating a solution that allows each developer, client, and project a way to work together no matter what part of the project they are working on.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>DDEV local development and hosting today</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>In 2017 we released our first supported version of our local development tool, <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a>. The tool is fully open sourced under the Apache license and has benefited from over 100 contributors adding to the code, documentation, as well as giving presentations on usage around the world. DDEV-Local has attracted thousands of developers to adopt it as their standard because of the quick startup time, ability to run multiple projects at once, share with colleagues and collaborators, and customize configurations.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>There are <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#quickstart-guides\">DDEV-Local quickstart guides</a> available for Drupal, TYPO3, WordPress, Backdrop, Magento and Laravel, but just about any PHP project will easily run in DDEV. Some other top web applications that use DDEV include Sulu, CraftCMS, Symfony, Flexitype, Bludit, and plenty more, thanks again to the contributors who share their <a href=\"https://github.com/ddev/ddev-contrib\">recipes</a> and <a href=\"https://github.com/ddev/awesome-ddev\">blogs</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Some common daily use cases include sales demos, client sign off, team input, testing new modules or code and reviewing patches in the issue queue. DDEV has become part and parcel of daily work for thousands of PHP developers. As teams and individuals see success with DDEV, scaling that success by encouraging workflow changes, creating clean development environments and increasing collaboration is something that DDEV is committed to and drives the continued innovation of this product.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In 2018 we released the first version of <a href=\"https://ddev.com/ddev-live/\">DDEV-Live</a>, our Kubernetes-based hosting platform. Earlier this year, in March of 2020, we released the second major version of DDEV-Live, focusing on more cloud native principles, GitOps concepts, and designed around an <a href=\"https://docs.ddev.com/\">API-first architecture</a> to allow developers an easy way to communicate directly with the platform.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>What’s next?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Later this year we will be releasing some new functionality that will act as a bridge between the DDEV-Local development tool and the DDEV-Live hosting platform. We will continue to focus on enabling teams to have the best workflow dynamics possible through developing the DDEV API to offer flexibility and customization for all team project needs.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','The DDEV Story','','publish','closed','closed','','the-ddev-story','','','2020-10-05 16:35:49','2020-10-05 22:35:49','',0,'https://ddev.com/?p=3307',0,'post','',0),(3358,1,'2020-10-13 12:13:12','2020-10-13 18:13:12','','BlogPosting','','publish','closed','closed','','blogposting','','','2020-10-13 12:13:12','2020-10-13 18:13:12','',0,'https://ddev.com/uncategorized/blogposting/',0,'schema','',0),(3359,1,'2020-10-13 12:13:12','2020-10-13 18:13:12','','WebPage','','publish','closed','closed','','webpage','','','2020-10-13 12:13:12','2020-10-13 18:13:12','',0,'https://ddev.com/uncategorized/webpage/',0,'schema','',0),(3360,8,'2020-10-13 12:21:45','2020-10-13 18:21:45','','LocalBusiness','','publish','closed','closed','','localbusiness','','','2020-10-13 12:25:51','2020-10-13 18:25:51','',0,'https://ddev.com/?schema=localbusiness',0,'schema','',0),(3364,16,'2020-10-13 15:31:15','2020-10-13 21:31:15','<!-- wp:paragraph -->\n<p>Are you running a project using the <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a> development environment? Have you heard that we also offer a production environment, <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a>? Here’s a handy guide to how to start with a project in DDEV-Local and walk through the steps to deploy to DDEV-Live hosting. All of the detailed documentation can be found in the DDEV docs, which we’ll link to throughout this post.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>DDEV is all about end to end integration so your experience is unified from local development to deployment. Our Kubernetes-based hosting platform follows the same <a href=\"https://ddev.com/workflow/the-ddev-story/\">vision</a> as the Docker-based local environment to give you the speed, consistency, and <a href=\"https://hackernoon.com/ever-wondered-why-we-use-containers-in-devops-l5113wif\">flexibility of containers</a> without the learning curve.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The key requirement is that you have a hosted Git repository for DDEV-Live to pull from, so that your code is <a href=\"https://ddev.com/ddev-live/a-git-based-workflow-from-dev-to-deploy/\">managed and centralized</a>, supporting GitOps best practices. You will also need up to date versions of both the ddev CLI and the ddev-live CLI (links below). Please read through all the steps so you understand what’s happening. Let’s get started!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>How do I take my project from DDEV-Local to DDEV-Live?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><em>Helpful hint: there’s loads of info in the ddev-live CLI, just run <code>ddev-live</code> and drill down with the <code>--help</code> flag on any command.&nbsp;</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li><strong>You have a project in DDEV-Local</strong><br>If you’re reading this, you likely already have a project running locally with DDEV-Local. <em>If you don’t</em> have a project you’d like to work with for this guide, or you’d like a clean project for testing:<ol><li><a href=\"https://ddev.readthedocs.io/en/stable/#installation\">Install or update the ddev cli</a> (requires Docker).</li><li>Then use a <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#quickstart-guides\">quickstart guide</a> to set up a simple Drupal, TYPO3 or WordPress site, preferably using Composer. You might also <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#getting-started\">check out an existing project</a> of your own. <br><em>Pro tip: Use the same name for your project when configuring DDEV-Local and DDEV-Live for easy end to end integration in the future.</em></li><li>Set up and configure Git for this project if you haven’t already.<br><br></li></ol></li><li><strong>Sign up for DDEV-Live</strong><br>Follow the <a href=\"https://docs.ddev.com/getting-started/\">Getting Started Guide</a> in the DDEV-Live documentation to set up your account  and connect to our platform (If you haven’t already. If you have an older account and you need a reset <a href=\"https://docs.ddev.com/support/\">please let us know</a>). Your project must be pushed to a remote repository on GitHub or GitLab PaaS to work with DDEV. We’re continuing to build out support for GitLab.com and other Git <a href=\"https://docs.ddev.com/providers/\">providers</a>.&nbsp;<ol><li>Sign in at <a href=\"https://dash.ddev.com/\">dash.ddev.com</a>, make note of your entry for “organization” for reference in steps below.</li><li>Enter payment information. A new DDEV-Live subscription includes a free 10 day trial for personal site hosting, after which you will be billed.</li><li>[If using GitHub, <a href=\"https://docs.ddev.com/github/\">install the DDEV-Live GitHub app</a>.]</li><li>[If using self-hosted GitLab, follow <a href=\"https://docs.ddev.com/gitlab/\">the docs here</a>.]</li><li><a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">Install (or update!) the ddev-live CLI</a> and authenticate the CLI with the DDEV platform.</li><li>Set your <a href=\"https://docs.ddev.com/organizations/\">default organization</a>.<br><br></li></ol></li><li><strong>Preparing for deployment</strong><br>Note: You can run Composer during the site creation on DDEV-Live in the next step. Review your configurations, --dev flags and .gitignore at this stage.<ol><li>Commit your local changes in Git and push to the hosted repository branch or tag you want to use for DDEV deployments. Keep in mind that any future pushes to this branch or tag will trigger a deploy to DDEV.</li><li>Take note of your php version, CMS version, and docroot for the next step.<br><br></li></ol></li><li><strong>Deploying your site on DDEV-Live</strong><br>This is the exciting part. Now you can create a DDEV-Live <a href=\"https://docs.ddev.com/sites/\">site</a> from your Git repository. There are three CMS specific guides available, <a href=\"https://docs.ddev.com/drupal-guide/\">Drupal</a>, <a href=\"https://docs.ddev.com/typo3-guide/\">TYPO3</a> and <a href=\"https://docs.ddev.com/wordpress-guide/\">WordPress</a>. Generic PHP support is currently under development.<ol><li>With your authenticated ddev-live cli, run <a href=\"https://docs.ddev.com/sites/\"><code>ddev-live create site …</code></a> with appropriate flags (<code>--run-composer-install</code>, <code>--docroot</code>, <code>--php-version</code>...) and reference to your Git repo/branch/tag. Your site will spin up on fresh resources inside DDEV-Live, returning a preview URL when it’s ready.&nbsp;</li><li>Use <code>ddev-live describe site &lt;site&gt;</code> to check readiness.</li><li>Upload any assets such as <a href=\"https://docs.ddev.com/databases/#pushing-databases\">databases</a> and <a href=\"https://docs.ddev.com/files/#pushing-files\">files</a>.</li><li>Configure your <a href=\"https://docs.ddev.com/hostnames/#updating-dns\">DNS</a>, <a href=\"https://docs.ddev.com/hostnames/\">hostnames</a>, and <a href=\"https://docs.ddev.com/tls/\">TLS</a> as needed.&nbsp;</li></ol></li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Working with DDEV: next steps</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Now that your site is live, you can keep working locally and use Git to manage your releases. For example, you may have set up DDEV-Live to track a Git tag such as “production.” Now any time you push commits to that tag they’ll deploy to DDEV.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you need to bring your production site down to your local, or to another local machine, use the <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/DDEV-Live/\">integration tool in DDEV-Local</a>. Set up the machine with both of the cli tools, authenticate, checkout the project repository and run <code>ddev pull</code> to import the project assets from DDEV-Live. You will also want to ensure that you’re <a href=\"https://www.drush.org/commands/10.x/sql_sanitize/\">sanitizing the database</a> once it’s on your computer. Continue to work with DDEV-Live as above by making commits and pushing to your DDEV-tracked repository.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>There’s a lot more that’s possible with DDEV. Take a look at some tools like <a href=\"https://docs.ddev.com/exec/\"><code>ddev-live exec</code></a> and <a href=\"https://docs.ddev.com/variables/\"><code>ddev-live config variable</code></a> for starters. Send us your <a href=\"https://docs.ddev.com/support/\">feedback</a> anytime! We <a href=\"https://ddev.com/ddev-live/the-ddev-live-hosting-experience-livestreamed/\">really appreciate it</a> and it helps everyone using the platform. Thank you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Conclusion:&nbsp;</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Now you can work with DDEV for local development and deploy quickly to our hosting platform. The things you want to achieve are actually already within reach, we just give you some structure to build on with a Git-centric workflow to reduce complexity in deployment and collaboration. We just released a couple of key features that will support these concepts. <a href=\"https://docs.ddev.com/site-tags/\">Site tagging</a> and <a href=\"https://docs.ddev.com/sites/#setting-expiration-on-your-site\">site expirations</a> are already available on DDEV-Live. These features will join others this fall as we build out something along the lines of on-demand, public-facing staging and testing sites that will be ephemeral and billed separately from permanent sites.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Stay tuned via our <a href=\"http://eepurl.com/gFfwFb\">newsletter</a> or <a href=\"https://twitter.com/ddev\">Twitter</a> for updates!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','How to deploy a site with DDEV','','publish','closed','closed','','how-to-deploy-a-site-with-ddev','','','2020-11-02 15:18:25','2020-11-02 22:18:25','',0,'https://ddev.com/?p=3364',0,'post','',0),(3431,16,'2020-10-15 09:50:07','2020-10-15 15:50:07','We are speaking at Bay Area Drupal Camp (BADCamp) 14-17 October 2020! Join us to connect with the local Drupal community, get hands-on experience with <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a> tips and tricks and more!\r\n<ul>\r\n 	<li>Thursday: DevOps summit!\r\n<ul>\r\n 	<li>DDEV-Local maintainer <a href=\"https://ddev.com/author/rfay/\">Randy Fay</a> will be presenting a lightning talk during the DevOps summit at 09:50 am PT. <a href=\"https://app.hopin.to/events/badcamp-2020-trainings-summits\">Join the Hopin</a>.</li>\r\n</ul>\r\n</li>\r\n 	<li>Friday: a DDEV BoF\r\n<ul>\r\n 	<li>Randy will lead a Birds of a Feather session to chat with you about any DDEV questions you might have. Whether you\'re an experienced DDEV-Local user with lots of customizations or just starting out <a href=\"https://github.com/ddev/ddev\">setting up DDEV for your local development environment</a>, this is the place to be. <a href=\"https://hopin.to/events/badcamp-2020-sessions\">Join the BADCamp sessions Hopin</a> at 10am PT.</li>\r\n</ul>\r\n</li>\r\n 	<li>Friday session: <a href=\"https://2020.badcamp.org/session/making-better-community-better-software-and-better-world\">Making a better community, better software, and a better world</a>\r\n<ul>\r\n 	<li>DDEV community/marketing manager <a href=\"https://ddev.com/author/elli/\">Elli Ludwigson</a> joins Alanna Burke and Ruby Sinreich as the Drupal Diversity and Inclusion Leadership team presents information and ideas for making our community an equitable place for everyone. Join in the <a href=\"https://hopin.to/events/badcamp-2020-sessions\">sessions Hopin</a> at 11am PT.</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://u\">Contribution time!</a>\r\n<ul>\r\n 	<li>On Friday and Saturday the Contribution Lounge will be open from 1-4 pm PT. Join teams working on issues or to get started with how to contribute to Drupal as an open source CMS</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>When</strong>: 14-17 October 2020\r\n\r\n<strong>Where</strong>: Virtual! The event takes place in two Hopin sessions, one for trainings/summits and one for sessions.\r\n\r\n<strong>Registration</strong>: The event is free! https://2020.badcamp.org/\r\n\r\n<strong>About</strong>: BADCamp is a four-day annual event celebrating open-source software, usually held in Berkeley, California. The event is 100% volunteer organized, and is free for attendees. The event includes talks, training, and summits such as the Nonprofit Summit (NPS.)','BADCamp 2020','','publish','closed','closed','','badcamp-2020','','','2020-10-15 09:53:16','2020-10-15 15:53:16','',0,'https://ddev.com/?post_type=tribe_events&#038;p=3431',0,'tribe_events','',0),(3499,1,'2020-10-28 15:06:53','2020-10-28 21:06:53','<!-- wp:paragraph -->\n<p><em>This is a guest post from </em><a href=\"https://twitter.com/bennimack\"><em>Benni Mack</em></a><em>, CTO of the </em><a href=\"https://b13.com/\"><em>digital agency b13</em></a><em>, located in Germany. He’s been the project lead for </em><a href=\"https://typo3.org/\"><em>TYPO3</em></a><em>, an Enterprise CMS based on PHP, for the last 6 years, steering contributors and developers around the TYPO3 Ecosystem through his passion for Open Source and PHP.</em> This is part one of a two part series. <a href=\"https://www.ddev.com/ddev-live/why-your-local-dev-environment-should-match-production/\">Find part two here</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Introduction</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>I’ve been a web developer for over 20 years, in which time my work shifted from HTML-only to dynamically built websites with PHP, Java, Ruby, and JavaScript. Especially with PHP and other non-compiled programming languages, it was an “easy fix” to work directly on the production web server to see my changes – even when those changes weren’t working. However, our company b13 shifted to using <a href=\"https://git-scm.com/\">Git as a Version Control System (VCS)</a> in 2012, and looking back, I have no regrets about making that change. Here are a few WHYs on the power of a good development setup for myself and my company.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>The Need for Git</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>When working as a single developer, keeping everything in a version control system seems a bit overkill. But Git has saved my butt hundreds of times. With Git:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://git-scm.com/book/en/v2/Git-Basics-Viewing-the-Commit-History\">History</a>: I can find out exactly WHEN I added or changed some code lines, and if I stick to proper commit messages, WHY I changed something. This helps me trace down bugs more efficiently. And, regarding <a href=\"https://git-scm.com/book/en/v2/Git-Basics-Recording-Changes-to-the-Repository#_committing_changes\">commit messages</a>: Especially when fixing hard-to-fix bugs, I set the commit message to a “Note to Future-Self” — because I can’t remember why I did a specific change 6 months ago. This does not replace a good habit of writing tests of course, but it acts as additional help for myself when maintaining code.</li><li><a href=\"https://git-scm.com/book/en/v2/Git-Branching-Branches-in-a-Nutshell\">Branching</a>: I can work on multiple things in parallel in branches, or keep quick changes I found during browsing through existing code by changing something and putting it “in my stash.”</li><li><a href=\"https://git-scm.com/book/en/v2/Distributed-Git-Distributed-Workflows\">Collaboration</a>: Even if you start out as a single developer, at some point you may need to share your code with somebody else. Git has you covered, including all of the history and all of the branches. A Git repository can be cloned from any kind of remote (even from a colleagues’ computer), there is no central repository needed.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>If you fear the Command Line when thinking about Git, I can warmly recommend <a href=\"https://www.git-tower.com/\">Git Tower</a> which makes tagging, branching, merging, fast-forwarding and the concept of “remotes” much easier to grasp through the use of a graphical user interface.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Once you’ve started to be disciplined with making small commits, even as a one-person-show, you can build your code in logical components which you integrate and deploy continuously. This fact, plus the discipline of writing good commit messages truly made me a better developer, and you don’t need to have a Computer Science degree for that.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>The next logical step: Deployment</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Now that everything is in Git, uploading the source code files can still be managed manually through FTP/SCP, or you can even use Git on the production environment. This turns out to be very risky. I’ve seen environments where somebody commits a change into Git on production, while at the same time somebody else had made another change in the same file, and uploaded <em>that</em> change to production. These were the days where we all sat in one room shouting: who uploaded what first or last?!&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This felt unnecessary, and we evaluated various alternative Deployment strategies. Deployment in this context is transferring a certain state of your source code and assets to a production environment, ie your web host. If you want to do this automatically, and in a repeatable way, we call it “Continuous Deployment,” ie “push the current state of this Git branch to the production environment,” multiple times a day. Those small changes and commits really come into play here.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For more complex web projects, some might need Frontend builds with npm, yarn etc, and defined dependencies for PHP with Composer to actually “build” the package you want to move to the production environment. You could also add Unit or Integration tests on your source code which should check that previous and new behavior works as expected. If you’re familiar with these concepts, you already have a “Continuous Integration” setup as well. Both terms are often referred to as “<a href=\"https://ddev.com/ddev-live/bringing-ci-cd-to-your-agency-with-ddev-live/\">CI/CD</a>,” and they cover the whole build process.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In the end, an automatic “build server” takes care of building the final state – an artifact such as a zip file – to be transferred to the production environment where it will run without any problems. No more yelling across the office!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>It’s a win for all developers: Deployment is one of these things that you don’t need to do manually anymore. Having this process from commit to integration to deployment saves you time and effort.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A bonus: You could even deploy one Git branch (for instance, a branch named “staging”) to a staging environment and another Git branch (“main”) to the production environment, so your colleagues or your customers can <a href=\"https://ddev.com/ddev-live/a-git-based-workflow-from-dev-to-deploy/\">test and preview each change on a separate server</a> before you push it to the production environment. This comes especially in handy when there are integrated services like external databases and APIs to test with.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>But how do I develop locally?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Now that a CI/CD process is in place, the biggest question left is: Well, how do I work on my web project on my computer in an equally collaborative and safe way? Especially with teams, every developer and contributor has their own local copy of the web project, including the database and assets, on their machine. Develop locally, and I don’t have to worry about my internet connection, or if the upload of a changed file has succeeded, I can focus on the task at hand.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We had been working with XAMPP, MAMP, and virtual machines, but Docker has had a huge impact in the past years. But if you’re primarily a web developer, <a href=\"https://www.ddev.com/ddev-local/ddev-v-build-it-yourself/\">setting up Docker yourself</a> is much more complicated, and I can fully relate to that as I still feel like a Docker newbie.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Fortunately enough the folks at DDEV released <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a>, which takes away all the pain from Docker and lets you focus on your PHP application development, whether it’s TYPO3, Drupal or any other PHP project. Install Docker and DDEV-Local and you’ll have a local environment, <a href=\"https://ddev.readthedocs.io/en/stable/users/extend/customization-extendibility/\">configured</a> to match your production environment, with your Git repository, up and running in a matter of minutes. It’s the last piece of the puzzle needed to never directly touch the production environment again.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To sum it up:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Using Git can save hours of work, even if you’re working as a one-person-show or don’t have to manage tons of branches.</li><li>With a repeatable and automated deployment strategy you don’t have to worry about the code on the production environment anymore.</li><li>Use DDEV-Local to make your life easier when you want to develop on your local machine.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>There are a lot more topics to cover, like how to <a href=\"https://ddev.readthedocs.io/en/latest/users/providers/DDEV-Live/\">sync your assets</a> or visitor-generated content back to your local environment, but this always depends on the tool you use–in TYPO3 CMS world this is especially important. What’s your story on how to handle your toolchain and managing content between environments? <a href=\"https://twitter.com/intent/tweet?text=Hi%20@bennimack!%20%23ddev&amp;via=Drud\">Drop us a tweet</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#typo3-quickstart\">DDEV-Local TYPO3 Quickstart guide</a></div>\n<!-- /wp:button -->','Why developing locally matters','','publish','closed','closed','','why-developing-locally-matters','','','2020-11-04 13:22:25','2020-11-04 20:22:25','',0,'https://ddev.com/?p=3499',0,'post','',0),(3516,8,'2020-11-03 09:40:26','2020-11-03 16:40:26','','Request a Demo','','publish','closed','closed','','request-a-demo','','','2020-11-03 09:40:26','2020-11-03 16:40:26','',0,'https://ddev.com/?p=3516',1,'nav_menu_item','',0),(3517,1,'2020-11-04 13:31:24','2020-11-04 20:31:24','<!-- wp:paragraph -->\n<p><em>This is a guest post from </em><a href=\"https://twitter.com/bennimack\"><em>Benni Mack</em></a><em>, CTO of the </em><a href=\"https://b13.com/\"><em>digital agency b13</em></a><em>, located in Germany. He’s been the project lead for </em><a href=\"https://typo3.org/\"><em>TYPO3</em></a><em>, an Enterprise CMS based on PHP, for the last 6 years, steering contributors and developers around the TYPO3 Ecosystem through his passion for Open Source and PHP. This is part two of a two part series, <a href=\"https://www.ddev.com/ddev-local/why-developing-locally-matters/\">find part one here</a>.</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Recap: A local development environment</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>In my previous blog post, I mentioned my road to a proper local development environment with Git, and a deployment strategy. Read all about it <a href=\"https://ddev.com/ddev-local/why-developing-locally-matters/\">here</a> to get a grip on why you should start setting up a local development environment too.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>From local to production - an easy task?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>When I started developing locally, this gradual change opened up a lot of possibilities I wasn’t aware of in the beginning:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>With Versioning through Git, I had a clear history of my modifications and could collaborate with my colleagues in a streamlined manner.</li><li>A local environment allowed me to continue my development when I wasn’t connected to the internet, when I was traveling.</li><li>By working locally, I did not have to debug on production to see my changes in effect but could test and bugfix faster than before.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>But I also had my fair share of lessons learned while having everything locally. One of the biggest challenges I faced was the different environments: Locally, I was running PHP 7.3, but the production server only had PHP 7.2, or didn’t even have all the PHP modules installed that I had on my local machine.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For composer-based PHP projects, we came around to the handy “platform.php” config to ensure that the dependencies match the same PHP version as on production. Still, everything else was hopefully working as expected, with many manual reminders to our team about which PHP functionality we were allowed to use.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"backgroundColor\":\"very-light-gray\"} -->\n<p class=\"has-background has-very-light-gray-background-color\"><strong>References:<br></strong><a href=\"https://www.naderman.de/slippy/slides/2018-12-07-SymfonCon-Composer-Platform-Config.pdf\">Composer Platform Config presentation</a> from Nils Adermann<br><a href=\"https://andy-carter.com/blog/composer-php-platform\">Enforcing a PHP Version for Installed Composer Packages</a> by Andy Carter <br><a href=\"https://getcomposer.org/doc/06-config.md#platform\">Composer Documentation on Platform Config</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Some production servers used Apache as a web server, some used Nginx, and on top of that, especially when working with multiple web projects at an agency throughout one day, it felt like we ended up with more work than before. So I asked myself: Should I switch back to developing on the live server??</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Local environment = Production environment</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The solution for us was: Virtualization. We at b13 started to build custom virtual machines, or later on, containers with Docker, to match the same system settings as on the production environment.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>With <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a>, it’s just a matter of a few configuration lines to ensure that your local environment for a specific web project contains the same PHP versions and modules. And you can run multiple web projects at the same time. Configuring these settings felt like a no-brainer when starting a new project. I could even check if my application still works on a more recent PHP version and tell the IT admin on the production environment that “we’re safe for a PHP upgrade from our side.” The actual update on the production environment still might take months: Larger corporations with commercial Linux distributions usually rely on many old software packages. A lot of manual work is required to execute a system update.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>The possibilities with Cloud-based production servers</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>If it’s so easy with Docker and DDEV-Local to change PHP versions, upgrade the system packages, why can’t a hosting provider do the same? Docker and Kubernetes have you covered in the container department. But that indeed isn’t something for me to configure as a regular web developer – I want to focus on my web application and my customers’ needs. Instead, I suggest choosing a hosting provider that offers such flexibility for you, so you can focus only on your local development.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Going into the Cloud for hosting offers even more solutions than just quicker updates for your software packages:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><strong>Scalability</strong>: If your website hits a lot of traffic, you shouldn’t wait for two months to get new hardware and migrate everything over, the host should be flexible enough to cover the peaks.</li><li><strong>Failover:</strong> If a server is down, the system should detect this and spin up a new machine without any visitor noticing anything—a self-healing process.</li><li><strong>Exchangeability</strong>: When you deploy your code changes, or even an update to your web application, your site shouldn’t be down, but instead do a <a href=\"https://en.wikipedia.org/wiki/Blue-green_deployment\">blue-green deployment</a>.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Kubernetes does that in a very sophisticated way –but to be honest– I don’t want to manage this on my own, as everyone has enough on their plate already. If you only want to work with your web application but have everything covered, <a href=\"https://ddev.com/ddev-live/\">DDEV-Live</a> might be just the right hosting solution for you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>A straightforward deployment with DDEV-Live</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>DDEV-Live covers all the functionality from DDEV-Local, which already has excellent support for the popular PHP content management systems. DDEV-Live hooks into your Git repository and deploys your changed code into the Cloud. Plus, a CI/CD solution, integrated backups, and their superb support should be enough to <a href=\"https://docs.ddev.com\">try it out</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A simple <code>ddev-live create site</code> and <code>ddev-live push</code> is all you need to <a href=\"https://ddev.com/ddev-live/how-to-deploy-a-site-with-ddev/\">host your sites with DDEV</a>. They pride themselves on making tools easy first, and customizable as needed, and the hosting platform is no exception.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you’re hooked with DDEV-Local, you should give DDEV-Live a shot.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->\n\n<!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Line art by <a href=\"https://thenounproject.com/term/container/597249 \">Shashank</a> and <a href=\"https://thenounproject.com/term/containers/1468090 \">Becris</a> on the noun project.</p>\n<!-- /wp:paragraph -->','Why your local dev environment should match production','','publish','closed','closed','','why-your-local-dev-environment-should-match-production','','','2020-11-04 13:31:25','2020-11-04 20:31:25','',0,'https://www.ddev.com/?p=3517',0,'post','',0),(3526,20,'2020-11-05 18:29:55','2020-11-06 01:29:55','<!-- wp:paragraph -->\n<p>Have you ever found yourself needing to deploy a <em>very specific</em> version of your web project? Perhaps you wanted to deploy a commit with the latest code for testing, or examine and share some new ideas in a feature branch with collaborators on the other side of the world. Or maybe you’d like your published production site to point to a tagged release of your codebase.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ddev.com/ddev-live/a-git-based-workflow-from-dev-to-deploy/\">Centering your work around Git</a> supports safe and collaborative work, but how do you continue that best practice all the way to production? The <a href=\"https://ddev.com/ddev-live/\">DDEV-live</a> platform solves the problem of connecting a Git workflow from development through to deployment by offering the ability to specify a Git branch, tag or commit to pull code from.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Git best practices and deployment limitations</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>When you’re following a Git-based workflow, you generally have multiple pieces of work tracked in branches within the repository. There’s the “main” branch (the source of all truth), various branches for testing, staging, integration, as well as development branches with features, bug fixes, and midnight inspirations. During the project’s lifecycle, it’s likely only the basic testing, staging, or production branches that get deployed in remote environments.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>But what if you want your production environment to pull code from a branch called “finalfix3” instead of being pinned to “master”? Or you’d like to build a unique QA environment from a single commit, separate from the deployment workflow. For hotfixes and random features the client suddenly wanted to see in a production-like environment (ie their browser), this can require more set up and configuration than it’s worth, leaving you considering whether you could just <a href=\"https://www.drupaleasy.com/blogs/ultimike/2019/06/sharing-your-ddev-local-site-public-url-using-ddev-share-and-ngrok\">use your machine as a host</a> for a few days (useful! but impractical in a complex work-from-home workflow).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Connecting and referencing your existing Git project with some web hosts requires a bunch of tools, a bunch of set up, and can be locked in to prescribed workflows. The inability to extend the structure and process you’ve built for your work limits what you can accomplish.&nbsp; Working with <a href=\"https://ddev.com/ddev-local/why-developing-locally-matters/\">branches locally is massively flexible</a> when tracking various pieces of work in progress, as well as when merging work to build a release. <a href=\"https://git-scm.com/book/en/v2/Git-Basics-Tagging\">Tagging</a> chunks of work in Git is a standard best practice for tracking versions or releases for a project in the long term (a nicely documented example is <a href=\"https://www.drupal.org/docs/develop/git/git-for-drupal-project-maintainers/release-naming-conventions\">the Drupal project</a>, which uses branches for versions and tags for releases).&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>So, how can you extend your project structure and Git best practices throughout your development lifecycle all the way to deployment?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Deploy any branch, tag, or commit to DDEV-Live&nbsp;</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The DDEV platform is specifically built with a Git-based workflow in mind. Any time you create a “<a href=\"https://docs.ddev.com/sites/\">site</a>” with DDEV-Live, you must reference a <a href=\"https://git-scm.com/docs/revisions\">Git revision</a> to pull the code from. A site can be created from a commit, tag, or branch from your existing GitHub or GitLab repository, creating parity for Git providers on the platform.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>What does this look like in practice? You will specify the Git revision to deploy on DDEV-Live when creating a site with a command such as this example (<a href=\"https://docs.ddev.com/sites/\">see more examples in the CLI docs</a>) referencing a branch named “dev”:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><code>ddev-live create site typo3 my-org/my-site --git-repo </code><a href=\"https://my.gitlab.hosting.com/repo\"><code>https://my.gitlab.hosting.com/repo</code></a><code> --git-rev dev</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>DDEV features automated deployments out of the box. The platform watches the Git revision you built the site from and rebuilds any time there is a change. If you’re already using a <a href=\"https://ddev.com/ddev-live/ci-cd/\">CI/CD</a> solution in your workflow, DDEV can easily be added <a href=\"https://docs.ddev.com/cicd/\">using our CLI and API</a> (to automatically spin up QA environments, for example). One place where you don\'t want automated deployments is production. When you\'re ready to go live, all you need to do is create a tag in Git. You can deploy that tag to any non-production environment for a final test before switching your production site to that tag.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>The freedom of flexibility</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>With specific references to Git revisions you can be very granular about what gets promoted to production or staging and be creative with workflows and automation. You might have a DDEV-Live environment pointed at your production code in a “1.19.0” tag, a CI/CD tool scripted to spin up test instances for automated testing from a “QA” branch, and an on-demand instance to work with <em>that one commit</em> from last month.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Directly referencing and connecting to a central Git repository throughout your workflow gives you efficiency, cohesion and safety. Out of the box automation and the freedom to choose exactly what and how you want to deploy gives you flexibility to work the way <em>you</em> want to, the way your project and clients will benefit the most.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>What’s next?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A sneak peek into the future!&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Currently, you could have work from a “qa” branch of your project in a DDEV-Live environment and share that work to anyone in the world from a preview URL. Next, DDEV is introducing more explicit support for temporary “preview sites” which are tied to pull or merge requests.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In the near future, your DDEV workspace could have published, and ephemeral preview sites held in it referencing various stages of the project. For example: The published site is a reference to the “1.19.0” tag in your repository, and has DNS set up and is live online. A site built from your “qa” branch also exists. This branch is not published, but there is a PR against it with some changes. This PR can be used to quickly build a preview site by adding a comment to the PR. The preview site can then be shared via URL to stakeholders, and will be deleted when the PR is closed.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We’re very curious about how you’ll use some of these newer features and would love to chat with you about it. Drop a line in the contact form and we’ll get you rolling!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','How to deploy from a branch, commit, or tag','','publish','closed','closed','','how-to-deploy-from-a-branch-commit-or-tag','','','2020-11-05 18:29:57','2020-11-06 01:29:57','',0,'https://www.ddev.com/?p=3526',0,'post','',0),(3530,11,'2020-11-18 11:17:10','2020-11-18 18:17:10','<!-- wp:paragraph -->\n<p><strong>Update 2020-12-16:</strong> <em>An Apple Silicon M1 pre-release of DDEV-Local is now available in </em><a href=\"https://github.com/ddev/ddev/releases\"><em>DDEV releases</em></a><em>! There is information there on how to get the latest prerelease for Docker Desktop for Mac on M1</em>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>ARM64 is the new word of the day all over the place since Apple has switched their hardware platform to \"Apple Silicon,\" which is on the ARM64 platform. Although the Apple news and benchmarks are exciting, ARM is not new, lots of devices already use it, and our <a href=\"https://github.com/ddev/ddev/releases/tag/v1.16.0\">open source DDEV-Local development environment</a> already supports it on Linux and WSL2.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In this blog, we\'ll take a look at these things:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>What is ARM64?</li><li>What is Apple Silicon/Apple M1 Chip? What is Big Sur? What is Rosetta 2?</li><li>DDEV-Local Already Runs On ARM64 in Linux and WSL2</li><li>When will DDEV-Local work on Apple Silicon?</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>What is ARM64?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The majority of Windows, Mac, and Linux computers to date have used the Intel CPU architecture, or AMD64. Most software, including DDEV-Local, our <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live hosting platform</a>, cloud VMs, the most popular Docker images, and many upstream projects have traditionally assumed AMD64 hardware, and ARM64 versions were not always available.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>\"ARM\" stands for \"Advanced RISC Machine\" and \"RISC\" stands for \"Reduced Instruction Set Computer.\" The Intel architecture we\'ve all used so long has been dubbed \"CISC\" or Complex Instruction Set Computer.\" ARM seems to be the future. <strong>ARM64</strong> means ARM with 64-bit chips (there are also loads of ARM32 chips out there in the world). (The intel architecture is typically labeled AMD64; apparently after another manufacturer of the AMD64 chips, AMD.)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Current versions of many devices already use ARM chips, including almost all Apple devices besides the Mac, Microsoft\'s Surface Pro X, the Raspberry Pi, Pinebook Pro, and many others.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>What is Apple Silicon/Apple M1 Chip? What is Big Sur? What is Rosetta 2?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Apple announced earlier this year that they were going to transition their entire Mac line from Intel processors to their own ARM64 \"<strong>Apple Silicon</strong>\" chip, dubbed the <a href=\"https://www.apple.com/mac/m1/\"><strong>M1</strong></a>. The <a href=\"https://www.apple.com/apple-events/november-2020/\">availability announcement on November 10, 2020</a> made incredible performance claims. At this point, third-party testers are also reporting outstanding performance, even for older AMD64 apps (like last month\'s apps) that have not been rebuilt for ARM64.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Apple\'s new <strong>Big Sur</strong> version of macOS (aka macOS version 11) has just been released, and runs on both Apple Silicon/M1/ARM64 and AMD64 computers. It\'s mostly just their annual OS update, but the big news is the Apple Silicon support.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Rosetta 2</strong> is a feature implemented in the M1 chip and Big Sur which allows macOS to run AMD64 apps, even though they use a different architecture.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>DDEV-Local Already Runs On ARM64 in Linux and WSL2</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><strong><a href=\"https://github.com/ddev/ddev/releases/tag/v1.16.0\">DDEV-Local v1.16</a> already runs on ARM64 computers</strong> where Docker is available. This includes Windows WSL2 on Windows ARM64 machines like the Surface Pro X, and also native Linux ARM64 machines like the Raspberry Pi (64-bit), Pinebook Pro, or Amazon EC2 ARM64 machines.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Thanks to incredible contributions by <a href=\"https://github.com/dennisameling\">Dennis Ameling</a> leading this transition, nearly all the features of DDEV-Local are available in ARM64 machines, and these features are also tested on Travis-CI, which has ARM64 testing available (testing <em>also</em> set up by Dennis!)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Building DDEV-Local for ARM64 was a monumental task, and a huge demonstration of the beauty of open source. Dennis has a Surface Pro X (ARM64) that he loves and wanted to be able to develop on... So he took on the task. It involved:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Reworking all the DDEV-Local Docker images (ddev-webserver, ddev-dbserver, ddev-ssh-agent, ddev-router) so they could be built for ARM64.</li><li>Providing ARM64 builds of certain key upstream tools which were incorporated into Docker images or required alongside DDEV-Local, like mkcert, mailhog, and docker-gen.</li><li>Reworking the image build process to use Docker\'s new <a href=\"https://www.docker.com/blog/tag/multi-architecture/\">multi-architecture</a> support, which allows a single image on <a href=\"http://hub.docker.com\">hub.docker.com</a> to have both AMD64 and ARM64 versions, and to pull the correct one as needed.</li><li>Building the DDEV-Local Go binary for AMD64.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:block {\"ref\":3535} /-->\n\n<!-- wp:heading -->\n<h2>When will DDEV-Local Work on Apple Silicon?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>People are just starting to receive the brand new macOS machines with Apple Silicon; we ordered ours and expect it to arrive in late November.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>However, Docker has the same problem as everybody else with getting Docker Desktop to run on Apple Silicon (see their <a href=\"https://www.docker.com/blog/apple-silicon-m1-chips-and-docker/\">announcement</a>). As of November, 2020, Docker Desktop doesn\'t run yet on Apple Silicon, but they\'re promising a technical preview soon, and they\'re happy with their progress on it.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Besides the dependency on Docker Desktop, the only other known issue in getting DDEV working on Apple Silicon is compiling the Go binary. The current version of Go, v1.15, does not support building darwin/arm64, the name of the architecture. However, the upcoming Go v1.16 (<a href=\"https://github.com/golang/go/wiki/Go-Release-Cycle\">due in February, 2021</a>) does. And it\'s available a few ways right now. Experiments with building have been successful but, of course, we can\'t run on real hardware until we get it.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>So the answer is... DDEV-Local will hopefully run on Apple Silicon Real Soon, probably just after a workable Docker Desktop is made available.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','ARM64! Apple Silicon! M1! DDEV-Local! What does it all mean?','','publish','closed','closed','','arm64-apple-silicon-m1-ddev-local-what-does-it-all-mean','','','2020-12-16 20:20:35','2020-12-17 03:20:35','',0,'https://www.ddev.com/?p=3530',0,'post','',0),(3535,16,'2020-11-18 08:42:31','2020-11-18 15:42:31','<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://github.com/ddev/ddev/releases\">Get the latest DDEV-Local here</a></div>\n<!-- /wp:button -->','DDEV-Local release page','','publish','closed','closed','','untitled-reusable-block-4','','','2020-11-18 08:42:40','2020-11-18 15:42:40','',0,'https://www.ddev.com/uncategorized/untitled-reusable-block-4/',0,'wp_block','',0),(3542,11,'2020-11-23 07:40:38','2020-11-23 14:40:38','<!-- wp:shortcode -->\n[embed]https://youtu.be/w3XV64hBeFU[/embed]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://github.com/ddev/ddev\">DDEV-Local v1.16</a> now supports the ARM64 architecture on Linux and Windows WSL2. You can read all about ARM64 and what it means to the world (and to DDEV) in the previous blog on <a href=\"https://www.ddev.com/ddev-local/arm64-apple-silicon-m1-ddev-local-what-does-it-all-mean/\">ARM64, Apple Silicon, and Apple\'s M1 chip</a>. Since I don\'t have a big machine to test with, I got the ARM64-based Raspberry Pi 4 instead, and it\'s actually worked out far better than I expected. It was a great way to have an ARM64 machine available for testing whenever needed during the development process... but it turns out some people might want to use a Pi as their desktop web development machine. All of features of DDEV-Local work out of the box. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>On this Raspberry Pi 4 I have Ubuntu 20.10, which is the first Ubuntu version to explicitly support the Raspberry Pi. I\'ve previously experimented with the <a href=\"https://www.raspberrypi.org/forums/viewtopic.php?t=275370\">64-bit Debian-10-based Raspberry Pi OS</a>, and it worked as expected as well, although Debian 10 doesn\'t have versions of Docker and docker-compose that are as recent as I\'d like.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Installing DDEV-Local is pretty easy and mostly just exactly what\'s laid out in the Linux <a href=\"https://ddev.readthedocs.io/en/stable/users/docker_installation/#linux-installation-docker-and-docker-compose\">Docker Installation Docs</a> and the <a href=\"https://ddev.readthedocs.io/en/stable/#installationupgrade-script-linux-and-macos-armarm64-and-amd64-architectures\">DDEV install docs</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Install <a href=\"http://docker.io\">docker.io</a> and docker-compose with <code>sudo apt-get update &amp;&amp; sudo apt-get install -y docker.io docker-compose</code></li><li>Add your user to the docker group with <code>sudo usermod -aG docker $USER</code>. Note that on some machines or operating systems you may have to log out and log in again to see this take effect, but you can test it with just <code>id</code> to see if you\'re in the docker group, and if <code>docker ps</code> works without sudo, it\'s working.</li><li><code>sudo apt-get install libnss3-tools xdg-utils</code> : libnss3-tools helps mkcert to work with Firefox and Chromium, and xdg-utils is the secret sauce behind <code>ddev launch</code> on Linux.</li><li>Install ddev using the install script (<a href=\"https://ddev.readthedocs.io/en/stable/#installationupgrade-script-linux-and-macos-armarm64-and-amd64-architectures\">docs</a>): <code>curl -LO [&lt;https://raw.githubusercontent.com/ddev/ddev/master/scripts/install_ddev.sh>](&lt;https://raw.githubusercontent.com/ddev/ddev/master/scripts/install_ddev.sh>) &amp;&amp; bash install_ddev.sh</code></li><li>Use <code>ddev config</code> in a project and <code>ddev start</code> and <code>ddev launch</code>!</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>I found that with just standard setup, DDEV-Local on the Raspberry Pi 4 was able to do everything it\'s supposed to do, and with better performance than expected. It would certainly be possible to add faster disk or an SSD to it and make things even better. So if you need a super-low-cost development environment, or just want to see what ARM64 is all about, or if you just want to do new cool things with the Pi, here\'s your chance!&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','Watch: DDEV-Local on ARM64 Raspberry Pi','','publish','closed','closed','','watch-ddev-local-on-arm64-raspberry-pi','','','2020-11-22 10:44:48','2020-11-22 17:44:48','',0,'https://www.ddev.com/?p=3542',0,'post','',0),(3546,16,'2020-11-20 08:03:01','2020-11-20 15:03:01','<!-- wp:paragraph -->\n<p>As developers and DevOps nerds, we are all about finding repeatable, automatable workflows, creating checklists, and standardizing processes so that everyone can do their best work unencumbered. One way to accomplish some of that, especially for a team, is to get set up with a <a href=\"https://about.gitlab.com/handbook/marketing/strategic-marketing/dot-com-vs-self-managed/\">self-hosted GitLab instance</a>. But it can be challenging to connect and integrate that beautiful workspace with external tools and environments in a way that just flows and doesn’t require extra context switching. We explored one way to directly connect self-managed GitLab with a production environment using a simple setup so you can keep working and start deploying.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>All customized and nowhere to go</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Setting up a customized instance of GitLab can be key to centralizing team work and making sure that code is stored in a safe and private location. A self-managed GitLab instance can fulfill customer expectations for privacy and professionalism when deployed on-premises or in your preferred cloud. The ability to manage users, logs, and much more also makes self-managed GitLab practical for growing teams and projects. GitLab features strong support for <a href=\"https://about.gitlab.com/blog/2020/11/11/gitlab-for-agile-portfolio-planning-project-management/\">Agile project management</a>, ensuring that work is broken down, organized, and tracked for the entire team. With development work streamlined and developers all working in one place you can be efficient, secure, and focused.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>As a digital agency, your team might need to keep work in very tightly defined pipelines as it moves forward. That means excellent project managers maintaining feature branches tied to epics and releases so chunks of work can be developed, tested and deployed in isolated environments. With all of that organization happening in GitLab, how can you connect the workflow all the way through to deployment for testing or production?&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>When it comes to deploying a project, things can get sticky. In order to get the latest changes from a self-managed GitLab instance to the web host you might need to manually export and move code, leverage <a href=\"https://docs.gitlab.com/ee/ci/environments/\">GitLab CI/CD</a>, or employ another integration tool. The more steps there are in the process, the greater the chance for breakage, loss, and failure. Plus, even though all the code is in GitLab, you might have different build and deploy processes for each CMS, pointed to different hosting providers. Things get tangled and confused and the overhead of maintaining so many different pipelines eats time and requires significant expertise.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Deploy from a self-managed GitLab instance</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a> platform features the ability to directly <a href=\"https://docs.ddev.com/gitlab/\">connect a self-managed GitLab instance</a> to a remote environment on our infrastructure. You may already have set up DDEV for your <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#getting-started\">local development environment</a> with projects from your repositories. There are just a couple more steps to start deploying to your DDEV-Live environment from your self-managed GitLab instance.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Configure a <a href=\"https://docs.ddev.com/gitlab/#configure-personal-access-token\">personal access token</a> on your GitLab account and pass the credentials to your DDEV-Live workspace via our CLI tool. Once that’s set up, you can run the <code>ddev-live create site…</code> command with a reference to any <a href=\"https://www.ddev.com/ddev-live/how-to-deploy-from-a-branch-commit-or-tag/\">repository branch, tag or commit</a>. If you’ve configured your personal access token with the API scope, changes to the Git revision you referenced in the <code>ddev-live create site</code> command will automatically be pushed to DDEV-Live. This can also be <a href=\"https://docs.ddev.com/gitlab/#project-webhook-configuration\">manually configured with webhooks</a> per project or builds can be triggered by hand.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>That means you can now work in DDEV-Local with a project you’ve checked out from your GitLab instance, push changes up to the repository, and see an automatic build happen immediately on DDEV-Live. Everything can be controlled through the ddev and ddev-live CLI tools, and also be scripted in your favorite CI/CD tool using your DDEV API token.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Benefits of a flexible development workflow</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>If you have a workflow and tools that you’ve set up to best support your projects, the last thing you want is to be disrupted. Any additional tools or systems you implement should make your process easier, not more complex, and should fit <em>your</em> process, not force you into workflows that don’t make sense for your developers, stakeholders, and projects. Something technically flexible to support a variety of PHP-based projects, as well as being adaptable and scriptable to integrate with other tools and providers. The best tool is the one that works <em>for</em> you, not against you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Now that you can connect just about any Git repo to DDEV-Live to deploy projects into the cloud, you can continue to save time on manual tasks and engineering effort in <a href=\"https://www.ddev.com/ddev-live/ci-cd/\">setting up CI/CD systems</a>. For an agency with a self-managed GitLab instance you can work with the full DDEV platform while continuing to support the privacy, security and efficiency needs of your team and your clients.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For senior developers, the benefits might include time savings in setting up CI/CD pipelines for automated tasks. Instead of exporting code, you can directly reference your code right where it lives, in Git. Continue working with, or move to, self-managed GitLab to support your customer and internal project lifecycle needs. For all developers, the benefits include the flexibility to use the <a href=\"https://docs.ddev.com/providers/\">Git provider</a> you prefer (GitHub, GitLab, and more as we build out agnostic Git support) and logical, straightforward commands you’ll use to interact with DDEV via CLI, leading to saved time and resources and the freedom to use the tech you want.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>What’s next?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The DDEV platform gives you the ability to continue using your existing, customized GitLab instance to manage all your work, but now with direct connections to deploy to DDEV-Live for any stage of your development workflow. With your API token and installable CLI, you can probably imagine a lot of possibilities for how to integrate DDEV into your current workflows.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For example, in addition to using DDEV in your CI/CD pipelines, you might also be in search of a way to spin up quick preview sites that can be shared. This functionality can support a really robust QA process with clients, where you can show work in progress that is only at the PR stage. Soon DDEV will include the ability to call up a fresh site on our platform based on changes in a PR you have created.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>What does your workflow look like today? What would like it to look like in the future? <a href=\"https://www.ddev.com/contact/\">Reach out</a> and tell us what features you’d like to see when working from GitLab!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','Deploying from a self-managed GitLab instance','','publish','closed','closed','','deploying-from-a-self-managed-gitlab-instance','','','2020-11-20 08:03:03','2020-11-20 15:03:03','',0,'https://www.ddev.com/?p=3546',0,'post','',0),(3551,2,'2020-11-20 17:18:47','2020-11-21 00:18:47','<!-- wp:heading {\"level\":4} -->\n<h4>Installation/Upgrade:</h4>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>If you’re new to <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a>, please follow the <a href=\"https://docs.ddev.com/getting-started/\">Getting Started Guide</a>.</li><li>For existing users, be sure you have the latest version of the <a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">ddev-live cli via brew or download</a>.</li><li><strong>Important extra step!</strong> If you have the DDEV-Live App installed on your GitHub account, you will need to visit <a href=\"https://github.com/settings/installations\">the application settings</a> and accept the additional permissions in order to use the latest DDEV platform functionality.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Key changes in this version</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The platform update on 23 November 2020 introduces <a href=\"https://www.ddev.com/ddev-live#ddev-preview\">DDEV Preview</a>, a collection of features to support testing and review during a development lifecycle. These features include a <a href=\"https://docs.ddev.com/preview-bot\">repository chat-bot</a> for GitHub and GitLab repositories, which you may call directly in your repositories with a comment to create a preview site. Preview site features are designed to enable developers to create on-demand site clones in production-like environments on the DDEV-Live infrastructure.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In order for the chat-bot to work with GitHub repositories, the DDEV-Live GitHub app now requires read and write permission on issues and pull-requests. DDEV uses a GitHub app in order to “listen” to your GitHub repositories. This is set up during <a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-github-app\">initial account configuration</a> for GitHub users. In order for the <a href=\"https://docs.ddev.com/github-bot\">GitHub bot</a> to work it needs to be able to observe and respond to events in your repository.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>With this update, you will be able to create a Preview site with just a comment on a PR, or on a merge request for GitLab users. GitLab does not require additional configuration.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Smaller changes</h4>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>UI updates to the dashboard, including the <a href=\"https://dash.ddev.com/pricing\">pricing page</a></li><li><a href=\"https://docs.ddev.com/gitlab-bot/\">Preview bot for GitLab</a></li><li>Added php 7.4 support: Users can pass --php-version=7.4 to <a href=\"https://docs.ddev.com/sites\">site creation or config</a> updates to run this version of PHP</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Caveats</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>GitHub users must accept additional permissions for the DDEV-Live GitHub app on their accounts.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Assets</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">DDEV-Live CLI v0.8.0</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Status page</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Subscribe on <a href=\"https://status.ddev.com/\">status.ddev.com</a> for all platform updates.</p>\n<!-- /wp:paragraph -->','Release notes: DDEV Platform 23 November 2020','','publish','closed','closed','','release-notes-ddev-platform-23nov2020','','','2021-02-02 09:48:19','2021-02-02 16:48:19','',0,'https://www.ddev.com/?p=3551',0,'post','',0),(3575,20,'2020-11-23 09:00:46','2020-11-23 16:00:46','<!-- wp:paragraph -->\n<p>PHP security support for version 7.2 will end on <a href=\"https://www.php.net/supported-versions.php\">30 Nov 2020</a>. Sites running PHP 7.2 will cease to receive all PHP version updates and are at greater risk for security issues. We will continue to provide a PHP 7.2 option on the <a href=\"https://www.ddev.com/ddev-live\">DDEV-Live</a> platform, however, we do not recommend this version.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>What this means for you:</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We require that you upgrade your sites to an actively supported version of PHP, either 7.3, 7.4, in order to continue receiving security updates.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Actions to take now:</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Here is a simple example of how to update your DDEV site:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Please note that we\'ve recently released new versions for both the <code><a href=\"https://github.com/ddev/ddev/releases\">ddev</a></code> and <code><a href=\"https://www.ddev.com/news/release-notes-ddev-platform-23nov2020/\">ddev-live</a></code> CLIs, update now if you haven\'t! </li><li>Test your site on PHP 7.3 using DDEV-Local:<ul><li>Clone the existing Git branch of your site that is running on DDEV-Live into a DDEV-Local environment. <a href=\"https://docs.ddev.com/backups/\">Backup and download assets</a>. Use <code>ddev pull</code> to do <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/DDEV-Live/\">all of the above if configured</a>.</li><li><a href=\"https://ddev.readthedocs.io/en/latest/users/extend/customization-extendibility/#changing-php-version\">Change DDEV-Local config to php 7.3</a></li><li>Run tests and confirm success. Commit any changes required locally.</li></ul></li><li>Switch your DDEV-Live <a href=\"https://docs.ddev.com/sites/#working-with-your-site-on-ddev-live\">site</a> to 7.3<ul><li>Run <code>ddev-live config &lt;site-type> &lt;site-name> --php-version=7.3</code> or to update your site’s DDEV-Live environment.</li><li>Push any required changes back to your deployed repository.</li></ul></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://docs.ddev.com/\">DDEV-Live documentation</a><br><a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local documentation</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Other items of note</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.php.net/manual/en/migration73.php\">Migrating from PHP 7.2.x to PHP 7.3.x </a><br><a href=\"https://www.php.net/ChangeLog-7.php#7.3.0\">PHP 7.3 changelog</a><br><a href=\"https://www.php.net/supported-versions.php\">PHP roadmap</a><br>Drupal 7.73 fully supports PHP 7.3.<br>D6LTS 6.55 fully supports PHP 7.3.<br>Wordpress 4.7 or newer fully supports PHP 7.3.<br>Typo3 9 fully supports PHP 7.3.<br>Typo3 10 fully supports PHP 7.3.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For additional platform status updates, please subscribe at <a href=\"https://status.ddev.com\">status.ddev.com</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','DDEV-Live PHP 7.2 notice','','publish','closed','closed','','ddev-live-php-7-2-notice','','','2020-11-22 12:57:33','2020-11-22 19:57:33','',0,'https://www.ddev.com/?p=3575',0,'post','',0),(3587,11,'2020-12-14 14:38:31','2020-12-14 21:38:31','<!-- wp:shortcode -->\n[embed]https://youtu.be/beC46R_61gw[/embed]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://github.com/ddev/ddev\">DDEV-Local</a>\'s v1.16 release has support for \"<a href=\"https://ddev.readthedocs.io/en/latest/users/alternate-uses/#casual-project-webosting-on-the-internet-including-lets-encrypt\">Casual webhosting</a> including Let\'s Encrypt.\" DDEV users have often requested the ability to use ddev as a self-managed low-end webserver, for things like small sites or sharing pre-release code, etc, and now it has arrived.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Why \"Casual Webhosting\"?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ever since the beginning of DDEV-Local, folks have found its simplicity and per-project configuration to be delightful, and have wanted that for simple hosting as well. Now you can set up a site just the way you do on your local machine, with the same commands and capabilities, and set up as many projects on it as you want to.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Caveats</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We call it \"casual\" and \"experimental\" for a reason. It\'s unknown how many sites or how much traffic can be handled. This is not managed hosting - if you set it up, you manage it. This is not a scalable solution (although you could always increase the size of the VM you were running it on, or move projects to a new VM). And from a security standpoint... there is no team of security experts vetting this. Some modest efforts have been undertaken to \"harden\" the images used here, but they may not be adequate.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I personally have three trivial sites running on this casual webhosting setup on a $5/month Linode server, and have had no problems so far. (See <a href=\"http://randyfay.com\">randyfay.com</a> for the list of sites).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Note that if you just want to show a site to your colleagues or customers, you might get by just fine with the <code>ddev share</code> command, which requires <a href=\"https://www.ddev.com/ddev-local/sharing-a-ddev-local-project-with-other-collaborators/\">no setup at all</a>. And if you want a managed service, consider <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a> with included <a href=\"https://www.ddev.com/ddev-live/what-is-ddev-preview/\">Preview</a> features or <a href=\"https://ddev.readthedocs.io/en/latest/users/providers/pantheon/\">Pantheon</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-text-color has-very-dark-gray-color has-background has-luminous-vivid-amber-background-color\" href=\"https://ddev.readthedocs.io/en/latest/users/alternate-uses/#casual-project-webosting-on-the-internet-including-lets-encrypt\">Read the Casual Webhosting docs</a></div>\n<!-- /wp:button -->\n\n<!-- wp:heading -->\n<h2>Requirements</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>Your server must be accessible on the internet</li><li>You must have control of your site\'s DNS</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Server setup</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Spin up a server. I recommend using Ubuntu 20.04, which has usable Docker and Docker-compose repositories out of the box. Install DDEV-Local with homebrew or the install_ddev.sh script (<a href=\"https://ddev.readthedocs.io/en/latest/users/alternate-uses/#casual-project-webosting-on-the-internet-including-lets-encrypt\">read the full docs here</a> and <a href=\"https://youtu.be/beC46R_61gw\">watch the video</a>, too).</li><li>Point DNS to both the server and a test version of the site. Your server should have a name but it doesn\'t completely matter. But do point a domain to your site, for example \"test.&lt;yoursite&gt;.com\" will let you verify that everything is working.</li><li>Set up a firewall and enable http, https, and ssh traffic, <code>ufw allow 80 &amp;&amp; ufw allow 443 &amp;&amp; ufw allow 22 &amp;&amp; ufw enable</code>.</li><li>Create your sudo-privileged user (<code>useradd -m &lt;username&gt;</code>; <code>usermod -aG sudo &lt;username&gt;</code>) and set up for ssh.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Site Setup</h2>\n<!-- /wp:heading -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Log in as the user you\'ve created.</li><li>Install Docker (<a href=\"https://ddev.readthedocs.io/en/stable/users/docker_installation/#linux-installation-docker-and-docker-compose\">docs</a> : <code>sudo apt-get update &amp;&amp; sudo apt-get install [docker.io](&lt;http://docker.io&gt;) docker-compose</code>). Don\'t forget the post-install action required of adding your user to the Docker group, <code>sudo usermod -aG docker $USER</code>.</li><li>Check out the site code.</li><li>cd into your project and <code>ddev config</code>, then <code>ddev config --additional-fqdns=test.your.fqdn</code></li><li><code>ddev config global --router-bind-all-interfaces,ddev-ssh-agent --use-hardened-images --use-letsencrypt [-letsencrypt-email=you@example.com](&lt;mailto:--letsencrypt-email=you@example.com&gt;)</code> will set ddev to listen on all interfaces (not just localhost),  the ssh-agent, use the hardened images, and configure Let\'s Encrypt.</li><li><code>ddev start</code></li><li>Import site user-generated files with <code>ddev import-files</code> or rsync or any other way you want to do it.</li><li>Import site database with <code>ddev import-db</code></li><li><code>ddev poweroff</code> and <code>ddev start</code></li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Followup</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>After you have the site running, you\'ll want to consider a number of other actions:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Add the real fqdn to your project, <code>ddev config --additional-hostnames=&lt;your.fqdn,test.&lt;your.fqdn&gt;</code> and <code>ddev start</code> - don\'t forget other hostnames that may be expected, like \"www\".</li><li>Set up ddev to start automatically on system startup (<a href=\"https://ddev.readthedocs.io/en/stable/users/alternate-uses/#casual-project-webosting-on-the-internet-including-lets-encrypt\">docs</a>).</li><li>Set projects/containers to auto-restart if they fail for any reason: <code>ddev config global --auto-restart-containers</code></li><li>Enable outgoing mail from the site (for transactional emails, for example). In general the most sustainable way to do this is to use an SMTP module for your CMS and point it at a service like <a href=\"https://mailgun.com\">Mailgun</a>.</li><li>Enable outgoing mail from the <em>server</em> and have it forwarded to you. This lets system mail notifications be delivered.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Did you know you can now <a href=\"https://github.com/sponsors/ddev\">sponsor DDEV on GitHub</a>? We\'re incredibly grateful to those who have so far, and for the contributions of many users over the years. Thank you!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->\n\n<!-- wp:heading -->\n<h2>Video Transcription</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>0:00  <br>\nHi, my name is Randy Fay, I am going to give you a little demo today of a new feature of data of local. And that is the casual web hosting feature. It\'s cheap and easy. It\'s open source. And I\'m sure you\'ll hear me say several times, this is not a replacement, for managed hosting, they\'re different things. But this is a way to get a site up onto the internet, maybe it\'s a specialized site, maybe low volume, maybe you just trying to show it off, maybe you\'re just maintaining it as you\'re demonstrating it to somebody, there\'s a lot of good uses for it. And let\'s take a look. So people have been liking D dev local for a long time they do the local development, they do a DD of config, they do a D dev start. And they say there it is, and they can change PHP versions, each project can have a different one, it\'s way easier than a normal server setup. So people say Can we do this on a server, and yes, now you can put a DD project on a server, and Ddf start and everybody in the world can access it. So there\'s a reason though, that it has casual and experimental all over it. So we\'re going to take a look at the caveats on it. The performance characteristics and server sizing aren\'t known. I\'m going to demonstrate today on a linode server, Nano Server a $5 a month, one gigabyte server. And I\'ve got a couple of I\'ve got a couple of my trivial sites already on one of these. And I think I\'ll add this one after we get done today. And of course, I could up up to the $10 a month version, and it\'d be fine. But the overall performance characteristics and sizing aren\'t known. And of course, there\'s no automatic way to scale it up like you would expect in a managed service. This isn\'t a managed service, you have to end up managing the host, on which Dev and Docker are running. And of course, from the security perspective, while the web image has been hardened, and sudo has been removed from the hardened image, there isn\'t any team of security experts signing off on this new feature. And I should point out to you that you may want to try some other techniques. If you\'re just trying to share your project right now, with a friend, you don\'t need to do this, just use the D dev share command. And it works great, it uses ngrok very easy to use. And of course, deed of the company has another product called D dub live, which is managed hosting. And it has some really nice features, and I encourage you to check it out. Okay, here\'s the requirements, you need a Linux machine, it needs to be reachable from the internet. And you need to have control of the DNS for the site. And of course, preferably for the server to so we\'re going to have set up DNS and pointed for both of those. Okay, let\'s go ahead and do it. What we\'re going to do for the server is we\'re going to spin up the server, point the server and site DNS to it. And then we\'re going to set up the firewall. And then we\'re going to create a user so that our user can complete the setup. We don\'t want to work with root on a server. We want to stop that as soon as we can, always so Okay, let\'s do it. We\'re going to spin up the server. Let\'s go to linode. Here, I am going to create a linode. And I\'m going to use a boon to 2004 because it\'s working really well with it\'s working really well with data of these days. It has the Docker and Docker compose that we need in it. So you don\'t have to go don\'t have to work as well as hard to install it. I\'m going to choose Fremont, California. And I\'m going to choose the nano plan the $5 a month plan. And we\'re going to call this demo the faze us.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>4:33  <br>\nAnd I\'m going to tell it to put my SSH key in there for route already. So here we go. And this will take just a couple of minutes, but I\'ll pause while it\'s doing it.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>5:13  <br>\nNow,</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>5:14  <br>\nso let\'s go ahead and do our do our next step here, we\'ve got it spun up. And now we\'re going to point the site and the server DNS to it. So we can use those easily. So here\'s the IP address, I\'m just going to copy that. And I\'m going to go over to my DNS. And the, the project, the site that we\'re going to move is PHP kgR consulting Comm. And so the first thing I\'m going to do before I try to move the whole thing, I\'m just going to move a test version of it. So I\'m going to say that I want to move demo.pk Hr consulting. And I\'m going to set it to one minute timeout. And here\'s my new IP address. I\'m going to use that. And now let\'s make a name for the server as well. And that\'s going to be demo dot the fes.us.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>6:49  <br>\nWhat did I do wrong here?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>6:53  <br>\nOh, I didn\'t delete it before. So here we go. I did a test run of this before. And I didn\'t delete this one. So I set it to one minute timeout. So it\'s probably okay, but we can get in there anyway. But I\'m going to change it to the new IP address. And let\'s just do one thing. While we\'re over here. I like to not forget to set the reverse DNS, when I\'m setting up one of these. So here\'s the IP v v. Four address. And I\'m going to edit the reverse DNS demo that that phase got us. Oh, it doesn\'t have the forward entry yet. It\'s, it\'ll be there in a minute. I\'ll come back to that after a while. So okay. Let\'s take a look at where we are. We\'ve we\'ve pointed the DNS adequately. And now we need to log in there and set up a firewall and a user. So let\'s go ahead and do that. So I can just go here, and I\'ll use the IP address for now to get in there because I\'m not sure that we can.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>8:22  <br>\nLet\'s see if we can Oh, look at that because I already named this once it I have a clash.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>8:34  <br>\nAnd I can get rid of it. It looks like I\'m already I\'m already on my way. Okay, here\'s my new site. This always bothers me to see localhost here. So I\'m going to set the hostname</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>9:00  <br>\nMo Mo dot the phase. So I\'ve got the hostname set now and we are going to set up the firewall. So Ufw allow at, we\'re gonna allow Port 43 HTTPS port and Port 22 for SSH. And we will say Ufw enable and we know That it\'s good. So here we are. So we have Ufw status. And we have those, those things coming through. So we have our firewall set up, we certainly don\'t want to install Docker with the firewall off, we only want to allow through the particular places. Okay, so now we\'re going to create our sudo privileged user. So I am going to user add dash m, r Fe. And now we have the R fe user, we\'re gonna put it in the pseudo group.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>10:53  <br>\nI guess that\'s not the right command. But I can just say, oh, it is the right command, I just didn\'t say R Fe.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>11:13  <br>\nSo now our fe is a member of the pseudo group. So be able to use sudo. And let\'s set the password for our Fe. I\'ll need to use that for sudo a little later. And let\'s, let\'s go ahead and set up the RFA.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>11:39  <br>\nSSH settings. So I\'m going to I forgot one other thing I want to do. I want to set our face, shell to bash so that I can tell what I\'m doing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>12:05  <br>\nThere, we\'ll do an SSH key, Janet creates the keys in the right directory with the right permissions and that kind of thing. And now I\'m going to create the authorized keys file, so I\'ll be able to go in there.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>12:26  <br>\nAnd</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>12:37  <br>\nI\'ll take my public key. And I will paste it in here. And my permissions a little more limited. And I should have everything I need to do is route should now be done. I\'ve got the firewall set up. I\'ve got my user setup. And so now we\'re going to log in as that user and install Docker in detail. So I will come back out of here. And I\'m just going to log in as an unprivileged user, and here I am, I\'m able to go right in there. And now we\'re going to install now we\'re going to install Docker and details. So let\'s take a look at the instructions for that. Here\'s documents instructions in the detail have read the docs. So we are going to just do this command apt get update and apt get install docker.io and Docker compose.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>13:54  <br>\nDid I type it right? Probably not. Got it right on the second time, though. And so yes, we do want to install those. Now, you never want to forget that on Linux, you have a couple of post install steps. So you have to add the user to the Docker group. So we\'ll do that right quick.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>15:02  <br>\nNow you see that our fe is in both the sudo and the Docker groups. If I do a docker ps, I should be able to talk to it, and I can\'t. So I will log in again. And now I\'m in. So I\'ve got the Docker officially added to my account now. So now we\'ve got Docker working, we need to do is install dedeaux. So let\'s go ahead to the docs for that. Here\'s the we\'re going to use the script to install, you can also use homebrew. But we\'re going to use the script to install it. So I\'m just going to copy here. And I\'m just going to paste. And this just curls the script and runs it. And we can see what\'s going on now it also installed make cert for us.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>16:02  <br>\nWe have data one dot 16 dot one here. So we should be good. So we\'ve got D Dev, and Docker. And now we\'re going to check out the code and import the files in the database. So I usually put all my projects in a directory called workspace that\'s a hangover from long ago using Eclipse. But that\'s what I always do. And that\'s where I was expect them to be. So I\'m going to clone</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>16:44  <br>\nthe code here for this. So now I\'m in the directory, there\'s everything I want to know. Everything I want to have. We\'re going to import the files and dB, I guess we need to configure it before we can do that. So let\'s do the Configure. We\'ll just do it with the additional Fq DNS To start with, No we won\'t, we\'ll just do a D dev config. It automatically figures out the project name, the doc root, the project type. And now I can do a deep dive start. Wait a second for these. For these things to be pulled? Really we should it disabled, PHP myadmin. And we should have disabled the</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>17:49  <br>\nSSH agent as well. So we\'ll do that in a minute. Okay, there we are, we have it running. We can\'t easily hit it with a browser yet. Because we aren\'t pointing the def site to it. And we haven\'t, we haven\'t put a database in there. So we just want to install anyway. So let\'s remember though to do the deed of config global</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>19:09  <br>\ndash dash omit containers equals data, SSH agent. And. And we probably don\'t need the data of SSH agent. Usually that\'s used in more of a development environment. So I\'m just going to do that and we\'ll get those done. And now let\'s let\'s get some files in a database up there. I always put files in a database in a directory called tarballs. So what I\'m going to do then, is I\'m going to copy from my system at home where I am here Have these files and database downloads. And I\'m going to SCP Star 2021 125 star to demo dot the phased on us workspace peak, hr consulting.com dot tarballs. So there I got those up there. So I\'ll just SSH in again.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>20:45  <br>\nSo here they are, my project is running. And I\'m going to do a deed of import files, data source equals P.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>21:03  <br>\nI\'m going to get the files in there. And now I\'m going to do a D dope import dB. And we\'ll get the the DB in here. It looks like I did the wrong thing. That\'s the right command. So now we have a running site, I can curl the site.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>21:49  <br>\nAnd I should see a regular Drupal seven contents. And I do so I can hit that now. So I have a running site, and it has its files, and everything else. So we\'ve checked out the code, imported the files in the database. Now, what we\'re going to do is use an additional FQ dn for testing. So we decided to use demo.pk, PK hr consulting.com as our site. So let\'s do that. Oh, did we already do it? No, we didn\'t add any additional Fq DNS yet. Demo dot pkg are consulting.com. And now we need to do a couple of global configuration here. We need to tell DD of globally to bind all interfaces, which means listen to the outside world. In a development environment. We don\'t want to be listening to the outside world. And we\'re going to guess here\'s the omit containers. We already did that. We\'re going to do the use hardened use hardened images, use Let\'s Encrypt and Let\'s Encrypt email. So let\'s do that.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>23:49  <br>\nAnd what else do we have to do? We already did the omit containers on router by router bind all interfaces has to be done.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>24:02  <br>\nOkay, there they all are. We have the we have everything set up here. And we can do it. We\'re going to do a df power off so that the so that we start over with all the right images in the right global configuration.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>24:30  <br>\nNow we\'re going to do a deep dive start. Let\'s just let\'s just ping demo dot p hr consulting.com and see if it\'s resolving and it is resolving. So that\'s good. So we\'ll do a deep dive start. And it has to pull the hardened image since we now change the configuration to require the hardened image</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>25:37  <br>\nThe router is negotiating with Let\'s Encrypt to get that to get that new cert. And so we should have the new cert now. And we should be able to hit HTTPS demo dot pkg consulting.com. And it could even work. And it did work. That\'s amazing. There it is, if you look at the certificate, you\'ll see that it was just issued, it\'s it expires in February. It\'s now November, this is three months from now. There it is. So we\'ve got demo dot pkg, or consulting going. So that\'s good, we can go around to it, we can log into it. All those things. So we\'ve done our DTF start, it\'s working. And there\'s some things that you\'d want to do after that. So the next thing that we\'ll do, and we might as well do it right now is to add the real domain to the project. So what we\'re going to do, we didn\'t, we didn\'t want to do this until we had tested the product tested the site to make sure that it was working. But what we would do is take our go back and get our IP address here and go over to our DNS management. Go to PK HR consulting, go to DNS.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>27:19  <br>\nAnd</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>27:22  <br>\nnow we can change the actual root of this. So we\'ll change it from where it was to where it is. Now, it\'s a great thing to wait to do this until you\'ve already tested the site with a different sub domain. Because that way you know that it\'s good. And then as DNS propagates, you can expect it maybe the land a couple of times at the old site, before it lands at the new there, we\'ve got that out there. And that will be propagated within a minute or two. Because we set a very low TTL on it earlier for the for the move. But we need to now add this</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>28:08  <br>\nin our config dot YAML. We\'re going to add Kiki hr consulting.com. And we\'ll do a deep dive start again, we need to wait just a second for this start.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>28:27  <br>\nBecause we\'re hoping that that Let\'s Encrypt will pull pull up the new name. Let\'s see in PHR consulting.com. And it would be nice if it knew about the new one and 192 address. That\'s the one that we want. So let\'s see if it did upstart we\'ll get that for us.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>29:07  <br>\nLet\'s just go visit PK HR consulting. And it is not working yet. Most likely because we heard it too much with getting through there. Well, actually, yeah. So it\'s this, this does not have a it has our our development certificate on it still. And we don\'t want that we want the real thing. So let\'s just do our and because we want it to renegotiate, we want the router to renegotiate that. We\'ll do a deed of start again and we\'ll see if see if Let\'s Encrypt can find demo.pk Hr consulting now Okay, cross your fingers, hold your breath. And let\'s do a reload on this. And there it is. Now we have the new one, you can tell that it\'s a new cert, it\'s got the February 23, we\'ve got the site moved up there. Let\'s just take a look at the status report. It needs to have the database update script run on it. So we got a little bit of work to do. But things are looking pretty good. We can check for updates. It\'s a real live site. So there we are. Let\'s take a look at what else we need to do. So follow up, we just added the real Fq dn the fully qualified domain name, PK hr consulting.com, to the live site, so it actually moved over. We we set the DNS to point to it, and then we did a restart, and I did have to do a deed of power off. And it did have start to get the router to renegotiate probably as we started to quickly after changing the domain name and DNS, the the instructions in the list, just take a look here. here\'s the here\'s the casual web posting section of D dub dot read the docs.io. And it tells you how to set up. So that D dub will automatically start on system setup because on systems system boot, you certainly want that. So there\'s a there\'s the technique for doing that. So you want that you probably want your containers to auto restart, that\'s a global configuration. You want to enable outgoing mail from the site, if you have any transactional email, especially mail usually would go to you but if you have any transactional email, and you have to in enable outgoing, you probably want to enable outgoing email from the server and tell it where to go so that you get notifications. If the server has trouble, those we won\'t go into those. Setting up outgoing email from the site usually means installing an SMTP module and bouncing it through one of them, you know, mailgun, or one of the email providers like that. And you probably want to configure off site backups, that\'s another that\'s can also be done with a modular plugin. There\'s many other ways to do it, you can you can do D Dev, export dB, and save the file if you want to or D dev snapshot. And reverse DNS. I was almost going to do that at the very beginning. But I recommend that you do set up reverse DNS helps mail to work. So we got it. We got it going. Some Reese\'s resources for you the casual web hosting Doc\'s or indie dev dot read the read the docs.io you can just search for casual in there. The dev repo github.com, dread D Dev. And don\'t forget about D dev.com. The dev live project data has been sponsoring dev local now for four years. And you should try out D dev live for real manage toasting there\'s a there\'s a</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>33:45  <br>\ngreat</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>33:47  <br>\nstartup deal out there. And then I think the pricing for for a regular site is $15 a month or something like that right now. Anyway, thank you very much for joining me, and happy to see you at any of the support locations. Anytime. And I hope you\'ll try this out. Thanks so much.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Transcribed by https://otter.ai</p>\n<!-- /wp:paragraph -->','Watch: DDEV-Local New Casual Webhosting Feature','','publish','closed','closed','','watch-ddev-local-new-casual-webhosting-feature','','','2020-12-26 09:42:50','2020-12-26 16:42:50','',0,'https://www.ddev.com/?p=3587',0,'post','',0),(3592,11,'2020-12-04 05:26:47','2020-12-04 12:26:47','<!-- wp:shortcode -->\n[embed]https://youtu.be/k_qlB5ZAk8k[/embed]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p>In this screencast we\'ll quickly create a <a href=\"https://www.ddev.com/DDEV-Live\">DDEV-Live</a> site from a local project, then make changes, push them up to a pull request on GitHub, then get the DDEV-Live bot to create a preview URL and site specific to that PR.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>What is DDEV-Live?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>DDEV-Live is our managed hosting service. You can interact with it via ddev-live <a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">command-line client</a> and via pushing to GitHub or GitLab. Currently it supports Drupal, TYPO3, and WordPress, with more platforms coming in the future.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>What is the Preview Feature?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>When interacting with customers and colleagues or collaborators, we often need to be able to show our work as it progresses, and the <a href=\"https://www.ddev.com/DDEV-Live/#ddev-preview\">DDEV-Live Preview Feature</a> does just this. You create a pull request with new code, and easily add a preview site to it, with its own resources, database, and code. The preview URL is provided right on the pull request.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Outline of the Screencast</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>In the screencast we:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Create a site from a running <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a> project, <span style=\"font-weight: 400;\" class=\"ugb-highlight\"><code>ddev-live create site drupal &lt;sitename&gt; --drupal-version=9 --branch=main --docroot=web --run-composer-install --github-repo=rfay/&lt;reponame&gt;</code></span></li><li>Wait for the site creation to complete.</li><li>Push the user-generated files up to the new site with <span style=\"font-weight: 400;\" class=\"ugb-highlight\"><code>cd web/site/default/files &amp;&amp; ddev-live push files &lt;sitename&gt; </code></span></li><li>Push the database (from the local project) up with <span style=\"font-weight: 400;\" class=\"ugb-highlight\"><code>ddev-live push db d9demo &lt;database_dumpfile&gt;</code></span></li><li>Wait for the pushes to complete and then verify the new site.</li><li>Create a new branch and add some new code in the DDEV-Local project. In this case we\'re adding a theme by doing <code>ddev composer require drupal/vani</code></li><li>Add the code, make a commit, push the new branch, and create a pull request.</li><li>The DDEV-Live bot immediately gives us instructions on the PR, suggesting that we submit a comment with the text <code>/ddev-live-create-preview</code>. Do it, and a preview site is created.</li><li>Verify that the new theme is available and enable it on the preview site.</li><li>When done, pull the pull request and note that DDEV-Live automatically deletes the preview site.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Read more about how to use <a href=\"https://docs.ddev.com/preview-bot/\">DDEV-Live in the documentation</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','Watch: DDEV-Live Preview Feature','','publish','closed','closed','','watch-ddev-live-preview-feature','','','2021-02-02 09:48:03','2021-02-02 16:48:03','',0,'https://www.ddev.com/?p=3592',0,'post','',0),(3597,16,'2020-12-01 17:30:32','2020-12-02 00:30:32','','FAQ','','publish','closed','closed','','faq','','','2020-12-01 17:30:32','2020-12-02 00:30:32','',0,'https://www.ddev.com/?p=3597',4,'nav_menu_item','',0),(3599,11,'2020-12-28 11:46:39','2020-12-28 18:46:39','<!-- wp:paragraph -->\n<p>If you know something about Docker, you know that you can throw one or two Docker images together and get yourself a working local development environment. There are plenty of nginx and php images out there on <a href=\"http://hub.docker.com\">hub.docker.com</a>, and you can do lots and lots of things with them. So why use <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a>, a tool that runs on Docker, when you could just roll your own Docker solution for local development? I\'ll try to make a comparison. Of course I\'m biased in favor of DDEV-Local.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3><strong>Custom Docker or docker-compose solution:</strong></h3>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>You have complete control and can customize as much as you want to.</li><li>You do all the development and you do it your way.</li><li>You do all the support to handle your team\'s problems and needs.</li><li>You get to determine what features you\'ll work on.</li><li>You can potentially make the configuration match your deployment environment more exactly than an off-the-shelf product like DDEV-Local.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3><strong>DDEV-Local:</strong></h3>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://github.com/ddev/ddev\">Open-source project</a> with no vendor lock-in.</li><li>Has already undergone more than 4 years of development, adding requested features and collaborating with community contributors. <a href=\"https://github.com/sponsors/ddev\">Sponsor DDEV on GitHub!</a></li><li>Explicit support for <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#quickstart-guides\">many CMS types</a>, including Drupal, Backdrop, TYPO3, Magento, Laravel, WordPress, Shopware and generic PHP or non-PHP projects. DDEV-Local will set up beginning settings files for you so you\'re set up in moments, but you can <a href=\"https://ddev.com/ddev-local/controlling-cms-settings-files-in-ddev-local/\">turn feature that off</a> when you don\'t need it.</li><li>Support for nearly all versions of both MySQL and MariaDB.</li><li>Out-of-the-box support for both Nginx and Apache and PHP 5.6-8.0.</li><li>Trusted https for every project.</li><li>Import, export, and snapshot databases.</li><li>Run or start as many projects as you want to, all at the same time, depending on the resources you have available. Each project can have different PHP version, use apache instead of nginx, etc.</li><li>Works the same on macOS, Linux, Windows and WSL2; great for diverse teams.</li><li>ssh integration (ssh-agent bundled so you can use your keys inside the container for accessing hosts or private composer repositories.</li><li>Composer support built into the web container and accessed with <code>ddev composer</code>.</li><li><a href=\"https://ddev.readthedocs.io/en/stable/users/step-debugging/#step-debugging-with-ddev-and-xdebug\">XDebug step-debugging</a> out of the box. Just <code>ddev xdebug on</code> and go.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:image {\"id\":3685,\"width\":512,\"height\":287,\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image is-resized\"><a href=\"https://www.ddev.com/ddev-local/ddev-local-phpstorm-and-xdebug-debugging/\"><img src=\"https://www.ddev.com/content/uploads/2020/12/Screen-Shot-2020-12-28-at-12.49.31-PM-1024x573.png\" alt=\"DDEV-Local, PHPStorm and Xdebug video and blog post\" class=\"wp-image-3685\" width=\"512\" height=\"287\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:list -->\n<ul><li>Integration with <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/pantheon/\">Pantheon.io</a> and <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/DDEV-Live/\">DDEV-Live</a> for hosting.</li><li><code>ddev share</code> lets you show work in progress to anyone anywhere in the world.</li><li>Respect for other tools and production environments: DDEV-Local doesn\'t reconfigure your computer or require exact versions of Docker, etc.</li><li>Extensive customization available, including adding packages and docker-compose recipes, with dozens of published solutions in <a href=\"https://github.com/ddev/ddev-contrib\">ddev-contrib</a> and <a href=\"https://stackoverflow.com/tags/ddev\">Stack Overflow</a>. (ApacheSolr, redis, MongoDB, RabbitMQ, Blackfire, Varnish, ...)<br>Custom commands based on shell scripts, that can be added as team needs grow.</li><li>Outstanding open-source community with <a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">support in many channels</a>.</li><li><strong>Team lead gets the day off</strong>! This is perhaps the biggest of the many benefits of DDEV-Local, and perhaps the most important. When you use a standardized, supported solution, your team leads don\'t spend all their time helping everybody else keep the development environment going. It\'s the same on every platform, project configurations get checked in, and mostly people just work on things instead of spending their time keeping the environment going (or extending it).</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>There are significant benefits of building and maintaining your own Docker-based dev environment, but I think you\'ll have more free time if you use ours!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Read the <a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local documentation</a> to get started.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->','Why use DDEV-Local instead of rolling your own Docker-based local dev solution?','','publish','closed','closed','','why-use-ddev-local-instead-of-rolling-your-own-docker-based-local-dev-solution','','','2020-12-28 11:46:40','2020-12-28 18:46:40','',0,'https://www.ddev.com/?p=3599',0,'post','',0),(3615,11,'2020-12-08 18:26:40','2020-12-09 01:26:40','<!-- wp:paragraph -->\n<p>Any web developer will have to move a site from one place to another periodically, so mastering the concepts and the details are important. The details are a little different from CMS to CMS, but the big picture stays mostly the same. Please note that many people have many opinions about all of this, and some people will disapprove of what I say, but it\'s intended to teach you the basic process, not the exact procedure. It also will necessarily be incomplete, since there\'s no way to cover every platform or CMS, or every permutation of deployment.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li><strong>Move the code for the website</strong>. If the site is just an HTML/JS site, you\'re done. (Typically the code is checked via Git or some other source management situation, so it can be checked out in the new location.)</li><li><strong>Move the database</strong>, which has dynamic content in it. In many cases this is just one database, but in complex situations it could be more than one database.</li><li><strong>Move the user-generated or dynamic files</strong>. On Drupal, for example, the sites/default/files directory typically has all these user-generated or dynamic files. (There may be more than one directory of user-generated/dynamic files. In Drupal there may be private files in a directory outside the docroot.)</li><li><strong>Move the exported configuration</strong>. In Drupal 8+, for example, the config_sync_directory has this explicit exported configuration.</li><li><strong>Build the site in the new location</strong>. Although older sites didn\'t have a build process for deployment, almost all the newer ones do. At the very minimum, this is typically a <code>composer install</code> to populate the vendor directory, which is often not checked into code. But there may be far more sophisticated requirements to the build, like an <code>npm install</code> or a <code>compass compile</code>. The basic idea is that your site may have a deployment build process which will have to be replicated in the new location.</li><li><strong>Configure database settings files</strong>. Normally the database credentials on one server will not be the same as on the other, so you\'ll need to update the database settings as your CMS or platform requires.</li><li><strong>Transform URLs if necessary</strong>. Some CMSs like WordPress, Magento, and Shopware, have a tendency to bury multiple references to the site URL inside the database, so a transformation has to take place after all this is done. We wish they wouldn\'t do this of course, but we have to live in the world we live in. Read about <a href=\"https://www.ddev.com/ddev-local/sharing-a-ddev-local-project-with-other-collaborators/\">how to transform URLs</a>. You\'ll need to understand how to manage this in your particular CMS, as each does it differently. (Note that in Drupal, TYPO3, and Backdrop at least, incorporating a full self-referencing URL inside dynamic content is at least a party foul, probably worse, and it ruins standard deployments.)</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Simplest deployment: Drupal through Drupal 7 - code, database, user-generated files, no build process</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Up through Drupal 7, all you had to do to move a site in many cases was to check out the code, load the database from a database dump, and get the files into sites/default/files where they belong. In those days (and still on WordPress) that\'s mostly what you have to do. Here is the process:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>On the source server</strong> (can be <a href=\"https://ddev.readthedocs.io/en/stable/\">DDEV-Local</a> or anywhere else):</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Dump the database. If the source project is in DDEV-Local, this means just doing an <code>ddev export-db --file=/path/to/sitename.db.sql.gz</code> If you\'re on a server or elsewhere, and assuming a single database, you can <code>mysqldump &lt;databasename&gt; | gzip &gt;/path/to/sitename.db.sql.gz</code></li><li>Tar up the user-generated files: <code>cd &lt;docroot&gt;/sites/default/files &amp;&amp; tar -czf /path/to/sitename_files.tar.gz .</code></li><li>Make sure your code has been checked in and pushed properly.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>On the target server</strong> (which can be DDEV-Local or anything else):</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Check out or update the code from your git repo or wherever it\'s stored.</li><li>Copy your database dump to the server and load it into the database server using a tool like mysql, for example <code>gzip -dc sitename.db.sql.gz | mysql &lt;databasename&gt;</code> (or on DDEV-Local <code>ddev import-db --src=/path/to/sitename_db.sql.gz</code>)</li><li>Copy your user-generated files tarball to the target server and untar it in the correct directory: <code>cd &lt;docroot&gt;/sites/default/files &amp;&amp; tar -zxf /path/to/sitename_files.tar.gz</code>. (Or on DDEV-Local <code>ddev import-files --src=/path/to/sitename_files.tar.gz</code>)</li><li>Edit your settings.php or settings.local.php (preferred) to point to the database you\'ve loaded.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Drupal 8+ deployment: code, database, files, config, site build</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Drupal 8+ is Drupal 7 with some extras, including copying the exported configuration and doing a <code>composer install</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>On the source server:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Do the steps you would have done for Drupal 7</li><li>Determine what build processes are required for the site. compass? npm install?</li><li>Export your configuration, for example, <code>drush cex</code>. The result will show you where the config was exported to. (This step is only necessary if configuration changes are to be migrated to the target server.)</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>On the target server:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Do the steps you would have done in Drupal 7</li><li><code>composer install</code> (or <code>ddev composer install</code> if the target is a DDEV-Local project.)</li><li>If there are other build steps discovered for the site, like an <code>npm install</code> or <code>compass</code>, add those processes.</li><li>Copy the exported configuration to the target server if necessary and put it in the configuration directory specified in your settings.php or settings.local.php (preferred). Then <code>drush cim</code> to import it. Best practices include checking to make sure config hasn\'t been changed in the database on the target server.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>TYPO3 deployment (based on TYPO3 v10)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>TYPO3 is mostly the same as Drupal 7 plus a composer build, but there are often (generated) files on the local system that need to be checked into git.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>On the source server</strong> (can be DDEV-Local or anywhere else):</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Dump the database. If the source project is in DDEV-Local, this means just doing an <code>ddev export-db --file=/path/to/sitename.db.sql.gz</code> If you\'re on a server or elsewhere, and assuming a single database, you can <code>mysqldump &lt;databasename&gt; | gzip &gt;/path/to/sitename.db.sql.gz</code></li><li>Tar up the user-generated files: <code>cd public/fileadmin &amp;&amp; tar -czf /path/to/&lt;sitename&gt;_fileadmin.tar.gz .</code> (Note that the user-generated files must <em>not</em> be checked into git.)</li><li>Verify that the <code>/config</code> and (optionally) <code>/var/labels</code> directories are checked into your git repo. These are directories which may have been created by sitebuilder actions, but they\'re <em>code</em>. (Nothing else in /var should be checked in.)</li><li>Make sure your code has been checked in and pushed properly.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>On the target server</strong> (which can be DDEV-Local or anything else):</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Check out or update the code from your git repo or wherever it\'s stored.</li><li>Run <code>composer install</code> (on DDEV-Local, <code>ddev composer install</code>). If there are other build activities like a <code>yarn install</code>, do those.</li><li>Copy your database dump to the target server and load it into the database server using a tool like mysql, for example <code>gzip -dc sitename.db.sql.gz | mysql &lt;databasename&gt;</code> (or on DDEV-Local, <code>ddev import-db --src=/path/to/sitename_db.sql.gz</code>)</li><li>Copy your user-generated files tarball to the target server and untar it in the correct directory: <code>cd sites/default/files &amp;&amp; tar -zxf /path/to/sitename_files.tar.gz</code>. (Or on DDEV-Local, <code>ddev import-files --src=/path/to/sitename_files.tar.gz</code>.)</li><li>Edit your public/typo3conf/LocalConfiguration.php or public/typo3conf/AdditionalConfiguration.php (or .env file, preferred) to point to the database you\'ve loaded. If the target is DDEV-Local, it will already take care of this for you.</li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>From DDEV-Live to DDEV-Local</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>If your site is hosted on <a href=\"http://www.ddev.com/ddev-live\">DDEV-Live</a>, there\'s a nice <code>ddev pull</code> command to get it once the connection is established. See the <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/DDEV-Live/\">docs for a quickstart</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>From DDEV-Local to DDEV-Live</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>DDEV-Local does not (yet) have a \"push\" command, although it will in future releases. It hasn\'t been included to date because it\'s a dangerous operation - you could overwrite your production with an old database or something else that doesn\'t belong there. In general \"pushing\" a database to production is never done, except perhaps that one first time. After that other techniques are called for.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li>Make sure you know your site name and org, and do the <code>ddev-live auth</code> if it hasn\'t already been done. (<a href=\"https://docs.ddev.com/authentication/\">docs</a>)</li><li>If you are creating the site for the first time, create the site and import db and files, see <a href=\"https://docs.ddev.com/drupal-guide/\">Drupal docs</a> or <a href=\"https://docs.ddev.com/typo3-guide/\">TYPO3 docs</a>. In either case, you\'ll want your site configured to automatically do the <code>composer install</code> build step.</li><li>Push files with <code>cd &lt;docroot&gt;/sites/default/files &amp;&amp; ddev-live push files &lt;sitename&gt; .</code></li><li>Dump the database from DDEV-Local with <code>ddev export-db --file=/path/to/&lt;projectname&gt;_db.sql.gz</code> and then push it to DDEV-Live with <code>ddev-live push db &lt;projectname&gt; /path/to/&lt;projectname&gt;_db.sql.gz</code></li></ol>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>From DDEV-Local to Pantheon</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>If you\'re deploying to <a href=\"http://pantheon.io\">Pantheon.io</a> you can use the web interface to upload the database and files under \"Database / Files\" → \"Import\". Just use <code>ddev export-db --file=/path/to/&lt;site&gt;_db.sql.gz</code> for the database and <code>cd &lt;docroot&gt;/sites/default/files &amp;&amp; tar -czf /path/to/&lt;sitename&gt;_files.tar.gz .</code> to create a files tarball and upload them. Advanced users can also use the \"terminus\" tool, which is bundled in the web container and already authenticated if you\'ve done a <code>ddev auth pantheon</code> with <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/pantheon/\">our integration</a>. So <code>ddev ssh</code> and use terminus to upload.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Complexities and Alternatives</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>There is no standard for deployment or moving sites, and nothing will replace your team\'s knowledge of the site and the build process.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Some teams prefer to do the build on a build machine (or in CI, or on a dev machine) and check in or push the resulting artifacts. For example, some teams will do a <code>composer install</code> and then check in the vendor directory and related artifacts.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Resources:</h3>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.ostraining.com/\">OSTraining</a> has a free YouTube class on <a href=\"https://www.youtube.com/playlist?list=PLtaXuX0nEZk-ow4oT3yqxmjk4IRHz4jHl\">Moving a Drupal 8+ Site</a>. Highly recommended.</li><li>Many, many agency deployment strategies are home-grown and require custom scripts to push things back and forth. There are examples of scripts like this in <a href=\"https://github.com/ddev/ddev-contrib\">ddev-contrib</a>, see <a href=\"https://github.com/ddev/ddev-contrib/blob/master/custom-commands/dump-and-deploy-db\">Dump and deploy SQL from/to remote servers</a> and <a href=\"https://github.com/ddev/ddev-contrib/blob/master/custom-commands/fetchproductiondb\">Fetch Production DB from remote server</a>.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:block {\"ref\":2527} /-->\n\n<!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Mass juggling image by <a href=\"https://pixabay.com/users/sarahrichterart-1546275/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=2329843\">Sarah Richter</a> from <a href=\"https://pixabay.com/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=2329843\">Pixabay</a></p>\n<!-- /wp:paragraph -->','Moving CMS sites around (server-to-server, server-to-local, local-to-server)','','publish','closed','closed','','moving-cms-sites-around-local-servers','','','2020-12-09 18:04:42','2020-12-10 01:04:42','',0,'https://www.ddev.com/?p=3615',0,'post','',0),(3620,16,'2020-12-07 22:06:50','2020-12-08 05:06:50','<!-- wp:shortcode -->\n[embed]https://youtu.be/K9VyBr5D2lI[/embed]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p>When you are in the groove of working on a new feature for your web project the last thing you probably want to do is spend time setting up extra tools just to see how your work looks live. Many of us have staging environments, alpha environments, dev environments, several local servers on our machines and of course various continuous integration tools. All of those require at least a couple steps to get your work in progress “live” and may also be locations that you can’t <a href=\"https://www.ddev.com/ddev-local/sharing-a-ddev-local-project-with-other-collaborators/\">just share</a> with collaborators.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>With this in mind, and based on the feedback of real live DDEV users, we’ve just added the first features of what we’re calling “<a href=\"https://www.ddev.com/ddev-live/#ddev-preview\">DDEV Preview</a>” to the platform on all tiers and as part of the <a href=\"https://dash.ddev.com/pricing\">personal free trial</a>. Preview allows you to create a temporary staging site with one command directly on a pull or merge request. Let’s look at how this can be helpful!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-very-dark-gray-color has-luminous-vivid-amber-background-color has-text-color has-background\" href=\"https://www.ddev.com/news/release-notes-ddev-platform-23nov2020/\">Read the release notes here</a></div>\n<!-- /wp:button -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>When you need to stage and demonstrate work in progress</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>As a developer who does not want to break production, you likely do a lot of testing and staging before tagging and releasing new work. You may have found that despite best efforts with continuous integration, staging environments go stale and require extra attention when you go to use them. Along the way you’re losing hours on each project in getting all environments up to speed, not to mention finding clever ways (that aren’t piles of screenshots) to show clients work in progress, get approval and feedback on user experience, and more.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>That’s not all, either - you’ve got a wide variety of projects, various CMSs, configurations, dependencies, and services connected to each of them. There’s not much of a one size fits all approach so each needs a series of environments for dev, test, stage, production, especially when clients each have their favorite hosting providers.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In summary, it’s complicated, and it’s a lot to manage. That’s why, at the request of DDEV users, we added the capability to create a quick, temporary preview site with the latest changes from your Git repository.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Integrated preview sites with GitHub and GitLab</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>With the <a href=\"https://www.ddev.com/news/release-notes-ddev-platform-23nov2020/\">first set of features</a> for DDEV Preview, the author of a pull or merge request (we’ll just say PR here) can now build a site directly from that PR with a comment. The DDEV Preview Bot on GitHub or GitLab watches for PRs against branches that are deployed (but not necessarily published) on <a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a> and automatically comments on a PR when it is created.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The Preview site is deleted when the PR is closed, so you don’t wind up with stray sites counting against your overall account quota on DDEV-Live (assuming you keep your PRs tidy!). That means you’re automatically conserving resources in terms of platform costs, too. Preview can be used independently of DDEV hosting services. You can use Preview if you are a <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a> user, or anyone with a GitHub/GitLab repo, and just want to have a Preview site but not a published production site hosted on DDEV-Live.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Using Preview in conjunction with other DDEV platform features can further smooth the process of taking a feature, bug fix, or new site from local development to live deployment. The time savings an end-to-end integrated system offers adds up and gives time back to everyone involved. Developers can focus on getting the feature right, project managers can spin up preview sites to hand over to business for client check-ins, and return on hiring and infrastructure investment is maximized across the organization.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Here’s an example of how you in the real world might use this feature.&nbsp;</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>You have an account with DDEV-Live (in this example, we\'ll use GitHub, which requires the DDEV-Live GitHub app installed on your GitHub account and the  ddev-live CLI installed on your machine) and <a href=\"https://www.ddev.com/ddev-live/how-to-deploy-a-site-with-ddev/\">deploy a site</a> from a branch via a <a href=\"https://docs.ddev.com/drupal-guide/\">command</a> such as:&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><code>$ ddev-live create site drupal my-drupal-site \\<br>     --github-repo my-github-org/clientsite \\<br>     --branch workingbranch \\<br>     --drupal-version 9 \\<br>     --run-composer-install</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Now you have a copy of the code in your branch <code>workingbranch</code> available on DDEV-Live, but not published with DNS etc. You also push your database and file assets.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This is where DDEV Preview comes in. For this example, let’s say your client wants to see the current work on their new website theme <em>right now</em> (<a href=\"https://www.ddev.com/ddev-live/watch-ddev-live-preview-feature/\">watch Randy’s example with a theme change here</a>). Commit and push your local work to your GitHub repository <code>clientsite</code> on the <code>workingbranch</code> branch, and create a PR from that commit.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Because you have that branch deployed on DDEV-Live already, our <a href=\"https://docs.ddev.com/preview-bot/\">preview bot</a> will automatically recognize the PR against the deployed branch and will comment on the PR to ask what you would like to do next.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Run the suggested command <code>/ddev-live-preview-site</code> and the bot will build a preview site using the code in your PR and the assets from the previously deployed branch to show your work in progress as it would appear “live.” The bot returns a URL you can share with your client, displaying how their site will look with the new theme and their existing blog posts and images. They can validate that you’re on the right track and you can close the PR (automatically deleting the preview site) and continue working.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Launch and learn!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>What are you missing in your development workflow today? How could it be easier for you (and your team) to move small pieces of work from start to finish?&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The next set of Preview features for DDEV-Live will include updates to the dashboard user experience, support for forked PRs, and shared workspaces on the platform. Further down the road will be more fine-tuned configuration management and launching Preview sites from a wider variety of environments to truly fulfill our mission of being either one flexible component or home to your entire development workflow.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Preview is available in <a href=\"https://dash.ddev.com/pricing\">every plan on DDEV-Live</a> to facilitate collaboration, testing, and client approvals without creating and syncing a separate environment. Our aim is to empower open source developers who seek the freedom that flexible and configurable tools can grant a development workflow. We hope DDEV can fill that role for you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.ddev.com/contact/\">Contact us</a> for a personal walkthrough or to put together a custom DDEV plan to to save you time and energy.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->','What is DDEV Preview?','','publish','closed','closed','','what-is-ddev-preview','','','2021-02-02 09:45:21','2021-02-02 16:45:21','',0,'https://www.ddev.com/?p=3620',0,'post','',0),(3659,24,'2020-12-21 14:00:10','2020-12-21 21:00:10','<!-- wp:paragraph -->\n<p>We squeezed in a few more platform updates for you before the end of the year! Thank you to the folks who have been using <a href=\"https://www.ddev.com/ddev-live/what-is-ddev-preview/\">DDEV Preview</a> already and who shared their feedback. Below you’ll find some of the latest updates to DDEV-Live for hosting as well as an FAQ for the Preview features.&nbsp;Preview sites are designed to be temporary instances on the DDEV-Live platform that can be used to see new code in a production-like environment, share work, test with users, or used however you see fit. Preview can be used whether your production site is hosted on DDEV or not, and of course it pairs well with our full end-to-end workflow from <a href=\"https://github.com/ddev/ddev\">DDEV-Local</a>. Mix and match!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>You may want to: <a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">Install or update the ddev-live CLI</a> or <a href=\"https://dash.ddev.com/pricing\">Create your DDEV-Live account</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>In the latest release of the DDEV-Live hosting platform:</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Default PHP version is now 7.3. PHP 7.2 is still available (but <a href=\"https://www.ddev.com/news/ddev-live-php-7-2-notice/\">not recommended</a>), as is 7.4 and 8 has just been added.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We’ve also been working on adding appropriate controls for workspace administrators on the platform to list, add and remove users in a given DDEV workspace. This is available with <code>ddev-live admin</code>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Users can now expect to access the same repositories they have access to on GitHub via ddev-live, where they are a member of an organization that has installed the ddev-live <a href=\"https://docs.ddev.com/github/\">GitHub app</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>DDEV-Live CLI release 0.9.0:</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Users will now be able to execute <code>ddev-live list repositories</code> for a list of repositories connected to the current workspace.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Users will now be able to create a Preview site using the CLI and <code>ddev-live create clone site</code> against an existing site in their workspace. Created clones can be described and listed via <code>ddev-live describe clone &lt;my-clone&gt;</code> and <code>ddev-live list clones</code> respectively. Clones are operations which will ultimately result in a site. The resulting sites will also appear in the&nbsp; <code>ddev-live list sites</code> command and can be described individually with <code>ddev-live describe site &lt;my-clone&gt;</code>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>When you describe a site, you will also be able to clearly see whether it is a clone and what its origin site is. And of course, <code>ddev-live delete site &lt;my-clone&gt;</code> will clean up your workspace, remove the clone, and free up space to create another site.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><code>brew upgrade ddev-live</code> or <a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">download</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 id=\"FAQ\">Some Frequently Asked Questions on DDEV Preview:</h3>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Q: How do I set an automatic expiration on a Preview site I created using the PR chat bot?</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A: Preview sites created directly on PRs in GitHub or GitLab will be automatically deleted when the PR closes, or when you <a href=\"https://docs.ddev.com/preview-bot/\">comment on the PR</a> with <code>/ddev-live-delete-preview-site</code>. Any site of type “clone” is also automatically deleted when the origin site is deleted, so there are no orphaned site clones.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Q: What if I want my Preview site to expire at a different time, such as 24 hours after creation?</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A: You can add a site expiration via the ddev-live CLI as you would for any <code>site</code>. First run <code>ddev-live list clones</code> or check your PR for the Preview &lt;site&gt; name, then run <code>ddev-live config drupal &lt;site&gt; --expires-in 1d</code>. <a href=\"https://docs.ddev.com/sites/#setting-expiration-on-your-site\">Read more about site expirations in the docs</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Q: Can I use the bot with <a href=\"http://gitlab.com/\">gitlab.com</a> or only with self-hosted GitLab install?</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A: Using <a href=\"https://docs.ddev.com/gitlab-bot/\">the bot on gitlab.com</a> works the same as on self-hosted GitLab.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Q: How can I specify a database for my Preview site?</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A: As a Preview site is a clone of an origin site, it automatically receives a clone of the origin site database at the time of the creation. Once created, the origin and clone databases may diverge, and can be optionally synced using <code>ddev-live push / pull</code> if desired.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The same applies for the file assets. The file assets are cloned without a delay using copy-on-write file system, so the clone site receives its assets instantly.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To replace the default cloned database, you can use <code>ddev-live push db &lt;pr-site&gt;</code> to <a href=\"https://docs.ddev.com/databases/\">push a separate prepared database in</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Q: Is there an extra charge for the Preview features? Is there a limit? Do they time out?</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A: Preview is included on all <a href=\"https://dash.ddev.com/pricing\">DDEV-Live plans</a>.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>A Preview site from the perspective of billing and quota management is the same as any other site. For a plan which includes N sites, you can have up to N sites on DDEV-Live in total, regardless of their type (regular “site” or “clone”, for example).&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>By default, Preview sites don’t timeout, except when their lifespan is tied to the PR they were created on - then they are deleted when the PR is closed. It is also possible to use <code>ddev-live config [site-type] [site-name] --expires-in=[duration]</code> to <a href=\"https://docs.ddev.com/sites/#setting-expiration-on-your-site\">configure any site’s expiration</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Q: If my plan includes 5 sites, are there rules as to how I allocate those sites for Preview, production, etc?</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A: The limit is for all types of sites in total. If you have a cap of 5 sites, you can have 1 origin + 4 clones; or 3 origin + 2 clones, etc.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To put it slightly differently: you may choose to have one Preview site for each site you deploy on DDEV-Live, or have one production site (live on the web), two deployed non-production sites, and two Preview sites that reference one of the deployed sites as their origin.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Q: What happens if you use the maximum number of sites and then try to launch another Preview?</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A: The PR bot will inform you on the PR that you are about to hit your quota. Here is a screenshot:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image -->\n<figure class=\"wp-block-image\"><img src=\"https://lh5.googleusercontent.com/fAiLYhhjV6TWVTkSr84X0MDqx2eoxmnGpvL1H5VhN25Pfhwe8sBX6idtHqt1lvwRIG73sbPL3LIsEO9d0yg_LfA5PxPVd8POTPBODsiqEN7mZ3iqTw8uWSGRsYeE7v2M-L9rVkVb\" alt=\"Screenshot of the ddev preview bot feedback, showing a comment on a Git PR that says &quot;error log... denied the request: would exceed quota...&quot;\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Q: The Preview bot comments keep disappearing from my PR, why is that?</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A: The bot interaction is intended to be summarized on the bottom of the PR thread. You will always find the most current status for the site when you scroll all the way down. To keep the thread tidy, the bot cleans up after itself for all the old and no longer relevant messages. To republish the PR bot help text at any time, comment with <code>/ddev-live-help</code>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>What’s next?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>If you’d like to know more about how DDEV-Live and the Preview feature set work, watch as DDEV-Local maintainer Randy Fay creates a <a href=\"https://www.ddev.com/ddev-live/watch-ddev-live-preview-feature/\">Preview site using the PR bot</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Our goal is to provide you with features and functionality that assist you in the ways you want to work, whether that’s managing long term workflow complexity or just spinning up a quick site. As always, the most valuable thing you can do is send your feedback on the experience! Ask questions, experiment, and use that DDEV-Live API token to integrate.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"very-dark-gray\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-button is-style-default\"><a class=\"wp-block-button__link has-very-dark-gray-color has-luminous-vivid-amber-background-color has-text-color has-background\" href=\"https://www.ddev.com/contact/\">What can DDEV solve for you? Drop us a line!</a></div>\n<!-- /wp:button -->','Release Notes: platform updates and DDEV Preview FAQ','','publish','closed','closed','','release-notes-platform-updates-plus-ddev-preview-faq','','','2021-02-03 18:17:22','2021-02-04 01:17:22','',0,'https://www.ddev.com/?p=3659',0,'post','',0),(3692,2,'2021-01-01 11:30:41','2021-01-01 18:30:41','<!-- wp:paragraph -->\n<p>I began working on the <a href=\"https://www.ddev.com/workflow/the-ddev-story/\">DDEV platform concept</a> in February of 2013, motivated by the desire to allow the individual web developer to remain relevant. As I reflect on where we started in 2013 and what lies in front of us for 2021, I can\'t help but feel a deep sense of gratitude and excitement for what the new year brings. In 2013, I watched an industry growing from the grass-roots efforts of millions of open source contributions into proprietary systems designed to capitalize on contributors.  As we enter 2021, I believe the tools to break that cycle are reaching maturation, and I\'d like to help you understand how DDEV will continue to help.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Successful web developers must solve three fundamental problems to focus on their craft.  The first is creating a working environment. The second is delivering the results of the work, and the third is collaborating with others. These three areas are at the root of why we created DDEV and why we love to hear what you need from the tools. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a> is an extendable, container-based local development environment for developers. With a strong focus on PHP, it removes the friction of a working environment for thousands of web developers daily. By focusing on containers, it allows for significant customization limited only by your creativity.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Deploying from local to environments of your choosing should be seamless. Establishing frameworks to deploy to existing cloud platforms or bare metal is a significant focus for 2021. Moving beyond the command line into graphical interfaces will allow us to become more accessible for a broader range of developers.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a> is an API-driven platform to enable CI/CD, hosting, and infrastructure management for your work. It is built on Kubernetes and Cloud-Native principles that we believe will drive the industry for the foreseeable future. We ended 2020 by enhancing our hosting capabilities with <a href=\"https://www.ddev.com/ddev-live/#ddev-preview\">DDEV Preview</a>, which can replicate environments based on pull requests. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In 2021, you will see broader integration with local development tooling and existing workflows through a series of language-specific SDKs that expose platform integration to any number of tools or processes. In addition to speed and usability improvements, translating services and behaviors used locally into and out of Kubernetes resources is a primary focus for the coming year.  Our goal is to support you as you move beyond the traditional CMS by allowing you to define the systems you build.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The type of work we perform at DDEV takes time to mature and is wholly dependent on clear communication to maintain alignment with your needs. 2021 is the year the DDEV platform illustrates that we are listening and serving a significantly different world.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Thank you for your continued interest and support. Let\'s build the future together.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2527} /-->','DDEV in 2021','','publish','closed','closed','','ddev-in-2021','','','2021-02-02 09:47:33','2021-02-02 16:47:33','',0,'https://www.ddev.com/?p=3692',0,'post','',0),(3712,8,'2021-01-06 15:21:32','2021-01-06 22:21:32','','Sitemap','','publish','closed','closed','','sitemap','','','2021-01-06 15:21:32','2021-01-06 22:21:32','',0,'https://preview-ddev-com-php74-ddev-external-sites.sites.xxx/?p=3712',5,'nav_menu_item','',0),(3718,8,'2021-01-08 16:28:08','2021-01-08 23:28:08','','Search','','publish','closed','closed','','search','','','2021-01-08 16:28:09','2021-01-08 23:28:09','',0,'https://www.ddev.com/?page_id=3718',0,'page','',0),(3720,8,'2021-01-08 16:32:09','2021-01-08 23:32:09',' ','','','publish','closed','closed','','3720','','','2021-01-08 16:32:09','2021-01-08 23:32:09','',0,'https://www.ddev.com/?p=3720',5,'nav_menu_item','',0),(3722,16,'2021-01-08 16:45:36','2021-01-08 23:45:36','We\'re already looking forward to DrupalConNA in April! There\'s lots to do before then:\r\n\r\nHere are the <a href=\"https://events.drupal.org/drupalcon2021/program/key-dates\">key dates</a> for registration, the call for content, as well as... DrupalFest??\r\n\r\nIf you\'re interested in contributing to the organizing efforts, check in the <a href=\"https://drupal.slack.com/archives/C17B88HB4\">#drupalcon channel</a> on <a href=\"https://www.drupal.org/community/contributor-guide/reference-information/talk/tools/slack\">Drupal Slack</a>.\r\n\r\n&nbsp;\r\n\r\nMore coming soon.','DrupalCon North America 2021','','publish','closed','closed','','drupalcon-north-america-2021','','','2021-01-08 16:45:36','2021-01-08 23:45:36','',0,'https://www.ddev.com/?post_type=event&#038;p=3722',0,'event','',0),(3724,16,'2021-01-11 16:11:14','2021-01-11 23:11:14','<iframe title=\"Walkthrough of DDEV-Local and DDEV-Live\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/9Vbwj_TKeU8?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>','','','publish','closed','closed','','d6eb5d52725bf33c76908a7aa43349d1','','','2021-01-11 16:11:14','2021-01-11 23:11:14','',0,'https://www.ddev.com/uncategorized/d6eb5d52725bf33c76908a7aa43349d1/',0,'oembed_cache','',0),(3733,8,'2021-01-14 16:00:00','2021-01-14 23:00:00','<!-- wp:heading -->\n<h2>Goals: update WordPress core, PHP version, and plugins</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We wanted to upgrade our WordPress site, <a href=\"https://www.ddev.com\" data-type=\"post\">ddev.com</a>, to the latest version of PHP as well as updating WordPress Core and some plugins. We are hosting ddev.com on our own DDEV-Live hosting platform and we used both the ddev-live CLI and DDEV-Local to perform these updates. In this scenario, we were primarily updating the backend and server configuration, so it didn\'t make sense to use <a href=\"https://www.ddev.com/ddev-live/#ddev-preview\">DDEV Preview</a> for this task. For work that includes a lot of frontend changes and visual review, <a href=\"https://www.ddev.com/ddev-live/what-is-ddev-preview/\">Preview is super helpful</a> so you may want to employ it if your updates fit that bill.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Takeaways and wins for this WordPress upgrade workflow</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Easing the pain of the WordPress uploads folder</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Moving the entire uploads folder from WordPress is notoriously painful and DDEV makes it very simple. It was also very easy to optimize all of the images in the uploads folder and move them seamlessly into production using the <code>push files</code> command in DDEV-Live.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Eliminating the complexity of PHP upgrades</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Upgrading PHP versions can be tricky, but DDEV offers commands for <a href=\"https://www.ddev.com/ddev-live/how-to-upgrade-wordpress-with-ddev-from-local-development-to-production/#create-site\">deploying a new site</a> with the desired PHP version specified and leveraging the hostname functionality in DDEV-Live. We had minimal downtime.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Removing the risk of WP plugin upgrades</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>DDEV also streamlines the plugin upgrade process using the local environment. We were able to check compatibility on a staging site to verify that everything was running as expected before simply pointing at the new site.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Procedure from local development to deployment</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>This tutorial assumes that you have a site existing on DDEV-Live for the deployment steps. If you don\'t, try the walkthrough on <a href=\"https://dash.ddev.com/get-started\">dash.ddev.com/get-started</a> after you create an account, or read more on <a href=\"https://www.ddev.com/ddev-live/how-to-deploy-a-site-with-ddev/\">how to deploy to DDEV-Live</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Spin up a version of the remote site in DDEV-Local</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>First, pull the code for your production site locally. In our case, this means a <code>git pull</code> of the currently deployed branch from the repository on GitHub because our project is already configured with Git and DDEV-Local. If you\'re doing this for the first time, you\'ll want to <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#getting-started\">read more</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Pull down and import the production database export using DDEV-Live</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>First we create a <a href=\"https://docs.ddev.com/databases/#database-backups\">database backup</a> using the <a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">ddev-live CLI tool</a>, referring to the site by our DDEV-Live &lt;org-name&gt;/&lt;site-name&gt;. Then we pull that backup locally and import to DDEV-Local.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><code>ddev-live backup database ddev-live-org-name/live-slug</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">Initiated database backup: ddev-live-org-name/live-slug-9wzbl\nFor backup status, run:\n  ddev-live describe backup database ddev-live-org-name/live-slug-9wzbl\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p><code>ddev-live pull database ddev-live-org-name/live-slug-9wzbl</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">Downloaded: live-slug-9wzbl.sql.gz\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\"># From the local project directory\n## Using DDEV\nddev import-db local-site-slug --src=live-slug-9wzbl.sql.gz\n## Using WP CLI\nddev exec `wp import db live-slug-9wzbl.sql.gz`\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Pull down and import the production WordPress uploads folder using DDEV-Live</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Same principle as the database: create a <a href=\"https://docs.ddev.com/files/#file-backups\">backup of the files</a>, then pull the backup down into the local files destination.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">ddev-live backup files ddev-live-org-name/live-slug\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">Initiated files backup: ddev-live-org-name/live-slug-hZYt3\nFor backup status, run:\n  ddev-live describe backup files ddev-live-org-name/live-slug-hZYt3\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p><code>ddev-live pull files ddev-live-org-name/live-slug-hZYt3 --dest=docroot</code><br>(This took about an hour for our site)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>You can also use <code>ddev pull</code> if you\'d like to <a href=\"https://ddev.readthedocs.io/en/stable/users/providers/DDEV-Live/\">automate bringing the project local</a>, but we wanted to do things in a more step by step way on this particular upgrade. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Update WordPress to latest version</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>First, <a href=\"https://ddev.readthedocs.io/en/stable/users/extend/customization-extendibility/#changing-php-version\">configure your DDEV-Local project settings</a> with the PHP version you will be using in production. In our case, PHP 7.4. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Then update WordPress:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">## Using WP-CLI\nddev exec \"wp core update\"\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Update plugins to latest version.</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We recommend updating plugins one at a time. If your local site is still in good shape after you update a plugin, move on to the next one.<br>You can update your plugins the old fashioned way with WP-CLI, or simply use Composer if you\'re using <a href=\"https://wpackagist.org/\">WPackagist</a>:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">## Using WP-CLI\nddev exec \"wp plugin update &lt;plugin-slug&gt;\"\n## Using Composer and WPackagist\ncomposer update wpackagist-plugin/&lt;your-plugin-slug&gt;\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p><strong>Pro-tip:</strong> Make a Git commit after each plugin update to make your pull requests more manageable and easier to code review. It also makes it easier to roll back and understand what went wrong, if needed.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">## Using Composer\ngit add composer.json\ngit commit -m \"Updated Advanced Custom Fields 5.8.7 =&gt; 5.9.1\"\n## Old-fashioned WP-CLI way\ngit add wp-content/plugins/advanced-custom-fields\ngit commit -m \"Updated Advanced Custom Fields 5.8.7 =&gt; 5.9.1\"\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Change branch from <code>master</code> to <code>main</code></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We saw this as a great time to <a href=\"https://github.com/github/renaming\">make the switch</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Push our new updated code to GitHub on the new <code>main</code> branch</h3>\n<!-- /wp:heading -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">git push origin main\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 id=\"create-site\">Create a new DDEV-Live site using the GitHub repo\'s <code>main</code> branch, and use PHP 7.4 on new site</h3>\n<!-- /wp:heading -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">ddev-live create site wordpress new-site-php74 \\\n--git-repo=https://github.com/&lt;your-account&gt;/&lt;your-repo&gt; \\\n--git-rev=main \\\n--docroot=docroot \\\n--php-version=7.4 \\\n--persistent-paths content/uploads \\\n--ephemeral-paths=content/cache \\\n--org=ddev-live-org-name \\\n--wordpress-version=5.6\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Push the production database export using DDEV-Live to the new site</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><code>ddev-live push database ddev-org-name/new-site-php74 live-slug-9wzbl.sql.gz</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Push the production uploads folder export using DDEV-Live to the new site</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><code>ddev-live push files ddev-org-name/new-site-php74 docroot/content/uploads content/uploads</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Pro-tip:</strong> We <a href=\"https://imageoptim.com/mac\">losslessly optimized</a> every image in our uploads folder before pushing them up to help with page load times. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Remove the hostnames from the old site using DDEV-Live and add them to the new site.</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>You should remove the hostnames from the old site and apply to the new site as quickly as possible to avoid downtime.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">ddev-live config hostname remove ddev-external-sites/live-site ddev.com\nddev-live config hostname remove ddev-external-sites/live-site www.ddev.com\nddev-live config hostname add ddev-external-sites/new-site-php74 ddev.com\nddev-live config hostname add ddev-external-sites/new-site-php74 www.ddev.com\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>That\'s it! As you can see, the site is up and running successfully with <a href=\"https://wordpress.org/news/2020/12/simone/\">WordPress 5.6, \"Simone\"</a>, which includes the latest security releases, on top of PHP 7.4. By using DDEV to make the upgrades locally and configure the production environment we were able to update and launch the site and move assets quickly and painlessly. This resulted in a more secure and more usable site for editors as well as visitors.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Let us know how this goes for you, feel free to drop a tweet <a href=\"https://twitter.com/ddevHQ\">@ddevHQ</a> or use our <a href=\"https://www.ddev.com/contact/\">contact form</a> for additional feedback. Thanks for stopping by.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2410} /-->\n\n<!-- wp:ugb/divider {\"uniqueClass\":\"ugb-4eec569\"} -->\n<div class=\"wp-block-ugb-divider ugb-divider ugb-4eec569 ugb-divider--v2 ugb-divider--design-basic ugb-main-block\"><style>.ugb-4eec569 hr.ugb-divider__hr{margin-left:auto !important;margin-right:auto !important}</style><div class=\"ugb-inner-block\"><div class=\"ugb-block-content\"><hr class=\"ugb-divider__hr\"/></div></div></div>\n<!-- /wp:ugb/divider -->','How to upgrade WordPress with DDEV: from local development to production','','publish','closed','closed','','how-to-upgrade-wordpress-with-ddev-from-local-development-to-production','','','2021-01-14 17:03:37','2021-01-15 00:03:37','',0,'https://www.ddev.com/?p=3733',0,'post','',0),(3761,21,'2021-01-11 12:21:00','2021-01-11 19:21:00','<!-- wp:heading {\"level\":3} -->\n<h3>Installation/Upgrade:</h3>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>If you’re new to&nbsp;<a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live</a>, please follow the&nbsp;<a href=\"https://docs.ddev.com/getting-started/\">Getting Started Guide</a>.</li><li>For existing users, be sure you have the latest version of the&nbsp;<a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">ddev-live cli via brew or download</a>.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading -->\n<h2>Key changes in this version</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The update to the DDEV-Live CLI on 11 January 2021 introduces custom cron commands for <a href=\"https://docs.ddev.com/drupal-guide/\">Drupal sites</a> on <a href=\"https://www.ddev.com/ddev-live\" data-type=\"post\">DDEV-Live</a>. It also builds further on the features of <a href=\"https://www.ddev.com/ddev-live/#ddev-preview\">DDEV Preview</a> and site clones with the command <code>delete clone</code>.  Thank you very much to our users who shared their specific cron needs with us so we could make the platform more useful for everyone.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We\'re just getting rolling with 2021, but have <a href=\"https://www.ddev.com/news/ddev-in-2021/\">big plans for the DDEV platform</a> in the year ahead. Stay tuned... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Drupal Custom Cron</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Users with <code>drupal</code> sites are now able to configure (add, view, &amp; remove) <code>custom cron commands</code> for their sites.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph -->\n<p>To add custom cron commands, use the <code>--cron-custom-command-add</code> &amp; <code>--cron-schedule</code> flags.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Add a custom cron command on a new site:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">// on a new site: create new cron with custom command \"drush version\" running every 5 minutes\n$ ddev-live create site drupal mysite \\\n--cron-custom-command-add \"drush version\" \\\n--cron-schedule \"*/5 * * * *\"\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:paragraph -->\n<p>Add a custom cron command to an existing site:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">// on an existing site: create new cron with custom command \"drush version\" running every 5 minutes\n$ ddev-live config drupal mysite \\\n--cron-custom-command-add \"drush version\" \\\n--cron-schedule \"*/5 * * * *\"\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph -->\n<p>View custom cron commands for a <code>drupal</code> site:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">// see custom crons, excerpt from the entire describe command with relevant information only\n$ ddev-live describe site mysite\nSITE INFO\n...\n Preview URL:   http://preview-mysite-myorg.sites.ddev.live\n Cron Status:   enabled\n Cron Schedule:\n Custom Cron Commands:\n  1. \"*/5 * * * *\" echo \'my new cron\'\n  2. \"*/5 * * * *\" drush version\n...\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph -->\n<p>To remove/delete custom cron commands use the <code>--cron-custom-command-delete</code> flag, along with the number of the command to remove.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">// delete custom cron executing \"drush version\"\n// This custom cron command is #2 in the above `ddev-live describe site mysite`\n\n$ ddev-live config drupal mysite \\\n--cron-custom-command-delete 2\n</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Delete Clone</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Users are now able to delete a preview site via <code>ddev-live delete clone site</code> against a broken or running clone in their workspace. This was introduced due to an edge case where a user would not be able to delete a broken/failed preview-site. <code>ddev-live delete clone site</code> is intended to fix this. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Once a preview-site has been successfully built and is live it will be viewable in a user\'s list of sites via <code>ddev-live list sites</code>. At that point the preview-site can then be deleted using <code>ddev-live delete site</code>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Caveats</h4>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>None</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Assets</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">DDEV-Live CLI v0.9.1</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://docs.ddev.com/\">DDEV-Live documentation</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Status page</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Subscribe on&nbsp;<a href=\"https://status.ddev.com/\">status.ddev.com</a>&nbsp;for platform updates.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:block {\"ref\":2410} /-->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Release notes: DDEV-Live CLI 0.9.1','','publish','closed','closed','','release-notes-ddev-live-cli-0-9-1','','','2021-02-02 09:47:12','2021-02-02 16:47:12','',0,'https://www.ddev.com/?p=3761',0,'post','',0),(3821,16,'2021-01-18 11:16:07','2021-01-18 18:16:07','<iframe title=\"TYPO3 CMS local development environment BETA-TEST!\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/Xz8tE2Vzngo?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>','','','publish','closed','closed','','59e00b0b307ba1a9465a83925ec6ebb4','','','2021-01-18 11:16:07','2021-01-18 18:16:07','',0,'https://www.ddev.com/uncategorized/59e00b0b307ba1a9465a83925ec6ebb4/',0,'oembed_cache','',0),(3824,16,'2021-01-19 10:22:23','2021-01-19 17:22:23','<strong>February 18-20, 2021</strong>\r\n\r\nWe are proud sponsors of <a href=\"https://www.fldrupal.camp/\">Florida Drupal Camp</a>! This is one of our favorites for a variety of reasons, especially because of the close, funky local community. While there will be no in-person alligator handling this year, we nonetheless look forward to learning and connecting with folks virtually.\r\n\r\n<strong><a href=\"https://www.fldrupal.camp/sessions/devops/panel-devops-people-processes-technologies-and%E2%80%A6\">Panel: DevOps - People, processes, technologies, and....</a></strong>\r\n<ul>\r\n 	<li>Thursday 18 February, 9:15 AM - 10:00 AM during the DevOps summit day</li>\r\n 	<li>Community and marketing manager <a href=\"https://www.ddev.com/author/elli/\">Elli Ludwigson</a> joins Tess Flynn to answer questions such as \"What is DevOps? What are the business impacts of getting DevOps right or wrong? What are the challenges in implementing DevOps? What are some key things to focus on?\"</li>\r\n</ul>\r\n<a href=\"https://www.fldrupal.camp/sessions/development-performance/demystifying-deployment-workflows\"><strong>Session: Demystifying deployment workflows</strong></a>\r\n<ul>\r\n 	<li>Friday 19 February, 1:00pm to 1:45pm</li>\r\n 	<li>Director of Customer Success <a href=\"https://www.ddev.com/author/dstoline\">David Stoline</a> will be presenting an end-to-end example of how you might work with a Drupal project from local development to deployment- anywhere! So often workflows are tied to an agency or a vendor, here\'s a chance to piece together what needs to happen so you can make informed decisions about the tools you use.</li>\r\n</ul>\r\n<strong>Contribution time!</strong>\r\n<ul>\r\n 	<li>Join on Saturday afternoon for a first time contributors\' workshop to learn the basics of navigating contributions to the Drupal open source project. There are ways to contribute no matter your skill set, and Drupal especially needs contributions from project managers, marketers, designers, translators, and of course developers can help too. <a href=\"https://www.fldrupal.camp/conference/contribution-day\">Check it out </a>and <a href=\"https://www.fldrupal.camp/schedule/sat\">view the full Saturday schedule here</a>!</li>\r\n</ul>\r\nTickets are $20, <a href=\"https://www.eventbrite.com/e/florida-drupalcamp-2021-tickets-135880928515\">register here</a>.','Florida Drupal Camp 2021','','publish','closed','closed','','florida-drupal-camp-2021','','','2021-02-11 12:37:56','2021-02-11 19:37:56','',0,'https://www.ddev.com/?post_type=event&#038;p=3824',0,'event','',0),(3828,16,'2021-01-21 14:00:00','2021-01-21 21:00:00','<!-- wp:paragraph -->\n<p><em>Photo of Mauricio Dinarte at DrupalCon Seattle contribution day in 2019 <a href=\"https://flic.kr/p/24UgYn2\">by Josef Kruckenberg @dasjo</a> </em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>9 minute read</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>It’s always a joy when the planets align and connections are made! After the virtual <a href=\"https://events.drupal.org/europe2020\">DrupalCon Europe</a> in December a few folks caught up on social Zoom, where I learned that a couple of my longtime friends in the Drupal community are using <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a> to teach web development to newcomers.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Mauricio Dinarte was one of my first mentors when I started learning Drupal in 2013, so it was an honor to interview him for this blog. <a href=\"https://www.drupal.org/u/dinarcon\">Mauricio</a>, aka <a href=\"https://twitter.com/dinarcon\">dinarcon</a>, has been doing Drupal for a decade now and teaching Drupal for half that time locally in Nicaragua as well as at Drupal Camps and Cons worldwide. This is the first blog in a set, please read more about <a href=\"https://www.ddev.com/ddev-local/why-standardization-is-important-to-teaching-web-development/\">teaching Drupal in Iceland from Hilmar Hallbjörnsson</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>What do you teach attendees about Drupal and React and what are some of the challenges in getting them started?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>I teach <a href=\"https://agaric.coop/training/getting-started-drupal-9\">Drupal site building</a>, <a href=\"https://agaric.coop/training/drupal-content-migrations\">Drupal migrations</a>, <a href=\"https://agaric.coop/training/upgrading-drupal-using-migrate-api\">Drupal upgrades</a>, and <a href=\"https://agaric.coop/training/getting-started-reactjs\">ReactJS basics</a>. I present sessions at events, which are a lecture style, and workshops going over specific examples and hands-on exercises. That has been quite different when they used to be in person versus now that they are online. Before, you were able to see someone had an issue, sit next to them and try to work together out of the problem. But now it\'s mostly online and depending on the size of the class, it’s not possible to let the attendees screen share. So that is a challenge.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Sometimes the setup is as simple as sending over links to repositories and lessons. Sometimes it’s using the <a href=\"https://www.drupal.org/docs/installing-drupal/drupal-quick-start-command\">quick start command in Drupal</a> or something like <a href=\"https://www.drupalvm.com/\">DrupalVM</a> or <a href=\"https://github.com/ddev/ddev#ddev\">DDEV</a> for more advanced classes. In all scenarios, no matter what the topic is, I strive for keeping it very, very simple in terms of the <a href=\"https://github.com/dinarcon/drupal_migrations_basic/blob/main/DEVELOPMENT.md\">local development environment</a>. It is not always possible, but that\'s something that I really look for: some way in which there is the least amount of effort from getting started to having a functional site and, depending on the course, writing the first line of code.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>How are you supporting students and adjusting to fit a more virtual, online format?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>About two weeks ago, I gave a presentation on <a href=\"https://www.drupal.org/docs/8/core/modules/layout-builder\">layout builder</a> to a small group. We were using <a href=\"https://www.mamp.info/\">MAMP</a> and <a href=\"https://pantheon.io/trainers\">Pantheon environments</a> to deploy, because it was not about explaining everything but just the essence of the tool. With some set up in advance I was able to start the training, so that was right for this instance. But in general, with online trainings, there have been a lot of challenges. Funny enough, most of the challenges go back to what I was describing - the local development environment.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For example, along with my colleagues at <a href=\"https://agaric.coop\">Agaric</a>, in 2020 we presented three or four different <a href=\"https://agaric.coop/training\">online workshops</a>. We would spend hours, and hours, and hours giving people support ahead of the training to get their local environments ready. We have seen so many different setups, every computer is different. It can get complicated. That is why we offer office hours before the trainings to help people get ready. We also offer training recordings so everyone can practice later. Again, the key is having a simple set up with a local environment to begin with.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>That goal of having quick wins when getting started coding sounds similar to our work with <a href=\"https://www.drupal.org/community/mentoring\">Drupal contribution mentoring</a>!&nbsp;</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Yeah, requiring the least amount of effort to get started is ideal — because in the context of mentoring, people want to contribute to Drupal as an open source project, and in the context of a training they want to learn a new skill. They don\'t necessarily want to learn Docker, Composer, LAMP stacks, or virtual machines to be able to contribute. That\'s why, depending on the topic and issue I choose the development tools that meet the minimum requirements to get them started.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>How do you determine which development tools are best for Drupal migrations or getting started or… ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>These have changed over the years. When I started presenting the Drupal workshop back in the day as part of the <a href=\"https://groups.drupal.org/global-training-days\">global training days program</a>, I used <a href=\"https://simplytest.me/\">simplytest.me</a>, an online tool for installing Drupal. Back then the install would only be available for two or three hours. I remember talking with <a href=\"https://www.drupal.org/u/patrickd\">Patrick Drotleff</a>, the creator of the tool, when he was extending the lifespan of temporary sites to about 24 hours. This allowed us to give a full day training using simplytest.me alone.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Before that, we would spend two of the three hours just trying to get an *AMP stack on each person\'s computer. It was inefficient and frustrating. That’s the friction that we wanted to avoid - people want to learn something new and then they discover that they need to learn twenty other things to be able to start being productive.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Later, I started using Pantheon for the Drupal site building courses, because they have the free tier with no time limits. Pantheon also has a program called <a href=\"https://pantheon.io/trainers\">Pantheon for Educators</a> where trainers like me can create environments on behalf of their students in advance. On the day of the training, we jump directly into the content, we don\'t need to worry about “Do you have LAMP stack on your computer?”</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For Drupal Migrations it\'s a little bit different because we know we need more setup than just an out-of-the-box Drupal install on Pantheon. Some modules need to be installed via composer. Depending on how the Pantheon site is set up, this might require configuring SSH keys . To keep things simple, I default to the Drupal quick start command. That uses the built-in PHP Web Server, SQL lite, and PHP itself. With that you can <a href=\"https://github.com/dinarcon/drupal_migrations_basic/blob/main/DEVELOPMENT.md\">get a Drupal install in five to 10 minutes</a>. That does require a little bit of technical knowledge and having PHP and Composer installed on your computer.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>As a part of <a href=\"https://understanddrupal.com/\">UnderstandDrupal.com</a> I recently released a <a href=\"https://understanddrupal.com/migrations\">Drupal Migration training</a>. In the lecture on debugging migrations I use DDEV because it\'s very simple to <a href=\"https://www.ddev.com/ddev-local/ddev-local-phpstorm-and-xdebug-debugging/\">install DDEV and to configure Xdebug</a>, so that was kind of the selling point. It was literally just issuing a command, setting a breakpoint, and allowing the IDE to listen for connections. And that was it.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Before DDEV I was using DrupalVM for many years. It works great if you have VirtualBox, Vagrant, and Ansible installed in your machine. But getting them properly configured in the first place can be challenging in some environments. So, you need to make a decision: to install VirtualBox or Docker. Attendees might come to a training with <a href=\"https://ddev.readthedocs.io/en/stable/#system-requirements\">Windows, Linux, Mac</a>. Sometimes they do not have admin privileges on that machine. I have fought many of those battles. And I don\'t consider myself a sysadmin! So the simpler the tool, the better for me. That\'s basically why I chose DDEV.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Tell me a little more about your experience using DDEV for local development? What was especially useful or lacking?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Definitely useful how easy it is to configure Xdebug. Coming from DrupalVM I was really looking forward to how to debug, which works out of the box. But the highlight of DDEV is <a href=\"https://www.ddev.com/author/rfay/\">Randy Fay</a>! I post a question in the <a href=\"https://ddev.readthedocs.io/en/stable/#support-and-user-contributed-documentation\">#ddev Slack channel</a> and he answers within minutes! Sometimes I just lurk in the channel to learn from others. Randy is so good at offering support, not only on a technical level. He also takes the time to explain how things work. That is a big asset for DDEV, you know, having someone who is able to offer support in a timely, kind, and humane way.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The only thing, which isn’t specific to DDEV, is that in order to get the local environment working you need Docker installed. That might be a challenge in itself. For example, two days ago, I was working with a client who was having problems with the DDEV install. And the reason was because they had just updated Docker desktop and that broke things. Of course the <a href=\"https://ddev.readthedocs.io/en/stable/#system-requirements\">system requirements</a> are in the docs, but sometimes people update their tools as soon as new releases are available without checking compatibility.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>What are the needs and goals of the students who sign up for Drupal web development trainings? Who are they?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Recently in my local community we noticed when we promoted the training as “Get started with Drupal” people didn’t know what Drupal was. So we switched the name to “How to build a website in a day” and got much more interest. We’re often teaching small business owners how to build a simple website for their business. While covering ecommerce integration is not feasible, we teach them how to build a product catalog in a day.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We have also given many sessions and trainings to university students majoring in computer science and design. The course is always tailored to the audience. So we talk about theming, reusable components, and modules to highlight Drupal’s flexibility and provide foundational knowledge. Sometimes we have attendees in leadership roles, or project managers, who come to a training to understand the bigger picture. They want a sense of the tools, what is possible, what is recommended so they can be a bridge between developers and stakeholders.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For the Drupal migrations trainings, that audience is varied. Sometimes they’re the one technical person in the organization who has been tasked with doing the update. The introductory course is friendly to just about anyone since it only requires understanding of site building concepts like nodes and users. Intermediate and advanced migration courses require some programming knowledge, but provide detailed instructions and examples as necessary. They may also obtain Drupal upgrade training which does require more PHP knowledge and a more complex local environment setup. Getting the two versions of Drupal talking to each other is when people start to lean on our support and office hours. Sometimes attendees just need to solve a specific problem, and that is again when we need to get them started with as little friction as possible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Some audiences benefit more significantly from migration trainings. For example, universities or governments who have hundreds of sites: They learn once and apply the knowledge multiple times.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>What are your teaching goals for 2021?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>I want to expand <a href=\"https://understanddrupal.com/\">UnderstandDrupal.com</a> to a teaching platform with more resources in text and video format. Different people learn in different ways to it makes sense to offer both options. Additionally, a goald I really hope I can accomplish in 2021 is to translate the material to other languages. One of the primary goals of UnderstandDrupal.com is to make the content accessible to as many people as possible. As someone who is not a native English speaker, I know the language barrier can be very high. I started translating to Spanish and French myself. I couldn’t keep up with that, but I will try again this year.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>I love what you said about the scaling and cascading effect of an impactful training for the right attendees. Why did you get into teaching?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Going back to study groups in school, I liked that experience of learning together. It made us more efficient, made the process accountable. Now, in my day-to-day professional experience, teaching has made me a better developer, and has allowed me to learn a lot more about the subjects I teach. If I weren’t a developer, I would probably be a teacher.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>For example, in 2019, I wrote a <a href=\"https://understanddrupal.com/31-days-of-migrations\">series of articles about Drupal migrations</a> for UnderstandDrupal.com which I&nbsp; consider the pinnacle of my Drupal contributions to date. It was 31 days straight trying to write a technical article every day. It seemed so reasonable at the beginning, but I was proven wrong early on. It could take up to eight hours to write an article. One of them took me 20 hours because I had to do a lot of&nbsp; research, debugging, and testing. So producing the series exaggerated all the benefits and all the difficulties in teaching and producing content.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I learned so much. Before I started writing that series, I had been doing migrations maybe for three years. I thought I knew enough to be brave and make that public commitment. By writing articles I think that my knowledge doubled or tripled in just that month, because I was so heads down into the topic., I would spend hours in the debugger stepping through the migrate API code, understanding, or trying to understand, how it worked.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I teach because I enjoy it, I like sharing my knowledge. When I started my journey, I didn\'t know of the Drupal community. For me, Drupal was a tool that allowed me to build a website without knowing a lot of HTML or CSS. It was probably six months later that I encountered my local community at a meetup. In five minutes, someone would answer what had taken me weeks, or months to investigate. So that’s why I teach, to be able to help others, save them time, and hopefully save them frustration.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Where to find Mauricio</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>The <a href=\"https://www.drupalnicaragua.org/\">Drupal Nicaragua community</a> can be found in many places, including <a href=\"https://groups.drupal.org/nicaragua\">groups.drupal.org</a>, <a href=\"https://www.facebook.com/pg/drupalni\">Facebook</a> and <a href=\"https://twitter.com/drupalni\">Twitter</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://understanddrupal.com/\">UnderstandDrupal.com</a> is Mauricio’s own site and project with pre-recorded courses on<a href=\"https://understanddrupal.com/migrations\"> Drupal Migrations</a> and <a href=\"https://understanddrupal.com/reactjs\">ReactJS</a>. Much of the material is free and <a href=\"https://github.com/dinarcon/\">open source</a>. When you sign up for <a href=\"https://agaric.coop/training\">a virtual training</a> you get the additional benefit of live explanations, lectures, and hands-on help with set up and questions. Please support Mauricio via one of the sponsorship links on the <a href=\"https://understanddrupal.com\">site</a>!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:ugb/button {\"borderRadius\":29,\"button1BackgroundColor\":\"#fcb900\",\"button1PaddingTop\":20,\"button1PaddingBottom\":20,\"button1BorderRadius\":100,\"uniqueClass\":\"ugb-2d796c2\"} -->\n<div class=\"wp-block-ugb-button ugb-button-wrapper ugb-2d796c2 ugb-main-block\"><style>.ugb-2d796c2 .ugb-block-content .ugb-button{border-radius:29px}.ugb-2d796c2 .ugb-button1{background-color:#fcb900;padding-top:20px;padding-bottom:20px;border-radius:100px !important}.ugb-2d796c2 .ugb-button1 .ugb-button--inner,.ugb-2d796c2 .ugb-button1 svg:not(.ugb-custom-icon){color:#222222 !important}.ugb-2d796c2 .ugb-button1:before{border-radius:100px !important}</style><div class=\"ugb-inner-block\"><div class=\"ugb-block-content\"><div class=\"ugb-button-container\"><a class=\"ugb-button1 ugb-button ugb-button--size-normal\" href=\"https://www.ddev.com/get-started/\" rel=\"\" title=\"\"><span class=\"ugb-button--inner\">Get started with Drupal and DDEV</span></a></div></div></div></div>\n<!-- /wp:ugb/button -->','Why an easy start is important to teaching web development','','publish','closed','closed','','why-an-easy-start-is-important-to-teaching-web-development','','','2021-01-28 13:06:03','2021-01-28 20:06:03','',0,'https://www.ddev.com/?p=3828',0,'post','',0),(3861,16,'2021-01-28 13:05:28','2021-01-28 20:05:28','<!-- wp:paragraph -->\n<p><em>Photo of Hilmar Hallbjörnsson at DrupalCon Amsterdam trivia night 2019 by <a href=\"https://flic.kr/p/2hD9UK1\">Illek Petr</a></em>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>10 minute read</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>How often do you get to chat with a viking about web development? After <a href=\"https://events.drupal.org/europe2020\">DrupalCon Europe</a> last December a few folks got together on Zoom to emulate our usual “hallway track” coffee hour chats, and I learned that a couple friends have been leveraging <a href=\"https://www.ddev.com/ddev-local/\">DDEV-Local</a> to teach web development to newcomers. This is the second blog in the series, please read more about <a href=\"https://www.ddev.com/ddev-local/why-an-easy-start-is-important-to-teaching-web-development/\">Mauricio Dinarte giving students a quick path to success here</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Hilmar Hallbjörnsson has been a friendly face at Drupal events around the world for so many years we’re not sure where or when exactly we first met. Drupal GovCon? Drupal Europe? In a community fond of headwear, <a href=\"https://www.drupal.org/u/drupalviking\">Hilmar</a>, aka <a href=\"https://twitter.com/drupalviking\">drupalviking</a>, stands out in various horned helmets at events. He is currently living and teaching in Iceland and recently taught a web development course at <a href=\"https://en.ru.is/\">Reykjavík University</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>How long have you been working with Drupal? </h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>I\'ve been a Drupal developer for nine years now, starting back in 2011. Before that I had written three or four CMSs on my own. After I got to know Drupal, I started crying because I realized that I would never-ever-ever have to write authentication methods again. So it was love at first sight, definitely. In the nine years since it’s just kept growing and maturing in many ways.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Actually, admitting being a PHP developer in Iceland is difficult,&nbsp; it would be easier to admit that you belong to a goat sacrificing cult! People talk about how PHP was back in the day when we were running PHP 4.7 but all my servers are now on PHP 7.4, so things have changed just a bit.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>What topics do you teach new web development students?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>I teach a course called \"Developing open sourced web software\" at Reykjavík University. Because of COVID, they called me in the middle of October, and asked me if I could deliver a course in the last week of November. My colleague, Reynir, and I looked at each other and said “Þetta reddast,” which is a common saying in Iceland: “We will figure it out somehow.” And we did! After this year, we might try to set that up so I could teach it in multiple schools as an online course.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The course begins with exploring: what is open software? What are the types of open software? What are the licenses? What does “free” and open source really mean? Then we got into how&nbsp; web software is delivered, with mostly open source AMP (Apache, MySQL, PHP) stacks. Then we kept on going with how to contribute to open software.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We started with Drupal, had two projects, essays, a verbal exam, and students had to keep a diary to log what they did. Part of that was to train them to write good commit messages later and be able to verbalize what they were doing and why. They got to know Drupal as a site builder, creating a simple music or board game collection on the site, using views, user permissions, image styles and so on. We had to scale down the second project in the course from bug hunting to writing a little API that could look up a song or a board game, and then add it to a collection via services. That was a sufficient challenge for a three week course.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>What tools, software, guides do you offer web development students?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>For local development, I used <a href=\"https://github.com/ddev/ddev\">DDEV</a> exclusively. Connecting and setting up everything with DDEV — that was the second time I literally cried. I used to have problems down the ying-yang; I had written five or six huge blog posts just for my own reference on setting up my work computer, to get Apache running, MySQL running, trying to configure SSL (which never worked right), trying to get the debugger running. It was a headache and a half. Then maybe a year or two years later, when I had to do it all again, everything was outdated.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Almost the whole time that I\'ve been working I\'ve been a one man team. When you are in a bigger company you would have the DevOps expert who understands everything about Docker, and everything about what\'s happening under the hood. I was always trying to understand what exactly Docker was doing at the same time as I needed to be building the site, managing clients, and umpteen other task.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Then I got DDEV, and being able to say `brew install ddev`, then just the `ddev config`, enter, enter, enter, then `ddev start`. My site is up and running! Oh, I need more memory for Maria DB? Okay, no problem, tikatikatak, `ddev restart`, up and running. So being able to both use it professionally and to start students on a project was great.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I did record a few lectures because we had a very short timeframe of three weeks so there wasn’t time to send them off to research on their own as much. I also refer students to Drupalize.me as supplementary material to the lectures.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>But, again, having a tool like DDEV helped me out a lot. DDEV have done the hard work, you are the experts in Docker. I was able to explain how open source software works in general, then point them to DDEV and have them follow the <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#quickstart-guides\">documentation to install Drupal</a>. It’s important to understand what\'s under the hood, but just as with a car, you know there is an engine in the front, and you know the shape of it. But probably you, like me, open the hood, and say nope! let\'s call a mechanic.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>What are some pros and cons to using DDEV for local web development?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>As a convert from Windows, I’ve been very happy with how quick and easy getting started with a local development environment on a Mac is. All my students that had Mac were up and running within 30 minutes. But we hit some snafus with Windows. Some of them were because they had some other web servers or <a href=\"https://ddev.readthedocs.io/en/stable/users/troubleshooting/#webserver-ports-are-already-occupied-by-another-webserver\">port problems</a>. Any previously configured machine from a student who installed a lot of programs for some of their courses was a headache, but we were able to get everybody up and running. My colleague Reynir runs Windows himself, so he took care of all the Windows people. On his personal machine it was smooth once we figured out that <a href=\"https://www.ddev.com/ddev-local/ddev-wsl2-getting-started/\">WSL</a> was the way to go.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>There is a little bit of DDEV documentation that could improve. I was trying to use Drupal Console but I couldn’t find how to initiate the Drupal Console with the command line as you would with Drush, eg `ddev drush`. <em>ed note: There’s now an </em><a href=\"https://stackoverflow.com/questions/65400086/drupal-console-with-ddev\"><em>answer for this on StackOverflow</em></a><em>, and </em><a href=\"https://ddev.readthedocs.io/en/stable/users/extend/custom-commands/\"><em>any custom command can be added to DDEV</em></a><em>.</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I also noticed if I was trying to debug with drush commands, <a href=\"https://www.ddev.com/ddev-local/ddev-local-phpstorm-and-xdebug-debugging/\">xdebug, and phpstorm</a>, I had to <a href=\"https://ddev.readthedocs.io/en/stable/users/cli-usage/#ssh-into-containers\">ssh into the web container</a> and then run the commands, going into the vendor directory. It was just an unfamiliar sequence of things I had to do in order to get to the right place and run the right commands.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>In general, the documentation is good, but it’s very technical. It would be nice to have more visual guides rather than just text. I experience that a lot in my hobby, board games, reading and editing a lot of rule books, so I know that a user often wants a more visual explanation. It’s easy to skip over a line of text and miss something very essential. For a lot of people who are a bit less used to technical documentation it can be a hurdle to get started.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.ddev.com/ddev-live/\">DDEV-Live hosting</a> would also benefit from a really clear guide: this is what you do to get up and running, and you’re done. <em>ed note: Once you sign up for an account on DDEV-Live there’s now a visual stepper to </em><a href=\"https://dash.ddev.com/get-started\"><em>get started</em></a><em>. More soon! please give it a try and let us know what you think.</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"align\":\"center\",\"id\":3867,\"width\":420,\"height\":548,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-rounded\"} -->\n<div class=\"wp-block-image is-style-rounded\"><figure class=\"aligncenter size-large is-resized\"><img src=\"https://www.ddev.com/content/uploads/2021/01/Hilmar-by-Michael-Cannon.jpg\" alt=\"Hilmar in a wig with two large braids and a helmet with goat-like horns.\" class=\"wp-image-3867\" width=\"420\" height=\"548\"/><figcaption>@drupalviking photo by Michael Cannon</figcaption></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Have you worked with other open source CMSs much?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>I actually wrote my first WordPress plugin two weeks ago, because I had to create a API endpoint and fetch some data. After that experience, I am more confident that I made the right decision back in 2011 with Drupal! I tried Joomla and Magento back in the day but they’ve changed so much since then.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I’ve also done some custom CMSs with very strange customer requests. Probably the most fun that I’ve had was to make a website where you rented sheep. You would rent a sheep for a year, it lived on the farm, and you got the lamb in spring, then the mutton, wool and whatever in the fall. You could go visit “your” sheep of course, and there was a social aspect on the site with photos and such. But a disconnect with the salesperson resulted in overpromising and under delivering and it didn’t work out. It actually would be very, very exciting to try to implement that again, and use Drupal to do that. It was that kind of project that is so absurd that you really want to see it through.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>How did you become interested in teaching web development?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Before I graduated back in 2012, I was a teacher\'s assistant. For my last year, I was the TA for people not living close to Reykjavík who had online meetings instead of in person, so virtual learning is not new to me. My professor was always saying we needed to teach more PHP, all these CMSs are based on it, and that idea just got more focused on Drupal over time.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>At Reykjavík University, we have a special project to culminate our studies where students work on something outside of the school, in the “real world,” instead of writing a thesis. I was working as a project manager for the Music Association of Iceland which had a very old system that needed new software, database migration, everything. I approached Reykjavík University with that project, and we were lucky enough to get a great great team of five people, four of whom were women. So, when the school project was finished we were about 85% ready to actually deploy, and that code has actually been up and running since. Very proud of that. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Then this past fall I pitched a Drupal migration as a project for students and had three students the whole semester doing a Drupal 7 to Drupal 9 transformation of a site. So I was already teaching Drupal when they asked me, can you do this intensive course? Then we just gathered a bit more material and carried on. And now we are proud to say that two of the students are now employees of our company, <a href=\"https://umadgera.is/\">Um að gera</a>. Even prouder that we were able to hire women in both positions.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Everyone learns in different ways for sure. For me, I learn visually, and I learn by example — I am not the greatest investigator. A colleague and best friend of mine works very differently from me, but as a pair we work so great together. He gets bored very, very quickly so he is constantly trying out new things. That\'s not what I like to do. He can go and say, okay, I boiled it down, I checked seven different things this is how you do it. He explains that to me in maybe 30 minutes, 60 minutes, because we know each other’s lingo. Then I implement that, and I take it further. And that just works well together. So, strengthening people’s individual skills and tendencies and helping them find where they fit in a team is also an important part of teaching.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>What do you see in the future for teaching, web development, and open source?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>I think we just have to do more. What I want to see is: can we streamline and standardise how we teach Drupal? As I said, everyone learns differently, but there are so many approaches, methods, materials it’s overwhelming. Drupalize.me is quite a good website, but the structure going from A to B to C is sometimes a little bit convoluted. I struggled a lot when I was doing the transition from how to site build into teaching people how to really program. Then I found this book — called <a href=\"https://www.packtpub.com/product/drupal-9-module-development-third-edition/9781800204621\">Drupal Nine Module Development</a>, by Daniel Sipos, that was very helpful and very up to date.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>At the same time, I was transitioning from functional programming to object oriented programming. Teaching this course also revealed how hard it is to teach object oriented programming. It\'s much easier to explain object oriented programming when you have some concrete things to implement, like when I have my students implement custom entities. Just by explaining how the interfaces connect, and I am implementing this interface, and I am extending a base abstract class... The learning curve is such a steep one. You\'re not only teaching PHP, and Drupal, you\'re also teaching object oriented programming to people who haven’t encountered anything like it before.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>How do you think we could unify efforts and standardize teaching Drupal? Is there an initiative for that already?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>If there is an initiative, I would definitely want to be a part of that. We need to have a unified process so there are various tracks to get into Drupal. Where are your skills? Every skillset is important. When we started giving people <a href=\"https://www.drupal.org/drupalorg/contribution-credit\">contribution credit</a> for documentation and contributing in other ways, not just code, that made our community much, much better. We were almost deteriorating the community by putting coders on a pedestal, and everybody else was not recognized. Having people who are specialists in QA, or who are great with writing or marketing is equally as important as writing the code itself.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We need an initiative to address how we are teaching Drupal to the world so that any person can come in and understand how things work and how they fit in. That’s why I’m very interested in doing this, to create a solid toolbox for teachers, and to share ideas on how to teach and how to build using realistic example projects. Something you can go through from install to completion, from a variety of angles. If you’re a site builder start here, do this. If you’re a designer, download this, follow this guide. We are drowning in work in the Drupal world, we need all the help we can get, so how about we have a great way to teach newcomers?</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Where to find Hilmar</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Hilmar’s company, for which he is backend Drupal dev, DevOps expert, CEO and CTO is <a href=\"https://umadgera.is/\">Um að gera</a>, and his personal blog is <a href=\"https://drupalviking.com/\">DrupalViking.com</a>. Look forward to a blog post about updating that site from Drupal 8 to Drupal 9 this February!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Do you have expertise in teaching web development? Would you be interested in joining an initiative? <a href=\"https://www.drupal.org/community/mentoring\">Drupal Core Mentoring</a> is also working to streamline on-boarding for new contributors, especially at DrupalCon events. Continue the conversation with us this spring at <a href=\"https://www.ddev.com/events/drupalcon-north-america-2021/\">DrupalCon North America</a>! In the meantime:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":3864} /-->','Why standardization is important to teaching web development','','publish','closed','closed','','why-standardization-is-important-to-teaching-web-development','','','2021-01-28 13:05:29','2021-01-28 20:05:29','',0,'https://www.ddev.com/?p=3861',0,'post','',0),(3864,16,'2021-01-28 11:22:20','2021-01-28 18:22:20','<!-- wp:ugb/button {\"borderRadius\":29,\"button1BackgroundColor\":\"#fcb900\",\"button1PaddingTop\":20,\"button1PaddingBottom\":20,\"button1BorderRadius\":100,\"uniqueClass\":\"ugb-c753114\"} -->\n<div class=\"wp-block-ugb-button ugb-button-wrapper ugb-c753114 ugb-main-block\"><style>.ugb-c753114 .ugb-block-content .ugb-button{border-radius:29px}.ugb-c753114 .ugb-button1{background-color:#fcb900;padding-top:20px;padding-bottom:20px;border-radius:100px !important}.ugb-c753114 .ugb-button1 .ugb-button--inner,.ugb-c753114 .ugb-button1 svg:not(.ugb-custom-icon){color:#222222 !important}.ugb-c753114 .ugb-button1:before{border-radius:100px !important}</style><div class=\"ugb-inner-block\"><div class=\"ugb-block-content\"><div class=\"ugb-button-container\"><a class=\"ugb-button1 ugb-button ugb-button--size-normal\" href=\"https://www.ddev.com/get-started/\" rel=\"\" title=\"\"><span class=\"ugb-button--inner\">Get started with Drupal and DDEV</span></a></div></div></div></div>\n<!-- /wp:ugb/button -->','Get started page','','publish','closed','closed','','untitled-reusable-block-5','','','2021-01-28 11:22:30','2021-01-28 18:22:30','',0,'https://www.ddev.com/uncategorized/untitled-reusable-block-5/',0,'wp_block','',0),(3884,16,'2021-02-04 15:42:13','2021-02-04 22:42:13','<!-- wp:paragraph -->\n<p>What if you could quickly spin up a copy of work-in-progress that could be shared as a live website with stakeholders, or used for testing and QA? A workflow that supports both the tools you already use and the way you work with others can help ease some bottlenecks and communication mishaps. That’s what <a href=\"https://www.ddev.com/ddev-live/#ddev-preview\">DDEV Preview</a> offers! In this blog, we’ll talk about how using a shareable preview site as one step in a software release process can support a <a href=\"https://www.ddev.com/devops/what-is-devops/\">DevOps workflow</a> that incorporates safety for the humans and security for the code.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Make testing easier and ultimately ship better-quality work</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.ddev.com/ddev-live/what-is-ddev-preview/\">Preview sites</a> are created from a pull request (PR) in your GitHub repository, or a merge request (MR) in a GitLab repository. They are available via URL, interactive via CLI, and can be connected to other tools using an API token. It takes <a href=\"https://docs.ddev.com/preview-bot/\">one command</a> to create a pull request preview site, which can then be used to test whatever upgrades you’ve made, catch bugs, and finally deploy with confidence.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Plus, with the user-friendly URL a preview site can be tested for accessibility, plugged into visual regression testing tools, run through QA or user acceptance testing (UAT). This flexible workflow empowers engineering teams to use whichever tools and methodology they prefer. Don’t wait until the last minute to make sure the work is right, test early and often!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Get stakeholder feedback faster and move on to your next feature</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Once a new feature or bug fix is in place, you might want to confirm the change with a stakeholder from the business team, or even a client. Instead of waiting for an environment to be provisioned or setting up your local machine to be a web host, set an <a href=\"https://docs.ddev.com/sites/#setting-expiration-on-your-site\">expiration</a>, share a URL, and take the evening off.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>By removing the bottlenecks in the review process such as waiting on server provisioning or the availability of one reviewer, work can move forward at a steady pace. Create a preview site and leave the link on your PR so your code reviewers can click through and see it live. That makes it even easier for reviewers who may not have their <a href=\"https://ddev.readthedocs.io/en/stable/\">local environment</a> set up for quick code pulls to see work-in-progress in action. No need to wait until the project is live online to make sure the work is right; stakeholders can participate and validate work throughout the process.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Truly collaborate with team members around the world</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A functional, healthy, engaged team is key to getting basically anything done. How can we help various team members to work in harmony? By giving them tools to participate, enabling them to self-serve without bottlenecks, and creating a sense of safety to experiment and to fail.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>As a reviewer, I want to quickly view my colleague’s design work-in-progress in order to leave a review for them. As a QA expert, I need to be able to see new work in a production-like environment before we deploy. As a business stakeholder I need to see what to expect in the upcoming release without needing to understand how to brew code. As a project manager, I need to show the client the new feature they’re requesting before we deploy. And as a developer, I want to demo and stress-test the cool new feature I’ve been working on without breaking prod.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Every one of those needs can be enabled by a preview site. A project owner, say the developer or the project manager, can create the preview site with a command and share that URL with others. Being able to conduct work simultaneously in different stages of the workflow means no one is waiting for each other or slowing the flow. The net result is faster development, increased margins and increased customer satisfaction.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Save time and money by only paying for the resources you use</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Preview sites can also be thought of as on-demand staging environments. The idea is that they are temporary, not taking up resources any longer than is needed, but also available when you need them. That’s why <a href=\"https://www.ddev.com/ddev-live/release-notes-platform-updates-plus-ddev-preview-faq/#FAQ\">a preview site is actually a clone</a> created based on a parent site, using the new code from a PR in combination with the assets and config from the parent. This reduces the time to create the preview and helps ensure that you’re working with a production-like environment.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Preview sites can be used alongside your current tools and hosting providers — you don’t need to use DDEV for hosting your live site. Sites are manageable through the ddev-live command line tool and can be tagged, organized, and deleted. All you really need is a project in a repository on <a href=\"https://docs.ddev.com/providers/\">GitHub or GitLab</a> to connect to and start working from. Preview is something you can get up-and-running right now in just a few minutes and start using it, no matter your current development workflow</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you’re using DDEV-Live for your hosting needs already, then the Preview features are a nice value-add for your investment. Since it’s already part of your software development lifecycle (SDLC), the benefits are even greater because the infrastructure is already part of your workflow. The flexibility to spin up and automatically delete preview sites almost at will can be a big boon to your bank account when you’re running testing and qa on multiple projects.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Transparent workflows support communication and agile development</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>A lot of <a href=\"https://drupal.tv/external-video/2019-02-16/achieve-devops-nirvana-putting-one-foot-front-other\">DevOps philosophy</a> boils down to making workflows transparent. Transparent workflows are visible workflows, and visible workflows enable clear communication between all involved. Offering visibility into work-in-progress very literally with a preview site fits in nicely. The benefits to dev team members, business stakeholders, and clients include rapid iterations, continuous alignment, and more frequent successful deployments.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We don’t need to release a unicorn feature every quarter. Releasing a small, useful feature every week that truly benefits the end user and creates customer loyalty keeps everyone engaged with regular doses of success and moving forward toward our shared goals.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Ready to start deploying with confidence?</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.ddev.com/workflow/the-ddev-story/\">DDEV solves the problem</a> of opaque workflows and dangerous deployments by giving all team members the ability to create preview sites to view or test work-in-progress, eliminating silos and creating security to move quickly. The <a href=\"https://www.ddev.com/ddev-live/what-is-ddev-preview/\">Preview feature</a> in the DDEV platform allows team members to create a preview site by adding a single comment to a PR `/ddev-live-preview-site`. The site is accessible with a URL, which can be shared to anyone, anywhere.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Start a free DDEV-Live trial to experiment with Preview today, or drop us a line to schedule a demo and talk about how DDEV fits your DevOps workflow.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:ugb/columns {\"uniqueClass\":\"ugb-18ce2a9\",\"align\":\"center\"} -->\n<div class=\"aligncenter wp-block-ugb-columns ugb-columns ugb-18ce2a9 ugb-columns--design-plain ugb-columns--columns-2 ugb-main-block\"><div class=\"ugb-inner-block\"><div class=\"ugb-block-content\"><div class=\"ugb-columns__item ugb-18ce2a9-content-wrapper\"><!-- wp:ugb/column {\"uniqueClass\":\"ugb-f207b95\"} -->\n<div class=\"wp-block-ugb-column ugb-column ugb-f207b95 ugb-column--design-plain ugb-main-block\"><div class=\"ugb-inner-block\"><div class=\"ugb-block-content\"><div class=\"ugb-column__item ugb-f207b95-column-wrapper\"><div class=\"ugb-column__content-wrapper\"><!-- wp:block {\"ref\":2710} /--></div></div></div></div></div>\n<!-- /wp:ugb/column -->\n\n<!-- wp:ugb/column {\"uniqueClass\":\"ugb-4728f54\"} -->\n<div class=\"wp-block-ugb-column ugb-column ugb-4728f54 ugb-column--design-plain ugb-main-block\"><div class=\"ugb-inner-block\"><div class=\"ugb-block-content\"><div class=\"ugb-column__item ugb-4728f54-column-wrapper\"><div class=\"ugb-column__content-wrapper\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":46,\"backgroundColor\":\"luminous-vivid-amber\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-luminous-vivid-amber-background-color has-text-color has-background\" style=\"border-radius:46px\">Drop us a line ?</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div></div></div></div>\n<!-- /wp:ugb/column --></div></div></div></div>\n<!-- /wp:ugb/columns -->','Five ways preview sites support a DevOps workflow','','publish','closed','closed','','five-ways-preview-sites-support-a-devops-workflow','','','2021-02-05 12:15:24','2021-02-05 19:15:24','',0,'https://www.ddev.com/?p=3884',0,'post','',0),(3907,25,'2021-02-17 13:13:27','2021-02-17 20:13:27','<!-- wp:paragraph -->\n<p>As the owner of a web project, you may want to directly access your production site to run developer tools. Historically, many of us would access a live site using SSH for direct shell access on a single static server for traditional hosting. Some hosting providers give limited access to run single commands from a local command line, or start a remote shell session with more complicated commands, but there are delays and it can be a bit like fiddling around in the dark. Add some Kubernetes-based, containerized hosting into the mix and it can feel really intimidating and complicated.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>With the release of <a href=\"https://docs.ddev.com/getting-started/#install-the-ddev-live-cli\">DDEV-Live CLI</a> version 0.9.2 and <a href=\"https://github.com/ddev/ddev-apis/releases/tag/v0.7.1\">API v 0.7.1</a> you now have the option of initiating an interactive session with a site on our <a href=\"https://ddev.com/ddev-live/\">Kubernetes-based hosting platform</a>. We handled the complicated parts so you don’t need to understand the container architecture that holds your project— just connect, navigate around inside the project, and use your command line tools as usual. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>How do I run commands on a remote host?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Previously, in order to run command line tools on a project in a DDEV-Live environment such as production or <a href=\"https://www.ddev.com/ddev-live/#ddev-preview\">Preview</a>, you could run a single command using <code>ddev-live exec</code>. (For those of you familiar with the <a href=\"https://ddev.readthedocs.io/en/latest/users/cli-usage/#executing-commands-in-containers\">DDEV-Local <code>ddev exec</code> command</a>, this is similar behavior that allows you access inside the web container.) Each command was run individually, and it was difficult to observe the results of the command. Commands could take an unknown period of time to execute, resulting in a loss of momentum, productivity, and even causing a little frustration.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>These direct commands are still available and have plenty uses, for example if you just want to set configuration or trigger a single command such as:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><code>ddev-live exec mysite -- drush cr</code></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Until now, running these commands could take several minutes, and the DDEV-Live CLI gave minimal feedback. This is because any command sent using <code>ddev-live exec</code> created what’s called a “<a href=\"https://docs.ddev.com/jobs/\">job</a>” in the backend on our platform, which would enter a scheduling queue and eventually would be executed. Once the job was actually triggered, the command would run in the expected amount of time, so the delay was just in how the command passed from the user to the project. Good news! We’ve found a better way.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Interactive exec for production containers</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Now, the <code>ddev-live exec</code> command consumes <a href=\"https://github.com/ddev/ddev-apis\">our API</a>, which gives everyone more options and flexibility. The exec command itself is faster as a single command and it offers an exciting new interactive mode! Check it out: start a session with <code>ddev-live exec mysite --i [command]</code> and the CLI will start a bidirectional stream of command output between your terminal and the Kubernetes pod where your project lives. The flag <code>--i</code> runs the exec command as an interactive session.  Omit it to run a single command as non-interactive.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Instead of waiting for a scheduled “job” to run somewhere in Kubernetes, commands execute right away in both interactive and non-interactive modes. Thanks to the API, you will not connect <em>directly</em> to the pod in Kubernetes, you connect to an API server which brokers everything you type to Kubernetes:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Client &lt;====&gt; API Server &lt;===&gt; Kubernetes</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>“That was a bunch of words!” you say. Here’s a more specific, super simple, example: run <code>ddev-live exec mysite --i bash</code>. Now you have a shell session open, you’re in the docroot for your project, and you can list files to prove it:&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"width\":828,\"height\":344} -->\n<figure class=\"wp-block-image is-resized\"><img src=\"https://lh4.googleusercontent.com/lOqVcFSWBQWxurN4gkklkzXSkIWPrtT6tzljNDGCDzL6HMih_C1ub4u9ooujS5ljjE-o5kE5VwW8nfG5UCQXJtU6dKp8Qre8zZSobQFSiZuZHgKxPk14frxt48XEVEmVPJvxf1kL\" alt=\"Screenshot of command line when running `ddev-live exec test-wp --i bash`. A prompt for the remote container appears, and we show listing the files in that directory.\" width=\"828\" height=\"344\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>While you’re here, you can start to do all kinds of fun stuff and quickly interact directly with your tools and files. For WordPress users, WP-CLI is available in the container:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:html -->\n<pre class=\"language-bash\"><code class=\"language-bash\">www-data@test-wp-5568574998-7mcbc:~/html$ wp cli version\nWP-CLI 2.4.0</code></pre>\n<!-- /wp:html -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Other developer tools and tasks in interactive exec mode: </h3>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li>Inspect sites/default/files.&nbsp;</li><li>Inspect code.&nbsp;</li><li>See what CMS version is live.&nbsp;</li><li>Inspect PHP configuration in /etc/php/&lt;version&gt;.&nbsp;</li><li>Confirm PHP major and minor version with <code>php --version</code>.&nbsp;</li><li>Remove files in sites/default/files that shouldn\'t be there.</li><li>Observe a deployment and check whether Composer downloaded the right files to the right places.</li><li>Explore (and alter) the database with <code>drush sql-cli</code>.</li><li>Check what code commit is deployed with <code>git log</code>.</li><li>Top Drush commands like <code>drush cr</code> and <code>drush uli</code>.</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>With DDEV-Live, you can now initiate an interactive session with your project on production and interact with developer tools in a natural command-line context. You can go ahead and run the commands you need to maintain and administer your project without delays or needing to pull and push entire site updates in order to accomplish simple interactive tasks.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2>Run commands on production websites</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>DDEV solves the difficulty of using developer tools on projects in hosted containers and the delay of waiting for individual commands to execute by offering an interactive command line connection to the production server that gives the end user the ability to work directly on their own live projects. That leads to saved time, increased velocity, and the flexibility to work with your projects the way you need to.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>tl;dr - Sign up for a free trial with a DDEV-Live personal account, <a href=\"https://docs.ddev.com/getting-started/\">set up your workspace</a>, spin up a site from a repository on your <a href=\"https://docs.ddev.com/sites/\">GitHub account</a>, and try running <code>ddev-live exec newSiteName --i bash</code>. Please <a href=\"https://www.ddev.com/contact/\">let us know how it goes</a> and what else you need! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block {\"ref\":2710} /-->','Execute commands and interact with your cloud containers','','publish','closed','closed','','execute-commands-and-interact-with-your-cloud-containers','','','2021-02-17 13:13:28','2021-02-17 20:13:28','',0,'https://www.ddev.com/?p=3907',0,'post','',0),(3922,8,'2021-02-22 12:49:04','2021-02-22 19:49:04','','DDEV Preview','','publish','closed','closed','','ddev-preview','','','2021-02-22 12:49:05','2021-02-22 19:49:05','',0,'https://www.ddev.com/?page_id=3922',0,'page','',0),(3925,8,'2021-02-22 12:50:16','2021-02-22 19:50:16',' ','','','publish','closed','closed','','3925','','','2021-02-22 12:50:16','2021-02-22 19:50:16','',0,'https://www.ddev.com/?p=3925',3,'nav_menu_item','',0);
/*!40000 ALTER TABLE `wp_posts` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-02-24  1:40:12

