/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.udf.examples;

import io.confluent.function.runtime.core.Context;
import io.confluent.function.runtime.core.RequestHandler;
import io.confluent.function.runtime.core.RequestInvocationException;
import java.nio.ByteBuffer;

public class MaxIntHandler
implements RequestHandler {
    private int max = Integer.MIN_VALUE;

    private static int fromByteArray(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    private static byte[] toByteArray(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public byte[] handleRequest(byte[] input, Context ctx) throws RequestInvocationException {
        if (input.length != 4) {
            throw new RequestInvocationException(222, "Invalid input");
        }
        int num = MaxIntHandler.fromByteArray(input);
        if (num > this.max) {
            this.max = num;
        }
        return MaxIntHandler.toByteArray(this.max);
    }

    public void open(byte[] payload, Context ctx) {
    }

    public void close(byte[] payload, Context ctx) {
    }
}

