---
title: glab repo members add
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see <https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments>
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

Add a member to the project.

## Synopsis

Add a member to the project with the specified role.

Roles:

- guest (10): Can view the project.
- reporter (20): Can view and create issues.
- developer (30): Can push to non-protected branches.
- maintainer (40): Can manage the project.
- owner (50): Full access to the project.

For custom roles, use `--role-id` with the ID of a custom role defined in the project or group.
Note: If the custom role does not exist an error is returned.

```plaintext
glab repo members add [flags]
```

## Examples

```console
# Add a user as a developer
$ glab repo members add --username=john.doe --role=developer
# Add a user as a maintainer with expiration date
$ glab repo members add --username=jane.smith --role=maintainer --expires-at=2024-12-31
# Add a user by ID
$ glab repo members add --user-id=123 --role=reporter
# Add a user with a custom role
$ glab repo members add --username=john.doe --role-id=101
```

## Options

```plaintext
  -e, --expires-at string   Expiration date for the membership (YYYY-MM-DD)
  -R, --repo OWNER/REPO     Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
  -r, --role string         Role for the user (guest, reporter, developer, maintainer, owner) (default "developer")
      --role-id int         ID of a custom role defined in the project or group
  -u, --user-id int         User ID instead of username
      --username string     Username instead of user-id
```

## Options inherited from parent commands

```plaintext
  -h, --help   Show help for this command.
```
