# age

chezmoi supports encrypting files with [age](https://age-encryption.org/).

Generate a key using `age-keygen`:

```console
$ age-keygen -o $HOME/key.txt
Public key: age1ql3z7hjy54pw3hyww5ayyfg7zqgvc7w3j2elw8zmrj2kg5sfn9aqmcac8p
```

Specify age encryption in your configuration file, being sure to specify at
least the identity and one recipient:

```toml title="~/.config/chezmoi/chezmoi.toml"
encryption = "age"
[age]
    identity = "/home/user/key.txt"
    recipient = "age1ql3z7hjy54pw3hyww5ayyfg7zqgvc7w3j2elw8zmrj2kg5sfn9aqmcac8p"
```

chezmoi supports multiple recipients and recipient files, and multiple
identities.

!!! note

    Make sure `encryption` is added to the top level section at the beginning of
    the config, before any other sections.

## Symmetric encryption

To use age's symmetric encryption, specify a single identity and enable
symmetric encryption in your config file, for example:

```toml title="~/.config/chezmoi/chezmoi.toml"
encryption = "age"
[age]
    identity = "~/.ssh/id_rsa"
    symmetric = true
```

## Symmetric encryption with a passphrase

To use age's symmetric encryption with a passphrase, set `age.passphrase` to
`true` in your config file, for example:

```toml title="~/.config/chezmoi/chezmoi.toml"
encryption = "age"
[age]
    passphrase = true
```

You will be prompted for the passphrase whenever you run `chezmoi add
--encrypt` and whenever chezmoi needs to decrypt the file, for example when you
run `chezmoi apply`, `chezmoi diff`, or `chezmoi status`.

## Builtin age encryption

chezmoi has builtin support for age encryption which is automatically used if
the `age` command is not found in `$PATH`.

!!! info

    The builtin age encryption does not support passphrases, symmetric
    encryption, or SSH keys.

    Passphrases are not supported because chezmoi needs to decrypt files
    regularly, e.g. when running a `chezmoi diff` or a `chezmoi status`
    command, not just when running `chezmoi apply`. Prompting for a passphrase
    each time would quickly become tiresome.

    Symmetric encryption may be supported in the future. Please [open an
    issue](https://github.com/twpayne/chezmoi/issues/new?assignees=&labels=enhancement&template=02_feature_request.md&title=)
    if you want this.

    SSH keys are not supported as the [age documentation explicitly recommends
    not using them](https://pkg.go.dev/filippo.io/age#hdr-Key_management):

    > When integrating age into a new system, it's recommended that you only
    > support X25519 keys, and not SSH keys. The latter are supported for
    > manual encryption operations.
