package cmd

import (
	"github.com/carapace-sh/carapace"
	"github.com/spf13/cobra"
)

var rootCmd = &cobra.Command{
	Use:   "soft",
	Short: "A self-hostable Git server for the command line",
	Long:  "https://github.com/charmbracelet/soft-serve",
	Run:   func(cmd *cobra.Command, args []string) {},
}

func Execute() error {
	return rootCmd.Execute()
}

func init() {
	carapace.Gen(rootCmd).Standalone()
	rootCmd.Flags().BoolP("help", "h", false, "help for soft")
	rootCmd.Flags().BoolP("version", "v", false, "version for soft")
}
