# v1.5 - Alter Ego

![](./v1.5/banner.png)

Oh noes! Run is multiples.

## Run

Now also accepts `array` and `shebang`.

```yaml
# yaml-language-server: $schema=https://carapace.sh/schemas/command.json
name: run
commands:
  - name: alias
    commands:
      - name: string
        run: "[tail, --lines, '${NUM:-1}']"

      - name: array
        run: [tail, --lines, "${NUM:-1}"]

  - name: script
    commands:
      - name: macro
        run: "$(tail -n${C_FLAG_LINES:-1} $@) ||| $chdir($tempdir)"
        flags:
          -n, --lines=: output the last NUM lines
        completion:
          positionalany: ["$files ||| $chdir($tempdir)"]

      - name: shebang
        run: |
          #!/usr/bin/env bash -x
          for arg in "$@"; do
            echo "${!arg}${C_FLAG_SUFFIX:-.suffix}"
          done
        flags:
          -s, --suffix=: suffix to add
        completion:
          flag:
            suffix: [.backup, .copy]
          positionalany: [one, two]
```

![](./v1.5/run.cast)

## Envsubst

Skip [expansion](https://carapace-sh.github.io/carapace/carapace/context/envsubst.html) with a `!` prefix.

| Expression           | Substitution           |
|----------------------|------------------------|
| `${HOME}`            | `/home/user`           |
| `${!HOME}`           | `${HOME}`              |
| `${UNSET:-default}`  | `default`              |
| `${!UNSET:-default}` | `${UNSET:-default}`    |

## Macro

The `$()` [exec macro] now defaults to `cmd` instead of `pwsh` on windows.

- `$(<command>)` (`sh` on unix and `cmd` on windows)
- `$bash(<command>)`
- `$cmd(<command>)`
- `$elvish(<command>)`
- `$fish(<command>)`
- `$nu(<command>)`
- `$osh(<command>)`
- `$pwsh(<command>)`
- `$sh(<command>)`
- `$xonsh(<command>)`
- `$zsh(<command>)`

## Edit

Added `carapace --edit FILE...` for convenience.

- `$CARAPACE_EDITOR` (highest priority)
- `$GIT_EDITOR`
- `$VISUAL`
- `$EDITOR`

![](./v1.5/edit.cast)

## Bridge

Added support for `kitten` which provides completion for [Kitty](https://sw.kovidgoyal.net/kitty/).

- `kitten` - identifier
- `bridge.Kitten` - macro

Parsing `compdef` header for multiple registered commands (instead of just one).
```sh
#compdef pulseaudio pactl pacmd pacat paplay parec parecord padsp pasuspender
```

Dynamically creating list of `inshellisense` completers.
```sh
inshellisense specs list 
# ["act","adb","adr","afplay","aftman","ag","agrippa","airflow",...
```
[exec macro]:https://carapace-sh.github.io/carapace-spec/carapace-spec/macros/core.html#exec
