// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/alpha/audit/v1alpha1/event.proto

package auditv1alpha1

import (
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ActorType is the type of actor that caused the audited event.
type ActorType int32

const (
	ActorType_ACTOR_TYPE_UNSPECIFIED ActorType = 0
	ActorType_ACTOR_TYPE_USER        ActorType = 1
	ActorType_ACTOR_TYPE_SYSTEM      ActorType = 2
)

// Enum value maps for ActorType.
var (
	ActorType_name = map[int32]string{
		0: "ACTOR_TYPE_UNSPECIFIED",
		1: "ACTOR_TYPE_USER",
		2: "ACTOR_TYPE_SYSTEM",
	}
	ActorType_value = map[string]int32{
		"ACTOR_TYPE_UNSPECIFIED": 0,
		"ACTOR_TYPE_USER":        1,
		"ACTOR_TYPE_SYSTEM":      2,
	}
)

func (x ActorType) Enum() *ActorType {
	p := new(ActorType)
	*p = x
	return p
}

func (x ActorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActorType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[0].Descriptor()
}

func (ActorType) Type() protoreflect.EnumType {
	return &file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[0]
}

func (x ActorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// ResourceType is the type of the resource that was affected by the audited event.
//
// [#next-free-field: 22]
type ResourceType int32

const (
	ResourceType_RESOURCE_TYPE_UNSPECIFIED                ResourceType = 0
	ResourceType_RESOURCE_TYPE_USER                       ResourceType = 1
	ResourceType_RESOURCE_TYPE_ORGANIZATION               ResourceType = 2
	ResourceType_RESOURCE_TYPE_ORGANIZATION_MEMBER        ResourceType = 3
	ResourceType_RESOURCE_TYPE_ORGANIZATION_IDP_GROUP     ResourceType = 9
	ResourceType_RESOURCE_TYPE_REPOSITORY                 ResourceType = 4
	ResourceType_RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR     ResourceType = 5
	ResourceType_RESOURCE_TYPE_REPOSITORY_COMMIT          ResourceType = 6
	ResourceType_RESOURCE_TYPE_REPOSITORY_IDP_GROUP       ResourceType = 18
	ResourceType_RESOURCE_TYPE_POLICY                     ResourceType = 17
	ResourceType_RESOURCE_TYPE_POLICY_COMMIT              ResourceType = 19
	ResourceType_RESOURCE_TYPE_POLICY_LABEL               ResourceType = 20
	ResourceType_RESOURCE_TYPE_PLUGIN                     ResourceType = 7
	ResourceType_RESOURCE_TYPE_PLUGIN_COMMIT              ResourceType = 15
	ResourceType_RESOURCE_TYPE_CURATED_PLUGIN             ResourceType = 8
	ResourceType_RESOURCE_TYPE_TOKEN                      ResourceType = 10
	ResourceType_RESOURCE_TYPE_SCIM_TOKEN                 ResourceType = 11
	ResourceType_RESOURCE_TYPE_REPOSITORY_LABEL           ResourceType = 12
	ResourceType_RESOURCE_TYPE_SERVER                     ResourceType = 13
	ResourceType_RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT ResourceType = 14
	ResourceType_RESOURCE_TYPE_PLUGIN_LABEL               ResourceType = 16
	ResourceType_RESOURCE_TYPE_SDK_PLUGIN_CONSTRAINT      ResourceType = 21
)

// Enum value maps for ResourceType.
var (
	ResourceType_name = map[int32]string{
		0:  "RESOURCE_TYPE_UNSPECIFIED",
		1:  "RESOURCE_TYPE_USER",
		2:  "RESOURCE_TYPE_ORGANIZATION",
		3:  "RESOURCE_TYPE_ORGANIZATION_MEMBER",
		9:  "RESOURCE_TYPE_ORGANIZATION_IDP_GROUP",
		4:  "RESOURCE_TYPE_REPOSITORY",
		5:  "RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR",
		6:  "RESOURCE_TYPE_REPOSITORY_COMMIT",
		18: "RESOURCE_TYPE_REPOSITORY_IDP_GROUP",
		17: "RESOURCE_TYPE_POLICY",
		19: "RESOURCE_TYPE_POLICY_COMMIT",
		20: "RESOURCE_TYPE_POLICY_LABEL",
		7:  "RESOURCE_TYPE_PLUGIN",
		15: "RESOURCE_TYPE_PLUGIN_COMMIT",
		8:  "RESOURCE_TYPE_CURATED_PLUGIN",
		10: "RESOURCE_TYPE_TOKEN",
		11: "RESOURCE_TYPE_SCIM_TOKEN",
		12: "RESOURCE_TYPE_REPOSITORY_LABEL",
		13: "RESOURCE_TYPE_SERVER",
		14: "RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT",
		16: "RESOURCE_TYPE_PLUGIN_LABEL",
		21: "RESOURCE_TYPE_SDK_PLUGIN_CONSTRAINT",
	}
	ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED":                0,
		"RESOURCE_TYPE_USER":                       1,
		"RESOURCE_TYPE_ORGANIZATION":               2,
		"RESOURCE_TYPE_ORGANIZATION_MEMBER":        3,
		"RESOURCE_TYPE_ORGANIZATION_IDP_GROUP":     9,
		"RESOURCE_TYPE_REPOSITORY":                 4,
		"RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR":     5,
		"RESOURCE_TYPE_REPOSITORY_COMMIT":          6,
		"RESOURCE_TYPE_REPOSITORY_IDP_GROUP":       18,
		"RESOURCE_TYPE_POLICY":                     17,
		"RESOURCE_TYPE_POLICY_COMMIT":              19,
		"RESOURCE_TYPE_POLICY_LABEL":               20,
		"RESOURCE_TYPE_PLUGIN":                     7,
		"RESOURCE_TYPE_PLUGIN_COMMIT":              15,
		"RESOURCE_TYPE_CURATED_PLUGIN":             8,
		"RESOURCE_TYPE_TOKEN":                      10,
		"RESOURCE_TYPE_SCIM_TOKEN":                 11,
		"RESOURCE_TYPE_REPOSITORY_LABEL":           12,
		"RESOURCE_TYPE_SERVER":                     13,
		"RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT": 14,
		"RESOURCE_TYPE_PLUGIN_LABEL":               16,
		"RESOURCE_TYPE_SDK_PLUGIN_CONSTRAINT":      21,
	}
)

func (x ResourceType) Enum() *ResourceType {
	p := new(ResourceType)
	*p = x
	return p
}

func (x ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[1].Descriptor()
}

func (ResourceType) Type() protoreflect.EnumType {
	return &file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[1]
}

func (x ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// EventType is the type of audited event.
//
// [#next-free-field: 74]
type EventType int32

const (
	EventType_EVENT_TYPE_UNSPECIFIED               EventType = 0
	EventType_EVENT_TYPE_ORGANIZATION_CREATED      EventType = 1
	EventType_EVENT_TYPE_ORGANIZATION_DELETED      EventType = 2
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_ADDED EventType = 3
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED      EventType = 4
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_ROLES_CHANGED     EventType = 50
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED           EventType = 5
	EventType_EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED          EventType = 21
	EventType_EVENT_TYPE_ORGANIZATION_IDP_GROUP_UPDATED        EventType = 59
	EventType_EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED        EventType = 22
	EventType_EVENT_TYPE_REPOSITORY_CREATED                    EventType = 6
	EventType_EVENT_TYPE_REPOSITORY_DEPRECATED                 EventType = 48
	EventType_EVENT_TYPE_REPOSITORY_UNDEPRECATED               EventType = 49
	EventType_EVENT_TYPE_REPOSITORY_DELETED                    EventType = 7
	EventType_EVENT_TYPE_REPOSITORY_COMMIT_PUSHED              EventType = 8
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED          EventType = 9
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED   EventType = 10
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLES_CHANGED  EventType = 63
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED        EventType = 11
	EventType_EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED         EventType = 12
	EventType_EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED EventType = 40
	EventType_EVENT_TYPE_REPOSITORY_IDP_GROUP_ADDED            EventType = 60
	EventType_EVENT_TYPE_REPOSITORY_IDP_GROUP_UPDATED          EventType = 61
	EventType_EVENT_TYPE_REPOSITORY_IDP_GROUP_REMOVED          EventType = 62
	EventType_EVENT_TYPE_POLICY_CREATED                        EventType = 54
	EventType_EVENT_TYPE_POLICY_DELETED                        EventType = 55
	EventType_EVENT_TYPE_POLICY_DEPRECATED                     EventType = 56
	EventType_EVENT_TYPE_POLICY_UNDEPRECATED                   EventType = 57
	EventType_EVENT_TYPE_POLICY_VISIBILITY_CHANGED             EventType = 58
	EventType_EVENT_TYPE_POLICY_COMMIT_PUSHED                  EventType = 64
	EventType_EVENT_TYPE_POLICY_LABEL_CREATED                  EventType = 65
	EventType_EVENT_TYPE_POLICY_LABEL_MOVED                    EventType = 66
	EventType_EVENT_TYPE_POLICY_LABEL_ARCHIVED                 EventType = 67
	EventType_EVENT_TYPE_POLICY_LABEL_UNARCHIVED               EventType = 68
	EventType_EVENT_TYPE_PLUGIN_CREATED                        EventType = 13
	EventType_EVENT_TYPE_PLUGIN_DELETED                        EventType = 14
	EventType_EVENT_TYPE_PLUGIN_DEPRECATED                     EventType = 51
	EventType_EVENT_TYPE_PLUGIN_UNDEPRECATED                   EventType = 52
	EventType_EVENT_TYPE_PLUGIN_VISIBILITY_CHANGED             EventType = 53
	EventType_EVENT_TYPE_PLUGIN_COMMIT_PUSHED                  EventType = 43
	EventType_EVENT_TYPE_CURATED_PLUGIN_CREATED                EventType = 20
	EventType_EVENT_TYPE_CURATED_PLUGIN_DELETED                EventType = 31
	EventType_EVENT_TYPE_USER_CREATED                          EventType = 15
	EventType_EVENT_TYPE_USER_DELETED                          EventType = 16
	EventType_EVENT_TYPE_USER_DEACTIVATED                      EventType = 17
	EventType_EVENT_TYPE_USER_LOGGED_IN                        EventType = 18
	EventType_EVENT_TYPE_USER_LOGGED_OUT                       EventType = 19
	EventType_EVENT_TYPE_TOKEN_CREATED                         EventType = 23
	EventType_EVENT_TYPE_TOKEN_DELETED                         EventType = 24
	EventType_EVENT_TYPE_USER_REACTIVATED                      EventType = 25
	EventType_EVENT_TYPE_SCIM_TOKEN_CREATED                    EventType = 26
	EventType_EVENT_TYPE_SCIM_TOKEN_DELETED                    EventType = 27
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	EventType_EVENT_TYPE_REPOSITORY_COMMIT_DELETED              EventType = 28
	EventType_EVENT_TYPE_REPOSITORY_LABEL_CREATED               EventType = 29
	EventType_EVENT_TYPE_REPOSITORY_LABEL_MOVED                 EventType = 30
	EventType_EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED              EventType = 38
	EventType_EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED            EventType = 39
	EventType_EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED  EventType = 32
	EventType_EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED EventType = 33
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	EventType_EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED   EventType = 34
	EventType_EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED    EventType = 35
	EventType_EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED   EventType = 36
	EventType_EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP       EventType = 37
	EventType_EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED EventType = 41
	EventType_EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED   EventType = 42
	EventType_EVENT_TYPE_PLUGIN_LABEL_CREATED                EventType = 44
	EventType_EVENT_TYPE_PLUGIN_LABEL_MOVED                  EventType = 45
	EventType_EVENT_TYPE_PLUGIN_LABEL_ARCHIVED               EventType = 46
	EventType_EVENT_TYPE_PLUGIN_LABEL_UNARCHIVED             EventType = 47
	EventType_EVENT_TYPE_SERVER_REVIEW_FLOW_ENABLED          EventType = 69
	EventType_EVENT_TYPE_SERVER_REVIEW_FLOW_DISABLED         EventType = 70
	EventType_EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_CREATED       EventType = 71
	EventType_EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_UPDATED       EventType = 72
	EventType_EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_DELETED       EventType = 73
)

// Enum value maps for EventType.
var (
	EventType_name = map[int32]string{
		0:  "EVENT_TYPE_UNSPECIFIED",
		1:  "EVENT_TYPE_ORGANIZATION_CREATED",
		2:  "EVENT_TYPE_ORGANIZATION_DELETED",
		3:  "EVENT_TYPE_ORGANIZATION_MEMBER_ADDED",
		4:  "EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED",
		50: "EVENT_TYPE_ORGANIZATION_MEMBER_ROLES_CHANGED",
		5:  "EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED",
		21: "EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED",
		59: "EVENT_TYPE_ORGANIZATION_IDP_GROUP_UPDATED",
		22: "EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED",
		6:  "EVENT_TYPE_REPOSITORY_CREATED",
		48: "EVENT_TYPE_REPOSITORY_DEPRECATED",
		49: "EVENT_TYPE_REPOSITORY_UNDEPRECATED",
		7:  "EVENT_TYPE_REPOSITORY_DELETED",
		8:  "EVENT_TYPE_REPOSITORY_COMMIT_PUSHED",
		9:  "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED",
		10: "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED",
		63: "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLES_CHANGED",
		11: "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED",
		12: "EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED",
		40: "EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED",
		60: "EVENT_TYPE_REPOSITORY_IDP_GROUP_ADDED",
		61: "EVENT_TYPE_REPOSITORY_IDP_GROUP_UPDATED",
		62: "EVENT_TYPE_REPOSITORY_IDP_GROUP_REMOVED",
		54: "EVENT_TYPE_POLICY_CREATED",
		55: "EVENT_TYPE_POLICY_DELETED",
		56: "EVENT_TYPE_POLICY_DEPRECATED",
		57: "EVENT_TYPE_POLICY_UNDEPRECATED",
		58: "EVENT_TYPE_POLICY_VISIBILITY_CHANGED",
		64: "EVENT_TYPE_POLICY_COMMIT_PUSHED",
		65: "EVENT_TYPE_POLICY_LABEL_CREATED",
		66: "EVENT_TYPE_POLICY_LABEL_MOVED",
		67: "EVENT_TYPE_POLICY_LABEL_ARCHIVED",
		68: "EVENT_TYPE_POLICY_LABEL_UNARCHIVED",
		13: "EVENT_TYPE_PLUGIN_CREATED",
		14: "EVENT_TYPE_PLUGIN_DELETED",
		51: "EVENT_TYPE_PLUGIN_DEPRECATED",
		52: "EVENT_TYPE_PLUGIN_UNDEPRECATED",
		53: "EVENT_TYPE_PLUGIN_VISIBILITY_CHANGED",
		43: "EVENT_TYPE_PLUGIN_COMMIT_PUSHED",
		20: "EVENT_TYPE_CURATED_PLUGIN_CREATED",
		31: "EVENT_TYPE_CURATED_PLUGIN_DELETED",
		15: "EVENT_TYPE_USER_CREATED",
		16: "EVENT_TYPE_USER_DELETED",
		17: "EVENT_TYPE_USER_DEACTIVATED",
		18: "EVENT_TYPE_USER_LOGGED_IN",
		19: "EVENT_TYPE_USER_LOGGED_OUT",
		23: "EVENT_TYPE_TOKEN_CREATED",
		24: "EVENT_TYPE_TOKEN_DELETED",
		25: "EVENT_TYPE_USER_REACTIVATED",
		26: "EVENT_TYPE_SCIM_TOKEN_CREATED",
		27: "EVENT_TYPE_SCIM_TOKEN_DELETED",
		28: "EVENT_TYPE_REPOSITORY_COMMIT_DELETED",
		29: "EVENT_TYPE_REPOSITORY_LABEL_CREATED",
		30: "EVENT_TYPE_REPOSITORY_LABEL_MOVED",
		38: "EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED",
		39: "EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED",
		32: "EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED",
		33: "EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED",
		34: "EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED",
		35: "EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED",
		36: "EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED",
		37: "EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP",
		41: "EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED",
		42: "EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED",
		44: "EVENT_TYPE_PLUGIN_LABEL_CREATED",
		45: "EVENT_TYPE_PLUGIN_LABEL_MOVED",
		46: "EVENT_TYPE_PLUGIN_LABEL_ARCHIVED",
		47: "EVENT_TYPE_PLUGIN_LABEL_UNARCHIVED",
		69: "EVENT_TYPE_SERVER_REVIEW_FLOW_ENABLED",
		70: "EVENT_TYPE_SERVER_REVIEW_FLOW_DISABLED",
		71: "EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_CREATED",
		72: "EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_UPDATED",
		73: "EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_DELETED",
	}
	EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":                            0,
		"EVENT_TYPE_ORGANIZATION_CREATED":                   1,
		"EVENT_TYPE_ORGANIZATION_DELETED":                   2,
		"EVENT_TYPE_ORGANIZATION_MEMBER_ADDED":              3,
		"EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED":       4,
		"EVENT_TYPE_ORGANIZATION_MEMBER_ROLES_CHANGED":      50,
		"EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED":            5,
		"EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED":           21,
		"EVENT_TYPE_ORGANIZATION_IDP_GROUP_UPDATED":         59,
		"EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED":         22,
		"EVENT_TYPE_REPOSITORY_CREATED":                     6,
		"EVENT_TYPE_REPOSITORY_DEPRECATED":                  48,
		"EVENT_TYPE_REPOSITORY_UNDEPRECATED":                49,
		"EVENT_TYPE_REPOSITORY_DELETED":                     7,
		"EVENT_TYPE_REPOSITORY_COMMIT_PUSHED":               8,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED":           9,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED":    10,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLES_CHANGED":   63,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED":         11,
		"EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED":          12,
		"EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED":  40,
		"EVENT_TYPE_REPOSITORY_IDP_GROUP_ADDED":             60,
		"EVENT_TYPE_REPOSITORY_IDP_GROUP_UPDATED":           61,
		"EVENT_TYPE_REPOSITORY_IDP_GROUP_REMOVED":           62,
		"EVENT_TYPE_POLICY_CREATED":                         54,
		"EVENT_TYPE_POLICY_DELETED":                         55,
		"EVENT_TYPE_POLICY_DEPRECATED":                      56,
		"EVENT_TYPE_POLICY_UNDEPRECATED":                    57,
		"EVENT_TYPE_POLICY_VISIBILITY_CHANGED":              58,
		"EVENT_TYPE_POLICY_COMMIT_PUSHED":                   64,
		"EVENT_TYPE_POLICY_LABEL_CREATED":                   65,
		"EVENT_TYPE_POLICY_LABEL_MOVED":                     66,
		"EVENT_TYPE_POLICY_LABEL_ARCHIVED":                  67,
		"EVENT_TYPE_POLICY_LABEL_UNARCHIVED":                68,
		"EVENT_TYPE_PLUGIN_CREATED":                         13,
		"EVENT_TYPE_PLUGIN_DELETED":                         14,
		"EVENT_TYPE_PLUGIN_DEPRECATED":                      51,
		"EVENT_TYPE_PLUGIN_UNDEPRECATED":                    52,
		"EVENT_TYPE_PLUGIN_VISIBILITY_CHANGED":              53,
		"EVENT_TYPE_PLUGIN_COMMIT_PUSHED":                   43,
		"EVENT_TYPE_CURATED_PLUGIN_CREATED":                 20,
		"EVENT_TYPE_CURATED_PLUGIN_DELETED":                 31,
		"EVENT_TYPE_USER_CREATED":                           15,
		"EVENT_TYPE_USER_DELETED":                           16,
		"EVENT_TYPE_USER_DEACTIVATED":                       17,
		"EVENT_TYPE_USER_LOGGED_IN":                         18,
		"EVENT_TYPE_USER_LOGGED_OUT":                        19,
		"EVENT_TYPE_TOKEN_CREATED":                          23,
		"EVENT_TYPE_TOKEN_DELETED":                          24,
		"EVENT_TYPE_USER_REACTIVATED":                       25,
		"EVENT_TYPE_SCIM_TOKEN_CREATED":                     26,
		"EVENT_TYPE_SCIM_TOKEN_DELETED":                     27,
		"EVENT_TYPE_REPOSITORY_COMMIT_DELETED":              28,
		"EVENT_TYPE_REPOSITORY_LABEL_CREATED":               29,
		"EVENT_TYPE_REPOSITORY_LABEL_MOVED":                 30,
		"EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED":              38,
		"EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED":            39,
		"EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED":  32,
		"EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED": 33,
		"EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED":      34,
		"EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED":       35,
		"EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED":      36,
		"EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP":          37,
		"EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED":    41,
		"EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED":      42,
		"EVENT_TYPE_PLUGIN_LABEL_CREATED":                   44,
		"EVENT_TYPE_PLUGIN_LABEL_MOVED":                     45,
		"EVENT_TYPE_PLUGIN_LABEL_ARCHIVED":                  46,
		"EVENT_TYPE_PLUGIN_LABEL_UNARCHIVED":                47,
		"EVENT_TYPE_SERVER_REVIEW_FLOW_ENABLED":             69,
		"EVENT_TYPE_SERVER_REVIEW_FLOW_DISABLED":            70,
		"EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_CREATED":          71,
		"EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_UPDATED":          72,
		"EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_DELETED":          73,
	}
)

func (x EventType) Enum() *EventType {
	p := new(EventType)
	*p = x
	return p
}

func (x EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[2].Descriptor()
}

func (EventType) Type() protoreflect.EnumType {
	return &file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[2]
}

func (x EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Actor is the actor who caused the audited event.
type Actor struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Type ActorType              `protobuf:"varint,1,opt,name=type,proto3,enum=buf.alpha.audit.v1alpha1.ActorType"`
	xxx_hidden_Id   string                 `protobuf:"bytes,2,opt,name=id,proto3"`
	xxx_hidden_Name string                 `protobuf:"bytes,3,opt,name=name,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Actor) Reset() {
	*x = Actor{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Actor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Actor) ProtoMessage() {}

func (x *Actor) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Actor) GetType() ActorType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return ActorType_ACTOR_TYPE_UNSPECIFIED
}

func (x *Actor) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Actor) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Actor) SetType(v ActorType) {
	x.xxx_hidden_Type = v
}

func (x *Actor) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Actor) SetName(v string) {
	x.xxx_hidden_Name = v
}

type Actor_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Type of actor who caused the audited event.
	Type ActorType
	// Id of the actor who caused the audited event.
	Id string
	// Name of the actor who caused the audited event.
	Name string
}

func (b0 Actor_builder) Build() *Actor {
	m0 := &Actor{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	return m0
}

// Resource is the affected resource by the audited event.
type Resource struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Type ResourceType           `protobuf:"varint,1,opt,name=type,proto3,enum=buf.alpha.audit.v1alpha1.ResourceType"`
	xxx_hidden_Id   string                 `protobuf:"bytes,2,opt,name=id,proto3"`
	xxx_hidden_Name string                 `protobuf:"bytes,3,opt,name=name,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Resource) Reset() {
	*x = Resource{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Resource) GetType() ResourceType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return ResourceType_RESOURCE_TYPE_UNSPECIFIED
}

func (x *Resource) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Resource) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Resource) SetType(v ResourceType) {
	x.xxx_hidden_Type = v
}

func (x *Resource) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Resource) SetName(v string) {
	x.xxx_hidden_Name = v
}

type Resource_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Type of resource that was affected by the audited event.
	Type ResourceType
	// Id of the affected resource by the audited event.
	Id string
	// Name of the affected resource by the audited event.
	Name string
}

func (b0 Resource_builder) Build() *Resource {
	m0 := &Resource{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	return m0
}

// EventMetadata provides additional details about the audited event.
type EventMetadata struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserAgent string                 `protobuf:"bytes,1,opt,name=user_agent,json=userAgent,proto3"`
	xxx_hidden_Ip        string                 `protobuf:"bytes,2,opt,name=ip,proto3"`
	xxx_hidden_TraceId   string                 `protobuf:"bytes,3,opt,name=trace_id,json=traceId,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *EventMetadata) Reset() {
	*x = EventMetadata{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventMetadata) ProtoMessage() {}

func (x *EventMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *EventMetadata) GetUserAgent() string {
	if x != nil {
		return x.xxx_hidden_UserAgent
	}
	return ""
}

func (x *EventMetadata) GetIp() string {
	if x != nil {
		return x.xxx_hidden_Ip
	}
	return ""
}

func (x *EventMetadata) GetTraceId() string {
	if x != nil {
		return x.xxx_hidden_TraceId
	}
	return ""
}

func (x *EventMetadata) SetUserAgent(v string) {
	x.xxx_hidden_UserAgent = v
}

func (x *EventMetadata) SetIp(v string) {
	x.xxx_hidden_Ip = v
}

func (x *EventMetadata) SetTraceId(v string) {
	x.xxx_hidden_TraceId = v
}

type EventMetadata_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// UserAgent is the User-Agent header associated with the request that triggered the audited event, if any.
	UserAgent string
	// IP is the IP address associated with the request that triggered the audited event, if any.
	Ip string
	// TraceID is the ID of the trace associated with the audited event, if any.
	TraceId string
}

func (b0 EventMetadata_builder) Build() *EventMetadata {
	m0 := &EventMetadata{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserAgent = b.UserAgent
	x.xxx_hidden_Ip = b.Ip
	x.xxx_hidden_TraceId = b.TraceId
	return m0
}

// Event is an audited action that happened in the BSR, with the information of what happened, when
// it happened, who did it, which resource was affected, and more contextual information on the
// event.
//
// [#next-free-field: 80]
type Event struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_EventId   string                 `protobuf:"bytes,1,opt,name=event_id,json=eventId,proto3"`
	xxx_hidden_Type      EventType              `protobuf:"varint,2,opt,name=type,proto3,enum=buf.alpha.audit.v1alpha1.EventType"`
	xxx_hidden_Actor     *Actor                 `protobuf:"bytes,3,opt,name=actor,proto3"`
	xxx_hidden_Resource  *Resource              `protobuf:"bytes,4,opt,name=resource,proto3"`
	xxx_hidden_EventTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=event_time,json=eventTime,proto3"`
	xxx_hidden_Metadata  *EventMetadata         `protobuf:"bytes,6,opt,name=metadata,proto3"`
	xxx_hidden_Payload   isEvent_Payload        `protobuf_oneof:"payload"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Event) Reset() {
	*x = Event{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Event) GetEventId() string {
	if x != nil {
		return x.xxx_hidden_EventId
	}
	return ""
}

func (x *Event) GetType() EventType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return EventType_EVENT_TYPE_UNSPECIFIED
}

func (x *Event) GetActor() *Actor {
	if x != nil {
		return x.xxx_hidden_Actor
	}
	return nil
}

func (x *Event) GetResource() *Resource {
	if x != nil {
		return x.xxx_hidden_Resource
	}
	return nil
}

func (x *Event) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_EventTime
	}
	return nil
}

func (x *Event) GetMetadata() *EventMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *Event) GetOrganizationCreated() *PayloadOrganizationCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationCreated); ok {
			return x.OrganizationCreated
		}
	}
	return nil
}

func (x *Event) GetOrganizationDeleted() *PayloadOrganizationDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationDeleted); ok {
			return x.OrganizationDeleted
		}
	}
	return nil
}

func (x *Event) GetOrganizationMemberAdded() *PayloadOrganizationMemberAdded {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberAdded); ok {
			return x.OrganizationMemberAdded
		}
	}
	return nil
}

func (x *Event) GetOrganizationMemberRoleChanged() *PayloadOrganizationMemberRoleChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRoleChanged); ok {
			return x.OrganizationMemberRoleChanged
		}
	}
	return nil
}

func (x *Event) GetOrganizationMemberRolesChanged() *PayloadOrganizationMemberRolesChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRolesChanged); ok {
			return x.OrganizationMemberRolesChanged
		}
	}
	return nil
}

func (x *Event) GetOrganizationMemberRemoved() *PayloadOrganizationMemberRemoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRemoved); ok {
			return x.OrganizationMemberRemoved
		}
	}
	return nil
}

func (x *Event) GetRepositoryCreated() *PayloadRepositoryCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryCreated); ok {
			return x.RepositoryCreated
		}
	}
	return nil
}

func (x *Event) GetRepositoryDeprecated() *PayloadRepositoryDeprecated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryDeprecated); ok {
			return x.RepositoryDeprecated
		}
	}
	return nil
}

func (x *Event) GetRepositoryUndeprecated() *PayloadRepositoryUndeprecated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryUndeprecated); ok {
			return x.RepositoryUndeprecated
		}
	}
	return nil
}

func (x *Event) GetRepositoryDeleted() *PayloadRepositoryDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryDeleted); ok {
			return x.RepositoryDeleted
		}
	}
	return nil
}

func (x *Event) GetRepositoryCommitPushed() *PayloadRepositoryCommitPushed {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitPushed); ok {
			return x.RepositoryCommitPushed
		}
	}
	return nil
}

func (x *Event) GetRepositoryContributorAdded() *PayloadRepositoryContributorAdded {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorAdded); ok {
			return x.RepositoryContributorAdded
		}
	}
	return nil
}

func (x *Event) GetRepositoryContributorRoleChanged() *PayloadRepositoryContributorRoleChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRoleChanged); ok {
			return x.RepositoryContributorRoleChanged
		}
	}
	return nil
}

func (x *Event) GetRepositoryContributorRolesChanged() *PayloadRepositoryContributorRolesChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRolesChanged); ok {
			return x.RepositoryContributorRolesChanged
		}
	}
	return nil
}

func (x *Event) GetRepositoryContributorRemoved() *PayloadRepositoryContributorRemoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRemoved); ok {
			return x.RepositoryContributorRemoved
		}
	}
	return nil
}

func (x *Event) GetRepositoryVisibilityChanged() *PayloadRepositoryVisibilityChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryVisibilityChanged); ok {
			return x.RepositoryVisibilityChanged
		}
	}
	return nil
}

func (x *Event) GetRepositoryDefaultLabelNameChanged() *PayloadRepositoryDefaultLabelNameChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultLabelNameChanged); ok {
			return x.RepositoryDefaultLabelNameChanged
		}
	}
	return nil
}

func (x *Event) GetRepositoryIdpGroupAdded() *PayloadRepositoryIDPGroupAdded {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryIdpGroupAdded); ok {
			return x.RepositoryIdpGroupAdded
		}
	}
	return nil
}

func (x *Event) GetRepositoryIdpGroupUpdated() *PayloadRepositoryIDPGroupUpdated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryIdpGroupUpdated); ok {
			return x.RepositoryIdpGroupUpdated
		}
	}
	return nil
}

func (x *Event) GetRepositoryIdpGroupRemoved() *PayloadRepositoryIDPGroupRemoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryIdpGroupRemoved); ok {
			return x.RepositoryIdpGroupRemoved
		}
	}
	return nil
}

func (x *Event) GetPolicyCreated() *PayloadPolicyCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyCreated); ok {
			return x.PolicyCreated
		}
	}
	return nil
}

func (x *Event) GetPolicyDeleted() *PayloadPolicyDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyDeleted); ok {
			return x.PolicyDeleted
		}
	}
	return nil
}

func (x *Event) GetPolicyDeprecated() *PayloadPolicyDeprecated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyDeprecated); ok {
			return x.PolicyDeprecated
		}
	}
	return nil
}

func (x *Event) GetPolicyUndeprecated() *PayloadPolicyUndeprecated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyUndeprecated); ok {
			return x.PolicyUndeprecated
		}
	}
	return nil
}

func (x *Event) GetPolicyVisibilityChanged() *PayloadPolicyVisibilityChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyVisibilityChanged); ok {
			return x.PolicyVisibilityChanged
		}
	}
	return nil
}

func (x *Event) GetPolicyCommitPushed() *PayloadPolicyCommitPushed {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyCommitPushed); ok {
			return x.PolicyCommitPushed
		}
	}
	return nil
}

func (x *Event) GetPolicyLabelCreated() *PayloadPolicyLabelCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyLabelCreated); ok {
			return x.PolicyLabelCreated
		}
	}
	return nil
}

func (x *Event) GetPolicyLabelMoved() *PayloadPolicyLabelMoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyLabelMoved); ok {
			return x.PolicyLabelMoved
		}
	}
	return nil
}

func (x *Event) GetPolicyLabelArchived() *PayloadPolicyLabelArchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyLabelArchived); ok {
			return x.PolicyLabelArchived
		}
	}
	return nil
}

func (x *Event) GetPolicyLabelUnarchived() *PayloadPolicyLabelUnarchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PolicyLabelUnarchived); ok {
			return x.PolicyLabelUnarchived
		}
	}
	return nil
}

func (x *Event) GetPluginCreated() *PayloadPluginCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginCreated); ok {
			return x.PluginCreated
		}
	}
	return nil
}

func (x *Event) GetPluginDeleted() *PayloadPluginDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginDeleted); ok {
			return x.PluginDeleted
		}
	}
	return nil
}

func (x *Event) GetPluginDeprecated() *PayloadPluginDeprecated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginDeprecated); ok {
			return x.PluginDeprecated
		}
	}
	return nil
}

func (x *Event) GetPluginUndeprecated() *PayloadPluginUndeprecated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginUndeprecated); ok {
			return x.PluginUndeprecated
		}
	}
	return nil
}

func (x *Event) GetPluginVisibilityChanged() *PayloadPluginVisibilityChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginVisibilityChanged); ok {
			return x.PluginVisibilityChanged
		}
	}
	return nil
}

func (x *Event) GetPluginCommitPushed() *PayloadPluginCommitPushed {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginCommitPushed); ok {
			return x.PluginCommitPushed
		}
	}
	return nil
}

func (x *Event) GetUserCreated() *PayloadUserCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserCreated); ok {
			return x.UserCreated
		}
	}
	return nil
}

func (x *Event) GetUserDeactivated() *PayloadUserDeactivated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserDeactivated); ok {
			return x.UserDeactivated
		}
	}
	return nil
}

func (x *Event) GetUserDeleted() *PayloadUserDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserDeleted); ok {
			return x.UserDeleted
		}
	}
	return nil
}

func (x *Event) GetUserLoggedIn() *PayloadUserLoggedIn {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserLoggedIn); ok {
			return x.UserLoggedIn
		}
	}
	return nil
}

func (x *Event) GetUserLoggedOut() *PayloadUserLoggedOut {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserLoggedOut); ok {
			return x.UserLoggedOut
		}
	}
	return nil
}

func (x *Event) GetCuratedPluginCreated() *PayloadCuratedPluginCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_CuratedPluginCreated); ok {
			return x.CuratedPluginCreated
		}
	}
	return nil
}

func (x *Event) GetIdpGroupAdded() *PayloadOrganizationIDPGroupAdded {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_IdpGroupAdded); ok {
			return x.IdpGroupAdded
		}
	}
	return nil
}

func (x *Event) GetIdpGroupUpdated() *PayloadOrganizationIDPGroupUpdated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_IdpGroupUpdated); ok {
			return x.IdpGroupUpdated
		}
	}
	return nil
}

func (x *Event) GetIdpGroupRemoved() *PayloadOrganizationIDPGroupRemoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_IdpGroupRemoved); ok {
			return x.IdpGroupRemoved
		}
	}
	return nil
}

func (x *Event) GetTokenCreated() *PayloadTokenCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_TokenCreated); ok {
			return x.TokenCreated
		}
	}
	return nil
}

func (x *Event) GetTokenDeleted() *PayloadTokenDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_TokenDeleted); ok {
			return x.TokenDeleted
		}
	}
	return nil
}

func (x *Event) GetUserReactivated() *PayloadUserReactivated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserReactivated); ok {
			return x.UserReactivated
		}
	}
	return nil
}

func (x *Event) GetScimTokenCreated() *PayloadSCIMTokenCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_ScimTokenCreated); ok {
			return x.ScimTokenCreated
		}
	}
	return nil
}

func (x *Event) GetScimTokenDeleted() *PayloadSCIMTokenDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_ScimTokenDeleted); ok {
			return x.ScimTokenDeleted
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) GetRepositoryCommitDeleted() *PayloadRepositoryCommitDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitDeleted); ok {
			return x.RepositoryCommitDeleted
		}
	}
	return nil
}

func (x *Event) GetRepositoryLabelCreated() *PayloadRepositoryLabelCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelCreated); ok {
			return x.RepositoryLabelCreated
		}
	}
	return nil
}

func (x *Event) GetRepositoryLabelMoved() *PayloadRepositoryLabelMoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelMoved); ok {
			return x.RepositoryLabelMoved
		}
	}
	return nil
}

func (x *Event) GetRepositoryLabelArchived() *PayloadRepositoryLabelArchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelArchived); ok {
			return x.RepositoryLabelArchived
		}
	}
	return nil
}

func (x *Event) GetRepositoryLabelUnarchived() *PayloadRepositoryLabelUnarchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelUnarchived); ok {
			return x.RepositoryLabelUnarchived
		}
	}
	return nil
}

func (x *Event) GetCuratedPluginDeleted() *PayloadCuratedPluginDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_CuratedPluginDeleted); ok {
			return x.CuratedPluginDeleted
		}
	}
	return nil
}

func (x *Event) GetPayloadServerBreakingChangePolicyEnabled() *PayloadServerBreakingChangePolicyEnabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyEnabled); ok {
			return x.PayloadServerBreakingChangePolicyEnabled
		}
	}
	return nil
}

func (x *Event) GetPayloadServerBreakingChangePolicyDisabled() *PayloadServerBreakingChangePolicyDisabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyDisabled); ok {
			return x.PayloadServerBreakingChangePolicyDisabled
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) GetRepositoryDefaultBranchChanged() *PayloadRepositoryDefaultBranchChanged {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultBranchChanged); ok {
			return x.RepositoryDefaultBranchChanged
		}
	}
	return nil
}

func (x *Event) GetPayloadServerUniquenessPolicyEnabled() *PayloadServerUniquenessPolicyEnabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyEnabled); ok {
			return x.PayloadServerUniquenessPolicyEnabled
		}
	}
	return nil
}

func (x *Event) GetPayloadServerUniquenessPolicyDisabled() *PayloadServerUniquenessPolicyDisabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyDisabled); ok {
			return x.PayloadServerUniquenessPolicyDisabled
		}
	}
	return nil
}

func (x *Event) GetUserAutoMergedFromNewIdp() *PayloadUserAutoMergedFromNewIdP {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_UserAutoMergedFromNewIdp); ok {
			return x.UserAutoMergedFromNewIdp
		}
	}
	return nil
}

func (x *Event) GetDeviceAuthorizationGrantApproved() *PayloadDeviceAuthorizationGrantApproved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantApproved); ok {
			return x.DeviceAuthorizationGrantApproved
		}
	}
	return nil
}

func (x *Event) GetDeviceAuthorizationGrantDenied() *PayloadDeviceAuthorizationGrantDenied {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantDenied); ok {
			return x.DeviceAuthorizationGrantDenied
		}
	}
	return nil
}

func (x *Event) GetPluginLabelCreated() *PayloadPluginLabelCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginLabelCreated); ok {
			return x.PluginLabelCreated
		}
	}
	return nil
}

func (x *Event) GetPluginLabelMoved() *PayloadPluginLabelMoved {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginLabelMoved); ok {
			return x.PluginLabelMoved
		}
	}
	return nil
}

func (x *Event) GetPluginLabelArchived() *PayloadPluginLabelArchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginLabelArchived); ok {
			return x.PluginLabelArchived
		}
	}
	return nil
}

func (x *Event) GetPluginLabelUnarchived() *PayloadPluginLabelUnarchived {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_PluginLabelUnarchived); ok {
			return x.PluginLabelUnarchived
		}
	}
	return nil
}

func (x *Event) GetServerReviewFlowEnabled() *PayloadServerReviewFlowEnabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_ServerReviewFlowEnabled); ok {
			return x.ServerReviewFlowEnabled
		}
	}
	return nil
}

func (x *Event) GetServerReviewFlowDisabled() *PayloadServerReviewFlowDisabled {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_ServerReviewFlowDisabled); ok {
			return x.ServerReviewFlowDisabled
		}
	}
	return nil
}

func (x *Event) GetSdkPluginConstraintCreated() *PayloadSDKPluginConstraintCreated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_SdkPluginConstraintCreated); ok {
			return x.SdkPluginConstraintCreated
		}
	}
	return nil
}

func (x *Event) GetSdkPluginConstraintUpdated() *PayloadSDKPluginConstraintUpdated {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_SdkPluginConstraintUpdated); ok {
			return x.SdkPluginConstraintUpdated
		}
	}
	return nil
}

func (x *Event) GetSdkPluginConstraintDeleted() *PayloadSDKPluginConstraintDeleted {
	if x != nil {
		if x, ok := x.xxx_hidden_Payload.(*event_SdkPluginConstraintDeleted); ok {
			return x.SdkPluginConstraintDeleted
		}
	}
	return nil
}

func (x *Event) SetEventId(v string) {
	x.xxx_hidden_EventId = v
}

func (x *Event) SetType(v EventType) {
	x.xxx_hidden_Type = v
}

func (x *Event) SetActor(v *Actor) {
	x.xxx_hidden_Actor = v
}

func (x *Event) SetResource(v *Resource) {
	x.xxx_hidden_Resource = v
}

func (x *Event) SetEventTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_EventTime = v
}

func (x *Event) SetMetadata(v *EventMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *Event) SetOrganizationCreated(v *PayloadOrganizationCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationCreated{v}
}

func (x *Event) SetOrganizationDeleted(v *PayloadOrganizationDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationDeleted{v}
}

func (x *Event) SetOrganizationMemberAdded(v *PayloadOrganizationMemberAdded) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationMemberAdded{v}
}

func (x *Event) SetOrganizationMemberRoleChanged(v *PayloadOrganizationMemberRoleChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationMemberRoleChanged{v}
}

func (x *Event) SetOrganizationMemberRolesChanged(v *PayloadOrganizationMemberRolesChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationMemberRolesChanged{v}
}

func (x *Event) SetOrganizationMemberRemoved(v *PayloadOrganizationMemberRemoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_OrganizationMemberRemoved{v}
}

func (x *Event) SetRepositoryCreated(v *PayloadRepositoryCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryCreated{v}
}

func (x *Event) SetRepositoryDeprecated(v *PayloadRepositoryDeprecated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryDeprecated{v}
}

func (x *Event) SetRepositoryUndeprecated(v *PayloadRepositoryUndeprecated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryUndeprecated{v}
}

func (x *Event) SetRepositoryDeleted(v *PayloadRepositoryDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryDeleted{v}
}

func (x *Event) SetRepositoryCommitPushed(v *PayloadRepositoryCommitPushed) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryCommitPushed{v}
}

func (x *Event) SetRepositoryContributorAdded(v *PayloadRepositoryContributorAdded) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryContributorAdded{v}
}

func (x *Event) SetRepositoryContributorRoleChanged(v *PayloadRepositoryContributorRoleChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryContributorRoleChanged{v}
}

func (x *Event) SetRepositoryContributorRolesChanged(v *PayloadRepositoryContributorRolesChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryContributorRolesChanged{v}
}

func (x *Event) SetRepositoryContributorRemoved(v *PayloadRepositoryContributorRemoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryContributorRemoved{v}
}

func (x *Event) SetRepositoryVisibilityChanged(v *PayloadRepositoryVisibilityChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryVisibilityChanged{v}
}

func (x *Event) SetRepositoryDefaultLabelNameChanged(v *PayloadRepositoryDefaultLabelNameChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryDefaultLabelNameChanged{v}
}

func (x *Event) SetRepositoryIdpGroupAdded(v *PayloadRepositoryIDPGroupAdded) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryIdpGroupAdded{v}
}

func (x *Event) SetRepositoryIdpGroupUpdated(v *PayloadRepositoryIDPGroupUpdated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryIdpGroupUpdated{v}
}

func (x *Event) SetRepositoryIdpGroupRemoved(v *PayloadRepositoryIDPGroupRemoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryIdpGroupRemoved{v}
}

func (x *Event) SetPolicyCreated(v *PayloadPolicyCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyCreated{v}
}

func (x *Event) SetPolicyDeleted(v *PayloadPolicyDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyDeleted{v}
}

func (x *Event) SetPolicyDeprecated(v *PayloadPolicyDeprecated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyDeprecated{v}
}

func (x *Event) SetPolicyUndeprecated(v *PayloadPolicyUndeprecated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyUndeprecated{v}
}

func (x *Event) SetPolicyVisibilityChanged(v *PayloadPolicyVisibilityChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyVisibilityChanged{v}
}

func (x *Event) SetPolicyCommitPushed(v *PayloadPolicyCommitPushed) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyCommitPushed{v}
}

func (x *Event) SetPolicyLabelCreated(v *PayloadPolicyLabelCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyLabelCreated{v}
}

func (x *Event) SetPolicyLabelMoved(v *PayloadPolicyLabelMoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyLabelMoved{v}
}

func (x *Event) SetPolicyLabelArchived(v *PayloadPolicyLabelArchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyLabelArchived{v}
}

func (x *Event) SetPolicyLabelUnarchived(v *PayloadPolicyLabelUnarchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PolicyLabelUnarchived{v}
}

func (x *Event) SetPluginCreated(v *PayloadPluginCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginCreated{v}
}

func (x *Event) SetPluginDeleted(v *PayloadPluginDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginDeleted{v}
}

func (x *Event) SetPluginDeprecated(v *PayloadPluginDeprecated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginDeprecated{v}
}

func (x *Event) SetPluginUndeprecated(v *PayloadPluginUndeprecated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginUndeprecated{v}
}

func (x *Event) SetPluginVisibilityChanged(v *PayloadPluginVisibilityChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginVisibilityChanged{v}
}

func (x *Event) SetPluginCommitPushed(v *PayloadPluginCommitPushed) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginCommitPushed{v}
}

func (x *Event) SetUserCreated(v *PayloadUserCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserCreated{v}
}

func (x *Event) SetUserDeactivated(v *PayloadUserDeactivated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserDeactivated{v}
}

func (x *Event) SetUserDeleted(v *PayloadUserDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserDeleted{v}
}

func (x *Event) SetUserLoggedIn(v *PayloadUserLoggedIn) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserLoggedIn{v}
}

func (x *Event) SetUserLoggedOut(v *PayloadUserLoggedOut) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserLoggedOut{v}
}

func (x *Event) SetCuratedPluginCreated(v *PayloadCuratedPluginCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_CuratedPluginCreated{v}
}

func (x *Event) SetIdpGroupAdded(v *PayloadOrganizationIDPGroupAdded) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_IdpGroupAdded{v}
}

func (x *Event) SetIdpGroupUpdated(v *PayloadOrganizationIDPGroupUpdated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_IdpGroupUpdated{v}
}

func (x *Event) SetIdpGroupRemoved(v *PayloadOrganizationIDPGroupRemoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_IdpGroupRemoved{v}
}

func (x *Event) SetTokenCreated(v *PayloadTokenCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_TokenCreated{v}
}

func (x *Event) SetTokenDeleted(v *PayloadTokenDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_TokenDeleted{v}
}

func (x *Event) SetUserReactivated(v *PayloadUserReactivated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserReactivated{v}
}

func (x *Event) SetScimTokenCreated(v *PayloadSCIMTokenCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_ScimTokenCreated{v}
}

func (x *Event) SetScimTokenDeleted(v *PayloadSCIMTokenDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_ScimTokenDeleted{v}
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) SetRepositoryCommitDeleted(v *PayloadRepositoryCommitDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryCommitDeleted{v}
}

func (x *Event) SetRepositoryLabelCreated(v *PayloadRepositoryLabelCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryLabelCreated{v}
}

func (x *Event) SetRepositoryLabelMoved(v *PayloadRepositoryLabelMoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryLabelMoved{v}
}

func (x *Event) SetRepositoryLabelArchived(v *PayloadRepositoryLabelArchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryLabelArchived{v}
}

func (x *Event) SetRepositoryLabelUnarchived(v *PayloadRepositoryLabelUnarchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryLabelUnarchived{v}
}

func (x *Event) SetCuratedPluginDeleted(v *PayloadCuratedPluginDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_CuratedPluginDeleted{v}
}

func (x *Event) SetPayloadServerBreakingChangePolicyEnabled(v *PayloadServerBreakingChangePolicyEnabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PayloadServerBreakingChangePolicyEnabled{v}
}

func (x *Event) SetPayloadServerBreakingChangePolicyDisabled(v *PayloadServerBreakingChangePolicyDisabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PayloadServerBreakingChangePolicyDisabled{v}
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) SetRepositoryDefaultBranchChanged(v *PayloadRepositoryDefaultBranchChanged) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_RepositoryDefaultBranchChanged{v}
}

func (x *Event) SetPayloadServerUniquenessPolicyEnabled(v *PayloadServerUniquenessPolicyEnabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PayloadServerUniquenessPolicyEnabled{v}
}

func (x *Event) SetPayloadServerUniquenessPolicyDisabled(v *PayloadServerUniquenessPolicyDisabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PayloadServerUniquenessPolicyDisabled{v}
}

func (x *Event) SetUserAutoMergedFromNewIdp(v *PayloadUserAutoMergedFromNewIdP) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_UserAutoMergedFromNewIdp{v}
}

func (x *Event) SetDeviceAuthorizationGrantApproved(v *PayloadDeviceAuthorizationGrantApproved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_DeviceAuthorizationGrantApproved{v}
}

func (x *Event) SetDeviceAuthorizationGrantDenied(v *PayloadDeviceAuthorizationGrantDenied) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_DeviceAuthorizationGrantDenied{v}
}

func (x *Event) SetPluginLabelCreated(v *PayloadPluginLabelCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginLabelCreated{v}
}

func (x *Event) SetPluginLabelMoved(v *PayloadPluginLabelMoved) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginLabelMoved{v}
}

func (x *Event) SetPluginLabelArchived(v *PayloadPluginLabelArchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginLabelArchived{v}
}

func (x *Event) SetPluginLabelUnarchived(v *PayloadPluginLabelUnarchived) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_PluginLabelUnarchived{v}
}

func (x *Event) SetServerReviewFlowEnabled(v *PayloadServerReviewFlowEnabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_ServerReviewFlowEnabled{v}
}

func (x *Event) SetServerReviewFlowDisabled(v *PayloadServerReviewFlowDisabled) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_ServerReviewFlowDisabled{v}
}

func (x *Event) SetSdkPluginConstraintCreated(v *PayloadSDKPluginConstraintCreated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_SdkPluginConstraintCreated{v}
}

func (x *Event) SetSdkPluginConstraintUpdated(v *PayloadSDKPluginConstraintUpdated) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_SdkPluginConstraintUpdated{v}
}

func (x *Event) SetSdkPluginConstraintDeleted(v *PayloadSDKPluginConstraintDeleted) {
	if v == nil {
		x.xxx_hidden_Payload = nil
		return
	}
	x.xxx_hidden_Payload = &event_SdkPluginConstraintDeleted{v}
}

func (x *Event) HasActor() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Actor != nil
}

func (x *Event) HasResource() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Resource != nil
}

func (x *Event) HasEventTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_EventTime != nil
}

func (x *Event) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *Event) HasPayload() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Payload != nil
}

func (x *Event) HasOrganizationCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationCreated)
	return ok
}

func (x *Event) HasOrganizationDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationDeleted)
	return ok
}

func (x *Event) HasOrganizationMemberAdded() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberAdded)
	return ok
}

func (x *Event) HasOrganizationMemberRoleChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRoleChanged)
	return ok
}

func (x *Event) HasOrganizationMemberRolesChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRolesChanged)
	return ok
}

func (x *Event) HasOrganizationMemberRemoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRemoved)
	return ok
}

func (x *Event) HasRepositoryCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryCreated)
	return ok
}

func (x *Event) HasRepositoryDeprecated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryDeprecated)
	return ok
}

func (x *Event) HasRepositoryUndeprecated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryUndeprecated)
	return ok
}

func (x *Event) HasRepositoryDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryDeleted)
	return ok
}

func (x *Event) HasRepositoryCommitPushed() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitPushed)
	return ok
}

func (x *Event) HasRepositoryContributorAdded() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorAdded)
	return ok
}

func (x *Event) HasRepositoryContributorRoleChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRoleChanged)
	return ok
}

func (x *Event) HasRepositoryContributorRolesChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRolesChanged)
	return ok
}

func (x *Event) HasRepositoryContributorRemoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRemoved)
	return ok
}

func (x *Event) HasRepositoryVisibilityChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryVisibilityChanged)
	return ok
}

func (x *Event) HasRepositoryDefaultLabelNameChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultLabelNameChanged)
	return ok
}

func (x *Event) HasRepositoryIdpGroupAdded() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryIdpGroupAdded)
	return ok
}

func (x *Event) HasRepositoryIdpGroupUpdated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryIdpGroupUpdated)
	return ok
}

func (x *Event) HasRepositoryIdpGroupRemoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryIdpGroupRemoved)
	return ok
}

func (x *Event) HasPolicyCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyCreated)
	return ok
}

func (x *Event) HasPolicyDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyDeleted)
	return ok
}

func (x *Event) HasPolicyDeprecated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyDeprecated)
	return ok
}

func (x *Event) HasPolicyUndeprecated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyUndeprecated)
	return ok
}

func (x *Event) HasPolicyVisibilityChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyVisibilityChanged)
	return ok
}

func (x *Event) HasPolicyCommitPushed() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyCommitPushed)
	return ok
}

func (x *Event) HasPolicyLabelCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyLabelCreated)
	return ok
}

func (x *Event) HasPolicyLabelMoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyLabelMoved)
	return ok
}

func (x *Event) HasPolicyLabelArchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyLabelArchived)
	return ok
}

func (x *Event) HasPolicyLabelUnarchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PolicyLabelUnarchived)
	return ok
}

func (x *Event) HasPluginCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginCreated)
	return ok
}

func (x *Event) HasPluginDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginDeleted)
	return ok
}

func (x *Event) HasPluginDeprecated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginDeprecated)
	return ok
}

func (x *Event) HasPluginUndeprecated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginUndeprecated)
	return ok
}

func (x *Event) HasPluginVisibilityChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginVisibilityChanged)
	return ok
}

func (x *Event) HasPluginCommitPushed() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginCommitPushed)
	return ok
}

func (x *Event) HasUserCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserCreated)
	return ok
}

func (x *Event) HasUserDeactivated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserDeactivated)
	return ok
}

func (x *Event) HasUserDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserDeleted)
	return ok
}

func (x *Event) HasUserLoggedIn() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserLoggedIn)
	return ok
}

func (x *Event) HasUserLoggedOut() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserLoggedOut)
	return ok
}

func (x *Event) HasCuratedPluginCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_CuratedPluginCreated)
	return ok
}

func (x *Event) HasIdpGroupAdded() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_IdpGroupAdded)
	return ok
}

func (x *Event) HasIdpGroupUpdated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_IdpGroupUpdated)
	return ok
}

func (x *Event) HasIdpGroupRemoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_IdpGroupRemoved)
	return ok
}

func (x *Event) HasTokenCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_TokenCreated)
	return ok
}

func (x *Event) HasTokenDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_TokenDeleted)
	return ok
}

func (x *Event) HasUserReactivated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserReactivated)
	return ok
}

func (x *Event) HasScimTokenCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_ScimTokenCreated)
	return ok
}

func (x *Event) HasScimTokenDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_ScimTokenDeleted)
	return ok
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) HasRepositoryCommitDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitDeleted)
	return ok
}

func (x *Event) HasRepositoryLabelCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelCreated)
	return ok
}

func (x *Event) HasRepositoryLabelMoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelMoved)
	return ok
}

func (x *Event) HasRepositoryLabelArchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelArchived)
	return ok
}

func (x *Event) HasRepositoryLabelUnarchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelUnarchived)
	return ok
}

func (x *Event) HasCuratedPluginDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_CuratedPluginDeleted)
	return ok
}

func (x *Event) HasPayloadServerBreakingChangePolicyEnabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyEnabled)
	return ok
}

func (x *Event) HasPayloadServerBreakingChangePolicyDisabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyDisabled)
	return ok
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) HasRepositoryDefaultBranchChanged() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultBranchChanged)
	return ok
}

func (x *Event) HasPayloadServerUniquenessPolicyEnabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyEnabled)
	return ok
}

func (x *Event) HasPayloadServerUniquenessPolicyDisabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyDisabled)
	return ok
}

func (x *Event) HasUserAutoMergedFromNewIdp() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_UserAutoMergedFromNewIdp)
	return ok
}

func (x *Event) HasDeviceAuthorizationGrantApproved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantApproved)
	return ok
}

func (x *Event) HasDeviceAuthorizationGrantDenied() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantDenied)
	return ok
}

func (x *Event) HasPluginLabelCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginLabelCreated)
	return ok
}

func (x *Event) HasPluginLabelMoved() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginLabelMoved)
	return ok
}

func (x *Event) HasPluginLabelArchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginLabelArchived)
	return ok
}

func (x *Event) HasPluginLabelUnarchived() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_PluginLabelUnarchived)
	return ok
}

func (x *Event) HasServerReviewFlowEnabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_ServerReviewFlowEnabled)
	return ok
}

func (x *Event) HasServerReviewFlowDisabled() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_ServerReviewFlowDisabled)
	return ok
}

func (x *Event) HasSdkPluginConstraintCreated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_SdkPluginConstraintCreated)
	return ok
}

func (x *Event) HasSdkPluginConstraintUpdated() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_SdkPluginConstraintUpdated)
	return ok
}

func (x *Event) HasSdkPluginConstraintDeleted() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Payload.(*event_SdkPluginConstraintDeleted)
	return ok
}

func (x *Event) ClearActor() {
	x.xxx_hidden_Actor = nil
}

func (x *Event) ClearResource() {
	x.xxx_hidden_Resource = nil
}

func (x *Event) ClearEventTime() {
	x.xxx_hidden_EventTime = nil
}

func (x *Event) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

func (x *Event) ClearPayload() {
	x.xxx_hidden_Payload = nil
}

func (x *Event) ClearOrganizationCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearOrganizationDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearOrganizationMemberAdded() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberAdded); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearOrganizationMemberRoleChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRoleChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearOrganizationMemberRolesChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRolesChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearOrganizationMemberRemoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_OrganizationMemberRemoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryDeprecated() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryDeprecated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryUndeprecated() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryUndeprecated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryCommitPushed() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitPushed); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryContributorAdded() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorAdded); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryContributorRoleChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRoleChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryContributorRolesChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRolesChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryContributorRemoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryContributorRemoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryVisibilityChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryVisibilityChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryDefaultLabelNameChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultLabelNameChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryIdpGroupAdded() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryIdpGroupAdded); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryIdpGroupUpdated() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryIdpGroupUpdated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryIdpGroupRemoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryIdpGroupRemoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyDeprecated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyDeprecated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyUndeprecated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyUndeprecated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyVisibilityChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyVisibilityChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyCommitPushed() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyCommitPushed); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyLabelCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyLabelCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyLabelMoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyLabelMoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyLabelArchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyLabelArchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPolicyLabelUnarchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_PolicyLabelUnarchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginDeprecated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginDeprecated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginUndeprecated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginUndeprecated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginVisibilityChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginVisibilityChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginCommitPushed() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginCommitPushed); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserDeactivated() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserDeactivated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserLoggedIn() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserLoggedIn); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserLoggedOut() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserLoggedOut); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearCuratedPluginCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_CuratedPluginCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearIdpGroupAdded() {
	if _, ok := x.xxx_hidden_Payload.(*event_IdpGroupAdded); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearIdpGroupUpdated() {
	if _, ok := x.xxx_hidden_Payload.(*event_IdpGroupUpdated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearIdpGroupRemoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_IdpGroupRemoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearTokenCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_TokenCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearTokenDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_TokenDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserReactivated() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserReactivated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearScimTokenCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_ScimTokenCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearScimTokenDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_ScimTokenDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) ClearRepositoryCommitDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryCommitDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryLabelCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryLabelMoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelMoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryLabelArchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelArchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearRepositoryLabelUnarchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryLabelUnarchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearCuratedPluginDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_CuratedPluginDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPayloadServerBreakingChangePolicyEnabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyEnabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPayloadServerBreakingChangePolicyDisabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_PayloadServerBreakingChangePolicyDisabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *Event) ClearRepositoryDefaultBranchChanged() {
	if _, ok := x.xxx_hidden_Payload.(*event_RepositoryDefaultBranchChanged); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPayloadServerUniquenessPolicyEnabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyEnabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPayloadServerUniquenessPolicyDisabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_PayloadServerUniquenessPolicyDisabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearUserAutoMergedFromNewIdp() {
	if _, ok := x.xxx_hidden_Payload.(*event_UserAutoMergedFromNewIdp); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearDeviceAuthorizationGrantApproved() {
	if _, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantApproved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearDeviceAuthorizationGrantDenied() {
	if _, ok := x.xxx_hidden_Payload.(*event_DeviceAuthorizationGrantDenied); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginLabelCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginLabelCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginLabelMoved() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginLabelMoved); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginLabelArchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginLabelArchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearPluginLabelUnarchived() {
	if _, ok := x.xxx_hidden_Payload.(*event_PluginLabelUnarchived); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearServerReviewFlowEnabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_ServerReviewFlowEnabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearServerReviewFlowDisabled() {
	if _, ok := x.xxx_hidden_Payload.(*event_ServerReviewFlowDisabled); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearSdkPluginConstraintCreated() {
	if _, ok := x.xxx_hidden_Payload.(*event_SdkPluginConstraintCreated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearSdkPluginConstraintUpdated() {
	if _, ok := x.xxx_hidden_Payload.(*event_SdkPluginConstraintUpdated); ok {
		x.xxx_hidden_Payload = nil
	}
}

func (x *Event) ClearSdkPluginConstraintDeleted() {
	if _, ok := x.xxx_hidden_Payload.(*event_SdkPluginConstraintDeleted); ok {
		x.xxx_hidden_Payload = nil
	}
}

const Event_Payload_not_set_case case_Event_Payload = 0
const Event_OrganizationCreated_case case_Event_Payload = 7
const Event_OrganizationDeleted_case case_Event_Payload = 8
const Event_OrganizationMemberAdded_case case_Event_Payload = 9
const Event_OrganizationMemberRoleChanged_case case_Event_Payload = 10
const Event_OrganizationMemberRolesChanged_case case_Event_Payload = 56
const Event_OrganizationMemberRemoved_case case_Event_Payload = 11
const Event_RepositoryCreated_case case_Event_Payload = 12
const Event_RepositoryDeprecated_case case_Event_Payload = 54
const Event_RepositoryUndeprecated_case case_Event_Payload = 55
const Event_RepositoryDeleted_case case_Event_Payload = 13
const Event_RepositoryCommitPushed_case case_Event_Payload = 14
const Event_RepositoryContributorAdded_case case_Event_Payload = 15
const Event_RepositoryContributorRoleChanged_case case_Event_Payload = 16
const Event_RepositoryContributorRolesChanged_case case_Event_Payload = 69
const Event_RepositoryContributorRemoved_case case_Event_Payload = 17
const Event_RepositoryVisibilityChanged_case case_Event_Payload = 18
const Event_RepositoryDefaultLabelNameChanged_case case_Event_Payload = 46
const Event_RepositoryIdpGroupAdded_case case_Event_Payload = 66
const Event_RepositoryIdpGroupUpdated_case case_Event_Payload = 67
const Event_RepositoryIdpGroupRemoved_case case_Event_Payload = 68
const Event_PolicyCreated_case case_Event_Payload = 60
const Event_PolicyDeleted_case case_Event_Payload = 61
const Event_PolicyDeprecated_case case_Event_Payload = 62
const Event_PolicyUndeprecated_case case_Event_Payload = 63
const Event_PolicyVisibilityChanged_case case_Event_Payload = 64
const Event_PolicyCommitPushed_case case_Event_Payload = 70
const Event_PolicyLabelCreated_case case_Event_Payload = 71
const Event_PolicyLabelMoved_case case_Event_Payload = 72
const Event_PolicyLabelArchived_case case_Event_Payload = 73
const Event_PolicyLabelUnarchived_case case_Event_Payload = 74
const Event_PluginCreated_case case_Event_Payload = 19
const Event_PluginDeleted_case case_Event_Payload = 20
const Event_PluginDeprecated_case case_Event_Payload = 57
const Event_PluginUndeprecated_case case_Event_Payload = 58
const Event_PluginVisibilityChanged_case case_Event_Payload = 59
const Event_PluginCommitPushed_case case_Event_Payload = 49
const Event_UserCreated_case case_Event_Payload = 21
const Event_UserDeactivated_case case_Event_Payload = 22
const Event_UserDeleted_case case_Event_Payload = 23
const Event_UserLoggedIn_case case_Event_Payload = 24
const Event_UserLoggedOut_case case_Event_Payload = 25
const Event_CuratedPluginCreated_case case_Event_Payload = 26
const Event_IdpGroupAdded_case case_Event_Payload = 27
const Event_IdpGroupUpdated_case case_Event_Payload = 65
const Event_IdpGroupRemoved_case case_Event_Payload = 28
const Event_TokenCreated_case case_Event_Payload = 29
const Event_TokenDeleted_case case_Event_Payload = 30
const Event_UserReactivated_case case_Event_Payload = 31
const Event_ScimTokenCreated_case case_Event_Payload = 32
const Event_ScimTokenDeleted_case case_Event_Payload = 33
const Event_RepositoryCommitDeleted_case case_Event_Payload = 34
const Event_RepositoryLabelCreated_case case_Event_Payload = 35
const Event_RepositoryLabelMoved_case case_Event_Payload = 36
const Event_RepositoryLabelArchived_case case_Event_Payload = 44
const Event_RepositoryLabelUnarchived_case case_Event_Payload = 45
const Event_CuratedPluginDeleted_case case_Event_Payload = 37
const Event_PayloadServerBreakingChangePolicyEnabled_case case_Event_Payload = 38
const Event_PayloadServerBreakingChangePolicyDisabled_case case_Event_Payload = 39
const Event_RepositoryDefaultBranchChanged_case case_Event_Payload = 40
const Event_PayloadServerUniquenessPolicyEnabled_case case_Event_Payload = 41
const Event_PayloadServerUniquenessPolicyDisabled_case case_Event_Payload = 42
const Event_UserAutoMergedFromNewIdp_case case_Event_Payload = 43
const Event_DeviceAuthorizationGrantApproved_case case_Event_Payload = 47
const Event_DeviceAuthorizationGrantDenied_case case_Event_Payload = 48
const Event_PluginLabelCreated_case case_Event_Payload = 50
const Event_PluginLabelMoved_case case_Event_Payload = 51
const Event_PluginLabelArchived_case case_Event_Payload = 52
const Event_PluginLabelUnarchived_case case_Event_Payload = 53
const Event_ServerReviewFlowEnabled_case case_Event_Payload = 75
const Event_ServerReviewFlowDisabled_case case_Event_Payload = 76
const Event_SdkPluginConstraintCreated_case case_Event_Payload = 77
const Event_SdkPluginConstraintUpdated_case case_Event_Payload = 78
const Event_SdkPluginConstraintDeleted_case case_Event_Payload = 79

func (x *Event) WhichPayload() case_Event_Payload {
	if x == nil {
		return Event_Payload_not_set_case
	}
	switch x.xxx_hidden_Payload.(type) {
	case *event_OrganizationCreated:
		return Event_OrganizationCreated_case
	case *event_OrganizationDeleted:
		return Event_OrganizationDeleted_case
	case *event_OrganizationMemberAdded:
		return Event_OrganizationMemberAdded_case
	case *event_OrganizationMemberRoleChanged:
		return Event_OrganizationMemberRoleChanged_case
	case *event_OrganizationMemberRolesChanged:
		return Event_OrganizationMemberRolesChanged_case
	case *event_OrganizationMemberRemoved:
		return Event_OrganizationMemberRemoved_case
	case *event_RepositoryCreated:
		return Event_RepositoryCreated_case
	case *event_RepositoryDeprecated:
		return Event_RepositoryDeprecated_case
	case *event_RepositoryUndeprecated:
		return Event_RepositoryUndeprecated_case
	case *event_RepositoryDeleted:
		return Event_RepositoryDeleted_case
	case *event_RepositoryCommitPushed:
		return Event_RepositoryCommitPushed_case
	case *event_RepositoryContributorAdded:
		return Event_RepositoryContributorAdded_case
	case *event_RepositoryContributorRoleChanged:
		return Event_RepositoryContributorRoleChanged_case
	case *event_RepositoryContributorRolesChanged:
		return Event_RepositoryContributorRolesChanged_case
	case *event_RepositoryContributorRemoved:
		return Event_RepositoryContributorRemoved_case
	case *event_RepositoryVisibilityChanged:
		return Event_RepositoryVisibilityChanged_case
	case *event_RepositoryDefaultLabelNameChanged:
		return Event_RepositoryDefaultLabelNameChanged_case
	case *event_RepositoryIdpGroupAdded:
		return Event_RepositoryIdpGroupAdded_case
	case *event_RepositoryIdpGroupUpdated:
		return Event_RepositoryIdpGroupUpdated_case
	case *event_RepositoryIdpGroupRemoved:
		return Event_RepositoryIdpGroupRemoved_case
	case *event_PolicyCreated:
		return Event_PolicyCreated_case
	case *event_PolicyDeleted:
		return Event_PolicyDeleted_case
	case *event_PolicyDeprecated:
		return Event_PolicyDeprecated_case
	case *event_PolicyUndeprecated:
		return Event_PolicyUndeprecated_case
	case *event_PolicyVisibilityChanged:
		return Event_PolicyVisibilityChanged_case
	case *event_PolicyCommitPushed:
		return Event_PolicyCommitPushed_case
	case *event_PolicyLabelCreated:
		return Event_PolicyLabelCreated_case
	case *event_PolicyLabelMoved:
		return Event_PolicyLabelMoved_case
	case *event_PolicyLabelArchived:
		return Event_PolicyLabelArchived_case
	case *event_PolicyLabelUnarchived:
		return Event_PolicyLabelUnarchived_case
	case *event_PluginCreated:
		return Event_PluginCreated_case
	case *event_PluginDeleted:
		return Event_PluginDeleted_case
	case *event_PluginDeprecated:
		return Event_PluginDeprecated_case
	case *event_PluginUndeprecated:
		return Event_PluginUndeprecated_case
	case *event_PluginVisibilityChanged:
		return Event_PluginVisibilityChanged_case
	case *event_PluginCommitPushed:
		return Event_PluginCommitPushed_case
	case *event_UserCreated:
		return Event_UserCreated_case
	case *event_UserDeactivated:
		return Event_UserDeactivated_case
	case *event_UserDeleted:
		return Event_UserDeleted_case
	case *event_UserLoggedIn:
		return Event_UserLoggedIn_case
	case *event_UserLoggedOut:
		return Event_UserLoggedOut_case
	case *event_CuratedPluginCreated:
		return Event_CuratedPluginCreated_case
	case *event_IdpGroupAdded:
		return Event_IdpGroupAdded_case
	case *event_IdpGroupUpdated:
		return Event_IdpGroupUpdated_case
	case *event_IdpGroupRemoved:
		return Event_IdpGroupRemoved_case
	case *event_TokenCreated:
		return Event_TokenCreated_case
	case *event_TokenDeleted:
		return Event_TokenDeleted_case
	case *event_UserReactivated:
		return Event_UserReactivated_case
	case *event_ScimTokenCreated:
		return Event_ScimTokenCreated_case
	case *event_ScimTokenDeleted:
		return Event_ScimTokenDeleted_case
	case *event_RepositoryCommitDeleted:
		return Event_RepositoryCommitDeleted_case
	case *event_RepositoryLabelCreated:
		return Event_RepositoryLabelCreated_case
	case *event_RepositoryLabelMoved:
		return Event_RepositoryLabelMoved_case
	case *event_RepositoryLabelArchived:
		return Event_RepositoryLabelArchived_case
	case *event_RepositoryLabelUnarchived:
		return Event_RepositoryLabelUnarchived_case
	case *event_CuratedPluginDeleted:
		return Event_CuratedPluginDeleted_case
	case *event_PayloadServerBreakingChangePolicyEnabled:
		return Event_PayloadServerBreakingChangePolicyEnabled_case
	case *event_PayloadServerBreakingChangePolicyDisabled:
		return Event_PayloadServerBreakingChangePolicyDisabled_case
	case *event_RepositoryDefaultBranchChanged:
		return Event_RepositoryDefaultBranchChanged_case
	case *event_PayloadServerUniquenessPolicyEnabled:
		return Event_PayloadServerUniquenessPolicyEnabled_case
	case *event_PayloadServerUniquenessPolicyDisabled:
		return Event_PayloadServerUniquenessPolicyDisabled_case
	case *event_UserAutoMergedFromNewIdp:
		return Event_UserAutoMergedFromNewIdp_case
	case *event_DeviceAuthorizationGrantApproved:
		return Event_DeviceAuthorizationGrantApproved_case
	case *event_DeviceAuthorizationGrantDenied:
		return Event_DeviceAuthorizationGrantDenied_case
	case *event_PluginLabelCreated:
		return Event_PluginLabelCreated_case
	case *event_PluginLabelMoved:
		return Event_PluginLabelMoved_case
	case *event_PluginLabelArchived:
		return Event_PluginLabelArchived_case
	case *event_PluginLabelUnarchived:
		return Event_PluginLabelUnarchived_case
	case *event_ServerReviewFlowEnabled:
		return Event_ServerReviewFlowEnabled_case
	case *event_ServerReviewFlowDisabled:
		return Event_ServerReviewFlowDisabled_case
	case *event_SdkPluginConstraintCreated:
		return Event_SdkPluginConstraintCreated_case
	case *event_SdkPluginConstraintUpdated:
		return Event_SdkPluginConstraintUpdated_case
	case *event_SdkPluginConstraintDeleted:
		return Event_SdkPluginConstraintDeleted_case
	default:
		return Event_Payload_not_set_case
	}
}

type Event_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Unique id of the audited event.
	EventId string
	// Type of the audited event. It specifies "what" happened.
	Type EventType
	// Actor of the audited event. It specifies "who" did it.
	Actor *Actor
	// Resource of the audited event. It specifies "which resource" was affected.
	Resource *Resource
	// Time of the audited event. It specifies "when" it happened.
	EventTime *timestamppb.Timestamp
	// Metadata about the audited event. It specifies any additional details about the audited event.
	Metadata *EventMetadata
	// Payload of the audited event. It specifies additional context on the event.

	// Fields of oneof xxx_hidden_Payload:
	OrganizationCreated               *PayloadOrganizationCreated
	OrganizationDeleted               *PayloadOrganizationDeleted
	OrganizationMemberAdded           *PayloadOrganizationMemberAdded
	OrganizationMemberRoleChanged     *PayloadOrganizationMemberRoleChanged
	OrganizationMemberRolesChanged    *PayloadOrganizationMemberRolesChanged
	OrganizationMemberRemoved         *PayloadOrganizationMemberRemoved
	RepositoryCreated                 *PayloadRepositoryCreated
	RepositoryDeprecated              *PayloadRepositoryDeprecated
	RepositoryUndeprecated            *PayloadRepositoryUndeprecated
	RepositoryDeleted                 *PayloadRepositoryDeleted
	RepositoryCommitPushed            *PayloadRepositoryCommitPushed
	RepositoryContributorAdded        *PayloadRepositoryContributorAdded
	RepositoryContributorRoleChanged  *PayloadRepositoryContributorRoleChanged
	RepositoryContributorRolesChanged *PayloadRepositoryContributorRolesChanged
	RepositoryContributorRemoved      *PayloadRepositoryContributorRemoved
	RepositoryVisibilityChanged       *PayloadRepositoryVisibilityChanged
	RepositoryDefaultLabelNameChanged *PayloadRepositoryDefaultLabelNameChanged
	RepositoryIdpGroupAdded           *PayloadRepositoryIDPGroupAdded
	RepositoryIdpGroupUpdated         *PayloadRepositoryIDPGroupUpdated
	RepositoryIdpGroupRemoved         *PayloadRepositoryIDPGroupRemoved
	PolicyCreated                     *PayloadPolicyCreated
	PolicyDeleted                     *PayloadPolicyDeleted
	PolicyDeprecated                  *PayloadPolicyDeprecated
	PolicyUndeprecated                *PayloadPolicyUndeprecated
	PolicyVisibilityChanged           *PayloadPolicyVisibilityChanged
	PolicyCommitPushed                *PayloadPolicyCommitPushed
	PolicyLabelCreated                *PayloadPolicyLabelCreated
	PolicyLabelMoved                  *PayloadPolicyLabelMoved
	PolicyLabelArchived               *PayloadPolicyLabelArchived
	PolicyLabelUnarchived             *PayloadPolicyLabelUnarchived
	PluginCreated                     *PayloadPluginCreated
	PluginDeleted                     *PayloadPluginDeleted
	PluginDeprecated                  *PayloadPluginDeprecated
	PluginUndeprecated                *PayloadPluginUndeprecated
	PluginVisibilityChanged           *PayloadPluginVisibilityChanged
	PluginCommitPushed                *PayloadPluginCommitPushed
	UserCreated                       *PayloadUserCreated
	UserDeactivated                   *PayloadUserDeactivated
	UserDeleted                       *PayloadUserDeleted
	UserLoggedIn                      *PayloadUserLoggedIn
	UserLoggedOut                     *PayloadUserLoggedOut
	CuratedPluginCreated              *PayloadCuratedPluginCreated
	IdpGroupAdded                     *PayloadOrganizationIDPGroupAdded
	IdpGroupUpdated                   *PayloadOrganizationIDPGroupUpdated
	IdpGroupRemoved                   *PayloadOrganizationIDPGroupRemoved
	TokenCreated                      *PayloadTokenCreated
	TokenDeleted                      *PayloadTokenDeleted
	UserReactivated                   *PayloadUserReactivated
	ScimTokenCreated                  *PayloadSCIMTokenCreated
	ScimTokenDeleted                  *PayloadSCIMTokenDeleted
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	RepositoryCommitDeleted                   *PayloadRepositoryCommitDeleted
	RepositoryLabelCreated                    *PayloadRepositoryLabelCreated
	RepositoryLabelMoved                      *PayloadRepositoryLabelMoved
	RepositoryLabelArchived                   *PayloadRepositoryLabelArchived
	RepositoryLabelUnarchived                 *PayloadRepositoryLabelUnarchived
	CuratedPluginDeleted                      *PayloadCuratedPluginDeleted
	PayloadServerBreakingChangePolicyEnabled  *PayloadServerBreakingChangePolicyEnabled
	PayloadServerBreakingChangePolicyDisabled *PayloadServerBreakingChangePolicyDisabled
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	RepositoryDefaultBranchChanged        *PayloadRepositoryDefaultBranchChanged
	PayloadServerUniquenessPolicyEnabled  *PayloadServerUniquenessPolicyEnabled
	PayloadServerUniquenessPolicyDisabled *PayloadServerUniquenessPolicyDisabled
	UserAutoMergedFromNewIdp              *PayloadUserAutoMergedFromNewIdP
	DeviceAuthorizationGrantApproved      *PayloadDeviceAuthorizationGrantApproved
	DeviceAuthorizationGrantDenied        *PayloadDeviceAuthorizationGrantDenied
	PluginLabelCreated                    *PayloadPluginLabelCreated
	PluginLabelMoved                      *PayloadPluginLabelMoved
	PluginLabelArchived                   *PayloadPluginLabelArchived
	PluginLabelUnarchived                 *PayloadPluginLabelUnarchived
	ServerReviewFlowEnabled               *PayloadServerReviewFlowEnabled
	ServerReviewFlowDisabled              *PayloadServerReviewFlowDisabled
	SdkPluginConstraintCreated            *PayloadSDKPluginConstraintCreated
	SdkPluginConstraintUpdated            *PayloadSDKPluginConstraintUpdated
	SdkPluginConstraintDeleted            *PayloadSDKPluginConstraintDeleted
	// -- end of xxx_hidden_Payload
}

func (b0 Event_builder) Build() *Event {
	m0 := &Event{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_EventId = b.EventId
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Actor = b.Actor
	x.xxx_hidden_Resource = b.Resource
	x.xxx_hidden_EventTime = b.EventTime
	x.xxx_hidden_Metadata = b.Metadata
	if b.OrganizationCreated != nil {
		x.xxx_hidden_Payload = &event_OrganizationCreated{b.OrganizationCreated}
	}
	if b.OrganizationDeleted != nil {
		x.xxx_hidden_Payload = &event_OrganizationDeleted{b.OrganizationDeleted}
	}
	if b.OrganizationMemberAdded != nil {
		x.xxx_hidden_Payload = &event_OrganizationMemberAdded{b.OrganizationMemberAdded}
	}
	if b.OrganizationMemberRoleChanged != nil {
		x.xxx_hidden_Payload = &event_OrganizationMemberRoleChanged{b.OrganizationMemberRoleChanged}
	}
	if b.OrganizationMemberRolesChanged != nil {
		x.xxx_hidden_Payload = &event_OrganizationMemberRolesChanged{b.OrganizationMemberRolesChanged}
	}
	if b.OrganizationMemberRemoved != nil {
		x.xxx_hidden_Payload = &event_OrganizationMemberRemoved{b.OrganizationMemberRemoved}
	}
	if b.RepositoryCreated != nil {
		x.xxx_hidden_Payload = &event_RepositoryCreated{b.RepositoryCreated}
	}
	if b.RepositoryDeprecated != nil {
		x.xxx_hidden_Payload = &event_RepositoryDeprecated{b.RepositoryDeprecated}
	}
	if b.RepositoryUndeprecated != nil {
		x.xxx_hidden_Payload = &event_RepositoryUndeprecated{b.RepositoryUndeprecated}
	}
	if b.RepositoryDeleted != nil {
		x.xxx_hidden_Payload = &event_RepositoryDeleted{b.RepositoryDeleted}
	}
	if b.RepositoryCommitPushed != nil {
		x.xxx_hidden_Payload = &event_RepositoryCommitPushed{b.RepositoryCommitPushed}
	}
	if b.RepositoryContributorAdded != nil {
		x.xxx_hidden_Payload = &event_RepositoryContributorAdded{b.RepositoryContributorAdded}
	}
	if b.RepositoryContributorRoleChanged != nil {
		x.xxx_hidden_Payload = &event_RepositoryContributorRoleChanged{b.RepositoryContributorRoleChanged}
	}
	if b.RepositoryContributorRolesChanged != nil {
		x.xxx_hidden_Payload = &event_RepositoryContributorRolesChanged{b.RepositoryContributorRolesChanged}
	}
	if b.RepositoryContributorRemoved != nil {
		x.xxx_hidden_Payload = &event_RepositoryContributorRemoved{b.RepositoryContributorRemoved}
	}
	if b.RepositoryVisibilityChanged != nil {
		x.xxx_hidden_Payload = &event_RepositoryVisibilityChanged{b.RepositoryVisibilityChanged}
	}
	if b.RepositoryDefaultLabelNameChanged != nil {
		x.xxx_hidden_Payload = &event_RepositoryDefaultLabelNameChanged{b.RepositoryDefaultLabelNameChanged}
	}
	if b.RepositoryIdpGroupAdded != nil {
		x.xxx_hidden_Payload = &event_RepositoryIdpGroupAdded{b.RepositoryIdpGroupAdded}
	}
	if b.RepositoryIdpGroupUpdated != nil {
		x.xxx_hidden_Payload = &event_RepositoryIdpGroupUpdated{b.RepositoryIdpGroupUpdated}
	}
	if b.RepositoryIdpGroupRemoved != nil {
		x.xxx_hidden_Payload = &event_RepositoryIdpGroupRemoved{b.RepositoryIdpGroupRemoved}
	}
	if b.PolicyCreated != nil {
		x.xxx_hidden_Payload = &event_PolicyCreated{b.PolicyCreated}
	}
	if b.PolicyDeleted != nil {
		x.xxx_hidden_Payload = &event_PolicyDeleted{b.PolicyDeleted}
	}
	if b.PolicyDeprecated != nil {
		x.xxx_hidden_Payload = &event_PolicyDeprecated{b.PolicyDeprecated}
	}
	if b.PolicyUndeprecated != nil {
		x.xxx_hidden_Payload = &event_PolicyUndeprecated{b.PolicyUndeprecated}
	}
	if b.PolicyVisibilityChanged != nil {
		x.xxx_hidden_Payload = &event_PolicyVisibilityChanged{b.PolicyVisibilityChanged}
	}
	if b.PolicyCommitPushed != nil {
		x.xxx_hidden_Payload = &event_PolicyCommitPushed{b.PolicyCommitPushed}
	}
	if b.PolicyLabelCreated != nil {
		x.xxx_hidden_Payload = &event_PolicyLabelCreated{b.PolicyLabelCreated}
	}
	if b.PolicyLabelMoved != nil {
		x.xxx_hidden_Payload = &event_PolicyLabelMoved{b.PolicyLabelMoved}
	}
	if b.PolicyLabelArchived != nil {
		x.xxx_hidden_Payload = &event_PolicyLabelArchived{b.PolicyLabelArchived}
	}
	if b.PolicyLabelUnarchived != nil {
		x.xxx_hidden_Payload = &event_PolicyLabelUnarchived{b.PolicyLabelUnarchived}
	}
	if b.PluginCreated != nil {
		x.xxx_hidden_Payload = &event_PluginCreated{b.PluginCreated}
	}
	if b.PluginDeleted != nil {
		x.xxx_hidden_Payload = &event_PluginDeleted{b.PluginDeleted}
	}
	if b.PluginDeprecated != nil {
		x.xxx_hidden_Payload = &event_PluginDeprecated{b.PluginDeprecated}
	}
	if b.PluginUndeprecated != nil {
		x.xxx_hidden_Payload = &event_PluginUndeprecated{b.PluginUndeprecated}
	}
	if b.PluginVisibilityChanged != nil {
		x.xxx_hidden_Payload = &event_PluginVisibilityChanged{b.PluginVisibilityChanged}
	}
	if b.PluginCommitPushed != nil {
		x.xxx_hidden_Payload = &event_PluginCommitPushed{b.PluginCommitPushed}
	}
	if b.UserCreated != nil {
		x.xxx_hidden_Payload = &event_UserCreated{b.UserCreated}
	}
	if b.UserDeactivated != nil {
		x.xxx_hidden_Payload = &event_UserDeactivated{b.UserDeactivated}
	}
	if b.UserDeleted != nil {
		x.xxx_hidden_Payload = &event_UserDeleted{b.UserDeleted}
	}
	if b.UserLoggedIn != nil {
		x.xxx_hidden_Payload = &event_UserLoggedIn{b.UserLoggedIn}
	}
	if b.UserLoggedOut != nil {
		x.xxx_hidden_Payload = &event_UserLoggedOut{b.UserLoggedOut}
	}
	if b.CuratedPluginCreated != nil {
		x.xxx_hidden_Payload = &event_CuratedPluginCreated{b.CuratedPluginCreated}
	}
	if b.IdpGroupAdded != nil {
		x.xxx_hidden_Payload = &event_IdpGroupAdded{b.IdpGroupAdded}
	}
	if b.IdpGroupUpdated != nil {
		x.xxx_hidden_Payload = &event_IdpGroupUpdated{b.IdpGroupUpdated}
	}
	if b.IdpGroupRemoved != nil {
		x.xxx_hidden_Payload = &event_IdpGroupRemoved{b.IdpGroupRemoved}
	}
	if b.TokenCreated != nil {
		x.xxx_hidden_Payload = &event_TokenCreated{b.TokenCreated}
	}
	if b.TokenDeleted != nil {
		x.xxx_hidden_Payload = &event_TokenDeleted{b.TokenDeleted}
	}
	if b.UserReactivated != nil {
		x.xxx_hidden_Payload = &event_UserReactivated{b.UserReactivated}
	}
	if b.ScimTokenCreated != nil {
		x.xxx_hidden_Payload = &event_ScimTokenCreated{b.ScimTokenCreated}
	}
	if b.ScimTokenDeleted != nil {
		x.xxx_hidden_Payload = &event_ScimTokenDeleted{b.ScimTokenDeleted}
	}
	if b.RepositoryCommitDeleted != nil {
		x.xxx_hidden_Payload = &event_RepositoryCommitDeleted{b.RepositoryCommitDeleted}
	}
	if b.RepositoryLabelCreated != nil {
		x.xxx_hidden_Payload = &event_RepositoryLabelCreated{b.RepositoryLabelCreated}
	}
	if b.RepositoryLabelMoved != nil {
		x.xxx_hidden_Payload = &event_RepositoryLabelMoved{b.RepositoryLabelMoved}
	}
	if b.RepositoryLabelArchived != nil {
		x.xxx_hidden_Payload = &event_RepositoryLabelArchived{b.RepositoryLabelArchived}
	}
	if b.RepositoryLabelUnarchived != nil {
		x.xxx_hidden_Payload = &event_RepositoryLabelUnarchived{b.RepositoryLabelUnarchived}
	}
	if b.CuratedPluginDeleted != nil {
		x.xxx_hidden_Payload = &event_CuratedPluginDeleted{b.CuratedPluginDeleted}
	}
	if b.PayloadServerBreakingChangePolicyEnabled != nil {
		x.xxx_hidden_Payload = &event_PayloadServerBreakingChangePolicyEnabled{b.PayloadServerBreakingChangePolicyEnabled}
	}
	if b.PayloadServerBreakingChangePolicyDisabled != nil {
		x.xxx_hidden_Payload = &event_PayloadServerBreakingChangePolicyDisabled{b.PayloadServerBreakingChangePolicyDisabled}
	}
	if b.RepositoryDefaultBranchChanged != nil {
		x.xxx_hidden_Payload = &event_RepositoryDefaultBranchChanged{b.RepositoryDefaultBranchChanged}
	}
	if b.PayloadServerUniquenessPolicyEnabled != nil {
		x.xxx_hidden_Payload = &event_PayloadServerUniquenessPolicyEnabled{b.PayloadServerUniquenessPolicyEnabled}
	}
	if b.PayloadServerUniquenessPolicyDisabled != nil {
		x.xxx_hidden_Payload = &event_PayloadServerUniquenessPolicyDisabled{b.PayloadServerUniquenessPolicyDisabled}
	}
	if b.UserAutoMergedFromNewIdp != nil {
		x.xxx_hidden_Payload = &event_UserAutoMergedFromNewIdp{b.UserAutoMergedFromNewIdp}
	}
	if b.DeviceAuthorizationGrantApproved != nil {
		x.xxx_hidden_Payload = &event_DeviceAuthorizationGrantApproved{b.DeviceAuthorizationGrantApproved}
	}
	if b.DeviceAuthorizationGrantDenied != nil {
		x.xxx_hidden_Payload = &event_DeviceAuthorizationGrantDenied{b.DeviceAuthorizationGrantDenied}
	}
	if b.PluginLabelCreated != nil {
		x.xxx_hidden_Payload = &event_PluginLabelCreated{b.PluginLabelCreated}
	}
	if b.PluginLabelMoved != nil {
		x.xxx_hidden_Payload = &event_PluginLabelMoved{b.PluginLabelMoved}
	}
	if b.PluginLabelArchived != nil {
		x.xxx_hidden_Payload = &event_PluginLabelArchived{b.PluginLabelArchived}
	}
	if b.PluginLabelUnarchived != nil {
		x.xxx_hidden_Payload = &event_PluginLabelUnarchived{b.PluginLabelUnarchived}
	}
	if b.ServerReviewFlowEnabled != nil {
		x.xxx_hidden_Payload = &event_ServerReviewFlowEnabled{b.ServerReviewFlowEnabled}
	}
	if b.ServerReviewFlowDisabled != nil {
		x.xxx_hidden_Payload = &event_ServerReviewFlowDisabled{b.ServerReviewFlowDisabled}
	}
	if b.SdkPluginConstraintCreated != nil {
		x.xxx_hidden_Payload = &event_SdkPluginConstraintCreated{b.SdkPluginConstraintCreated}
	}
	if b.SdkPluginConstraintUpdated != nil {
		x.xxx_hidden_Payload = &event_SdkPluginConstraintUpdated{b.SdkPluginConstraintUpdated}
	}
	if b.SdkPluginConstraintDeleted != nil {
		x.xxx_hidden_Payload = &event_SdkPluginConstraintDeleted{b.SdkPluginConstraintDeleted}
	}
	return m0
}

type case_Event_Payload protoreflect.FieldNumber

func (x case_Event_Payload) String() string {
	md := file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isEvent_Payload interface {
	isEvent_Payload()
}

type event_OrganizationCreated struct {
	OrganizationCreated *PayloadOrganizationCreated `protobuf:"bytes,7,opt,name=organization_created,json=organizationCreated,proto3,oneof"`
}

type event_OrganizationDeleted struct {
	OrganizationDeleted *PayloadOrganizationDeleted `protobuf:"bytes,8,opt,name=organization_deleted,json=organizationDeleted,proto3,oneof"`
}

type event_OrganizationMemberAdded struct {
	OrganizationMemberAdded *PayloadOrganizationMemberAdded `protobuf:"bytes,9,opt,name=organization_member_added,json=organizationMemberAdded,proto3,oneof"`
}

type event_OrganizationMemberRoleChanged struct {
	OrganizationMemberRoleChanged *PayloadOrganizationMemberRoleChanged `protobuf:"bytes,10,opt,name=organization_member_role_changed,json=organizationMemberRoleChanged,proto3,oneof"`
}

type event_OrganizationMemberRolesChanged struct {
	OrganizationMemberRolesChanged *PayloadOrganizationMemberRolesChanged `protobuf:"bytes,56,opt,name=organization_member_roles_changed,json=organizationMemberRolesChanged,proto3,oneof"`
}

type event_OrganizationMemberRemoved struct {
	OrganizationMemberRemoved *PayloadOrganizationMemberRemoved `protobuf:"bytes,11,opt,name=organization_member_removed,json=organizationMemberRemoved,proto3,oneof"`
}

type event_RepositoryCreated struct {
	RepositoryCreated *PayloadRepositoryCreated `protobuf:"bytes,12,opt,name=repository_created,json=repositoryCreated,proto3,oneof"`
}

type event_RepositoryDeprecated struct {
	RepositoryDeprecated *PayloadRepositoryDeprecated `protobuf:"bytes,54,opt,name=repository_deprecated,json=repositoryDeprecated,proto3,oneof"`
}

type event_RepositoryUndeprecated struct {
	RepositoryUndeprecated *PayloadRepositoryUndeprecated `protobuf:"bytes,55,opt,name=repository_undeprecated,json=repositoryUndeprecated,proto3,oneof"`
}

type event_RepositoryDeleted struct {
	RepositoryDeleted *PayloadRepositoryDeleted `protobuf:"bytes,13,opt,name=repository_deleted,json=repositoryDeleted,proto3,oneof"`
}

type event_RepositoryCommitPushed struct {
	RepositoryCommitPushed *PayloadRepositoryCommitPushed `protobuf:"bytes,14,opt,name=repository_commit_pushed,json=repositoryCommitPushed,proto3,oneof"`
}

type event_RepositoryContributorAdded struct {
	RepositoryContributorAdded *PayloadRepositoryContributorAdded `protobuf:"bytes,15,opt,name=repository_contributor_added,json=repositoryContributorAdded,proto3,oneof"`
}

type event_RepositoryContributorRoleChanged struct {
	RepositoryContributorRoleChanged *PayloadRepositoryContributorRoleChanged `protobuf:"bytes,16,opt,name=repository_contributor_role_changed,json=repositoryContributorRoleChanged,proto3,oneof"`
}

type event_RepositoryContributorRolesChanged struct {
	RepositoryContributorRolesChanged *PayloadRepositoryContributorRolesChanged `protobuf:"bytes,69,opt,name=repository_contributor_roles_changed,json=repositoryContributorRolesChanged,proto3,oneof"`
}

type event_RepositoryContributorRemoved struct {
	RepositoryContributorRemoved *PayloadRepositoryContributorRemoved `protobuf:"bytes,17,opt,name=repository_contributor_removed,json=repositoryContributorRemoved,proto3,oneof"`
}

type event_RepositoryVisibilityChanged struct {
	RepositoryVisibilityChanged *PayloadRepositoryVisibilityChanged `protobuf:"bytes,18,opt,name=repository_visibility_changed,json=repositoryVisibilityChanged,proto3,oneof"`
}

type event_RepositoryDefaultLabelNameChanged struct {
	RepositoryDefaultLabelNameChanged *PayloadRepositoryDefaultLabelNameChanged `protobuf:"bytes,46,opt,name=repository_default_label_name_changed,json=repositoryDefaultLabelNameChanged,proto3,oneof"`
}

type event_RepositoryIdpGroupAdded struct {
	RepositoryIdpGroupAdded *PayloadRepositoryIDPGroupAdded `protobuf:"bytes,66,opt,name=repository_idp_group_added,json=repositoryIdpGroupAdded,proto3,oneof"`
}

type event_RepositoryIdpGroupUpdated struct {
	RepositoryIdpGroupUpdated *PayloadRepositoryIDPGroupUpdated `protobuf:"bytes,67,opt,name=repository_idp_group_updated,json=repositoryIdpGroupUpdated,proto3,oneof"`
}

type event_RepositoryIdpGroupRemoved struct {
	RepositoryIdpGroupRemoved *PayloadRepositoryIDPGroupRemoved `protobuf:"bytes,68,opt,name=repository_idp_group_removed,json=repositoryIdpGroupRemoved,proto3,oneof"`
}

type event_PolicyCreated struct {
	PolicyCreated *PayloadPolicyCreated `protobuf:"bytes,60,opt,name=policy_created,json=policyCreated,proto3,oneof"`
}

type event_PolicyDeleted struct {
	PolicyDeleted *PayloadPolicyDeleted `protobuf:"bytes,61,opt,name=policy_deleted,json=policyDeleted,proto3,oneof"`
}

type event_PolicyDeprecated struct {
	PolicyDeprecated *PayloadPolicyDeprecated `protobuf:"bytes,62,opt,name=policy_deprecated,json=policyDeprecated,proto3,oneof"`
}

type event_PolicyUndeprecated struct {
	PolicyUndeprecated *PayloadPolicyUndeprecated `protobuf:"bytes,63,opt,name=policy_undeprecated,json=policyUndeprecated,proto3,oneof"`
}

type event_PolicyVisibilityChanged struct {
	PolicyVisibilityChanged *PayloadPolicyVisibilityChanged `protobuf:"bytes,64,opt,name=policy_visibility_changed,json=policyVisibilityChanged,proto3,oneof"`
}

type event_PolicyCommitPushed struct {
	PolicyCommitPushed *PayloadPolicyCommitPushed `protobuf:"bytes,70,opt,name=policy_commit_pushed,json=policyCommitPushed,proto3,oneof"`
}

type event_PolicyLabelCreated struct {
	PolicyLabelCreated *PayloadPolicyLabelCreated `protobuf:"bytes,71,opt,name=policy_label_created,json=policyLabelCreated,proto3,oneof"`
}

type event_PolicyLabelMoved struct {
	PolicyLabelMoved *PayloadPolicyLabelMoved `protobuf:"bytes,72,opt,name=policy_label_moved,json=policyLabelMoved,proto3,oneof"`
}

type event_PolicyLabelArchived struct {
	PolicyLabelArchived *PayloadPolicyLabelArchived `protobuf:"bytes,73,opt,name=policy_label_archived,json=policyLabelArchived,proto3,oneof"`
}

type event_PolicyLabelUnarchived struct {
	PolicyLabelUnarchived *PayloadPolicyLabelUnarchived `protobuf:"bytes,74,opt,name=policy_label_unarchived,json=policyLabelUnarchived,proto3,oneof"`
}

type event_PluginCreated struct {
	PluginCreated *PayloadPluginCreated `protobuf:"bytes,19,opt,name=plugin_created,json=pluginCreated,proto3,oneof"`
}

type event_PluginDeleted struct {
	PluginDeleted *PayloadPluginDeleted `protobuf:"bytes,20,opt,name=plugin_deleted,json=pluginDeleted,proto3,oneof"`
}

type event_PluginDeprecated struct {
	PluginDeprecated *PayloadPluginDeprecated `protobuf:"bytes,57,opt,name=plugin_deprecated,json=pluginDeprecated,proto3,oneof"`
}

type event_PluginUndeprecated struct {
	PluginUndeprecated *PayloadPluginUndeprecated `protobuf:"bytes,58,opt,name=plugin_undeprecated,json=pluginUndeprecated,proto3,oneof"`
}

type event_PluginVisibilityChanged struct {
	PluginVisibilityChanged *PayloadPluginVisibilityChanged `protobuf:"bytes,59,opt,name=plugin_visibility_changed,json=pluginVisibilityChanged,proto3,oneof"`
}

type event_PluginCommitPushed struct {
	PluginCommitPushed *PayloadPluginCommitPushed `protobuf:"bytes,49,opt,name=plugin_commit_pushed,json=pluginCommitPushed,proto3,oneof"`
}

type event_UserCreated struct {
	UserCreated *PayloadUserCreated `protobuf:"bytes,21,opt,name=user_created,json=userCreated,proto3,oneof"`
}

type event_UserDeactivated struct {
	UserDeactivated *PayloadUserDeactivated `protobuf:"bytes,22,opt,name=user_deactivated,json=userDeactivated,proto3,oneof"`
}

type event_UserDeleted struct {
	UserDeleted *PayloadUserDeleted `protobuf:"bytes,23,opt,name=user_deleted,json=userDeleted,proto3,oneof"`
}

type event_UserLoggedIn struct {
	UserLoggedIn *PayloadUserLoggedIn `protobuf:"bytes,24,opt,name=user_logged_in,json=userLoggedIn,proto3,oneof"`
}

type event_UserLoggedOut struct {
	UserLoggedOut *PayloadUserLoggedOut `protobuf:"bytes,25,opt,name=user_logged_out,json=userLoggedOut,proto3,oneof"`
}

type event_CuratedPluginCreated struct {
	CuratedPluginCreated *PayloadCuratedPluginCreated `protobuf:"bytes,26,opt,name=curated_plugin_created,json=curatedPluginCreated,proto3,oneof"`
}

type event_IdpGroupAdded struct {
	IdpGroupAdded *PayloadOrganizationIDPGroupAdded `protobuf:"bytes,27,opt,name=idp_group_added,json=idpGroupAdded,proto3,oneof"`
}

type event_IdpGroupUpdated struct {
	IdpGroupUpdated *PayloadOrganizationIDPGroupUpdated `protobuf:"bytes,65,opt,name=idp_group_updated,json=idpGroupUpdated,proto3,oneof"`
}

type event_IdpGroupRemoved struct {
	IdpGroupRemoved *PayloadOrganizationIDPGroupRemoved `protobuf:"bytes,28,opt,name=idp_group_removed,json=idpGroupRemoved,proto3,oneof"`
}

type event_TokenCreated struct {
	TokenCreated *PayloadTokenCreated `protobuf:"bytes,29,opt,name=token_created,json=tokenCreated,proto3,oneof"`
}

type event_TokenDeleted struct {
	TokenDeleted *PayloadTokenDeleted `protobuf:"bytes,30,opt,name=token_deleted,json=tokenDeleted,proto3,oneof"`
}

type event_UserReactivated struct {
	UserReactivated *PayloadUserReactivated `protobuf:"bytes,31,opt,name=user_reactivated,json=userReactivated,proto3,oneof"`
}

type event_ScimTokenCreated struct {
	ScimTokenCreated *PayloadSCIMTokenCreated `protobuf:"bytes,32,opt,name=scim_token_created,json=scimTokenCreated,proto3,oneof"`
}

type event_ScimTokenDeleted struct {
	ScimTokenDeleted *PayloadSCIMTokenDeleted `protobuf:"bytes,33,opt,name=scim_token_deleted,json=scimTokenDeleted,proto3,oneof"`
}

type event_RepositoryCommitDeleted struct {
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	RepositoryCommitDeleted *PayloadRepositoryCommitDeleted `protobuf:"bytes,34,opt,name=repository_commit_deleted,json=repositoryCommitDeleted,proto3,oneof"`
}

type event_RepositoryLabelCreated struct {
	RepositoryLabelCreated *PayloadRepositoryLabelCreated `protobuf:"bytes,35,opt,name=repository_label_created,json=repositoryLabelCreated,proto3,oneof"`
}

type event_RepositoryLabelMoved struct {
	RepositoryLabelMoved *PayloadRepositoryLabelMoved `protobuf:"bytes,36,opt,name=repository_label_moved,json=repositoryLabelMoved,proto3,oneof"`
}

type event_RepositoryLabelArchived struct {
	RepositoryLabelArchived *PayloadRepositoryLabelArchived `protobuf:"bytes,44,opt,name=repository_label_archived,json=repositoryLabelArchived,proto3,oneof"`
}

type event_RepositoryLabelUnarchived struct {
	RepositoryLabelUnarchived *PayloadRepositoryLabelUnarchived `protobuf:"bytes,45,opt,name=repository_label_unarchived,json=repositoryLabelUnarchived,proto3,oneof"`
}

type event_CuratedPluginDeleted struct {
	CuratedPluginDeleted *PayloadCuratedPluginDeleted `protobuf:"bytes,37,opt,name=curated_plugin_deleted,json=curatedPluginDeleted,proto3,oneof"`
}

type event_PayloadServerBreakingChangePolicyEnabled struct {
	PayloadServerBreakingChangePolicyEnabled *PayloadServerBreakingChangePolicyEnabled `protobuf:"bytes,38,opt,name=payload_server_breaking_change_policy_enabled,json=payloadServerBreakingChangePolicyEnabled,proto3,oneof"`
}

type event_PayloadServerBreakingChangePolicyDisabled struct {
	PayloadServerBreakingChangePolicyDisabled *PayloadServerBreakingChangePolicyDisabled `protobuf:"bytes,39,opt,name=payload_server_breaking_change_policy_disabled,json=payloadServerBreakingChangePolicyDisabled,proto3,oneof"`
}

type event_RepositoryDefaultBranchChanged struct {
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	RepositoryDefaultBranchChanged *PayloadRepositoryDefaultBranchChanged `protobuf:"bytes,40,opt,name=repository_default_branch_changed,json=repositoryDefaultBranchChanged,proto3,oneof"`
}

type event_PayloadServerUniquenessPolicyEnabled struct {
	PayloadServerUniquenessPolicyEnabled *PayloadServerUniquenessPolicyEnabled `protobuf:"bytes,41,opt,name=payload_server_uniqueness_policy_enabled,json=payloadServerUniquenessPolicyEnabled,proto3,oneof"`
}

type event_PayloadServerUniquenessPolicyDisabled struct {
	PayloadServerUniquenessPolicyDisabled *PayloadServerUniquenessPolicyDisabled `protobuf:"bytes,42,opt,name=payload_server_uniqueness_policy_disabled,json=payloadServerUniquenessPolicyDisabled,proto3,oneof"`
}

type event_UserAutoMergedFromNewIdp struct {
	UserAutoMergedFromNewIdp *PayloadUserAutoMergedFromNewIdP `protobuf:"bytes,43,opt,name=user_auto_merged_from_new_idp,json=userAutoMergedFromNewIdp,proto3,oneof"`
}

type event_DeviceAuthorizationGrantApproved struct {
	DeviceAuthorizationGrantApproved *PayloadDeviceAuthorizationGrantApproved `protobuf:"bytes,47,opt,name=device_authorization_grant_approved,json=deviceAuthorizationGrantApproved,proto3,oneof"`
}

type event_DeviceAuthorizationGrantDenied struct {
	DeviceAuthorizationGrantDenied *PayloadDeviceAuthorizationGrantDenied `protobuf:"bytes,48,opt,name=device_authorization_grant_denied,json=deviceAuthorizationGrantDenied,proto3,oneof"`
}

type event_PluginLabelCreated struct {
	PluginLabelCreated *PayloadPluginLabelCreated `protobuf:"bytes,50,opt,name=plugin_label_created,json=pluginLabelCreated,proto3,oneof"`
}

type event_PluginLabelMoved struct {
	PluginLabelMoved *PayloadPluginLabelMoved `protobuf:"bytes,51,opt,name=plugin_label_moved,json=pluginLabelMoved,proto3,oneof"`
}

type event_PluginLabelArchived struct {
	PluginLabelArchived *PayloadPluginLabelArchived `protobuf:"bytes,52,opt,name=plugin_label_archived,json=pluginLabelArchived,proto3,oneof"`
}

type event_PluginLabelUnarchived struct {
	PluginLabelUnarchived *PayloadPluginLabelUnarchived `protobuf:"bytes,53,opt,name=plugin_label_unarchived,json=pluginLabelUnarchived,proto3,oneof"`
}

type event_ServerReviewFlowEnabled struct {
	ServerReviewFlowEnabled *PayloadServerReviewFlowEnabled `protobuf:"bytes,75,opt,name=server_review_flow_enabled,json=serverReviewFlowEnabled,proto3,oneof"`
}

type event_ServerReviewFlowDisabled struct {
	ServerReviewFlowDisabled *PayloadServerReviewFlowDisabled `protobuf:"bytes,76,opt,name=server_review_flow_disabled,json=serverReviewFlowDisabled,proto3,oneof"`
}

type event_SdkPluginConstraintCreated struct {
	SdkPluginConstraintCreated *PayloadSDKPluginConstraintCreated `protobuf:"bytes,77,opt,name=sdk_plugin_constraint_created,json=sdkPluginConstraintCreated,proto3,oneof"`
}

type event_SdkPluginConstraintUpdated struct {
	SdkPluginConstraintUpdated *PayloadSDKPluginConstraintUpdated `protobuf:"bytes,78,opt,name=sdk_plugin_constraint_updated,json=sdkPluginConstraintUpdated,proto3,oneof"`
}

type event_SdkPluginConstraintDeleted struct {
	SdkPluginConstraintDeleted *PayloadSDKPluginConstraintDeleted `protobuf:"bytes,79,opt,name=sdk_plugin_constraint_deleted,json=sdkPluginConstraintDeleted,proto3,oneof"`
}

func (*event_OrganizationCreated) isEvent_Payload() {}

func (*event_OrganizationDeleted) isEvent_Payload() {}

func (*event_OrganizationMemberAdded) isEvent_Payload() {}

func (*event_OrganizationMemberRoleChanged) isEvent_Payload() {}

func (*event_OrganizationMemberRolesChanged) isEvent_Payload() {}

func (*event_OrganizationMemberRemoved) isEvent_Payload() {}

func (*event_RepositoryCreated) isEvent_Payload() {}

func (*event_RepositoryDeprecated) isEvent_Payload() {}

func (*event_RepositoryUndeprecated) isEvent_Payload() {}

func (*event_RepositoryDeleted) isEvent_Payload() {}

func (*event_RepositoryCommitPushed) isEvent_Payload() {}

func (*event_RepositoryContributorAdded) isEvent_Payload() {}

func (*event_RepositoryContributorRoleChanged) isEvent_Payload() {}

func (*event_RepositoryContributorRolesChanged) isEvent_Payload() {}

func (*event_RepositoryContributorRemoved) isEvent_Payload() {}

func (*event_RepositoryVisibilityChanged) isEvent_Payload() {}

func (*event_RepositoryDefaultLabelNameChanged) isEvent_Payload() {}

func (*event_RepositoryIdpGroupAdded) isEvent_Payload() {}

func (*event_RepositoryIdpGroupUpdated) isEvent_Payload() {}

func (*event_RepositoryIdpGroupRemoved) isEvent_Payload() {}

func (*event_PolicyCreated) isEvent_Payload() {}

func (*event_PolicyDeleted) isEvent_Payload() {}

func (*event_PolicyDeprecated) isEvent_Payload() {}

func (*event_PolicyUndeprecated) isEvent_Payload() {}

func (*event_PolicyVisibilityChanged) isEvent_Payload() {}

func (*event_PolicyCommitPushed) isEvent_Payload() {}

func (*event_PolicyLabelCreated) isEvent_Payload() {}

func (*event_PolicyLabelMoved) isEvent_Payload() {}

func (*event_PolicyLabelArchived) isEvent_Payload() {}

func (*event_PolicyLabelUnarchived) isEvent_Payload() {}

func (*event_PluginCreated) isEvent_Payload() {}

func (*event_PluginDeleted) isEvent_Payload() {}

func (*event_PluginDeprecated) isEvent_Payload() {}

func (*event_PluginUndeprecated) isEvent_Payload() {}

func (*event_PluginVisibilityChanged) isEvent_Payload() {}

func (*event_PluginCommitPushed) isEvent_Payload() {}

func (*event_UserCreated) isEvent_Payload() {}

func (*event_UserDeactivated) isEvent_Payload() {}

func (*event_UserDeleted) isEvent_Payload() {}

func (*event_UserLoggedIn) isEvent_Payload() {}

func (*event_UserLoggedOut) isEvent_Payload() {}

func (*event_CuratedPluginCreated) isEvent_Payload() {}

func (*event_IdpGroupAdded) isEvent_Payload() {}

func (*event_IdpGroupUpdated) isEvent_Payload() {}

func (*event_IdpGroupRemoved) isEvent_Payload() {}

func (*event_TokenCreated) isEvent_Payload() {}

func (*event_TokenDeleted) isEvent_Payload() {}

func (*event_UserReactivated) isEvent_Payload() {}

func (*event_ScimTokenCreated) isEvent_Payload() {}

func (*event_ScimTokenDeleted) isEvent_Payload() {}

func (*event_RepositoryCommitDeleted) isEvent_Payload() {}

func (*event_RepositoryLabelCreated) isEvent_Payload() {}

func (*event_RepositoryLabelMoved) isEvent_Payload() {}

func (*event_RepositoryLabelArchived) isEvent_Payload() {}

func (*event_RepositoryLabelUnarchived) isEvent_Payload() {}

func (*event_CuratedPluginDeleted) isEvent_Payload() {}

func (*event_PayloadServerBreakingChangePolicyEnabled) isEvent_Payload() {}

func (*event_PayloadServerBreakingChangePolicyDisabled) isEvent_Payload() {}

func (*event_RepositoryDefaultBranchChanged) isEvent_Payload() {}

func (*event_PayloadServerUniquenessPolicyEnabled) isEvent_Payload() {}

func (*event_PayloadServerUniquenessPolicyDisabled) isEvent_Payload() {}

func (*event_UserAutoMergedFromNewIdp) isEvent_Payload() {}

func (*event_DeviceAuthorizationGrantApproved) isEvent_Payload() {}

func (*event_DeviceAuthorizationGrantDenied) isEvent_Payload() {}

func (*event_PluginLabelCreated) isEvent_Payload() {}

func (*event_PluginLabelMoved) isEvent_Payload() {}

func (*event_PluginLabelArchived) isEvent_Payload() {}

func (*event_PluginLabelUnarchived) isEvent_Payload() {}

func (*event_ServerReviewFlowEnabled) isEvent_Payload() {}

func (*event_ServerReviewFlowDisabled) isEvent_Payload() {}

func (*event_SdkPluginConstraintCreated) isEvent_Payload() {}

func (*event_SdkPluginConstraintUpdated) isEvent_Payload() {}

func (*event_SdkPluginConstraintDeleted) isEvent_Payload() {}

type PayloadOrganizationCreated struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadOrganizationCreated) Reset() {
	*x = PayloadOrganizationCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationCreated) ProtoMessage() {}

func (x *PayloadOrganizationCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadOrganizationCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadOrganizationCreated_builder) Build() *PayloadOrganizationCreated {
	m0 := &PayloadOrganizationCreated{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadOrganizationDeleted struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadOrganizationDeleted) Reset() {
	*x = PayloadOrganizationDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationDeleted) ProtoMessage() {}

func (x *PayloadOrganizationDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadOrganizationDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadOrganizationDeleted_builder) Build() *PayloadOrganizationDeleted {
	m0 := &PayloadOrganizationDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadOrganizationMemberAdded struct {
	state                       protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                          `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                          `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_MemberRole       v1alpha1.OrganizationRole       `protobuf:"varint,3,opt,name=member_role,json=memberRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_MemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,4,opt,name=member_role_source,json=memberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationMemberAdded) Reset() {
	*x = PayloadOrganizationMemberAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberAdded) ProtoMessage() {}

func (x *PayloadOrganizationMemberAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationMemberAdded) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberAdded) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberAdded) GetMemberRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_MemberRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberAdded) GetMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_MemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberAdded) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationMemberAdded) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationMemberAdded) SetMemberRole(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_MemberRole = v
}

func (x *PayloadOrganizationMemberAdded) SetMemberRoleSource(v v1alpha1.OrganizationRoleSource) {
	x.xxx_hidden_MemberRoleSource = v
}

type PayloadOrganizationMemberAdded_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization with the new member.
	OrganizationId string
	// organization_name is the name of the organization with the new member.
	OrganizationName string
	// member_role is the role granted to the member added to the organization.
	MemberRole v1alpha1.OrganizationRole
	// member_role_source is the source of the role granted to the member.
	MemberRoleSource v1alpha1.OrganizationRoleSource
}

func (b0 PayloadOrganizationMemberAdded_builder) Build() *PayloadOrganizationMemberAdded {
	m0 := &PayloadOrganizationMemberAdded{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_MemberRole = b.MemberRole
	x.xxx_hidden_MemberRoleSource = b.MemberRoleSource
	return m0
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadOrganizationMemberRoleChanged struct {
	state                          protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId      string                          `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName    string                          `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_OldRole             v1alpha1.OrganizationRole       `protobuf:"varint,3,opt,name=old_role,json=oldRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_NewRole             v1alpha1.OrganizationRole       `protobuf:"varint,4,opt,name=new_role,json=newRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_OldMemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,5,opt,name=old_member_role_source,json=oldMemberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	xxx_hidden_NewMemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,6,opt,name=new_member_role_source,json=newMemberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *PayloadOrganizationMemberRoleChanged) Reset() {
	*x = PayloadOrganizationMemberRoleChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberRoleChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberRoleChanged) ProtoMessage() {}

func (x *PayloadOrganizationMemberRoleChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationMemberRoleChanged) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberRoleChanged) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberRoleChanged) GetOldRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_OldRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRoleChanged) GetNewRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_NewRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRoleChanged) GetOldMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_OldMemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberRoleChanged) GetNewMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_NewMemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberRoleChanged) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetOldRole(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_OldRole = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetNewRole(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_NewRole = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetOldMemberRoleSource(v v1alpha1.OrganizationRoleSource) {
	x.xxx_hidden_OldMemberRoleSource = v
}

func (x *PayloadOrganizationMemberRoleChanged) SetNewMemberRoleSource(v v1alpha1.OrganizationRoleSource) {
	x.xxx_hidden_NewMemberRoleSource = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadOrganizationMemberRoleChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization within which the role was changed.
	OrganizationId string
	// organization_name is the name of the organization within which the role was changed.
	OrganizationName string
	// old_role is the old role of the member whose role was changed.
	OldRole v1alpha1.OrganizationRole
	// new_role is the new role of the member whose role was changed.
	NewRole v1alpha1.OrganizationRole
	// old_member_role_source is the old source of the role granted to the member.
	OldMemberRoleSource v1alpha1.OrganizationRoleSource
	// new_member_role_source is the new source of the role granted to the member.
	NewMemberRoleSource v1alpha1.OrganizationRoleSource
}

func (b0 PayloadOrganizationMemberRoleChanged_builder) Build() *PayloadOrganizationMemberRoleChanged {
	m0 := &PayloadOrganizationMemberRoleChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_OldRole = b.OldRole
	x.xxx_hidden_NewRole = b.NewRole
	x.xxx_hidden_OldMemberRoleSource = b.OldMemberRoleSource
	x.xxx_hidden_NewMemberRoleSource = b.NewMemberRoleSource
	return m0
}

type PayloadOrganizationMemberRolesChanged struct {
	state                       protoimpl.MessageState                                     `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                                                     `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                                                     `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_OldRoles         *[]*PayloadOrganizationMemberRolesChanged_OrganizationRole `protobuf:"bytes,3,rep,name=old_roles,json=oldRoles,proto3"`
	xxx_hidden_NewRoles         *[]*PayloadOrganizationMemberRolesChanged_OrganizationRole `protobuf:"bytes,4,rep,name=new_roles,json=newRoles,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationMemberRolesChanged) Reset() {
	*x = PayloadOrganizationMemberRolesChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberRolesChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberRolesChanged) ProtoMessage() {}

func (x *PayloadOrganizationMemberRolesChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationMemberRolesChanged) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberRolesChanged) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberRolesChanged) GetOldRoles() []*PayloadOrganizationMemberRolesChanged_OrganizationRole {
	if x != nil {
		if x.xxx_hidden_OldRoles != nil {
			return *x.xxx_hidden_OldRoles
		}
	}
	return nil
}

func (x *PayloadOrganizationMemberRolesChanged) GetNewRoles() []*PayloadOrganizationMemberRolesChanged_OrganizationRole {
	if x != nil {
		if x.xxx_hidden_NewRoles != nil {
			return *x.xxx_hidden_NewRoles
		}
	}
	return nil
}

func (x *PayloadOrganizationMemberRolesChanged) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationMemberRolesChanged) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationMemberRolesChanged) SetOldRoles(v []*PayloadOrganizationMemberRolesChanged_OrganizationRole) {
	x.xxx_hidden_OldRoles = &v
}

func (x *PayloadOrganizationMemberRolesChanged) SetNewRoles(v []*PayloadOrganizationMemberRolesChanged_OrganizationRole) {
	x.xxx_hidden_NewRoles = &v
}

type PayloadOrganizationMemberRolesChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization within which the roles was changed.
	OrganizationId string
	// organization_name is the name of the organization within which the roles was changed.
	OrganizationName string
	// old_roles are the old roles of the member.
	OldRoles []*PayloadOrganizationMemberRolesChanged_OrganizationRole
	// new_roles are the new roles of the member.
	NewRoles []*PayloadOrganizationMemberRolesChanged_OrganizationRole
}

func (b0 PayloadOrganizationMemberRolesChanged_builder) Build() *PayloadOrganizationMemberRolesChanged {
	m0 := &PayloadOrganizationMemberRolesChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_OldRoles = &b.OldRoles
	x.xxx_hidden_NewRoles = &b.NewRoles
	return m0
}

type PayloadOrganizationMemberRemoved struct {
	state                       protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                          `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                          `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_MemberRole       v1alpha1.OrganizationRole       `protobuf:"varint,3,opt,name=member_role,json=memberRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_MemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,4,opt,name=member_role_source,json=memberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationMemberRemoved) Reset() {
	*x = PayloadOrganizationMemberRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberRemoved) ProtoMessage() {}

func (x *PayloadOrganizationMemberRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationMemberRemoved) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberRemoved) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberRemoved) GetMemberRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_MemberRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRemoved) GetMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_MemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberRemoved) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationMemberRemoved) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationMemberRemoved) SetMemberRole(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_MemberRole = v
}

func (x *PayloadOrganizationMemberRemoved) SetMemberRoleSource(v v1alpha1.OrganizationRoleSource) {
	x.xxx_hidden_MemberRoleSource = v
}

type PayloadOrganizationMemberRemoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization that the member was removed from.
	OrganizationId string
	// organization_name is the name of the organization that the member was removed from.
	OrganizationName string
	// member_role is the role that the member had when removed from the organization.
	MemberRole v1alpha1.OrganizationRole
	// member_role_source is the source of the role granted to the member.
	MemberRoleSource v1alpha1.OrganizationRoleSource
}

func (b0 PayloadOrganizationMemberRemoved_builder) Build() *PayloadOrganizationMemberRemoved {
	m0 := &PayloadOrganizationMemberRemoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_MemberRole = b.MemberRole
	x.xxx_hidden_MemberRoleSource = b.MemberRoleSource
	return m0
}

type PayloadOrganizationIDPGroupAdded struct {
	state                       protoimpl.MessageState    `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                    `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                    `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_RoleOverride     v1alpha1.OrganizationRole `protobuf:"varint,3,opt,name=role_override,json=roleOverride,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationIDPGroupAdded) Reset() {
	*x = PayloadOrganizationIDPGroupAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationIDPGroupAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationIDPGroupAdded) ProtoMessage() {}

func (x *PayloadOrganizationIDPGroupAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationIDPGroupAdded) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupAdded) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupAdded) GetRoleOverride() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_RoleOverride
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationIDPGroupAdded) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationIDPGroupAdded) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationIDPGroupAdded) SetRoleOverride(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_RoleOverride = v
}

type PayloadOrganizationIDPGroupAdded_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization with the new IDP group.
	OrganizationId string
	// organization_name is the name of the organization with the new IDP group.
	OrganizationName string
	// role_override is the role override associated with the new IDP group.
	RoleOverride v1alpha1.OrganizationRole
}

func (b0 PayloadOrganizationIDPGroupAdded_builder) Build() *PayloadOrganizationIDPGroupAdded {
	m0 := &PayloadOrganizationIDPGroupAdded{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_RoleOverride = b.RoleOverride
	return m0
}

type PayloadOrganizationIDPGroupUpdated struct {
	state                       protoimpl.MessageState    `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                    `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                    `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_OldRoleOverride  v1alpha1.OrganizationRole `protobuf:"varint,3,opt,name=old_role_override,json=oldRoleOverride,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_NewRoleOverride  v1alpha1.OrganizationRole `protobuf:"varint,4,opt,name=new_role_override,json=newRoleOverride,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationIDPGroupUpdated) Reset() {
	*x = PayloadOrganizationIDPGroupUpdated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationIDPGroupUpdated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationIDPGroupUpdated) ProtoMessage() {}

func (x *PayloadOrganizationIDPGroupUpdated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationIDPGroupUpdated) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupUpdated) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupUpdated) GetOldRoleOverride() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_OldRoleOverride
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationIDPGroupUpdated) GetNewRoleOverride() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_NewRoleOverride
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationIDPGroupUpdated) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationIDPGroupUpdated) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationIDPGroupUpdated) SetOldRoleOverride(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_OldRoleOverride = v
}

func (x *PayloadOrganizationIDPGroupUpdated) SetNewRoleOverride(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_NewRoleOverride = v
}

type PayloadOrganizationIDPGroupUpdated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization with the updated IDP group.
	OrganizationId string
	// organization_name is the name of the organization with the updated IDP group.
	OrganizationName string
	// old_role_override is the role override associated with the IDP updated group. Only set if the
	// role override was changed.
	OldRoleOverride v1alpha1.OrganizationRole
	// new_role_override is the role override associated with the IDP updated group. Only set if the
	// role override was changed.
	NewRoleOverride v1alpha1.OrganizationRole
}

func (b0 PayloadOrganizationIDPGroupUpdated_builder) Build() *PayloadOrganizationIDPGroupUpdated {
	m0 := &PayloadOrganizationIDPGroupUpdated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_OldRoleOverride = b.OldRoleOverride
	x.xxx_hidden_NewRoleOverride = b.NewRoleOverride
	return m0
}

type PayloadOrganizationIDPGroupRemoved struct {
	state                       protoimpl.MessageState    `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId   string                    `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_OrganizationName string                    `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3"`
	xxx_hidden_RoleOverride     v1alpha1.OrganizationRole `protobuf:"varint,3,opt,name=role_override,json=roleOverride,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadOrganizationIDPGroupRemoved) Reset() {
	*x = PayloadOrganizationIDPGroupRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationIDPGroupRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationIDPGroupRemoved) ProtoMessage() {}

func (x *PayloadOrganizationIDPGroupRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationIDPGroupRemoved) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupRemoved) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupRemoved) GetRoleOverride() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_RoleOverride
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationIDPGroupRemoved) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *PayloadOrganizationIDPGroupRemoved) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

func (x *PayloadOrganizationIDPGroupRemoved) SetRoleOverride(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_RoleOverride = v
}

type PayloadOrganizationIDPGroupRemoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// organization_id is the id of the organization with the removed IDP group.
	OrganizationId string
	// organization_name is the name of the organization with the removed IDP group.
	OrganizationName string
	// role_override is the role override associated with the removed IDP group.
	RoleOverride v1alpha1.OrganizationRole
}

func (b0 PayloadOrganizationIDPGroupRemoved_builder) Build() *PayloadOrganizationIDPGroupRemoved {
	m0 := &PayloadOrganizationIDPGroupRemoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_OrganizationName = b.OrganizationName
	x.xxx_hidden_RoleOverride = b.RoleOverride
	return m0
}

type PayloadRepositoryCreated struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId          string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName        string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility       v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_DefaultLabelName string                 `protobuf:"bytes,4,opt,name=default_label_name,json=defaultLabelName,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadRepositoryCreated) Reset() {
	*x = PayloadRepositoryCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryCreated) ProtoMessage() {}

func (x *PayloadRepositoryCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryCreated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryCreated) GetDefaultLabelName() string {
	if x != nil {
		return x.xxx_hidden_DefaultLabelName
	}
	return ""
}

func (x *PayloadRepositoryCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryCreated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

func (x *PayloadRepositoryCreated) SetDefaultLabelName(v string) {
	x.xxx_hidden_DefaultLabelName = v
}

type PayloadRepositoryCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility
	// default_label_name is the name of the default label for the repository.
	// If empty, the repository was created with the default label name of 'main'.
	DefaultLabelName string
}

func (b0 PayloadRepositoryCreated_builder) Build() *PayloadRepositoryCreated {
	m0 := &PayloadRepositoryCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_DefaultLabelName = b.DefaultLabelName
	return m0
}

type PayloadRepositoryDeleted struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadRepositoryDeleted) Reset() {
	*x = PayloadRepositoryDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDeleted) ProtoMessage() {}

func (x *PayloadRepositoryDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDeleted) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDeleted) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryDeleted) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryDeleted) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadRepositoryDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadRepositoryDeleted_builder) Build() *PayloadRepositoryDeleted {
	m0 := &PayloadRepositoryDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadRepositoryDeprecated struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId            string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName          string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility         v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_DeprecationMessage string                 `protobuf:"bytes,4,opt,name=deprecation_message,json=deprecationMessage,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *PayloadRepositoryDeprecated) Reset() {
	*x = PayloadRepositoryDeprecated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDeprecated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDeprecated) ProtoMessage() {}

func (x *PayloadRepositoryDeprecated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryDeprecated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDeprecated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDeprecated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryDeprecated) GetDeprecationMessage() string {
	if x != nil {
		return x.xxx_hidden_DeprecationMessage
	}
	return ""
}

func (x *PayloadRepositoryDeprecated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryDeprecated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryDeprecated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

func (x *PayloadRepositoryDeprecated) SetDeprecationMessage(v string) {
	x.xxx_hidden_DeprecationMessage = v
}

type PayloadRepositoryDeprecated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility
	// deprecation_message is the deprecation message set by the deprecation actor.
	DeprecationMessage string
}

func (b0 PayloadRepositoryDeprecated_builder) Build() *PayloadRepositoryDeprecated {
	m0 := &PayloadRepositoryDeprecated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_DeprecationMessage = b.DeprecationMessage
	return m0
}

type PayloadRepositoryUndeprecated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadRepositoryUndeprecated) Reset() {
	*x = PayloadRepositoryUndeprecated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryUndeprecated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryUndeprecated) ProtoMessage() {}

func (x *PayloadRepositoryUndeprecated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryUndeprecated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryUndeprecated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryUndeprecated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryUndeprecated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryUndeprecated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryUndeprecated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadRepositoryUndeprecated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadRepositoryUndeprecated_builder) Build() *PayloadRepositoryUndeprecated {
	m0 := &PayloadRepositoryUndeprecated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadRepositoryCommitPushed struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Tags           []string               `protobuf:"bytes,5,rep,name=tags,proto3"`
	xxx_hidden_DraftName      string                 `protobuf:"bytes,6,opt,name=draft_name,json=draftName,proto3"`
	xxx_hidden_ManifestDigest string                 `protobuf:"bytes,7,opt,name=manifest_digest,json=manifestDigest,proto3"`
	xxx_hidden_B5Digest       string                 `protobuf:"bytes,8,opt,name=b5_digest,json=b5Digest,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryCommitPushed) Reset() {
	*x = PayloadRepositoryCommitPushed{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryCommitPushed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryCommitPushed) ProtoMessage() {}

func (x *PayloadRepositoryCommitPushed) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryCommitPushed) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetTags() []string {
	if x != nil {
		return x.xxx_hidden_Tags
	}
	return nil
}

func (x *PayloadRepositoryCommitPushed) GetDraftName() string {
	if x != nil {
		return x.xxx_hidden_DraftName
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetManifestDigest() string {
	if x != nil {
		return x.xxx_hidden_ManifestDigest
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetB5Digest() string {
	if x != nil {
		return x.xxx_hidden_B5Digest
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryCommitPushed) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryCommitPushed) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryCommitPushed) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryCommitPushed) SetTags(v []string) {
	x.xxx_hidden_Tags = v
}

func (x *PayloadRepositoryCommitPushed) SetDraftName(v string) {
	x.xxx_hidden_DraftName = v
}

func (x *PayloadRepositoryCommitPushed) SetManifestDigest(v string) {
	x.xxx_hidden_ManifestDigest = v
}

func (x *PayloadRepositoryCommitPushed) SetB5Digest(v string) {
	x.xxx_hidden_B5Digest = v
}

type PayloadRepositoryCommitPushed_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// repository_id is the id of the repository within which the commit was created.
	RepositoryId string
	// repository_name is the name of the repository within which the commit was created.
	RepositoryName string
	// tags are the tags included in the push. Optional.
	Tags []string
	// draft_name is the name of the draft. Optional.
	DraftName string
	// manifest_digest is the module's manifest digest.
	ManifestDigest string
	// b5_digest is the module's b5 digest.
	B5Digest string
}

func (b0 PayloadRepositoryCommitPushed_builder) Build() *PayloadRepositoryCommitPushed {
	m0 := &PayloadRepositoryCommitPushed{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Tags = b.Tags
	x.xxx_hidden_DraftName = b.DraftName
	x.xxx_hidden_ManifestDigest = b.ManifestDigest
	x.xxx_hidden_B5Digest = b.B5Digest
	return m0
}

type PayloadRepositoryContributorAdded struct {
	state                      protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_OwnerId         string                  `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName       string                  `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId    string                  `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName  string                  `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_ContributorRole v1alpha1.RepositoryRole `protobuf:"varint,5,opt,name=contributor_role,json=contributorRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *PayloadRepositoryContributorAdded) Reset() {
	*x = PayloadRepositoryContributorAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorAdded) ProtoMessage() {}

func (x *PayloadRepositoryContributorAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryContributorAdded) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetContributorRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_ContributorRole
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorAdded) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryContributorAdded) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryContributorAdded) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryContributorAdded) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryContributorAdded) SetContributorRole(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_ContributorRole = v
}

type PayloadRepositoryContributorAdded_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// repository_id is the id of the repository with the new contributor.
	RepositoryId string
	// repository_name is the name of the repository with the new contributor.
	RepositoryName string
	// contributor_role is the role granted to the contributor added to the repository.
	ContributorRole v1alpha1.RepositoryRole
}

func (b0 PayloadRepositoryContributorAdded_builder) Build() *PayloadRepositoryContributorAdded {
	m0 := &PayloadRepositoryContributorAdded{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_ContributorRole = b.ContributorRole
	return m0
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryContributorRoleChanged struct {
	state                     protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                  `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                  `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                  `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                  `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_OldRole        v1alpha1.RepositoryRole `protobuf:"varint,5,opt,name=old_role,json=oldRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	xxx_hidden_NewRole        v1alpha1.RepositoryRole `protobuf:"varint,6,opt,name=new_role,json=newRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryContributorRoleChanged) Reset() {
	*x = PayloadRepositoryContributorRoleChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorRoleChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorRoleChanged) ProtoMessage() {}

func (x *PayloadRepositoryContributorRoleChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryContributorRoleChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetOldRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_OldRole
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorRoleChanged) GetNewRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_NewRole
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorRoleChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetOldRole(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_OldRole = v
}

func (x *PayloadRepositoryContributorRoleChanged) SetNewRole(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_NewRole = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryContributorRoleChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// repository_id is the id of the repository within which the role was changed.
	RepositoryId string
	// repository_name is the name of the repository within which the role was changed.
	RepositoryName string
	// old_role is the old role of the contributor whose role was changed.
	OldRole v1alpha1.RepositoryRole
	// new_role is the new role of the contributor whose role was changed.
	NewRole v1alpha1.RepositoryRole
}

func (b0 PayloadRepositoryContributorRoleChanged_builder) Build() *PayloadRepositoryContributorRoleChanged {
	m0 := &PayloadRepositoryContributorRoleChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_OldRole = b.OldRole
	x.xxx_hidden_NewRole = b.NewRole
	return m0
}

type PayloadRepositoryContributorRolesChanged struct {
	state                     protoimpl.MessageState                                      `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                                                      `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                                                      `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                                                      `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                                                      `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_OldRoles       *[]*PayloadRepositoryContributorRolesChanged_RepositoryRole `protobuf:"bytes,5,rep,name=old_roles,json=oldRoles,proto3"`
	xxx_hidden_NewRoles       *[]*PayloadRepositoryContributorRolesChanged_RepositoryRole `protobuf:"bytes,6,rep,name=new_roles,json=newRoles,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryContributorRolesChanged) Reset() {
	*x = PayloadRepositoryContributorRolesChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorRolesChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorRolesChanged) ProtoMessage() {}

func (x *PayloadRepositoryContributorRolesChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryContributorRolesChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorRolesChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorRolesChanged) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorRolesChanged) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorRolesChanged) GetOldRoles() []*PayloadRepositoryContributorRolesChanged_RepositoryRole {
	if x != nil {
		if x.xxx_hidden_OldRoles != nil {
			return *x.xxx_hidden_OldRoles
		}
	}
	return nil
}

func (x *PayloadRepositoryContributorRolesChanged) GetNewRoles() []*PayloadRepositoryContributorRolesChanged_RepositoryRole {
	if x != nil {
		if x.xxx_hidden_NewRoles != nil {
			return *x.xxx_hidden_NewRoles
		}
	}
	return nil
}

func (x *PayloadRepositoryContributorRolesChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryContributorRolesChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryContributorRolesChanged) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryContributorRolesChanged) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryContributorRolesChanged) SetOldRoles(v []*PayloadRepositoryContributorRolesChanged_RepositoryRole) {
	x.xxx_hidden_OldRoles = &v
}

func (x *PayloadRepositoryContributorRolesChanged) SetNewRoles(v []*PayloadRepositoryContributorRolesChanged_RepositoryRole) {
	x.xxx_hidden_NewRoles = &v
}

type PayloadRepositoryContributorRolesChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// repository_id is the id of the repository within which the role was changed.
	RepositoryId string
	// repository_name is the name of the repository within which the role was changed.
	RepositoryName string
	// old_roles are the old roles of the contributor.
	OldRoles []*PayloadRepositoryContributorRolesChanged_RepositoryRole
	// new_roles are the new roles of the contributor.
	NewRoles []*PayloadRepositoryContributorRolesChanged_RepositoryRole
}

func (b0 PayloadRepositoryContributorRolesChanged_builder) Build() *PayloadRepositoryContributorRolesChanged {
	m0 := &PayloadRepositoryContributorRolesChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_OldRoles = &b.OldRoles
	x.xxx_hidden_NewRoles = &b.NewRoles
	return m0
}

type PayloadRepositoryContributorRemoved struct {
	state                      protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_OwnerId         string                  `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName       string                  `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId    string                  `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName  string                  `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_ContributorRole v1alpha1.RepositoryRole `protobuf:"varint,5,opt,name=contributor_role,json=contributorRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *PayloadRepositoryContributorRemoved) Reset() {
	*x = PayloadRepositoryContributorRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorRemoved) ProtoMessage() {}

func (x *PayloadRepositoryContributorRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryContributorRemoved) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetContributorRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_ContributorRole
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorRemoved) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryContributorRemoved) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryContributorRemoved) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryContributorRemoved) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryContributorRemoved) SetContributorRole(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_ContributorRole = v
}

type PayloadRepositoryContributorRemoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// repository_id is the id of the repository that the contributor was removed from.
	RepositoryId string
	// repository_name is the name of the repository that the contributor was removed from.
	RepositoryName string
	// contributor_role is the role that the contributor had when removed from the repository.
	ContributorRole v1alpha1.RepositoryRole
}

func (b0 PayloadRepositoryContributorRemoved_builder) Build() *PayloadRepositoryContributorRemoved {
	m0 := &PayloadRepositoryContributorRemoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_ContributorRole = b.ContributorRole
	return m0
}

type PayloadRepositoryVisibilityChanged struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId       string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName     string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_OldVisibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=old_visibility,json=oldVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_NewVisibility v1alpha1.Visibility    `protobuf:"varint,4,opt,name=new_visibility,json=newVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *PayloadRepositoryVisibilityChanged) Reset() {
	*x = PayloadRepositoryVisibilityChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryVisibilityChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryVisibilityChanged) ProtoMessage() {}

func (x *PayloadRepositoryVisibilityChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryVisibilityChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryVisibilityChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryVisibilityChanged) GetOldVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_OldVisibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryVisibilityChanged) GetNewVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_NewVisibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryVisibilityChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryVisibilityChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryVisibilityChanged) SetOldVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_OldVisibility = v
}

func (x *PayloadRepositoryVisibilityChanged) SetNewVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_NewVisibility = v
}

type PayloadRepositoryVisibilityChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// old_visibility is the old visibility of the repository.
	OldVisibility v1alpha1.Visibility
	// new_visibility is the new visibility of the repository.
	NewVisibility v1alpha1.Visibility
}

func (b0 PayloadRepositoryVisibilityChanged_builder) Build() *PayloadRepositoryVisibilityChanged {
	m0 := &PayloadRepositoryVisibilityChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_OldVisibility = b.OldVisibility
	x.xxx_hidden_NewVisibility = b.NewVisibility
	return m0
}

type PayloadRepositoryDefaultLabelNameChanged struct {
	state                          protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId             string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName           string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_OldDefaultLabelName string                 `protobuf:"bytes,3,opt,name=old_default_label_name,json=oldDefaultLabelName,proto3"`
	xxx_hidden_NewDefaultLabelName string                 `protobuf:"bytes,4,opt,name=new_default_label_name,json=newDefaultLabelName,proto3"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *PayloadRepositoryDefaultLabelNameChanged) Reset() {
	*x = PayloadRepositoryDefaultLabelNameChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDefaultLabelNameChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDefaultLabelNameChanged) ProtoMessage() {}

func (x *PayloadRepositoryDefaultLabelNameChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetOldDefaultLabelName() string {
	if x != nil {
		return x.xxx_hidden_OldDefaultLabelName
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetNewDefaultLabelName() string {
	if x != nil {
		return x.xxx_hidden_NewDefaultLabelName
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryDefaultLabelNameChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryDefaultLabelNameChanged) SetOldDefaultLabelName(v string) {
	x.xxx_hidden_OldDefaultLabelName = v
}

func (x *PayloadRepositoryDefaultLabelNameChanged) SetNewDefaultLabelName(v string) {
	x.xxx_hidden_NewDefaultLabelName = v
}

type PayloadRepositoryDefaultLabelNameChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// old_default_label_name is the old default label name of the repository.
	OldDefaultLabelName string
	// new_default_label_name is the new default label name of the repository.
	NewDefaultLabelName string
}

func (b0 PayloadRepositoryDefaultLabelNameChanged_builder) Build() *PayloadRepositoryDefaultLabelNameChanged {
	m0 := &PayloadRepositoryDefaultLabelNameChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_OldDefaultLabelName = b.OldDefaultLabelName
	x.xxx_hidden_NewDefaultLabelName = b.NewDefaultLabelName
	return m0
}

// PayloadRepositoryDefaultBranchChanged is deprecated.
//
// Use PayloadRepositoryDefaultLabelNameChanged instead.
//
// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryDefaultBranchChanged struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId          string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName        string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_OldDefaultBranch string                 `protobuf:"bytes,3,opt,name=old_default_branch,json=oldDefaultBranch,proto3"`
	xxx_hidden_NewDefaultBranch string                 `protobuf:"bytes,4,opt,name=new_default_branch,json=newDefaultBranch,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *PayloadRepositoryDefaultBranchChanged) Reset() {
	*x = PayloadRepositoryDefaultBranchChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDefaultBranchChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDefaultBranchChanged) ProtoMessage() {}

func (x *PayloadRepositoryDefaultBranchChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryDefaultBranchChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) GetOldDefaultBranch() string {
	if x != nil {
		return x.xxx_hidden_OldDefaultBranch
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) GetNewDefaultBranch() string {
	if x != nil {
		return x.xxx_hidden_NewDefaultBranch
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryDefaultBranchChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryDefaultBranchChanged) SetOldDefaultBranch(v string) {
	x.xxx_hidden_OldDefaultBranch = v
}

func (x *PayloadRepositoryDefaultBranchChanged) SetNewDefaultBranch(v string) {
	x.xxx_hidden_NewDefaultBranch = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryDefaultBranchChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository.
	OwnerId string
	// owner_name is the name of the owner of the repository.
	OwnerName string
	// old_default_branch is the old default branch of the repository.
	OldDefaultBranch string
	// new_default_branch is the new default branch of the repository.
	NewDefaultBranch string
}

func (b0 PayloadRepositoryDefaultBranchChanged_builder) Build() *PayloadRepositoryDefaultBranchChanged {
	m0 := &PayloadRepositoryDefaultBranchChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_OldDefaultBranch = b.OldDefaultBranch
	x.xxx_hidden_NewDefaultBranch = b.NewDefaultBranch
	return m0
}

type PayloadRepositoryIDPGroupAdded struct {
	state                     protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId   string                  `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                  `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_RoleOverride   v1alpha1.RepositoryRole `protobuf:"varint,3,opt,name=role_override,json=roleOverride,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryIDPGroupAdded) Reset() {
	*x = PayloadRepositoryIDPGroupAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryIDPGroupAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryIDPGroupAdded) ProtoMessage() {}

func (x *PayloadRepositoryIDPGroupAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryIDPGroupAdded) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryIDPGroupAdded) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryIDPGroupAdded) GetRoleOverride() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_RoleOverride
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryIDPGroupAdded) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryIDPGroupAdded) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryIDPGroupAdded) SetRoleOverride(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_RoleOverride = v
}

type PayloadRepositoryIDPGroupAdded_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// repository_id is the id of the repository with the new IDP group.
	RepositoryId string
	// repository_name is the name of the repository with the new IDP group.
	RepositoryName string
	// role_override is the role override associated with the new IDP group.
	RoleOverride v1alpha1.RepositoryRole
}

func (b0 PayloadRepositoryIDPGroupAdded_builder) Build() *PayloadRepositoryIDPGroupAdded {
	m0 := &PayloadRepositoryIDPGroupAdded{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_RoleOverride = b.RoleOverride
	return m0
}

type PayloadRepositoryIDPGroupUpdated struct {
	state                      protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId    string                  `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName  string                  `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_OldRoleOverride v1alpha1.RepositoryRole `protobuf:"varint,3,opt,name=old_role_override,json=oldRoleOverride,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	xxx_hidden_NewRoleOverride v1alpha1.RepositoryRole `protobuf:"varint,4,opt,name=new_role_override,json=newRoleOverride,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *PayloadRepositoryIDPGroupUpdated) Reset() {
	*x = PayloadRepositoryIDPGroupUpdated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryIDPGroupUpdated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryIDPGroupUpdated) ProtoMessage() {}

func (x *PayloadRepositoryIDPGroupUpdated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryIDPGroupUpdated) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryIDPGroupUpdated) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryIDPGroupUpdated) GetOldRoleOverride() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_OldRoleOverride
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryIDPGroupUpdated) GetNewRoleOverride() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_NewRoleOverride
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryIDPGroupUpdated) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryIDPGroupUpdated) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryIDPGroupUpdated) SetOldRoleOverride(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_OldRoleOverride = v
}

func (x *PayloadRepositoryIDPGroupUpdated) SetNewRoleOverride(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_NewRoleOverride = v
}

type PayloadRepositoryIDPGroupUpdated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// repository_id is the id of the repository with the updated IDP group.
	RepositoryId string
	// repository_name is the name of the repository with the updated IDP group.
	RepositoryName string
	// old_role_override is the role override associated with the IDP updated group. Only set if the
	// role override was changed.
	OldRoleOverride v1alpha1.RepositoryRole
	// new_role_override is the role override associated with the IDP updated group. Only set if the
	// role override was changed.
	NewRoleOverride v1alpha1.RepositoryRole
}

func (b0 PayloadRepositoryIDPGroupUpdated_builder) Build() *PayloadRepositoryIDPGroupUpdated {
	m0 := &PayloadRepositoryIDPGroupUpdated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_OldRoleOverride = b.OldRoleOverride
	x.xxx_hidden_NewRoleOverride = b.NewRoleOverride
	return m0
}

type PayloadRepositoryIDPGroupRemoved struct {
	state                     protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId   string                  `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                  `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_RoleOverride   v1alpha1.RepositoryRole `protobuf:"varint,3,opt,name=role_override,json=roleOverride,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryIDPGroupRemoved) Reset() {
	*x = PayloadRepositoryIDPGroupRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryIDPGroupRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryIDPGroupRemoved) ProtoMessage() {}

func (x *PayloadRepositoryIDPGroupRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryIDPGroupRemoved) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryIDPGroupRemoved) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryIDPGroupRemoved) GetRoleOverride() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_RoleOverride
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryIDPGroupRemoved) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryIDPGroupRemoved) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryIDPGroupRemoved) SetRoleOverride(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_RoleOverride = v
}

type PayloadRepositoryIDPGroupRemoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// repository_id is the id of the repository with the removed IDP group.
	RepositoryId string
	// repository_name is the name of the repository with the removed IDP group.
	RepositoryName string
	// role_override is the role override associated with the removed IDP group.
	RoleOverride v1alpha1.RepositoryRole
}

func (b0 PayloadRepositoryIDPGroupRemoved_builder) Build() *PayloadRepositoryIDPGroupRemoved {
	m0 := &PayloadRepositoryIDPGroupRemoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_RoleOverride = b.RoleOverride
	return m0
}

type PayloadPolicyCreated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPolicyCreated) Reset() {
	*x = PayloadPolicyCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyCreated) ProtoMessage() {}

func (x *PayloadPolicyCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyCreated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPolicyCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyCreated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadPolicyCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy.
	OwnerId string
	// owner_name is the name of the owner of the policy.
	OwnerName string
	// visibility is the visibility of the policy.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadPolicyCreated_builder) Build() *PayloadPolicyCreated {
	m0 := &PayloadPolicyCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadPolicyDeleted struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPolicyDeleted) Reset() {
	*x = PayloadPolicyDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyDeleted) ProtoMessage() {}

func (x *PayloadPolicyDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyDeleted) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyDeleted) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPolicyDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyDeleted) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyDeleted) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadPolicyDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy.
	OwnerId string
	// owner_name is the name of the owner of the policy.
	OwnerName string
	// visibility is the visibility of the policy.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadPolicyDeleted_builder) Build() *PayloadPolicyDeleted {
	m0 := &PayloadPolicyDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadPolicyDeprecated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPolicyDeprecated) Reset() {
	*x = PayloadPolicyDeprecated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyDeprecated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyDeprecated) ProtoMessage() {}

func (x *PayloadPolicyDeprecated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyDeprecated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyDeprecated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyDeprecated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPolicyDeprecated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyDeprecated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyDeprecated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadPolicyDeprecated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy.
	OwnerId string
	// owner_name is the name of the owner of the policy.
	OwnerName string
	// visibility is the visibility of the policy.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadPolicyDeprecated_builder) Build() *PayloadPolicyDeprecated {
	m0 := &PayloadPolicyDeprecated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadPolicyUndeprecated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPolicyUndeprecated) Reset() {
	*x = PayloadPolicyUndeprecated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyUndeprecated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyUndeprecated) ProtoMessage() {}

func (x *PayloadPolicyUndeprecated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyUndeprecated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyUndeprecated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyUndeprecated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPolicyUndeprecated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyUndeprecated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyUndeprecated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadPolicyUndeprecated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy.
	OwnerId string
	// owner_name is the name of the owner of the policy.
	OwnerName string
	// visibility is the visibility of the policy.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadPolicyUndeprecated_builder) Build() *PayloadPolicyUndeprecated {
	m0 := &PayloadPolicyUndeprecated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadPolicyVisibilityChanged struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId       string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName     string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_OldVisibility v1alpha1.Visibility    `protobuf:"varint,4,opt,name=old_visibility,json=oldVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_NewVisibility v1alpha1.Visibility    `protobuf:"varint,5,opt,name=new_visibility,json=newVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *PayloadPolicyVisibilityChanged) Reset() {
	*x = PayloadPolicyVisibilityChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyVisibilityChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyVisibilityChanged) ProtoMessage() {}

func (x *PayloadPolicyVisibilityChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyVisibilityChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyVisibilityChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyVisibilityChanged) GetOldVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_OldVisibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPolicyVisibilityChanged) GetNewVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_NewVisibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPolicyVisibilityChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyVisibilityChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyVisibilityChanged) SetOldVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_OldVisibility = v
}

func (x *PayloadPolicyVisibilityChanged) SetNewVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_NewVisibility = v
}

type PayloadPolicyVisibilityChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy.
	OwnerId string
	// owner_name is the name of the owner of the policy.
	OwnerName string
	// old_visibility is the old visibility of the policy.
	OldVisibility v1alpha1.Visibility
	// new_visibility is the new visibility of the policy.
	NewVisibility v1alpha1.Visibility
}

func (b0 PayloadPolicyVisibilityChanged_builder) Build() *PayloadPolicyVisibilityChanged {
	m0 := &PayloadPolicyVisibilityChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_OldVisibility = b.OldVisibility
	x.xxx_hidden_NewVisibility = b.NewVisibility
	return m0
}

type PayloadPolicyCommitPushed struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PolicyId   string                 `protobuf:"bytes,3,opt,name=policy_id,json=policyId,proto3"`
	xxx_hidden_PolicyName string                 `protobuf:"bytes,4,opt,name=policy_name,json=policyName,proto3"`
	xxx_hidden_P1Digest   string                 `protobuf:"bytes,5,opt,name=p1_digest,json=p1Digest,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPolicyCommitPushed) Reset() {
	*x = PayloadPolicyCommitPushed{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyCommitPushed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyCommitPushed) ProtoMessage() {}

func (x *PayloadPolicyCommitPushed) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyCommitPushed) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyCommitPushed) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyCommitPushed) GetPolicyId() string {
	if x != nil {
		return x.xxx_hidden_PolicyId
	}
	return ""
}

func (x *PayloadPolicyCommitPushed) GetPolicyName() string {
	if x != nil {
		return x.xxx_hidden_PolicyName
	}
	return ""
}

func (x *PayloadPolicyCommitPushed) GetP1Digest() string {
	if x != nil {
		return x.xxx_hidden_P1Digest
	}
	return ""
}

func (x *PayloadPolicyCommitPushed) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyCommitPushed) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyCommitPushed) SetPolicyId(v string) {
	x.xxx_hidden_PolicyId = v
}

func (x *PayloadPolicyCommitPushed) SetPolicyName(v string) {
	x.xxx_hidden_PolicyName = v
}

func (x *PayloadPolicyCommitPushed) SetP1Digest(v string) {
	x.xxx_hidden_P1Digest = v
}

type PayloadPolicyCommitPushed_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy.
	OwnerId string
	// owner_name is the name of the owner of the policy.
	OwnerName string
	// policy_id is the id of the policy within which the commit was created.
	PolicyId string
	// policy_name is the name of the policy within which the commit was created.
	PolicyName string
	// p1_digest is the p1 digest of the pushed policy commit.
	P1Digest string
}

func (b0 PayloadPolicyCommitPushed_builder) Build() *PayloadPolicyCommitPushed {
	m0 := &PayloadPolicyCommitPushed{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PolicyId = b.PolicyId
	x.xxx_hidden_PolicyName = b.PolicyName
	x.xxx_hidden_P1Digest = b.P1Digest
	return m0
}

type PayloadPluginCreated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginType string                 `protobuf:"bytes,3,opt,name=plugin_type,json=pluginType,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,4,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginCreated) Reset() {
	*x = PayloadPluginCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginCreated) ProtoMessage() {}

func (x *PayloadPluginCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginCreated) GetPluginType() string {
	if x != nil {
		return x.xxx_hidden_PluginType
	}
	return ""
}

func (x *PayloadPluginCreated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPluginCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginCreated) SetPluginType(v string) {
	x.xxx_hidden_PluginType = v
}

func (x *PayloadPluginCreated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadPluginCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin.
	OwnerId string
	// owner_name is the name of the owner of the plugin.
	OwnerName string
	// plugin_type is the type of the plugin.
	PluginType string
	// visibility is the visibility of the plugin.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadPluginCreated_builder) Build() *PayloadPluginCreated {
	m0 := &PayloadPluginCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginType = b.PluginType
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadPluginDeleted struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginType string                 `protobuf:"bytes,3,opt,name=plugin_type,json=pluginType,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,4,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginDeleted) Reset() {
	*x = PayloadPluginDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginDeleted) ProtoMessage() {}

func (x *PayloadPluginDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginDeleted) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginDeleted) GetPluginType() string {
	if x != nil {
		return x.xxx_hidden_PluginType
	}
	return ""
}

func (x *PayloadPluginDeleted) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPluginDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginDeleted) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginDeleted) SetPluginType(v string) {
	x.xxx_hidden_PluginType = v
}

func (x *PayloadPluginDeleted) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadPluginDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the check plugin.
	OwnerId string
	// owner_name is the name of the owner of the check plugin.
	OwnerName string
	// plugin_type is the type of the plugin.
	PluginType string
	// visibility is the visibility of the plugin.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadPluginDeleted_builder) Build() *PayloadPluginDeleted {
	m0 := &PayloadPluginDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginType = b.PluginType
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadPluginDeprecated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginType string                 `protobuf:"bytes,3,opt,name=plugin_type,json=pluginType,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,4,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginDeprecated) Reset() {
	*x = PayloadPluginDeprecated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginDeprecated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginDeprecated) ProtoMessage() {}

func (x *PayloadPluginDeprecated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginDeprecated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginDeprecated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginDeprecated) GetPluginType() string {
	if x != nil {
		return x.xxx_hidden_PluginType
	}
	return ""
}

func (x *PayloadPluginDeprecated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPluginDeprecated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginDeprecated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginDeprecated) SetPluginType(v string) {
	x.xxx_hidden_PluginType = v
}

func (x *PayloadPluginDeprecated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadPluginDeprecated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the check plugin.
	OwnerId string
	// owner_name is the name of the owner of the check plugin.
	OwnerName string
	// plugin_type is the type of the plugin.
	PluginType string
	// visibility is the visibility of the plugin.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadPluginDeprecated_builder) Build() *PayloadPluginDeprecated {
	m0 := &PayloadPluginDeprecated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginType = b.PluginType
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadPluginUndeprecated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginType string                 `protobuf:"bytes,3,opt,name=plugin_type,json=pluginType,proto3"`
	xxx_hidden_Visibility v1alpha1.Visibility    `protobuf:"varint,4,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginUndeprecated) Reset() {
	*x = PayloadPluginUndeprecated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginUndeprecated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginUndeprecated) ProtoMessage() {}

func (x *PayloadPluginUndeprecated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginUndeprecated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginUndeprecated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginUndeprecated) GetPluginType() string {
	if x != nil {
		return x.xxx_hidden_PluginType
	}
	return ""
}

func (x *PayloadPluginUndeprecated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPluginUndeprecated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginUndeprecated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginUndeprecated) SetPluginType(v string) {
	x.xxx_hidden_PluginType = v
}

func (x *PayloadPluginUndeprecated) SetVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_Visibility = v
}

type PayloadPluginUndeprecated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the check plugin.
	OwnerId string
	// owner_name is the name of the owner of the check plugin.
	OwnerName string
	// plugin_type is the type of the plugin.
	PluginType string
	// visibility is the visibility of the plugin.
	Visibility v1alpha1.Visibility
}

func (b0 PayloadPluginUndeprecated_builder) Build() *PayloadPluginUndeprecated {
	m0 := &PayloadPluginUndeprecated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginType = b.PluginType
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type PayloadPluginVisibilityChanged struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId       string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName     string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginType    string                 `protobuf:"bytes,3,opt,name=plugin_type,json=pluginType,proto3"`
	xxx_hidden_OldVisibility v1alpha1.Visibility    `protobuf:"varint,4,opt,name=old_visibility,json=oldVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_NewVisibility v1alpha1.Visibility    `protobuf:"varint,5,opt,name=new_visibility,json=newVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *PayloadPluginVisibilityChanged) Reset() {
	*x = PayloadPluginVisibilityChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginVisibilityChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginVisibilityChanged) ProtoMessage() {}

func (x *PayloadPluginVisibilityChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginVisibilityChanged) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginVisibilityChanged) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginVisibilityChanged) GetPluginType() string {
	if x != nil {
		return x.xxx_hidden_PluginType
	}
	return ""
}

func (x *PayloadPluginVisibilityChanged) GetOldVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_OldVisibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPluginVisibilityChanged) GetNewVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.xxx_hidden_NewVisibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadPluginVisibilityChanged) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginVisibilityChanged) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginVisibilityChanged) SetPluginType(v string) {
	x.xxx_hidden_PluginType = v
}

func (x *PayloadPluginVisibilityChanged) SetOldVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_OldVisibility = v
}

func (x *PayloadPluginVisibilityChanged) SetNewVisibility(v v1alpha1.Visibility) {
	x.xxx_hidden_NewVisibility = v
}

type PayloadPluginVisibilityChanged_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the check plugin.
	OwnerId string
	// owner_name is the name of the owner of the check plugin.
	OwnerName string
	// plugin_type is the type of the plugin.
	PluginType string
	// old_visibility is the old visibility of the plugin.
	OldVisibility v1alpha1.Visibility
	// new_visibility is the new visibility of the plugin.
	NewVisibility v1alpha1.Visibility
}

func (b0 PayloadPluginVisibilityChanged_builder) Build() *PayloadPluginVisibilityChanged {
	m0 := &PayloadPluginVisibilityChanged{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginType = b.PluginType
	x.xxx_hidden_OldVisibility = b.OldVisibility
	x.xxx_hidden_NewVisibility = b.NewVisibility
	return m0
}

type PayloadPluginCommitPushed struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId   string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	xxx_hidden_P1Digest   string                 `protobuf:"bytes,5,opt,name=p1_digest,json=p1Digest,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginCommitPushed) Reset() {
	*x = PayloadPluginCommitPushed{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginCommitPushed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginCommitPushed) ProtoMessage() {}

func (x *PayloadPluginCommitPushed) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginCommitPushed) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginCommitPushed) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginCommitPushed) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginCommitPushed) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginCommitPushed) GetP1Digest() string {
	if x != nil {
		return x.xxx_hidden_P1Digest
	}
	return ""
}

func (x *PayloadPluginCommitPushed) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginCommitPushed) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginCommitPushed) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginCommitPushed) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

func (x *PayloadPluginCommitPushed) SetP1Digest(v string) {
	x.xxx_hidden_P1Digest = v
}

type PayloadPluginCommitPushed_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin.
	OwnerId string
	// owner_name is the name of the owner of the plugin.
	OwnerName string
	// plugin_id is the id of the plugin.
	PluginId string
	// plugin_name is the name of the plugin.
	PluginName string
	// p1_digest is the p1 digest of the pushed plugin commit.
	P1Digest string
}

func (b0 PayloadPluginCommitPushed_builder) Build() *PayloadPluginCommitPushed {
	m0 := &PayloadPluginCommitPushed{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	x.xxx_hidden_P1Digest = b.P1Digest
	return m0
}

type PayloadUserCreated struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserCreated) Reset() {
	*x = PayloadUserCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserCreated) ProtoMessage() {}

func (x *PayloadUserCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserCreated_builder) Build() *PayloadUserCreated {
	m0 := &PayloadUserCreated{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserReactivated struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserReactivated) Reset() {
	*x = PayloadUserReactivated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserReactivated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserReactivated) ProtoMessage() {}

func (x *PayloadUserReactivated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserReactivated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserReactivated_builder) Build() *PayloadUserReactivated {
	m0 := &PayloadUserReactivated{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserDeactivated struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserDeactivated) Reset() {
	*x = PayloadUserDeactivated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserDeactivated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserDeactivated) ProtoMessage() {}

func (x *PayloadUserDeactivated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserDeactivated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserDeactivated_builder) Build() *PayloadUserDeactivated {
	m0 := &PayloadUserDeactivated{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserDeleted struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserDeleted) Reset() {
	*x = PayloadUserDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserDeleted) ProtoMessage() {}

func (x *PayloadUserDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserDeleted_builder) Build() *PayloadUserDeleted {
	m0 := &PayloadUserDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserLoggedIn struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserLoggedIn) Reset() {
	*x = PayloadUserLoggedIn{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserLoggedIn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserLoggedIn) ProtoMessage() {}

func (x *PayloadUserLoggedIn) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserLoggedIn_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserLoggedIn_builder) Build() *PayloadUserLoggedIn {
	m0 := &PayloadUserLoggedIn{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadUserLoggedOut struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserLoggedOut) Reset() {
	*x = PayloadUserLoggedOut{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserLoggedOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserLoggedOut) ProtoMessage() {}

func (x *PayloadUserLoggedOut) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserLoggedOut_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserLoggedOut_builder) Build() *PayloadUserLoggedOut {
	m0 := &PayloadUserLoggedOut{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// PayloadUserAutoMergedFromNewIdP is the payload for the audit event
// EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP. It has no additional information
// to be included, since the new user is automatically merged to an existing user
// without the new user being created.
type PayloadUserAutoMergedFromNewIdP struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadUserAutoMergedFromNewIdP) Reset() {
	*x = PayloadUserAutoMergedFromNewIdP{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserAutoMergedFromNewIdP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserAutoMergedFromNewIdP) ProtoMessage() {}

func (x *PayloadUserAutoMergedFromNewIdP) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadUserAutoMergedFromNewIdP_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadUserAutoMergedFromNewIdP_builder) Build() *PayloadUserAutoMergedFromNewIdP {
	m0 := &PayloadUserAutoMergedFromNewIdP{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadCuratedPluginCreated struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId   string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *PayloadCuratedPluginCreated) Reset() {
	*x = PayloadCuratedPluginCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadCuratedPluginCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadCuratedPluginCreated) ProtoMessage() {}

func (x *PayloadCuratedPluginCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadCuratedPluginCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadCuratedPluginCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadCuratedPluginCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadCuratedPluginCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

type PayloadCuratedPluginCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin.
	OwnerId string
	// owner_name is the name of the owner of the plugin.
	OwnerName string
}

func (b0 PayloadCuratedPluginCreated_builder) Build() *PayloadCuratedPluginCreated {
	m0 := &PayloadCuratedPluginCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	return m0
}

type PayloadCuratedPluginDeleted struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId   string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *PayloadCuratedPluginDeleted) Reset() {
	*x = PayloadCuratedPluginDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadCuratedPluginDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadCuratedPluginDeleted) ProtoMessage() {}

func (x *PayloadCuratedPluginDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadCuratedPluginDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadCuratedPluginDeleted) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadCuratedPluginDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadCuratedPluginDeleted) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

type PayloadCuratedPluginDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin.
	OwnerId string
	// owner_name is the name of the owner of the plugin.
	OwnerName string
}

func (b0 PayloadCuratedPluginDeleted_builder) Build() *PayloadCuratedPluginDeleted {
	m0 := &PayloadCuratedPluginDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	return m0
}

type PayloadTokenCreated struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId         string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_TokenExpiryTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=token_expiry_time,json=tokenExpiryTime,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *PayloadTokenCreated) Reset() {
	*x = PayloadTokenCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadTokenCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadTokenCreated) ProtoMessage() {}

func (x *PayloadTokenCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadTokenCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadTokenCreated) GetTokenExpiryTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_TokenExpiryTime
	}
	return nil
}

func (x *PayloadTokenCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadTokenCreated) SetTokenExpiryTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_TokenExpiryTime = v
}

func (x *PayloadTokenCreated) HasTokenExpiryTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_TokenExpiryTime != nil
}

func (x *PayloadTokenCreated) ClearTokenExpiryTime() {
	x.xxx_hidden_TokenExpiryTime = nil
}

type PayloadTokenCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the token.
	OwnerId string
	// token_expiry_time is the expiry time of the token.
	TokenExpiryTime *timestamppb.Timestamp
}

func (b0 PayloadTokenCreated_builder) Build() *PayloadTokenCreated {
	m0 := &PayloadTokenCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_TokenExpiryTime = b.TokenExpiryTime
	return m0
}

type PayloadTokenDeleted struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PayloadTokenDeleted) Reset() {
	*x = PayloadTokenDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadTokenDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadTokenDeleted) ProtoMessage() {}

func (x *PayloadTokenDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadTokenDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadTokenDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

type PayloadTokenDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the token.
	OwnerId string
}

func (b0 PayloadTokenDeleted_builder) Build() *PayloadTokenDeleted {
	m0 := &PayloadTokenDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	return m0
}

type PayloadSCIMTokenCreated struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_TokenExpiryTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=token_expiry_time,json=tokenExpiryTime,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *PayloadSCIMTokenCreated) Reset() {
	*x = PayloadSCIMTokenCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadSCIMTokenCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadSCIMTokenCreated) ProtoMessage() {}

func (x *PayloadSCIMTokenCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadSCIMTokenCreated) GetTokenExpiryTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_TokenExpiryTime
	}
	return nil
}

func (x *PayloadSCIMTokenCreated) SetTokenExpiryTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_TokenExpiryTime = v
}

func (x *PayloadSCIMTokenCreated) HasTokenExpiryTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_TokenExpiryTime != nil
}

func (x *PayloadSCIMTokenCreated) ClearTokenExpiryTime() {
	x.xxx_hidden_TokenExpiryTime = nil
}

type PayloadSCIMTokenCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// token_expiry_time is the expiry time of the token.
	TokenExpiryTime *timestamppb.Timestamp
}

func (b0 PayloadSCIMTokenCreated_builder) Build() *PayloadSCIMTokenCreated {
	m0 := &PayloadSCIMTokenCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_TokenExpiryTime = b.TokenExpiryTime
	return m0
}

type PayloadSCIMTokenDeleted struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadSCIMTokenDeleted) Reset() {
	*x = PayloadSCIMTokenDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadSCIMTokenDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadSCIMTokenDeleted) ProtoMessage() {}

func (x *PayloadSCIMTokenDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadSCIMTokenDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadSCIMTokenDeleted_builder) Build() *PayloadSCIMTokenDeleted {
	m0 := &PayloadSCIMTokenDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// PayloadRepositoryCommitDeleted is deprecated.
//
// Individual repository commits cannot be deleted.
//
// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryCommitDeleted struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_DraftName      string                 `protobuf:"bytes,5,opt,name=draft_name,json=draftName,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryCommitDeleted) Reset() {
	*x = PayloadRepositoryCommitDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryCommitDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryCommitDeleted) ProtoMessage() {}

func (x *PayloadRepositoryCommitDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryCommitDeleted) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetDraftName() string {
	if x != nil {
		return x.xxx_hidden_DraftName
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryCommitDeleted) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryCommitDeleted) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryCommitDeleted) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadRepositoryCommitDeleted) SetDraftName(v string) {
	x.xxx_hidden_DraftName = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
type PayloadRepositoryCommitDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository from which the commit will be deleted.
	OwnerId string
	// owner_name is the name of the owner of the repository from which the commit will be deleted.
	OwnerName string
	// repository_id is the id of the repository from which the commit will be deleted.
	RepositoryId string
	// repository_name is the name of the repository from which the commit will be deleted.
	RepositoryName string
	// draft_name is the name of the draft. Optional.
	DraftName string
}

func (b0 PayloadRepositoryCommitDeleted_builder) Build() *PayloadRepositoryCommitDeleted {
	m0 := &PayloadRepositoryCommitDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_DraftName = b.DraftName
	return m0
}

type PayloadRepositoryLabelCreated struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_LabelNamespace string                 `protobuf:"bytes,5,opt,name=label_namespace,json=labelNamespace,proto3"`
	xxx_hidden_CommitId       string                 `protobuf:"bytes,6,opt,name=commit_id,json=commitId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryLabelCreated) Reset() {
	*x = PayloadRepositoryLabelCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelCreated) ProtoMessage() {}

func (x *PayloadRepositoryLabelCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryLabelCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelCreated) GetLabelNamespace() string {
	if x != nil {
		return x.xxx_hidden_LabelNamespace
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetCommitId() string {
	if x != nil {
		return x.xxx_hidden_CommitId
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryLabelCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryLabelCreated) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryLabelCreated) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelCreated) SetLabelNamespace(v string) {
	x.xxx_hidden_LabelNamespace = v
}

func (x *PayloadRepositoryLabelCreated) SetCommitId(v string) {
	x.xxx_hidden_CommitId = v
}

type PayloadRepositoryLabelCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository on which the label was created.
	OwnerId string
	// owner_name is the name of the owner of the repository on which the label was created.
	OwnerName string
	// repository_id is the id of the repository on which the label was created.
	RepositoryId string
	// repository_name is the name of the repository from which the label was created.
	RepositoryName string
	// label_namespace is the namespace of the label that was created.
	//
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	LabelNamespace string
	// commit_id is the id of the commit on which the label was created.
	CommitId string
}

func (b0 PayloadRepositoryLabelCreated_builder) Build() *PayloadRepositoryLabelCreated {
	m0 := &PayloadRepositoryLabelCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_LabelNamespace = b.LabelNamespace
	x.xxx_hidden_CommitId = b.CommitId
	return m0
}

type PayloadRepositoryLabelMoved struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_LabelNamespace string                 `protobuf:"bytes,5,opt,name=label_namespace,json=labelNamespace,proto3"`
	xxx_hidden_ToCommitId     string                 `protobuf:"bytes,6,opt,name=to_commit_id,json=toCommitId,proto3"`
	xxx_hidden_FromCommitId   string                 `protobuf:"bytes,7,opt,name=from_commit_id,json=fromCommitId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryLabelMoved) Reset() {
	*x = PayloadRepositoryLabelMoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelMoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelMoved) ProtoMessage() {}

func (x *PayloadRepositoryLabelMoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryLabelMoved) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelMoved) GetLabelNamespace() string {
	if x != nil {
		return x.xxx_hidden_LabelNamespace
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetToCommitId() string {
	if x != nil {
		return x.xxx_hidden_ToCommitId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetFromCommitId() string {
	if x != nil {
		return x.xxx_hidden_FromCommitId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryLabelMoved) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryLabelMoved) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryLabelMoved) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelMoved) SetLabelNamespace(v string) {
	x.xxx_hidden_LabelNamespace = v
}

func (x *PayloadRepositoryLabelMoved) SetToCommitId(v string) {
	x.xxx_hidden_ToCommitId = v
}

func (x *PayloadRepositoryLabelMoved) SetFromCommitId(v string) {
	x.xxx_hidden_FromCommitId = v
}

type PayloadRepositoryLabelMoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository on which the label was moved.
	OwnerId string
	// owner_name is the name of the owner of the repository on which the label was moved.
	OwnerName string
	// repository_id is the id of the repository on which the label was moved.
	RepositoryId string
	// repository_name is the name of the repository from which the label was moved.
	RepositoryName string
	// label_namespace is the namespace of the label that was moved.
	//
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	LabelNamespace string
	// to_commit_id is the id of the commit on which the label was moved to.
	ToCommitId string
	// from_commit_id is the id of the commit on which the label was moved from.
	FromCommitId string
}

func (b0 PayloadRepositoryLabelMoved_builder) Build() *PayloadRepositoryLabelMoved {
	m0 := &PayloadRepositoryLabelMoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_LabelNamespace = b.LabelNamespace
	x.xxx_hidden_ToCommitId = b.ToCommitId
	x.xxx_hidden_FromCommitId = b.FromCommitId
	return m0
}

type PayloadRepositoryLabelArchived struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryLabelArchived) Reset() {
	*x = PayloadRepositoryLabelArchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelArchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelArchived) ProtoMessage() {}

func (x *PayloadRepositoryLabelArchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryLabelArchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryLabelArchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryLabelArchived) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryLabelArchived) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

type PayloadRepositoryLabelArchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository on which the label was archived.
	OwnerId string
	// owner_name is the name of the owner of the repository on which the label was archived.
	OwnerName string
	// repository_id is the id of the repository on which the label was archived.
	RepositoryId string
	// repository_name is the name of the repository from which the label was archived.
	RepositoryName string
}

func (b0 PayloadRepositoryLabelArchived_builder) Build() *PayloadRepositoryLabelArchived {
	m0 := &PayloadRepositoryLabelArchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	return m0
}

type PayloadRepositoryLabelUnarchived struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId        string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PayloadRepositoryLabelUnarchived) Reset() {
	*x = PayloadRepositoryLabelUnarchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelUnarchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelUnarchived) ProtoMessage() {}

func (x *PayloadRepositoryLabelUnarchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryLabelUnarchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadRepositoryLabelUnarchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadRepositoryLabelUnarchived) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadRepositoryLabelUnarchived) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

type PayloadRepositoryLabelUnarchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the repository on which the label was unarchived.
	OwnerId string
	// owner_name is the name of the owner of the repository on which the label was unarchived.
	OwnerName string
	// repository_id is the id of the repository on which the label was unarchived.
	RepositoryId string
	// repository_name is the name of the repository from which the label was unarchived.
	RepositoryName string
}

func (b0 PayloadRepositoryLabelUnarchived_builder) Build() *PayloadRepositoryLabelUnarchived {
	m0 := &PayloadRepositoryLabelUnarchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	return m0
}

type PayloadServerBreakingChangePolicyEnabled struct {
	state                             protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_Category               v1alpha1.BreakingChangeCategory `protobuf:"varint,1,opt,name=category,proto3,enum=buf.alpha.registry.v1alpha1.BreakingChangeCategory"`
	xxx_hidden_IgnoreUnstablePackages bool                            `protobuf:"varint,2,opt,name=ignore_unstable_packages,json=ignoreUnstablePackages,proto3,oneof"`
	XXX_raceDetectHookData            protoimpl.RaceDetectHookData
	XXX_presence                      [1]uint32
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *PayloadServerBreakingChangePolicyEnabled) Reset() {
	*x = PayloadServerBreakingChangePolicyEnabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerBreakingChangePolicyEnabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerBreakingChangePolicyEnabled) ProtoMessage() {}

func (x *PayloadServerBreakingChangePolicyEnabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadServerBreakingChangePolicyEnabled) GetCategory() v1alpha1.BreakingChangeCategory {
	if x != nil {
		return x.xxx_hidden_Category
	}
	return v1alpha1.BreakingChangeCategory(0)
}

func (x *PayloadServerBreakingChangePolicyEnabled) GetIgnoreUnstablePackages() bool {
	if x != nil {
		return x.xxx_hidden_IgnoreUnstablePackages
	}
	return false
}

func (x *PayloadServerBreakingChangePolicyEnabled) SetCategory(v v1alpha1.BreakingChangeCategory) {
	x.xxx_hidden_Category = v
}

func (x *PayloadServerBreakingChangePolicyEnabled) SetIgnoreUnstablePackages(v bool) {
	x.xxx_hidden_IgnoreUnstablePackages = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 1, 2)
}

func (x *PayloadServerBreakingChangePolicyEnabled) HasIgnoreUnstablePackages() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 1)
}

func (x *PayloadServerBreakingChangePolicyEnabled) ClearIgnoreUnstablePackages() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 1)
	x.xxx_hidden_IgnoreUnstablePackages = false
}

type PayloadServerBreakingChangePolicyEnabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// category is the category of breaking changes.
	Category v1alpha1.BreakingChangeCategory
	// ignore_unstable_packages tracks breaking change enforcement for unstable packages.
	IgnoreUnstablePackages *bool
}

func (b0 PayloadServerBreakingChangePolicyEnabled_builder) Build() *PayloadServerBreakingChangePolicyEnabled {
	m0 := &PayloadServerBreakingChangePolicyEnabled{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Category = b.Category
	if b.IgnoreUnstablePackages != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 1, 2)
		x.xxx_hidden_IgnoreUnstablePackages = *b.IgnoreUnstablePackages
	}
	return m0
}

type PayloadServerBreakingChangePolicyDisabled struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadServerBreakingChangePolicyDisabled) Reset() {
	*x = PayloadServerBreakingChangePolicyDisabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerBreakingChangePolicyDisabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerBreakingChangePolicyDisabled) ProtoMessage() {}

func (x *PayloadServerBreakingChangePolicyDisabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadServerBreakingChangePolicyDisabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadServerBreakingChangePolicyDisabled_builder) Build() *PayloadServerBreakingChangePolicyDisabled {
	m0 := &PayloadServerBreakingChangePolicyDisabled{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadServerReviewFlowEnabled struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadServerReviewFlowEnabled) Reset() {
	*x = PayloadServerReviewFlowEnabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerReviewFlowEnabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerReviewFlowEnabled) ProtoMessage() {}

func (x *PayloadServerReviewFlowEnabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadServerReviewFlowEnabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadServerReviewFlowEnabled_builder) Build() *PayloadServerReviewFlowEnabled {
	m0 := &PayloadServerReviewFlowEnabled{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadServerReviewFlowDisabled struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadServerReviewFlowDisabled) Reset() {
	*x = PayloadServerReviewFlowDisabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerReviewFlowDisabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerReviewFlowDisabled) ProtoMessage() {}

func (x *PayloadServerReviewFlowDisabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadServerReviewFlowDisabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadServerReviewFlowDisabled_builder) Build() *PayloadServerReviewFlowDisabled {
	m0 := &PayloadServerReviewFlowDisabled{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadServerUniquenessPolicyEnabled struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadServerUniquenessPolicyEnabled) Reset() {
	*x = PayloadServerUniquenessPolicyEnabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerUniquenessPolicyEnabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerUniquenessPolicyEnabled) ProtoMessage() {}

func (x *PayloadServerUniquenessPolicyEnabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadServerUniquenessPolicyEnabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadServerUniquenessPolicyEnabled_builder) Build() *PayloadServerUniquenessPolicyEnabled {
	m0 := &PayloadServerUniquenessPolicyEnabled{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadServerUniquenessPolicyDisabled struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PayloadServerUniquenessPolicyDisabled) Reset() {
	*x = PayloadServerUniquenessPolicyDisabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerUniquenessPolicyDisabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerUniquenessPolicyDisabled) ProtoMessage() {}

func (x *PayloadServerUniquenessPolicyDisabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type PayloadServerUniquenessPolicyDisabled_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 PayloadServerUniquenessPolicyDisabled_builder) Build() *PayloadServerUniquenessPolicyDisabled {
	m0 := &PayloadServerUniquenessPolicyDisabled{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type PayloadDeviceAuthorizationGrantApproved struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ClientId string                 `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *PayloadDeviceAuthorizationGrantApproved) Reset() {
	*x = PayloadDeviceAuthorizationGrantApproved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadDeviceAuthorizationGrantApproved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadDeviceAuthorizationGrantApproved) ProtoMessage() {}

func (x *PayloadDeviceAuthorizationGrantApproved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadDeviceAuthorizationGrantApproved) GetClientId() string {
	if x != nil {
		return x.xxx_hidden_ClientId
	}
	return ""
}

func (x *PayloadDeviceAuthorizationGrantApproved) SetClientId(v string) {
	x.xxx_hidden_ClientId = v
}

type PayloadDeviceAuthorizationGrantApproved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// client_id is the id of the registered oauth2 client of the grant.
	ClientId string
}

func (b0 PayloadDeviceAuthorizationGrantApproved_builder) Build() *PayloadDeviceAuthorizationGrantApproved {
	m0 := &PayloadDeviceAuthorizationGrantApproved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ClientId = b.ClientId
	return m0
}

type PayloadDeviceAuthorizationGrantDenied struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ClientId string                 `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *PayloadDeviceAuthorizationGrantDenied) Reset() {
	*x = PayloadDeviceAuthorizationGrantDenied{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadDeviceAuthorizationGrantDenied) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadDeviceAuthorizationGrantDenied) ProtoMessage() {}

func (x *PayloadDeviceAuthorizationGrantDenied) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadDeviceAuthorizationGrantDenied) GetClientId() string {
	if x != nil {
		return x.xxx_hidden_ClientId
	}
	return ""
}

func (x *PayloadDeviceAuthorizationGrantDenied) SetClientId(v string) {
	x.xxx_hidden_ClientId = v
}

type PayloadDeviceAuthorizationGrantDenied_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// client_id is the id of the registered oauth2 client of the grant.
	ClientId string
}

func (b0 PayloadDeviceAuthorizationGrantDenied_builder) Build() *PayloadDeviceAuthorizationGrantDenied {
	m0 := &PayloadDeviceAuthorizationGrantDenied{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ClientId = b.ClientId
	return m0
}

type PayloadPluginLabelCreated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId   string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	xxx_hidden_CommitId   string                 `protobuf:"bytes,6,opt,name=commit_id,json=commitId,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginLabelCreated) Reset() {
	*x = PayloadPluginLabelCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginLabelCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginLabelCreated) ProtoMessage() {}

func (x *PayloadPluginLabelCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginLabelCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginLabelCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginLabelCreated) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginLabelCreated) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginLabelCreated) GetCommitId() string {
	if x != nil {
		return x.xxx_hidden_CommitId
	}
	return ""
}

func (x *PayloadPluginLabelCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginLabelCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginLabelCreated) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginLabelCreated) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

func (x *PayloadPluginLabelCreated) SetCommitId(v string) {
	x.xxx_hidden_CommitId = v
}

type PayloadPluginLabelCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin on which the label was created.
	OwnerId string
	// owner_name is the name of the owner of the plugin on which the label was created.
	OwnerName string
	// plugin_id is the id of the plugin on which the label was created.
	PluginId string
	// plugin_name is the name of the plugin from which the label was created.
	PluginName string
	// commit_id is the id of the commit on which the label was created.
	CommitId string
}

func (b0 PayloadPluginLabelCreated_builder) Build() *PayloadPluginLabelCreated {
	m0 := &PayloadPluginLabelCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	x.xxx_hidden_CommitId = b.CommitId
	return m0
}

type PayloadPluginLabelMoved struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId      string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName    string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId     string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName   string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	xxx_hidden_ToCommitId   string                 `protobuf:"bytes,6,opt,name=to_commit_id,json=toCommitId,proto3"`
	xxx_hidden_FromCommitId string                 `protobuf:"bytes,7,opt,name=from_commit_id,json=fromCommitId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *PayloadPluginLabelMoved) Reset() {
	*x = PayloadPluginLabelMoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginLabelMoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginLabelMoved) ProtoMessage() {}

func (x *PayloadPluginLabelMoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginLabelMoved) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetToCommitId() string {
	if x != nil {
		return x.xxx_hidden_ToCommitId
	}
	return ""
}

func (x *PayloadPluginLabelMoved) GetFromCommitId() string {
	if x != nil {
		return x.xxx_hidden_FromCommitId
	}
	return ""
}

func (x *PayloadPluginLabelMoved) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginLabelMoved) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginLabelMoved) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginLabelMoved) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

func (x *PayloadPluginLabelMoved) SetToCommitId(v string) {
	x.xxx_hidden_ToCommitId = v
}

func (x *PayloadPluginLabelMoved) SetFromCommitId(v string) {
	x.xxx_hidden_FromCommitId = v
}

type PayloadPluginLabelMoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin on which the label was moved.
	OwnerId string
	// owner_name is the name of the owner of the plugin on which the label was moved.
	OwnerName string
	// plugin_id is the id of the plugin on which the label was moved.
	PluginId string
	// plugin_name is the name of the plugin from which the label was moved.
	PluginName string
	// to_commit_id is the id of the commit on which the label was moved to.
	ToCommitId string
	// from_commit_id is the id of the commit on which the label was moved from.
	FromCommitId string
}

func (b0 PayloadPluginLabelMoved_builder) Build() *PayloadPluginLabelMoved {
	m0 := &PayloadPluginLabelMoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	x.xxx_hidden_ToCommitId = b.ToCommitId
	x.xxx_hidden_FromCommitId = b.FromCommitId
	return m0
}

type PayloadPluginLabelArchived struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId   string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginLabelArchived) Reset() {
	*x = PayloadPluginLabelArchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginLabelArchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginLabelArchived) ProtoMessage() {}

func (x *PayloadPluginLabelArchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginLabelArchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginLabelArchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginLabelArchived) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginLabelArchived) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginLabelArchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginLabelArchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginLabelArchived) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginLabelArchived) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

type PayloadPluginLabelArchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin on which the label was archived.
	OwnerId string
	// owner_name is the name of the owner of the plugin on which the label was archived.
	OwnerName string
	// plugin_id is the id of the plugin on which the label was archived.
	PluginId string
	// plugin_name is the name of the plugin from which the label was archived.
	PluginName string
}

func (b0 PayloadPluginLabelArchived_builder) Build() *PayloadPluginLabelArchived {
	m0 := &PayloadPluginLabelArchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	return m0
}

type PayloadPluginLabelUnarchived struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PluginId   string                 `protobuf:"bytes,3,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName string                 `protobuf:"bytes,4,opt,name=plugin_name,json=pluginName,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPluginLabelUnarchived) Reset() {
	*x = PayloadPluginLabelUnarchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPluginLabelUnarchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPluginLabelUnarchived) ProtoMessage() {}

func (x *PayloadPluginLabelUnarchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPluginLabelUnarchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPluginLabelUnarchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPluginLabelUnarchived) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadPluginLabelUnarchived) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadPluginLabelUnarchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPluginLabelUnarchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPluginLabelUnarchived) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadPluginLabelUnarchived) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

type PayloadPluginLabelUnarchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the plugin on which the label was unarchived.
	OwnerId string
	// owner_name is the name of the owner of the plugin on which the label was unarchived.
	OwnerName string
	// plugin_id is the id of the plugin on which the label was unarchived.
	PluginId string
	// plugin_name is the name of the plugin from which the label was unarchived.
	PluginName string
}

func (b0 PayloadPluginLabelUnarchived_builder) Build() *PayloadPluginLabelUnarchived {
	m0 := &PayloadPluginLabelUnarchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	return m0
}

type PayloadPolicyLabelCreated struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PolicyId   string                 `protobuf:"bytes,3,opt,name=policy_id,json=policyId,proto3"`
	xxx_hidden_PolicyName string                 `protobuf:"bytes,4,opt,name=policy_name,json=policyName,proto3"`
	xxx_hidden_CommitId   string                 `protobuf:"bytes,6,opt,name=commit_id,json=commitId,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPolicyLabelCreated) Reset() {
	*x = PayloadPolicyLabelCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyLabelCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyLabelCreated) ProtoMessage() {}

func (x *PayloadPolicyLabelCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyLabelCreated) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyLabelCreated) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyLabelCreated) GetPolicyId() string {
	if x != nil {
		return x.xxx_hidden_PolicyId
	}
	return ""
}

func (x *PayloadPolicyLabelCreated) GetPolicyName() string {
	if x != nil {
		return x.xxx_hidden_PolicyName
	}
	return ""
}

func (x *PayloadPolicyLabelCreated) GetCommitId() string {
	if x != nil {
		return x.xxx_hidden_CommitId
	}
	return ""
}

func (x *PayloadPolicyLabelCreated) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyLabelCreated) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyLabelCreated) SetPolicyId(v string) {
	x.xxx_hidden_PolicyId = v
}

func (x *PayloadPolicyLabelCreated) SetPolicyName(v string) {
	x.xxx_hidden_PolicyName = v
}

func (x *PayloadPolicyLabelCreated) SetCommitId(v string) {
	x.xxx_hidden_CommitId = v
}

type PayloadPolicyLabelCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy on which the label was created.
	OwnerId string
	// owner_name is the name of the owner of the policy on which the label was created.
	OwnerName string
	// policy_id is the id of the policy on which the label was created.
	PolicyId string
	// policy_name is the name of the policy from which the label was created.
	PolicyName string
	// commit_id is the id of the commit on which the label was created.
	CommitId string
}

func (b0 PayloadPolicyLabelCreated_builder) Build() *PayloadPolicyLabelCreated {
	m0 := &PayloadPolicyLabelCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PolicyId = b.PolicyId
	x.xxx_hidden_PolicyName = b.PolicyName
	x.xxx_hidden_CommitId = b.CommitId
	return m0
}

type PayloadPolicyLabelMoved struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId      string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName    string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PolicyId     string                 `protobuf:"bytes,3,opt,name=policy_id,json=policyId,proto3"`
	xxx_hidden_PolicyName   string                 `protobuf:"bytes,4,opt,name=policy_name,json=policyName,proto3"`
	xxx_hidden_ToCommitId   string                 `protobuf:"bytes,6,opt,name=to_commit_id,json=toCommitId,proto3"`
	xxx_hidden_FromCommitId string                 `protobuf:"bytes,7,opt,name=from_commit_id,json=fromCommitId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *PayloadPolicyLabelMoved) Reset() {
	*x = PayloadPolicyLabelMoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyLabelMoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyLabelMoved) ProtoMessage() {}

func (x *PayloadPolicyLabelMoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyLabelMoved) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyLabelMoved) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyLabelMoved) GetPolicyId() string {
	if x != nil {
		return x.xxx_hidden_PolicyId
	}
	return ""
}

func (x *PayloadPolicyLabelMoved) GetPolicyName() string {
	if x != nil {
		return x.xxx_hidden_PolicyName
	}
	return ""
}

func (x *PayloadPolicyLabelMoved) GetToCommitId() string {
	if x != nil {
		return x.xxx_hidden_ToCommitId
	}
	return ""
}

func (x *PayloadPolicyLabelMoved) GetFromCommitId() string {
	if x != nil {
		return x.xxx_hidden_FromCommitId
	}
	return ""
}

func (x *PayloadPolicyLabelMoved) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyLabelMoved) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyLabelMoved) SetPolicyId(v string) {
	x.xxx_hidden_PolicyId = v
}

func (x *PayloadPolicyLabelMoved) SetPolicyName(v string) {
	x.xxx_hidden_PolicyName = v
}

func (x *PayloadPolicyLabelMoved) SetToCommitId(v string) {
	x.xxx_hidden_ToCommitId = v
}

func (x *PayloadPolicyLabelMoved) SetFromCommitId(v string) {
	x.xxx_hidden_FromCommitId = v
}

type PayloadPolicyLabelMoved_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy on which the label was moved.
	OwnerId string
	// owner_name is the name of the owner of the policy on which the label was moved.
	OwnerName string
	// policy_id is the id of the policy on which the label was moved.
	PolicyId string
	// policy_name is the name of the policy from which the label was moved.
	PolicyName string
	// to_commit_id is the id of the commit on which the label was moved to.
	ToCommitId string
	// from_commit_id is the id of the commit on which the label was moved from.
	FromCommitId string
}

func (b0 PayloadPolicyLabelMoved_builder) Build() *PayloadPolicyLabelMoved {
	m0 := &PayloadPolicyLabelMoved{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PolicyId = b.PolicyId
	x.xxx_hidden_PolicyName = b.PolicyName
	x.xxx_hidden_ToCommitId = b.ToCommitId
	x.xxx_hidden_FromCommitId = b.FromCommitId
	return m0
}

type PayloadPolicyLabelArchived struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PolicyId   string                 `protobuf:"bytes,3,opt,name=policy_id,json=policyId,proto3"`
	xxx_hidden_PolicyName string                 `protobuf:"bytes,4,opt,name=policy_name,json=policyName,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPolicyLabelArchived) Reset() {
	*x = PayloadPolicyLabelArchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyLabelArchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyLabelArchived) ProtoMessage() {}

func (x *PayloadPolicyLabelArchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyLabelArchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyLabelArchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyLabelArchived) GetPolicyId() string {
	if x != nil {
		return x.xxx_hidden_PolicyId
	}
	return ""
}

func (x *PayloadPolicyLabelArchived) GetPolicyName() string {
	if x != nil {
		return x.xxx_hidden_PolicyName
	}
	return ""
}

func (x *PayloadPolicyLabelArchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyLabelArchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyLabelArchived) SetPolicyId(v string) {
	x.xxx_hidden_PolicyId = v
}

func (x *PayloadPolicyLabelArchived) SetPolicyName(v string) {
	x.xxx_hidden_PolicyName = v
}

type PayloadPolicyLabelArchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy on which the label was archived.
	OwnerId string
	// owner_name is the name of the owner of the policy on which the label was archived.
	OwnerName string
	// policy_id is the id of the policy on which the label was archived.
	PolicyId string
	// policy_name is the name of the policy from which the label was archived.
	PolicyName string
}

func (b0 PayloadPolicyLabelArchived_builder) Build() *PayloadPolicyLabelArchived {
	m0 := &PayloadPolicyLabelArchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PolicyId = b.PolicyId
	x.xxx_hidden_PolicyName = b.PolicyName
	return m0
}

type PayloadPolicyLabelUnarchived struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerId    string                 `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_OwnerName  string                 `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_PolicyId   string                 `protobuf:"bytes,3,opt,name=policy_id,json=policyId,proto3"`
	xxx_hidden_PolicyName string                 `protobuf:"bytes,4,opt,name=policy_name,json=policyName,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PayloadPolicyLabelUnarchived) Reset() {
	*x = PayloadPolicyLabelUnarchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadPolicyLabelUnarchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadPolicyLabelUnarchived) ProtoMessage() {}

func (x *PayloadPolicyLabelUnarchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadPolicyLabelUnarchived) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *PayloadPolicyLabelUnarchived) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *PayloadPolicyLabelUnarchived) GetPolicyId() string {
	if x != nil {
		return x.xxx_hidden_PolicyId
	}
	return ""
}

func (x *PayloadPolicyLabelUnarchived) GetPolicyName() string {
	if x != nil {
		return x.xxx_hidden_PolicyName
	}
	return ""
}

func (x *PayloadPolicyLabelUnarchived) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *PayloadPolicyLabelUnarchived) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *PayloadPolicyLabelUnarchived) SetPolicyId(v string) {
	x.xxx_hidden_PolicyId = v
}

func (x *PayloadPolicyLabelUnarchived) SetPolicyName(v string) {
	x.xxx_hidden_PolicyName = v
}

type PayloadPolicyLabelUnarchived_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// owner_id is the id of the owner of the policy on which the label was unarchived.
	OwnerId string
	// owner_name is the name of the owner of the policy on which the label was unarchived.
	OwnerName string
	// policy_id is the id of the policy on which the label was unarchived.
	PolicyId string
	// policy_name is the name of the policy from which the label was unarchived.
	PolicyName string
}

func (b0 PayloadPolicyLabelUnarchived_builder) Build() *PayloadPolicyLabelUnarchived {
	m0 := &PayloadPolicyLabelUnarchived{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_PolicyId = b.PolicyId
	x.xxx_hidden_PolicyName = b.PolicyName
	return m0
}

type PayloadSDKPluginConstraintCreated struct {
	state                          protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwnerId   string                 `protobuf:"bytes,1,opt,name=repository_owner_id,json=repositoryOwnerId,proto3"`
	xxx_hidden_RepositoryOwnerName string                 `protobuf:"bytes,2,opt,name=repository_owner_name,json=repositoryOwnerName,proto3"`
	xxx_hidden_RepositoryId        string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName      string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_PluginOwnerId       string                 `protobuf:"bytes,5,opt,name=plugin_owner_id,json=pluginOwnerId,proto3"`
	xxx_hidden_PluginOwnerName     string                 `protobuf:"bytes,6,opt,name=plugin_owner_name,json=pluginOwnerName,proto3"`
	xxx_hidden_PluginId            string                 `protobuf:"bytes,7,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName          string                 `protobuf:"bytes,8,opt,name=plugin_name,json=pluginName,proto3"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *PayloadSDKPluginConstraintCreated) Reset() {
	*x = PayloadSDKPluginConstraintCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadSDKPluginConstraintCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadSDKPluginConstraintCreated) ProtoMessage() {}

func (x *PayloadSDKPluginConstraintCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadSDKPluginConstraintCreated) GetRepositoryOwnerId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwnerId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintCreated) GetRepositoryOwnerName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwnerName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintCreated) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintCreated) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintCreated) GetPluginOwnerId() string {
	if x != nil {
		return x.xxx_hidden_PluginOwnerId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintCreated) GetPluginOwnerName() string {
	if x != nil {
		return x.xxx_hidden_PluginOwnerName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintCreated) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintCreated) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintCreated) SetRepositoryOwnerId(v string) {
	x.xxx_hidden_RepositoryOwnerId = v
}

func (x *PayloadSDKPluginConstraintCreated) SetRepositoryOwnerName(v string) {
	x.xxx_hidden_RepositoryOwnerName = v
}

func (x *PayloadSDKPluginConstraintCreated) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadSDKPluginConstraintCreated) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadSDKPluginConstraintCreated) SetPluginOwnerId(v string) {
	x.xxx_hidden_PluginOwnerId = v
}

func (x *PayloadSDKPluginConstraintCreated) SetPluginOwnerName(v string) {
	x.xxx_hidden_PluginOwnerName = v
}

func (x *PayloadSDKPluginConstraintCreated) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadSDKPluginConstraintCreated) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

type PayloadSDKPluginConstraintCreated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// repository_owner_id is the id of the owner of the repository of the SDK constraint.
	RepositoryOwnerId string
	// repository_owner_name is the name of the owner of the repository of the SDK constraint.
	RepositoryOwnerName string
	// repository_id is the id of the repository of the SDK constraint.
	RepositoryId string
	// repository_name is the name of the repository of the SDK constraint.
	RepositoryName string
	// plugin_owner_id is the id of the owner of the plugin of the SDK constraint.
	PluginOwnerId string
	// plugin_owner_name is the name of the owner of the plugin of the SDK constraint.
	PluginOwnerName string
	// plugin_id is the id of the plugin of the SDK constraint.
	PluginId string
	// plugin_name is the name of the plugin of the SDK constraint.
	PluginName string
}

func (b0 PayloadSDKPluginConstraintCreated_builder) Build() *PayloadSDKPluginConstraintCreated {
	m0 := &PayloadSDKPluginConstraintCreated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwnerId = b.RepositoryOwnerId
	x.xxx_hidden_RepositoryOwnerName = b.RepositoryOwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_PluginOwnerId = b.PluginOwnerId
	x.xxx_hidden_PluginOwnerName = b.PluginOwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	return m0
}

type PayloadSDKPluginConstraintUpdated struct {
	state                          protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwnerId   string                 `protobuf:"bytes,1,opt,name=repository_owner_id,json=repositoryOwnerId,proto3"`
	xxx_hidden_RepositoryOwnerName string                 `protobuf:"bytes,2,opt,name=repository_owner_name,json=repositoryOwnerName,proto3"`
	xxx_hidden_RepositoryId        string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName      string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_PluginOwnerId       string                 `protobuf:"bytes,5,opt,name=plugin_owner_id,json=pluginOwnerId,proto3"`
	xxx_hidden_PluginOwnerName     string                 `protobuf:"bytes,6,opt,name=plugin_owner_name,json=pluginOwnerName,proto3"`
	xxx_hidden_PluginId            string                 `protobuf:"bytes,7,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName          string                 `protobuf:"bytes,8,opt,name=plugin_name,json=pluginName,proto3"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *PayloadSDKPluginConstraintUpdated) Reset() {
	*x = PayloadSDKPluginConstraintUpdated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadSDKPluginConstraintUpdated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadSDKPluginConstraintUpdated) ProtoMessage() {}

func (x *PayloadSDKPluginConstraintUpdated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadSDKPluginConstraintUpdated) GetRepositoryOwnerId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwnerId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintUpdated) GetRepositoryOwnerName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwnerName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintUpdated) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintUpdated) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintUpdated) GetPluginOwnerId() string {
	if x != nil {
		return x.xxx_hidden_PluginOwnerId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintUpdated) GetPluginOwnerName() string {
	if x != nil {
		return x.xxx_hidden_PluginOwnerName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintUpdated) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintUpdated) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintUpdated) SetRepositoryOwnerId(v string) {
	x.xxx_hidden_RepositoryOwnerId = v
}

func (x *PayloadSDKPluginConstraintUpdated) SetRepositoryOwnerName(v string) {
	x.xxx_hidden_RepositoryOwnerName = v
}

func (x *PayloadSDKPluginConstraintUpdated) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadSDKPluginConstraintUpdated) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadSDKPluginConstraintUpdated) SetPluginOwnerId(v string) {
	x.xxx_hidden_PluginOwnerId = v
}

func (x *PayloadSDKPluginConstraintUpdated) SetPluginOwnerName(v string) {
	x.xxx_hidden_PluginOwnerName = v
}

func (x *PayloadSDKPluginConstraintUpdated) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadSDKPluginConstraintUpdated) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

type PayloadSDKPluginConstraintUpdated_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// repository_owner_id is the id of the owner of the repository of the SDK constraint.
	RepositoryOwnerId string
	// repository_owner_name is the name of the owner of the repository of the SDK constraint.
	RepositoryOwnerName string
	// repository_id is the id of the repository of the SDK constraint.
	RepositoryId string
	// repository_name is the name of the repository of the SDK constraint.
	RepositoryName string
	// plugin_owner_id is the id of the owner of the plugin of the SDK constraint.
	PluginOwnerId string
	// plugin_owner_name is the name of the owner of the plugin of the SDK constraint.
	PluginOwnerName string
	// plugin_id is the id of the plugin of the SDK constraint.
	PluginId string
	// plugin_name is the name of the plugin of the SDK constraint.
	PluginName string
}

func (b0 PayloadSDKPluginConstraintUpdated_builder) Build() *PayloadSDKPluginConstraintUpdated {
	m0 := &PayloadSDKPluginConstraintUpdated{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwnerId = b.RepositoryOwnerId
	x.xxx_hidden_RepositoryOwnerName = b.RepositoryOwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_PluginOwnerId = b.PluginOwnerId
	x.xxx_hidden_PluginOwnerName = b.PluginOwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	return m0
}

type PayloadSDKPluginConstraintDeleted struct {
	state                          protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwnerId   string                 `protobuf:"bytes,1,opt,name=repository_owner_id,json=repositoryOwnerId,proto3"`
	xxx_hidden_RepositoryOwnerName string                 `protobuf:"bytes,2,opt,name=repository_owner_name,json=repositoryOwnerName,proto3"`
	xxx_hidden_RepositoryId        string                 `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryName      string                 `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_PluginOwnerId       string                 `protobuf:"bytes,5,opt,name=plugin_owner_id,json=pluginOwnerId,proto3"`
	xxx_hidden_PluginOwnerName     string                 `protobuf:"bytes,6,opt,name=plugin_owner_name,json=pluginOwnerName,proto3"`
	xxx_hidden_PluginId            string                 `protobuf:"bytes,7,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_PluginName          string                 `protobuf:"bytes,8,opt,name=plugin_name,json=pluginName,proto3"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *PayloadSDKPluginConstraintDeleted) Reset() {
	*x = PayloadSDKPluginConstraintDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadSDKPluginConstraintDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadSDKPluginConstraintDeleted) ProtoMessage() {}

func (x *PayloadSDKPluginConstraintDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadSDKPluginConstraintDeleted) GetRepositoryOwnerId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwnerId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintDeleted) GetRepositoryOwnerName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwnerName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintDeleted) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintDeleted) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintDeleted) GetPluginOwnerId() string {
	if x != nil {
		return x.xxx_hidden_PluginOwnerId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintDeleted) GetPluginOwnerName() string {
	if x != nil {
		return x.xxx_hidden_PluginOwnerName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintDeleted) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *PayloadSDKPluginConstraintDeleted) GetPluginName() string {
	if x != nil {
		return x.xxx_hidden_PluginName
	}
	return ""
}

func (x *PayloadSDKPluginConstraintDeleted) SetRepositoryOwnerId(v string) {
	x.xxx_hidden_RepositoryOwnerId = v
}

func (x *PayloadSDKPluginConstraintDeleted) SetRepositoryOwnerName(v string) {
	x.xxx_hidden_RepositoryOwnerName = v
}

func (x *PayloadSDKPluginConstraintDeleted) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *PayloadSDKPluginConstraintDeleted) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *PayloadSDKPluginConstraintDeleted) SetPluginOwnerId(v string) {
	x.xxx_hidden_PluginOwnerId = v
}

func (x *PayloadSDKPluginConstraintDeleted) SetPluginOwnerName(v string) {
	x.xxx_hidden_PluginOwnerName = v
}

func (x *PayloadSDKPluginConstraintDeleted) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *PayloadSDKPluginConstraintDeleted) SetPluginName(v string) {
	x.xxx_hidden_PluginName = v
}

type PayloadSDKPluginConstraintDeleted_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// repository_owner_id is the id of the owner of the repository of the SDK constraint.
	RepositoryOwnerId string
	// repository_owner_name is the name of the owner of the repository of the SDK constraint.
	RepositoryOwnerName string
	// repository_id is the id of the repository of the SDK constraint.
	RepositoryId string
	// repository_name is the name of the repository of the SDK constraint.
	RepositoryName string
	// plugin_owner_id is the id of the owner of the plugin of the SDK constraint.
	PluginOwnerId string
	// plugin_owner_name is the name of the owner of the plugin of the SDK constraint.
	PluginOwnerName string
	// plugin_id is the id of the plugin of the SDK constraint.
	PluginId string
	// plugin_name is the name of the plugin of the SDK constraint.
	PluginName string
}

func (b0 PayloadSDKPluginConstraintDeleted_builder) Build() *PayloadSDKPluginConstraintDeleted {
	m0 := &PayloadSDKPluginConstraintDeleted{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwnerId = b.RepositoryOwnerId
	x.xxx_hidden_RepositoryOwnerName = b.RepositoryOwnerName
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_PluginOwnerId = b.PluginOwnerId
	x.xxx_hidden_PluginOwnerName = b.PluginOwnerName
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_PluginName = b.PluginName
	return m0
}

type PayloadOrganizationMemberRolesChanged_OrganizationRole struct {
	state             protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_Role   v1alpha1.OrganizationRole       `protobuf:"varint,1,opt,name=role,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	xxx_hidden_Source v1alpha1.OrganizationRoleSource `protobuf:"varint,2,opt,name=source,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *PayloadOrganizationMemberRolesChanged_OrganizationRole) Reset() {
	*x = PayloadOrganizationMemberRolesChanged_OrganizationRole{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberRolesChanged_OrganizationRole) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberRolesChanged_OrganizationRole) ProtoMessage() {}

func (x *PayloadOrganizationMemberRolesChanged_OrganizationRole) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadOrganizationMemberRolesChanged_OrganizationRole) GetRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.xxx_hidden_Role
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRolesChanged_OrganizationRole) GetSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.xxx_hidden_Source
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberRolesChanged_OrganizationRole) SetRole(v v1alpha1.OrganizationRole) {
	x.xxx_hidden_Role = v
}

func (x *PayloadOrganizationMemberRolesChanged_OrganizationRole) SetSource(v v1alpha1.OrganizationRoleSource) {
	x.xxx_hidden_Source = v
}

type PayloadOrganizationMemberRolesChanged_OrganizationRole_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// role is the role of the member.
	Role v1alpha1.OrganizationRole
	// source is the source of the role granted to the member.
	Source v1alpha1.OrganizationRoleSource
}

func (b0 PayloadOrganizationMemberRolesChanged_OrganizationRole_builder) Build() *PayloadOrganizationMemberRolesChanged_OrganizationRole {
	m0 := &PayloadOrganizationMemberRolesChanged_OrganizationRole{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Role = b.Role
	x.xxx_hidden_Source = b.Source
	return m0
}

type PayloadRepositoryContributorRolesChanged_RepositoryRole struct {
	state             protoimpl.MessageState        `protogen:"opaque.v1"`
	xxx_hidden_Role   v1alpha1.RepositoryRole       `protobuf:"varint,1,opt,name=role,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	xxx_hidden_Source v1alpha1.RepositoryRoleSource `protobuf:"varint,2,opt,name=source,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRoleSource"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *PayloadRepositoryContributorRolesChanged_RepositoryRole) Reset() {
	*x = PayloadRepositoryContributorRolesChanged_RepositoryRole{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorRolesChanged_RepositoryRole) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorRolesChanged_RepositoryRole) ProtoMessage() {}

func (x *PayloadRepositoryContributorRolesChanged_RepositoryRole) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PayloadRepositoryContributorRolesChanged_RepositoryRole) GetRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.xxx_hidden_Role
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorRolesChanged_RepositoryRole) GetSource() v1alpha1.RepositoryRoleSource {
	if x != nil {
		return x.xxx_hidden_Source
	}
	return v1alpha1.RepositoryRoleSource(0)
}

func (x *PayloadRepositoryContributorRolesChanged_RepositoryRole) SetRole(v v1alpha1.RepositoryRole) {
	x.xxx_hidden_Role = v
}

func (x *PayloadRepositoryContributorRolesChanged_RepositoryRole) SetSource(v v1alpha1.RepositoryRoleSource) {
	x.xxx_hidden_Source = v
}

type PayloadRepositoryContributorRolesChanged_RepositoryRole_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// role is the role of the member.
	Role v1alpha1.RepositoryRole
	// source is the source of the role granted to the member.
	Source v1alpha1.RepositoryRoleSource
}

func (b0 PayloadRepositoryContributorRolesChanged_RepositoryRole_builder) Build() *PayloadRepositoryContributorRolesChanged_RepositoryRole {
	m0 := &PayloadRepositoryContributorRolesChanged_RepositoryRole{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Role = b.Role
	x.xxx_hidden_Source = b.Source
	return m0
}

var File_buf_alpha_audit_v1alpha1_event_proto protoreflect.FileDescriptor

const file_buf_alpha_audit_v1alpha1_event_proto_rawDesc = "" +
	"\n" +
	"$buf/alpha/audit/v1alpha1/event.proto\x12\x18buf.alpha.audit.v1alpha1\x1a'buf/alpha/registry/v1alpha1/admin.proto\x1a,buf/alpha/registry/v1alpha1/repository.proto\x1a&buf/alpha/registry/v1alpha1/role.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"d\n" +
	"\x05Actor\x127\n" +
	"\x04type\x18\x01 \x01(\x0e2#.buf.alpha.audit.v1alpha1.ActorTypeR\x04type\x12\x0e\n" +
	"\x02id\x18\x02 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\"j\n" +
	"\bResource\x12:\n" +
	"\x04type\x18\x01 \x01(\x0e2&.buf.alpha.audit.v1alpha1.ResourceTypeR\x04type\x12\x0e\n" +
	"\x02id\x18\x02 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\"Y\n" +
	"\rEventMetadata\x12\x1d\n" +
	"\n" +
	"user_agent\x18\x01 \x01(\tR\tuserAgent\x12\x0e\n" +
	"\x02ip\x18\x02 \x01(\tR\x02ip\x12\x19\n" +
	"\btrace_id\x18\x03 \x01(\tR\atraceId\"\xf6D\n" +
	"\x05Event\x12\x19\n" +
	"\bevent_id\x18\x01 \x01(\tR\aeventId\x127\n" +
	"\x04type\x18\x02 \x01(\x0e2#.buf.alpha.audit.v1alpha1.EventTypeR\x04type\x125\n" +
	"\x05actor\x18\x03 \x01(\v2\x1f.buf.alpha.audit.v1alpha1.ActorR\x05actor\x12>\n" +
	"\bresource\x18\x04 \x01(\v2\".buf.alpha.audit.v1alpha1.ResourceR\bresource\x129\n" +
	"\n" +
	"event_time\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\teventTime\x12C\n" +
	"\bmetadata\x18\x06 \x01(\v2'.buf.alpha.audit.v1alpha1.EventMetadataR\bmetadata\x12i\n" +
	"\x14organization_created\x18\a \x01(\v24.buf.alpha.audit.v1alpha1.PayloadOrganizationCreatedH\x00R\x13organizationCreated\x12i\n" +
	"\x14organization_deleted\x18\b \x01(\v24.buf.alpha.audit.v1alpha1.PayloadOrganizationDeletedH\x00R\x13organizationDeleted\x12v\n" +
	"\x19organization_member_added\x18\t \x01(\v28.buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAddedH\x00R\x17organizationMemberAdded\x12\x89\x01\n" +
	" organization_member_role_changed\x18\n" +
	" \x01(\v2>.buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChangedH\x00R\x1dorganizationMemberRoleChanged\x12\x8c\x01\n" +
	"!organization_member_roles_changed\x188 \x01(\v2?.buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChangedH\x00R\x1eorganizationMemberRolesChanged\x12|\n" +
	"\x1borganization_member_removed\x18\v \x01(\v2:.buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemovedH\x00R\x19organizationMemberRemoved\x12c\n" +
	"\x12repository_created\x18\f \x01(\v22.buf.alpha.audit.v1alpha1.PayloadRepositoryCreatedH\x00R\x11repositoryCreated\x12l\n" +
	"\x15repository_deprecated\x186 \x01(\v25.buf.alpha.audit.v1alpha1.PayloadRepositoryDeprecatedH\x00R\x14repositoryDeprecated\x12r\n" +
	"\x17repository_undeprecated\x187 \x01(\v27.buf.alpha.audit.v1alpha1.PayloadRepositoryUndeprecatedH\x00R\x16repositoryUndeprecated\x12c\n" +
	"\x12repository_deleted\x18\r \x01(\v22.buf.alpha.audit.v1alpha1.PayloadRepositoryDeletedH\x00R\x11repositoryDeleted\x12s\n" +
	"\x18repository_commit_pushed\x18\x0e \x01(\v27.buf.alpha.audit.v1alpha1.PayloadRepositoryCommitPushedH\x00R\x16repositoryCommitPushed\x12\x7f\n" +
	"\x1crepository_contributor_added\x18\x0f \x01(\v2;.buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAddedH\x00R\x1arepositoryContributorAdded\x12\x92\x01\n" +
	"#repository_contributor_role_changed\x18\x10 \x01(\v2A.buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChangedH\x00R repositoryContributorRoleChanged\x12\x95\x01\n" +
	"$repository_contributor_roles_changed\x18E \x01(\v2B.buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChangedH\x00R!repositoryContributorRolesChanged\x12\x85\x01\n" +
	"\x1erepository_contributor_removed\x18\x11 \x01(\v2=.buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemovedH\x00R\x1crepositoryContributorRemoved\x12\x82\x01\n" +
	"\x1drepository_visibility_changed\x18\x12 \x01(\v2<.buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChangedH\x00R\x1brepositoryVisibilityChanged\x12\x96\x01\n" +
	"%repository_default_label_name_changed\x18. \x01(\v2B.buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultLabelNameChangedH\x00R!repositoryDefaultLabelNameChanged\x12w\n" +
	"\x1arepository_idp_group_added\x18B \x01(\v28.buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupAddedH\x00R\x17repositoryIdpGroupAdded\x12}\n" +
	"\x1crepository_idp_group_updated\x18C \x01(\v2:.buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupUpdatedH\x00R\x19repositoryIdpGroupUpdated\x12}\n" +
	"\x1crepository_idp_group_removed\x18D \x01(\v2:.buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupRemovedH\x00R\x19repositoryIdpGroupRemoved\x12W\n" +
	"\x0epolicy_created\x18< \x01(\v2..buf.alpha.audit.v1alpha1.PayloadPolicyCreatedH\x00R\rpolicyCreated\x12W\n" +
	"\x0epolicy_deleted\x18= \x01(\v2..buf.alpha.audit.v1alpha1.PayloadPolicyDeletedH\x00R\rpolicyDeleted\x12`\n" +
	"\x11policy_deprecated\x18> \x01(\v21.buf.alpha.audit.v1alpha1.PayloadPolicyDeprecatedH\x00R\x10policyDeprecated\x12f\n" +
	"\x13policy_undeprecated\x18? \x01(\v23.buf.alpha.audit.v1alpha1.PayloadPolicyUndeprecatedH\x00R\x12policyUndeprecated\x12v\n" +
	"\x19policy_visibility_changed\x18@ \x01(\v28.buf.alpha.audit.v1alpha1.PayloadPolicyVisibilityChangedH\x00R\x17policyVisibilityChanged\x12g\n" +
	"\x14policy_commit_pushed\x18F \x01(\v23.buf.alpha.audit.v1alpha1.PayloadPolicyCommitPushedH\x00R\x12policyCommitPushed\x12g\n" +
	"\x14policy_label_created\x18G \x01(\v23.buf.alpha.audit.v1alpha1.PayloadPolicyLabelCreatedH\x00R\x12policyLabelCreated\x12a\n" +
	"\x12policy_label_moved\x18H \x01(\v21.buf.alpha.audit.v1alpha1.PayloadPolicyLabelMovedH\x00R\x10policyLabelMoved\x12j\n" +
	"\x15policy_label_archived\x18I \x01(\v24.buf.alpha.audit.v1alpha1.PayloadPolicyLabelArchivedH\x00R\x13policyLabelArchived\x12p\n" +
	"\x17policy_label_unarchived\x18J \x01(\v26.buf.alpha.audit.v1alpha1.PayloadPolicyLabelUnarchivedH\x00R\x15policyLabelUnarchived\x12W\n" +
	"\x0eplugin_created\x18\x13 \x01(\v2..buf.alpha.audit.v1alpha1.PayloadPluginCreatedH\x00R\rpluginCreated\x12W\n" +
	"\x0eplugin_deleted\x18\x14 \x01(\v2..buf.alpha.audit.v1alpha1.PayloadPluginDeletedH\x00R\rpluginDeleted\x12`\n" +
	"\x11plugin_deprecated\x189 \x01(\v21.buf.alpha.audit.v1alpha1.PayloadPluginDeprecatedH\x00R\x10pluginDeprecated\x12f\n" +
	"\x13plugin_undeprecated\x18: \x01(\v23.buf.alpha.audit.v1alpha1.PayloadPluginUndeprecatedH\x00R\x12pluginUndeprecated\x12v\n" +
	"\x19plugin_visibility_changed\x18; \x01(\v28.buf.alpha.audit.v1alpha1.PayloadPluginVisibilityChangedH\x00R\x17pluginVisibilityChanged\x12g\n" +
	"\x14plugin_commit_pushed\x181 \x01(\v23.buf.alpha.audit.v1alpha1.PayloadPluginCommitPushedH\x00R\x12pluginCommitPushed\x12Q\n" +
	"\fuser_created\x18\x15 \x01(\v2,.buf.alpha.audit.v1alpha1.PayloadUserCreatedH\x00R\vuserCreated\x12]\n" +
	"\x10user_deactivated\x18\x16 \x01(\v20.buf.alpha.audit.v1alpha1.PayloadUserDeactivatedH\x00R\x0fuserDeactivated\x12Q\n" +
	"\fuser_deleted\x18\x17 \x01(\v2,.buf.alpha.audit.v1alpha1.PayloadUserDeletedH\x00R\vuserDeleted\x12U\n" +
	"\x0euser_logged_in\x18\x18 \x01(\v2-.buf.alpha.audit.v1alpha1.PayloadUserLoggedInH\x00R\fuserLoggedIn\x12X\n" +
	"\x0fuser_logged_out\x18\x19 \x01(\v2..buf.alpha.audit.v1alpha1.PayloadUserLoggedOutH\x00R\ruserLoggedOut\x12m\n" +
	"\x16curated_plugin_created\x18\x1a \x01(\v25.buf.alpha.audit.v1alpha1.PayloadCuratedPluginCreatedH\x00R\x14curatedPluginCreated\x12d\n" +
	"\x0fidp_group_added\x18\x1b \x01(\v2:.buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupAddedH\x00R\ridpGroupAdded\x12j\n" +
	"\x11idp_group_updated\x18A \x01(\v2<.buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupUpdatedH\x00R\x0fidpGroupUpdated\x12j\n" +
	"\x11idp_group_removed\x18\x1c \x01(\v2<.buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupRemovedH\x00R\x0fidpGroupRemoved\x12T\n" +
	"\rtoken_created\x18\x1d \x01(\v2-.buf.alpha.audit.v1alpha1.PayloadTokenCreatedH\x00R\ftokenCreated\x12T\n" +
	"\rtoken_deleted\x18\x1e \x01(\v2-.buf.alpha.audit.v1alpha1.PayloadTokenDeletedH\x00R\ftokenDeleted\x12]\n" +
	"\x10user_reactivated\x18\x1f \x01(\v20.buf.alpha.audit.v1alpha1.PayloadUserReactivatedH\x00R\x0fuserReactivated\x12a\n" +
	"\x12scim_token_created\x18  \x01(\v21.buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreatedH\x00R\x10scimTokenCreated\x12a\n" +
	"\x12scim_token_deleted\x18! \x01(\v21.buf.alpha.audit.v1alpha1.PayloadSCIMTokenDeletedH\x00R\x10scimTokenDeleted\x12z\n" +
	"\x19repository_commit_deleted\x18\" \x01(\v28.buf.alpha.audit.v1alpha1.PayloadRepositoryCommitDeletedB\x02\x18\x01H\x00R\x17repositoryCommitDeleted\x12s\n" +
	"\x18repository_label_created\x18# \x01(\v27.buf.alpha.audit.v1alpha1.PayloadRepositoryLabelCreatedH\x00R\x16repositoryLabelCreated\x12m\n" +
	"\x16repository_label_moved\x18$ \x01(\v25.buf.alpha.audit.v1alpha1.PayloadRepositoryLabelMovedH\x00R\x14repositoryLabelMoved\x12v\n" +
	"\x19repository_label_archived\x18, \x01(\v28.buf.alpha.audit.v1alpha1.PayloadRepositoryLabelArchivedH\x00R\x17repositoryLabelArchived\x12|\n" +
	"\x1brepository_label_unarchived\x18- \x01(\v2:.buf.alpha.audit.v1alpha1.PayloadRepositoryLabelUnarchivedH\x00R\x19repositoryLabelUnarchived\x12m\n" +
	"\x16curated_plugin_deleted\x18% \x01(\v25.buf.alpha.audit.v1alpha1.PayloadCuratedPluginDeletedH\x00R\x14curatedPluginDeleted\x12\xa5\x01\n" +
	"-payload_server_breaking_change_policy_enabled\x18& \x01(\v2B.buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabledH\x00R(payloadServerBreakingChangePolicyEnabled\x12\xa8\x01\n" +
	".payload_server_breaking_change_policy_disabled\x18' \x01(\v2C.buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyDisabledH\x00R)payloadServerBreakingChangePolicyDisabled\x12\x90\x01\n" +
	"!repository_default_branch_changed\x18( \x01(\v2?.buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultBranchChangedB\x02\x18\x01H\x00R\x1erepositoryDefaultBranchChanged\x12\x98\x01\n" +
	"(payload_server_uniqueness_policy_enabled\x18) \x01(\v2>.buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyEnabledH\x00R$payloadServerUniquenessPolicyEnabled\x12\x9b\x01\n" +
	")payload_server_uniqueness_policy_disabled\x18* \x01(\v2?.buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyDisabledH\x00R%payloadServerUniquenessPolicyDisabled\x12|\n" +
	"\x1duser_auto_merged_from_new_idp\x18+ \x01(\v29.buf.alpha.audit.v1alpha1.PayloadUserAutoMergedFromNewIdPH\x00R\x18userAutoMergedFromNewIdp\x12\x92\x01\n" +
	"#device_authorization_grant_approved\x18/ \x01(\v2A.buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantApprovedH\x00R deviceAuthorizationGrantApproved\x12\x8c\x01\n" +
	"!device_authorization_grant_denied\x180 \x01(\v2?.buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantDeniedH\x00R\x1edeviceAuthorizationGrantDenied\x12g\n" +
	"\x14plugin_label_created\x182 \x01(\v23.buf.alpha.audit.v1alpha1.PayloadPluginLabelCreatedH\x00R\x12pluginLabelCreated\x12a\n" +
	"\x12plugin_label_moved\x183 \x01(\v21.buf.alpha.audit.v1alpha1.PayloadPluginLabelMovedH\x00R\x10pluginLabelMoved\x12j\n" +
	"\x15plugin_label_archived\x184 \x01(\v24.buf.alpha.audit.v1alpha1.PayloadPluginLabelArchivedH\x00R\x13pluginLabelArchived\x12p\n" +
	"\x17plugin_label_unarchived\x185 \x01(\v26.buf.alpha.audit.v1alpha1.PayloadPluginLabelUnarchivedH\x00R\x15pluginLabelUnarchived\x12w\n" +
	"\x1aserver_review_flow_enabled\x18K \x01(\v28.buf.alpha.audit.v1alpha1.PayloadServerReviewFlowEnabledH\x00R\x17serverReviewFlowEnabled\x12z\n" +
	"\x1bserver_review_flow_disabled\x18L \x01(\v29.buf.alpha.audit.v1alpha1.PayloadServerReviewFlowDisabledH\x00R\x18serverReviewFlowDisabled\x12\x80\x01\n" +
	"\x1dsdk_plugin_constraint_created\x18M \x01(\v2;.buf.alpha.audit.v1alpha1.PayloadSDKPluginConstraintCreatedH\x00R\x1asdkPluginConstraintCreated\x12\x80\x01\n" +
	"\x1dsdk_plugin_constraint_updated\x18N \x01(\v2;.buf.alpha.audit.v1alpha1.PayloadSDKPluginConstraintUpdatedH\x00R\x1asdkPluginConstraintUpdated\x12\x80\x01\n" +
	"\x1dsdk_plugin_constraint_deleted\x18O \x01(\v2;.buf.alpha.audit.v1alpha1.PayloadSDKPluginConstraintDeletedH\x00R\x1asdkPluginConstraintDeletedB\t\n" +
	"\apayload\"\x1c\n" +
	"\x1aPayloadOrganizationCreated\"\x1c\n" +
	"\x1aPayloadOrganizationDeleted\"\xa9\x02\n" +
	"\x1ePayloadOrganizationMemberAdded\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12+\n" +
	"\x11organization_name\x18\x02 \x01(\tR\x10organizationName\x12N\n" +
	"\vmember_role\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\n" +
	"memberRole\x12a\n" +
	"\x12member_role_source\x18\x04 \x01(\x0e23.buf.alpha.registry.v1alpha1.OrganizationRoleSourceR\x10memberRoleSource\"\xe8\x03\n" +
	"$PayloadOrganizationMemberRoleChanged\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12+\n" +
	"\x11organization_name\x18\x02 \x01(\tR\x10organizationName\x12H\n" +
	"\bold_role\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\aoldRole\x12H\n" +
	"\bnew_role\x18\x04 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\anewRole\x12h\n" +
	"\x16old_member_role_source\x18\x05 \x01(\x0e23.buf.alpha.registry.v1alpha1.OrganizationRoleSourceR\x13oldMemberRoleSource\x12h\n" +
	"\x16new_member_role_source\x18\x06 \x01(\x0e23.buf.alpha.registry.v1alpha1.OrganizationRoleSourceR\x13newMemberRoleSource:\x02\x18\x01\"\x80\x04\n" +
	"%PayloadOrganizationMemberRolesChanged\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12+\n" +
	"\x11organization_name\x18\x02 \x01(\tR\x10organizationName\x12m\n" +
	"\told_roles\x18\x03 \x03(\v2P.buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged.OrganizationRoleR\boldRoles\x12m\n" +
	"\tnew_roles\x18\x04 \x03(\v2P.buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged.OrganizationRoleR\bnewRoles\x1a\xa2\x01\n" +
	"\x10OrganizationRole\x12A\n" +
	"\x04role\x18\x01 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x04role\x12K\n" +
	"\x06source\x18\x02 \x01(\x0e23.buf.alpha.registry.v1alpha1.OrganizationRoleSourceR\x06source\"\xab\x02\n" +
	" PayloadOrganizationMemberRemoved\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12+\n" +
	"\x11organization_name\x18\x02 \x01(\tR\x10organizationName\x12N\n" +
	"\vmember_role\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\n" +
	"memberRole\x12a\n" +
	"\x12member_role_source\x18\x04 \x01(\x0e23.buf.alpha.registry.v1alpha1.OrganizationRoleSourceR\x10memberRoleSource\"\xcc\x01\n" +
	" PayloadOrganizationIDPGroupAdded\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12+\n" +
	"\x11organization_name\x18\x02 \x01(\tR\x10organizationName\x12R\n" +
	"\rrole_override\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\froleOverride\"\xb0\x02\n" +
	"\"PayloadOrganizationIDPGroupUpdated\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12+\n" +
	"\x11organization_name\x18\x02 \x01(\tR\x10organizationName\x12Y\n" +
	"\x11old_role_override\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x0foldRoleOverride\x12Y\n" +
	"\x11new_role_override\x18\x04 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x0fnewRoleOverride\"\xce\x01\n" +
	"\"PayloadOrganizationIDPGroupRemoved\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12+\n" +
	"\x11organization_name\x18\x02 \x01(\tR\x10organizationName\x12R\n" +
	"\rrole_override\x18\x03 \x01(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\froleOverride\"\xcb\x01\n" +
	"\x18PayloadRepositoryCreated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12G\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\x12,\n" +
	"\x12default_label_name\x18\x04 \x01(\tR\x10defaultLabelName\"\x9d\x01\n" +
	"\x18PayloadRepositoryDeleted\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12G\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\xd1\x01\n" +
	"\x1bPayloadRepositoryDeprecated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12G\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\x12/\n" +
	"\x13deprecation_message\x18\x04 \x01(\tR\x12deprecationMessage\"\xa2\x01\n" +
	"\x1dPayloadRepositoryUndeprecated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12G\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\xa0\x02\n" +
	"\x1dPayloadRepositoryCommitPushed\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12\x12\n" +
	"\x04tags\x18\x05 \x03(\tR\x04tags\x12\x1d\n" +
	"\n" +
	"draft_name\x18\x06 \x01(\tR\tdraftName\x12'\n" +
	"\x0fmanifest_digest\x18\a \x01(\tR\x0emanifestDigest\x12\x1b\n" +
	"\tb5_digest\x18\b \x01(\tR\bb5Digest\"\x83\x02\n" +
	"!PayloadRepositoryContributorAdded\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12V\n" +
	"\x10contributor_role\x18\x05 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x0fcontributorRole\"\xc5\x02\n" +
	"'PayloadRepositoryContributorRoleChanged\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12F\n" +
	"\bold_role\x18\x05 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\aoldRole\x12F\n" +
	"\bnew_role\x18\x06 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\anewRole:\x02\x18\x01\"\xb1\x04\n" +
	"(PayloadRepositoryContributorRolesChanged\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12n\n" +
	"\told_roles\x18\x05 \x03(\v2Q.buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged.RepositoryRoleR\boldRoles\x12n\n" +
	"\tnew_roles\x18\x06 \x03(\v2Q.buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged.RepositoryRoleR\bnewRoles\x1a\x9c\x01\n" +
	"\x0eRepositoryRole\x12?\n" +
	"\x04role\x18\x01 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x04role\x12I\n" +
	"\x06source\x18\x02 \x01(\x0e21.buf.alpha.registry.v1alpha1.RepositoryRoleSourceR\x06source\"\x85\x02\n" +
	"#PayloadRepositoryContributorRemoved\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12V\n" +
	"\x10contributor_role\x18\x05 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x0fcontributorRole\"\xfe\x01\n" +
	"\"PayloadRepositoryVisibilityChanged\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12N\n" +
	"\x0eold_visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\roldVisibility\x12N\n" +
	"\x0enew_visibility\x18\x04 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\rnewVisibility\"\xce\x01\n" +
	"(PayloadRepositoryDefaultLabelNameChanged\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x123\n" +
	"\x16old_default_label_name\x18\x03 \x01(\tR\x13oldDefaultLabelName\x123\n" +
	"\x16new_default_label_name\x18\x04 \x01(\tR\x13newDefaultLabelName\"\xc1\x01\n" +
	"%PayloadRepositoryDefaultBranchChanged\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12,\n" +
	"\x12old_default_branch\x18\x03 \x01(\tR\x10oldDefaultBranch\x12,\n" +
	"\x12new_default_branch\x18\x04 \x01(\tR\x10newDefaultBranch:\x02\x18\x01\"\xc0\x01\n" +
	"\x1ePayloadRepositoryIDPGroupAdded\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12P\n" +
	"\rrole_override\x18\x03 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\froleOverride\"\xa2\x02\n" +
	" PayloadRepositoryIDPGroupUpdated\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12W\n" +
	"\x11old_role_override\x18\x03 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x0foldRoleOverride\x12W\n" +
	"\x11new_role_override\x18\x04 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x0fnewRoleOverride\"\xc2\x01\n" +
	" PayloadRepositoryIDPGroupRemoved\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12P\n" +
	"\rrole_override\x18\x03 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\froleOverride\"\x99\x01\n" +
	"\x14PayloadPolicyCreated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12G\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\x99\x01\n" +
	"\x14PayloadPolicyDeleted\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12G\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\x9c\x01\n" +
	"\x17PayloadPolicyDeprecated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12G\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\x9e\x01\n" +
	"\x19PayloadPolicyUndeprecated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12G\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\xfa\x01\n" +
	"\x1ePayloadPolicyVisibilityChanged\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12N\n" +
	"\x0eold_visibility\x18\x04 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\roldVisibility\x12N\n" +
	"\x0enew_visibility\x18\x05 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\rnewVisibility\"\xb0\x01\n" +
	"\x19PayloadPolicyCommitPushed\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tpolicy_id\x18\x03 \x01(\tR\bpolicyId\x12\x1f\n" +
	"\vpolicy_name\x18\x04 \x01(\tR\n" +
	"policyName\x12\x1b\n" +
	"\tp1_digest\x18\x05 \x01(\tR\bp1Digest\"\xba\x01\n" +
	"\x14PayloadPluginCreated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1f\n" +
	"\vplugin_type\x18\x03 \x01(\tR\n" +
	"pluginType\x12G\n" +
	"\n" +
	"visibility\x18\x04 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\xba\x01\n" +
	"\x14PayloadPluginDeleted\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1f\n" +
	"\vplugin_type\x18\x03 \x01(\tR\n" +
	"pluginType\x12G\n" +
	"\n" +
	"visibility\x18\x04 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\xbd\x01\n" +
	"\x17PayloadPluginDeprecated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1f\n" +
	"\vplugin_type\x18\x03 \x01(\tR\n" +
	"pluginType\x12G\n" +
	"\n" +
	"visibility\x18\x04 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\xbf\x01\n" +
	"\x19PayloadPluginUndeprecated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1f\n" +
	"\vplugin_type\x18\x03 \x01(\tR\n" +
	"pluginType\x12G\n" +
	"\n" +
	"visibility\x18\x04 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"\x9b\x02\n" +
	"\x1ePayloadPluginVisibilityChanged\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1f\n" +
	"\vplugin_type\x18\x03 \x01(\tR\n" +
	"pluginType\x12N\n" +
	"\x0eold_visibility\x18\x04 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\roldVisibility\x12N\n" +
	"\x0enew_visibility\x18\x05 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\rnewVisibility\"\xb0\x01\n" +
	"\x19PayloadPluginCommitPushed\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tplugin_id\x18\x03 \x01(\tR\bpluginId\x12\x1f\n" +
	"\vplugin_name\x18\x04 \x01(\tR\n" +
	"pluginName\x12\x1b\n" +
	"\tp1_digest\x18\x05 \x01(\tR\bp1Digest\"\x14\n" +
	"\x12PayloadUserCreated\"\x18\n" +
	"\x16PayloadUserReactivated\"\x18\n" +
	"\x16PayloadUserDeactivated\"\x14\n" +
	"\x12PayloadUserDeleted\"\x15\n" +
	"\x13PayloadUserLoggedIn\"\x16\n" +
	"\x14PayloadUserLoggedOut\"!\n" +
	"\x1fPayloadUserAutoMergedFromNewIdP\"W\n" +
	"\x1bPayloadCuratedPluginCreated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\"W\n" +
	"\x1bPayloadCuratedPluginDeleted\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\"x\n" +
	"\x13PayloadTokenCreated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12F\n" +
	"\x11token_expiry_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\x0ftokenExpiryTime\"0\n" +
	"\x13PayloadTokenDeleted\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\"a\n" +
	"\x17PayloadSCIMTokenCreated\x12F\n" +
	"\x11token_expiry_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x0ftokenExpiryTime\"\x19\n" +
	"\x17PayloadSCIMTokenDeleted\"\xcb\x01\n" +
	"\x1ePayloadRepositoryCommitDeleted\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12\x1d\n" +
	"\n" +
	"draft_name\x18\x05 \x01(\tR\tdraftName:\x02\x18\x01\"\xf1\x01\n" +
	"\x1dPayloadRepositoryLabelCreated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12+\n" +
	"\x0flabel_namespace\x18\x05 \x01(\tB\x02\x18\x01R\x0elabelNamespace\x12\x1b\n" +
	"\tcommit_id\x18\x06 \x01(\tR\bcommitId\"\x9a\x02\n" +
	"\x1bPayloadRepositoryLabelMoved\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12+\n" +
	"\x0flabel_namespace\x18\x05 \x01(\tB\x02\x18\x01R\x0elabelNamespace\x12 \n" +
	"\fto_commit_id\x18\x06 \x01(\tR\n" +
	"toCommitId\x12$\n" +
	"\x0efrom_commit_id\x18\a \x01(\tR\ffromCommitId\"\xa8\x01\n" +
	"\x1ePayloadRepositoryLabelArchived\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\"\xaa\x01\n" +
	" PayloadRepositoryLabelUnarchived\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\"\xd7\x01\n" +
	"(PayloadServerBreakingChangePolicyEnabled\x12O\n" +
	"\bcategory\x18\x01 \x01(\x0e23.buf.alpha.registry.v1alpha1.BreakingChangeCategoryR\bcategory\x12=\n" +
	"\x18ignore_unstable_packages\x18\x02 \x01(\bH\x00R\x16ignoreUnstablePackages\x88\x01\x01B\x1b\n" +
	"\x19_ignore_unstable_packages\"+\n" +
	")PayloadServerBreakingChangePolicyDisabled\" \n" +
	"\x1ePayloadServerReviewFlowEnabled\"!\n" +
	"\x1fPayloadServerReviewFlowDisabled\"&\n" +
	"$PayloadServerUniquenessPolicyEnabled\"'\n" +
	"%PayloadServerUniquenessPolicyDisabled\"F\n" +
	"'PayloadDeviceAuthorizationGrantApproved\x12\x1b\n" +
	"\tclient_id\x18\x01 \x01(\tR\bclientId\"D\n" +
	"%PayloadDeviceAuthorizationGrantDenied\x12\x1b\n" +
	"\tclient_id\x18\x01 \x01(\tR\bclientId\"\xb0\x01\n" +
	"\x19PayloadPluginLabelCreated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tplugin_id\x18\x03 \x01(\tR\bpluginId\x12\x1f\n" +
	"\vplugin_name\x18\x04 \x01(\tR\n" +
	"pluginName\x12\x1b\n" +
	"\tcommit_id\x18\x06 \x01(\tR\bcommitId\"\xd9\x01\n" +
	"\x17PayloadPluginLabelMoved\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tplugin_id\x18\x03 \x01(\tR\bpluginId\x12\x1f\n" +
	"\vplugin_name\x18\x04 \x01(\tR\n" +
	"pluginName\x12 \n" +
	"\fto_commit_id\x18\x06 \x01(\tR\n" +
	"toCommitId\x12$\n" +
	"\x0efrom_commit_id\x18\a \x01(\tR\ffromCommitId\"\x94\x01\n" +
	"\x1aPayloadPluginLabelArchived\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tplugin_id\x18\x03 \x01(\tR\bpluginId\x12\x1f\n" +
	"\vplugin_name\x18\x04 \x01(\tR\n" +
	"pluginName\"\x96\x01\n" +
	"\x1cPayloadPluginLabelUnarchived\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tplugin_id\x18\x03 \x01(\tR\bpluginId\x12\x1f\n" +
	"\vplugin_name\x18\x04 \x01(\tR\n" +
	"pluginName\"\xb0\x01\n" +
	"\x19PayloadPolicyLabelCreated\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tpolicy_id\x18\x03 \x01(\tR\bpolicyId\x12\x1f\n" +
	"\vpolicy_name\x18\x04 \x01(\tR\n" +
	"policyName\x12\x1b\n" +
	"\tcommit_id\x18\x06 \x01(\tR\bcommitId\"\xd9\x01\n" +
	"\x17PayloadPolicyLabelMoved\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tpolicy_id\x18\x03 \x01(\tR\bpolicyId\x12\x1f\n" +
	"\vpolicy_name\x18\x04 \x01(\tR\n" +
	"policyName\x12 \n" +
	"\fto_commit_id\x18\x06 \x01(\tR\n" +
	"toCommitId\x12$\n" +
	"\x0efrom_commit_id\x18\a \x01(\tR\ffromCommitId\"\x94\x01\n" +
	"\x1aPayloadPolicyLabelArchived\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tpolicy_id\x18\x03 \x01(\tR\bpolicyId\x12\x1f\n" +
	"\vpolicy_name\x18\x04 \x01(\tR\n" +
	"policyName\"\x96\x01\n" +
	"\x1cPayloadPolicyLabelUnarchived\x12\x19\n" +
	"\bowner_id\x18\x01 \x01(\tR\aownerId\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x02 \x01(\tR\townerName\x12\x1b\n" +
	"\tpolicy_id\x18\x03 \x01(\tR\bpolicyId\x12\x1f\n" +
	"\vpolicy_name\x18\x04 \x01(\tR\n" +
	"policyName\"\xe7\x02\n" +
	"!PayloadSDKPluginConstraintCreated\x12.\n" +
	"\x13repository_owner_id\x18\x01 \x01(\tR\x11repositoryOwnerId\x122\n" +
	"\x15repository_owner_name\x18\x02 \x01(\tR\x13repositoryOwnerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12&\n" +
	"\x0fplugin_owner_id\x18\x05 \x01(\tR\rpluginOwnerId\x12*\n" +
	"\x11plugin_owner_name\x18\x06 \x01(\tR\x0fpluginOwnerName\x12\x1b\n" +
	"\tplugin_id\x18\a \x01(\tR\bpluginId\x12\x1f\n" +
	"\vplugin_name\x18\b \x01(\tR\n" +
	"pluginName\"\xe7\x02\n" +
	"!PayloadSDKPluginConstraintUpdated\x12.\n" +
	"\x13repository_owner_id\x18\x01 \x01(\tR\x11repositoryOwnerId\x122\n" +
	"\x15repository_owner_name\x18\x02 \x01(\tR\x13repositoryOwnerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12&\n" +
	"\x0fplugin_owner_id\x18\x05 \x01(\tR\rpluginOwnerId\x12*\n" +
	"\x11plugin_owner_name\x18\x06 \x01(\tR\x0fpluginOwnerName\x12\x1b\n" +
	"\tplugin_id\x18\a \x01(\tR\bpluginId\x12\x1f\n" +
	"\vplugin_name\x18\b \x01(\tR\n" +
	"pluginName\"\xe7\x02\n" +
	"!PayloadSDKPluginConstraintDeleted\x12.\n" +
	"\x13repository_owner_id\x18\x01 \x01(\tR\x11repositoryOwnerId\x122\n" +
	"\x15repository_owner_name\x18\x02 \x01(\tR\x13repositoryOwnerName\x12#\n" +
	"\rrepository_id\x18\x03 \x01(\tR\frepositoryId\x12'\n" +
	"\x0frepository_name\x18\x04 \x01(\tR\x0erepositoryName\x12&\n" +
	"\x0fplugin_owner_id\x18\x05 \x01(\tR\rpluginOwnerId\x12*\n" +
	"\x11plugin_owner_name\x18\x06 \x01(\tR\x0fpluginOwnerName\x12\x1b\n" +
	"\tplugin_id\x18\a \x01(\tR\bpluginId\x12\x1f\n" +
	"\vplugin_name\x18\b \x01(\tR\n" +
	"pluginName*S\n" +
	"\tActorType\x12\x1a\n" +
	"\x16ACTOR_TYPE_UNSPECIFIED\x10\x00\x12\x13\n" +
	"\x0fACTOR_TYPE_USER\x10\x01\x12\x15\n" +
	"\x11ACTOR_TYPE_SYSTEM\x10\x02*\xef\x05\n" +
	"\fResourceType\x12\x1d\n" +
	"\x19RESOURCE_TYPE_UNSPECIFIED\x10\x00\x12\x16\n" +
	"\x12RESOURCE_TYPE_USER\x10\x01\x12\x1e\n" +
	"\x1aRESOURCE_TYPE_ORGANIZATION\x10\x02\x12%\n" +
	"!RESOURCE_TYPE_ORGANIZATION_MEMBER\x10\x03\x12(\n" +
	"$RESOURCE_TYPE_ORGANIZATION_IDP_GROUP\x10\t\x12\x1c\n" +
	"\x18RESOURCE_TYPE_REPOSITORY\x10\x04\x12(\n" +
	"$RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR\x10\x05\x12#\n" +
	"\x1fRESOURCE_TYPE_REPOSITORY_COMMIT\x10\x06\x12&\n" +
	"\"RESOURCE_TYPE_REPOSITORY_IDP_GROUP\x10\x12\x12\x18\n" +
	"\x14RESOURCE_TYPE_POLICY\x10\x11\x12\x1f\n" +
	"\x1bRESOURCE_TYPE_POLICY_COMMIT\x10\x13\x12\x1e\n" +
	"\x1aRESOURCE_TYPE_POLICY_LABEL\x10\x14\x12\x18\n" +
	"\x14RESOURCE_TYPE_PLUGIN\x10\a\x12\x1f\n" +
	"\x1bRESOURCE_TYPE_PLUGIN_COMMIT\x10\x0f\x12 \n" +
	"\x1cRESOURCE_TYPE_CURATED_PLUGIN\x10\b\x12\x17\n" +
	"\x13RESOURCE_TYPE_TOKEN\x10\n" +
	"\x12\x1c\n" +
	"\x18RESOURCE_TYPE_SCIM_TOKEN\x10\v\x12\"\n" +
	"\x1eRESOURCE_TYPE_REPOSITORY_LABEL\x10\f\x12\x18\n" +
	"\x14RESOURCE_TYPE_SERVER\x10\r\x12,\n" +
	"(RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT\x10\x0e\x12\x1e\n" +
	"\x1aRESOURCE_TYPE_PLUGIN_LABEL\x10\x10\x12'\n" +
	"#RESOURCE_TYPE_SDK_PLUGIN_CONSTRAINT\x10\x15*\xd0\x17\n" +
	"\tEventType\x12\x1a\n" +
	"\x16EVENT_TYPE_UNSPECIFIED\x10\x00\x12#\n" +
	"\x1fEVENT_TYPE_ORGANIZATION_CREATED\x10\x01\x12#\n" +
	"\x1fEVENT_TYPE_ORGANIZATION_DELETED\x10\x02\x12(\n" +
	"$EVENT_TYPE_ORGANIZATION_MEMBER_ADDED\x10\x03\x123\n" +
	"+EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED\x10\x04\x1a\x02\b\x01\x120\n" +
	",EVENT_TYPE_ORGANIZATION_MEMBER_ROLES_CHANGED\x102\x12*\n" +
	"&EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED\x10\x05\x12+\n" +
	"'EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED\x10\x15\x12-\n" +
	")EVENT_TYPE_ORGANIZATION_IDP_GROUP_UPDATED\x10;\x12-\n" +
	")EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED\x10\x16\x12!\n" +
	"\x1dEVENT_TYPE_REPOSITORY_CREATED\x10\x06\x12$\n" +
	" EVENT_TYPE_REPOSITORY_DEPRECATED\x100\x12&\n" +
	"\"EVENT_TYPE_REPOSITORY_UNDEPRECATED\x101\x12!\n" +
	"\x1dEVENT_TYPE_REPOSITORY_DELETED\x10\a\x12'\n" +
	"#EVENT_TYPE_REPOSITORY_COMMIT_PUSHED\x10\b\x12+\n" +
	"'EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED\x10\t\x122\n" +
	".EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED\x10\n" +
	"\x123\n" +
	"/EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLES_CHANGED\x10?\x12-\n" +
	")EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED\x10\v\x12,\n" +
	"(EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED\x10\f\x124\n" +
	"0EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED\x10(\x12)\n" +
	"%EVENT_TYPE_REPOSITORY_IDP_GROUP_ADDED\x10<\x12+\n" +
	"'EVENT_TYPE_REPOSITORY_IDP_GROUP_UPDATED\x10=\x12+\n" +
	"'EVENT_TYPE_REPOSITORY_IDP_GROUP_REMOVED\x10>\x12\x1d\n" +
	"\x19EVENT_TYPE_POLICY_CREATED\x106\x12\x1d\n" +
	"\x19EVENT_TYPE_POLICY_DELETED\x107\x12 \n" +
	"\x1cEVENT_TYPE_POLICY_DEPRECATED\x108\x12\"\n" +
	"\x1eEVENT_TYPE_POLICY_UNDEPRECATED\x109\x12(\n" +
	"$EVENT_TYPE_POLICY_VISIBILITY_CHANGED\x10:\x12#\n" +
	"\x1fEVENT_TYPE_POLICY_COMMIT_PUSHED\x10@\x12#\n" +
	"\x1fEVENT_TYPE_POLICY_LABEL_CREATED\x10A\x12!\n" +
	"\x1dEVENT_TYPE_POLICY_LABEL_MOVED\x10B\x12$\n" +
	" EVENT_TYPE_POLICY_LABEL_ARCHIVED\x10C\x12&\n" +
	"\"EVENT_TYPE_POLICY_LABEL_UNARCHIVED\x10D\x12\x1d\n" +
	"\x19EVENT_TYPE_PLUGIN_CREATED\x10\r\x12\x1d\n" +
	"\x19EVENT_TYPE_PLUGIN_DELETED\x10\x0e\x12 \n" +
	"\x1cEVENT_TYPE_PLUGIN_DEPRECATED\x103\x12\"\n" +
	"\x1eEVENT_TYPE_PLUGIN_UNDEPRECATED\x104\x12(\n" +
	"$EVENT_TYPE_PLUGIN_VISIBILITY_CHANGED\x105\x12#\n" +
	"\x1fEVENT_TYPE_PLUGIN_COMMIT_PUSHED\x10+\x12%\n" +
	"!EVENT_TYPE_CURATED_PLUGIN_CREATED\x10\x14\x12%\n" +
	"!EVENT_TYPE_CURATED_PLUGIN_DELETED\x10\x1f\x12\x1b\n" +
	"\x17EVENT_TYPE_USER_CREATED\x10\x0f\x12\x1b\n" +
	"\x17EVENT_TYPE_USER_DELETED\x10\x10\x12\x1f\n" +
	"\x1bEVENT_TYPE_USER_DEACTIVATED\x10\x11\x12\x1d\n" +
	"\x19EVENT_TYPE_USER_LOGGED_IN\x10\x12\x12\x1e\n" +
	"\x1aEVENT_TYPE_USER_LOGGED_OUT\x10\x13\x12\x1c\n" +
	"\x18EVENT_TYPE_TOKEN_CREATED\x10\x17\x12\x1c\n" +
	"\x18EVENT_TYPE_TOKEN_DELETED\x10\x18\x12\x1f\n" +
	"\x1bEVENT_TYPE_USER_REACTIVATED\x10\x19\x12!\n" +
	"\x1dEVENT_TYPE_SCIM_TOKEN_CREATED\x10\x1a\x12!\n" +
	"\x1dEVENT_TYPE_SCIM_TOKEN_DELETED\x10\x1b\x12,\n" +
	"$EVENT_TYPE_REPOSITORY_COMMIT_DELETED\x10\x1c\x1a\x02\b\x01\x12'\n" +
	"#EVENT_TYPE_REPOSITORY_LABEL_CREATED\x10\x1d\x12%\n" +
	"!EVENT_TYPE_REPOSITORY_LABEL_MOVED\x10\x1e\x12(\n" +
	"$EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED\x10&\x12*\n" +
	"&EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED\x10'\x124\n" +
	"0EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED\x10 \x125\n" +
	"1EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED\x10!\x124\n" +
	",EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED\x10\"\x1a\x02\b\x01\x12/\n" +
	"+EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED\x10#\x120\n" +
	",EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED\x10$\x12,\n" +
	"(EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP\x10%\x122\n" +
	".EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED\x10)\x120\n" +
	",EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED\x10*\x12#\n" +
	"\x1fEVENT_TYPE_PLUGIN_LABEL_CREATED\x10,\x12!\n" +
	"\x1dEVENT_TYPE_PLUGIN_LABEL_MOVED\x10-\x12$\n" +
	" EVENT_TYPE_PLUGIN_LABEL_ARCHIVED\x10.\x12&\n" +
	"\"EVENT_TYPE_PLUGIN_LABEL_UNARCHIVED\x10/\x12)\n" +
	"%EVENT_TYPE_SERVER_REVIEW_FLOW_ENABLED\x10E\x12*\n" +
	"&EVENT_TYPE_SERVER_REVIEW_FLOW_DISABLED\x10F\x12,\n" +
	"(EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_CREATED\x10G\x12,\n" +
	"(EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_UPDATED\x10H\x12,\n" +
	"(EVENT_TYPE_SDK_PLUGIN_CONSTRAINT_DELETED\x10IB\x82\x02\n" +
	"\x1ccom.buf.alpha.audit.v1alpha1B\n" +
	"EventProtoP\x01ZSgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/audit/v1alpha1;auditv1alpha1\xa2\x02\x03BAA\xaa\x02\x18Buf.Alpha.Audit.V1alpha1\xca\x02\x18Buf\\Alpha\\Audit\\V1alpha1\xe2\x02$Buf\\Alpha\\Audit\\V1alpha1\\GPBMetadata\xea\x02\x1bBuf::Alpha::Audit::V1alpha1b\x06proto3"

var file_buf_alpha_audit_v1alpha1_event_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_buf_alpha_audit_v1alpha1_event_proto_msgTypes = make([]protoimpl.MessageInfo, 79)
var file_buf_alpha_audit_v1alpha1_event_proto_goTypes = []any{
	(ActorType)(0),                                                  // 0: buf.alpha.audit.v1alpha1.ActorType
	(ResourceType)(0),                                               // 1: buf.alpha.audit.v1alpha1.ResourceType
	(EventType)(0),                                                  // 2: buf.alpha.audit.v1alpha1.EventType
	(*Actor)(nil),                                                   // 3: buf.alpha.audit.v1alpha1.Actor
	(*Resource)(nil),                                                // 4: buf.alpha.audit.v1alpha1.Resource
	(*EventMetadata)(nil),                                           // 5: buf.alpha.audit.v1alpha1.EventMetadata
	(*Event)(nil),                                                   // 6: buf.alpha.audit.v1alpha1.Event
	(*PayloadOrganizationCreated)(nil),                              // 7: buf.alpha.audit.v1alpha1.PayloadOrganizationCreated
	(*PayloadOrganizationDeleted)(nil),                              // 8: buf.alpha.audit.v1alpha1.PayloadOrganizationDeleted
	(*PayloadOrganizationMemberAdded)(nil),                          // 9: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded
	(*PayloadOrganizationMemberRoleChanged)(nil),                    // 10: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged
	(*PayloadOrganizationMemberRolesChanged)(nil),                   // 11: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged
	(*PayloadOrganizationMemberRemoved)(nil),                        // 12: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved
	(*PayloadOrganizationIDPGroupAdded)(nil),                        // 13: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupAdded
	(*PayloadOrganizationIDPGroupUpdated)(nil),                      // 14: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupUpdated
	(*PayloadOrganizationIDPGroupRemoved)(nil),                      // 15: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupRemoved
	(*PayloadRepositoryCreated)(nil),                                // 16: buf.alpha.audit.v1alpha1.PayloadRepositoryCreated
	(*PayloadRepositoryDeleted)(nil),                                // 17: buf.alpha.audit.v1alpha1.PayloadRepositoryDeleted
	(*PayloadRepositoryDeprecated)(nil),                             // 18: buf.alpha.audit.v1alpha1.PayloadRepositoryDeprecated
	(*PayloadRepositoryUndeprecated)(nil),                           // 19: buf.alpha.audit.v1alpha1.PayloadRepositoryUndeprecated
	(*PayloadRepositoryCommitPushed)(nil),                           // 20: buf.alpha.audit.v1alpha1.PayloadRepositoryCommitPushed
	(*PayloadRepositoryContributorAdded)(nil),                       // 21: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAdded
	(*PayloadRepositoryContributorRoleChanged)(nil),                 // 22: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged
	(*PayloadRepositoryContributorRolesChanged)(nil),                // 23: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged
	(*PayloadRepositoryContributorRemoved)(nil),                     // 24: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemoved
	(*PayloadRepositoryVisibilityChanged)(nil),                      // 25: buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged
	(*PayloadRepositoryDefaultLabelNameChanged)(nil),                // 26: buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultLabelNameChanged
	(*PayloadRepositoryDefaultBranchChanged)(nil),                   // 27: buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultBranchChanged
	(*PayloadRepositoryIDPGroupAdded)(nil),                          // 28: buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupAdded
	(*PayloadRepositoryIDPGroupUpdated)(nil),                        // 29: buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupUpdated
	(*PayloadRepositoryIDPGroupRemoved)(nil),                        // 30: buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupRemoved
	(*PayloadPolicyCreated)(nil),                                    // 31: buf.alpha.audit.v1alpha1.PayloadPolicyCreated
	(*PayloadPolicyDeleted)(nil),                                    // 32: buf.alpha.audit.v1alpha1.PayloadPolicyDeleted
	(*PayloadPolicyDeprecated)(nil),                                 // 33: buf.alpha.audit.v1alpha1.PayloadPolicyDeprecated
	(*PayloadPolicyUndeprecated)(nil),                               // 34: buf.alpha.audit.v1alpha1.PayloadPolicyUndeprecated
	(*PayloadPolicyVisibilityChanged)(nil),                          // 35: buf.alpha.audit.v1alpha1.PayloadPolicyVisibilityChanged
	(*PayloadPolicyCommitPushed)(nil),                               // 36: buf.alpha.audit.v1alpha1.PayloadPolicyCommitPushed
	(*PayloadPluginCreated)(nil),                                    // 37: buf.alpha.audit.v1alpha1.PayloadPluginCreated
	(*PayloadPluginDeleted)(nil),                                    // 38: buf.alpha.audit.v1alpha1.PayloadPluginDeleted
	(*PayloadPluginDeprecated)(nil),                                 // 39: buf.alpha.audit.v1alpha1.PayloadPluginDeprecated
	(*PayloadPluginUndeprecated)(nil),                               // 40: buf.alpha.audit.v1alpha1.PayloadPluginUndeprecated
	(*PayloadPluginVisibilityChanged)(nil),                          // 41: buf.alpha.audit.v1alpha1.PayloadPluginVisibilityChanged
	(*PayloadPluginCommitPushed)(nil),                               // 42: buf.alpha.audit.v1alpha1.PayloadPluginCommitPushed
	(*PayloadUserCreated)(nil),                                      // 43: buf.alpha.audit.v1alpha1.PayloadUserCreated
	(*PayloadUserReactivated)(nil),                                  // 44: buf.alpha.audit.v1alpha1.PayloadUserReactivated
	(*PayloadUserDeactivated)(nil),                                  // 45: buf.alpha.audit.v1alpha1.PayloadUserDeactivated
	(*PayloadUserDeleted)(nil),                                      // 46: buf.alpha.audit.v1alpha1.PayloadUserDeleted
	(*PayloadUserLoggedIn)(nil),                                     // 47: buf.alpha.audit.v1alpha1.PayloadUserLoggedIn
	(*PayloadUserLoggedOut)(nil),                                    // 48: buf.alpha.audit.v1alpha1.PayloadUserLoggedOut
	(*PayloadUserAutoMergedFromNewIdP)(nil),                         // 49: buf.alpha.audit.v1alpha1.PayloadUserAutoMergedFromNewIdP
	(*PayloadCuratedPluginCreated)(nil),                             // 50: buf.alpha.audit.v1alpha1.PayloadCuratedPluginCreated
	(*PayloadCuratedPluginDeleted)(nil),                             // 51: buf.alpha.audit.v1alpha1.PayloadCuratedPluginDeleted
	(*PayloadTokenCreated)(nil),                                     // 52: buf.alpha.audit.v1alpha1.PayloadTokenCreated
	(*PayloadTokenDeleted)(nil),                                     // 53: buf.alpha.audit.v1alpha1.PayloadTokenDeleted
	(*PayloadSCIMTokenCreated)(nil),                                 // 54: buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreated
	(*PayloadSCIMTokenDeleted)(nil),                                 // 55: buf.alpha.audit.v1alpha1.PayloadSCIMTokenDeleted
	(*PayloadRepositoryCommitDeleted)(nil),                          // 56: buf.alpha.audit.v1alpha1.PayloadRepositoryCommitDeleted
	(*PayloadRepositoryLabelCreated)(nil),                           // 57: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelCreated
	(*PayloadRepositoryLabelMoved)(nil),                             // 58: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelMoved
	(*PayloadRepositoryLabelArchived)(nil),                          // 59: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelArchived
	(*PayloadRepositoryLabelUnarchived)(nil),                        // 60: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelUnarchived
	(*PayloadServerBreakingChangePolicyEnabled)(nil),                // 61: buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabled
	(*PayloadServerBreakingChangePolicyDisabled)(nil),               // 62: buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyDisabled
	(*PayloadServerReviewFlowEnabled)(nil),                          // 63: buf.alpha.audit.v1alpha1.PayloadServerReviewFlowEnabled
	(*PayloadServerReviewFlowDisabled)(nil),                         // 64: buf.alpha.audit.v1alpha1.PayloadServerReviewFlowDisabled
	(*PayloadServerUniquenessPolicyEnabled)(nil),                    // 65: buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyEnabled
	(*PayloadServerUniquenessPolicyDisabled)(nil),                   // 66: buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyDisabled
	(*PayloadDeviceAuthorizationGrantApproved)(nil),                 // 67: buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantApproved
	(*PayloadDeviceAuthorizationGrantDenied)(nil),                   // 68: buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantDenied
	(*PayloadPluginLabelCreated)(nil),                               // 69: buf.alpha.audit.v1alpha1.PayloadPluginLabelCreated
	(*PayloadPluginLabelMoved)(nil),                                 // 70: buf.alpha.audit.v1alpha1.PayloadPluginLabelMoved
	(*PayloadPluginLabelArchived)(nil),                              // 71: buf.alpha.audit.v1alpha1.PayloadPluginLabelArchived
	(*PayloadPluginLabelUnarchived)(nil),                            // 72: buf.alpha.audit.v1alpha1.PayloadPluginLabelUnarchived
	(*PayloadPolicyLabelCreated)(nil),                               // 73: buf.alpha.audit.v1alpha1.PayloadPolicyLabelCreated
	(*PayloadPolicyLabelMoved)(nil),                                 // 74: buf.alpha.audit.v1alpha1.PayloadPolicyLabelMoved
	(*PayloadPolicyLabelArchived)(nil),                              // 75: buf.alpha.audit.v1alpha1.PayloadPolicyLabelArchived
	(*PayloadPolicyLabelUnarchived)(nil),                            // 76: buf.alpha.audit.v1alpha1.PayloadPolicyLabelUnarchived
	(*PayloadSDKPluginConstraintCreated)(nil),                       // 77: buf.alpha.audit.v1alpha1.PayloadSDKPluginConstraintCreated
	(*PayloadSDKPluginConstraintUpdated)(nil),                       // 78: buf.alpha.audit.v1alpha1.PayloadSDKPluginConstraintUpdated
	(*PayloadSDKPluginConstraintDeleted)(nil),                       // 79: buf.alpha.audit.v1alpha1.PayloadSDKPluginConstraintDeleted
	(*PayloadOrganizationMemberRolesChanged_OrganizationRole)(nil),  // 80: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged.OrganizationRole
	(*PayloadRepositoryContributorRolesChanged_RepositoryRole)(nil), // 81: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged.RepositoryRole
	(*timestamppb.Timestamp)(nil),                                   // 82: google.protobuf.Timestamp
	(v1alpha1.OrganizationRole)(0),                                  // 83: buf.alpha.registry.v1alpha1.OrganizationRole
	(v1alpha1.OrganizationRoleSource)(0),                            // 84: buf.alpha.registry.v1alpha1.OrganizationRoleSource
	(v1alpha1.Visibility)(0),                                        // 85: buf.alpha.registry.v1alpha1.Visibility
	(v1alpha1.RepositoryRole)(0),                                    // 86: buf.alpha.registry.v1alpha1.RepositoryRole
	(v1alpha1.BreakingChangeCategory)(0),                            // 87: buf.alpha.registry.v1alpha1.BreakingChangeCategory
	(v1alpha1.RepositoryRoleSource)(0),                              // 88: buf.alpha.registry.v1alpha1.RepositoryRoleSource
}
var file_buf_alpha_audit_v1alpha1_event_proto_depIdxs = []int32{
	0,   // 0: buf.alpha.audit.v1alpha1.Actor.type:type_name -> buf.alpha.audit.v1alpha1.ActorType
	1,   // 1: buf.alpha.audit.v1alpha1.Resource.type:type_name -> buf.alpha.audit.v1alpha1.ResourceType
	2,   // 2: buf.alpha.audit.v1alpha1.Event.type:type_name -> buf.alpha.audit.v1alpha1.EventType
	3,   // 3: buf.alpha.audit.v1alpha1.Event.actor:type_name -> buf.alpha.audit.v1alpha1.Actor
	4,   // 4: buf.alpha.audit.v1alpha1.Event.resource:type_name -> buf.alpha.audit.v1alpha1.Resource
	82,  // 5: buf.alpha.audit.v1alpha1.Event.event_time:type_name -> google.protobuf.Timestamp
	5,   // 6: buf.alpha.audit.v1alpha1.Event.metadata:type_name -> buf.alpha.audit.v1alpha1.EventMetadata
	7,   // 7: buf.alpha.audit.v1alpha1.Event.organization_created:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationCreated
	8,   // 8: buf.alpha.audit.v1alpha1.Event.organization_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationDeleted
	9,   // 9: buf.alpha.audit.v1alpha1.Event.organization_member_added:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded
	10,  // 10: buf.alpha.audit.v1alpha1.Event.organization_member_role_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged
	11,  // 11: buf.alpha.audit.v1alpha1.Event.organization_member_roles_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged
	12,  // 12: buf.alpha.audit.v1alpha1.Event.organization_member_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved
	16,  // 13: buf.alpha.audit.v1alpha1.Event.repository_created:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryCreated
	18,  // 14: buf.alpha.audit.v1alpha1.Event.repository_deprecated:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDeprecated
	19,  // 15: buf.alpha.audit.v1alpha1.Event.repository_undeprecated:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryUndeprecated
	17,  // 16: buf.alpha.audit.v1alpha1.Event.repository_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDeleted
	20,  // 17: buf.alpha.audit.v1alpha1.Event.repository_commit_pushed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryCommitPushed
	21,  // 18: buf.alpha.audit.v1alpha1.Event.repository_contributor_added:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAdded
	22,  // 19: buf.alpha.audit.v1alpha1.Event.repository_contributor_role_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged
	23,  // 20: buf.alpha.audit.v1alpha1.Event.repository_contributor_roles_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged
	24,  // 21: buf.alpha.audit.v1alpha1.Event.repository_contributor_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemoved
	25,  // 22: buf.alpha.audit.v1alpha1.Event.repository_visibility_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged
	26,  // 23: buf.alpha.audit.v1alpha1.Event.repository_default_label_name_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultLabelNameChanged
	28,  // 24: buf.alpha.audit.v1alpha1.Event.repository_idp_group_added:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupAdded
	29,  // 25: buf.alpha.audit.v1alpha1.Event.repository_idp_group_updated:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupUpdated
	30,  // 26: buf.alpha.audit.v1alpha1.Event.repository_idp_group_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupRemoved
	31,  // 27: buf.alpha.audit.v1alpha1.Event.policy_created:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyCreated
	32,  // 28: buf.alpha.audit.v1alpha1.Event.policy_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyDeleted
	33,  // 29: buf.alpha.audit.v1alpha1.Event.policy_deprecated:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyDeprecated
	34,  // 30: buf.alpha.audit.v1alpha1.Event.policy_undeprecated:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyUndeprecated
	35,  // 31: buf.alpha.audit.v1alpha1.Event.policy_visibility_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyVisibilityChanged
	36,  // 32: buf.alpha.audit.v1alpha1.Event.policy_commit_pushed:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyCommitPushed
	73,  // 33: buf.alpha.audit.v1alpha1.Event.policy_label_created:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyLabelCreated
	74,  // 34: buf.alpha.audit.v1alpha1.Event.policy_label_moved:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyLabelMoved
	75,  // 35: buf.alpha.audit.v1alpha1.Event.policy_label_archived:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyLabelArchived
	76,  // 36: buf.alpha.audit.v1alpha1.Event.policy_label_unarchived:type_name -> buf.alpha.audit.v1alpha1.PayloadPolicyLabelUnarchived
	37,  // 37: buf.alpha.audit.v1alpha1.Event.plugin_created:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginCreated
	38,  // 38: buf.alpha.audit.v1alpha1.Event.plugin_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginDeleted
	39,  // 39: buf.alpha.audit.v1alpha1.Event.plugin_deprecated:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginDeprecated
	40,  // 40: buf.alpha.audit.v1alpha1.Event.plugin_undeprecated:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginUndeprecated
	41,  // 41: buf.alpha.audit.v1alpha1.Event.plugin_visibility_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginVisibilityChanged
	42,  // 42: buf.alpha.audit.v1alpha1.Event.plugin_commit_pushed:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginCommitPushed
	43,  // 43: buf.alpha.audit.v1alpha1.Event.user_created:type_name -> buf.alpha.audit.v1alpha1.PayloadUserCreated
	45,  // 44: buf.alpha.audit.v1alpha1.Event.user_deactivated:type_name -> buf.alpha.audit.v1alpha1.PayloadUserDeactivated
	46,  // 45: buf.alpha.audit.v1alpha1.Event.user_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadUserDeleted
	47,  // 46: buf.alpha.audit.v1alpha1.Event.user_logged_in:type_name -> buf.alpha.audit.v1alpha1.PayloadUserLoggedIn
	48,  // 47: buf.alpha.audit.v1alpha1.Event.user_logged_out:type_name -> buf.alpha.audit.v1alpha1.PayloadUserLoggedOut
	50,  // 48: buf.alpha.audit.v1alpha1.Event.curated_plugin_created:type_name -> buf.alpha.audit.v1alpha1.PayloadCuratedPluginCreated
	13,  // 49: buf.alpha.audit.v1alpha1.Event.idp_group_added:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupAdded
	14,  // 50: buf.alpha.audit.v1alpha1.Event.idp_group_updated:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupUpdated
	15,  // 51: buf.alpha.audit.v1alpha1.Event.idp_group_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupRemoved
	52,  // 52: buf.alpha.audit.v1alpha1.Event.token_created:type_name -> buf.alpha.audit.v1alpha1.PayloadTokenCreated
	53,  // 53: buf.alpha.audit.v1alpha1.Event.token_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadTokenDeleted
	44,  // 54: buf.alpha.audit.v1alpha1.Event.user_reactivated:type_name -> buf.alpha.audit.v1alpha1.PayloadUserReactivated
	54,  // 55: buf.alpha.audit.v1alpha1.Event.scim_token_created:type_name -> buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreated
	55,  // 56: buf.alpha.audit.v1alpha1.Event.scim_token_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadSCIMTokenDeleted
	56,  // 57: buf.alpha.audit.v1alpha1.Event.repository_commit_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryCommitDeleted
	57,  // 58: buf.alpha.audit.v1alpha1.Event.repository_label_created:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelCreated
	58,  // 59: buf.alpha.audit.v1alpha1.Event.repository_label_moved:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelMoved
	59,  // 60: buf.alpha.audit.v1alpha1.Event.repository_label_archived:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelArchived
	60,  // 61: buf.alpha.audit.v1alpha1.Event.repository_label_unarchived:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelUnarchived
	51,  // 62: buf.alpha.audit.v1alpha1.Event.curated_plugin_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadCuratedPluginDeleted
	61,  // 63: buf.alpha.audit.v1alpha1.Event.payload_server_breaking_change_policy_enabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabled
	62,  // 64: buf.alpha.audit.v1alpha1.Event.payload_server_breaking_change_policy_disabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyDisabled
	27,  // 65: buf.alpha.audit.v1alpha1.Event.repository_default_branch_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultBranchChanged
	65,  // 66: buf.alpha.audit.v1alpha1.Event.payload_server_uniqueness_policy_enabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyEnabled
	66,  // 67: buf.alpha.audit.v1alpha1.Event.payload_server_uniqueness_policy_disabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyDisabled
	49,  // 68: buf.alpha.audit.v1alpha1.Event.user_auto_merged_from_new_idp:type_name -> buf.alpha.audit.v1alpha1.PayloadUserAutoMergedFromNewIdP
	67,  // 69: buf.alpha.audit.v1alpha1.Event.device_authorization_grant_approved:type_name -> buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantApproved
	68,  // 70: buf.alpha.audit.v1alpha1.Event.device_authorization_grant_denied:type_name -> buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantDenied
	69,  // 71: buf.alpha.audit.v1alpha1.Event.plugin_label_created:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginLabelCreated
	70,  // 72: buf.alpha.audit.v1alpha1.Event.plugin_label_moved:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginLabelMoved
	71,  // 73: buf.alpha.audit.v1alpha1.Event.plugin_label_archived:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginLabelArchived
	72,  // 74: buf.alpha.audit.v1alpha1.Event.plugin_label_unarchived:type_name -> buf.alpha.audit.v1alpha1.PayloadPluginLabelUnarchived
	63,  // 75: buf.alpha.audit.v1alpha1.Event.server_review_flow_enabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerReviewFlowEnabled
	64,  // 76: buf.alpha.audit.v1alpha1.Event.server_review_flow_disabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerReviewFlowDisabled
	77,  // 77: buf.alpha.audit.v1alpha1.Event.sdk_plugin_constraint_created:type_name -> buf.alpha.audit.v1alpha1.PayloadSDKPluginConstraintCreated
	78,  // 78: buf.alpha.audit.v1alpha1.Event.sdk_plugin_constraint_updated:type_name -> buf.alpha.audit.v1alpha1.PayloadSDKPluginConstraintUpdated
	79,  // 79: buf.alpha.audit.v1alpha1.Event.sdk_plugin_constraint_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadSDKPluginConstraintDeleted
	83,  // 80: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded.member_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	84,  // 81: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded.member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	83,  // 82: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.old_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	83,  // 83: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.new_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	84,  // 84: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.old_member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	84,  // 85: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.new_member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	80,  // 86: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged.old_roles:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged.OrganizationRole
	80,  // 87: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged.new_roles:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged.OrganizationRole
	83,  // 88: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved.member_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	84,  // 89: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved.member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	83,  // 90: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupAdded.role_override:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	83,  // 91: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupUpdated.old_role_override:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	83,  // 92: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupUpdated.new_role_override:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	83,  // 93: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupRemoved.role_override:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	85,  // 94: buf.alpha.audit.v1alpha1.PayloadRepositoryCreated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 95: buf.alpha.audit.v1alpha1.PayloadRepositoryDeleted.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 96: buf.alpha.audit.v1alpha1.PayloadRepositoryDeprecated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 97: buf.alpha.audit.v1alpha1.PayloadRepositoryUndeprecated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	86,  // 98: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAdded.contributor_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	86,  // 99: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged.old_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	86,  // 100: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged.new_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	81,  // 101: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged.old_roles:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged.RepositoryRole
	81,  // 102: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged.new_roles:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged.RepositoryRole
	86,  // 103: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemoved.contributor_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	85,  // 104: buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged.old_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 105: buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged.new_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	86,  // 106: buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupAdded.role_override:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	86,  // 107: buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupUpdated.old_role_override:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	86,  // 108: buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupUpdated.new_role_override:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	86,  // 109: buf.alpha.audit.v1alpha1.PayloadRepositoryIDPGroupRemoved.role_override:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	85,  // 110: buf.alpha.audit.v1alpha1.PayloadPolicyCreated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 111: buf.alpha.audit.v1alpha1.PayloadPolicyDeleted.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 112: buf.alpha.audit.v1alpha1.PayloadPolicyDeprecated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 113: buf.alpha.audit.v1alpha1.PayloadPolicyUndeprecated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 114: buf.alpha.audit.v1alpha1.PayloadPolicyVisibilityChanged.old_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 115: buf.alpha.audit.v1alpha1.PayloadPolicyVisibilityChanged.new_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 116: buf.alpha.audit.v1alpha1.PayloadPluginCreated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 117: buf.alpha.audit.v1alpha1.PayloadPluginDeleted.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 118: buf.alpha.audit.v1alpha1.PayloadPluginDeprecated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 119: buf.alpha.audit.v1alpha1.PayloadPluginUndeprecated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 120: buf.alpha.audit.v1alpha1.PayloadPluginVisibilityChanged.old_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	85,  // 121: buf.alpha.audit.v1alpha1.PayloadPluginVisibilityChanged.new_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	82,  // 122: buf.alpha.audit.v1alpha1.PayloadTokenCreated.token_expiry_time:type_name -> google.protobuf.Timestamp
	82,  // 123: buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreated.token_expiry_time:type_name -> google.protobuf.Timestamp
	87,  // 124: buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabled.category:type_name -> buf.alpha.registry.v1alpha1.BreakingChangeCategory
	83,  // 125: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged.OrganizationRole.role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	84,  // 126: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRolesChanged.OrganizationRole.source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	86,  // 127: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged.RepositoryRole.role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	88,  // 128: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRolesChanged.RepositoryRole.source:type_name -> buf.alpha.registry.v1alpha1.RepositoryRoleSource
	129, // [129:129] is the sub-list for method output_type
	129, // [129:129] is the sub-list for method input_type
	129, // [129:129] is the sub-list for extension type_name
	129, // [129:129] is the sub-list for extension extendee
	0,   // [0:129] is the sub-list for field type_name
}

func init() { file_buf_alpha_audit_v1alpha1_event_proto_init() }
func file_buf_alpha_audit_v1alpha1_event_proto_init() {
	if File_buf_alpha_audit_v1alpha1_event_proto != nil {
		return
	}
	file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3].OneofWrappers = []any{
		(*event_OrganizationCreated)(nil),
		(*event_OrganizationDeleted)(nil),
		(*event_OrganizationMemberAdded)(nil),
		(*event_OrganizationMemberRoleChanged)(nil),
		(*event_OrganizationMemberRolesChanged)(nil),
		(*event_OrganizationMemberRemoved)(nil),
		(*event_RepositoryCreated)(nil),
		(*event_RepositoryDeprecated)(nil),
		(*event_RepositoryUndeprecated)(nil),
		(*event_RepositoryDeleted)(nil),
		(*event_RepositoryCommitPushed)(nil),
		(*event_RepositoryContributorAdded)(nil),
		(*event_RepositoryContributorRoleChanged)(nil),
		(*event_RepositoryContributorRolesChanged)(nil),
		(*event_RepositoryContributorRemoved)(nil),
		(*event_RepositoryVisibilityChanged)(nil),
		(*event_RepositoryDefaultLabelNameChanged)(nil),
		(*event_RepositoryIdpGroupAdded)(nil),
		(*event_RepositoryIdpGroupUpdated)(nil),
		(*event_RepositoryIdpGroupRemoved)(nil),
		(*event_PolicyCreated)(nil),
		(*event_PolicyDeleted)(nil),
		(*event_PolicyDeprecated)(nil),
		(*event_PolicyUndeprecated)(nil),
		(*event_PolicyVisibilityChanged)(nil),
		(*event_PolicyCommitPushed)(nil),
		(*event_PolicyLabelCreated)(nil),
		(*event_PolicyLabelMoved)(nil),
		(*event_PolicyLabelArchived)(nil),
		(*event_PolicyLabelUnarchived)(nil),
		(*event_PluginCreated)(nil),
		(*event_PluginDeleted)(nil),
		(*event_PluginDeprecated)(nil),
		(*event_PluginUndeprecated)(nil),
		(*event_PluginVisibilityChanged)(nil),
		(*event_PluginCommitPushed)(nil),
		(*event_UserCreated)(nil),
		(*event_UserDeactivated)(nil),
		(*event_UserDeleted)(nil),
		(*event_UserLoggedIn)(nil),
		(*event_UserLoggedOut)(nil),
		(*event_CuratedPluginCreated)(nil),
		(*event_IdpGroupAdded)(nil),
		(*event_IdpGroupUpdated)(nil),
		(*event_IdpGroupRemoved)(nil),
		(*event_TokenCreated)(nil),
		(*event_TokenDeleted)(nil),
		(*event_UserReactivated)(nil),
		(*event_ScimTokenCreated)(nil),
		(*event_ScimTokenDeleted)(nil),
		(*event_RepositoryCommitDeleted)(nil),
		(*event_RepositoryLabelCreated)(nil),
		(*event_RepositoryLabelMoved)(nil),
		(*event_RepositoryLabelArchived)(nil),
		(*event_RepositoryLabelUnarchived)(nil),
		(*event_CuratedPluginDeleted)(nil),
		(*event_PayloadServerBreakingChangePolicyEnabled)(nil),
		(*event_PayloadServerBreakingChangePolicyDisabled)(nil),
		(*event_RepositoryDefaultBranchChanged)(nil),
		(*event_PayloadServerUniquenessPolicyEnabled)(nil),
		(*event_PayloadServerUniquenessPolicyDisabled)(nil),
		(*event_UserAutoMergedFromNewIdp)(nil),
		(*event_DeviceAuthorizationGrantApproved)(nil),
		(*event_DeviceAuthorizationGrantDenied)(nil),
		(*event_PluginLabelCreated)(nil),
		(*event_PluginLabelMoved)(nil),
		(*event_PluginLabelArchived)(nil),
		(*event_PluginLabelUnarchived)(nil),
		(*event_ServerReviewFlowEnabled)(nil),
		(*event_ServerReviewFlowDisabled)(nil),
		(*event_SdkPluginConstraintCreated)(nil),
		(*event_SdkPluginConstraintUpdated)(nil),
		(*event_SdkPluginConstraintDeleted)(nil),
	}
	file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[58].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_audit_v1alpha1_event_proto_rawDesc), len(file_buf_alpha_audit_v1alpha1_event_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   79,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_alpha_audit_v1alpha1_event_proto_goTypes,
		DependencyIndexes: file_buf_alpha_audit_v1alpha1_event_proto_depIdxs,
		EnumInfos:         file_buf_alpha_audit_v1alpha1_event_proto_enumTypes,
		MessageInfos:      file_buf_alpha_audit_v1alpha1_event_proto_msgTypes,
	}.Build()
	File_buf_alpha_audit_v1alpha1_event_proto = out.File
	file_buf_alpha_audit_v1alpha1_event_proto_goTypes = nil
	file_buf_alpha_audit_v1alpha1_event_proto_depIdxs = nil
}
