// Code generated by smithy-go-codegen DO NOT EDIT.

package workspacesinstances

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/workspacesinstances/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a collection of WorkSpaces Instances based on specified filters.
func (c *Client) ListWorkspaceInstances(ctx context.Context, params *ListWorkspaceInstancesInput, optFns ...func(*Options)) (*ListWorkspaceInstancesOutput, error) {
	if params == nil {
		params = &ListWorkspaceInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListWorkspaceInstances", params, optFns, c.addOperationListWorkspaceInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListWorkspaceInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Defines filters and pagination parameters for retrieving WorkSpaces Instances.
type ListWorkspaceInstancesInput struct {

	// Maximum number of WorkSpaces Instances to return in a single response.
	MaxResults *int32

	// Pagination token for retrieving subsequent pages of WorkSpaces Instances.
	NextToken *string

	// Filter WorkSpaces Instances by their current provisioning states.
	ProvisionStates []types.ProvisionStateEnum

	noSmithyDocumentSerde
}

// Contains the list of WorkSpaces Instances matching the specified criteria.
type ListWorkspaceInstancesOutput struct {

	// Collection of WorkSpaces Instances returned by the query.
	//
	// This member is required.
	WorkspaceInstances []types.WorkspaceInstance

	// Token for retrieving additional WorkSpaces Instances if the result set is
	// paginated.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListWorkspaceInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListWorkspaceInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListWorkspaceInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListWorkspaceInstances"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListWorkspaceInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListWorkspaceInstancesPaginatorOptions is the paginator options for
// ListWorkspaceInstances
type ListWorkspaceInstancesPaginatorOptions struct {
	// Maximum number of WorkSpaces Instances to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListWorkspaceInstancesPaginator is a paginator for ListWorkspaceInstances
type ListWorkspaceInstancesPaginator struct {
	options   ListWorkspaceInstancesPaginatorOptions
	client    ListWorkspaceInstancesAPIClient
	params    *ListWorkspaceInstancesInput
	nextToken *string
	firstPage bool
}

// NewListWorkspaceInstancesPaginator returns a new ListWorkspaceInstancesPaginator
func NewListWorkspaceInstancesPaginator(client ListWorkspaceInstancesAPIClient, params *ListWorkspaceInstancesInput, optFns ...func(*ListWorkspaceInstancesPaginatorOptions)) *ListWorkspaceInstancesPaginator {
	if params == nil {
		params = &ListWorkspaceInstancesInput{}
	}

	options := ListWorkspaceInstancesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListWorkspaceInstancesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListWorkspaceInstancesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListWorkspaceInstances page.
func (p *ListWorkspaceInstancesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListWorkspaceInstancesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListWorkspaceInstances(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListWorkspaceInstancesAPIClient is a client that implements the
// ListWorkspaceInstances operation.
type ListWorkspaceInstancesAPIClient interface {
	ListWorkspaceInstances(context.Context, *ListWorkspaceInstancesInput, ...func(*Options)) (*ListWorkspaceInstancesOutput, error)
}

var _ ListWorkspaceInstancesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListWorkspaceInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListWorkspaceInstances",
	}
}
